@extends('admin.layouts.app')

@section('title', 'مدیریت انواع امکانات')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت انواع امکانات</h1>
        <a href="{{ route('admin.amenity-types.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50 ml-2"></i> افزودن نوع امکان جدید
        </a>
    </div>

    <!-- Content Row -->
    <div class="row">
        <div class="col-xl-12 col-md-12 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">لیست انواع امکانات</h6>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>کلید</th>
                                    <th>نام</th>
                                    <th>بخش</th>
                                    <th>ترتیب نمایش</th>
                                    <th width="200">عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($amenityTypes as $index => $type)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $type->type_key }}</td>
                                    <td>{{ $type->type_name }}</td>
                                    <td>
                                        @if($type->type_section == 'key_info')
                                            <span class="badge" style="background-color: #cfe2ff; color: #084298;">اطلاعات کلیدی</span>
                                        @elseif($type->type_section == 'room_feature')
                                            <span class="badge" style="background-color: #d1e7dd; color: #0f5132;">ویژگی اتاق</span>
                                        @elseif($type->type_section == 'hotel_facility')
                                            <span class="badge" style="background-color: #cff4fc; color: #055160;">امکانات هتل</span>
                                        @else
                                            <span class="badge" style="background-color: #e2e3e5; color: #41464b;">{{ $type->type_section }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $type->display_order ?? '-' }}</td>
                                    <td>
                                        <a href="{{ route('admin.amenity-types.edit', $type->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i> ویرایش
                                        </a>
                                        <form action="{{ route('admin.amenity-types.destroy', $type->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این مورد اطمینان دارید؟')">
                                                <i class="fas fa-trash"></i> حذف
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">هیچ نوع امکانی یافت نشد</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $amenityTypes->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize DataTable if needed
        if ($.fn.dataTable) {
            $('#dataTable').DataTable({
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json"
                },
                "paging": false,
                "searching": true,
                "ordering": true,
                "info": false,
            });
        }
    });
</script>
@endsection 