@extends('admin.layouts.app')

@section('title', 'ویرایش تبلیغ')

@section('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">
<style>
    .preview-image {
        max-width: 100%;
        max-height: 200px;
        margin-top: 10px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <h1 class="page-title">ویرایش تبلیغ</h1>
    
    <div class="card">
        <div class="card-header">
            <h5 class="m-0">اطلاعات تبلیغ</h5>
        </div>
        <div class="card-body">
            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <form action="{{ route('admin.advertisements.update', $advertisement->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title">عنوان تبلیغ <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $advertisement->title) }}" required>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="ad_type">نوع تبلیغ <span class="text-danger">*</span></label>
                            <select class="form-control" id="ad_type" name="ad_type" required>
                                <option value="">انتخاب کنید</option>
                                @foreach($adTypes as $key => $value)
                                    <option value="{{ $key }}" {{ old('ad_type', $advertisement->ad_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="position">موقعیت نمایش <span class="text-danger">*</span></label>
                            <select class="form-control" id="position" name="position" required>
                                <option value="">انتخاب کنید</option>
                                @foreach($positions as $key => $value)
                                    <option value="{{ $key }}" {{ old('position', $advertisement->position) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="image">تصویر تبلیغ</label>
                            <input type="file" class="form-control" id="image" name="image" accept="image/*" onchange="previewImage(this)">
                            <small class="form-text text-muted">فرمت‌های مجاز: JPG، PNG، GIF (حداکثر سایز: 2MB)</small>
                            @if($advertisement->image_path)
                                <div class="mt-2">
                                    <p>تصویر فعلی:</p>
                                    <img src="{{ asset('storage/' . $advertisement->image_path) }}" alt="{{ $advertisement->title }}" class="preview-image">
                                </div>
                            @endif
                            <img id="preview" src="#" alt="پیش نمایش تصویر" class="preview-image" style="display: none;">
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="target_url">لینک مقصد</label>
                            <input type="url" class="form-control" id="target_url" name="target_url" value="{{ old('target_url', $advertisement->target_url) }}" placeholder="https://example.com">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="html_content">محتوای HTML (اختیاری)</label>
                            <textarea class="form-control" id="html_content" name="html_content" rows="5">{{ old('html_content', $advertisement->html_content) }}</textarea>
                            <small class="form-text text-muted">فقط برای تبلیغات نوع HTML</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="start_date">تاریخ شروع <span class="text-danger">*</span></label>
                            <input type="text" class="form-control date-picker" id="start_date" name="start_date" value="{{ old('start_date', $advertisement->start_date ? $advertisement->start_date->format('Y-m-d') : '') }}" required>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="end_date">تاریخ پایان</label>
                            <input type="text" class="form-control date-picker" id="end_date" name="end_date" value="{{ old('end_date', $advertisement->end_date ? $advertisement->end_date->format('Y-m-d') : '') }}">
                            <small class="form-text text-muted">در صورت خالی بودن، نامحدود خواهد بود</small>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="display_order">ترتیب نمایش</label>
                            <input type="number" class="form-control" id="display_order" name="display_order" value="{{ old('display_order', $advertisement->display_order) }}" min="0">
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="speed">سرعت حرکت (ثانیه)</label>
                            <input type="number" class="form-control" id="speed" name="speed" 
                                value="{{ old('speed', $advertisement->speed ?? 20) }}" min="5" max="60" step="1">
                            <small class="form-text text-muted">سرعت حرکت متن (5 تا 60 ثانیه)</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="direction">جهت حرکت متن</label>
                            <select class="form-control" id="direction" name="direction">
                                <option value="rtl" {{ old('direction', $advertisement->direction ?? 'rtl') == 'rtl' ? 'selected' : '' }}>از راست به چپ</option>
                                <option value="ltr" {{ old('direction', $advertisement->direction) == 'ltr' ? 'selected' : '' }}>از چپ به راست</option>
                            </select>
                            <small class="form-text text-muted">جهت ورود و حرکت متن تبلیغاتی</small>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="animation_type">نوع انیمیشن</label>
                            <select class="form-control" id="animation_type" name="animation_type">
                                <option value="none" {{ old('animation_type', $advertisement->animation_type ?? 'none') == 'none' ? 'selected' : '' }}>بدون انیمیشن</option>
                                <option value="blink" {{ old('animation_type', $advertisement->animation_type) == 'blink' ? 'selected' : '' }}>چشمک زن</option>
                                <option value="fade" {{ old('animation_type', $advertisement->animation_type) == 'fade' ? 'selected' : '' }}>محو شونده</option>
                                <option value="pulse" {{ old('animation_type', $advertisement->animation_type) == 'pulse' ? 'selected' : '' }}>ضربان</option>
                                <option value="slide" {{ old('animation_type', $advertisement->animation_type) == 'slide' ? 'selected' : '' }}>لغزشی</option>
                            </select>
                            <small class="form-text text-muted">نوع جلوه متحرک برای متن تبلیغاتی</small>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="text_color">رنگ متن</label>
                            <input type="color" class="form-control" id="text_color" name="text_color" 
                                value="{{ old('text_color', $advertisement->text_color ?? '#FFC107') }}">
                            <small class="form-text text-muted">رنگ نمایش متن تبلیغاتی</small>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="size">اندازه (px)</label>
                            <input type="text" class="form-control" id="size" name="size" value="{{ old('size', $advertisement->size) }}" placeholder="مثال: 728x90">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="view_count">تعداد نمایش</label>
                            <input type="number" class="form-control" id="view_count" name="view_count" value="{{ old('view_count', $advertisement->view_count) }}" min="0">
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="click_count">تعداد کلیک</label>
                            <input type="number" class="form-control" id="click_count" name="click_count" value="{{ old('click_count', $advertisement->click_count) }}" min="0">
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="advertiser_name">نام تبلیغ دهنده</label>
                            <input type="text" class="form-control" id="advertiser_name" name="advertiser_name" value="{{ old('advertiser_name', $advertisement->advertiser_name) }}">
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="advertiser_contact">اطلاعات تماس تبلیغ دهنده</label>
                            <input type="text" class="form-control" id="advertiser_contact" name="advertiser_contact" value="{{ old('advertiser_contact', $advertisement->advertiser_contact) }}">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mt-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $advertisement->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">فعال</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save ml-1"></i>
                        بروزرسانی تبلیغ
                    </button>
                    <a href="{{ route('admin.advertisements.index') }}" class="btn btn-secondary mr-2">
                        <i class="fas fa-arrow-right ml-1"></i>
                        بازگشت
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/fa.js"></script>
<script>
    // Initialize date pickers
    flatpickr(".date-picker", {
        locale: "fa",
        dateFormat: "Y-m-d",
        enableTime: false,
        allowInput: true
    });
    
    // Preview image function
    function previewImage(input) {
        var preview = document.getElementById('preview');
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.style.display = 'block';
            }
            reader.readAsDataURL(input.files[0]);
        } else {
            preview.style.display = 'none';
        }
    }
    
    // Show/hide HTML content based on ad type
    document.getElementById('ad_type').addEventListener('change', function() {
        var htmlContentGroup = document.getElementById('html_content').closest('.form-group');
        if (this.value === 'html') {
            htmlContentGroup.style.display = 'block';
        } else {
            htmlContentGroup.style.display = 'none';
        }
    });
    
    // Trigger the change event on page load
    document.addEventListener('DOMContentLoaded', function() {
        var adTypeSelect = document.getElementById('ad_type');
        var event = new Event('change');
        adTypeSelect.dispatchEvent(event);
    });
</script>
@endsection 