@extends('admin.layouts.app')

@section('title', 'مدیریت تخصیص آگهی به زون‌ها')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت تخصیص آگهی به زون‌ها</h1>
        <button type="button" class="btn btn-primary assign-ad-btn" data-bs-toggle="modal" data-bs-target="#assignAdModal">
            <i class="fa fa-plus-circle"></i> تخصیص آگهی جدید
        </button>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <!-- نمایش زون‌ها و آگهی‌های تخصیص داده شده -->
    @foreach($zones as $zone)
        <div class="card shadow mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">مدیریت آگهی‌های زون</h5>
                <button type="button" class="btn btn-primary assign-ad-btn" data-bs-toggle="modal" data-bs-target="#assignAdModal"
                        onclick="presetZone({{ $zone->id }}, '{{ $zone->zone_name }}')">
                    <i class="fa fa-plus-circle"></i> تخصیص آگهی جدید
                </button>
            </div>
            <div class="card-body">
                @if($zone->adSettings->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>آگهی</th>
                                    <th>موقعیت جغرافیایی</th>
                                    <th>ترتیب نمایش</th>
                                    <th>تاریخ شروع</th>
                                    <th>تاریخ پایان</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($zone->adSettings as $zoneAd)
                                    <tr>
                                        <td>
                                            @if($zoneAd->ad)
                                                <div style="display: flex; align-items: center;">
                                                    @if($zoneAd->ad->image_path)
                                                        <img src="{{ $zoneAd->ad->getImageUrlAttribute() }}" alt="تصویر آگهی" style="width: 50px; height: 50px; object-fit: cover; margin-left: 10px;">
                                                    @endif
                                                    <div>
                                                        <strong>{{ $zoneAd->ad->title }}</strong>
                                                        <small class="d-block text-muted">{{ Str::limit($zoneAd->ad->description, 50) }}</small>
                                                    </div>
                                                </div>
                                            @else
                                                <span class="text-danger">آگهی حذف شده</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($zoneAd->location)
                                                {{ $zoneAd->location->title }}
                                            @else
                                                <span class="text-muted">سراسری</span>
                                            @endif
                                        </td>
                                        <td>{{ $zoneAd->display_order }}</td>
                                        <td>
                                            @if($zoneAd->start_date)
                                                {{ date('Y/m/d', strtotime($zoneAd->start_date)) }}
                                            @else
                                                <span class="text-muted">بدون محدودیت</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($zoneAd->end_date)
                                                {{ date('Y/m/d', strtotime($zoneAd->end_date)) }}
                                                @if($zoneAd->end_date < now())
                                                    <span class="badge bg-danger">منقضی شده</span>
                                                @endif
                                            @else
                                                <span class="text-muted">بدون محدودیت</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($zoneAd->is_active)
                                                <span class="badge bg-success">فعال</span>
                                            @else
                                                <span class="badge bg-danger">غیرفعال</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-info edit-zone-ad-btn" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#editZoneAdModal"
                                                    data-zone-ad-id="{{ $zoneAd->id }}"
                                                    data-display-order="{{ $zoneAd->display_order }}"
                                                    data-is-active="{{ $zoneAd->is_active }}"
                                                    data-start-date="{{ $zoneAd->start_date }}"
                                                    data-end-date="{{ $zoneAd->end_date }}">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                            
                                            <button type="button" class="btn btn-sm btn-danger delete-zone-ad-btn" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#deleteZoneAdModal"
                                                    data-zone-ad-id="{{ $zoneAd->id }}">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-center text-muted">هیچ آگهی‌ای به این زون تخصیص داده نشده است.</p>
                @endif
            </div>
        </div>
    @endforeach
</div>

<!-- Modal for Assigning Ad to Zone -->
<div class="modal fade" id="assignAdModal" tabindex="-1" aria-labelledby="assignAdModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="assignAdModalLabel">تخصیص آگهی به زون</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.ads.assign-to-zone') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="zone_id" class="form-label">انتخاب زون:</label>
                        <select name="zone_id" id="zone_id" class="form-control" required>
                            <option value="">-- انتخاب زون --</option>
                            @foreach($zones as $zone)
                                <option value="{{ $zone->id }}">{{ $zone->zone_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="ad_id" class="form-label">انتخاب آگهی:</label>
                        <select name="ad_id" id="ad_id" class="form-control" required>
                            <option value="">-- انتخاب آگهی --</option>
                            @foreach($ads as $ad)
                                <option value="{{ $ad->id }}">{{ $ad->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="location_id" class="form-label">موقعیت مکانی (اختیاری):</label>
                        <select name="location_id" id="location_id" class="form-control">
                            <option value="">-- بدون موقعیت مکانی --</option>
                            @foreach($locations as $location)
                                <option value="{{ $location->id }}">{{ $location->location_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="display_order" class="form-label">ترتیب نمایش:</label>
                        <input type="number" name="display_order" id="display_order" class="form-control" value="1" min="1">
                    </div>
                    
                    <div class="mb-3 form-check">
                        <input type="checkbox" name="is_active" id="is_active" class="form-check-input" checked>
                        <label class="form-check-label" for="is_active">فعال</label>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="start_date" class="form-label">تاریخ شروع:</label>
                                <input type="date" name="start_date" id="start_date" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="end_date" class="form-label">تاریخ پایان:</label>
                                <input type="date" name="end_date" id="end_date" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-primary">ثبت</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal for Editing Ad Settings in Zone -->
<div class="modal fade" id="editZoneAdModal" tabindex="-1" aria-labelledby="editZoneAdModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editZoneAdModalLabel">ویرایش تنظیمات آگهی در زون</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.ads.update-zone-ad') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="zone_ad_id" id="edit_zone_ad_id">
                    
                    <div class="mb-3">
                        <label for="edit_display_order" class="form-label">ترتیب نمایش:</label>
                        <input type="number" name="display_order" id="edit_display_order" class="form-control" min="1">
                    </div>
                    
                    <div class="mb-3 form-check">
                        <input type="checkbox" name="is_active" id="edit_is_active" class="form-check-input">
                        <label class="form-check-label" for="edit_is_active">فعال</label>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_start_date" class="form-label">تاریخ شروع:</label>
                                <input type="date" name="start_date" id="edit_start_date" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_end_date" class="form-label">تاریخ پایان:</label>
                                <input type="date" name="end_date" id="edit_end_date" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal for Deleting Ad from Zone -->
<div class="modal fade" id="deleteZoneAdModal" tabindex="-1" aria-labelledby="deleteZoneAdModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteZoneAdModalLabel">حذف آگهی از زون</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.ads.delete-zone-ad') }}" method="POST">
                @csrf
                @method('DELETE')
                <div class="modal-body">
                    <input type="hidden" name="zone_ad_id" id="delete_zone_ad_id">
                    <p>آیا از حذف این آگهی از زون مطمئن هستید؟</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-danger">حذف</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Handle edit zone ad modal
    $('.edit-zone-ad-btn').on('click', function() {
        const zoneAdId = $(this).data('zone-ad-id');
        const displayOrder = $(this).data('display-order');
        const isActive = $(this).data('is-active');
        const startDate = $(this).data('start-date');
        const endDate = $(this).data('end-date');
        
        $('#edit_zone_ad_id').val(zoneAdId);
        $('#edit_display_order').val(displayOrder);
        $('#edit_is_active').prop('checked', isActive == 1);
        $('#edit_start_date').val(startDate);
        $('#edit_end_date').val(endDate);
    });
    
    // Handle delete zone ad modal
    $('.delete-zone-ad-btn').on('click', function() {
        const zoneAdId = $(this).data('zone-ad-id');
        $('#delete_zone_ad_id').val(zoneAdId);
    });
    
    // Function to preset zone when adding an ad from a specific zone
    function presetZone(zoneId, zoneName) {
        $('#zone_id').val(zoneId);
    }
</script>
@endpush 