@extends('layouts.admin')

@section('title', 'اختصاص پکیج تبلیغاتی به مکان')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">اختصاص پکیج تبلیغاتی به مکان</h1>
        <a href="{{ route('admin.ads.location-ads') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-right fa-sm text-white-50"></i> بازگشت به لیست
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">فرم اختصاص پکیج</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.ads.store-assignment') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="location_id">انتخاب مکان <span class="text-danger">*</span></label>
                            <select class="form-control select2 @error('location_id') is-invalid @enderror" id="location_id" name="location_id" required>
                                <option value="">-- انتخاب مکان --</option>
                                @foreach($locations as $location)
                                    <option value="{{ $location->id }}" @if(old('location_id') == $location->id) selected @endif>
                                        {{ $location->title }} ({{ $location->category_fa }})
                                    </option>
                                @endforeach
                            </select>
                            @error('location_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="package_id">انتخاب پکیج <span class="text-danger">*</span></label>
                            <select class="form-control @error('package_id') is-invalid @enderror" id="package_id" name="package_id" required>
                                <option value="">-- انتخاب پکیج --</option>
                                @foreach($packages as $package)
                                    <option value="{{ $package->id }}" @if(old('package_id') == $package->id) selected @endif
                                        data-badge-text="{{ $package->badge_text }}"
                                        data-badge-color="{{ $package->badge_color }}"
                                        data-duration="{{ $package->duration_days }}"
                                        data-price="{{ $package->price }}">
                                        {{ $package->name }} ({{ number_format($package->price) }} ریال - {{ $package->duration_days }} روز)
                                    </option>
                                @endforeach
                            </select>
                            @error('package_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="start_date">تاریخ شروع <span class="text-danger">*</span></label>
                            <input type="date" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date', date('Y-m-d')) }}" required>
                            @error('start_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="end_date">تاریخ پایان</label>
                            <input type="date" class="form-control @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date') }}">
                            @error('end_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">اگر خالی بماند، بر اساس مدت پکیج محاسبه می‌شود</small>
                        </div>
                    </div>
                </div>
                
                <hr>
                <h5>محدوده نمایش</h5>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="geographic_scope">محدوده جغرافیایی</label>
                            <select class="form-control @error('geographic_scope') is-invalid @enderror" id="geographic_scope" name="geographic_scope">
                                <option value="">سراسری</option>
                                <option value="country" @if(old('geographic_scope') == 'country') selected @endif>کشور</option>
                                <option value="province" @if(old('geographic_scope') == 'province') selected @endif>استان</option>
                                <option value="county" @if(old('geographic_scope') == 'county') selected @endif>شهرستان</option>
                                <option value="city" @if(old('geographic_scope') == 'city') selected @endif>شهر</option>
                                <option value="zone" @if(old('geographic_scope') == 'zone') selected @endif>منطقه</option>
                            </select>
                            @error('geographic_scope')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="geo_id">شناسه منطقه جغرافیایی</label>
                            <input type="number" class="form-control @error('geo_id') is-invalid @enderror" id="geo_id" name="geo_id" value="{{ old('geo_id') }}">
                            @error('geo_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">بر اساس محدوده جغرافیایی انتخاب شده، شناسه منطقه را وارد کنید</small>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="category_id">محدوده دسته‌بندی</label>
                    <select class="form-control @error('category_id') is-invalid @enderror" id="category_id" name="category_id">
                        <option value="">همه دسته‌بندی‌ها</option>
                        @foreach(\App\Models\Category::all() as $category)
                            <option value="{{ $category->id }}" @if(old('category_id') == $category->id) selected @endif>
                                {{ $category->category_fa }}
                            </option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <hr>
                <h5>تنظیمات سفارشی</h5>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="custom_badge_text">متن سفارشی نشان</label>
                            <input type="text" class="form-control @error('custom_badge_text') is-invalid @enderror" id="custom_badge_text" name="custom_badge_text" value="{{ old('custom_badge_text') }}">
                            @error('custom_badge_text')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">اگر خالی بماند، از متن پیش‌فرض پکیج استفاده می‌شود</small>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="custom_badge_color">رنگ سفارشی نشان</label>
                            <input type="color" class="form-control @error('custom_badge_color') is-invalid @enderror" id="custom_badge_color" name="custom_badge_color" value="{{ old('custom_badge_color') }}">
                            @error('custom_badge_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">اگر خالی بماند، از رنگ پیش‌فرض پکیج استفاده می‌شود</small>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="display_priority">اولویت نمایش</label>
                    <input type="number" class="form-control @error('display_priority') is-invalid @enderror" id="display_priority" name="display_priority" value="{{ old('display_priority', 10) }}">
                    @error('display_priority')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="form-text text-muted">اولویت کوچکتر = نمایش بالاتر در گروه پکیج‌های همسان</small>
                </div>
                
                <button type="submit" class="btn btn-primary">ذخیره و تخصیص پکیج</button>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function(){
        // نمایش مقادیر پیش‌فرض پکیج انتخاب شده
        $('#package_id').change(function(){
            var selected = $(this).find('option:selected');
            $('#custom_badge_text').attr('placeholder', selected.data('badge-text'));
            $('#custom_badge_color').val(selected.data('badge-color'));
            
            // محاسبه تاریخ پایان بر اساس مدت پکیج
            if($('#start_date').val()) {
                var startDate = new Date($('#start_date').val());
                startDate.setDate(startDate.getDate() + parseInt(selected.data('duration')));
                var endDateStr = startDate.toISOString().split('T')[0];
                $('#end_date').val(endDateStr);
            }
        });
        
        // محاسبه تاریخ پایان در هنگام تغییر تاریخ شروع
        $('#start_date').change(function(){
            var selected = $('#package_id').find('option:selected');
            if(selected.val() && $(this).val()) {
                var startDate = new Date($(this).val());
                startDate.setDate(startDate.getDate() + parseInt(selected.data('duration')));
                var endDateStr = startDate.toISOString().split('T')[0];
                $('#end_date').val(endDateStr);
            }
        });
    });
</script>
@endpush
@endsection 