// تنظیمات CSRF برای تمام درخواست‌های AJAX
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

// مدیریت پیام‌های هشدار
function showAlert(message, type = 'success') {
    const alertHtml = `
        <div class="alert alert-${type} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    `;
    
    $('.alert-container').html(alertHtml);
    
    // حذف خودکار پیام بعد از 5 ثانیه
    setTimeout(() => {
        $('.alert').alert('close');
    }, 5000);
}

// مدیریت فرم‌ها
function handleFormSubmit(form, successCallback = null) {
    form.on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const url = $(this).attr('action');
        const method = $(this).attr('method') || 'POST';
        
        $.ajax({
            url: url,
            method: method,
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.message) {
                    showAlert(response.message, response.type || 'success');
                }
                
                if (successCallback) {
                    successCallback(response);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    showAlert(response.message, 'danger');
                } else {
                    showAlert('خطا در ارسال اطلاعات', 'danger');
                }
            }
        });
    });
}

// مدیریت جدول‌ها
function initializeDataTable(tableId, options = {}) {
    const defaultOptions = {
        language: {
            url: '/assets/js/datatable-persian.json'
        },
        responsive: true,
        pageLength: 10,
        order: [[0, 'desc']]
    };
    
    return $(tableId).DataTable({
        ...defaultOptions,
        ...options
    });
}

// مدیریت منو
function initializeMenu() {
    $('.main-nav a').on('click', function() {
        $('.main-nav a').removeClass('active');
        $(this).addClass('active');
    });
}

// مدیریت لودینگ
function showLoading() {
    $('.loading-overlay').fadeIn();
}

function hideLoading() {
    $('.loading-overlay').fadeOut();
}

// مدیریت مودال‌ها
function showModal(modalId) {
    const modal = new bootstrap.Modal(document.getElementById(modalId));
    modal.show();
}

function hideModal(modalId) {
    const modal = bootstrap.Modal.getInstance(document.getElementById(modalId));
    if (modal) {
        modal.hide();
    }
}

// مدیریت اسکرول
function smoothScroll(target) {
    $('html, body').animate({
        scrollTop: $(target).offset().top - 100
    }, 500);
}

// مدیریت تصاویر
function initializeImageUpload(input, preview) {
    input.on('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.attr('src', e.target.result);
            };
            reader.readAsDataURL(file);
        }
    });
}

// مدیریت تاریخ‌ها
function initializeDatePicker(input) {
    input.persianDatepicker({
        format: 'YYYY/MM/DD',
        initialValue: false,
        autoClose: true
    });
}

// مدیریت انتخاب‌ها
function initializeSelect2(select) {
    select.select2({
        dir: 'rtl',
        language: 'fa'
    });
}

// مدیریت اعتبارسنجی فرم‌ها
function initializeFormValidation(form) {
    form.validate({
        errorElement: 'span',
        errorClass: 'invalid-feedback',
        validClass: 'valid-feedback',
        rules: {
            required: {
                required: true
            },
            email: {
                required: true,
                email: true
            },
            minlength: {
                minlength: 6
            }
        },
        messages: {
            required: {
                required: 'این فیلد الزامی است'
            },
            email: {
                required: 'لطفا ایمیل خود را وارد کنید',
                email: 'لطفا یک ایمیل معتبر وارد کنید'
            },
            minlength: {
                minlength: 'حداقل 6 کاراکتر وارد کنید'
            }
        }
    });
}

// اجرای توابع در زمان لود صفحه
$(document).ready(function() {
    initializeMenu();
    
    // اعمال اعتبارسنجی روی تمام فرم‌ها
    $('form').each(function() {
        initializeFormValidation($(this));
    });
    
    // اعمال select2 روی تمام select‌ها
    $('select').each(function() {
        initializeSelect2($(this));
    });
    
    // اعمال datepicker روی تمام input‌های تاریخ
    $('input[type="date"]').each(function() {
        initializeDatePicker($(this));
    });
}); 