<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Limit;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        // اضافه کردن لاگ برای تشخیص مسیرهای API
        Log::info('RouteServiceProvider boot called');

        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        $this->routes(function () {
            // پشتیبانی از هر دو مسیر API (قدیمی و جدید)
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            // پشتیبانی از مسیر قدیمی API
            Route::middleware('api')
                ->prefix('0000/Admin/public/api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));
        });
    }
}
