<?php

namespace App\Models;

use App\Traits\HasTranslatedName;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Zone extends Model
{
    use HasFactory, SoftDeletes, HasTranslatedName;

    protected $table = 'state7_zone';

    public $timestamps = false;

    protected $fillable = [
        'city_id',
        'village_id',
        'parent_zone_id',
        'name',
        'name_en',
        'code',
        'slug',
        'global_slug',
        'zone_type',
        'area',
        'population',
        'households',
        'postal_code',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'area' => 'decimal:2',
        'population' => 'integer',
        'households' => 'integer',
        'deleted_at' => 'datetime',
    ];

    // Relationships
    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function village()
    {
        return $this->belongsTo(Village::class);
    }

    public function parentZone()
    {
        return $this->belongsTo(Zone::class, 'parent_zone_id');
    }

    public function childZones()
    {
        return $this->hasMany(Zone::class, 'parent_zone_id');
    }

    public function locations()
    {
        return $this->hasMany(Location::class);
    }

    // Make name_fa attribute for compatibility
    public function getNameFaAttribute()
    {
        return $this->name;
    }
}
