<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LocationAdPackage extends Model
{
    protected $table = 'location_ad_packages';

    protected $fillable = [
        'location_id', 'package_id', 'start_date', 'end_date', 'is_active',
        'payment_status', 'payment_amount', 'payment_date', 'payment_ref',
        'display_priority', 'geographic_scope', 'geo_id', 'category_id',
        'custom_badge_text', 'custom_badge_color',
    ];

    protected $dates = [
        'start_date', 'end_date', 'payment_date',
    ];

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function package()
    {
        return $this->belongsTo(AdPackage::class, 'package_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function getBadgeTextAttribute()
    {
        return $this->custom_badge_text ?? $this->package->badge_text;
    }

    public function getBadgeColorAttribute()
    {
        return $this->custom_badge_color ?? $this->package->badge_color;
    }

    // تابع کمکی برای دریافت نام منطقه جغرافیایی
    public function getGeographicName($lang = null)
    {
        $lang = $lang ?: app()->getLocale();
        if (! $this->geographic_scope || ! $this->geo_id) {
            return 'سراسری';
        }
        switch ($this->geographic_scope) {
            case 'country':
                $geo = \App\Models\Country::find($this->geo_id);
                return $geo ? $geo->getTranslatedName($lang) : 'نامشخص';
            case 'province':
                $geo = \App\Models\Province::find($this->geo_id);
                return $geo ? $geo->getTranslatedName($lang) : 'نامشخص';
            case 'county':
                $geo = \App\Models\County::find($this->geo_id);
                return $geo ? $geo->getTranslatedName($lang) : 'نامشخص';
            case 'city':
                $geo = \App\Models\City::find($this->geo_id);
                return $geo ? $geo->getTranslatedName($lang) : 'نامشخص';
            case 'zone':
                $geo = \App\Models\Zone::find($this->geo_id);
                return $geo ? $geo->getTranslatedName($lang) : 'نامشخص';
            default:
                return 'نامشخص';
        }
    }
}
