<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AdDisplayZone extends Model
{
    protected $table = 'ad_display_zones';

    protected $fillable = [
        'zone_key', 'zone_name', 'description', 'position',
        'max_desktop_cards', 'max_mobile_cards', 'card_layout',
        'allowed_packages', 'is_geographic_filtered', 'is_category_filtered',
        'is_active', 'display_order',
    ];

    protected $casts = [
        'allowed_packages' => 'array',
        'is_geographic_filtered' => 'boolean',
        'is_category_filtered' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function getMaxCardsAttribute()
    {
        // بر اساس دستگاه کاربر تعداد کارت‌های مناسب را برمی‌گرداند
        $agent = new \Jenssegers\Agent\Agent;

        if ($agent->isMobile()) {
            return $this->max_mobile_cards;
        }

        return $this->max_desktop_cards;
    }
}
