<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \App\Http\Middleware\RedirectOldApiPaths::class, // میدلور هدایت مسیرهای قدیمی API
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\FixCsrfToken::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \Illuminate\Http\Middleware\HandleCors::class,
            \App\Http\Middleware\CorsMiddleware::class,
            \App\Http\Middleware\SetLocale::class,
            \App\Http\Middleware\StorePreviousUrl::class,
            \App\Http\Middleware\SecureHeaders::class,
            \App\Http\Middleware\SessionTimeout::class,
            \App\Http\Middleware\CheckIpAddress::class,
            \App\Http\Middleware\CheckUserAgent::class,
            \App\Http\Middleware\CheckReferer::class,
            \App\Http\Middleware\CheckContentType::class,
            \App\Http\Middleware\CheckOrigin::class,
            \App\Http\Middleware\CheckRequestSize::class,
            \App\Http\Middleware\ConcurrentRequestsLimit::class,
            \App\Http\Middleware\SecureFileAccess::class,
            \App\Http\Middleware\SanitizeInput::class,
            \App\Http\Middleware\BruteForceProtection::class,
            \App\Http\Middleware\ClickjackingProtection::class,
            \App\Http\Middleware\ContentTypeProtection::class,
            \App\Http\Middleware\EnhancedCsrfProtection::class,
            \App\Http\Middleware\XssProtection::class,
            \App\Http\Middleware\FileUploadProtection::class,
            \App\Http\Middleware\SessionSecurity::class,
            \App\Http\Middleware\SecurityHeaders::class,
            \App\Http\Middleware\SqlInjectionProtection::class,
            \App\Http\Middleware\PathTraversalProtection::class,
            \App\Http\Middleware\CommandInjectionProtection::class,
            \App\Http\Middleware\SecuritySettingsMiddleware::class,
            \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRoutes::class,
            \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRedirectFilter::class,
            \Mcamara\LaravelLocalization\Middleware\LocaleSessionRedirect::class,
            \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationViewPath::class,
            \App\Http\Middleware\CheckMaintenanceMode::class,
        ],

        'api' => [
            // \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
            \Illuminate\Routing\Middleware\ThrottleRequests::class.':api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\ApiRequestValidator::class,
            \App\Http\Middleware\SecuritySettingsMiddleware::class,
        ],
    ];

    /**
     * The application's middleware aliases.
     *
     * Aliases may be used instead of class names to conveniently assign middleware to routes and groups.
     *
     * @var array<string, class-string|string>
     */
    protected $middlewareAliases = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'auth.session' => \Illuminate\Session\Middleware\AuthenticateSession::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \App\Http\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'admin' => \App\Http\Middleware\AdminMiddleware::class,
        'secure.headers' => \App\Http\Middleware\SecureHeaders::class,
        'session.timeout' => \App\Http\Middleware\SessionTimeout::class,
        'password.expiry' => \App\Http\Middleware\PasswordExpiry::class,
    ];
}
