-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jul 01, 2025 at 08:19 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `alu`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `UpdateLocationStatistics` (IN `location_title_id` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci)   BEGIN
    DECLARE total_ratings_count INT DEFAULT 0;
    DECLARE avg_rating DECIMAL(3,2) DEFAULT 0.00;
    DECLARE total_comments_count INT DEFAULT 0;
    DECLARE last_rating_date DATETIME DEFAULT NULL;
    DECLARE last_comment_date DATETIME DEFAULT NULL;
    
    -- محاسبه آمار امتیازات
    SELECT 
        COUNT(*),
        COALESCE(AVG(rating), 0),
        MAX(created_at)
    INTO 
        total_ratings_count,
        avg_rating,
        last_rating_date
    FROM ratings 
    WHERE title_id = location_title_id AND status = 'approved';
    
    -- محاسبه آمار نظرات
    SELECT 
        COUNT(*),
        MAX(created_at)
    INTO 
        total_comments_count,
        last_comment_date
    FROM rating_location_comments 
    WHERE title_id = location_title_id AND status = 'approved';
    
    -- به‌روزرسانی یا درج آمار
    INSERT INTO rating_statistics (
        title_id, total_ratings, average_rating, total_comments, 
        last_rating_date, last_comment_date, updated_at
    ) VALUES (
        location_title_id, total_ratings_count, avg_rating, total_comments_count,
        last_rating_date, last_comment_date, NOW()
    ) ON DUPLICATE KEY UPDATE
        total_ratings = total_ratings_count,
        average_rating = avg_rating,
        total_comments = total_comments_count,
        last_rating_date = last_rating_date,
        last_comment_date = last_comment_date,
        updated_at = NOW();
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

CREATE TABLE `admins` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `role` varchar(20) NOT NULL DEFAULT 'admin',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `password_updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `username`, `password`, `remember_token`, `name`, `email`, `avatar`, `role`, `is_active`, `last_login`, `created_at`, `updated_at`, `password_updated_at`) VALUES
(1, 'rajestary', '$2y$12$TJVYMf/WYI3lOFCuM5qJ1uqmwTv.F6FWAg6miSY8so5CEpqp9EYdy', 'YrFpNd4vPDznRRJiyD2QvsERTmXJrEJigT0683GmhrKdJCfIjPARP8fpC3Bz', 'یوسف رجستری', 'rajestary@gmail.com', 'avatars/admins/yP0R1fV9wnFXE3XU22afqbiWwXI9ZQcjRQ7PAgsh.jpg', 'admin', 1, '2025-07-01 06:09:10', '2025-04-25 10:37:48', '2025-07-01 02:39:10', NULL),
(2, 'admin', '$2y$12$rD08Q.VznYBQo1yAZw40vuieE4cLJeVMv3SICRxdZXWNWwPW.kZNu', NULL, 'مدیر سیستم', 'admin@example.com', NULL, 'super_admin', 1, NULL, '2025-05-18 18:50:32', '2025-05-18 18:50:32', NULL),
(4, 'superadmin', '$2y$12$BnKjIJdzfwzU4DIeMaAYQuiY6/GC3T6Jfjcd312FK0OGttePwAtoC', NULL, 'مدیر کل', 'superadmin@example.com', NULL, 'super_admin', 1, NULL, '2025-05-18 18:51:10', '2025-05-18 18:51:10', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `admin_password_histories`
--

CREATE TABLE `admin_password_histories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `admin_id` int(11) NOT NULL,
  `password` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `advertisements`
--

CREATE TABLE `advertisements` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `ad_type` varchar(255) NOT NULL COMMENT 'نوع تبلیغ: banner, featured, popup, sidebar, etc.',
  `position` varchar(255) NOT NULL COMMENT 'موقعیت: header, sidebar, footer, content, etc.',
  `image_path` varchar(255) DEFAULT NULL,
  `html_content` text DEFAULT NULL COMMENT 'محتوای HTML برای تبلیغات خاص',
  `content_direction` varchar(3) NOT NULL DEFAULT 'rtl' COMMENT 'جهت متن محتوای HTML (rtl یا ltr)',
  `target_url` varchar(255) DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `display_order` int(11) NOT NULL DEFAULT 10,
  `speed` int(20) DEFAULT NULL,
  `direction` enum('rtl','ltr') NOT NULL DEFAULT 'rtl' COMMENT 'جهت حرکت متن تبلیغاتی',
  `animation_type` enum('none','blink','fade','pulse','slide') NOT NULL DEFAULT 'none' COMMENT 'نوع انیمیشن متن تبلیغاتی',
  `text_color` varchar(20) NOT NULL DEFAULT '#FFC107' COMMENT 'رنگ متن تبلیغاتی',
  `view_count` int(11) NOT NULL DEFAULT 0,
  `click_count` int(11) NOT NULL DEFAULT 0,
  `size` varchar(255) DEFAULT NULL COMMENT 'سایز تبلیغ (px)',
  `advertiser_name` varchar(255) DEFAULT NULL,
  `advertiser_contact` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `target_regions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'منطقه‌های هدف (JSON)' CHECK (json_valid(`target_regions`)),
  `target_categories` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'دسته‌بندی‌های هدف (JSON)' CHECK (json_valid(`target_categories`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `advertisements`
--

INSERT INTO `advertisements` (`id`, `title`, `ad_type`, `position`, `image_path`, `html_content`, `content_direction`, `target_url`, `start_date`, `end_date`, `is_active`, `display_order`, `speed`, `direction`, `animation_type`, `text_color`, `view_count`, `click_count`, `size`, `advertiser_name`, `advertiser_contact`, `created_at`, `updated_at`, `target_regions`, `target_categories`) VALUES
(3, 'در الو ایران، کشف کنید، دیده شوید و رشد کنید! کسب‌وکارها و جاذبه‌های برتر ایران، همه در یکجا', 'text', 'text_ticker', NULL, NULL, 'rtl', NULL, '2025-04-01 00:00:00', NULL, 0, 1, 30, 'ltr', 'none', '#FFC107', 0, 0, NULL, NULL, NULL, '2025-04-27 10:50:38', '2025-04-27 11:51:49', NULL, NULL),
(4, 'در الو ایران، دنیایی از خدمات، مشاغل، جاذبه‌ها و نیازهای روزمره را کشف کنید! هر آنچه در سراسر ایران به دنبالش هستید، اینجاست.', 'text', 'header', NULL, 'در الو ایران، دنیایی از خدمات، مشاغل، جاذبه‌ها و نیازمندی‌ها را کشف کنید!', 'rtl', NULL, '2025-04-01 00:00:00', '2037-05-05 00:00:00', 0, 2, 40, 'ltr', 'none', '#ffc107', 0, 0, NULL, NULL, NULL, '2025-04-27 11:02:40', '2025-05-18 22:57:14', NULL, NULL),
(8, 'ghkjgjh', 'featured', 'homepage_featured', NULL, NULL, 'rtl', NULL, '2025-04-01 00:00:00', NULL, 0, 10, 20, 'rtl', 'none', '#ffc107', 3, 0, NULL, NULL, NULL, '2025-04-28 05:28:18', '2025-04-28 06:07:48', NULL, NULL),
(9, 'در الو ایران، دنیایی از خدمات، مشاغل، جاذبه‌ها و نیازهای روزمره را کشف کنید! هر آنچه در سراسر ایران به دنبالش هستید، اینجاست.', 'text', 'text_ticker', NULL, NULL, 'rtl', NULL, '2025-05-01 00:00:00', NULL, 1, 1, 30, 'ltr', 'none', '#ffd500', 0, 0, NULL, NULL, NULL, '2025-05-18 22:58:26', '2025-05-18 23:27:44', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ad_card_designs`
--

CREATE TABLE `ad_card_designs` (
  `id` int(11) NOT NULL,
  `design_key` varchar(50) NOT NULL COMMENT 'کلید یکتای طراحی',
  `name` varchar(100) NOT NULL COMMENT 'نام طراحی',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `css_class` varchar(100) NOT NULL COMMENT 'کلاس CSS',
  `html_template` text DEFAULT NULL COMMENT 'قالب HTML',
  `is_default` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'پیش‌فرض',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='طراحی‌های کارت‌های تبلیغاتی';

--
-- Dumping data for table `ad_card_designs`
--

INSERT INTO `ad_card_designs` (`id`, `design_key`, `name`, `description`, `css_class`, `html_template`, `is_default`, `created_at`, `updated_at`) VALUES
(1, 'standard', 'استاندارد', 'طراحی استاندارد کارت', 'card-standard', NULL, 1, '2025-04-28 07:49:44', '2025-04-28 07:49:44'),
(2, 'diamond', 'الماس', 'طراحی ویژه کارت الماس', 'card-diamond', NULL, 0, '2025-04-28 07:49:44', '2025-04-28 07:49:44'),
(3, 'gold', 'طلایی', 'طراحی کارت طلایی', 'card-gold', NULL, 0, '2025-04-28 07:49:44', '2025-04-28 07:49:44'),
(4, 'silver', 'نقره‌ای', 'طراحی کارت نقره‌ای', 'card-silver', NULL, 0, '2025-04-28 07:49:44', '2025-04-28 07:49:44'),
(5, 'bronze', 'برنزی', 'طراحی کارت برنزی', 'card-bronze', NULL, 0, '2025-04-28 07:49:44', '2025-04-28 07:49:44');

-- --------------------------------------------------------

--
-- Table structure for table `ad_display_zones`
--

CREATE TABLE `ad_display_zones` (
  `id` int(11) NOT NULL,
  `zone_key` varchar(50) NOT NULL COMMENT 'کلید یکتای ناحیه نمایش',
  `zone_name` varchar(100) NOT NULL COMMENT 'نام ناحیه نمایش',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `position` varchar(50) NOT NULL COMMENT 'موقعیت: home_top, category_sidebar, search_results, etc.',
  `max_desktop_cards` int(11) NOT NULL DEFAULT 4 COMMENT 'حداکثر تعداد کارت‌های نمایشی در دسکتاپ',
  `max_mobile_cards` int(11) NOT NULL DEFAULT 2 COMMENT 'حداکثر تعداد کارت‌های نمایشی در موبایل',
  `card_layout` varchar(50) DEFAULT 'grid' COMMENT 'چیدمان کارت‌ها: grid, carousel, list',
  `allowed_packages` text DEFAULT NULL COMMENT 'پکیج‌های مجاز (JSON آرایه کلیدهای پکیج)',
  `is_geographic_filtered` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'فیلتر بر اساس موقعیت جغرافیایی',
  `is_category_filtered` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'فیلتر بر اساس دسته‌بندی',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'وضعیت فعال',
  `display_order` int(11) NOT NULL DEFAULT 10 COMMENT 'ترتیب نمایش',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تنظیمات نمایش پکیج‌های تبلیغاتی در مناطق مختلف سایت';

--
-- Dumping data for table `ad_display_zones`
--

INSERT INTO `ad_display_zones` (`id`, `zone_key`, `zone_name`, `description`, `position`, `max_desktop_cards`, `max_mobile_cards`, `card_layout`, `allowed_packages`, `is_geographic_filtered`, `is_category_filtered`, `is_active`, `display_order`, `created_at`, `updated_at`, `created_by`) VALUES
(1, 'home_featured', 'ویژه صفحه اصلی', 'نمایش در بالای صفحه اصلی', 'home_top', 4, 2, 'carousel', '[\"diamond\"]', 0, 0, 1, 1, '2025-04-28 07:49:31', '2025-04-28 07:49:31', NULL),
(2, 'geo_featured', 'ویژه منطقه', 'نمایش بر اساس موقعیت جغرافیایی', 'geo_results', 4, 2, 'grid', '[\"gold\"]', 1, 0, 1, 2, '2025-04-28 07:49:31', '2025-04-28 07:49:31', NULL),
(3, 'category_featured', 'ویژه دسته‌بندی', 'نمایش در صفحات دسته‌بندی', 'category_top', 4, 2, 'grid', '[\"silver\"]', 0, 1, 1, 3, '2025-04-28 07:49:31', '2025-04-28 07:49:31', NULL),
(4, 'category_bottom', 'انتهای دسته‌بندی', 'نمایش در پایین صفحات دسته‌بندی', 'category_bottom', 4, 2, 'carousel', '[\"bronze\"]', 0, 1, 1, 4, '2025-04-28 07:49:31', '2025-04-28 07:49:31', NULL),
(5, 'homepage_diamond', 'تبلیغات الماسی صفحه اصلی', NULL, 'grid', 4, 2, 'grid', '[\"diamond\"]', 0, 0, 1, 10, '2025-04-28 20:13:50', '2025-04-28 23:46:42', 1);

-- --------------------------------------------------------

--
-- Table structure for table `ad_packages`
--

CREATE TABLE `ad_packages` (
  `id` int(11) NOT NULL,
  `package_key` varchar(50) NOT NULL COMMENT 'کلید یکتای پکیج',
  `name` varchar(100) NOT NULL COMMENT 'نام پکیج',
  `description` text DEFAULT NULL COMMENT 'توضیحات پکیج',
  `price` decimal(10,2) NOT NULL COMMENT 'قیمت پکیج',
  `duration_days` int(11) NOT NULL DEFAULT 30 COMMENT 'مدت اعتبار (روز)',
  `badge_text` varchar(50) DEFAULT NULL COMMENT 'متن نشان روی کارت',
  `badge_color` varchar(20) DEFAULT '#FFC107' COMMENT 'رنگ نشان',
  `card_design` varchar(50) DEFAULT 'standard' COMMENT 'طراحی کارت: standard, premium, diamond, gold',
  `card_border_color` varchar(20) DEFAULT NULL COMMENT 'رنگ حاشیه کارت',
  `card_background_color` varchar(20) DEFAULT NULL COMMENT 'رنگ پس‌زمینه کارت',
  `card_text_color` varchar(20) DEFAULT NULL COMMENT 'رنگ متن کارت',
  `priority` int(11) NOT NULL DEFAULT 10 COMMENT 'اولویت نمایش (کمتر = مهمتر)',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'وضعیت فعال بودن',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول انواع پکیج‌های تبلیغاتی';

--
-- Dumping data for table `ad_packages`
--

INSERT INTO `ad_packages` (`id`, `package_key`, `name`, `description`, `price`, `duration_days`, `badge_text`, `badge_color`, `card_design`, `card_border_color`, `card_background_color`, `card_text_color`, `priority`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'diamond', 'پکیج الماس', 'نمایش در بالای صفحه اصلی بدون محدودیت منطقه و دسته', 5000000.00, 30, 'ویژه', '#9c27b0', 'diamond', '#9c27b0', '#f3e5f5', '#4a148c', 1, 1, '2025-04-28 07:48:18', '2025-04-28 07:48:18'),
(2, 'gold', 'پکیج طلایی', 'نمایش بر اساس منطقه جغرافیایی', 3000000.00, 30, 'طلایی', '#FFC107', 'gold', '#ffc107', '#fff8e1', '#ff6f00', 2, 1, '2025-04-28 07:48:18', '2025-04-28 07:48:18'),
(3, 'silver', 'پکیج نقره‌ای', 'نمایش بر اساس دسته‌بندی', 2000000.00, 30, 'نقره‌ای', '#757575', 'silver', '#9e9e9e', '#f5f5f5', '#424242', 3, 1, '2025-04-28 07:48:18', '2025-04-28 07:48:18'),
(4, 'bronze', 'پکیج برنزی', 'نمایش در پایین صفحات دسته‌بندی', 1000000.00, 30, 'برنزی', '#8d6e63', 'bronze', '#8d6e63', '#efebe9', '#3e2723', 4, 1, '2025-04-28 07:48:18', '2025-04-28 07:48:18');

-- --------------------------------------------------------

--
-- Table structure for table `amenities`
--

CREATE TABLE `amenities` (
  `id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL COMMENT 'شناسه نوع امکان',
  `title` varchar(100) NOT NULL COMMENT 'عنوان امکان',
  `icon` varchar(100) DEFAULT 'fas fa-check' COMMENT 'آیکون FontAwesome',
  `description` text DEFAULT NULL COMMENT 'توضیحات امکان',
  `display_order` int(11) DEFAULT 10 COMMENT 'ترتیب نمایش',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال بودن',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `amenity_translations`
--

CREATE TABLE `amenity_translations` (
  `id` int(11) NOT NULL,
  `amenity_id` int(11) NOT NULL COMMENT 'شناسه امکان',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `title` varchar(100) NOT NULL COMMENT 'عنوان امکان در این زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات امکان در این زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `amenity_types`
--

CREATE TABLE `amenity_types` (
  `id` int(11) NOT NULL,
  `type_key` varchar(50) NOT NULL COMMENT 'کلید یکتا برای نوع امکان',
  `type_name` varchar(100) NOT NULL COMMENT 'نام نوع امکان',
  `type_section` enum('key_info','room_feature','hotel_facility') NOT NULL COMMENT 'بخش مربوط به امکان',
  `display_order` int(11) DEFAULT 10 COMMENT 'ترتیب نمایش',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `amenity_type_translations`
--

CREATE TABLE `amenity_type_translations` (
  `id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL COMMENT 'شناسه نوع امکان',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `type_name` varchar(100) NOT NULL COMMENT 'نام نوع امکان در این زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `button_settings`
--

CREATE TABLE `button_settings` (
  `id` int(11) NOT NULL,
  `button_key` varchar(50) NOT NULL COMMENT 'کلید دکمه',
  `button_text` varchar(100) NOT NULL COMMENT 'متن دکمه',
  `button_url` varchar(255) DEFAULT NULL COMMENT 'آدرس دکمه',
  `button_icon` varchar(50) DEFAULT NULL COMMENT 'آیکون دکمه',
  `button_class` varchar(100) DEFAULT NULL COMMENT 'کلاس CSS دکمه',
  `is_visible` tinyint(1) DEFAULT 1 COMMENT 'نمایش دکمه',
  `show_for_guests` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای مهمان‌ها',
  `show_for_users` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای کاربران',
  `sort_order` int(11) DEFAULT 0 COMMENT 'ترتیب نمایش',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تنظیمات دکمه‌های سایت';

--
-- Dumping data for table `button_settings`
--

INSERT INTO `button_settings` (`id`, `button_key`, `button_text`, `button_url`, `button_icon`, `button_class`, `is_visible`, `show_for_guests`, `show_for_users`, `sort_order`, `language_code`, `created_at`, `updated_at`) VALUES
(122, 'login', 'ورود', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'fa', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(123, 'register', 'ثبت نام', '/register', 'fas fa-user-plus', 'btn-auth', 0, 1, 0, 2, 'fa', '2025-06-03 09:16:55', '2025-06-03 05:57:14'),
(124, 'dashboard', 'داشبورد', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'fa', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(125, 'profile', 'پروفایل کاربری', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'fa', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(126, 'my_locations', 'مکان‌های من', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'fa', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(127, 'favorites', 'علاقه‌مندی‌ها', '/user/favorites', 'fas fa-heart', 'dropdown-item', 0, 0, 1, 4, 'fa', '2025-06-03 09:16:55', '2025-06-03 05:57:52'),
(128, 'settings', 'تنظیمات', '/user/settings', 'fas fa-cog', 'dropdown-item', 0, 0, 1, 5, 'fa', '2025-06-03 09:16:55', '2025-06-03 05:57:55'),
(129, 'logout', 'خروج', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'fa', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(130, 'add_location', 'ثبت مکان', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'fa', '2025-06-03 09:16:55', '2025-06-03 05:58:06'),
(131, 'login', 'Login', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(132, 'register', 'Register', '/register', 'fas fa-user-plus', 'btn-auth', 1, 1, 0, 2, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(133, 'dashboard', 'Dashboard', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(134, 'profile', 'User Profile', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(135, 'my_locations', 'My Locations', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(136, 'favorites', 'Favorites', '/user/favorites', 'fas fa-heart', 'dropdown-item', 1, 0, 1, 4, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(137, 'settings', 'Settings', '/user/settings', 'fas fa-cog', 'dropdown-item', 1, 0, 1, 5, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(138, 'logout', 'Logout', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(139, 'add_location', 'Add New Location', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'en', '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(149, 'login', 'تسجيل الدخول', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'ar', '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(150, 'register', 'إنشاء حساب', '/register', 'fas fa-user-plus', 'btn-auth', 1, 1, 0, 2, 'ar', '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(151, 'dashboard', 'لوحة التحكم', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'ar', '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(152, 'profile', 'الملف الشخصي', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'ar', '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(153, 'my_locations', 'مواقعي', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'ar', '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(154, 'favorites', 'المفضلة', '/user/favorites', 'fas fa-heart', 'dropdown-item', 1, 0, 1, 4, 'ar', '2025-06-03 05:47:58', '2025-06-03 05:47:58'),
(155, 'settings', 'الإعدادات', '/user/settings', 'fas fa-cog', 'dropdown-item', 1, 0, 1, 5, 'ar', '2025-06-03 05:47:58', '2025-06-03 05:47:58'),
(156, 'logout', 'تسجيل الخروج', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'ar', '2025-06-03 05:47:58', '2025-06-03 05:47:58'),
(157, 'add_location', 'إضافة موقع جديد', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'ar', '2025-06-03 05:47:58', '2025-06-03 05:47:58');

-- --------------------------------------------------------

--
-- Table structure for table `button_settings_backup`
--

CREATE TABLE `button_settings_backup` (
  `id` int(11) NOT NULL DEFAULT 0,
  `button_key` varchar(50) NOT NULL COMMENT 'کلید دکمه',
  `button_text` varchar(100) NOT NULL COMMENT 'متن دکمه',
  `button_url` varchar(255) DEFAULT NULL COMMENT 'آدرس دکمه',
  `button_icon` varchar(50) DEFAULT NULL COMMENT 'آیکون دکمه',
  `button_class` varchar(100) DEFAULT NULL COMMENT 'کلاس CSS دکمه',
  `is_visible` tinyint(1) DEFAULT 1 COMMENT 'نمایش دکمه',
  `show_for_guests` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای مهمان‌ها',
  `show_for_users` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای کاربران',
  `sort_order` int(11) DEFAULT 0 COMMENT 'ترتیب نمایش',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `button_settings_backup`
--

INSERT INTO `button_settings_backup` (`id`, `button_key`, `button_text`, `button_url`, `button_icon`, `button_class`, `is_visible`, `show_for_guests`, `show_for_users`, `sort_order`, `language_code`, `created_at`, `updated_at`) VALUES
(63, 'login', 'ورود', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(64, 'register', 'ثبت نام', '/register', 'fas fa-user-plus', 'btn-auth', 1, 1, 0, 2, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(65, 'dashboard', 'داشبورد', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(66, 'profile', 'پروفایل کاربری', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(67, 'my_locations', 'مکان‌های من', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(68, 'favorites', 'علاقه‌مندی‌ها', '/user/favorites', 'fas fa-heart', 'dropdown-item', 1, 0, 1, 4, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(69, 'settings', 'تنظیمات', '/user/settings', 'fas fa-cog', 'dropdown-item', 1, 0, 1, 5, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(70, 'logout', 'خروج', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(71, 'add_location', 'ثبت مکان جدید', '/add-place', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'fa', '2025-06-03 04:53:45', '2025-06-03 04:53:45');

-- --------------------------------------------------------

--
-- Table structure for table `button_settings_backup_multilingual`
--

CREATE TABLE `button_settings_backup_multilingual` (
  `id` int(11) NOT NULL DEFAULT 0,
  `button_key` varchar(50) NOT NULL COMMENT 'کلید دکمه',
  `button_text` varchar(100) NOT NULL COMMENT 'متن دکمه',
  `button_url` varchar(255) DEFAULT NULL COMMENT 'آدرس دکمه',
  `button_icon` varchar(50) DEFAULT NULL COMMENT 'آیکون دکمه',
  `button_class` varchar(100) DEFAULT NULL COMMENT 'کلاس CSS دکمه',
  `is_visible` tinyint(1) DEFAULT 1 COMMENT 'نمایش دکمه',
  `show_for_guests` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای مهمان‌ها',
  `show_for_users` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای کاربران',
  `sort_order` int(11) DEFAULT 0 COMMENT 'ترتیب نمایش',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `button_settings_backup_multilingual`
--

INSERT INTO `button_settings_backup_multilingual` (`id`, `button_key`, `button_text`, `button_url`, `button_icon`, `button_class`, `is_visible`, `show_for_guests`, `show_for_users`, `sort_order`, `language_code`, `created_at`, `updated_at`) VALUES
(113, 'login', 'ورود', '/login', 'fas fa-sign-in-alt', 'btn-auth', 1, 1, 0, 1, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:07:57'),
(114, 'register', 'ثبت نام', '/register', 'fas fa-user-plus', 'btn-auth', 0, 1, 0, 2, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:09:13'),
(115, 'dashboard', 'داشبورد', '/user/dashboard', 'fas fa-tachometer-alt', 'dropdown-item', 1, 0, 1, 1, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:07:57'),
(116, 'profile', 'پروفایل کاربری', '/user/profile', 'fas fa-user-edit', 'dropdown-item', 1, 0, 1, 2, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:09:19'),
(117, 'my_locations', 'مکان‌های من', '/user/locations', 'fas fa-map-marker-alt', 'dropdown-item', 1, 0, 1, 3, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:07:57'),
(118, 'favorites', 'علاقه‌مندی‌ها', '/user/favorites', 'fas fa-heart', 'dropdown-item', 0, 0, 1, 4, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:09:30'),
(119, 'settings', 'تنظیمات', '/user/settings', 'fas fa-cog', 'dropdown-item', 0, 0, 1, 5, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:09:32'),
(120, 'logout', 'خروج', '/user/logout', 'fas fa-sign-out-alt', 'dropdown-item', 1, 0, 1, 6, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:07:57'),
(121, 'add_location', 'ثبت مکان جدید', '/user/locations/create', 'fas fa-plus-circle', 'btn-add-place', 1, 1, 1, 10, 'fa', '2025-06-03 05:07:57', '2025-06-03 05:07:57');

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cache`
--

INSERT INTO `cache` (`key`, `value`, `expiration`) VALUES
('admin_panel_cache_button_settings_fa', 'O:39:\"Illuminate\\Database\\Eloquent\\Collection\":2:{s:8:\"\0*\0items\";a:2:{i:0;O:24:\"App\\Models\\ButtonSetting\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:15:\"button_settings\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:13:{s:2:\"id\";i:122;s:10:\"button_key\";s:5:\"login\";s:11:\"button_text\";s:8:\"ورود\";s:10:\"button_url\";s:6:\"/login\";s:11:\"button_icon\";s:18:\"fas fa-sign-in-alt\";s:12:\"button_class\";s:8:\"btn-auth\";s:10:\"is_visible\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:0;s:10:\"sort_order\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 12:46:55\";s:10:\"updated_at\";s:19:\"2025-06-03 12:46:55\";}s:11:\"\0*\0original\";a:13:{s:2:\"id\";i:122;s:10:\"button_key\";s:5:\"login\";s:11:\"button_text\";s:8:\"ورود\";s:10:\"button_url\";s:6:\"/login\";s:11:\"button_icon\";s:18:\"fas fa-sign-in-alt\";s:12:\"button_class\";s:8:\"btn-auth\";s:10:\"is_visible\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:0;s:10:\"sort_order\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 12:46:55\";s:10:\"updated_at\";s:19:\"2025-06-03 12:46:55\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:4:{s:10:\"is_visible\";s:7:\"boolean\";s:15:\"show_for_guests\";s:7:\"boolean\";s:14:\"show_for_users\";s:7:\"boolean\";s:10:\"sort_order\";s:7:\"integer\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:0:{}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:10:{i:0;s:10:\"button_key\";i:1;s:11:\"button_text\";i:2;s:10:\"button_url\";i:3;s:11:\"button_icon\";i:4;s:12:\"button_class\";i:5;s:10:\"is_visible\";i:6;s:15:\"show_for_guests\";i:7;s:14:\"show_for_users\";i:8;s:10:\"sort_order\";i:9;s:13:\"language_code\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}i:1;O:24:\"App\\Models\\ButtonSetting\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:15:\"button_settings\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:13:{s:2:\"id\";i:130;s:10:\"button_key\";s:12:\"add_location\";s:11:\"button_text\";s:15:\"ثبت مکان\";s:10:\"button_url\";s:22:\"/user/locations/create\";s:11:\"button_icon\";s:18:\"fas fa-plus-circle\";s:12:\"button_class\";s:13:\"btn-add-place\";s:10:\"is_visible\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:10:\"sort_order\";i:10;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 12:46:55\";s:10:\"updated_at\";s:19:\"2025-06-03 09:28:06\";}s:11:\"\0*\0original\";a:13:{s:2:\"id\";i:130;s:10:\"button_key\";s:12:\"add_location\";s:11:\"button_text\";s:15:\"ثبت مکان\";s:10:\"button_url\";s:22:\"/user/locations/create\";s:11:\"button_icon\";s:18:\"fas fa-plus-circle\";s:12:\"button_class\";s:13:\"btn-add-place\";s:10:\"is_visible\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:10:\"sort_order\";i:10;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 12:46:55\";s:10:\"updated_at\";s:19:\"2025-06-03 09:28:06\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:4:{s:10:\"is_visible\";s:7:\"boolean\";s:15:\"show_for_guests\";s:7:\"boolean\";s:14:\"show_for_users\";s:7:\"boolean\";s:10:\"sort_order\";s:7:\"integer\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:0:{}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:10:{i:0;s:10:\"button_key\";i:1;s:11:\"button_text\";i:2;s:10:\"button_url\";i:3;s:11:\"button_icon\";i:4;s:12:\"button_class\";i:5;s:10:\"is_visible\";i:6;s:15:\"show_for_guests\";i:7;s:14:\"show_for_users\";i:8;s:10:\"sort_order\";i:9;s:13:\"language_code\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}', 1751353641),
('admin_panel_cache_display_settings_homepage_below_map', 'O:25:\"App\\Models\\DisplaySetting\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:16:\"display_settings\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:20:{s:2:\"id\";i:1;s:8:\"page_key\";s:8:\"homepage\";s:11:\"section_key\";s:9:\"below_map\";s:13:\"desktop_items\";i:6;s:12:\"mobile_items\";i:6;s:14:\"load_more_text\";N;s:9:\"is_active\";i:1;s:12:\"hero_section\";i:1;s:16:\"featured_section\";i:1;s:18:\"categories_section\";i:1;s:14:\"latest_section\";i:1;s:15:\"popular_section\";i:1;s:11:\"map_section\";i:1;s:16:\"sidebar_position\";s:5:\"right\";s:14:\"items_per_page\";i:12;s:12:\"show_ratings\";i:1;s:13:\"show_comments\";i:1;s:18:\"show_share_buttons\";i:1;s:10:\"created_at\";s:19:\"2025-05-08 17:20:50\";s:10:\"updated_at\";s:19:\"2025-05-16 14:08:11\";}s:11:\"\0*\0original\";a:20:{s:2:\"id\";i:1;s:8:\"page_key\";s:8:\"homepage\";s:11:\"section_key\";s:9:\"below_map\";s:13:\"desktop_items\";i:6;s:12:\"mobile_items\";i:6;s:14:\"load_more_text\";N;s:9:\"is_active\";i:1;s:12:\"hero_section\";i:1;s:16:\"featured_section\";i:1;s:18:\"categories_section\";i:1;s:14:\"latest_section\";i:1;s:15:\"popular_section\";i:1;s:11:\"map_section\";i:1;s:16:\"sidebar_position\";s:5:\"right\";s:14:\"items_per_page\";i:12;s:12:\"show_ratings\";i:1;s:13:\"show_comments\";i:1;s:18:\"show_share_buttons\";i:1;s:10:\"created_at\";s:19:\"2025-05-08 17:20:50\";s:10:\"updated_at\";s:19:\"2025-05-16 14:08:11\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:13:{s:9:\"is_active\";s:7:\"boolean\";s:13:\"desktop_items\";s:7:\"integer\";s:12:\"mobile_items\";s:7:\"integer\";s:12:\"hero_section\";s:7:\"boolean\";s:16:\"featured_section\";s:7:\"boolean\";s:18:\"categories_section\";s:7:\"boolean\";s:14:\"latest_section\";s:7:\"boolean\";s:15:\"popular_section\";s:7:\"boolean\";s:11:\"map_section\";s:7:\"boolean\";s:14:\"items_per_page\";s:7:\"integer\";s:12:\"show_ratings\";s:7:\"boolean\";s:13:\"show_comments\";s:7:\"boolean\";s:18:\"show_share_buttons\";s:7:\"boolean\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:0:{}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:17:{i:0;s:8:\"page_key\";i:1;s:11:\"section_key\";i:2;s:13:\"desktop_items\";i:3;s:12:\"mobile_items\";i:4;s:14:\"load_more_text\";i:5;s:9:\"is_active\";i:6;s:12:\"hero_section\";i:7;s:16:\"featured_section\";i:8;s:18:\"categories_section\";i:9;s:14:\"latest_section\";i:10;s:15:\"popular_section\";i:11;s:11:\"map_section\";i:12;s:16:\"sidebar_position\";i:13;s:14:\"items_per_page\";i:14;s:12:\"show_ratings\";i:15;s:13:\"show_comments\";i:16;s:18:\"show_share_buttons\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}', 1751353643),
('admin_panel_cache_header_settings_fa', 'a:14:{s:9:\"site_logo\";s:16:\"/images/logo.png\";s:10:\"site_title\";s:19:\"اَلو ایران\";s:15:\"show_search_box\";s:1:\"0\";s:18:\"search_placeholder\";s:34:\"جستجو در مکان‌ها...\";s:22:\"show_language_switcher\";s:1:\"1\";s:14:\"show_user_menu\";s:1:\"1\";s:12:\"header_style\";s:7:\"default\";s:13:\"sticky_header\";s:1:\"1\";s:15:\"show_breadcrumb\";s:1:\"0\";s:10:\"login_text\";s:8:\"ورود\";s:11:\"logout_text\";s:8:\"خروج\";s:17:\"add_location_text\";s:24:\"ثبت مکان جدید\";s:16:\"add_location_url\";s:22:\"/user/locations/create\";s:24:\"show_add_location_button\";s:1:\"1\";}', 1751353641),
('admin_panel_cache_health_check', 's:2:\"ok\";', 1751350196),
('admin_panel_cache_sidebar_stats', 'a:17:{s:15:\"total_locations\";i:51;s:16:\"active_locations\";i:51;s:17:\"pending_locations\";i:0;s:16:\"total_categories\";i:207;s:13:\"total_ratings\";i:0;s:15:\"pending_ratings\";i:0;s:16:\"approved_ratings\";i:0;s:11:\"total_users\";i:1;s:12:\"active_users\";i:1;s:14:\"inactive_users\";i:0;s:12:\"banned_users\";i:0;s:12:\"total_admins\";i:3;s:13:\"active_admins\";i:3;s:9:\"total_ads\";i:4;s:10:\"active_ads\";i:1;s:15:\"unread_messages\";i:0;s:20:\"system_notifications\";i:0;}', 1751350867),
('admin_panel_cache_site_menus_fa', 'O:39:\"Illuminate\\Database\\Eloquent\\Collection\":2:{s:8:\"\0*\0items\";a:4:{i:0;O:19:\"App\\Models\\SiteMenu\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:10:\"site_menus\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:13:{s:2:\"id\";i:1;s:5:\"title\";s:17:\"صفحه اصلی\";s:3:\"url\";s:1:\"/\";s:4:\"icon\";s:11:\"fas fa-home\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:1;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 08:40:07\";}s:11:\"\0*\0original\";a:13:{s:2:\"id\";i:1;s:5:\"title\";s:17:\"صفحه اصلی\";s:3:\"url\";s:1:\"/\";s:4:\"icon\";s:11:\"fas fa-home\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:1;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 08:40:07\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:4:{s:9:\"is_active\";s:7:\"boolean\";s:15:\"show_for_guests\";s:7:\"boolean\";s:14:\"show_for_users\";s:7:\"boolean\";s:10:\"sort_order\";s:7:\"integer\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:1:{s:8:\"children\";O:39:\"Illuminate\\Database\\Eloquent\\Collection\":2:{s:8:\"\0*\0items\";a:0:{}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:10:{i:0;s:5:\"title\";i:1;s:3:\"url\";i:2;s:4:\"icon\";i:3;s:6:\"target\";i:4;s:9:\"parent_id\";i:5;s:10:\"sort_order\";i:6;s:9:\"is_active\";i:7;s:15:\"show_for_guests\";i:8;s:14:\"show_for_users\";i:9;s:13:\"language_code\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}i:1;O:19:\"App\\Models\\SiteMenu\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:10:\"site_menus\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:13:{s:2:\"id\";i:2;s:5:\"title\";s:26:\"دسته‌بندی‌ها\";s:3:\"url\";s:11:\"/categories\";s:4:\"icon\";s:11:\"fas fa-list\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:2;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 08:40:07\";}s:11:\"\0*\0original\";a:13:{s:2:\"id\";i:2;s:5:\"title\";s:26:\"دسته‌بندی‌ها\";s:3:\"url\";s:11:\"/categories\";s:4:\"icon\";s:11:\"fas fa-list\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:2;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 08:40:07\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:4:{s:9:\"is_active\";s:7:\"boolean\";s:15:\"show_for_guests\";s:7:\"boolean\";s:14:\"show_for_users\";s:7:\"boolean\";s:10:\"sort_order\";s:7:\"integer\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:1:{s:8:\"children\";O:39:\"Illuminate\\Database\\Eloquent\\Collection\":2:{s:8:\"\0*\0items\";a:0:{}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:10:{i:0;s:5:\"title\";i:1;s:3:\"url\";i:2;s:4:\"icon\";i:3;s:6:\"target\";i:4;s:9:\"parent_id\";i:5;s:10:\"sort_order\";i:6;s:9:\"is_active\";i:7;s:15:\"show_for_guests\";i:8;s:14:\"show_for_users\";i:9;s:13:\"language_code\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}i:2;O:19:\"App\\Models\\SiteMenu\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:10:\"site_menus\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:13:{s:2:\"id\";i:3;s:5:\"title\";s:8:\"نقشه\";s:3:\"url\";s:4:\"/map\";s:4:\"icon\";s:10:\"fas fa-map\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:3;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 07:41:54\";}s:11:\"\0*\0original\";a:13:{s:2:\"id\";i:3;s:5:\"title\";s:8:\"نقشه\";s:3:\"url\";s:4:\"/map\";s:4:\"icon\";s:10:\"fas fa-map\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:3;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 07:41:54\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:4:{s:9:\"is_active\";s:7:\"boolean\";s:15:\"show_for_guests\";s:7:\"boolean\";s:14:\"show_for_users\";s:7:\"boolean\";s:10:\"sort_order\";s:7:\"integer\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:1:{s:8:\"children\";O:39:\"Illuminate\\Database\\Eloquent\\Collection\":2:{s:8:\"\0*\0items\";a:0:{}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:10:{i:0;s:5:\"title\";i:1;s:3:\"url\";i:2;s:4:\"icon\";i:3;s:6:\"target\";i:4;s:9:\"parent_id\";i:5;s:10:\"sort_order\";i:6;s:9:\"is_active\";i:7;s:15:\"show_for_guests\";i:8;s:14:\"show_for_users\";i:9;s:13:\"language_code\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}i:3;O:19:\"App\\Models\\SiteMenu\":32:{s:13:\"\0*\0connection\";s:5:\"mysql\";s:8:\"\0*\0table\";s:10:\"site_menus\";s:13:\"\0*\0primaryKey\";s:2:\"id\";s:10:\"\0*\0keyType\";s:3:\"int\";s:12:\"incrementing\";b:1;s:7:\"\0*\0with\";a:0:{}s:12:\"\0*\0withCount\";a:0:{}s:19:\"preventsLazyLoading\";b:0;s:10:\"\0*\0perPage\";i:15;s:6:\"exists\";b:1;s:18:\"wasRecentlyCreated\";b:0;s:28:\"\0*\0escapeWhenCastingToString\";b:0;s:13:\"\0*\0attributes\";a:13:{s:2:\"id\";i:4;s:5:\"title\";s:17:\"درباره ما\";s:3:\"url\";s:6:\"/about\";s:4:\"icon\";s:18:\"fas fa-info-circle\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:4;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 07:41:55\";}s:11:\"\0*\0original\";a:13:{s:2:\"id\";i:4;s:5:\"title\";s:17:\"درباره ما\";s:3:\"url\";s:6:\"/about\";s:4:\"icon\";s:18:\"fas fa-info-circle\";s:6:\"target\";s:5:\"_self\";s:9:\"parent_id\";N;s:10:\"sort_order\";i:4;s:9:\"is_active\";i:1;s:15:\"show_for_guests\";i:1;s:14:\"show_for_users\";i:1;s:13:\"language_code\";s:2:\"fa\";s:10:\"created_at\";s:19:\"2025-06-03 08:40:07\";s:10:\"updated_at\";s:19:\"2025-06-03 07:41:55\";}s:10:\"\0*\0changes\";a:0:{}s:8:\"\0*\0casts\";a:4:{s:9:\"is_active\";s:7:\"boolean\";s:15:\"show_for_guests\";s:7:\"boolean\";s:14:\"show_for_users\";s:7:\"boolean\";s:10:\"sort_order\";s:7:\"integer\";}s:17:\"\0*\0classCastCache\";a:0:{}s:21:\"\0*\0attributeCastCache\";a:0:{}s:13:\"\0*\0dateFormat\";N;s:10:\"\0*\0appends\";a:0:{}s:19:\"\0*\0dispatchesEvents\";a:0:{}s:14:\"\0*\0observables\";a:0:{}s:12:\"\0*\0relations\";a:1:{s:8:\"children\";O:39:\"Illuminate\\Database\\Eloquent\\Collection\":2:{s:8:\"\0*\0items\";a:0:{}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}}s:10:\"\0*\0touches\";a:0:{}s:27:\"\0*\0relationAutoloadCallback\";N;s:26:\"\0*\0relationAutoloadContext\";N;s:10:\"timestamps\";b:1;s:13:\"usesUniqueIds\";b:0;s:9:\"\0*\0hidden\";a:0:{}s:10:\"\0*\0visible\";a:0:{}s:11:\"\0*\0fillable\";a:10:{i:0;s:5:\"title\";i:1;s:3:\"url\";i:2;s:4:\"icon\";i:3;s:6:\"target\";i:4;s:9:\"parent_id\";i:5;s:10:\"sort_order\";i:6;s:9:\"is_active\";i:7;s:15:\"show_for_guests\";i:8;s:14:\"show_for_users\";i:9;s:13:\"language_code\";}s:10:\"\0*\0guarded\";a:1:{i:0;s:1:\"*\";}}}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}', 1751353641),
('admin_panel_cache_site_settings_fa', 'a:8:{s:10:\"site_title\";s:17:\"الو ایران\";s:11:\"theme_color\";s:7:\"#000000\";s:9:\"logo_text\";s:19:\"اَلو ایران\";s:11:\"footer_text\";s:74:\"تمامی حقوق برای اَلو ایران محفوظ است © 2025\";s:4:\"logo\";s:27:\"/images/logo_GpUFTpls92.png\";s:9:\"site_icon\";s:32:\"/images/site_icon_aovTkFMsE2.png\";s:7:\"favicon\";s:30:\"/images/favicon_wtUayzrqNJ.png\";s:13:\"contact_phone\";s:11:\"09981100917\";}', 1751353643);

-- --------------------------------------------------------

--
-- Table structure for table `cache_locks`
--

CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `category_key` varchar(50) NOT NULL COMMENT 'کلید دسته‌بندی (منحصر به فرد)',
  `category_fa` varchar(100) NOT NULL COMMENT 'نام دسته‌بندی به فارسی',
  `category_en` varchar(100) DEFAULT NULL COMMENT 'نام دسته‌بندی به انگلیسی',
  `category_ar` varchar(100) DEFAULT NULL COMMENT 'نام دسته‌بندی به عربی',
  `emoji` varchar(20) DEFAULT '?' COMMENT 'ایموجی دسته‌بندی',
  `font_icon` varchar(50) DEFAULT 'location-dot' COMMENT 'آیکون Font Awesome',
  `color` varchar(20) DEFAULT '#4e73df' COMMENT 'رنگ دسته‌بندی به کد HEX',
  `sort_order` int(11) DEFAULT 10 COMMENT 'ترتیب نمایش',
  `show_in_menu` tinyint(1) DEFAULT 1 COMMENT 'نمایش در منو',
  `show_in_filters` tinyint(1) DEFAULT 1 COMMENT 'نمایش در فیلترها',
  `parent_id` int(11) DEFAULT NULL COMMENT 'شناسه دسته‌بندی والد',
  `description_fa` text DEFAULT NULL COMMENT 'توضیحات فارسی	',
  `description_en` text DEFAULT NULL COMMENT 'توضیحات انگلیسی',
  `description_ar` text DEFAULT NULL COMMENT 'توضیحات عربی',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول دسته‌بندی‌های مکان‌ها';

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `category_key`, `category_fa`, `category_en`, `category_ar`, `emoji`, `font_icon`, `color`, `sort_order`, `show_in_menu`, `show_in_filters`, `parent_id`, `description_fa`, `description_en`, `description_ar`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'shopping_centers', 'مراکز خرید', 'Shopping Centers', 'مراكز التسوق', '🛍️', 'shop', '#FF6B6B', 1, 1, 1, NULL, 'مراکز خرید شامل مال‌ها، بازارها و فروشگاه‌های بزرگ', 'Shopping centers including malls, bazaars, and large stores', 'مراكز التسوق تشمل المولات والأسواق والمتاجر الكبيرة', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(2, 'accommodation', 'اقامتی', 'Accommodation', 'الإقامة', '🏨', 'hotel', '#4ECDC4', 2, 1, 1, NULL, 'مراکز اقامتی شامل هتل‌ها، مهمانپذیرها و اقامتگاه‌ها', 'Accommodation centers including hotels, motels, and guest houses', 'مراكز الإقامة تشمل الفنادق والموتيلات وبيوت الضيافة', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(3, 'medical', 'درمانی', 'Medical', 'الطبية', '🏥', 'hospital', '#FF6B6B', 3, 1, 1, NULL, 'مراکز درمانی و پزشکی', 'Medical and healthcare centers', 'المراكز الطبية ومرافق الرعاية الصحية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(4, 'food', 'غذایی', 'Food & Dining', 'المطاعم والمأكولات', '🍽️', 'utensils', '#FFA07A', 4, 1, 1, NULL, 'رستوران‌ها، کافه‌ها و مراکز غذایی', 'Restaurants, cafes, and food centers', 'المطاعم والمقاهي ومراكز الأطعمة', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(5, 'entertainment', 'تفریحی', 'Entertainment', 'الترفيه', '🎭', 'masks-theater', '#A569BD', 5, 1, 1, NULL, 'مراکز تفریحی و سرگرمی', 'Entertainment and recreational centers', 'مراكز الترفيه والمنشآت الترفيهية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(6, 'education', 'آموزشی', 'Education', 'التعليم', '🎓', 'graduation-cap', '#3498DB', 6, 1, 1, NULL, 'مراکز آموزشی و علمی', 'Educational and scientific centers', 'المراكز التعليمية والعلمية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(7, 'transportation', 'حمل و نقل', 'Transportation', 'النقل', '🚆', 'bus', '#F39C12', 7, 1, 1, NULL, 'مراکز مرتبط با حمل و نقل', 'Transportation-related centers', 'المراكز المتعلقة بالنقل والمواصلات', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(8, 'sport', 'ورزشی', 'Sports', 'الرياضة', '⚽', 'futbol', '#2ECC71', 8, 1, 1, NULL, 'مراکز ورزشی و تفریحات ورزشی', 'Sports and athletic facilities', 'المنشآت الرياضية والمراكز الرياضية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(9, 'religious', 'مذهبی', 'Religious', 'الدينية', '🕌', 'mosque', '#9B59B6', 9, 1, 1, NULL, 'اماکن مذهبی', 'Religious places', 'الأماكن الدينية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(10, 'public_services', 'خدمات عمومی', 'Public Services', 'الخدمات العامة', '🏛️', 'landmark', '#95A5A6', 10, 1, 1, NULL, 'مراکز خدمات عمومی و دولتی', 'Public and governmental service centers', 'مراكز الخدمات العامة والحكومية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(11, 'natural', 'طبیعت', 'Natural', 'الطبيعة', '🌳', 'tree', '#27AE60', 11, 1, 1, NULL, 'جاذبه‌های طبیعی و پارک‌ها', 'Natural attractions and parks', 'المعالم الطبيعية والحدائق', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(12, 'business', 'کسب و کار', 'Business', 'الأعمال', '💼', 'briefcase', '#2980B9', 12, 1, 1, NULL, 'مراکز تجاری و کسب و کار', 'Business and commercial centers', 'المراكز التجارية ومرافق الأعمال', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(13, 'cultural', 'فرهنگی', 'Cultural', 'الثقافية', '🎨', 'palette', '#E74C3C', 13, 1, 1, NULL, 'مراکز فرهنگی و هنری', 'Cultural and artistic centers', 'المراكز الثقافية والفنية', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(14, 'industrial', 'صنعتی', 'Industrial', 'الصناعية', '🏭', 'industry', '#7F8C8D', 14, 1, 1, NULL, 'مراکز صنعتی و کارخانه‌ها', 'Industrial and manufacturing centers', 'المراكز الصناعية ووحدات الإنتاج', 1, '2025-04-24 09:10:01', '2025-05-16 04:20:31'),
(15, 'automotive', 'خدمات خودرویی', 'Automotive Services', 'خدمات السيارات', '🚗', 'car', '#3498DB', 15, 1, 1, NULL, 'خدمات مرتبط با خودرو و وسایل نقلیه', 'Automobile-related services', 'خدمات السيارات ومراكز الصيانة', 1, '2025-04-24 10:02:20', '2025-05-16 04:20:31'),
(16, 'construction', 'خدمات ساختمانی', 'Construction Services', 'خدمات البناء', '🏗️', 'helmet-safety', '#E67E22', 16, 1, 1, NULL, 'خدمات مرتبط با ساخت و ساز و ساختمان', 'Construction and building services', 'خدمات البناء والتشييد', 1, '2025-04-24 10:06:44', '2025-05-16 04:20:31'),
(17, 'fuel_stations', 'مراکز سوخت', 'Fuel Stations', 'محطات الوقود', '⛽', 'gas-pump', '#F39C12', 17, 1, 1, NULL, 'مراکز عرضه سوخت و ایستگاه‌های شارژ', 'Fuel stations and charging points', 'محطات الوقود ونقاط الشحن', 1, '2025-04-24 10:12:35', '2025-05-16 04:20:31'),
(18, 'beauty_salons', 'سالن‌های زیبایی', 'Beauty Salons', 'صالونات التجميل', '💇', 'scissors', '#E91E63', 18, 1, 1, NULL, 'مراکز خدمات زیبایی و آرایشی', 'Beauty and cosmetic service centers', 'مراكز التجميل وخدمات التجميل', 1, '2025-04-24 10:16:40', '2025-05-16 04:20:31'),
(101, 'mall', 'مرکز خرید (مال)', 'Shopping Mall', 'المولات التجارية', '🏬', 'store', '#FF6B6B', 1, 1, 1, 1, 'مراکز خرید بزرگ و مال‌ها', 'Large shopping centers and malls', 'مراكز التسوق الكبيرة والمولات التجارية', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(102, 'bazaar', 'بازار سنتی', 'Traditional Bazaar', 'السوق التقليدي', '🛒', 'shopping-basket', '#FF8E8E', 2, 1, 1, 1, 'بازارهای سنتی و قدیمی', 'Traditional markets and bazaars', 'الأسواق التقليدية والمتاجر القديمة', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(103, 'department_store', 'فروشگاه زنجیره‌ای', 'Department Store', 'المتجر المتعدد الأقسام', '🏪', 'store-alt', '#FF5252', 3, 1, 1, 1, 'فروشگاه‌های زنجیره‌ای بزرگ', 'Large department stores', 'المتاجر الكبيرة متعددة الأقسام', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(104, 'supermarket', 'سوپرمارکت', 'Supermarket', 'السوبرماركت', '🛒', 'shopping-cart', '#FF3D3D', 4, 1, 1, 1, 'سوپرمارکت‌ها و هایپرمارکت‌ها', 'Supermarkets and hypermarkets', 'السوبرماركت وهايبرماركت', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(105, 'clothing_store', 'پوشاک', 'Clothing Store', 'متجر الملابس', '👕', 'tshirt', '#FF1744', 5, 1, 1, 1, 'فروشگاه‌های پوشاک و لباس', 'Clothing and apparel stores', 'متاجر الملابس والأزياء', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(106, 'electronics_store', 'الکترونیک', 'Electronics Store', 'متجر الإلكترونيات', '📱', 'mobile-alt', '#D50000', 6, 1, 1, 1, 'فروشگاه‌های لوازم الکترونیکی', 'Electronics and appliance stores', 'متاجر الأجهزة الإلكترونية', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(107, 'jewelry_store', 'طلا و جواهر', 'Jewelry Store', 'متجر المجوهرات', '💎', 'gem', '#FFD600', 7, 1, 1, 1, 'فروشگاه‌های طلا و جواهر', 'Jewelry and precious stone stores', 'متاجر المجوهرات والأحجار الكريمة', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(108, 'book_store', 'کتابفروشی', 'Bookstore', 'متجر الكتب', '📚', 'book', '#795548', 8, 1, 1, 1, 'کتابفروشی‌ها و مراکز فروش کتاب', 'Bookstores and book sales centers', 'متاجر الكتب ومراكز بيع الكتب', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(109, 'home_appliances', 'لوازم خانگی', 'Home Appliances', 'الأجهزة المنزلية', '🛏️', 'couch', '#8D6E63', 9, 1, 1, 1, 'فروشگاه‌های لوازم خانگی', 'Home appliance stores', 'متاجر الأجهزة المنزلية', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(110, 'sports_shop', 'لوازم ورزشی', 'Sports Shop', 'متجر الرياضة', '⚽', 'dumbbell', '#2ECC71', 10, 1, 1, 1, 'فروشگاه‌های لوازم ورزشی', 'Sports equipment stores', 'متاجر المعدات الرياضية', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(111, 'antique_shop', 'عتیقه فروشی', 'Antique Shop', 'متجر التحف', '🏺', 'history', '#8D6E63', 11, 1, 1, 1, 'فروشگاه‌های عتیقه و اشیاء قدیمی', 'Antique and vintage item stores', 'متاجر التحف والأغراض القديمة', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(112, 'handicrafts', 'صنایع دستی', 'Handicrafts', 'المصنوعات اليدوية', '🧵', 'palette', '#F06292', 12, 1, 1, 1, 'فروشگاه‌های صنایع دستی', 'Handicraft and artisanal product stores', 'متاجر المنتجات اليدوية والحرفية', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(113, 'perfumery', 'عطر و ادکلن', 'Perfumery', 'متجر العطور', '🧴', 'spray-can', '#BA68C8', 13, 1, 1, 1, 'فروشگاه‌های عطر و ادکلن', 'Perfume and fragrance stores', 'متاجر العطور والروائح', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(114, 'optician', 'عینک فروشی', 'Optician', 'محل النظارات', '👓', 'glasses', '#64B5F6', 14, 1, 1, 1, 'فروشگاه‌های عینک و لوازم بینایی', 'Eyewear and optical stores', 'متاجر النظارات والبصريات', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(115, 'shoes_store', 'کفش فروشی', 'Shoe Store', 'متجر الأحذية', '👞', 'shoe-prints', '#4DB6AC', 15, 1, 1, 1, 'فروشگاه‌های کفش و کیف', 'Shoe and bag stores', 'متاجر الأحذية والحقائب', 1, '2025-04-24 09:11:46', '2025-05-16 04:24:15'),
(201, 'hotel', 'هتل', 'Hotel', 'الفندق', '🏨', 'hotel', '#4ECDC4', 1, 1, 1, 2, 'هتل‌های چند ستاره و مجهز', 'Multi-star and well-equipped hotels', 'الفنادق متعددة النجوم والمجهزة بالكامل', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(202, 'motel', 'مهمانپذیر', 'Motel', 'موتيل', '🛏️', 'bed', '#48CFAD', 2, 1, 1, 2, 'مهمانپذیرها و هتل‌های اقتصادی', 'Budget hotels and economical accommodations', 'الفنادق الاقتصادية وبيوت الإقامة', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(203, 'apartment_hotel', 'آپارتمان هتل', 'Apartment Hotel', 'فندق شقق', '🏢', 'building', '#37BC9B', 3, 1, 1, 2, 'آپارتمان‌های هتلی و سوئیت‌ها', 'Apartment-style hotels and suites', 'الشقق الفندقية والسويتات', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(204, 'hostel', 'هاستل', 'Hostel', 'السكن المشترك', '🛌', 'person-shelter', '#3BAFDA', 4, 1, 1, 2, 'هاستل‌ها و اقامتگاه‌های اشتراکی', 'Hostels and shared accommodations', 'مساكن الشباب والإقامة المشتركة', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(205, 'eco_lodge', 'اقامتگاه بوم‌گردی', 'Eco Lodge', 'المنتجع البيئي', '🏕️', 'campground', '#8CC152', 5, 1, 1, 2, 'اقامتگاه‌های بوم‌گردی و سنتی', 'Eco-friendly and traditional lodgings', 'أماكن الإقامة البيئية والتقليدية', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(206, 'villa', 'ویلا', 'Villa', 'فيلا', '🏡', 'house-chimney', '#A0D468', 6, 1, 1, 2, 'ویلاهای اجاره‌ای و اقامتی', 'Rental villas and vacation homes', 'الفيلات للإيجار ومنازل العطلات', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(207, 'guest_house', 'خانه مسافر', 'Guest House', 'بيت الضيافة', '🏠', 'house-user', '#FFCE54', 7, 1, 1, 2, 'خانه‌های مسافر و مهمان', 'Guest houses and traveler homes', 'بيوت الضيافة ومساكن المسافرين', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(208, 'resort', 'مجتمع تفریحی', 'Resort', 'منتجع', '⛱️', 'umbrella-beach', '#FC6E51', 8, 1, 1, 2, 'مجتمع‌های تفریحی و ریزورت‌ها', 'Recreational resorts and vacation complexes', 'المنتجعات الترفيهية ومجمعات العطلات', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(209, 'camping', 'چادر و کمپینگ', 'Camping', 'التخييم', '⛺', 'campground', '#ED5565', 9, 1, 1, 2, 'محل‌های کمپینگ و چادر زدن', 'Camping sites and tent areas', 'مواقع التخييم ومناطق الخيام', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(210, 'caravanserai', 'کاروانسرا', 'Caravanserai', 'الخان', '🏰', 'fort-awesome', '#DA4453', 10, 1, 1, 2, 'کاروانسراهای سنتی و تاریخی', 'Traditional and historical caravanserais', 'الخانات التقليدية والتاريخية', 1, '2025-04-24 09:12:53', '2025-05-16 04:24:15'),
(301, 'hospital', 'بیمارستان', 'Hospital', 'المستشفى', '🏥', 'hospital', '#FF6B6B', 1, 1, 1, 3, 'بیمارستان‌های عمومی و تخصصی', 'General and specialized hospitals', 'المستشفيات العامة والمتخصصة', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(302, 'clinic', 'کلینیک', 'Clinic', 'العيادة', '🩺', 'clinic-medical', '#FF8E8E', 2, 1, 1, 3, 'کلینیک‌های تخصصی و عمومی', 'Specialized and general clinics', 'العيادات المتخصصة والعامة', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(303, 'pharmacy', 'داروخانه', 'Pharmacy', 'الصيدلية', '💊', 'pills', '#FF5252', 3, 1, 1, 3, 'داروخانه‌ها و مراکز فروش دارو', 'Pharmacies and medicine sales centers', 'الصيدليات ومراكز بيع الأدوية', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(304, 'laboratory', 'آزمایشگاه', 'Laboratory', 'المختبر', '🧪', 'flask', '#FF3D3D', 4, 1, 1, 3, 'آزمایشگاه‌های تشخیص طبی', 'Medical diagnostic laboratories', 'المختبرات الطبية التشخيصية', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(305, 'dental_clinic', 'کلینیک دندانپزشکی', 'Dental Clinic', 'عيادة الأسنان', '🦷', 'tooth', '#FF1744', 5, 1, 1, 3, 'مراکز دندانپزشکی و تخصصی دندان', 'Dental clinics and specialized dental centers', 'عيادات الأسنان ومراكز طب الأسنان', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(306, 'optometry', 'بینایی سنجی', 'Optometry', 'فحص النظر', '👁️', 'eye', '#D50000', 6, 1, 1, 3, 'مراکز بینایی سنجی و عینک‌سازی', 'Optometry and eyewear centers', 'مراكز فحص النظر والنظارات', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(307, 'physiotherapy', 'فیزیوتراپی', 'Physiotherapy', 'العلاج الطبيعي', '💆', 'hands-helping', '#FFD600', 7, 1, 1, 3, 'مراکز فیزیوتراپی و توانبخشی', 'Physiotherapy and rehabilitation centers', 'مراكز العلاج الطبيعي والتأهيل', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(308, 'psychiatry', 'روانپزشکی', 'Psychiatry', 'الطب النفسي', '🧠', 'brain', '#795548', 8, 1, 1, 3, 'مراکز روانپزشکی و روانشناسی', 'Psychiatry and psychology centers', 'مراكز الطب النفسي وعلم النفس', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(309, 'emergency', 'اورژانس', 'Emergency', 'الطوارئ', '🚑', 'ambulance', '#8D6E63', 9, 1, 1, 3, 'مراکز اورژانس و فوریت‌های پزشکی', 'Emergency and urgent medical centers', 'مراكز الطوارئ والإسعاف', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(310, 'traditional_medicine', 'طب سنتی', 'Traditional Medicine', 'الطب التقليدي', '🌿', 'leaf', '#8BC34A', 10, 1, 1, 3, 'مراکز طب سنتی و گیاهان دارویی', 'Traditional and herbal medicine centers', 'مراكز الطب التقليدي والأعشاب', 1, '2025-04-24 09:14:53', '2025-05-16 04:24:15'),
(401, 'restaurant', 'رستوران', 'Restaurant', 'المطعم', '🍴', 'utensils', '#FFA07A', 1, 1, 1, 4, 'رستوران‌های سنتی و بین‌المللی', 'Traditional and international restaurants', 'المطاعم التقليدية والدولية', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(402, 'fast_food', 'فست فود', 'Fast Food', 'الوجبات السريعة', '🍔', 'hamburger', '#FF8A65', 2, 1, 1, 4, 'فست فودها و ساندویچی‌ها', 'Fast food outlets and sandwich shops', 'محلات الوجبات السريعة والشطائر', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(403, 'cafe', 'کافه', 'Cafe', 'المقهى', '☕', 'coffee', '#FF7043', 3, 1, 1, 4, 'کافه‌ها و قهوه خانه‌ها', 'Cafes and coffee houses', 'المقاهي ومحلات القهوة', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(404, 'confectionery', 'قنادی', 'Confectionery', 'الحلويات', '🍰', 'birthday-cake', '#FF5722', 4, 1, 1, 4, 'قنادی‌ها و شیرینی فروشی‌ها', 'Confectioneries and sweet shops', 'محلات الحلويات والسكاكر', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(405, 'ice_cream', 'بستنی فروشی', 'Ice Cream', 'آيس كريم', '🍦', 'ice-cream', '#F4511E', 5, 1, 1, 4, 'بستنی فروشی‌ها و کافه بستنی', 'Ice cream parlors and dessert cafes', 'محلات الآيس كريم والحلويات', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(406, 'juice_bar', 'آبمیوه فروشی', 'Juice Bar', 'عصير', '🍹', 'glass-whiskey', '#E64A19', 6, 1, 1, 4, 'آبمیوه فروشی‌ها و اسموتی بار', 'Juice bars and smoothie shops', 'محلات العصائر والسموذي', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(407, 'traditional_restaurant', 'رستوران سنتی', 'Traditional Restaurant', 'المطعم التقليدي', '🥘', 'mortar-pestle', '#D84315', 7, 1, 1, 4, 'رستوران‌های سنتی و محلی', 'Traditional and local cuisine restaurants', 'المطاعم التقليدية والمحلية', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(408, 'international_restaurant', 'رستوران بین‌المللی', 'International Restaurant', 'المطعم الدولي', '🍣', 'globe', '#BF360C', 8, 1, 1, 4, 'رستوران‌های بین‌المللی و خارجی', 'International and foreign cuisine restaurants', 'المطاعم الدولية والأجنبية', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(409, 'seafood_restaurant', 'رستوران غذاهای دریایی', 'Seafood Restaurant', 'مطعم المأكولات البحرية', '🐟', 'fish', '#00ACC1', 9, 1, 1, 4, 'رستوران‌های تخصصی غذاهای دریایی', 'Specialized seafood restaurants', 'المطاعم المتخصصة في المأكولات البحرية', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(410, 'vegetarian_restaurant', 'رستوران گیاهخواری', 'Vegetarian Restaurant', 'مطعم نباتي', '🥗', 'leaf', '#4CAF50', 10, 1, 1, 4, 'رستوران‌های گیاهخواری و وگان', 'Vegetarian and vegan restaurants', 'المطاعم النباتية والخالية من المنتجات الحيوانية', 1, '2025-04-24 09:15:06', '2025-05-16 04:24:15'),
(501, 'cinema', 'سینما', 'Cinema', 'السينما', '🎬', 'film', '#A569BD', 1, 1, 1, 5, 'سینماها و سالن‌های نمایش فیلم', 'Cinemas and movie theaters', 'دور السينما وصالات الأفلام', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(502, 'theater', 'تئاتر', 'Theater', 'المسرح', '🎭', 'masks-theater', '#9B59B6', 2, 1, 1, 5, 'سالن‌های تئاتر و نمایش', 'Theaters and performance halls', 'المسارح وقاعات العروض', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(503, 'amusement_park', 'پارک تفریحی', 'Amusement Park', 'مدينة الملاهي', '🎢', 'ferris-wheel', '#8E44AD', 3, 1, 1, 5, 'پارک‌های تفریحی و شهربازی', 'Amusement parks and funfairs', 'مدن الملاهي والحدائق الترفيهية', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(504, 'bowling', 'بولینگ', 'Bowling', 'البولينج', '🎳', 'bowling-ball', '#7D3C98', 4, 1, 1, 5, 'سالن‌های بولینگ', 'Bowling alleys and lanes', 'ملاعب البولينج', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(505, 'gaming_center', 'گیم نت', 'Gaming Center', 'مركز الألعاب', '🎮', 'gamepad', '#6C3483', 5, 1, 1, 5, 'گیم نت‌ها و مراکز بازی', 'Gaming centers and arcades', 'مراكز الألعاب وألعاب الفيديو', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(506, 'karaoke', 'کارائوکه', 'Karaoke', 'الكاريوكي', '🎤', 'microphone', '#5D3FD3', 6, 1, 1, 5, 'سالن‌های کارائوکه', 'Karaoke rooms and singing venues', 'غرف الكاريوكي والغناء', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(507, 'night_club', 'باشگاه شبانه', 'Night Club', 'النادي الليلي', '🪩', 'music', '#4A235A', 7, 1, 1, 5, 'باشگاه‌های شبانه و دیسکو', 'Nightclubs and discotheques', 'النوادي الليلية والدي جي', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(508, 'concert_hall', 'سالن کنسرت', 'Concert Hall', 'قاعة الحفلات', '🎵', 'guitar', '#3B1E77', 8, 1, 1, 5, 'سالن‌های کنسرت و موسیقی', 'Concert halls and music venues', 'قاعات الحفلات والموسيقى', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(509, 'art_gallery', 'گالری هنری', 'Art Gallery', 'المعرض الفني', '🎨', 'palette', '#2C1177', 9, 1, 1, 5, 'گالری‌های هنری و نمایشگاه‌ها', 'Art galleries and exhibitions', 'المعارض الفنية والمعارض', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(510, 'escape_room', 'اتاق فرار', 'Escape Room', 'غرفة الهروب', '🔐', 'door-closed', '#1A0677', 10, 1, 1, 5, 'اتاق‌های فرار و بازی‌های فکری', 'Escape rooms and puzzle games', 'غرف الهروب والألغاز', 1, '2025-04-24 09:15:21', '2025-05-16 04:24:15'),
(601, 'university', 'دانشگاه', 'University', 'الجامعة', '🎓', 'university', '#3498DB', 1, 1, 1, 6, 'دانشگاه‌ها و مراکز آموزش عالی', 'Universities and higher education institutions', 'الجامعات ومؤسسات التعليم العالي', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(602, 'school', 'مدرسه', 'School', 'المدرسة', '🏫', 'school', '#2980B9', 2, 1, 1, 6, 'مدارس و مراکز آموزشی عمومی', 'Schools and general education centers', 'المدارس ومراكز التعليم العام', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(603, 'language_institute', 'آموزشگاه زبان', 'Language Institute', 'معهد اللغة', '🗣️', 'language', '#1F618D', 3, 1, 1, 6, 'آموزشگاه‌های زبان خارجی', 'Foreign language institutes', 'معاهد اللغات الأجنبية', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(604, 'technical_college', 'آموزشگاه فنی', 'Technical College', 'الكلية التقنية', '🔧', 'tools', '#154360', 4, 1, 1, 6, 'مراکز آموزش فنی و حرفه‌ای', 'Technical and vocational training centers', 'مراكز التدريب التقني والمهني', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(605, 'library', 'کتابخانه', 'Library', 'المكتبة', '📚', 'book-open', '#5DADE2', 5, 1, 1, 6, 'کتابخانه‌های عمومی و تخصصی', 'Public and specialized libraries', 'المكتبات العامة والمتخصصة', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(606, 'research_center', 'مرکز تحقیقاتی', 'Research Center', 'مركز الأبحاث', '🔬', 'microscope', '#21618C', 6, 1, 1, 6, 'مراکز تحقیقاتی و پژوهشی', 'Research and scientific centers', 'مراكز الأبحاث والعلمية', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(607, 'driving_school', 'آموزشگاه رانندگی', 'Driving School', 'مدرسة القيادة', '🚗', 'car', '#1A5276', 7, 1, 1, 6, 'آموزشگاه‌های رانندگی', 'Driving schools and training centers', 'مدارس تعليم القيادة', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(608, 'art_school', 'آموزشگاه هنری', 'Art School', 'مدرسة الفنون', '🎨', 'paint-brush', '#2874A6', 8, 1, 1, 6, 'آموزشگاه‌های هنر و موسیقی', 'Art and music schools', 'مدارس الفنون والموسيقى', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(609, 'computer_course', 'آموزشگاه کامپیوتر', 'Computer Course', 'دورات الكمبيوتر', '💻', 'laptop-code', '#1B4F72', 9, 1, 1, 6, 'آموزشگاه‌های کامپیوتر و فناوری', 'Computer and technology training centers', 'مراكز تدريب الكمبيوتر والتكنولوجيا', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(610, 'kindergarten', 'مهدکودک', 'Kindergarten', 'الحضانة', '🧸', 'child', '#85C1E9', 10, 1, 1, 6, 'مهدکودک‌ها و پیش‌دبستانی‌ها', 'Kindergartens and preschools', 'رياض الأطفال ومراكز ما قبل المدرسة', 1, '2025-04-24 09:15:34', '2025-05-16 04:24:15'),
(701, 'airport', 'فرودگاه', 'Airport', 'المطار', '✈️', 'plane', '#F39C12', 1, 1, 1, 7, 'فرودگاه‌ها و پایانه‌های هوایی', 'Airports and air terminals', 'المطارات ومحطات الطيران', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(702, 'train_station', 'ایستگاه قطار', 'Train Station', 'محطة القطار', '🚆', 'train', '#E67E22', 2, 1, 1, 7, 'ایستگاه‌های قطار و مترو', 'Train and metro stations', 'محطات القطارات والمترو', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(703, 'bus_terminal', 'ترمینال اتوبوس', 'Bus Terminal', 'محطة الحافلات', '🚌', 'bus', '#D35400', 3, 1, 1, 7, 'ترمینال‌های اتوبوس‌رانی', 'Bus terminals and stations', 'محطات الحافلات والمواصلات', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(704, 'taxi_station', 'پایانه تاکسی', 'Taxi Station', 'موقف التاكسي', '🚕', 'taxi', '#BA4A00', 4, 1, 1, 7, 'پایانه‌های تاکسی‌رانی', 'Taxi stands and pickup points', 'مواقف التاكسي ونقاط التوصيل', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(705, 'subway', 'مترو', 'Subway', 'المترو', '🚇', 'subway', '#A04000', 5, 1, 1, 7, 'ایستگاه‌های مترو', 'Subway and underground stations', 'محطات المترو والأنفاق', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(706, 'car_rental', 'اجاره خودرو', 'Car Rental', 'تأجير السيارات', '🚗', 'car', '#6E2C00', 6, 1, 1, 7, 'شرکت‌های اجاره خودرو', 'Car rental companies', 'شركات تأجير السيارات', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(707, 'bike_rental', 'اجاره دوچرخه', 'Bike Rental', 'تأجير الدراجات', '🚲', 'bicycle', '#7B241C', 7, 1, 1, 7, 'ایستگاه‌های اجاره دوچرخه', 'Bicycle rental stations', 'محطات تأجير الدراجات', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(708, 'parking', 'پارکینگ', 'Parking', 'موقف السيارات', '🅿️', 'parking', '#922B21', 8, 1, 1, 7, 'پارکینگ‌های عمومی', 'Public parking facilities', 'مواقف السيارات العامة', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(709, 'gas_station1', 'پمپ بنزین', 'Gas Station', 'محطة وقود', '⛽', 'gas-pump', '#641E16', 9, 0, 0, 7, 'پمپ بنزین‌ها و جایگاه سوخت', 'Fuel stations and gas pumps', 'محطات الوقود ومضخات البنزين', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(710, 'port', 'بندر', 'Port', 'الميناء', '⚓', 'anchor', '#512E5F', 10, 1, 1, 7, 'بندرگاه‌ها و اسکله‌ها', 'Ports and docks', 'الموانئ والأرصفة', 1, '2025-04-24 09:15:48', '2025-05-16 04:24:15'),
(801, 'gym', 'باشگاه بدنسازی', 'Gym', 'النادي الرياضي', '💪', 'dumbbell', '#2ECC71', 1, 1, 1, 8, 'باشگاه‌های بدنسازی و فیتنس', 'Gyms and fitness centers', 'الصالات الرياضية ومراكز اللياقة', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(802, 'swimming_pool', 'استخر', 'Swimming Pool', 'المسبح', '🏊', 'swimming-pool', '#27AE60', 2, 1, 1, 8, 'استخرهای شنا و مراکز آبی', 'Swimming pools and aquatic centers', 'المسابح والمرافق المائية', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(803, 'stadium', 'استادیوم', 'Stadium', 'الملعب', '🏟️', 'stadium', '#229954', 3, 1, 1, 8, 'استادیوم‌های ورزشی', 'Sports stadiums and arenas', 'الملاعب الرياضية والصالات', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(804, 'football_field', 'زمین فوتبال', 'Football Field', 'ملعب كرة القدم', '⚽', 'futbol', '#1E8449', 4, 1, 1, 8, 'زمین‌های فوتبال', 'Football fields and pitches', 'ملاعب كرة القدم', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(805, 'tennis_court', 'زمین تنیس', 'Tennis Court', 'ملعب التنس', '🎾', 'table-tennis-paddle-ball', '#186A3B', 5, 1, 1, 8, 'زمین‌های تنیس', 'Tennis courts and facilities', 'ملاعب التنس', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(806, 'golf_course', 'زمین گلف', 'Golf Course', 'ملعب الجولف', '⛳', 'golf-ball-tee', '#145A32', 6, 1, 1, 8, 'زمین‌های گلف', 'Golf courses and clubs', 'ملاعب الجولف', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(807, 'ski_resort', 'پیست اسکی', 'Ski Resort', 'منتجع التزلج', '⛷️', 'skiing', '#117A65', 7, 1, 1, 8, 'پیست‌های اسکی', 'Ski resorts and slopes', 'منتجعات التزلج', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(808, 'martial_arts', 'ورزش‌های رزمی', 'Martial Arts', 'الرياضات القتالية', '🥋', 'user-ninja', '#0E6655', 8, 1, 1, 8, 'باشگاه‌های ورزش‌های رزمی', 'Martial arts training centers', 'مراكز التدريب على الفنون القتالية', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(809, 'yoga_studio', 'باشگاه یوگا', 'Yoga Studio', 'استوديو اليوجا', '🧘', 'spa', '#0B5345', 9, 1, 1, 8, 'باشگاه‌های یوگا و مدیتیشن', 'Yoga and meditation studios', 'استوديوهات اليوجا والتأمل', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(810, 'climbing', 'سالن سنگ‌نوردی', 'Climbing', 'تسلق الصخور', '🧗', 'mountain', '#186A3B', 10, 1, 1, 8, 'سالن‌های سنگ‌نوردی و صخره‌نوردی', 'Rock climbing and bouldering halls', 'قاعات تسلق الصخور', 1, '2025-04-24 09:16:01', '2025-05-16 04:24:15'),
(901, 'mosque', 'مسجد', 'Mosque', 'المسجد', '🕌', 'mosque', '#9B59B6', 1, 1, 1, 9, 'مساجد و نمازخانه‌ها', 'Mosques and prayer halls', 'المساجد ومصليات الصلاة', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(902, 'church', 'کلیسا', 'Church', 'الكنيسة', '⛪', 'church', '#8E44AD', 2, 1, 1, 9, 'کلیساها و مراکز مسیحی', 'Churches and Christian centers', 'الكنائس والمراكز المسيحية', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(903, 'shrine', 'حرم', 'Shrine', 'الحرم', '🕋', 'kaaba', '#7D3C98', 3, 1, 1, 9, 'حرم‌های امامزاده‌ها و معصومین', 'Shrines and holy sites', 'الأضرحة والأماكن المقدسة', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(904, 'temple', 'معبد', 'Temple', 'المعبد', '🛕', 'place-of-worship', '#6C3483', 4, 1, 1, 9, 'معابد و پرستشگاه‌ها', 'Temples and worship places', 'المعابد وأماكن العبادة', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(905, 'synagogue', 'کنیسه', 'Synagogue', 'الكنيس', '🕍', 'synagogue', '#5D3FD3', 5, 1, 1, 9, 'کنیسه‌ها و مراکز یهودی', 'Synagogues and Jewish centers', 'الكنيس والمراكز اليهودية', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(906, 'holy_site', 'زیارتگاه', 'Holy Site', 'المكان المقدس', '🙏', 'hands-praying', '#4A235A', 6, 1, 1, 9, 'زیارتگاه‌ها و اماکن مقدس', 'Holy sites and pilgrimage locations', 'الأماكن المقدسة ومواقع الحج', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(907, 'religious_school', 'مدرسه دینی', 'Religious School', 'المدرسة الدينية', '📿', 'pray', '#3B1E77', 7, 1, 1, 9, 'مدارس دینی و حوزه‌های علمیه', 'Religious schools and seminaries', 'المدارس الدينية والحوزات', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(908, 'prayer_hall', 'نمازخانه', 'Prayer Hall', 'مصلى', '🛐', 'person-praying', '#2C1177', 8, 1, 1, 9, 'نمازخانه‌های عمومی', 'Public prayer rooms', 'مصليات الصلاة العامة', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(909, 'cemetery', 'قبرستان', 'Cemetery', 'المقبرة', '⚰️', 'cross', '#1A0677', 9, 1, 1, 9, 'قبرستان‌ها و آرامگاه‌ها', 'Cemeteries and burial sites', 'المقابر ومواقع الدفن', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(910, 'religious_charity', 'خیریه مذهبی', 'Religious Charity', 'الجمعية الخيرية الدينية', '🤲', 'hand-holding-heart', '#1A237E', 10, 1, 1, 9, 'خیریه‌های مذهبی و مراکز کمک‌رسانی', 'Religious charities and aid centers', 'الجمعيات الخيرية الدينية', 1, '2025-04-24 09:16:16', '2025-05-16 04:24:15'),
(1001, 'post_office', 'پست', 'Post Office', 'البريد', '📮', 'envelope', '#95A5A6', 1, 1, 1, 10, 'دفاتر پست و مراکز پستی', 'Post offices and mailing centers', 'مكاتب البريد ومراكز البريد', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1002, 'police_station', 'کلانتری', 'Police Station', 'مركز الشرطة', '👮', 'shield-halved', '#7F8C8D', 2, 1, 1, 10, 'کلانتری‌ها و مراکز پلیس', 'Police stations and security centers', 'مراكز الشرطة والأمن', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1003, 'fire_station', 'ایستگاه آتش‌نشانی', 'Fire Station', 'الإطفاء', '🚒', 'fire-extinguisher', '#616A6B', 3, 1, 1, 10, 'ایستگاه‌های آتش‌نشانی', 'Fire stations and emergency services', 'محطات الإطفاء والطوارئ', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1004, 'city_hall', 'شهرداری', 'City Hall', 'البلدية', '🏛️', 'landmark', '#515A5A', 4, 1, 1, 10, 'ساختمان شهرداری و مراکز دولتی', 'Municipal buildings and government offices', 'المباني البلدية والمكاتب الحكومية', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1005, 'embassy', 'سفارت', 'Embassy', 'السفارة', '🏢', 'building-columns', '#424949', 5, 1, 1, 10, 'سفارتخانه‌ها و کنسولگری‌ها', 'Embassies and consulates', 'السفارات والقنصليات', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1006, 'court', 'دادگاه', 'Court', 'المحكمة', '⚖️', 'scale-balanced', '#34495E', 6, 1, 1, 10, 'دادگاه‌ها و مراکز قضایی', 'Courts and judicial centers', 'المحاكم ومراكز القضاء', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1007, 'bank', 'بانک', 'Bank', 'البنك', '🏦', 'money-bill-wave', '#2C3E50', 7, 1, 1, 10, 'بانک‌ها و مؤسسات مالی', 'Banks and financial institutions', 'البنوك والمؤسسات المالية', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1008, 'atm', 'عابر بانک', 'ATM', 'الصراف الآلي', '🏧', 'money-bill-1-wave', '#1B2631', 8, 1, 1, 10, 'دستگاه‌های خودپرداز', 'ATMs and cash machines', 'ماكينات الصراف الآلي', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1009, 'notary', 'دفتر اسناد رسمی', 'Notary', 'الكاتب العدل', '📝', 'file-signature', '#17202A', 9, 1, 1, 10, 'دفاتر اسناد رسمی و ثبت', 'Notary offices and document certification', 'مكاتب التوثيق والعدل', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1010, 'community_center', 'خانه محله', 'Community Center', 'مركز المجتمع', '🏘️', 'people-roof', '#0E0E10', 10, 1, 1, 10, 'خانه‌های محله و مراکز اجتماعی', 'Community centers and neighborhood houses', 'مراكز المجتمع والجمعيات', 1, '2025-04-24 09:16:29', '2025-05-16 04:24:15'),
(1101, 'park', 'پارک', 'Park', 'الحديقة', '🌳', 'tree', '#27AE60', 1, 1, 1, 11, 'پارک‌ها و فضای سبز', 'Parks and green spaces', 'الحدائق والمساحات الخضراء', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1102, 'garden', 'باغ', 'Garden', 'البستان', '🏡', 'leaf', '#229954', 2, 1, 1, 11, 'باغ‌ها و باغچه‌های عمومی', 'Gardens and public green areas', 'البساتين والحدائق العامة', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1103, 'forest', 'جنگل', 'Forest', 'الغابة', '🌲', 'tree-city', '#1E8449', 3, 1, 1, 11, 'جنگل‌ها و مناطق جنگلی', 'Forests and woodland areas', 'الغابات والمناطق الخضراء', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1104, 'mountain', 'کوه', 'Mountain', 'الجبل', '⛰️', 'mountain-sun', '#186A3B', 4, 1, 1, 11, 'کوه‌ها و مناطق کوهستانی', 'Mountains and mountainous regions', 'الجبال والمناطق الجبلية', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1105, 'lake', 'دریاچه', 'Lake', 'البحيرة', '🏞️', 'water', '#145A32', 5, 1, 1, 11, 'دریاچه‌ها و تالاب‌ها', 'Lakes and wetlands', 'البحيرات والمناطق الرطبة', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1106, 'river', 'رودخانه', 'River', 'النهر', '🌊', 'water-ladder', '#117A65', 6, 1, 1, 11, 'رودخانه‌ها و نهرها', 'Rivers and streams', 'الأنهار والجداول', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1107, 'waterfall', 'آبشار', 'Waterfall', 'الشلال', '🌊', 'waterfall', '#0E6655', 7, 1, 1, 11, 'آبشارها و چشمه‌ها', 'Waterfalls and springs', 'الشلالات والينابيع', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1108, 'beach', 'ساحل', 'Beach', 'الشاطئ', '🏖️', 'umbrella-beach', '#0B5345', 8, 1, 1, 11, 'سواحل و مناطق ساحلی', 'Beaches and coastal areas', 'الشواطئ والمناطق الساحلية', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1109, 'cave', 'غار', 'Cave', 'الكهف', '🕳️', 'mountain-city', '#186A3B', 9, 1, 1, 11, 'غارها و حفره‌های طبیعی', 'Caves and natural cavities', 'الكهوف والتجاويف الطبيعية', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1110, 'desert', 'بیابان', 'Desert', 'الصحراء', '🏜️', 'sun-plant-wilt', '#A04000', 10, 1, 1, 11, 'بیابان‌ها و مناطق کویری', 'Deserts and arid regions', 'الصحاري والمناطق الجافة', 1, '2025-04-24 09:28:31', '2025-05-16 04:24:15'),
(1201, 'office', 'دفتر کار', 'Office', 'المكتب', '🏢', 'building', '#2980B9', 1, 1, 1, 12, 'دفاتر کار و شرکت‌ها', 'Offices and company workspaces', 'المكاتب ومساحات العمل', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1202, 'co_working', 'فضای کار اشتراکی', 'Co-Working Space', 'مساحة العمل المشتركة', '👨‍💻', 'laptop-house', '#1F618D', 2, 1, 1, 12, 'فضاهای کار اشتراکی', 'Shared workspaces and coworking areas', 'مساحات العمل المشتركة', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1203, 'business_center', 'مرکز تجاری', 'Business Center', 'المركز التجاري', '🏢', 'city', '#154360', 3, 1, 1, 12, 'مراکز تجاری و اداری', 'Business centers and commercial complexes', 'المراكز التجارية والمجمعات', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1204, 'startup', 'استارتاپ', 'Startup', 'الشركة الناشئة', '💡', 'lightbulb', '#5DADE2', 4, 1, 1, 12, 'شرکت‌های استارتاپی', 'Startup companies and innovative businesses', 'الشركات الناشئة والمبتكرة', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1205, 'company', 'شرکت', 'Company', 'الشركة', '🏭', 'company', '#21618C', 5, 1, 1, 12, 'شرکت ها', 'Companies and corporations', 'الشركات والمؤسسات', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1206, 'warehouse', 'انبار', 'Warehouse', 'المستودع', '📦', 'box-open', '#1A5276', 6, 1, 1, 12, 'انبارها و مراکز نگهداری کالا', 'Warehouses and storage facilities', 'المستودعات ومرافق التخزين', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1207, 'exhibition', 'نمایشگاه', 'Exhibition', 'المعرض', '🎪', 'tent', '#2874A6', 7, 1, 1, 12, 'نمایشگاه‌های تجاری', 'Trade exhibitions and showcases', 'المعارض التجارية والعروض', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1208, 'convention_center', 'مرکز همایش', 'Convention Center', 'مركز المؤتمرات', '🏛️', 'microphone-lines', '#1B4F72', 8, 1, 1, 12, 'مراکز همایش و کنفرانس', 'Convention and conference centers', 'مراكز المؤتمرات والندوات', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1209, 'printing', 'چاپخانه', 'Printing House', 'المطبعة', '🖨️', 'print', '#85C1E9', 9, 1, 1, 12, 'چاپخانه‌ها و مراکز چاپ', 'Printing houses and publishing centers', 'المطابع ومراكز النشر', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1210, 'advertising', 'آژانس تبلیغاتی', 'Advertising Agency', 'وكالة الإعلان', '📢', 'bullhorn', '#3498DB', 10, 1, 1, 12, 'آژانس‌های تبلیغاتی و بازاریابی', 'Advertising and marketing agencies', 'وكالات الإعلان والتسويق', 1, '2025-04-24 09:28:47', '2025-05-16 04:24:15'),
(1301, 'museum', 'موزه', 'Museum', 'المتحف', '🏛️', 'landmark', '#E74C3C', 1, 1, 1, 13, 'موزه‌ها و گالری‌های تاریخی', 'Museums and historical galleries', 'المتاحف والمعارض التاريخية', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1302, 'historical_site', 'مکان تاریخی', 'Historical Site', 'الموقع التاريخي', '🏰', 'fort-awesome', '#C0392B', 2, 1, 1, 13, 'اماکن تاریخی و باستانی', 'Historical and ancient sites', 'المواقع التاريخية والأثرية', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1303, 'cultural_center', 'مرکز فرهنگی', 'Cultural Center', 'المركز الثقافي', '🎭', 'masks-theater', '#A93226', 3, 1, 1, 13, 'مراکز فرهنگی و هنری', 'Cultural and artistic centers', 'المراكز الثقافية والفنية', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1304, 'public_library', 'کتابخانه عمومی', 'Public Library', 'المكتبة العامة', '📚', 'book-open', '#922B21', 4, 1, 1, 13, 'کتابخانه‌های عمومی', 'Public libraries and reading spaces', 'المكتبات العامة ومساحات القراءة', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1305, 'monument', 'بنای یادبود', 'Monument', 'النصب التذكاري', '🗽', 'monument', '#4A235A', 8, 1, 1, 13, 'بناهای یادبود و مجسمه‌ها', 'Memorials and statues', 'النصب التذكارية والتماثيل', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1306, 'heritage_site', 'میراث فرهنگی', 'Heritage Site', 'الموقع التراثي', '🏺', 'landmark-dome', '#3B1E77', 9, 1, 1, 13, 'سایت‌های میراث فرهنگی', 'Cultural heritage sites', 'مواقع التراث الثقافي', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1317, 'cultural_festival', 'جشنواره فرهنگی', 'Cultural Festival', 'المهرجان الثقافي', '🎪', 'tent', '#2C1177', 10, 1, 1, 13, 'جشنواره‌ها و رویدادهای فرهنگی', 'Cultural festivals and events', 'المهرجانات الثقافية والفعاليات', 1, '2025-04-24 09:45:58', '2025-05-16 04:24:15'),
(1401, 'factory', 'کارخانه', 'Factory', 'المصنع', '🏭', 'industry', '#7F8C8D', 1, 1, 1, 14, 'کارخانه‌ها و واحدهای تولیدی', 'Factories and production units', 'المصانع ووحدات الإنتاج', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1402, 'industrial_zone', 'منطقه صنعتی', 'Industrial Zone', 'المنطقة الصناعية', '🏗️', 'helmet-safety', '#616A6B', 2, 1, 1, 14, 'مناطق و شهرک‌های صنعتی', 'Industrial zones and complexes', 'المناطق الصناعية والمجمعات', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1403, 'power_plant', 'نیروگاه', 'Power Plant', 'محطة الطاقة', '⚡', 'bolt', '#515A5A', 3, 1, 1, 14, 'نیروگاه‌ها و مراکز تولید انرژی', 'Power plants and energy production centers', 'محطات الطاقة ومراكز الإنتاج', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1404, 'oil_refinery', 'پالایشگاه', 'Oil Refinery', 'مصفاة النفط', '🛢️', 'oil-can', '#424949', 4, 1, 1, 14, 'پالایشگاه‌های نفت و گاز', 'Oil refineries and processing plants', 'مصافي النفط ومرافق التكرير', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1405, 'mine', 'معدن', 'Mine', 'المنجم', '⛏️', 'pickaxe', '#34495E', 5, 1, 1, 14, 'معدن‌ها و مراکز استخراج', 'Mines and extraction sites', 'المناجم ومواقع الاستخراج', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1406, 'construction_site', 'کارگاه ساختمانی', 'Construction Site', 'موقع البناء', '🏗️', 'hammer', '#2C3E50', 6, 1, 1, 14, 'کارگاه‌های ساختمانی', 'Construction sites and building projects', 'مواقع البناء والمشاريع', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1407, 'industrial_warehouse', 'انبار صنعتی', 'Industrial warehouse', 'المستودع الصناعي', '📦', 'boxes-stacked', '#1B2631', 7, 1, 1, 14, 'انبارهای صنعتی', 'Industrial warehouses and storage', 'المستودعات الصناعية والتخزين', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1408, 'water_treatment', 'تصفیه خانه', 'Water Treatment', 'محطة معالجة المياه', '💧', 'droplet', '#17202A', 8, 1, 1, 14, 'تصفیه خانه‌های آب و فاضلاب', 'Water treatment and purification plants', 'محطات معالجة المياه', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1409, 'recycling_center', 'مرکز بازیافت', 'Recycling Center', 'مركز إعادة التدوير', '♻️', 'recycle', '#0E0E10', 9, 1, 1, 14, 'مراکز بازیافت', 'Recycling centers and waste management', 'مراكز إعادة التدوير', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1410, 'manufacturing', 'کارگاه تولیدی', 'Manufacturing', 'الورشة الإنتاجية', '⚙️', 'gears', '#95A5A6', 10, 1, 1, 14, 'کارگاه‌های تولیدی کوچک', 'Small production workshops', 'الورش الإنتاجية الصغيرة', 1, '2025-04-24 09:54:42', '2025-05-16 04:24:15'),
(1501, 'car_repair', 'تعمیرگاه خودرو', 'Car Repair', 'تصليح السيارات', '🔧', 'screwdriver-wrench', '#2980B9', 1, 1, 1, 15, 'تعمیرگاه‌های تخصصی خودرو', 'Specialized car repair shops', 'ورش تصليح السيارات المتخصصة', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1502, 'car_wash', 'کارواش', 'Car Wash', 'غسيل السيارات', '🚿', 'car-side', '#1F618D', 2, 1, 1, 15, 'کارواش‌های خودرو و خدمات شستشو', 'Car wash and cleaning services', 'خدمات غسيل السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1503, 'tire_shop', 'لاستیک فروشی', 'Tire Shop', 'متجر الإطارات', '🛞', 'tire', '#154360', 3, 1, 1, 15, 'فروش و تعویض لاستیک و رینگ', 'Tire sales and replacement services', 'متاجر إطارات السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1504, 'auto_electric', 'برق خودرو', 'Auto Electric', 'كهرباء السيارات', '⚡', 'bolt', '#5DADE2', 4, 1, 1, 15, 'تعمیرات سیستم برق خودرو', 'Car electrical system repairs', 'خدمات كهرباء السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1505, 'auto_paint', 'نقاشی خودرو', 'Auto Painting', 'دهان السيارات', '🎨', 'spray-can', '#21618C', 5, 1, 1, 15, 'نقاشی و ترمیم بدنه خودرو', 'Car body painting and restoration', 'خدمات دهان السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1506, 'oil_change', 'تعویض روغن', 'Oil Change', 'تغيير الزيت', '🛢️', 'oil-can', '#1A5276', 6, 1, 1, 15, 'مراکز تعویض روغن و فیلتر', 'Oil change and filter replacement centers', 'مراكز تغيير الزيت والفلاتر', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1507, 'car_accessories', 'لوازم یدکی', 'Car Accessories', 'اكسسوارات السيارات', '🚘', 'car-rear', '#2874A6', 7, 1, 1, 15, 'فروش لوازم یدکی و تزئینات خودرو', 'Car accessories and spare parts stores', 'متاجر اكسسوارات السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1508, 'auto_glass', 'شیشه خودرو', 'Auto Glass', 'زجاج السيارات', '🚙', 'car-side', '#1B4F72', 8, 1, 1, 15, 'تعمیر و تعویض شیشه خودرو', 'Car glass repair and replacement', 'خدمات زجاج السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1509, 'car_diagnostic', 'دیاگ و عیب‌یابی', 'Car Diagnostic', 'تشخيص الأعطال', '📟', 'computer', '#85C1E9', 9, 1, 1, 15, 'مراکز دیاگ و عیب‌یابی کامپیوتری', 'Computerized car diagnostic centers', 'مراكز تشخيص أعطال السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1510, 'tow_truck', 'یدک‌کش و امداد', 'Tow Truck Service', 'خدمة السحب', '🛟', 'truck-pickup', '#3498DB', 10, 1, 1, 15, 'خدمات یدک‌کش و امداد خودرو', 'Towing and roadside assistance services', 'خدمات السحب والإسعاف', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1511, 'auto_insurance', 'بیمه خودرو', 'Auto Insurance', 'تأمين السيارات', '📄', 'file-contract', '#2C3E50', 11, 1, 1, 15, 'شرکت‌های بیمه خودرو', 'Car insurance companies', 'شركات تأمين السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1512, 'car_rental2', 'اجاره خودرو', 'Car Rental2', 'تأجير السيارات', '🚖', 'car-tunnel', '#1F618D', 12, 1, 1, 15, 'شرکت‌های اجاره خودرو', 'Car rental services', 'خدمات تأجير السيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1513, 'motorcycle_service', 'خدمات موتورسیکلت', 'Motorcycle Service', 'خدمات الدراجات النارية', '🏍️', 'motorcycle', '#154360', 13, 1, 1, 15, 'تعمیرگاه‌های موتورسیکلت', 'Motorcycle repair shops', 'ورش تصليح الدراجات النارية', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1514, 'car_inspection', 'معاینه فنی', 'Car Inspection', 'الفحص الفني', '🔍', 'magnifying-glass', '#5DADE2', 14, 1, 1, 15, 'مراکز معاینه فنی خودرو', 'Vehicle technical inspection centers', 'مراكز الفحص الفني للسيارات', 1, '2025-04-24 10:05:35', '2025-05-16 04:24:15'),
(1601, 'construction_company', 'شرکت ساختمانی', 'Construction Company', 'شركة البناء', '🏢', 'building-user', '#D35400', 1, 1, 1, 16, 'شرکت‌های پیمانکاری ساختمان', 'Building and construction companies', 'شركات البناء والتشييد', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1602, 'architect', 'معماری', 'Architecture', 'التصميم المعماري', '📐', 'ruler-combined', '#BA4A00', 2, 1, 1, 16, 'دفاتر معماری و طراحی ساختمان', 'Architecture and building design offices', 'مكاتب التصميم المعماري', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1603, 'interior_design', 'دکوراسیون داخلی', 'Interior Design', 'التصميم الداخلي', '🛋️', 'couch', '#A04000', 3, 1, 1, 16, 'خدمات دکوراسیون و طراحی داخلی', 'Interior decoration and design services', 'خدمات الديكور الداخلي', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1604, 'building_materials', 'مصالح ساختمانی', 'Building Materials', 'مواد البناء', '🧱', 'bricks', '#6E2C00', 4, 1, 1, 16, 'فروش مصالح ساختمانی', 'Building materials and supplies stores', 'متاجر مواد البناء', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1605, 'plumbing', 'لوله‌کشی', 'Plumbing', 'السباكة', '🚿', 'faucet', '#7B241C', 5, 1, 1, 16, 'خدمات لوله‌کشی و تأسیسات آب', 'Plumbing and water installation services', 'خدمات السباكة والتمديدات', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1606, 'electrical', 'برق ساختمان', 'Electrical', 'الكهرباء', '💡', 'lightbulb', '#922B21', 6, 1, 1, 16, 'خدمات برق و تأسیسات الکتریکی', 'Electrical and wiring services', 'خدمات الكهرباء والتمديدات', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1607, 'carpentry', 'نجاری', 'Carpentry', 'النجارة', '🪚', 'saw', '#641E16', 7, 1, 1, 16, 'خدمات نجاری و کار با چوب', 'Carpentry and woodworking services', 'خدمات النجارة والأخشاب', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1608, 'tiling', 'کاشی و سرامیک', 'Tiling', 'البلاط', '🧱', 'border-none', '#512E5F', 8, 1, 1, 16, 'خدمات کاشی‌کاری و سرامیک', 'Tiling and ceramic installation', 'خدمات البلاط والسيراميك', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1609, 'painting', 'نقاشی ساختمان', 'Painting', 'الدهان', '🎨', 'paint-roller', '#4A235A', 9, 1, 1, 16, 'خدمات رنگ‌آمیزی ساختمان', 'Building painting services', 'خدمات دهان المباني', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1610, 'elevator', 'آسانسور', 'Elevator', 'المصعد', '🛗', 'elevator', '#3B1E77', 10, 1, 1, 16, 'نصب و تعمیر آسانسور', 'Elevator installation and maintenance', 'خدمات تركيب المصاعد', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1611, 'insulation', 'عایق‌کاری', 'Insulation', 'العزل', '🧤', 'mitten', '#2C1177', 11, 1, 1, 16, 'خدمات عایق‌کاری ساختمان', 'Building insulation services', 'خدمات العزل الحراري', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1612, 'demolition', 'تخریب', 'Demolition', 'الهدم', '🏚️', 'house-crack', '#1A0677', 12, 1, 1, 16, 'خدمات تخریب ساختمان', 'Demolition and wrecking services', 'خدمات الهدم والتكسير', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1613, 'landscaping', 'محوطه‌سازی', 'Landscaping', 'تنسيق المواقع', '🌳', 'tree-city', '#1A237E', 13, 1, 1, 16, 'خدمات محوطه‌سازی و فضای سبز', 'Landscaping and outdoor space design', 'خدمات تنسيق الحدائق', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1614, 'concrete', 'بتن‌ریزی', 'Concrete', 'صب الخرسانة', '🏗️', 'cube', '#E67E22', 14, 1, 1, 16, 'خدمات بتن‌ریزی و اسکلت‌سازی', 'Concrete pouring and framework services', 'خدمات صب الخرسانة', 1, '2025-04-24 10:06:44', '2025-05-16 04:24:15'),
(1701, 'gas_station', 'پمپ بنزین', 'Gas Station', 'محطة البنزين', '⛽', 'gas-pump', '#F39C12', 1, 1, 1, 17, 'ایستگاه‌های سوخت بنزین و گازوئیل', 'Gasoline and diesel fuel stations', 'محطات وقود البنزين والديزل', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1702, 'cng_station', 'پمپ سی‌ان‌جی', 'CNG Station', 'محطة الغاز الطبيعي', '⛽', 'gas-pump', '#E67E22', 2, 1, 1, 17, 'ایستگاه‌های سوخت گاز طبیعی فشرده (CNG)', 'Compressed natural gas (CNG) stations', 'محطات الغاز الطبيعي المضغوط', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1703, 'lpg_station', 'پمپ گاز مایع', 'LPG Station', 'محطة الغاز المسال', '⛽', 'gas-pump', '#D35400', 3, 1, 1, 17, 'ایستگاه‌های سوخت گاز مایع (LPG)', 'Liquefied petroleum gas (LPG) stations', 'محطات الغاز المسال', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1704, 'charging_station', 'ایستگاه شارژ', 'Charging Station', 'محطة الشحن', '🔋', 'charging-station', '#27AE60', 4, 1, 1, 17, 'ایستگاه‌های شارژ خودروهای الکتریکی', 'Electric vehicle charging stations', 'محطات شحن السيارات الكهربائية', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1705, 'hydrogen_station', 'ایستگاه هیدروژن', 'Hydrogen Station', 'محطة الهيدروجين', '⚛️', 'atom', '#3498DB', 5, 1, 1, 17, 'ایستگاه‌های سوخت هیدروژنی', 'Hydrogen fuel stations', 'محطات وقود الهيدروجين', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1706, 'gas_cylinder', 'پرشدن کپسول گاز', 'Gas Cylinder', 'تعبئة اسطوانات الغاز', '🧯', 'fire-extinguisher', '#E74C3C', 6, 1, 1, 17, 'مراکز پرکردن کپسول گاز', 'Gas cylinder refilling centers', 'مراكز تعبئة اسطوانات الغاز', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1707, 'fuel_delivery', 'تحویل سوخت سیار', 'Fuel Delivery', 'توصيل الوقود', '🚚', 'truck-moving', '#9B59B6', 7, 1, 1, 17, 'خدمات تحویل سوخت در محل', 'Mobile fuel delivery services', 'خدمات توصيل الوقود', 1, '2025-04-24 10:15:31', '2025-05-16 04:24:15'),
(1801, 'womens_salon', 'آرایشگاه زنانه', 'Women\'s Salon', 'صالون نسائي', '💇‍♀️', 'person-dress', '#E91E63', 1, 1, 1, 18, 'سالن‌های زیبایی مخصوص بانوان', 'Beauty salons for women', 'صالونات التجميل للسيدات', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1802, 'mens_salon', 'آرایشگاه مردانه', 'Men\'s Salon', 'صالون رجالي', '💇‍♂️', 'person', '#2196F3', 2, 1, 1, 18, 'آرایشگاه‌های مخصوص آقایان', 'Barber shops for men', 'صالونات الحلاقة للرجال', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1803, 'unisex_salon', 'آرایشگاه عمومی', 'Unisex Salon', 'صالون عام', '💇', 'scissors', '#9C27B0', 3, 1, 1, 18, 'آرایشگاه‌های عمومی برای هر دو جنس', 'Unisex hair salons', 'صالونات التجميل العامة', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1804, 'spa', 'اسپا و ماساژ', 'Spa & Massage', 'السبا والمساج', '💆', 'spa', '#00BCD4', 4, 1, 1, 18, 'مراکز اسپا و ماساژ درمانی', 'Spa and massage therapy centers', 'مراكز السبا والمساج', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1805, 'nails', 'ناخن و مانیکور', 'Nails & Manicure', 'العناية بالأظافر', '💅', 'hand-sparkles', '#FF5722', 5, 1, 1, 18, 'سالن‌های ناخن و مانیکور', 'Nail care and manicure salons', 'صالونات العناية بالأظافر', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1806, 'barber', 'آرایشگاه سنتی', 'Barber Shop', 'الحلاقة التقليدية', '✂️', 'cut', '#795548', 6, 1, 1, 18, 'آرایشگاه‌های سنتی مردانه', 'Traditional barber shops', 'صالونات الحلاقة التقليدية', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15');
INSERT INTO `categories` (`id`, `category_key`, `category_fa`, `category_en`, `category_ar`, `emoji`, `font_icon`, `color`, `sort_order`, `show_in_menu`, `show_in_filters`, `parent_id`, `description_fa`, `description_en`, `description_ar`, `is_active`, `created_at`, `updated_at`) VALUES
(1807, 'cosmetics', 'سالن زیبایی', 'Cosmetic Salon', 'صالون التجميل', '💄', 'lipstick', '#FF4081', 7, 1, 1, 18, 'سالن‌های تخصصی آرایش و زیبایی', 'Cosmetic and makeup salons', 'صالونات التجميل والمكياج', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1808, 'hair_removal', 'اپیلاسیون', 'Hair Removal', 'إزالة الشعر', '🧖', 'hot-tub-person', '#673AB7', 8, 1, 1, 18, 'مراکز اپیلاسیون و لیزر موهای زائد', 'Hair removal and laser centers', 'مراكز إزالة الشعر بالليزر', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1809, 'tattoo', 'تاتو و پیرسینگ', 'Tattoo & Piercing', 'التاتو والثقب', '🖋️', 'pen-fancy', '#3F51B5', 9, 1, 1, 18, 'مراکز تاتو و پیرسینگ', 'Tattoo and piercing studios', 'استوديوهات الوشم والثقب', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1810, 'tanning', 'سالن برنزه', 'Tanning Salon', 'صالون التسمير', '🌞', 'sun', '#FF9800', 10, 1, 1, 18, 'سالن‌های برنزه کردن', 'Tanning salons and sunbeds', 'صالونات التسمير', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1811, 'bridal', 'آرایش عروس', 'Bridal Makeup', 'تجميل العروس', '👰', 'rings-wedding', '#E91E63', 11, 1, 1, 18, 'خدمات تخصصی آرایش عروس', 'Bridal makeup and styling services', 'خدمات تجميل العرائس', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15'),
(1812, 'barber_college', 'آموزشگاه آرایشگری', 'Barber College', 'مدرسة التجميل', '🎓', 'scissors', '#607D8B', 12, 1, 1, 18, 'آموزشگاه‌های آرایشگری و زیبایی', 'Beauty and barber training schools', 'مدارس التجميل والحلاقة', 1, '2025-04-24 10:16:40', '2025-05-16 04:24:15');

-- --------------------------------------------------------

--
-- Table structure for table `category_templates`
--

CREATE TABLE `category_templates` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `template_key` varchar(50) NOT NULL,
  `template_name` varchar(100) NOT NULL,
  `header_style` varchar(50) NOT NULL DEFAULT 'standard',
  `content_layout` varchar(50) NOT NULL DEFAULT 'default',
  `primary_color` varchar(20) NOT NULL DEFAULT '#4e73df',
  `secondary_color` varchar(20) NOT NULL DEFAULT '#f8f9fc',
  `icon_set` varchar(50) DEFAULT NULL,
  `background_image` varchar(255) DEFAULT NULL,
  `custom_css` text DEFAULT NULL,
  `custom_js` text DEFAULT NULL,
  `meta_fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Additional meta fields for the template' CHECK (json_valid(`meta_fields`)),
  `display_order` int(11) NOT NULL DEFAULT 10,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `parent_template_id` int(11) DEFAULT NULL,
  `template_type` enum('base','parent','child','custom','default') NOT NULL DEFAULT 'custom',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `features` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'لیست ماژول‌های فعال' CHECK (json_valid(`features`)),
  `custom_fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'فیلدهای سفارشی' CHECK (json_valid(`custom_fields`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `category_templates`
--

INSERT INTO `category_templates` (`id`, `category_id`, `template_key`, `template_name`, `header_style`, `content_layout`, `primary_color`, `secondary_color`, `icon_set`, `background_image`, `custom_css`, `custom_js`, `meta_fields`, `display_order`, `is_active`, `parent_template_id`, `template_type`, `created_at`, `updated_at`, `features`, `custom_fields`) VALUES
(1, 101, 'mall', 'مال', 'default', 'list', '#ff0000', '#ff00a2', 'vazir', NULL, NULL, NULL, NULL, 10, 1, NULL, 'child', '2025-04-27 08:30:49', '2025-05-20 17:06:43', '{\"booking\":{\"settings\":{\"enable_calendar\":\"1\",\"max_days\":null}},\"payment\":{\"settings\":{\"gateway\":\"zarinpal\"}},\"gallery\":{\"is_enabled\":\"1\"},\"comments\":{\"is_enabled\":\"1\"},\"map\":{\"settings\":{\"provider\":\"leaflet\"}},\"opening_hours\":{\"is_enabled\":\"1\"},\"social_media\":{\"is_enabled\":\"1\"},\"contact_form\":{\"is_enabled\":\"1\"},\"reviews\":{\"is_enabled\":\"1\"},\"related_items\":{\"is_enabled\":\"1\",\"settings\":{\"count\":\"5\"}},\"custom_fields\":{\"settings\":{\"fields\":\"\\u0638\\u0631\\u0641\\u06cc\\u062a\"}}}', NULL),
(2, 201, 'hotel', 'قالب هتل', 'standard', 'default', '#1a3c64', '#f8f9fc', 'fontawesome', NULL, NULL, NULL, NULL, 10, 1, NULL, 'child', '2025-04-27 08:30:49', '2025-05-20 16:01:30', NULL, NULL),
(3, 401, 'restaurant', 'قالب رستوران', 'standard', 'default', '#9c1f28', '#f8f9fc', 'fontawesome', NULL, NULL, NULL, NULL, 10, 1, NULL, 'child', '2025-04-27 08:30:50', '2025-05-20 16:01:30', NULL, NULL),
(4, 5, 'attraction', 'قالب جاذبه گردشگری', 'standard', 'default', '#1e7145', '#f8f9fc', 'fontawesome', NULL, NULL, NULL, NULL, 10, 1, NULL, 'parent', '2025-04-27 08:30:50', '2025-05-20 16:01:30', NULL, NULL),
(6, 101, 'تست', 'تست', 'default', 'default', '#0d6efd', '#6c757d', 'fontawesome', NULL, NULL, NULL, NULL, 10, 1, NULL, 'default', '2025-05-22 07:35:46', '2025-05-22 07:35:46', '[\"payment\",\"gallery\",\"comments\"]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `category_template_settings`
--

CREATE TABLE `category_template_settings` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL COMMENT 'شناسه دسته‌بندی',
  `template_id` int(11) NOT NULL COMMENT 'شناسه قالب',
  `feature_id` int(11) NOT NULL COMMENT 'شناسه ویژگی',
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'وضعیت فعال بودن ویژگی',
  `display_order` int(11) NOT NULL DEFAULT 0 COMMENT 'ترتیب نمایش',
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات خاص ویژگی' CHECK (json_valid(`settings`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category_translations`
--

CREATE TABLE `category_translations` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL COMMENT 'شناسه دسته‌بندی',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `name` varchar(100) NOT NULL COMMENT 'نام دسته‌بندی در این زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات دسته‌بندی در این زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_reactions`
--

CREATE TABLE `comment_reactions` (
  `id` int(11) NOT NULL,
  `comment_id` int(11) NOT NULL COMMENT 'شناسه نظر',
  `user_ip` varchar(45) NOT NULL COMMENT 'آدرس IP کاربر',
  `user_agent` text DEFAULT NULL COMMENT 'اطلاعات مرورگر',
  `reaction_type` enum('like','dislike','love','angry','laugh') NOT NULL COMMENT 'نوع واکنش',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول واکنش‌های کاربران به نظرات';

-- --------------------------------------------------------

--
-- Table structure for table `content_type_translations`
--

CREATE TABLE `content_type_translations` (
  `id` int(11) NOT NULL,
  `content_type_id` int(11) NOT NULL COMMENT 'شناسه نوع محتوا',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `type_name` varchar(100) NOT NULL COMMENT 'نام نوع محتوا در این زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات نوع محتوا در این زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `display_settings`
--

CREATE TABLE `display_settings` (
  `id` int(11) NOT NULL,
  `page_key` varchar(50) NOT NULL COMMENT 'کلید صفحه',
  `section_key` varchar(50) NOT NULL COMMENT 'کلید بخش',
  `desktop_items` int(11) NOT NULL DEFAULT 9 COMMENT 'تعداد آیتم‌های نمایشی در دسکتاپ',
  `mobile_items` int(11) NOT NULL DEFAULT 9 COMMENT 'تعداد آیتم‌های نمایشی در موبایل',
  `load_more_text` varchar(100) DEFAULT 'نمایش بیشتر' COMMENT 'متن دکمه نمایش بیشتر',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `hero_section` tinyint(1) NOT NULL DEFAULT 1,
  `featured_section` tinyint(1) NOT NULL DEFAULT 1,
  `categories_section` tinyint(1) NOT NULL DEFAULT 1,
  `latest_section` tinyint(1) NOT NULL DEFAULT 1,
  `popular_section` tinyint(1) NOT NULL DEFAULT 1,
  `map_section` tinyint(1) NOT NULL DEFAULT 1,
  `sidebar_position` varchar(10) NOT NULL DEFAULT 'right',
  `items_per_page` int(11) NOT NULL DEFAULT 12,
  `show_ratings` tinyint(1) NOT NULL DEFAULT 1,
  `show_comments` tinyint(1) NOT NULL DEFAULT 1,
  `show_share_buttons` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `display_settings`
--

INSERT INTO `display_settings` (`id`, `page_key`, `section_key`, `desktop_items`, `mobile_items`, `load_more_text`, `is_active`, `hero_section`, `featured_section`, `categories_section`, `latest_section`, `popular_section`, `map_section`, `sidebar_position`, `items_per_page`, `show_ratings`, `show_comments`, `show_share_buttons`, `created_at`, `updated_at`) VALUES
(1, 'homepage', 'below_map', 6, 6, NULL, 1, 1, 1, 1, 1, 1, 1, 'right', 12, 1, 1, 1, '2025-05-08 13:50:50', '2025-05-16 10:38:11');

-- --------------------------------------------------------

--
-- Table structure for table `display_zones`
--

CREATE TABLE `display_zones` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `zone_key` varchar(255) NOT NULL,
  `zone_name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `max_desktop_cards` int(11) NOT NULL DEFAULT 4,
  `max_mobile_cards` int(11) NOT NULL DEFAULT 2,
  `card_layout` varchar(255) NOT NULL DEFAULT 'grid',
  `display_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_by` bigint(20) UNSIGNED DEFAULT NULL,
  `updated_by` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `display_zones`
--

INSERT INTO `display_zones` (`id`, `zone_key`, `zone_name`, `description`, `position`, `max_desktop_cards`, `max_mobile_cards`, `card_layout`, `display_order`, `is_active`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(1, 'homepage_diamond', 'Homepage Diamond Zone', 'Special zone for homepage diamond advertisements', 'homepage', 1, 1, 'diamond', 1, 1, NULL, NULL, '2025-05-08 04:04:05', '2025-05-08 04:04:05');

-- --------------------------------------------------------

--
-- Table structure for table `dynamic_translations`
--

CREATE TABLE `dynamic_translations` (
  `id` int(11) NOT NULL,
  `namespace` varchar(50) NOT NULL DEFAULT '*',
  `group` varchar(50) NOT NULL DEFAULT '*',
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `language_code` varchar(5) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `header_settings`
--

CREATE TABLE `header_settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(50) NOT NULL COMMENT 'کلید تنظیم',
  `setting_value` text DEFAULT NULL COMMENT 'مقدار تنظیم',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تنظیمات هدر سایت';

--
-- Dumping data for table `header_settings`
--

INSERT INTO `header_settings` (`id`, `setting_key`, `setting_value`, `language_code`, `description`, `is_active`, `created_at`, `updated_at`) VALUES
(113, 'site_logo', '/images/logo.png', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(114, 'site_title', 'اَلو ایران', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(115, 'show_search_box', '0', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 05:56:11'),
(116, 'search_placeholder', 'جستجو در مکان‌ها...', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(117, 'show_language_switcher', '1', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(118, 'show_user_menu', '1', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(119, 'header_style', 'default', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(120, 'sticky_header', '1', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(121, 'show_breadcrumb', '0', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 05:56:11'),
(122, 'login_text', 'ورود', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(123, 'logout_text', 'خروج', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(124, 'add_location_text', 'ثبت مکان جدید', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(125, 'add_location_url', '/user/locations/create', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(126, 'show_add_location_button', '1', 'fa', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(127, 'site_logo', '/images/logo.png', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(128, 'site_title', 'Alo Iran', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(129, 'show_search_box', '1', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(130, 'search_placeholder', 'Search locations...', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(131, 'show_language_switcher', '1', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(132, 'show_user_menu', '1', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(133, 'header_style', 'default', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(134, 'sticky_header', '1', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(135, 'show_breadcrumb', '1', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(136, 'login_text', 'Login', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(137, 'logout_text', 'Logout', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(138, 'add_location_text', 'Add New Location', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(139, 'add_location_url', '/user/locations/create', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(140, 'show_add_location_button', '1', 'en', NULL, 1, '2025-06-03 09:16:55', '2025-06-03 09:16:55'),
(155, 'site_logo', '/images/logo.png', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(156, 'site_title', 'ألو إيران', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(157, 'show_search_box', '0', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:48:04'),
(158, 'search_placeholder', 'البحث في المواقع...', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(159, 'show_language_switcher', '1', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(160, 'show_user_menu', '1', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(161, 'header_style', 'default', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(162, 'sticky_header', '1', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(163, 'show_breadcrumb', '1', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(164, 'login_text', 'تسجيل الدخول', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(165, 'logout_text', 'تسجيل الخروج', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(166, 'add_location_text', 'إضافة موقع جديد', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(167, 'add_location_url', '/user/locations/create', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57'),
(168, 'show_add_location_button', '1', 'ar', NULL, 1, '2025-06-03 05:47:57', '2025-06-03 05:47:57');

-- --------------------------------------------------------

--
-- Table structure for table `header_settings_backup`
--

CREATE TABLE `header_settings_backup` (
  `id` int(11) NOT NULL DEFAULT 0,
  `setting_key` varchar(50) NOT NULL COMMENT 'کلید تنظیم',
  `setting_value` text DEFAULT NULL COMMENT 'مقدار تنظیم',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `header_settings_backup`
--

INSERT INTO `header_settings_backup` (`id`, `setting_key`, `setting_value`, `language_code`, `description`, `is_active`, `created_at`, `updated_at`) VALUES
(29, 'site_logo', '/images/logo.png', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(30, 'site_title', 'اَلو ایران', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(31, 'show_search_box', '1', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(32, 'search_placeholder', 'جستجو در مکان‌ها...', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(33, 'show_language_switcher', '1', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(34, 'show_user_menu', '1', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(35, 'header_style', 'default', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(36, 'sticky_header', '1', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(37, 'show_breadcrumb', '1', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(38, 'login_text', 'ورود', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(39, 'logout_text', 'خروج', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(40, 'add_location_text', 'ثبت مکان جدید', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(41, 'add_location_url', '/add-place', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45'),
(42, 'show_add_location_button', '1', 'fa', NULL, 1, '2025-06-03 04:53:45', '2025-06-03 04:53:45');

-- --------------------------------------------------------

--
-- Table structure for table `header_settings_backup_multilingual`
--

CREATE TABLE `header_settings_backup_multilingual` (
  `id` int(11) NOT NULL DEFAULT 0,
  `setting_key` varchar(50) NOT NULL COMMENT 'کلید تنظیم',
  `setting_value` text DEFAULT NULL COMMENT 'مقدار تنظیم',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `header_settings_backup_multilingual`
--

INSERT INTO `header_settings_backup_multilingual` (`id`, `setting_key`, `setting_value`, `language_code`, `description`, `is_active`, `created_at`, `updated_at`) VALUES
(99, 'site_logo', '/images/logo.png', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(100, 'site_title', 'اَلو ایران', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(101, 'show_search_box', '0', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:08:46'),
(102, 'search_placeholder', 'جستجو در مکان‌ها...', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(103, 'show_language_switcher', '1', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(104, 'show_user_menu', '1', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(105, 'header_style', 'default', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(106, 'sticky_header', '1', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(107, 'show_breadcrumb', '0', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:31:17'),
(108, 'login_text', 'ورود', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(109, 'logout_text', 'خروج', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(110, 'add_location_text', 'ثبت مکان جدید', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(111, 'add_location_url', '/user/locations/create', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56'),
(112, 'show_add_location_button', '1', 'fa', NULL, 1, '2025-06-03 05:07:56', '2025-06-03 05:07:56');

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) UNSIGNED NOT NULL,
  `reserved_at` int(10) UNSIGNED DEFAULT NULL,
  `available_at` int(10) UNSIGNED NOT NULL,
  `created_at` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `id` int(11) NOT NULL,
  `code` varchar(5) NOT NULL COMMENT 'کد زبان (fa, en, ar)',
  `name` varchar(50) NOT NULL COMMENT 'نام زبان به زبان خودش',
  `native_name` varchar(50) NOT NULL COMMENT 'نام زبان به زبان‌های دیگر',
  `flag` varchar(50) DEFAULT NULL COMMENT 'پرچم کشور مربوط به زبان',
  `direction` enum('ltr','rtl') NOT NULL DEFAULT 'ltr' COMMENT 'جهت متن',
  `date_format` varchar(20) DEFAULT 'Y-m-d' COMMENT 'قالب تاریخ',
  `time_format` varchar(20) DEFAULT 'H:i:s' COMMENT 'قالب زمان',
  `is_default` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'زبان پیش‌فرض',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'وضعیت فعال',
  `order` int(11) DEFAULT 10,
  `locale` varchar(10) DEFAULT NULL COMMENT 'Locale code (e.g. fa_IR)',
  `currency_code` varchar(3) DEFAULT NULL COMMENT 'Default currency code',
  `number_format` varchar(50) DEFAULT NULL COMMENT 'Number format pattern',
  `first_day_of_week` tinyint(1) DEFAULT 0 COMMENT 'First day of week (0=Sunday)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` (`id`, `code`, `name`, `native_name`, `flag`, `direction`, `date_format`, `time_format`, `is_default`, `is_active`, `order`, `locale`, `currency_code`, `number_format`, `first_day_of_week`, `created_at`, `updated_at`) VALUES
(1, 'fa', 'فارسی', 'فارسی', NULL, 'rtl', 'Y-m-d', 'H:i:s', 1, 1, 2, 'fa_IR', NULL, NULL, 0, '2025-05-08 05:18:13', '2025-05-16 20:24:04'),
(2, 'en', 'English', 'انگلیسی', NULL, 'ltr', 'Y-m-d', 'H:i:s', 0, 1, 1, NULL, NULL, NULL, 0, '2025-05-08 05:25:22', '2025-05-16 20:24:04'),
(3, 'ar', 'العربية', 'العربية', NULL, 'rtl', 'Y-m-d', 'H:i:s', 0, 1, 3, NULL, NULL, NULL, 0, '2025-05-15 22:57:55', '2025-05-16 02:56:43');

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE `locations` (
  `id` int(11) NOT NULL,
  `title_id` varchar(50) NOT NULL,
  `category` varchar(50) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `category_fa` varchar(50) NOT NULL,
  `title` varchar(255) NOT NULL,
  `ad_package` varchar(20) DEFAULT NULL,
  `ad_expiry` date DEFAULT NULL,
  `display_until` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `Slogan` varchar(255) DEFAULT NULL,
  `lat` decimal(10,7) DEFAULT NULL,
  `lng` decimal(10,7) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `open_hours` varchar(100) DEFAULT NULL,
  `closing_hours` varchar(100) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `county_id` int(11) DEFAULT NULL,
  `district_id` int(11) DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `village_id` int(11) DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `tags` varchar(250) DEFAULT NULL,
  `images` text DEFAULT NULL,
  `amenities` text DEFAULT NULL,
  `star_rating` smallint(6) DEFAULT NULL,
  `emoji` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `user_id` int(10) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `package_type` enum('regular','bronze','silver','gold','diamond') NOT NULL DEFAULT 'regular',
  `package_expires_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locations`
--

INSERT INTO `locations` (`id`, `title_id`, `category`, `category_id`, `category_fa`, `title`, `ad_package`, `ad_expiry`, `display_until`, `description`, `Slogan`, `lat`, `lng`, `url`, `phone`, `open_hours`, `closing_hours`, `country_id`, `province_id`, `county_id`, `district_id`, `city_id`, `village_id`, `zone_id`, `address`, `tags`, `images`, `amenities`, `star_rating`, `emoji`, `is_active`, `user_id`, `created_at`, `updated_at`, `package_type`, `package_expires_at`) VALUES
(1, 'bazar-syty-sntr-1-kshm-1745706020', 'mall', 101, 'مرکز خرید (مال)', 'بازار سیتی سنتر 1 قشم', NULL, NULL, NULL, 'توضیحات', 'شعار', 26.9391066, 56.2741358, 'http://127.0.0.1:8000/fa/shopping_centers/mall/bazar-starh-kshm-1745924593', '0998', '10', '18', 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, 3, '2025-04-26 18:50:20', '2025-05-29 17:08:37', 'diamond', '2025-04-29 20:30:00'),
(2, 'bazar-syty-sntr-2-kshm-1745924321', 'mall', 101, 'مرکز خرید (مال)', 'بازار سیتی سنتر 2 قشم', NULL, NULL, NULL, NULL, NULL, 26.9384562, 56.2745660, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:28:41', '2025-04-29 07:28:41', 'regular', NULL),
(3, 'bazar-starh-kshm-1745924593', 'mall', 101, 'مرکز خرید (مال)', 'بازار ستاره قشم', NULL, NULL, NULL, 'توضیحات\r\nدیتابیس', 'اولین مال قشم', 26.9500193, 56.2737152, 'hhtps://moeid.ir', '09981100998', '07:00', '22:00', 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', 'ستاره, بازار, قشم', '[\"locations\\/bazar-starh-kshm-1745924593\\/HID09V1ffSuTpccdTMGFPTOyvShFPSGxEDCGbjbZ.jpg\"]', 'امکانات\n2\n3', 5, NULL, 1, NULL, '2025-04-29 07:33:13', '2025-05-30 05:46:34', 'regular', NULL),
(4, 'bazar-zyton-kshm-1745924929', 'mall', 101, 'مرکز خرید (مال)', 'بازار زیتون قشم', NULL, NULL, NULL, NULL, NULL, 26.9460598, 56.2744309, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:38:49', '2025-04-29 07:38:49', 'regular', NULL),
(5, 'bazar-almas-mal-kshm-1745925052', 'mall', 101, 'مرکز خرید (مال)', 'بازار الماس مال قشم', NULL, NULL, NULL, NULL, NULL, 26.9474650, 56.2742364, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:40:52', '2025-04-29 07:40:52', 'regular', NULL),
(6, 'bazar-frdosy-kshm-1745925135', 'mall', 101, 'مرکز خرید (مال)', 'بازار فردوسی قشم', NULL, NULL, NULL, NULL, NULL, 26.9513821, 56.2735621, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:42:15', '2025-04-29 07:42:15', 'regular', NULL),
(7, 'bazar-prdys-kshm-1745925200', 'mall', 101, 'مرکز خرید (مال)', 'بازار پردیس قشم', NULL, NULL, NULL, NULL, NULL, 26.9508370, 56.2732398, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:43:20', '2025-04-29 07:43:20', 'regular', NULL),
(8, 'bazar-maarag-kshm-1745925313', 'mall', 101, 'مرکز خرید (مال)', 'بازار معراج قشم', NULL, NULL, NULL, NULL, NULL, 26.9640094, 56.2731904, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:45:13', '2025-04-29 07:45:13', 'regular', NULL),
(9, 'bazar-khlyg-fars-kshm-1745925449', 'mall', 101, 'مرکز خرید (مال)', 'بازار خلیج فارس قشم', NULL, NULL, NULL, NULL, NULL, 26.9494734, 56.2738341, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:47:29', '2025-04-29 07:47:29', 'regular', NULL),
(10, 'bazar-amyn-kshm-1745925533', 'mall', 101, 'مرکز خرید (مال)', 'بازار امین قشم', NULL, NULL, NULL, NULL, NULL, 26.9402297, 56.2750679, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:48:53', '2025-04-29 07:48:53', 'regular', NULL),
(11, 'bazar-mylad-kshm-1745925729', 'mall', 101, 'مرکز خرید (مال)', 'بازار میلاد قشم', NULL, NULL, NULL, NULL, NULL, 26.9509709, 56.2723603, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:52:10', '2025-04-29 07:52:10', 'regular', NULL),
(12, 'bazar-tap-aylnd-kshm-1745925814', 'mall', 101, 'مرکز خرید (مال)', 'بازار تاپ آیلند قشم', NULL, NULL, NULL, NULL, NULL, 26.9479631, 56.2721012, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:53:34', '2025-04-29 07:53:34', 'regular', NULL),
(13, 'bazar-kdym-kshm-1745926019', 'bazaar', 102, 'بازار سنتی', 'بازار قدیم قشم', NULL, NULL, NULL, NULL, NULL, 26.9617151, 56.2714217, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:56:59', '2025-04-29 07:56:59', 'regular', NULL),
(14, 'bazar-symrgh-kshm-1745926192', 'mall', 101, 'مرکز خرید (مال)', 'بازار سیمرغ قشم', NULL, NULL, NULL, NULL, NULL, 26.9414738, 56.2740563, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 07:59:52', '2025-04-29 07:59:52', 'regular', NULL),
(15, 'asklh-msafrbry-thakry-kshm-1745926400', 'port', 710, 'بندر', 'اسکله مسافربری ذاکری قشم', NULL, NULL, NULL, NULL, NULL, 26.9649465, 56.2726700, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:03:20', '2025-04-29 08:03:20', 'regular', NULL),
(16, 'frodgah-byn-almlly-dyrstan-1745926709', 'airport', 701, 'فرودگاه', 'فرودگاه بین المللی دیرستان', NULL, NULL, NULL, NULL, NULL, 26.7560819, 55.8944571, NULL, NULL, NULL, NULL, 1, 22, 4, 1, 1, 2, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:08:29', '2025-04-29 08:12:43', 'regular', NULL),
(17, 'asklh-bndr-laft-1745926843', 'port', 710, 'بندر', 'اسکله بندر لافت', NULL, NULL, NULL, NULL, NULL, 26.9516642, 55.7523170, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 5, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، لافت', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:10:43', '2025-04-29 08:10:43', 'regular', NULL),
(18, 'bazar-zyton-rmkan-1745927129', 'mall', 101, 'مرکز خرید (مال)', 'بازار زیتون رمکان', NULL, NULL, NULL, NULL, NULL, 26.8707705, 56.0377038, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:15:29', '2025-04-29 08:15:29', 'regular', NULL),
(19, 'bazar-starh-rmkan-1745927198', 'mall', 101, 'مرکز خرید (مال)', 'بازار ستاره رمکان', NULL, NULL, NULL, NULL, NULL, 26.8704594, 56.0382876, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:16:38', '2025-04-29 08:16:38', 'regular', NULL),
(20, 'bazar-royal-rmkan-1745927322', 'mall', 101, 'مرکز خرید (مال)', 'بازار رویال رمکان', NULL, NULL, NULL, NULL, NULL, 26.8675165, 56.0394056, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:18:42', '2025-04-29 08:18:42', 'regular', NULL),
(21, 'pmp-bnzyn-rmkan-1745927977', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین رمکان', NULL, NULL, NULL, NULL, NULL, 26.8866228, 56.0384609, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:29:37', '2025-04-29 08:29:37', 'regular', NULL),
(22, 'pmp-bnzyn-gyahdan-1745928152', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین گیاهدان', NULL, NULL, NULL, NULL, NULL, 26.9183924, 56.0652410, NULL, NULL, NULL, NULL, 1, 22, 4, 2, NULL, 25, NULL, 'ایران، هرمزگان، قشم، مركزی، گیاهدان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:32:32', '2025-04-29 08:32:32', 'regular', NULL),
(23, 'gaygah-sokht-sy-an-gy-cng-1745928305', 'cng_station', 1702, 'پمپ سی‌ان‌جی', 'جایگاه سوخت سی ان جی CNG', NULL, NULL, NULL, NULL, NULL, 26.9553557, 56.0817017, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 6, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، درگهان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:35:05', '2025-04-29 08:35:05', 'regular', NULL),
(24, 'pmp-bnzyn-drghan-1745928512', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین درگهان', NULL, NULL, NULL, NULL, NULL, 26.9531889, 56.0691118, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 6, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، درگهان', 'بنزین، گازوئیل', '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:38:32', '2025-04-29 08:38:32', 'regular', NULL),
(25, 'pmp-bnzyn-syar-drghan-1745928652', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین سیار درگهان', NULL, NULL, NULL, NULL, NULL, 26.9614712, 56.0522961, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 6, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، درگهان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:40:52', '2025-04-29 08:40:52', 'regular', NULL),
(26, 'pmp-bnzyn-rmchah-1745928998', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین رمچاه', NULL, NULL, NULL, NULL, NULL, 26.9010616, 56.1600031, NULL, NULL, NULL, NULL, 1, 22, 4, 2, NULL, 22, NULL, 'ایران، هرمزگان، قشم، مركزی، رمچاه', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:46:38', '2025-04-29 08:48:28', 'regular', NULL),
(27, 'pmp-bnzyn-kshm-1745929266', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین قشم', NULL, NULL, NULL, NULL, NULL, 26.9753213, 56.2369162, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:51:06', '2025-04-29 08:51:06', 'regular', NULL),
(28, 'pmp-bnzyn-kshm-1745929383', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین پارک زیتون قشم', NULL, NULL, NULL, NULL, NULL, 26.9356919, 56.2694676, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 3, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، قشم', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 08:53:03', '2025-04-29 08:53:36', 'regular', NULL),
(29, 'pmp-bnzyn-laft-1745930232', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین لافت', NULL, NULL, NULL, NULL, NULL, 26.9401395, 55.7506657, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 5, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، لافت', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:07:12', '2025-04-29 09:07:12', 'regular', NULL),
(30, 'pmp-bnzyn-tmban-1745930408', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین تمبان', NULL, NULL, NULL, NULL, NULL, 26.7658444, 55.8698496, NULL, NULL, NULL, NULL, 1, 22, 4, 2, NULL, 14, NULL, 'ایران، هرمزگان، قشم، مركزی، تمبان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:10:08', '2025-04-29 09:10:08', 'regular', NULL),
(31, 'pmp-bnzyn-soza-1745930728', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین سوزا', NULL, NULL, NULL, NULL, NULL, 26.7880290, 56.0670290, NULL, NULL, NULL, NULL, 1, 22, 4, 1, 1, NULL, NULL, 'ایران، هرمزگان، قشم، شهاب، سوزا', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:15:28', '2025-04-29 09:15:28', 'regular', NULL),
(32, 'pmp-bnzyn-basaaydo-1745931180', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین باسعیدو', NULL, NULL, NULL, NULL, NULL, 26.6563771, 55.2825600, NULL, NULL, NULL, NULL, 1, 22, 4, 3, NULL, 56, NULL, 'ایران، هرمزگان، قشم، حرا، باسعیدو', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:23:00', '2025-04-29 09:23:00', 'regular', NULL),
(33, 'pmp-bnzyn-hra-1745931534', 'gas_station', 1701, 'پمپ بنزین', 'پمپ بنزین حرا', NULL, NULL, NULL, NULL, NULL, 26.7582901, 55.7011074, NULL, NULL, NULL, NULL, 1, 22, 4, 3, 7, 64, NULL, 'ایران، هرمزگان، قشم، حرا، ملکی', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:28:54', '2025-04-29 09:28:54', 'regular', NULL),
(34, 'bazar-arslan-laft-1745931770', 'mall', 101, 'مرکز خرید (مال)', 'بازار ارسلان لافت', NULL, NULL, NULL, NULL, NULL, 26.9384745, 55.7500900, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 5, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، لافت', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:32:50', '2025-04-29 09:32:50', 'regular', NULL),
(35, 'bazar-myaaad-laft-1745931891', 'mall', 101, 'مرکز خرید (مال)', 'بازار میعاد لافت', NULL, NULL, NULL, NULL, NULL, 26.9447735, 55.7635085, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 5, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، لافت', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:34:51', '2025-04-29 09:34:51', 'regular', NULL),
(36, 'msgd-amam-gaafr-sadk-aa-1745933124', 'mosque', 901, 'مسجد', 'مسجد امام جعفر صادق (ع) رمکان', NULL, NULL, NULL, NULL, NULL, 26.8732635, 56.0376517, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:55:24', '2025-04-29 09:58:48', 'regular', NULL),
(37, 'msgd-aamr-bn-khtab-rmkan-1745933304', 'mosque', 901, 'مسجد', 'مسجد عمر بن خطاب رمکان', NULL, NULL, NULL, NULL, NULL, 26.8715067, 56.0430086, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 09:58:24', '2025-04-29 09:58:24', 'regular', NULL),
(38, 'msgd-aaly-bn-aby-talb-rmkan-1745933424', 'mosque', 901, 'مسجد', 'مسجد علی بن ابی طالب رمکان', NULL, NULL, NULL, NULL, NULL, 26.8720043, 56.0460985, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:00:24', '2025-04-29 10:00:24', 'regular', NULL),
(39, 'msgd-shhrk-karkhanh-syman-rmkan-1745933515', 'mosque', 901, 'مسجد', 'مسجد شهرک کارخانه سیمان رمکان', NULL, NULL, NULL, NULL, NULL, 26.8776753, 56.0456234, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:01:55', '2025-04-29 10:01:55', 'regular', NULL),
(40, 'msgd-hsn-bn-aaly-1745933843', 'mosque', 901, 'مسجد', 'مسجد حسن بن علی', NULL, NULL, NULL, NULL, NULL, 26.8687320, 56.0385361, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:07:23', '2025-04-29 10:07:23', 'regular', NULL),
(41, 'msgd-hag-mosy-rmkan-1745933973', 'mosque', 901, 'مسجد', 'مسجد حاج موسی رمکان', NULL, NULL, NULL, NULL, NULL, 26.8656016, 56.0383845, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:09:33', '2025-04-29 10:09:33', 'regular', NULL),
(42, 'msgd-ktba-rmkan-1745934051', 'mosque', 901, 'مسجد', 'مسجد قطبا رمکان', NULL, NULL, NULL, NULL, NULL, 26.8639753, 56.0364268, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:10:51', '2025-04-29 10:10:51', 'regular', NULL),
(43, 'msgd-aathman-bn-aafan-1745934165', 'mosque', 901, 'مسجد', 'مسجد عثمان بن عفان', NULL, NULL, NULL, NULL, NULL, 26.8620371, 56.0376671, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:12:45', '2025-04-29 10:12:45', 'regular', NULL),
(44, 'msgd-gamaa-rmkan-1745934254', 'mosque', 901, 'مسجد', 'مسجد جامع رمکان', NULL, NULL, NULL, NULL, NULL, 26.8588020, 56.0357841, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:14:14', '2025-04-29 10:14:14', 'regular', NULL),
(45, 'msgd-blal-rmkan-1745934450', 'mosque', 901, 'مسجد', 'مسجد بلال رمکان', NULL, NULL, NULL, NULL, NULL, 26.8676520, 56.0413600, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:17:30', '2025-04-29 10:17:30', 'regular', NULL),
(46, 'msgd-hag-hsyn-asmaaayl-1745934567', 'mosque', 901, 'مسجد', 'مسجد حاج حسین اسماعیل رمکان', NULL, NULL, NULL, NULL, NULL, 26.8752950, 56.0421090, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:19:27', '2025-04-29 10:19:45', 'regular', NULL),
(47, 'msgd-khald-bn-olyd-rmkan-1745934776', 'mosque', 901, 'مسجد', 'مسجد خالد بن ولید رمکان', NULL, NULL, NULL, NULL, NULL, 26.8603662, 56.0340500, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:22:56', '2025-04-29 10:22:56', 'regular', NULL),
(48, 'msgd-hag-mhmd-shryf-salhy-rmkan-1745934977', 'mosque', 901, 'مسجد', 'مسجد حاج محمد شریف صالحی رمکان', NULL, NULL, NULL, NULL, NULL, 26.8579840, 56.0299390, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:26:17', '2025-04-29 10:26:17', 'regular', NULL),
(49, 'msgd-shrayy-rmkan-1745935734', 'mosque', 901, 'مسجد', 'مسجد صحرایی رمکان', NULL, NULL, NULL, NULL, NULL, 26.8660370, 56.0352450, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:38:54', '2025-04-29 10:38:54', 'regular', NULL),
(50, 'msgd-syd-kmal-rmkan-1745935785', 'mosque', 901, 'مسجد', 'مسجد سید کمال رمکان', NULL, NULL, NULL, NULL, NULL, 26.8646213, 56.0409605, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 10:39:45', '2025-04-29 10:39:45', 'regular', NULL),
(51, 'msgd-pmp-bnzyn-rmkan-1745937013', 'mosque', 901, 'مسجد', 'مسجد پمپ بنزین رمکان', NULL, NULL, NULL, NULL, NULL, 26.8863158, 56.0387010, NULL, NULL, NULL, NULL, 1, 22, 4, 2, 4, NULL, NULL, 'ایران، هرمزگان، قشم، مركزی، رمكان', NULL, '[]', NULL, NULL, NULL, 1, NULL, '2025-04-29 11:00:13', '2025-04-29 11:00:13', 'regular', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `location_ad_packages`
--

CREATE TABLE `location_ad_packages` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL COMMENT 'شناسه مکان',
  `package_id` int(11) NOT NULL COMMENT 'شناسه پکیج',
  `start_date` date NOT NULL COMMENT 'تاریخ شروع',
  `end_date` date NOT NULL COMMENT 'تاریخ پایان',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'وضعیت فعال',
  `payment_status` enum('pending','paid','failed','refunded') NOT NULL DEFAULT 'pending' COMMENT 'وضعیت پرداخت',
  `payment_amount` decimal(10,2) DEFAULT NULL COMMENT 'مبلغ پرداختی',
  `payment_date` datetime DEFAULT NULL COMMENT 'تاریخ پرداخت',
  `payment_ref` varchar(100) DEFAULT NULL COMMENT 'شناسه پرداخت',
  `display_priority` int(11) DEFAULT 10 COMMENT 'اولویت نمایش در گروه همسان',
  `geographic_scope` enum('global','country','province','county','city','district','zone') DEFAULT NULL COMMENT 'محدوده جغرافیایی',
  `geo_id` int(11) DEFAULT NULL COMMENT 'شناسه منطقه جغرافیایی',
  `category_id` int(11) DEFAULT NULL COMMENT 'شناسه دسته‌بندی محدودیت',
  `custom_badge_text` varchar(50) DEFAULT NULL COMMENT 'متن سفارشی نشان',
  `custom_badge_color` varchar(20) DEFAULT NULL COMMENT 'رنگ سفارشی نشان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول اختصاص پکیج‌های تبلیغاتی به مکان‌ها';

-- --------------------------------------------------------

--
-- Table structure for table `location_amenities`
--

CREATE TABLE `location_amenities` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL COMMENT 'شناسه مکان',
  `amenity_id` int(11) NOT NULL COMMENT 'شناسه امکان',
  `value` varchar(255) DEFAULT NULL COMMENT 'مقدار خاص برای این امکان در این مکان',
  `badge` varchar(255) DEFAULT NULL COMMENT 'نشان خاص برای این امکان',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال بودن',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `location_attributes`
--

CREATE TABLE `location_attributes` (
  `id` int(11) NOT NULL,
  `category` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tags` text DEFAULT NULL,
  `features` text DEFAULT NULL,
  `amenities` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `location_contents`
--

CREATE TABLE `location_contents` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL COMMENT 'شناسه مکان',
  `content_type_id` int(11) NOT NULL COMMENT 'شناسه نوع محتوا',
  `title` varchar(255) DEFAULT NULL COMMENT 'عنوان محتوا',
  `content` text DEFAULT NULL COMMENT 'متن محتوا',
  `extra_data` text DEFAULT NULL COMMENT 'اطلاعات اضافی (JSON)',
  `sort_order` int(11) DEFAULT 0 COMMENT 'ترتیب نمایش',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال بودن',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `location_content_translations`
--

CREATE TABLE `location_content_translations` (
  `id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL COMMENT 'شناسه محتوا',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `title` varchar(255) DEFAULT NULL COMMENT 'عنوان محتوا در این زبان',
  `content` text DEFAULT NULL COMMENT 'متن محتوا در این زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `location_content_types`
--

CREATE TABLE `location_content_types` (
  `id` int(11) NOT NULL,
  `type_key` varchar(50) NOT NULL COMMENT 'کلید یکتا برای نوع محتوا',
  `type_name` varchar(100) NOT NULL COMMENT 'عنوان نوع محتوا',
  `icon` varchar(50) DEFAULT 'fas fa-file-text' COMMENT 'آیکون FontAwesome',
  `description` text DEFAULT NULL COMMENT 'توضیحات نوع محتوا',
  `display_order` int(11) DEFAULT 10 COMMENT 'ترتیب نمایش',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال بودن',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `location_display_settings`
--

CREATE TABLE `location_display_settings` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `section_key` varchar(50) NOT NULL,
  `is_enabled` tinyint(1) DEFAULT 1,
  `display_order` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Stand-in structure for view `location_rating_summary`
-- (See below for the actual view)
--
CREATE TABLE `location_rating_summary` (
`location_id` int(11)
,`title_id` varchar(50)
,`title` varchar(255)
,`category` varchar(50)
,`category_fa` varchar(50)
,`total_ratings` int(11)
,`average_rating` decimal(3,2)
,`total_comments` int(11)
,`service_avg` decimal(3,2)
,`quality_avg` decimal(3,2)
,`location_avg` decimal(3,2)
,`price_avg` decimal(3,2)
,`cleanliness_avg` decimal(3,2)
,`last_rating_date` datetime
,`last_comment_date` datetime
,`pending_comments` bigint(21)
,`pending_ratings` bigint(21)
);

-- --------------------------------------------------------

--
-- Table structure for table `location_seo`
--

CREATE TABLE `location_seo` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'عنوان متا',
  `meta_description` text DEFAULT NULL COMMENT 'توضیحات متا',
  `meta_keywords` text DEFAULT NULL,
  `og_title` varchar(255) DEFAULT NULL COMMENT 'عنوان Open Graph',
  `og_description` text DEFAULT NULL COMMENT 'توضیحات Open Graph',
  `og_image` varchar(255) DEFAULT NULL COMMENT 'تصویر Open Graph',
  `og_type` varchar(50) DEFAULT 'website' COMMENT 'نوع محتوا Open Graph',
  `canonical_url` varchar(255) DEFAULT NULL COMMENT 'آدرس کنونیکال',
  `robots_meta` varchar(50) DEFAULT 'index,follow' COMMENT 'دستورات robots',
  `schema_type` varchar(50) DEFAULT 'LocalBusiness' COMMENT 'نوع Schema.org',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `location_translations`
--

CREATE TABLE `location_translations` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL COMMENT 'شناسه مکان',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `title` varchar(255) NOT NULL COMMENT 'عنوان مکان در این زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات مکان در این زبان',
  `address` text DEFAULT NULL COMMENT 'آدرس مکان در این زبان',
  `slogan` varchar(255) DEFAULT NULL COMMENT 'شعار مکان در این زبان',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'عنوان متا در این زبان',
  `meta_description` text DEFAULT NULL COMMENT 'توضیحات متا در این زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mall_template_settings`
--

CREATE TABLE `mall_template_settings` (
  `id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `header_style` varchar(50) DEFAULT 'default',
  `primary_color` varchar(20) DEFAULT '#3949ab',
  `secondary_color` varchar(20) DEFAULT '#1a237e',
  `features` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `store_categories` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `floor_plans` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `opening_hours` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `social_media` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `custom_css` text DEFAULT NULL,
  `custom_js` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `sender_id` int(11) DEFAULT NULL,
  `recipient_id` int(11) DEFAULT NULL,
  `sender_name` varchar(255) NOT NULL,
  `sender_email` varchar(255) NOT NULL,
  `sender_phone` varchar(255) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(2, '2024_03_19_add_homepage_settings_to_display_settings', 1),
(3, '2024_01_15_000000_create_password_reset_tokens_table', 2);

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `type` varchar(255) NOT NULL,
  `notifiable_type` varchar(255) NOT NULL,
  `notifiable_id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `admin_id` int(11) NOT NULL,
  `email_notifications` tinyint(1) NOT NULL DEFAULT 1,
  `sms_notifications` tinyint(1) NOT NULL DEFAULT 0,
  `push_notifications` tinyint(1) NOT NULL DEFAULT 1,
  `notification_types` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`notification_types`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `used` tinyint(1) NOT NULL DEFAULT 0,
  `used_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `password_reset_tokens`
--

INSERT INTO `password_reset_tokens` (`email`, `token`, `created_at`, `expires_at`, `ip_address`, `user_agent`, `used`, `used_at`) VALUES
('rajestary@gmail.com', '$2y$12$CDmpunXFKuvb3Q7ukLEnWeKqCiCYYrcEJeG/3.C0TydqDQ0fh7EYW', '2025-06-01 08:14:53', '2025-06-01 09:14:53', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ratings`
--

CREATE TABLE `ratings` (
  `id` int(11) NOT NULL,
  `title_id` varchar(255) DEFAULT NULL,
  `category` varchar(50) DEFAULT NULL,
  `hotel_name` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `user_phone` varchar(20) DEFAULT NULL,
  `rating` tinyint(4) NOT NULL COMMENT 'امتیاز کلی (1-5)',
  `overall_rating` tinyint(1) DEFAULT NULL,
  `positive_comment` text DEFAULT NULL,
  `negative_comment` text DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `timestamp` datetime NOT NULL DEFAULT current_timestamp(),
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `admin_reply` text DEFAULT NULL,
  `admin_reply_date` datetime DEFAULT NULL,
  `helpful_count` int(11) NOT NULL DEFAULT 0,
  `not_helpful_count` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `is_verified` tinyint(1) NOT NULL DEFAULT 0,
  `is_featured` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `approved_at` datetime DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `service_rating` tinyint(4) DEFAULT NULL COMMENT 'امتیاز خدمات (1-5)',
  `cleanliness_rating` tinyint(4) DEFAULT NULL COMMENT 'امتیاز نظافت (1-5)',
  `quality_rating` tinyint(4) DEFAULT NULL COMMENT 'امتیاز کیفیت (1-5)',
  `location_rating` tinyint(4) DEFAULT NULL COMMENT 'امتیاز موقعیت (1-5)',
  `price_rating` tinyint(4) DEFAULT NULL COMMENT 'امتیاز قیمت (1-5)',
  `trip_type` varchar(50) DEFAULT NULL,
  `travel_method` varchar(50) DEFAULT NULL,
  `visit_purpose` varchar(50) DEFAULT NULL,
  `recommendation` enum('yes','no','maybe') DEFAULT NULL,
  `stay_date` date DEFAULT NULL,
  `visit_date` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Triggers `ratings`
--
DELIMITER $$
CREATE TRIGGER `update_stats_after_rating_delete` AFTER DELETE ON `ratings` FOR EACH ROW BEGIN
    CALL UpdateLocationStatistics(OLD.title_id);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `update_stats_after_rating_insert` AFTER INSERT ON `ratings` FOR EACH ROW BEGIN
    CALL UpdateLocationStatistics(NEW.title_id);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `update_stats_after_rating_update` AFTER UPDATE ON `ratings` FOR EACH ROW BEGIN
    CALL UpdateLocationStatistics(NEW.title_id);
    IF OLD.title_id != NEW.title_id THEN
        CALL UpdateLocationStatistics(OLD.title_id);
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `rating_comment_helpful_votes`
--

CREATE TABLE `rating_comment_helpful_votes` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `comment_id` int(11) NOT NULL COMMENT 'شناسه کامنت',
  `user_id` int(11) DEFAULT NULL COMMENT 'شناسه کاربر (اختیاری)',
  `ip_address` varchar(45) DEFAULT NULL,
  `vote_type` enum('helpful','not_helpful') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='رای‌های مفید/غیرمفید برای کامنت‌های مکان‌ها';

-- --------------------------------------------------------

--
-- Table structure for table `rating_helpful_votes`
--

CREATE TABLE `rating_helpful_votes` (
  `id` int(11) NOT NULL,
  `rating_id` int(11) NOT NULL COMMENT 'شناسه نظر',
  `user_ip` varchar(45) NOT NULL,
  `user_agent` text DEFAULT NULL,
  `vote_type` enum('helpful','not_helpful') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول آرای مفید بودن نظرات';

-- --------------------------------------------------------

--
-- Table structure for table `rating_location_comments`
--

CREATE TABLE `rating_location_comments` (
  `id` int(11) NOT NULL,
  `title_id` varchar(50) NOT NULL,
  `category` varchar(100) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL COMMENT 'شناسه نظر والد (برای پاسخ‌ها)',
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `user_name` varchar(100) NOT NULL,
  `user_email` varchar(100) NOT NULL,
  `user_phone` varchar(20) DEFAULT NULL,
  `comment` text NOT NULL,
  `rating` tinyint(4) DEFAULT NULL COMMENT 'امتیاز (1-5)',
  `status` enum('pending','approved','rejected','spam') NOT NULL DEFAULT 'pending',
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `helpful_count` int(11) DEFAULT 0 COMMENT 'تعداد رای‌های مفید',
  `not_helpful_count` int(11) DEFAULT 0 COMMENT 'تعداد رای‌های غیرمفید',
  `likes_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد لایک',
  `dislikes_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد دیسلایک',
  `replies_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد پاسخ‌ها',
  `is_pinned` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'سنجاق شده',
  `is_featured` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'نظر ویژه',
  `is_verified` tinyint(1) DEFAULT 0 COMMENT 'آیا تایید شده است',
  `admin_reply` text DEFAULT NULL,
  `admin_reply_date` datetime DEFAULT NULL COMMENT 'تاریخ پاسخ مدیر',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `approved_at` datetime DEFAULT NULL COMMENT 'تاریخ تایید',
  `approved_by` int(11) DEFAULT NULL COMMENT 'تایید شده توسط (admin_id)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول نظرات مکان‌ها';

--
-- Triggers `rating_location_comments`
--
DELIMITER $$
CREATE TRIGGER `update_stats_after_comment_delete` AFTER DELETE ON `rating_location_comments` FOR EACH ROW BEGIN
    CALL UpdateLocationStatistics(OLD.title_id);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `update_stats_after_comment_insert` AFTER INSERT ON `rating_location_comments` FOR EACH ROW BEGIN
    CALL UpdateLocationStatistics(NEW.title_id);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `update_stats_after_comment_update` AFTER UPDATE ON `rating_location_comments` FOR EACH ROW BEGIN
    CALL UpdateLocationStatistics(NEW.title_id);
    IF OLD.title_id != NEW.title_id THEN
        CALL UpdateLocationStatistics(OLD.title_id);
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `rating_statistics`
--

CREATE TABLE `rating_statistics` (
  `id` int(11) NOT NULL,
  `title_id` varchar(50) NOT NULL,
  `total_ratings` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد کل امتیازات',
  `average_rating` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'میانگین امتیاز',
  `rating_1_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد امتیاز 1',
  `rating_2_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد امتیاز 2',
  `rating_3_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد امتیاز 3',
  `rating_4_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد امتیاز 4',
  `rating_5_count` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد امتیاز 5',
  `service_avg` decimal(3,2) DEFAULT NULL COMMENT 'میانگین امتیاز خدمات',
  `quality_avg` decimal(3,2) DEFAULT NULL COMMENT 'میانگین امتیاز کیفیت',
  `location_avg` decimal(3,2) DEFAULT NULL COMMENT 'میانگین امتیاز موقعیت',
  `price_avg` decimal(3,2) DEFAULT NULL COMMENT 'میانگین امتیاز قیمت',
  `cleanliness_avg` decimal(3,2) DEFAULT NULL COMMENT 'میانگین امتیاز نظافت',
  `total_comments` int(11) NOT NULL DEFAULT 0 COMMENT 'تعداد کل نظرات',
  `last_rating_date` datetime DEFAULT NULL COMMENT 'تاریخ آخرین امتیاز',
  `last_comment_date` datetime DEFAULT NULL COMMENT 'تاریخ آخرین نظر',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول آمار امتیازات و نظرات مکان‌ها';

--
-- Dumping data for table `rating_statistics`
--

INSERT INTO `rating_statistics` (`id`, `title_id`, `total_ratings`, `average_rating`, `rating_1_count`, `rating_2_count`, `rating_3_count`, `rating_4_count`, `rating_5_count`, `service_avg`, `quality_avg`, `location_avg`, `price_avg`, `cleanliness_avg`, `total_comments`, `last_rating_date`, `last_comment_date`, `updated_at`) VALUES
(1, 'bazar-starh-kshm-1745924593', 0, 0.00, 0, 0, 0, 2, 0, 3.00, NULL, 5.00, 2.00, 5.00, 0, NULL, NULL, '2025-06-04 09:42:29'),
(7, 'bazar-syty-sntr-1-kshm-1745706020', 0, 0.00, 0, 0, 0, 0, 1, 5.00, NULL, 5.00, 4.00, 5.00, 0, NULL, NULL, '2025-06-04 10:30:49'),
(9, 'asklh-bndr-laft-1745926843', 0, 0.00, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, '2025-06-03 13:14:24');

-- --------------------------------------------------------

--
-- Table structure for table `security_settings`
--

CREATE TABLE `security_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `group` varchar(255) NOT NULL COMMENT 'گروه تنظیمات',
  `key` varchar(255) NOT NULL COMMENT 'کلید تنظیم',
  `value` text DEFAULT NULL COMMENT 'مقدار تنظیم',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'وضعیت فعال بودن',
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'گزینه‌های اضافی' CHECK (json_valid(`options`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `security_settings`
--

INSERT INTO `security_settings` (`id`, `group`, `key`, `value`, `description`, `is_active`, `options`, `created_at`, `updated_at`) VALUES
(1, 'file', 'allowed_mimes', '[\"image\\/jpeg\",\"image\\/png\",\"image\\/gif\",\"application\\/pdf\",\"application\\/msword\",\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\"]', 'انواع فایل‌های مجاز برای آپلود', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(2, 'file', 'max_file_size', '10485760', 'حداکثر حجم فایل (به بایت)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(3, 'file', 'dangerous_extensions', '[\"php\",\"php3\",\"php4\",\"php5\",\"php7\",\"phtml\",\"asp\",\"aspx\",\"jsp\",\"jspx\",\"exe\",\"dll\",\"so\",\"sh\",\"bat\",\"cmd\"]', 'پسوندهای خطرناک', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(4, 'session', 'max_sessions', '3', 'حداکثر تعداد نشست همزمان', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(5, 'session', 'session_lifetime', '120', 'زمان انقضای نشست (به دقیقه)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(6, 'session', 'regenerate_interval', '30', 'فاصله زمانی بازسازی شناسه نشست (به دقیقه)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(7, 'xss', 'xss_patterns', '[\"<script\",\"javascript:\",\"onload=\",\"onerror=\",\"onclick=\",\"onmouseover=\"]', 'الگوهای XSS', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(8, 'xss', 'csp_policy', 'default-src \'self\'; script-src \'self\' \'unsafe-inline\' \'unsafe-eval\'; style-src \'self\' \'unsafe-inline\';', 'سیاست امنیتی محتوا (CSP)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(9, 'xss', 'csrf_token_lifetime', '7200', 'زمان انقضای توکن CSRF (به ثانیه)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(10, 'brute_force', 'max_attempts', '5', 'حداکثر تعداد تلاش‌های ناموفق', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(11, 'brute_force', 'lockout_time', '1800', 'زمان قفل شدن (به ثانیه)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(12, 'brute_force', 'attempt_cleanup', '3600', 'زمان پاکسازی تلاش‌ها (به ثانیه)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(13, 'log', 'log_level', 'warning', 'سطح لاگ', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(14, 'log', 'log_retention', '30', 'مدت زمان نگهداری لاگ‌ها (به روز)', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53'),
(15, 'log', 'log_encryption', 'true', 'رمزنگاری لاگ‌ها', 1, NULL, '2025-05-08 11:40:53', '2025-05-08 11:40:53');

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `site_menus`
--

CREATE TABLE `site_menus` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL COMMENT 'عنوان منو',
  `url` varchar(255) NOT NULL COMMENT 'آدرس لینک',
  `icon` varchar(50) DEFAULT NULL COMMENT 'آیکون FontAwesome',
  `target` enum('_self','_blank') DEFAULT '_self' COMMENT 'نحوه باز شدن لینک',
  `parent_id` int(11) DEFAULT NULL COMMENT 'منوی والد (برای زیرمنو)',
  `sort_order` int(11) DEFAULT 0 COMMENT 'ترتیب نمایش',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'فعال/غیرفعال',
  `show_for_guests` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای مهمان‌ها',
  `show_for_users` tinyint(1) DEFAULT 1 COMMENT 'نمایش برای کاربران',
  `language_code` varchar(5) DEFAULT 'fa' COMMENT 'کد زبان',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='منوهای اصلی سایت';

--
-- Dumping data for table `site_menus`
--

INSERT INTO `site_menus` (`id`, `title`, `url`, `icon`, `target`, `parent_id`, `sort_order`, `is_active`, `show_for_guests`, `show_for_users`, `language_code`, `created_at`, `updated_at`) VALUES
(1, 'صفحه اصلی', '/', 'fas fa-home', '_self', NULL, 1, 1, 1, 1, 'fa', '2025-06-03 05:10:07', '2025-06-03 05:10:07'),
(2, 'دسته‌بندی‌ها', '/categories', 'fas fa-list', '_self', NULL, 2, 1, 1, 1, 'fa', '2025-06-03 05:10:07', '2025-06-03 05:10:07'),
(3, 'نقشه', '/map', 'fas fa-map', '_self', NULL, 3, 1, 1, 1, 'fa', '2025-06-03 05:10:07', '2025-06-03 04:11:54'),
(4, 'درباره ما', '/about', 'fas fa-info-circle', '_self', NULL, 4, 1, 1, 1, 'fa', '2025-06-03 05:10:07', '2025-06-03 04:11:55'),
(5, 'تماس با ما', '/contact', 'fas fa-phone', '_self', NULL, 5, 0, 1, 1, 'fa', '2025-06-03 05:10:07', '2025-06-03 05:31:23');

-- --------------------------------------------------------

--
-- Table structure for table `site_settings`
--

CREATE TABLE `site_settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(50) NOT NULL COMMENT 'کلید تنظیم',
  `setting_value` text DEFAULT NULL COMMENT 'مقدار تنظیم',
  `language_code` varchar(5) NOT NULL COMMENT 'کد زبان',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title` varchar(255) DEFAULT NULL COMMENT 'عنوان سایت',
  `site_icon` varchar(255) DEFAULT NULL COMMENT 'آیکن سایت',
  `favicon` varchar(255) DEFAULT NULL COMMENT 'فاوآیکن سایت',
  `logo` varchar(255) DEFAULT NULL COMMENT 'لوگوی سایت',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'عنوان متا',
  `meta_description` text DEFAULT NULL COMMENT 'توضیحات متا',
  `meta_keywords` text DEFAULT NULL COMMENT 'کلمات کلیدی متا',
  `footer_text` text DEFAULT NULL COMMENT 'متن فوتر',
  `contact_email` varchar(255) DEFAULT NULL COMMENT 'ایمیل تماس',
  `contact_phone` varchar(50) DEFAULT NULL COMMENT 'شماره تماس',
  `contact_address` text DEFAULT NULL COMMENT 'آدرس تماس',
  `social_media` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'شبکه‌های اجتماعی (JSON)' CHECK (json_valid(`social_media`)),
  `theme_color` varchar(20) DEFAULT NULL COMMENT 'رنگ اصلی سایت',
  `custom_css` text DEFAULT NULL COMMENT 'CSS سفارشی',
  `custom_js` text DEFAULT NULL COMMENT 'JavaScript سفارشی',
  `google_analytics_id` varchar(50) DEFAULT NULL COMMENT 'شناسه Google Analytics',
  `google_maps_api_key` varchar(100) DEFAULT NULL COMMENT 'کلید API گوگل مپس',
  `smtp_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات SMTP (JSON)' CHECK (json_valid(`smtp_settings`)),
  `payment_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات پرداخت (JSON)' CHECK (json_valid(`payment_settings`)),
  `notification_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات اعلان‌ها (JSON)' CHECK (json_valid(`notification_settings`)),
  `maintenance_mode` tinyint(1) DEFAULT 0 COMMENT 'حالت تعمیر و نگهداری',
  `maintenance_message` text DEFAULT NULL COMMENT 'پیام حالت تعمیر و نگهداری',
  `version` varchar(20) DEFAULT NULL COMMENT 'نسخه سایت',
  `last_backup` datetime DEFAULT NULL COMMENT 'آخرین پشتیبان‌گیری',
  `backup_frequency` varchar(50) DEFAULT NULL COMMENT 'تناوب پشتیبان‌گیری',
  `backup_retention` int(11) DEFAULT NULL COMMENT 'مدت نگهداری پشتیبان‌ها (روز)',
  `cache_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات کش (JSON)' CHECK (json_valid(`cache_settings`)),
  `security_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات امنیتی (JSON)' CHECK (json_valid(`security_settings`)),
  `api_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات API (JSON)' CHECK (json_valid(`api_settings`)),
  `seo_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات SEO (JSON)' CHECK (json_valid(`seo_settings`)),
  `display_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات نمایش (JSON)' CHECK (json_valid(`display_settings`)),
  `notification_templates` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'قالب‌های اعلان (JSON)' CHECK (json_valid(`notification_templates`)),
  `custom_fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'فیلدهای سفارشی (JSON)' CHECK (json_valid(`custom_fields`)),
  `integration_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات یکپارچه‌سازی (JSON)' CHECK (json_valid(`integration_settings`)),
  `backup_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات پشتیبان‌گیری (JSON)' CHECK (json_valid(`backup_settings`)),
  `monitoring_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات مانیتورینگ (JSON)' CHECK (json_valid(`monitoring_settings`)),
  `reporting_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات گزارش‌گیری (JSON)' CHECK (json_valid(`reporting_settings`)),
  `localization_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات بومی‌سازی (JSON)' CHECK (json_valid(`localization_settings`)),
  `performance_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات عملکرد (JSON)' CHECK (json_valid(`performance_settings`)),
  `accessibility_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات دسترسی‌پذیری (JSON)' CHECK (json_valid(`accessibility_settings`)),
  `compliance_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات انطباق (JSON)' CHECK (json_valid(`compliance_settings`)),
  `advanced_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'تنظیمات پیشرفته (JSON)' CHECK (json_valid(`advanced_settings`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='تنظیمات سایت در زبان‌های مختلف';

--
-- Dumping data for table `site_settings`
--

INSERT INTO `site_settings` (`id`, `setting_key`, `setting_value`, `language_code`, `description`, `is_active`, `created_at`, `updated_at`, `title`, `site_icon`, `favicon`, `logo`, `meta_title`, `meta_description`, `meta_keywords`, `footer_text`, `contact_email`, `contact_phone`, `contact_address`, `social_media`, `theme_color`, `custom_css`, `custom_js`, `google_analytics_id`, `google_maps_api_key`, `smtp_settings`, `payment_settings`, `notification_settings`, `maintenance_mode`, `maintenance_message`, `version`, `last_backup`, `backup_frequency`, `backup_retention`, `cache_settings`, `security_settings`, `api_settings`, `seo_settings`, `display_settings`, `notification_templates`, `custom_fields`, `integration_settings`, `backup_settings`, `monitoring_settings`, `reporting_settings`, `localization_settings`, `performance_settings`, `accessibility_settings`, `compliance_settings`, `advanced_settings`) VALUES
(107, 'site_title', '\"\\u0627\\u0644\\u0648 \\u0627\\u06cc\\u0631\\u0627\\u0646\"', 'fa', NULL, 1, '2025-05-15 10:48:29', '2025-05-15 11:19:31', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(108, 'theme_color', '\"#000000\"', 'fa', NULL, 1, '2025-05-15 10:48:29', '2025-05-15 10:48:29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(110, 'logo_text', '\"\\u0627\\u064e\\u0644\\u0648 \\u0627\\u06cc\\u0631\\u0627\\u0646\"', 'fa', NULL, 1, '2025-05-15 10:58:41', '2025-05-15 11:19:31', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(112, 'site_title', '\"Alu Iran\"', 'en', NULL, 1, '2025-05-15 19:11:07', '2025-05-15 19:11:07', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(113, 'theme_color', '\"#000000\"', 'en', NULL, 1, '2025-05-15 19:11:07', '2025-05-15 19:11:07', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(114, 'logo_text', '\"Alu Iran\"', 'en', NULL, 1, '2025-05-15 19:11:07', '2025-05-15 19:11:07', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(116, 'footer_text', '\"\\u062a\\u0645\\u0627\\u0645\\u06cc \\u062d\\u0642\\u0648\\u0642 \\u0628\\u0631\\u0627\\u06cc \\u0627\\u064e\\u0644\\u0648 \\u0627\\u06cc\\u0631\\u0627\\u0646 \\u0645\\u062d\\u0641\\u0648\\u0638 \\u0627\\u0633\\u062a \\u00a9 2025\"', 'fa', NULL, 1, '2025-05-16 11:00:32', '2025-05-16 11:44:17', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(117, 'site_title', '\"\\u0627\\u064e\\u0644\\u0648 \\u0627\\u06cc\\u0631\\u0627\\u0646\"', 'ar', NULL, 1, '2025-05-16 11:45:41', '2025-05-16 11:45:41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(118, 'theme_color', '\"#000000\"', 'ar', NULL, 1, '2025-05-16 11:45:41', '2025-05-16 11:45:41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(119, 'logo_text', '\"\\u0627\\u064e\\u0644\\u0648 \\u0627\\u06cc\\u0631\\u0627\\u0646\"', 'ar', NULL, 1, '2025-05-16 11:45:41', '2025-05-16 11:45:41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(120, 'footer_text', '\"\\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0645\\u062d\\u0641\\u0648\\u0638\\u0629 \\u00a9 2025 \\u0623\\u0644\\u0648 \\u0625\\u064a\\u0631\\u0627\\u0646\"', 'ar', NULL, 1, '2025-05-16 11:45:41', '2025-05-16 11:45:41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(121, 'footer_text', '\"All rights reserved \\u00a9 2025 Alu Iran\"', 'en', NULL, 1, '2025-05-16 11:47:41', '2025-05-16 11:47:41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(122, 'logo', '\"\\/images\\/logo_GpUFTpls92.png\"', 'fa', NULL, 1, '2025-05-18 15:22:11', '2025-05-18 15:22:11', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(123, 'site_icon', '\"\\/images\\/site_icon_aovTkFMsE2.png\"', 'fa', NULL, 1, '2025-05-18 15:25:38', '2025-05-18 15:48:50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(124, 'favicon', '\"\\/images\\/favicon_wtUayzrqNJ.png\"', 'fa', NULL, 1, '2025-05-18 15:25:58', '2025-05-18 15:49:41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(125, 'contact_phone', '\"09981100917\"', 'fa', NULL, 1, '2025-05-22 03:41:57', '2025-05-22 03:41:57', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `state1_countries`
--

CREATE TABLE `state1_countries` (
  `id` int(11) NOT NULL COMMENT 'شناسه کشور',
  `flag` varchar(10) DEFAULT NULL COMMENT 'پرچم کشورها',
  `name` varchar(100) NOT NULL COMMENT 'نام فارسی کشور',
  `name_en` varchar(100) NOT NULL COMMENT 'نام انگلیسی کشور',
  `name_ar` varchar(50) DEFAULT NULL COMMENT 'نام عربی کشور',
  `native_name` varchar(100) DEFAULT NULL COMMENT 'نام بومی',
  `capital` varchar(100) DEFAULT NULL COMMENT 'پایتخت به فارسی',
  `capital_en` varchar(50) DEFAULT NULL COMMENT 'پایتخت به انگلیسی',
  `capital_ar` varchar(50) DEFAULT NULL COMMENT 'پایتخت به عربی',
  `iso_code` char(2) NOT NULL COMMENT 'کد ISO دو حرفی',
  `iso_code3` char(3) NOT NULL COMMENT 'کد ISO سه حرفی',
  `num_code` smallint(6) DEFAULT NULL COMMENT 'کد عددی ISO',
  `phone_code` varchar(10) DEFAULT NULL COMMENT 'پیش‌شماره تلفن',
  `currency_code` varchar(3) DEFAULT NULL COMMENT 'کد ارز',
  `region` varchar(100) DEFAULT NULL COMMENT 'منطقه جغرافیایی',
  `subregion` varchar(100) DEFAULT NULL COMMENT 'زیرمنطقه',
  `boundaries` geometry DEFAULT NULL COMMENT 'مرزها (GeoJSON)',
  `area` decimal(12,2) DEFAULT NULL COMMENT 'مساحت (کیلومتر مربع)',
  `population` bigint(20) DEFAULT NULL COMMENT 'جمعیت',
  `timezone` varchar(50) DEFAULT NULL COMMENT 'منطقه زمانی',
  `continent` varchar(50) DEFAULT NULL COMMENT 'قاره',
  `tld` varchar(10) DEFAULT NULL COMMENT 'دامنه سطح بالا',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال (1=فعال، 0=غیرفعال)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'تاریخ ایجاد',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'تاریخ بروزرسانی'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول اطلاعات کشورهای جهان';

--
-- Dumping data for table `state1_countries`
--

INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '🇮🇷', 'ایران', 'Iran', 'إيران', 'ایران', 'تهران', 'Tehran', 'طهران', 'IR', 'IRN', 364, '98', 'IRR', 'آسیا', 'جنوب غربی آسیا', 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, 1648195.00, 83992953, 'UTC+3:30', 'Asia', '.ir', 1, '2025-05-16 17:58:16', '2025-05-16 20:32:38');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(2, '🇦🇫', 'افغانستان', 'Afghanistan', 'أفغانستان', 'افغانستان', 'کابل', 'Kabul', 'كابل', 'AF', 'AFG', 4, '93', 'AFN', 'آسیا', 'جنوبی آسیا', NULL, 652230.00, 38928341, 'UTC+4:30', 'Asia', '.af', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(3, '🇦🇱', 'آلبانی', 'Albania', 'ألبانيا', 'Shqipëria', 'تیرانا', 'Tirana', 'تيرانا', 'AL', 'ALB', 8, '355', 'ALL', 'اروپا', 'جنوب شرقی اروپا', NULL, 28748.00, 2877797, 'UTC+1', 'Europe', '.al', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(4, '🇩🇿', 'الجزایر', 'Algeria', 'الجزائر', 'الجزائر', 'الجزیره', 'Algiers', 'الجزائر', 'DZ', 'DZA', 12, '213', 'DZD', 'آفریقا', 'شمالی آفریقا', NULL, 2381741.00, 43851043, 'UTC+1', 'Africa', '.dz', 0, '2025-05-16 17:58:16', '2025-05-16 20:40:58'),
(5, '🇺🇸', 'آمریکا', 'United States', 'الولايات المتحدة', 'United States', 'واشنگتن دی‌سی', 'Washington, D.C.', 'واشنطن العاصمة', 'US', 'USA', 840, '1', 'USD', 'آمریکا', 'شمالی آمریکا', NULL, 9833517.00, 331002647, 'UTC-5 to -10', 'North America', '.us', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(6, '🇬🇧', 'انگلیس', 'United Kingdom', 'المملكة المتحدة', 'United Kingdom', 'لندن', 'London', 'لندن', 'GB', 'GBR', 826, '44', 'GBP', 'اروپا', 'شمال غربی اروپا', NULL, 242495.00, 67886004, 'UTC+0', 'Europe', '.uk', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(7, '🇨🇦', 'کانادا', 'Canada', 'كندا', 'Canada', 'اتاوا', 'Ottawa', 'أوتاوا', 'CA', 'CAN', 124, '1', 'CAD', 'آمریکا', 'شمالی آمریکا', NULL, 9984670.00, 38005238, 'UTC-3:30 to -8', 'North America', '.ca', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(8, '🇩🇪', 'آلمان', 'Germany', 'ألمانيا', 'Deutschland', 'برلین', 'Berlin', 'برلين', 'DE', 'DEU', 276, '49', 'EUR', 'اروپا', 'غربی اروپا', NULL, 357022.00, 83783945, 'UTC+1', 'Europe', '.de', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(9, '🇫🇷', 'فرانسه', 'France', 'فرنسا', 'France', 'پاریس', 'Paris', 'باريس', 'FR', 'FRA', 250, '33', 'EUR', 'اروپا', 'غربی اروپا', NULL, 551695.00, 65273512, 'UTC+1', 'Europe', '.fr', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(10, '🇮🇹', 'ایتالیا', 'Italy', 'إيطاليا', 'Italia', 'رم', 'Rome', 'روما', 'IT', 'ITA', 380, '39', 'EUR', 'اروپا', 'جنوبی اروپا', NULL, 301340.00, 60461828, 'UTC+1', 'Europe', '.it', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(11, '🇯🇵', 'ژاپن', 'Japan', 'اليابان', '日本', 'توکیو', 'Tokyo', 'طوكيو', 'JP', 'JPN', 392, '81', 'JPY', 'آسیا', 'شرقی آسیا', NULL, 377975.00, 126476458, 'UTC+9', 'Asia', '.jp', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(12, '🇨🇳', 'چین', 'China', 'الصين', '中国', 'پکن', 'Beijing', 'بكين', 'CN', 'CHN', 156, '86', 'CNY', 'آسیا', 'شرقی آسیا', NULL, 9596961.00, 1439323774, 'UTC+8', 'Asia', '.cn', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(13, '🇷🇺', 'روسیه', 'Russia', 'روسيا', 'Россия', 'مسکو', 'Moscow', 'موسكو', 'RU', 'RUS', 643, '7', 'RUB', 'اروپا/آسیا', 'شرقی اروپا/شمالی آسیا', NULL, 17098242.00, 145934460, 'UTC+2 to +12', 'Europe/Asia', '.ru', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(14, '🇮🇳', 'هند', 'India', 'الهند', 'भारत', 'دهلی نو', 'New Delhi', 'نيودلهي', 'IN', 'IND', 356, '91', 'INR', 'آسیا', 'جنوبی آسیا', NULL, 3287263.00, 1380004385, 'UTC+5:30', 'Asia', '.in', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(15, '🇧🇷', 'برزیل', 'Brazil', 'البرازيل', 'Brasil', 'برازیلیا', 'Brasília', 'برازيليا', 'BR', 'BRA', 76, '55', 'BRL', 'آمریکا', 'جنوبی آمریکا', NULL, 8515767.00, 212559409, 'UTC-2 to -5', 'South America', '.br', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(16, '🇦🇺', 'استرالیا', 'Australia', 'أستراليا', 'Australia', 'کانبرا', 'Canberra', 'كانبرا', 'AU', 'AUS', 36, '61', 'AUD', 'اقیانوسیه', 'استرالیا و نیوزیلند', NULL, 7692024.00, 25499881, 'UTC+8 to +10:30', 'Oceania', '.au', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(17, '🇿🇦', 'آفریقای جنوبی', 'South Africa', 'جنوب أفريقيا', 'South Africa', 'پرتوریا', 'Pretoria', 'بريتوريا', 'ZA', 'ZAF', 710, '27', 'ZAR', 'آفریقا', 'جنوبی آفریقا', NULL, 1221037.00, 59308690, 'UTC+2', 'Africa', '.za', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16'),
(18, '🇲🇽', 'مکزیک', 'Mexico', 'المكسيك', 'México', 'مکزیکو سیتی', 'Mexico City', 'مدينة مكسيكو', 'MX', 'MEX', 484, '52', 'MXN', 'آمریکا', 'شمالی آمریکا', NULL, 1964375.00, 128932753, 'UTC-5 to -8', 'North America', '.mx', 0, '2025-05-16 17:58:16', '2025-05-16 17:58:16');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(19, '🇸🇦', 'عربستان سعودی', 'Saudi Arabia', 'المملكة العربية السعودية', 'المملكة العربية السعودية', 'ریاض', 'Riyadh', 'الرياض', 'SA', 'SAU', 682, '966', 'SAR', 'آسیا', 'غربی آسیا', 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, 2149690.00, 34813867, 'UTC+3', 'Asia', '.sa', 1, '2025-05-16 17:58:16', '2025-05-16 21:35:04');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(20, '🇹🇷', 'ترکیه', 'Turkey', 'تركيا', 'Türkiye', 'آنکارا', 'Ankara', 'أنقرة', 'TR', 'TUR', 792, '90', 'TRY', 'آسیا', 'غربی آسیا', 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, 783562.00, 84339067, 'UTC+3', 'Asia', '.tr', 1, '2025-05-16 17:58:16', '2025-05-16 21:44:04');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(21, '🇦🇪', 'امارات متحده عربی', 'United Arab Emirates', 'الإمارات العربية المتحدة', 'الإمارات العربية المتحدة', 'ابوظبی', 'Abu Dhabi', 'أبو ظبي', 'AE', 'ARE', 784, '971', 'AED', 'آسیا', 'غربی آسیا', 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, 83600.00, 9890400, 'UTC+4', 'Asia', '.ae', 1, '2025-05-16 21:00:47', '2025-05-16 21:13:43'),
(22, '🇦🇲', 'ارمنستان', 'Armenia', 'أرمينيا', 'Հայաստան', 'ایروان', 'Yerevan', 'يريفان', 'AM', 'ARM', 51, '374', 'AMD', 'آسیا', 'غربی آسیا', NULL, 29743.00, 2963234, 'UTC+4', 'Asia', '.am', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(23, '🇦🇿', 'آذربایجان', 'Azerbaijan', 'أذربيجان', 'Azərbaycan', 'باکو', 'Baku', 'باكو', 'AZ', 'AZE', 31, '994', 'AZN', 'آسیا', 'غربی آسیا', NULL, 86600.00, 10139175, 'UTC+4', 'Asia', '.az', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(24, '🇧🇭', 'بحرین', 'Bahrain', 'البحرين', 'البحرين', 'منامه', 'Manama', 'المنامة', 'BH', 'BHR', 48, '973', 'BHD', 'آسیا', 'غربی آسیا', 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, 765.00, 1701583, 'UTC+3', 'Asia', '.bh', 1, '2025-05-16 21:00:47', '2025-05-16 21:37:07'),
(25, '🇧🇩', 'بنگلادش', 'Bangladesh', 'بنغلاديش', 'বাংলাদেশ', 'داکا', 'Dhaka', 'دكا', 'BD', 'BGD', 50, '880', 'BDT', 'آسیا', 'جنوبی آسیا', NULL, 147570.00, 164689383, 'UTC+6', 'Asia', '.bd', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(26, '🇧🇹', 'بوتان', 'Bhutan', 'بوتان', 'འབྲུག་ཡུལ་', 'تیمفو', 'Thimphu', 'تيمفو', 'BT', 'BTN', 64, '975', 'BTN', 'آسیا', 'جنوبی آسیا', NULL, 38394.00, 771612, 'UTC+6', 'Asia', '.bt', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(27, '🇧🇳', 'برونئی', 'Brunei', 'بروناي', 'Brunei Darussalam', 'بندر سری بگاوان', 'Bandar Seri Begawan', 'بندر سري بگاوان', 'BN', 'BRN', 96, '673', 'BND', 'آسیا', 'جنوب شرقی آسیا', NULL, 5765.00, 437483, 'UTC+8', 'Asia', '.bn', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(28, '🇰🇭', 'کامبوج', 'Cambodia', 'كمبوديا', 'កម្ពុជា', 'پنوم پن', 'Phnom Penh', 'بنوم بنه', 'KH', 'KHM', 116, '855', 'KHR', 'آسیا', 'جنوب شرقی آسیا', NULL, 181035.00, 16718971, 'UTC+7', 'Asia', '.kh', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(29, '🇨🇾', 'قبرس', 'Cyprus', 'قبرص', 'Κύπρος', 'نیکوزیا', 'Nicosia', 'نيقوسيا', 'CY', 'CYP', 196, '357', 'EUR', 'آسیا', 'غربی آسیا', NULL, 9251.00, 1207361, 'UTC+2', 'Asia', '.cy', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(30, '🇬🇪', 'گرجستان', 'Georgia', 'جورجيا', 'საქართველო', 'تفلیس', 'Tbilisi', 'تبليسي', 'GE', 'GEO', 268, '995', 'GEL', 'آسیا', 'غربی آسیا', NULL, 69700.00, 3989175, 'UTC+4', 'Asia', '.ge', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(32, '🇦🇴', 'آنگولا', 'Angola', 'أنغولا', 'Angola', 'لواندا', 'Luanda', 'لواندا', 'AO', 'AGO', 24, '244', 'AOA', 'آفریقا', 'مرکزی آفریقا', NULL, 1246700.00, 32866268, 'UTC+1', 'Africa', '.ao', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(33, '🇧🇯', 'بنین', 'Benin', 'بنين', 'Bénin', 'پورتو نووو', 'Porto-Novo', 'بورتو نوفو', 'BJ', 'BEN', 204, '229', 'XOF', 'آفریقا', 'غربی آفریقا', NULL, 112622.00, 12123198, 'UTC+1', 'Africa', '.bj', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(34, '🇧🇼', 'بوتسوانا', 'Botswana', 'بوتسوانا', 'Botswana', 'گابورون', 'Gaborone', 'غابورون', 'BW', 'BWA', 72, '267', 'BWP', 'آفریقا', 'جنوبی آفریقا', NULL, 581730.00, 2351625, 'UTC+2', 'Africa', '.bw', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(35, '🇧🇫', 'بورکینافاسو', 'Burkina Faso', 'بوركينا فاسو', 'Burkina Faso', 'اوآگادوگو', 'Ouagadougou', 'واجادوجو', 'BF', 'BFA', 854, '226', 'XOF', 'آفریقا', 'غربی آفریقا', NULL, 274200.00, 20903278, 'UTC+0', 'Africa', '.bf', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(36, '🇧🇮', 'بوروندی', 'Burundi', 'بوروندي', 'Burundi', 'بوجومبورا', 'Bujumbura', 'بوجومبورا', 'BI', 'BDI', 108, '257', 'BIF', 'آفریقا', 'شرقی آفریقا', NULL, 27830.00, 11890781, 'UTC+2', 'Africa', '.bi', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(37, '🇨🇲', 'کامرون', 'Cameroon', 'الكاميرون', 'Cameroon', 'یائونده', 'Yaoundé', 'ياوندي', 'CM', 'CMR', 120, '237', 'XAF', 'آفریقا', 'مرکزی آفریقا', NULL, 475442.00, 26545864, 'UTC+1', 'Africa', '.cm', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(38, '🇨🇻', 'کیپ ورد', 'Cape Verde', 'الرأس الأخضر', 'Cabo Verde', 'پریا', 'Praia', 'برايا', 'CV', 'CPV', 132, '238', 'CVE', 'آفریقا', 'غربی آفریقا', NULL, 4033.00, 555988, 'UTC-1', 'Africa', '.cv', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(39, '🇨🇫', 'جمهوری آفریقای مرکزی', 'Central African Republic', 'جمهورية أفريقيا الوسطى', 'République centrafricaine', 'بانگی', 'Bangui', 'بانغي', 'CF', 'CAF', 140, '236', 'XAF', 'آفریقا', 'مرکزی آفریقا', NULL, 622984.00, 4829764, 'UTC+1', 'Africa', '.cf', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(40, '🇹🇩', 'چاد', 'Chad', 'تشاد', 'Tchad', 'انجامنا', 'N\'Djamena', 'نجامينا', 'TD', 'TCD', 148, '235', 'XAF', 'آفریقا', 'مرکزی آفریقا', NULL, 1284000.00, 16425859, 'UTC+1', 'Africa', '.td', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(41, '🇦🇹', 'اتریش', 'Austria', 'النمسا', 'Österreich', 'وین', 'Vienna', 'فيينا', 'AT', 'AUT', 40, '43', 'EUR', 'اروپا', 'غربی اروپا', NULL, 83871.00, 9006400, 'UTC+1', 'Europe', '.at', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(42, '🇧🇾', 'بلاروس', 'Belarus', 'بيلاروسيا', 'Беларусь', 'مینسک', 'Minsk', 'مينسك', 'BY', 'BLR', 112, '375', 'BYN', 'اروپا', 'شرقی اروپا', NULL, 207600.00, 9449321, 'UTC+3', 'Europe', '.by', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(43, '🇧🇪', 'بلژیک', 'Belgium', 'بلجيكا', 'België', 'بروکسل', 'Brussels', 'بروكسل', 'BE', 'BEL', 56, '32', 'EUR', 'اروپا', 'غربی اروپا', NULL, 30528.00, 11589616, 'UTC+1', 'Europe', '.be', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(44, '🇧🇦', 'بوسنی و هرزگوین', 'Bosnia and Herzegovina', 'البوسنة والهرسك', 'Bosna i Hercegovina', 'سارایوو', 'Sarajevo', 'سراييفو', 'BA', 'BIH', 70, '387', 'BAM', 'اروپا', 'جنوب شرقی اروپا', NULL, 51209.00, 3280815, 'UTC+1', 'Europe', '.ba', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(45, '🇧🇬', 'بلغارستان', 'Bulgaria', 'بلغاريا', 'България', 'صوفیه', 'Sofia', 'صوفيا', 'BG', 'BGR', 100, '359', 'BGN', 'اروپا', 'شرقی اروپا', NULL, 110879.00, 6948445, 'UTC+2', 'Europe', '.bg', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(46, '🇭🇷', 'کرواسی', 'Croatia', 'كرواتيا', 'Hrvatska', 'زاگرب', 'Zagreb', 'زغرب', 'HR', 'HRV', 191, '385', 'HRK', 'اروپا', 'جنوب شرقی اروپا', NULL, 56594.00, 4105267, 'UTC+1', 'Europe', '.hr', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(47, '🇨🇿', 'جمهوری چک', 'Czech Republic', 'التشيك', 'Česko', 'پراگ', 'Prague', 'براغ', 'CZ', 'CZE', 203, '420', 'CZK', 'اروپا', 'شرقی اروپا', NULL, 78865.00, 10708982, 'UTC+1', 'Europe', '.cz', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(48, '🇩🇰', 'دانمارک', 'Denmark', 'الدنمارك', 'Danmark', 'کپنهاگ', 'Copenhagen', 'كوبنهاغن', 'DK', 'DNK', 208, '45', 'DKK', 'اروپا', 'شمالی اروپا', NULL, 43094.00, 5792203, 'UTC+1', 'Europe', '.dk', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(49, '🇪🇪', 'استونی', 'Estonia', 'إستونيا', 'Eesti', 'تالین', 'Tallinn', 'تالين', 'EE', 'EST', 233, '372', 'EUR', 'اروپا', 'شمالی اروپا', NULL, 45227.00, 1326539, 'UTC+2', 'Europe', '.ee', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(50, '🇫🇮', 'فنلاند', 'Finland', 'فنلندا', 'Suomi', 'هلسینکی', 'Helsinki', 'هلسنكي', 'FI', 'FIN', 246, '358', 'EUR', 'اروپا', 'شمالی اروپا', NULL, 338424.00, 5540718, 'UTC+2', 'Europe', '.fi', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(51, '🇦🇷', 'آرژانتین', 'Argentina', 'الأرجنتين', 'Argentina', 'بوئنوس آیرس', 'Buenos Aires', 'بوينس آيرس', 'AR', 'ARG', 32, '54', 'ARS', 'آمریکا', 'جنوبی آمریکا', NULL, 2780400.00, 45195777, 'UTC-3', 'South America', '.ar', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(52, '🇧🇿', 'بلیز', 'Belize', 'بليز', 'Belize', 'بلموپان', 'Belmopan', 'بلموبان', 'BZ', 'BLZ', 84, '501', 'BZD', 'آمریکا', 'مرکزی آمریکا', NULL, 22966.00, 397621, 'UTC-6', 'North America', '.bz', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(53, '🇧🇴', 'بولیوی', 'Bolivia', 'بوليفيا', 'Bolivia', 'سوکره', 'Sucre', 'سوكري', 'BO', 'BOL', 68, '591', 'BOB', 'آمریکا', 'جنوبی آمریکا', NULL, 1098581.00, 11673029, 'UTC-4', 'South America', '.bo', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(54, '🇨🇱', 'شیلی', 'Chile', 'تشيلي', 'Chile', 'سانتیاگو', 'Santiago', 'سانتياغو', 'CL', 'CHL', 152, '56', 'CLP', 'آمریکا', 'جنوبی آمریکا', NULL, 756102.00, 19116209, 'UTC-4', 'South America', '.cl', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(55, '🇨🇴', 'کلمبیا', 'Colombia', 'كولومبيا', 'Colombia', 'بوگوتا', 'Bogotá', 'بوغوتا', 'CO', 'COL', 170, '57', 'COP', 'آمریکا', 'جنوبی آمریکا', NULL, 1141748.00, 50882884, 'UTC-5', 'South America', '.co', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(56, '🇨🇷', 'کاستاریکا', 'Costa Rica', 'كوستاريكا', 'Costa Rica', 'سان خوزه', 'San José', 'سان خوسيه', 'CR', 'CRI', 188, '506', 'CRC', 'آمریکا', 'مرکزی آمریکا', NULL, 51100.00, 5094114, 'UTC-6', 'North America', '.cr', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(57, '🇨🇺', 'کوبا', 'Cuba', 'كوبا', 'Cuba', 'هاوانا', 'Havana', 'هافانا', 'CU', 'CUB', 192, '53', 'CUP', 'آمریکا', 'کارائیب', NULL, 109884.00, 11326616, 'UTC-5', 'North America', '.cu', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(58, '🇩🇴', 'جمهوری دومینیکن', 'Dominican Republic', 'جمهورية الدومينيكان', 'República Dominicana', 'سانتو دومینگو', 'Santo Domingo', 'سانتو دومينغو', 'DO', 'DOM', 214, '1-809, 1-8', 'DOP', 'آمریکا', 'کارائیب', NULL, 48671.00, 10847904, 'UTC-4', 'North America', '.do', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(59, '🇪🇨', 'اکوادور', 'Ecuador', 'الإكوادور', 'Ecuador', 'کیتو', 'Quito', 'كيتو', 'EC', 'ECU', 218, '593', 'USD', 'آمریکا', 'جنوبی آمریکا', NULL, 283561.00, 17643060, 'UTC-5', 'South America', '.ec', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(60, '🇸🇻', 'السالوادور', 'El Salvador', 'السلفادور', 'El Salvador', 'سان سالوادور', 'San Salvador', 'سان سلفادور', 'SV', 'SLV', 222, '503', 'USD', 'آمریکا', 'مرکزی آمریکا', NULL, 21041.00, 6486201, 'UTC-6', 'North America', '.sv', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(61, '🇫🇯', 'فیجی', 'Fiji', 'فيجي', 'Fiji', 'سووا', 'Suva', 'سوفا', 'FJ', 'FJI', 242, '679', 'FJD', 'اقیانوسیه', 'ملانزی', NULL, 18272.00, 896444, 'UTC+12', 'Oceania', '.fj', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(62, '🇰🇮', 'کیریباتی', 'Kiribati', 'كيريباتي', 'Kiribati', 'تاراوا جنوبی', 'South Tarawa', 'تاراوا الجنوبية', 'KI', 'KIR', 296, '686', 'AUD', 'اقیانوسیه', 'میکرونزی', NULL, 811.00, 119446, 'UTC+12, +13, +14', 'Oceania', '.ki', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(63, '🇲🇭', 'جزایر مارشال', 'Marshall Islands', 'جزر مارشال', 'Marshall Islands', 'ماجورو', 'Majuro', 'ماجورو', 'MH', 'MHL', 584, '692', 'USD', 'اقیانوسیه', 'میکرونزی', NULL, 181.00, 59194, 'UTC+12', 'Oceania', '.mh', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(64, '🇫🇲', 'میکرونزی', 'Micronesia', 'ميكرونيزيا', 'Micronesia', 'پالیکیر', 'Palikir', 'باليكير', 'FM', 'FSM', 583, '691', 'USD', 'اقیانوسیه', 'میکرونزی', NULL, 702.00, 115021, 'UTC+10, +11', 'Oceania', '.fm', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(65, '🇳🇷', 'نائورو', 'Nauru', 'ناورو', 'Nauru', 'یارن', 'Yaren', 'يارين', 'NR', 'NRU', 520, '674', 'AUD', 'اقیانوسیه', 'میکرونزی', NULL, 21.00, 10824, 'UTC+12', 'Oceania', '.nr', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(66, '🇳🇨', 'کالدونیای جدید', 'New Caledonia', 'كاليدونيا الجديدة', 'Nouvelle-Calédonie', 'نومئا', 'Nouméa', 'نوميا', 'NC', 'NCL', 540, '687', 'XPF', 'اقیانوسیه', 'ملانزی', NULL, 18575.00, 285491, 'UTC+11', 'Oceania', '.nc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(67, '🇳🇿', 'نیوزیلند', 'New Zealand', 'نيوزيلندا', 'New Zealand', 'ولینگتون', 'Wellington', 'ويلينغتون', 'NZ', 'NZL', 554, '64', 'NZD', 'اقیانوسیه', 'استرالیا و نیوزیلند', NULL, 270467.00, 4822233, 'UTC+12', 'Oceania', '.nz', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(68, '🇵🇼', 'پالائو', 'Palau', 'بالاو', 'Palau', 'نگرولمود', 'Ngerulmud', 'نجرولمود', 'PW', 'PLW', 585, '680', 'USD', 'اقیانوسیه', 'میکرونزی', NULL, 459.00, 18092, 'UTC+9', 'Oceania', '.pw', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(69, '🇵🇬', 'پاپوآ گینه نو', 'Papua New Guinea', 'بابوا غينيا الجديدة', 'Papua New Guinea', 'پورت مورسبی', 'Port Moresby', 'بورت مورسبي', 'PG', 'PNG', 598, '675', 'PGK', 'اقیانوسیه', 'ملانزی', NULL, 462840.00, 8947027, 'UTC+10', 'Oceania', '.pg', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(70, '🇼🇸', 'ساموآ', 'Samoa', 'ساموا', 'Samoa', 'آپیا', 'Apia', 'ابيا', 'WS', 'WSM', 882, '685', 'WST', 'اقیانوسیه', 'پلی‌نزی', NULL, 2842.00, 198410, 'UTC+13', 'Oceania', '.ws', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(71, '🇦🇩', 'آندورا', 'Andorra', 'أندورا', 'Andorra', 'آندورا لاولا', 'Andorra la Vella', 'أندورا لا فيلا', 'AD', 'AND', 20, '376', 'EUR', 'اروپا', 'جنوبی اروپا', NULL, 468.00, 77265, 'UTC+1', 'Europe', '.ad', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(72, '🇻🇦', 'واتیکان', 'Vatican City', 'الفاتيكان', 'Città del Vaticano', 'واتیکان', 'Vatican City', 'الفاتيكان', 'VA', 'VAT', 336, '379', 'EUR', 'اروپا', 'جنوبی اروپا', NULL, 0.44, 825, 'UTC+1', 'Europe', '.va', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(73, '🇸🇲', 'سان مارینو', 'San Marino', 'سان مارينو', 'San Marino', 'سان مارینو', 'San Marino', 'سان مارينو', 'SM', 'SMR', 674, '378', 'EUR', 'اروپا', 'جنوبی اروپا', NULL, 61.00, 33938, 'UTC+1', 'Europe', '.sm', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(74, '🇲🇨', 'موناکو', 'Monaco', 'موناكو', 'Monaco', 'موناکو', 'Monaco', 'موناكو', 'MC', 'MCO', 492, '377', 'EUR', 'اروپا', 'غربی اروپا', NULL, 2.02, 39244, 'UTC+1', 'Europe', '.mc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(75, '🇱🇮', 'لیختناشتاین', 'Liechtenstein', 'ليختنشتاين', 'Liechtenstein', 'فادوتس', 'Vaduz', 'فادوز', 'LI', 'LIE', 438, '423', 'CHF', 'اروپا', 'غربی اروپا', NULL, 160.00, 38128, 'UTC+1', 'Europe', '.li', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(76, '🇮🇸', 'ایسلند', 'Iceland', 'آيسلندا', 'Ísland', 'ریکیاویک', 'Reykjavík', 'ريكيافيك', 'IS', 'ISL', 352, '354', 'ISK', 'اروپا', 'شمالی اروپا', NULL, 103000.00, 341243, 'UTC+0', 'Europe', '.is', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(77, '🇲🇻', 'مالدیو', 'Maldives', 'المالديف', 'ދިވެހިރާއްޖެ', 'ماله', 'Malé', 'ماليه', 'MV', 'MDV', 462, '960', 'MVR', 'آسیا', 'جنوبی آسیا', NULL, 300.00, 540542, 'UTC+5', 'Asia', '.mv', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(78, '🇲🇹', 'مالت', 'Malta', 'مالطا', 'Malta', 'والتا', 'Valletta', 'فاليتا', 'MT', 'MLT', 470, '356', 'EUR', 'اروپا', 'جنوبی اروپا', NULL, 316.00, 441539, 'UTC+1', 'Europe', '.mt', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(79, '🇰🇳', 'سنت کیتس و نویس', 'Saint Kitts and Nevis', 'سانت كيتس ونيفيس', 'Saint Kitts and Nevis', 'باستر', 'Basseterre', 'باستير', 'KN', 'KNA', 659, '1-869', 'XCD', 'آمریکا', 'کارائیب', NULL, 261.00, 53199, 'UTC-4', 'North America', '.kn', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(80, '🇱🇨', 'سنت لوسیا', 'Saint Lucia', 'سانت لوسيا', 'Saint Lucia', 'کاستریس', 'Castries', 'كاستريس', 'LC', 'LCA', 662, '1-758', 'XCD', 'آمریکا', 'کارائیب', NULL, 616.00, 183629, 'UTC-4', 'North America', '.lc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(81, '🇻🇨', 'سنت وینسنت و گرنادین‌ها', 'Saint Vincent and the Grenadines', 'سانت فنسنت والغرينادين', 'Saint Vincent and the Grenadines', 'کینگزتاون', 'Kingstown', 'كينغستاون', 'VC', 'VCT', 670, '1-784', 'XCD', 'آمریکا', 'کارائیب', NULL, 389.00, 110947, 'UTC-4', 'North America', '.vc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(82, '🇸🇨', 'سیشل', 'Seychelles', 'سيشل', 'Seychelles', 'ویکتوریا', 'Victoria', 'فيكتوريا', 'SC', 'SYC', 690, '248', 'SCR', 'آفریقا', 'شرقی آفریقا', NULL, 452.00, 98347, 'UTC+4', 'Africa', '.sc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(83, '🇸🇱', 'سیرالئون', 'Sierra Leone', 'سيراليون', 'Sierra Leone', 'فریتاون', 'Freetown', 'فريتاون', 'SL', 'SLE', 694, '232', 'SLL', 'آفریقا', 'غربی آفریقا', NULL, 71740.00, 7976985, 'UTC+0', 'Africa', '.sl', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(84, '🇸🇬', 'سنگاپور', 'Singapore', 'سنغافورة', 'Singapore', 'سنگاپور', 'Singapore', 'سنغافورة', 'SG', 'SGP', 702, '65', 'SGD', 'آسیا', 'جنوب شرقی آسیا', NULL, 719.00, 5850343, 'UTC+8', 'Asia', '.sg', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(85, '🇸🇰', 'اسلواکی', 'Slovakia', 'سلوفاكيا', 'Slovensko', 'براتیسلاوا', 'Bratislava', 'براتيسلافا', 'SK', 'SVK', 703, '421', 'EUR', 'اروپا', 'شرقی اروپا', NULL, 49035.00, 5459643, 'UTC+1', 'Europe', '.sk', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(86, '🇸🇮', 'اسلوونی', 'Slovenia', 'سلوفينيا', 'Slovenija', 'لیوبلیانا', 'Ljubljana', 'ليوبليانا', 'SI', 'SVN', 705, '386', 'EUR', 'اروپا', 'جنوبی اروپا', NULL, 20273.00, 2078932, 'UTC+1', 'Europe', '.si', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(87, '🇸🇧', 'جزایر سلیمان', 'Solomon Islands', 'جزر سليمان', 'Solomon Islands', 'هونیارا', 'Honiara', 'هونيارا', 'SB', 'SLB', 90, '677', 'SBD', 'اقیانوسیه', 'ملانزی', NULL, 28896.00, 686878, 'UTC+11', 'Oceania', '.sb', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(88, '🇸🇴', 'سومالی', 'Somalia', 'الصومال', 'Soomaaliya', 'موگادیشو', 'Mogadishu', 'مقديشو', 'SO', 'SOM', 706, '252', 'SOS', 'آفریقا', 'شرقی آفریقا', NULL, 637657.00, 15893219, 'UTC+3', 'Africa', '.so', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(90, '🇸🇸', 'سودان جنوبی', 'South Sudan', 'جنوب السودان', 'South Sudan', 'جوبا', 'Juba', 'جوبا', 'SS', 'SSD', 728, '211', 'SSP', 'آفریقا', 'شرقی آفریقا', NULL, 619745.00, 11193729, 'UTC+3', 'Africa', '.ss', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(91, '🇱🇰', 'سری‌لانکا', 'Sri Lanka', 'سريلانكا', 'ශ්‍රී ලංකාව', 'کلمبو', 'Colombo', 'كولمبو', 'LK', 'LKA', 144, '94', 'LKR', 'آسیا', 'جنوبی آسیا', NULL, 65610.00, 21413250, 'UTC+5:30', 'Asia', '.lk', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(92, '🇸🇩', 'سودان', 'Sudan', 'السودان', 'السودان', 'خرطوم', 'Khartoum', 'الخرطوم', 'SD', 'SDN', 729, '249', 'SDG', 'آفریقا', 'شمالی آفریقا', NULL, 1861484.00, 43849269, 'UTC+3', 'Africa', '.sd', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(93, '🇸🇷', 'سورینام', 'Suriname', 'سورينام', 'Suriname', 'پاراماریبو', 'Paramaribo', 'باراماريبو', 'SR', 'SUR', 740, '597', 'SRD', 'آمریکا', 'جنوبی آمریکا', NULL, 163820.00, 586634, 'UTC-3', 'South America', '.sr', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(94, '🇸🇪', 'سوئد', 'Sweden', 'السويد', 'Sverige', 'استکهلم', 'Stockholm', 'ستوكهولم', 'SE', 'SWE', 752, '46', 'SEK', 'اروپا', 'شمالی اروپا', NULL, 450295.00, 10099270, 'UTC+1', 'Europe', '.se', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(95, '🇨🇭', 'سوئیس', 'Switzerland', 'سويسرا', 'Schweiz', 'برن', 'Bern', 'برن', 'CH', 'CHE', 756, '41', 'CHF', 'اروپا', 'غربی اروپا', NULL, 41284.00, 8654618, 'UTC+1', 'Europe', '.ch', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(96, '🇸🇾', 'سوریه', 'Syria', 'سوريا', 'سوريا', 'دمشق', 'Damascus', 'دمشق', 'SY', 'SYR', 760, '963', 'SYP', 'آسیا', 'غربی آسیا', NULL, 185180.00, 17500657, 'UTC+2', 'Asia', '.sy', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(97, '🇹🇯', 'تاجیکستان', 'Tajikistan', 'طاجيكستان', 'Тоҷикистон', 'دوشنبه', 'Dushanbe', 'دوشنبه', 'TJ', 'TJK', 762, '992', 'TJS', 'آسیا', 'مرکزی آسیا', NULL, 143100.00, 9537642, 'UTC+5', 'Asia', '.tj', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(98, '🇹🇿', 'تانزانیا', 'Tanzania', 'تنزانيا', 'Tanzania', 'دودوما', 'Dodoma', 'دودوما', 'TZ', 'TZA', 834, '255', 'TZS', 'آفریقا', 'شرقی آفریقا', NULL, 945087.00, 59734213, 'UTC+3', 'Africa', '.tz', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(99, '🇹🇭', 'تایلند', 'Thailand', 'تايلاند', 'ประเทศไทย', 'بانکوک', 'Bangkok', 'بانكوك', 'TH', 'THA', 764, '66', 'THB', 'آسیا', 'جنوب شرقی آسیا', NULL, 513120.00, 69799978, 'UTC+7', 'Asia', '.th', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(100, '🇹🇱', 'تیمور شرقی', 'Timor-Leste', 'تيمور الشرقية', 'Timor-Leste', 'دیلی', 'Dili', 'ديلي', 'TL', 'TLS', 626, '670', 'USD', 'آسیا', 'جنوب شرقی آسیا', NULL, 14874.00, 1318442, 'UTC+9', 'Asia', '.tl', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(101, '🇹🇬', 'توگو', 'Togo', 'توغو', 'Togo', 'لومه', 'Lomé', 'لومي', 'TG', 'TGO', 768, '228', 'XOF', 'آفریقا', 'غربی آفریقا', NULL, 56785.00, 8278737, 'UTC+0', 'Africa', '.tg', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(102, '🇹🇴', 'تونگا', 'Tonga', 'تونغا', 'Tonga', 'نوکوآلوفا', 'Nukuʻalofa', 'نوكو ألوفا', 'TO', 'TON', 776, '676', 'TOP', 'اقیانوسیه', 'پلی‌نزی', NULL, 747.00, 105697, 'UTC+13', 'Oceania', '.to', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(103, '🇹🇹', 'ترینیداد و توباگو', 'Trinidad and Tobago', 'ترينيداد وتوباغو', 'Trinidad and Tobago', 'پورت آو اسپاین', 'Port of Spain', 'بورت أوف سبين', 'TT', 'TTO', 780, '1-868', 'TTD', 'آمریکا', 'کارائیب', NULL, 5130.00, 1399491, 'UTC-4', 'North America', '.tt', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(104, '🇹🇳', 'تونس', 'Tunisia', 'تونس', 'تونس', 'تونس', 'Tunis', 'تونس', 'TN', 'TUN', 788, '216', 'TND', 'آفریقا', 'شمالی آفریقا', NULL, 163610.00, 11818618, 'UTC+1', 'Africa', '.tn', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(106, '🇹🇲', 'ترکمنستان', 'Turkmenistan', 'تركمانستان', 'Türkmenistan', 'عشق‌آباد', 'Ashgabat', 'عشق آباد', 'TM', 'TKM', 795, '993', 'TMT', 'آسیا', 'مرکزی آسیا', NULL, 488100.00, 6031187, 'UTC+5', 'Asia', '.tm', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(107, '🇹🇻', 'تووالو', 'Tuvalu', 'توفالو', 'Tuvalu', 'فونافوتی', 'Funafuti', 'فونافوتي', 'TV', 'TUV', 798, '688', 'AUD', 'اقیانوسیه', 'پلی‌نزی', NULL, 26.00, 11792, 'UTC+12', 'Oceania', '.tv', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(108, '🇺🇬', 'اوگاندا', 'Uganda', 'أوغندا', 'Uganda', 'کامپالا', 'Kampala', 'كمبالا', 'UG', 'UGA', 800, '256', 'UGX', 'آفریقا', 'شرقی آفریقا', NULL, 241550.00, 45741000, 'UTC+3', 'Africa', '.ug', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(109, '🇺🇦', 'اوکراین', 'Ukraine', 'أوكرانيا', 'Україна', 'کی‌یف', 'Kyiv', 'كييف', 'UA', 'UKR', 804, '380', 'UAH', 'اروپا', 'شرقی اروپا', NULL, 603500.00, 43733759, 'UTC+2', 'Europe', '.ua', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(112, '🇺🇾', 'اروگوئه', 'Uruguay', 'أوروغواي', 'Uruguay', 'مونته‌ویدئو', 'Montevideo', 'مونتيفيديو', 'UY', 'URY', 858, '598', 'UYU', 'آمریکا', 'جنوبی آمریکا', NULL, 181034.00, 3473727, 'UTC-3', 'South America', '.uy', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(113, '🇺🇿', 'ازبکستان', 'Uzbekistan', 'أوزبكستان', 'Oʻzbekiston', 'تاشکند', 'Tashkent', 'طشقند', 'UZ', 'UZB', 860, '998', 'UZS', 'آسیا', 'مرکزی آسیا', NULL, 447400.00, 34232050, 'UTC+5', 'Asia', '.uz', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(114, '🇻🇺', 'وانواتو', 'Vanuatu', 'فانواتو', 'Vanuatu', 'پورت ویلا', 'Port Vila', 'بورت فيلا', 'VU', 'VUT', 548, '678', 'VUV', 'اقیانوسیه', 'ملانزی', NULL, 12189.00, 307150, 'UTC+11', 'Oceania', '.vu', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(115, '🇻🇪', 'ونزوئلا', 'Venezuela', 'فنزويلا', 'Venezuela', 'کاراکاس', 'Caracas', 'كاراكاس', 'VE', 'VEN', 862, '58', 'VES', 'آمریکا', 'جنوبی آمریکا', NULL, 916445.00, 28435943, 'UTC-4', 'South America', '.ve', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(116, '🇻🇳', 'ویتنام', 'Vietnam', 'فيتنام', 'Việt Nam', 'هانوی', 'Hanoi', 'هانوي', 'VN', 'VNM', 704, '84', 'VND', 'آسیا', 'جنوب شرقی آسیا', NULL, 331212.00, 97338583, 'UTC+7', 'Asia', '.vn', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(117, '🇾🇪', 'یمن', 'Yemen', 'اليمن', 'اليمن', 'صنعا', 'Sana\'a', 'صنعاء', 'YE', 'YEM', 887, '967', 'YER', 'آسیا', 'غربی آسیا', NULL, 527968.00, 29825968, 'UTC+3', 'Asia', '.ye', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(118, '🇿🇲', 'زامبیا', 'Zambia', 'زامبيا', 'Zambia', 'لوساکا', 'Lusaka', 'لوساكا', 'ZM', 'ZMB', 894, '260', 'ZMW', 'آفریقا', 'شرقی آفریقا', NULL, 752612.00, 18383956, 'UTC+2', 'Africa', '.zm', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(119, '🇿🇼', 'زیمبابوه', 'Zimbabwe', 'زيمبابوي', 'Zimbabwe', 'هراره', 'Harare', 'هراري', 'ZW', 'ZWE', 716, '263', 'ZWL', 'آفریقا', 'شرقی آفریقا', NULL, 390757.00, 14862927, 'UTC+2', 'Africa', '.zw', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(120, '🇹🇼', 'تایوان', 'Taiwan', 'تايوان', '臺灣', 'تایپه', 'Taipei', 'تايبيه', 'TW', 'TWN', 158, '886', 'TWD', 'آسیا', 'شرقی آسیا', NULL, 36193.00, 23816775, 'UTC+8', 'Asia', '.tw', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(121, '🇽🇰', 'کوزوو', 'Kosovo', 'كوسوفو', 'Kosovë', 'پریشتینا', 'Pristina', 'بريشتينا', 'XK', 'XKX', NULL, '383', 'EUR', 'اروپا', 'جنوب شرقی اروپا', NULL, 10887.00, 1810463, 'UTC+1', 'Europe', NULL, 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(122, '🇵🇸', 'فلسطین', 'Palestine', 'فلسطين', 'فلسطين', 'بیت‌المقدس', 'Jerusalem', 'القدس', 'PS', 'PSE', 275, '970', 'ILS', 'آسیا', 'غربی آسیا', NULL, 6020.00, 5101416, 'UTC+2', 'Asia', '.ps', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(123, '🇭🇰', 'هنگ‌کنگ', 'Hong Kong', 'هونغ كونغ', '香港', 'هنگ‌کنگ', 'Hong Kong', 'هونغ كونغ', 'HK', 'HKG', 344, '852', 'HKD', 'آسیا', 'شرقی آسیا', NULL, 1104.00, 7496988, 'UTC+8', 'Asia', '.hk', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(124, '🇲🇴', 'ماکائو', 'Macau', 'ماكاو', '澳門', 'ماکائو', 'Macau', 'ماكاو', 'MO', 'MAC', 446, '853', 'MOP', 'آسیا', 'شرقی آسیا', NULL, 30.00, 649342, 'UTC+8', 'Asia', '.mo', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(125, '🇬🇱', 'گرینلند', 'Greenland', 'جرينلاند', 'Kalaallit Nunaat', 'نوک', 'Nuuk', 'نوك', 'GL', 'GRL', 304, '299', 'DKK', 'آمریکا', 'شمالی آمریکا', NULL, 2166086.00, 56770, 'UTC-4 to -1', 'North America', '.gl', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(126, '🇵🇷', 'پورتوریکو', 'Puerto Rico', 'بورتوريكو', 'Puerto Rico', 'سان خوان', 'San Juan', 'سان خوان', 'PR', 'PRI', 630, '1-787, 1-9', 'USD', 'آمریکا', 'کارائیب', NULL, 8870.00, 3194034, 'UTC-4', 'North America', '.pr', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(127, '🇬🇺', 'گوام', 'Guam', 'غوام', 'Guam', 'هاگاتنیا', 'Hagåtña', 'هاغاتنا', 'GU', 'GUM', 316, '1-671', 'USD', 'اقیانوسیه', 'میکرونزی', NULL, 549.00, 168783, 'UTC+10', 'Oceania', '.gu', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(128, '🇲🇵', 'جزایر ماریانای شمالی', 'Northern Mariana Islands', 'جزر ماريانا الشمالية', 'Northern Mariana Islands', 'سایپان', 'Saipan', 'سايبان', 'MP', 'MNP', 580, '1-670', 'USD', 'اقیانوسیه', 'میکرونزی', NULL, 464.00, 57557, 'UTC+10', 'Oceania', '.mp', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(129, '🇻🇮', 'جزایر ویرجین ایالات متحده', 'U.S. Virgin Islands', 'جزر العذراء الأمريكية', 'U.S. Virgin Islands', 'شارلوت آمالی', 'Charlotte Amalie', 'شارلوت أمالي', 'VI', 'VIR', 850, '1-340', 'USD', 'آمریکا', 'کارائیب', NULL, 346.00, 104425, 'UTC-4', 'North America', '.vi', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(130, '🇦🇸', 'ساموآی آمریکا', 'American Samoa', 'ساموا الأمريكية', 'American Samoa', 'پاگو پاگو', 'Pago Pago', 'باغو باغو', 'AS', 'ASM', 16, '1-684', 'USD', 'اقیانوسیه', 'پلی‌نزی', NULL, 199.00, 55191, 'UTC-11', 'Oceania', '.as', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(131, '🇦🇮', 'آنگویلا', 'Anguilla', 'أنغويلا', 'Anguilla', 'د ولی', 'The Valley', 'ذا فالي', 'AI', 'AIA', 660, '1-264', 'XCD', 'آمریکا', 'کارائیب', NULL, 91.00, 15002, 'UTC-4', 'North America', '.ai', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(132, '🇧🇲', 'برمودا', 'Bermuda', 'برمودا', 'Bermuda', 'همیلتون', 'Hamilton', 'هاميلتون', 'BM', 'BMU', 60, '1-441', 'BMD', 'آمریکا', 'شمالی آمریکا', NULL, 54.00, 62273, 'UTC-4', 'North America', '.bm', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(133, '🇻🇬', 'جزایر ویرجین بریتانیا', 'British Virgin Islands', 'جزر العذراء البريطانية', 'British Virgin Islands', 'رود تاون', 'Road Town', 'رود تاون', 'VG', 'VGB', 92, '1-284', 'USD', 'آمریکا', 'کارائیب', NULL, 151.00, 30237, 'UTC-4', 'North America', '.vg', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(134, '🇰🇾', 'جزایر کیمن', 'Cayman Islands', 'جزر كايمان', 'Cayman Islands', 'جرج تاون', 'George Town', 'جورج تاون', 'KY', 'CYM', 136, '1-345', 'KYD', 'آمریکا', 'کارائیب', NULL, 264.00, 65720, 'UTC-5', 'North America', '.ky', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(135, '🇫🇰', 'جزایر فالکلند', 'Falkland Islands', 'جزر فوكلاند', 'Falkland Islands', 'استنلی', 'Stanley', 'ستانلي', 'FK', 'FLK', 238, '500', 'FKP', 'آمریکا', 'جنوبی آمریکا', NULL, 12173.00, 3480, 'UTC-3', 'South America', '.fk', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(136, '🇬🇮', 'جبل‌الطارق', 'Gibraltar', 'جبل طارق', 'Gibraltar', 'جبل‌الطارق', 'Gibraltar', 'جبل طارق', 'GI', 'GIB', 292, '350', 'GIP', 'اروپا', 'جنوبی اروپا', NULL, 6.80, 33691, 'UTC+1', 'Europe', '.gi', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(137, '🇬🇬', 'گرنزی', 'Guernsey', 'غيرنزي', 'Guernsey', 'سنت پتر پورت', 'St. Peter Port', 'سانت بيتر بورت', 'GG', 'GGY', 831, '44-1481', 'GBP', 'اروپا', 'شمال غربی اروپا', NULL, 78.00, 63026, 'UTC+0', 'Europe', '.gg', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(138, '🇯🇪', 'جرزی', 'Jersey', 'جيرزي', 'Jersey', 'سنت هلیه', 'Saint Helier', 'سانت هيلير', 'JE', 'JEY', 832, '44-1534', 'GBP', 'اروپا', 'شمال غربی اروپا', NULL, 116.00, 100800, 'UTC+0', 'Europe', '.je', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(139, '🇮🇲', 'جزیره من', 'Isle of Man', 'جزيرة مان', 'Isle of Man', 'داگلاس', 'Douglas', 'دوغلاس', 'IM', 'IMN', 833, '44-1624', 'GBP', 'اروپا', 'شمال غربی اروپا', NULL, 572.00, 85032, 'UTC+0', 'Europe', '.im', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(141, '🇲🇸', 'مونت‌سرات', 'Montserrat', 'مونتسيرات', 'Montserrat', 'پلیموث', 'Plymouth', 'بليموث', 'MS', 'MSR', 500, '1-664', 'XCD', 'آمریکا', 'کارائیب', NULL, 102.00, 4922, 'UTC-4', 'North America', '.ms', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(142, '🇵🇳', 'جزایر پیت‌کرن', 'Pitcairn Islands', 'جزر بيتكيرن', 'Pitcairn Islands', 'آدامزتاون', 'Adamstown', 'آدمزتاون', 'PN', 'PCN', 612, '64', 'NZD', 'اقیانوسیه', 'پلی‌نزی', NULL, 47.00, 50, 'UTC-8', 'Oceania', '.pn', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(143, '🇸🇭', 'سنت هلن', 'Saint Helena', 'سانت هيلينا', 'Saint Helena', 'جیمزتاون', 'Jamestown', 'جيمستاون', 'SH', 'SHN', 654, '290', 'SHP', 'آفریقا', 'غربی آفریقا', NULL, 394.00, 6059, 'UTC+0', 'Africa', '.sh', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(144, '🇸🇯', 'سوالبارد و یان ماین', 'Svalbard and Jan Mayen', 'سفالبارد ويان ماين', 'Svalbard og Jan Mayen', 'لونگیربین', 'Longyearbyen', 'لونغياربين', 'SJ', 'SJM', 744, '47', 'NOK', 'اروپا', 'شمالی اروپا', NULL, 62422.00, 2562, 'UTC+1', 'Europe', '.sj', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(145, '🇹🇨', 'جزایر تورکس و کایکوس', 'Turks and Caicos Islands', 'جزر توركس وكايكوس', 'Turks and Caicos Islands', 'کاکبرن تاون', 'Cockburn Town', 'كوكبورن تاون', 'TC', 'TCA', 796, '1-649', 'USD', 'آمریکا', 'کارائیب', NULL, 948.00, 38717, 'UTC-5', 'North America', '.tc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(146, '🇼🇫', 'والیس و فوتونا', 'Wallis and Futuna', 'واليس وفوتونا', 'Wallis et Futuna', 'ماتا-اتو', 'Mata-Utu', 'ماتا-أوتو', 'WF', 'WLF', 876, '681', 'XPF', 'اقیانوسیه', 'پلی‌نزی', NULL, 142.00, 11239, 'UTC+12', 'Oceania', '.wf', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(147, '🇪🇭', 'صحرای غربی', 'Western Sahara', 'الصحراء الغربية', 'الصحراء الغربية', 'العیون', 'El Aaiún', 'العيون', 'EH', 'ESH', 732, '212', 'MAD', 'آفریقا', 'شمالی آفریقا', NULL, 266000.00, 582463, 'UTC+0', 'Africa', NULL, 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(148, '🇦🇽', 'جزایر آلند', 'Åland Islands', 'جزر أولاند', 'Åland', 'ماریهامن', 'Mariehamn', 'ماريهامن', 'AX', 'ALA', 248, '358', 'EUR', 'اروپا', 'شمالی اروپا', NULL, 1580.00, 29689, 'UTC+2', 'Europe', '.ax', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(149, '🇨🇼', 'کوراسائو', 'Curaçao', 'كوراساو', 'Curaçao', 'ویلمستاد', 'Willemstad', 'ويلمستاد', 'CW', 'CUW', 531, '599', 'ANG', 'آمریکا', 'کارائیب', NULL, 444.00, 164100, 'UTC-4', 'North America', '.cw', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(150, '🇲🇫', 'سنت مارتین', 'Saint Martin', 'سانت مارتين', 'Saint-Martin', 'ماریگو', 'Marigot', 'ماريغو', 'MF', 'MAF', 663, '590', 'EUR', 'آمریکا', 'کارائیب', NULL, 53.00, 38659, 'UTC-4', 'North America', '.mf', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(151, '🇸🇽', 'سنت مارتین', 'Sint Maarten', 'سينت مارتن', 'Sint Maarten', 'فیلیپسبورگ', 'Philipsburg', 'فيلبسبورخ', 'SX', 'SXM', 534, '1-721', 'ANG', 'آمریکا', 'کارائیب', NULL, 34.00, 42876, 'UTC-4', 'North America', '.sx', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(152, '🇧🇶', 'جزایر کارائیب هلند', 'Caribbean Netherlands', 'هولندا الكاريبية', 'Caribisch Nederland', 'کرالندیج', 'Kralendijk', 'كراليندايك', 'BQ', 'BES', 535, '599', 'USD', 'آمریکا', 'کارائیب', NULL, 328.00, 25979, 'UTC-4', 'North America', '.bq', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(154, '🇹🇫', 'سرزمین‌های جنوبی فرانسه', 'French Southern Territories', 'أراض فرنسية جنوبية', 'Terres australes françaises', 'پورت-او-فرانس', 'Port-aux-Français', 'بورتو فرانسيه', 'TF', 'ATF', 260, NULL, 'EUR', 'قطب جنوب', NULL, NULL, 7829.00, 140, 'UTC+5', 'Antarctica', '.tf', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(155, '🇺🇲', 'جزایر کوچک حاشیه‌ای ایالات متحده', 'U.S. Minor Outlying Islands', 'جزر الولايات المتحدة الصغيرة النائية', 'U.S. Minor Outlying Islands', NULL, NULL, NULL, 'UM', 'UMI', 581, NULL, 'USD', 'اقیانوسیه', 'میکرونزی/پلی‌نزی', NULL, 34.20, 300, 'UTC-12 to -11', 'Oceania', '.us', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(156, '🇮🇴', 'قلمرو بریتانیا در اقیانوس هند', 'British Indian Ocean Territory', 'إقليم المحيط الهندي البريطاني', 'British Indian Ocean Territory', 'دیگو گارسیا', 'Diego Garcia', 'دييغو غارسيا', 'IO', 'IOT', 86, '246', 'USD', 'آفریقا', 'شرقی آفریقا', NULL, 60.00, 3000, 'UTC+6', 'Africa', '.io', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(157, '🇨🇨', 'جزایر کوکوس', 'Cocos (Keeling) Islands', 'جزر كوكوس', 'Cocos (Keeling) Islands', 'وست آیلند', 'West Island', 'ويست آيلند', 'CC', 'CCK', 166, '61', 'AUD', 'آسیا', 'جنوب شرقی آسیا', NULL, 14.00, 596, 'UTC+6:30', 'Asia', '.cc', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(158, '🇨🇽', 'جزیره کریسمس', 'Christmas Island', 'جزيرة كريسماس', 'Christmas Island', 'فلیینگ فیش کاو', 'Flying Fish Cove', 'فلاينغ فيش كوف', 'CX', 'CXR', 162, '61', 'AUD', 'آسیا', 'جنوب شرقی آسیا', NULL, 135.00, 1843, 'UTC+7', 'Asia', '.cx', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(159, '🇳🇫', 'جزیره نورفولک', 'Norfolk Island', 'جزيرة نورفولك', 'Norfolk Island', 'کینگستون', 'Kingston', 'كينغستون', 'NF', 'NFK', 574, '672', 'AUD', 'اقیانوسیه', 'استرالیا و نیوزیلند', NULL, 36.00, 1748, 'UTC+11:30', 'Oceania', '.nf', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(160, '🇳🇺', 'نیوئه', 'Niue', 'نيوي', 'Niue', 'آلوفی', 'Alofi', 'ألوفي', 'NU', 'NIU', 570, '683', 'NZD', 'اقیانوسیه', 'پلی‌نزی', NULL, 260.00, 1624, 'UTC-11', 'Oceania', '.nu', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(161, '🇹🇰', 'توکلائو', 'Tokelau', 'توكيلاو', 'Tokelau', 'فاکائوفو', 'Fakaofo', 'فاكاوفو', 'TK', 'TKL', 772, '690', 'NZD', 'اقیانوسیه', 'پلی‌نزی', NULL, 12.00, 1411, 'UTC+13', 'Oceania', '.tk', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(163, '🇬🇵', 'گوادلوپ', 'Guadeloupe', 'غوادلوب', 'Guadeloupe', 'باس-تر', 'Basse-Terre', 'باس-تير', 'GP', 'GLP', 312, '590', 'EUR', 'آمریکا', 'کارائیب', NULL, 1628.00, 400127, 'UTC-4', 'North America', '.gp', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(164, '🇲🇶', 'مارتینیک', 'Martinique', 'مارتينيك', 'Martinique', 'فور-دو-فرانس', 'Fort-de-France', 'فور دو فرانس', 'MQ', 'MTQ', 474, '596', 'EUR', 'آمریکا', 'کارائیب', NULL, 1128.00, 375265, 'UTC-4', 'North America', '.mq', 0, '2025-05-16 21:00:47', '2025-05-16 21:00:47'),
(165, '🇷🇪', 'رئونیون', 'Réunion', 'ريونيون', 'La Réunion', 'سن-دنی', 'Saint-Denis', 'سان-دني', 'RE', 'REU', 638, '262', 'EUR', 'آفریقا', 'شرقی آفریقا', NULL, 2511.00, 895308, 'UTC+4', 'Africa', '.re', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(166, '🇾🇹', 'مایوت', 'Mayotte', 'مايوت', 'Mayotte', 'مامودزو', 'Mamoudzou', 'مامودزو', 'YT', 'MYT', 175, '262', 'EUR', 'آفریقا', 'شرقی آفریقا', NULL, 374.00, 272815, 'UTC+3', 'Africa', '.yt', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(167, '🇵🇲', 'سن پیر و میکلون', 'Saint Pierre and Miquelon', 'سان بيير وميكلون', 'Saint-Pierre-et-Miquelon', 'سن-پیر', 'Saint-Pierre', 'سان-بيير', 'PM', 'SPM', 666, '508', 'EUR', 'آمریکا', 'شمالی آمریکا', NULL, 242.00, 5794, 'UTC-3', 'North America', '.pm', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(168, '🇬🇩', 'گرنادا', 'Grenada', 'غرينادا', 'Grenada', 'سنت جورج', 'St. George\'s', 'سانت جورجز', 'GD', 'GRD', 308, '1-473', 'XCD', 'آمریکا', 'کارائیب', NULL, 344.00, 112519, 'UTC-4', 'North America', '.gd', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(172, '🇦🇬', 'آنتیگوا و باربودا', 'Antigua and Barbuda', 'أنتيغوا وباربودا', 'Antigua and Barbuda', 'سنت جانز', 'St. John\'s', 'سانت جونز', 'AG', 'ATG', 28, '1-268', 'XCD', 'آمریکا', 'کارائیب', NULL, 442.00, 97928, 'UTC-4', 'North America', '.ag', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(173, '🇩🇲', 'دومینیکا', 'Dominica', 'دومينيكا', 'Dominica', 'روزو', 'Roseau', 'روزو', 'DM', 'DMA', 212, '1-767', 'XCD', 'آمریکا', 'کارائیب', NULL, 751.00, 71991, 'UTC-4', 'North America', '.dm', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(175, '🇦🇼', 'آروبا', 'Aruba', 'أروبا', 'Aruba', 'اورنجستاد', 'Oranjestad', 'أورنجستاد', 'AW', 'ABW', 533, '297', 'AWG', 'آمریکا', 'کارائیب', NULL, 180.00, 106766, 'UTC-4', 'North America', '.aw', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(178, '🇧🇱', 'سن بارتلمی', 'Saint Barthélemy', 'سان بارتيلمي', 'Saint-Barthélemy', 'گوستاویا', 'Gustavia', 'غوستافيا', 'BL', 'BLM', 652, '590', 'EUR', 'آمریکا', 'کارائیب', NULL, 21.00, 9847, 'UTC-4', 'North America', '.bl', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(182, '🇬🇾', 'گویان فرانسه', 'French Guiana', 'غويانا الفرنسية', 'Guyane française', 'کاین', 'Cayenne', 'كايين', 'GF', 'GUF', 254, '594', 'EUR', 'آمریکا', 'جنوبی آمریکا', NULL, 83534.00, 298682, 'UTC-3', 'South America', '.gf', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(183, '🇬🇫', 'گویان', 'Guyana', 'غيانا', 'Guyana', 'جورج تاون', 'Georgetown', 'جورج تاون', 'GY', 'GUY', 328, '592', 'GYD', 'آمریکا', 'جنوبی آمریکا', NULL, 214969.00, 786559, 'UTC-4', 'South America', '.gy', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(185, '🇵🇪', 'پرو', 'Peru', 'بيرو', 'Perú', 'لیما', 'Lima', 'ليما', 'PE', 'PER', 604, '51', 'PEN', 'آمریکا', 'جنوبی آمریکا', NULL, 1285216.00, 32971846, 'UTC-5', 'South America', '.pe', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(186, '🇵🇾', 'پاراگوئه', 'Paraguay', 'باراغواي', 'Paraguay', 'آسونسیون', 'Asunción', 'أسونسيون', 'PY', 'PRY', 600, '595', 'PYG', 'آمریکا', 'جنوبی آمریکا', NULL, 406752.00, 7132530, 'UTC-4', 'South America', '.py', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(188, '🇫🇴', 'جزایر فارو', 'Faroe Islands', 'جزر فارو', 'Føroyar', 'توشهاون', 'Tórshavn', 'تورشافن', 'FO', 'FRO', 234, '298', 'DKK', 'اروپا', 'شمالی اروپا', NULL, 1399.00, 48863, 'UTC+0', 'Europe', '.fo', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(190, '🇵🇫', 'پلی‌نزی فرانسه', 'French Polynesia', 'بولينيزيا الفرنسية', 'Polynésie française', 'پاپته', 'Papeete', 'بابيتي', 'PF', 'PYF', 258, '689', 'XPF', 'اقیانوسیه', 'پلی‌نزی', NULL, 4167.00, 280904, 'UTC-10, -9:30, -9', 'Oceania', '.pf', 0, '2025-05-16 21:03:40', '2025-05-16 21:03:40'),
(194, '🇨🇰', 'جزایر کوک', 'Cook Islands', 'جزر كوك', 'Cook Islands', 'آواروآ', 'Avarua', 'أفاروا', 'CK', 'COK', 184, '682', 'NZD', 'اقیانوسیه', 'پلی‌نزی', NULL, 236.00, 17564, 'UTC-10', 'Oceania', '.ck', 0, '2025-05-16 21:04:38', '2025-05-16 21:04:38'),
(213, '🇦🇶', 'جنوبگان', 'Antarctica', 'أنتاركتيكا', 'Antarctica', NULL, NULL, NULL, 'AQ', 'ATA', 10, NULL, NULL, 'قطب جنوب', NULL, NULL, 14000000.00, 1106, 'UTC-12 to +12', 'Antarctica', '.aq', 0, '2025-05-16 21:04:38', '2025-05-16 21:04:38'),
(214, '🇧🇻', 'جزیره بووه', 'Bouvet Island', 'جزيرة بوفيه', 'Bouvetøya', NULL, NULL, NULL, 'BV', 'BVT', 74, NULL, 'NOK', 'قطب جنوب', NULL, NULL, 49.00, 0, 'UTC+1', 'Antarctica', '.bv', 0, '2025-05-16 21:04:38', '2025-05-16 21:04:38'),
(216, '🇭🇲', 'جزیره هرد و جزایر مک‌دونالد', 'Heard Island and McDonald Islands', 'جزيرة هيرد وجزر ماكدونالد', 'Heard Island and McDonald Islands', NULL, NULL, NULL, 'HM', 'HMD', 334, NULL, 'AUD', 'قطب جنوب', NULL, NULL, 412.00, 0, 'UTC+5', 'Antarctica', '.hm', 0, '2025-05-16 21:05:30', '2025-05-16 21:05:30'),
(217, '🇬🇸', 'جزایر جورجیای جنوبی و ساندویچ جنوبی', 'South Georgia and the South Sandwich Islands', 'جزر جورجيا الجنوبية وجزر ساندويتش الجنوبية', 'South Georgia and the South Sandwich Islands', 'گریتویکن', 'Grytviken', 'غريتفيكن', 'GS', 'SGS', 239, NULL, 'GBP', 'قطب جنوب', NULL, NULL, 3903.00, 30, 'UTC-2', 'Antarctica', '.gs', 0, '2025-05-16 21:05:30', '2025-05-16 21:05:30'),
(219, '🇮🇨', 'جزایر قناری', 'Canary Islands', 'جزر الكناري', 'Canarias', 'لاس پالماس', 'Las Palmas', 'لاس بالماس', 'IC', '', NULL, '34', 'EUR', 'آفریقا', 'شمالی آفریقا', NULL, 7447.00, 2153389, 'UTC+0', 'Africa', NULL, 0, '2025-05-16 21:05:30', '2025-05-16 21:05:30'),
(220, '🇨🇵', 'جزیره کلیپرتون', 'Clipperton Island', 'جزيرة كليبرتون', 'Île Clipperton', NULL, NULL, NULL, 'CP', 'CPT', NULL, NULL, 'EUR', 'آمریکا', 'شمالی آمریکا', NULL, 6.00, 0, 'UTC-8', 'North America', NULL, 0, '2025-05-16 21:06:39', '2025-05-16 21:06:39'),
(221, '🇩🇬', 'دیگو گارسیا', 'Diego Garcia', 'دييغو غارسيا', 'Diego Garcia', NULL, NULL, NULL, 'DG', 'DGA', NULL, '246', 'USD', 'آفریقا', 'شرقی آفریقا', NULL, 30.00, 4000, 'UTC+6', 'Africa', NULL, 0, '2025-05-16 21:06:39', '2025-05-16 21:06:39');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(301, '🇴🇲', 'عمان', 'Oman', 'عُمان', 'عُمان', 'مسقط', 'Muscat', 'مسقط', 'OM', 'OMN', 512, '968', 'OMR', 'آسیا', 'غربی آسیا', 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, 309500.00, 5106622, 'UTC+4', 'Asia', '.om', 1, '2025-05-16 21:26:19', '2025-05-16 21:37:11'),
(302, '🇶🇦', 'قطر', 'Qatar', 'قطر', 'قطر', 'دوحه', 'Doha', 'الدوحة', 'QA', 'QAT', 634, '974', 'QAR', 'آسیا', 'غربی آسیا', 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, 11586.00, 2881060, 'UTC+3', 'Asia', '.qa', 1, '2025-05-16 21:26:20', '2025-05-16 21:37:19');
INSERT INTO `state1_countries` (`id`, `flag`, `name`, `name_en`, `name_ar`, `native_name`, `capital`, `capital_en`, `capital_ar`, `iso_code`, `iso_code3`, `num_code`, `phone_code`, `currency_code`, `region`, `subregion`, `boundaries`, `area`, `population`, `timezone`, `continent`, `tld`, `is_active`, `created_at`, `updated_at`) VALUES
(303, '🇰🇼', 'کویت', 'Kuwait', 'الكويت', 'الكويت', 'کویت', 'Kuwait City', 'مدينة الكويت', 'KW', 'KWT', 414, '965', 'KWD', 'آسیا', 'غربی آسیا', 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, 17818.00, 4270563, 'UTC+3', 'Asia', '.kw', 1, '2025-05-16 21:26:20', '2025-05-16 21:37:15');

-- --------------------------------------------------------

--
-- Table structure for table `state2_provinces`
--

CREATE TABLE `state2_provinces` (
  `id` int(11) NOT NULL COMMENT 'شناسه استان',
  `country_id` int(11) NOT NULL COMMENT 'شناسه کشور (ایران)',
  `name` varchar(100) NOT NULL COMMENT 'نام استان',
  `name_en` varchar(100) DEFAULT NULL COMMENT 'نام انگلیسی',
  `name_ar` varchar(50) DEFAULT NULL COMMENT 'نام استان به عربی',
  `code` varchar(10) DEFAULT NULL COMMENT 'کد استاندارد',
  `slug` varchar(100) NOT NULL COMMENT 'نامک',
  `global_slug` varchar(255) DEFAULT NULL,
  `center_city_name` varchar(100) DEFAULT NULL COMMENT 'مرکز استان',
  `boundaries` geometry DEFAULT NULL COMMENT 'مرزها (GeoJSON)',
  `area` decimal(10,2) DEFAULT NULL COMMENT 'مساحت (کیلومتر مربع)',
  `population` bigint(20) DEFAULT NULL COMMENT 'جمعیت',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول استان‌های ایران';

--
-- Dumping data for table `state2_provinces`
--

INSERT INTO `state2_provinces` (`id`, `country_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `center_city_name`, `boundaries`, `area`, `population`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(0, 1, 'مرکزی', 'Markazi', NULL, '00', 'markazi', 'iran-markazi', 'اراک', NULL, 29127.00, 1429475, 'استان مرکزی یکی از استان‌های ایران است که در مرکز کشور قرار دارد.', 0, '2025-04-26 22:12:11', '2025-04-29 12:31:39', NULL),
(1, 1, 'گیلان', 'Gilan', NULL, '01', 'gilan', 'iran-gilan', 'رشت', NULL, 14042.00, 2530696, 'استان گیلان در شمال ایران و جنوب دریای خزر قرار دارد.', 0, '2025-04-26 22:14:07', '2025-04-29 12:31:39', NULL),
(2, 1, 'مازندران', 'Mazandaran', NULL, '02', 'mazandaran', 'iran-mazandaran', 'ساری', NULL, 23842.00, 3283582, 'استان مازندران در شمال ایران و در کرانه جنوبی دریای خزر قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(3, 1, 'آذربایجان شرقی', 'East Azerbaijan', NULL, '03', 'east-azerbaijan', 'iran-east-azerbaijan', 'تبریز', NULL, 45650.00, 3909652, 'استان آذربایجان شرقی در شمال غربی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(4, 1, 'آذربایجان غربی', 'West Azerbaijan', NULL, '04', 'west-azerbaijan', 'iran-west-azerbaijan', 'ارومیه', NULL, 37437.00, 3265219, 'استان آذربایجان غربی در شمال غربی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(5, 1, 'کرمانشاه', 'Kermanshah', NULL, '05', 'kermanshah', 'iran-kermanshah', 'کرمانشاه', NULL, 24998.00, 1952434, 'استان کرمانشاه در غرب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(6, 1, 'خوزستان', 'Khuzestan', NULL, '06', 'khuzestan', 'iran-khuzestan', 'اهواز', NULL, 64055.00, 4710509, 'استان خوزستان در جنوب غربی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(7, 1, 'فارس', 'Fars', NULL, '07', 'fars', 'iran-fars', 'شیراز', NULL, 122608.00, 4851274, 'استان فارس در جنوب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(8, 1, 'کرمان', 'Kerman', NULL, '08', 'kerman', 'iran-kerman', 'کرمان', NULL, 180726.00, 3164718, 'استان کرمان در جنوب شرقی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(9, 1, 'خراسان رضوی', 'Razavi Khorasan', NULL, '09', 'razavi-khorasan', 'iran-razavi-khorasan', 'مشهد', NULL, 118854.00, 6434501, 'استان خراسان رضوی در شمال شرقی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(10, 1, 'اصفهان', 'Isfahan', NULL, '10', 'isfahan', 'iran-isfahan', 'اصفهان', NULL, 107029.00, 5120850, 'استان اصفهان در مرکز ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(11, 1, 'سیستان و بلوچستان', 'Sistan and Baluchestan', NULL, '11', 'sistan-baluchestan', 'iran-sistan-baluchestan', 'زاهدان', NULL, 181785.00, 2775014, 'استان سیستان و بلوچستان در جنوب شرقی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(12, 1, 'کردستان', 'Kurdistan', NULL, '12', 'kurdistan', 'iran-kurdistan', 'سنندج', NULL, 29137.00, 1603011, 'استان کردستان در غرب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(13, 1, 'همدان', 'Hamadan', NULL, '13', 'hamadan', 'iran-hamadan', 'همدان', NULL, 19368.00, 1758268, 'استان همدان در غرب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(14, 1, 'چهارمحال و بختیاری', 'Chaharmahal and Bakhtiari', NULL, '14', 'chaharmahal-bakhtiari', 'iran-chaharmahal-bakhtiari', 'شهرکرد', NULL, 16332.00, 947763, 'استان چهارمحال و بختیاری در غرب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(15, 1, 'لرستان', 'Lorestan', NULL, '15', 'lorestan', 'iran-lorestan', 'خرم‌آباد', NULL, 28294.00, 1760649, 'استان لرستان در غرب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(16, 1, 'ایلام', 'Ilam', NULL, '16', 'ilam', 'iran-ilam', 'ایلام', NULL, 20133.00, 580158, 'استان ایلام در غرب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(17, 1, 'کهگیلویه و بویراحمد', 'Kohgiluyeh and Boyer-Ahmad', NULL, '17', 'kohgiluyeh-boyer-ahmad', 'iran-kohgiluyeh-boyer-ahmad', 'یاسوج', NULL, 15504.00, 713052, 'استان کهگیلویه و بویراحمد در جنوب غربی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(18, 1, 'بوشهر', 'Bushehr', NULL, '18', 'bushehr', 'iran-bushehr', 'بوشهر', NULL, 22742.00, 1163400, 'استان بوشهر در جنوب ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(19, 1, 'زنجان', 'Zanjan', NULL, '19', 'zanjan', 'iran-zanjan', 'زنجان', NULL, 21773.00, 1057461, 'استان زنجان در شمال غربی ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(20, 1, 'سمنان', 'Semnan', NULL, '20', 'semnan', 'iran-semnan', 'سمنان', NULL, 97491.00, 702360, 'استان سمنان در شمال ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL),
(21, 1, 'یزد', 'Yazd', NULL, '21', 'yazd', 'iran-yazd', 'یزد', NULL, 129285.00, 1138533, 'استان یزد در مرکز ایران قرار دارد.', 0, '2025-04-26 22:15:04', '2025-04-29 12:31:39', NULL);
INSERT INTO `state2_provinces` (`id`, `country_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `center_city_name`, `boundaries`, `area`, `population`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(22, 1, 'هرمزگان', 'Hormozgan', NULL, '22', 'hormozgan', 'iran-hormozgan', 'بندرعباس', 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, 70697.00, 1800000, 'استان هرمزگان در جنوب ایران و در کرانه خلیج فارس و دریای عمان قرار دارد.', 1, '2025-04-24 16:14:31', '2025-04-29 12:31:59', NULL),
(23, 1, 'تهران', 'Tehran', NULL, '23', 'tehran', 'iran-tehran', 'تهران', NULL, 13692.00, 13267637, 'استان تهران در شمال ایران قرار دارد و پایتخت کشور است.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(24, 1, 'اردبیل', 'Ardabil', NULL, '24', 'ardabil', 'iran-ardabil', 'اردبیل', NULL, 17800.00, 1270420, 'استان اردبیل در شمال غربی ایران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(25, 1, 'قم', 'Qom', NULL, '25', 'qom', 'iran-qom', 'قم', NULL, 11237.00, 1292283, 'استان قم در مرکز ایران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(26, 1, 'قزوین', 'Qazvin', NULL, '26', 'qazvin', 'iran-qazvin', 'قزوین', NULL, 15549.00, 1273761, 'استان قزوین در شمال غربی ایران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(27, 1, 'گلستان', 'Golestan', NULL, '27', 'golestan', 'iran-golestan', 'گرگان', NULL, 20367.00, 1868819, 'استان گلستان در شمال ایران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(28, 1, 'خراسان شمالی', 'North Khorasan', NULL, '28', 'north-khorasan', 'iran-north-khorasan', 'بجنورد', NULL, 28434.00, 863092, 'استان خراسان شمالی در شمال شرقی ایران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(29, 1, 'خراسان جنوبی', 'South Khorasan', NULL, '29', 'south-khorasan', 'iran-south-khorasan', 'بیرجند', NULL, 151913.00, 768898, 'استان خراسان جنوبی در شرق ایران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL),
(30, 1, 'البرز', 'Alborz', NULL, '30', 'alborz', 'iran-alborz', 'کرج', NULL, 5834.00, 2712400, 'استان البرز در شمال ایران و نزدیک به تهران قرار دارد.', 0, '2025-04-26 22:15:59', '2025-04-29 12:31:39', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `state3_counties`
--

CREATE TABLE `state3_counties` (
  `id` int(11) NOT NULL COMMENT 'شناسه شهرستان',
  `province_id` int(11) NOT NULL COMMENT 'شناسه استان',
  `name` varchar(100) NOT NULL COMMENT 'نام شهرستان',
  `name_en` varchar(100) DEFAULT NULL COMMENT 'نام انگلیسی',
  `name_ar` varchar(50) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL COMMENT 'کد استاندارد',
  `slug` varchar(100) NOT NULL COMMENT 'نامک',
  `global_slug` varchar(255) DEFAULT NULL COMMENT 'نامک سراسری',
  `center_city_name` varchar(100) DEFAULT NULL COMMENT 'مرکز شهرستان',
  `boundaries` geometry DEFAULT NULL COMMENT 'مرزها (GeoJSON)',
  `area` decimal(10,2) DEFAULT NULL COMMENT 'مساحت (کیلومتر مربع)',
  `population` bigint(20) DEFAULT NULL COMMENT 'جمعیت',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول شهرستان‌های ایران';

--
-- Dumping data for table `state3_counties`
--

INSERT INTO `state3_counties` (`id`, `province_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `center_city_name`, `boundaries`, `area`, `population`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 22, 'ابوموسی', 'Abu Musa', NULL, '01', 'abu-musa', 'iran-hormozgan-abu-musa', 'ابوموسی', NULL, 68.00, 5000, 'شهرستان ابوموسی در جنوبی‌ترین نقطه ایران و در خلیج فارس قرار دارد و شامل جزایر استراتژیک متعددی می‌باشد.', 1, '2025-04-24 17:20:48', '2025-04-24 17:20:48', NULL),
(2, 22, 'بندرعباس', 'Bandar Abbas', NULL, '02', 'bandar-abbas', 'iran-hormozgan-bandar-abbas', 'بندرعباس', NULL, 7081.00, 680000, 'شهرستان بندرعباس مرکز استان هرمزگان و یکی از مهمترین بنادر تجاری ایران است.', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(3, 22, 'بندرلنگه', 'Bandar Lengeh', NULL, '03', 'bandar-lengeh', 'iran-hormozgan-bandar-lengeh', 'بندرلنگه', NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:20', '2025-04-25 08:31:20', NULL),
(4, 22, 'قشم', 'Qeshm', NULL, '04', 'qeshm', 'iran-hormozgan-qeshm', 'قشم', NULL, 1491.00, 150000, 'شهرستان قشم بزرگترین جزیره ایران در خلیج فارس است و دارای جاذبه‌های طبیعی و گردشگری زیادی می‌باشد.', 1, '2025-04-24 16:16:02', '2025-04-24 16:16:02', NULL),
(5, 22, 'میناب', 'Minab', NULL, '05', 'minab', NULL, 'میناب', NULL, NULL, NULL, NULL, 1, '2025-04-25 17:53:57', '2025-04-25 17:53:57', NULL),
(6, 22, 'جاسک', 'Jask', NULL, '06', 'jask', 'iran-hormozgan-jask', 'بندر جاسک', NULL, NULL, NULL, NULL, 1, '2025-04-25 09:19:41', '2025-04-25 09:19:41', NULL),
(8, 22, 'حاجی آباد', 'Hajjiabad', NULL, '08', 'hajjiabad', 'iran-hormozgan-hajjiabad', 'حاجی آباد', NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(9, 22, 'بستک', 'Bastak', NULL, '09', 'bastak', 'iran-hormozgan-bastak', 'بستک', NULL, NULL, NULL, 'شهرستان بستک در غرب استان هرمزگان قرار دارد.', 1, '2025-04-24 21:31:33', '2025-04-24 21:31:33', NULL),
(10, 22, 'خمیر', 'Khamir', NULL, '10', 'khamir', 'iran-hormozgan-khamir', 'خمیر', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:13:17', '2025-04-24 23:13:17', NULL),
(11, 22, 'پارسیان', 'Parsian', NULL, '11', 'parsian', 'iran-hormozgan-parsian', 'پارسیان', NULL, NULL, NULL, NULL, 1, '2025-04-24 22:47:22', '2025-04-24 22:47:22', NULL),
(12, 22, 'سیریك', 'Sirik', NULL, '12', 'sirik', 'iran-hormozgan-sirik', 'سیریك', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:07:33', '2025-04-24 23:07:33', NULL),
(13, 22, 'بشاگرد', 'Bashagard', NULL, '13', 'bashagard', 'iran-hormozgan-bashagard', 'سردشت', NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:28', '2025-04-25 10:10:28', NULL),
(81, 22, 'رودان', 'Rudan', NULL, '07', 'rudan', 'iran-hormozgan-rudan', 'دهبارز', NULL, NULL, NULL, NULL, 1, '2025-04-25 15:32:05', '2025-04-25 15:32:05', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `state4_districts`
--

CREATE TABLE `state4_districts` (
  `id` int(11) NOT NULL COMMENT 'شناسه بخش',
  `county_id` int(11) NOT NULL COMMENT 'شناسه شهرستان',
  `name` varchar(100) NOT NULL COMMENT 'نام بخش',
  `name_en` varchar(100) DEFAULT NULL COMMENT 'نام انگلیسی',
  `name_ar` varchar(100) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL COMMENT 'کد استاندارد',
  `slug` varchar(100) NOT NULL COMMENT 'نامک',
  `global_slug` varchar(255) DEFAULT NULL COMMENT 'نامک سراسری',
  `center_city_name` varchar(100) DEFAULT NULL COMMENT 'مرکز بخش',
  `boundaries` geometry DEFAULT NULL COMMENT 'مرزها (GeoJSON)',
  `area` decimal(10,2) DEFAULT NULL COMMENT 'مساحت (کیلومتر مربع)',
  `population` bigint(20) DEFAULT NULL COMMENT 'جمعیت',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول بخش‌های ایران';

--
-- Dumping data for table `state4_districts`
--

INSERT INTO `state4_districts` (`id`, `county_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `center_city_name`, `boundaries`, `area`, `population`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 4, 'شهاب', 'Shahab', NULL, '01', 'shahab', 'iran-hormozgan-qeshm-shahab', 'سوزا', NULL, NULL, NULL, 'بخش شهاب در غرب جزیره قشم قرار دارد.', 1, '2025-04-24 16:18:36', '2025-04-24 16:18:36', NULL),
(2, 4, 'مركزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-qeshm-markazi', 'قشم', NULL, NULL, NULL, 'بخش مرکزی شهرستان قشم', 1, '2025-04-24 16:18:36', '2025-04-24 16:18:36', NULL),
(3, 4, 'حرا', 'Hara', NULL, '04', 'hara', 'iran-hormozgan-qeshm-hara', 'دولاب', NULL, NULL, NULL, 'بخش حرا در شرق جزیره قشم قرار دارد و نام آن از جنگل‌های حرا گرفته شده است.', 1, '2025-04-24 16:18:36', '2025-04-24 16:18:36', NULL),
(4, 1, 'تنب', 'Tanb', NULL, '01', 'tanb-abu-musa', 'iran-hormozgan-abu-musa-tanb', 'تنب', NULL, NULL, NULL, 'بخش تنب شامل جزایر تنب بزرگ و کوچک می‌باشد.', 1, '2025-04-24 17:23:49', '2025-04-24 17:23:49', NULL),
(5, 1, 'مركزی', 'Markazi', NULL, '02', 'markazi-abu-musa', 'iran-hormozgan-abu-musa-markazi', 'ابوموسی', NULL, NULL, NULL, 'بخش مرکزی شهرستان ابوموسی', 1, '2025-04-24 17:23:49', '2025-04-24 17:23:49', NULL),
(6, 2, 'فین', 'Fin', NULL, '03', 'fin', 'iran-hormozgan-bandar-abbas-fin', 'فین', NULL, NULL, NULL, 'بخش فین در شمال غربی بندرعباس قرار دارد.', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(7, 2, 'مركزی', 'Markazi', NULL, '04', 'markazi-bandar-abbas', 'iran-hormozgan-bandar-abbas-markazi', 'بندرعباس', NULL, NULL, NULL, 'بخش مرکزی شهرستان بندرعباس', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(8, 2, 'تخت', 'Takht', NULL, '05', 'takht', 'iran-hormozgan-bandar-abbas-takht', 'تخت', NULL, NULL, NULL, 'بخش تخت در شمال شرقی بندرعباس قرار دارد.', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(9, 2, 'قلعه قاضی', 'Qaleh Qazi', NULL, '06', 'qaleh-qazi', 'iran-hormozgan-bandar-abbas-qaleh-qazi', 'قلعه قاضی', NULL, NULL, NULL, 'بخش قلعه قاضی در شرق بندرعباس قرار دارد.', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(10, 2, 'هرمز', 'Hormuz', NULL, '07', 'hormuz', 'iran-hormozgan-bandar-abbas-hormuz', 'هرمز', NULL, NULL, NULL, 'بخش هرمز شامل جزیره هرمز می‌باشد.', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(11, 2, 'شمیل', 'Shamil', NULL, '08', 'shamil', 'iran-hormozgan-bandar-abbas-shamil', 'شمیل', NULL, NULL, NULL, 'بخش شمیل در شمال بندرعباس قرار دارد.', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(12, 9, 'جناح', 'Jenah', NULL, '01', 'jenah', 'iran-hormozgan-bastak-jenah', 'جناح', NULL, NULL, NULL, 'بخش جناح در شهرستان بستک', 1, '2025-04-24 21:32:06', '2025-04-24 21:32:06', NULL),
(13, 9, 'مركزی', 'Markazi', NULL, '02', 'markazi-bastak', 'iran-hormozgan-bastak-markazi', 'بستک', NULL, NULL, NULL, 'بخش مرکزی شهرستان بستک', 1, '2025-04-24 21:32:06', '2025-04-24 21:32:06', NULL),
(14, 9, 'کوخرد هرنگ', 'Kookherd-Harang', NULL, '03', 'kookherd-harang', 'iran-hormozgan-bastak-kookherd-harang', 'کوخرد', NULL, NULL, NULL, 'بخش کوخرد هرنگ در شهرستان بستک', 1, '2025-04-24 21:32:06', '2025-04-24 21:32:06', NULL),
(15, 11, 'مركزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-parsian-markazi', 'پارسیان', NULL, NULL, NULL, NULL, 1, '2025-04-24 22:50:19', '2025-04-24 22:50:19', NULL),
(16, 11, 'كوشكنار', 'Kushkunar', NULL, '01', 'kushkunar', 'iran-hormozgan-parsian-kushkunar', 'كوشكنار', NULL, NULL, NULL, NULL, 1, '2025-04-24 22:50:19', '2025-04-24 22:50:19', NULL),
(17, 12, 'بمانی', 'Bamani', NULL, '01', 'bamani', 'iran-hormozgan-sirik-bamani', 'بمانی', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:07:49', '2025-04-24 23:07:49', NULL),
(18, 12, 'مركزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-sirik-markazi', 'سیریك', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:07:49', '2025-04-24 23:07:49', NULL),
(19, 10, 'رویدر', 'Ruyder', NULL, '01', 'ruyder', 'iran-hormozgan-khamir-ruyder', 'رویدر', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:13:34', '2025-04-24 23:13:34', NULL),
(20, 10, 'مركزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-khamir-markazi', 'خمیر', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:13:34', '2025-04-24 23:13:34', NULL),
(21, 10, 'کهورستان', 'Kahoorstan', NULL, '03', 'kahoorstan', 'iran-hormozgan-khamir-kahoorstan', 'کهورستان', NULL, NULL, NULL, NULL, 1, '2025-04-24 23:13:34', '2025-04-24 23:13:34', NULL),
(22, 3, 'شیبكوه', 'Shibkuh', NULL, '02', 'shibkuh', 'iran-hormozgan-bandar-lengeh-shibkuh', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:36', '2025-04-25 08:31:36', NULL),
(23, 3, 'كیش', 'Kish', NULL, '03', 'kish', 'iran-hormozgan-bandar-lengeh-kish', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:36', '2025-04-25 08:31:36', NULL),
(24, 3, 'مركزی', 'Markazi', NULL, '05', 'markazi', 'iran-hormozgan-bandar-lengeh-markazi', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:36', '2025-04-25 08:31:36', NULL),
(25, 3, 'مهران', 'Mehran', NULL, '06', 'mehran', 'iran-hormozgan-bandar-lengeh-mehran', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:36', '2025-04-25 08:31:36', NULL),
(26, 6, 'مرکزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-jask-markazi', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:19:58', '2025-04-25 09:19:58', NULL),
(27, 6, 'لیردف', 'Lirdaf', NULL, '03', 'lirdaf', 'iran-hormozgan-jask-lirdaf', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:19:58', '2025-04-25 09:19:58', NULL),
(28, 13, 'مركزی', 'Markazi', NULL, '01', 'markazi', 'iran-hormozgan-bashagard-markazi', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:39', '2025-04-25 10:10:39', NULL),
(29, 13, 'گوهران', 'Gowharan', NULL, '02', 'gowharan', 'iran-hormozgan-bashagard-gowharan', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:39', '2025-04-25 10:10:39', NULL),
(30, 13, 'گافروپارمون', 'Gafr and Parmon', NULL, '03', 'gafr-parmon', 'iran-hormozgan-bashagard-gafr-parmon', NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:39', '2025-04-25 10:10:39', NULL),
(31, 8, 'فارغان', 'Faraghan', NULL, '01', 'faraghan', 'iran-hormozgan-hajjiabad-faraghan', 'فارغان', NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(32, 8, 'مرکزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-hajjiabad-markazi', 'حاجی آباد', NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(33, 8, 'احمدی', 'Ahmadi', NULL, '03', 'ahmadi', 'iran-hormozgan-hajjiabad-ahmadi', 'احمدی', NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(34, 81, 'رودخانه', 'Rudkhaneh', NULL, '01', 'rudkhaneh', 'iran-hormozgan-rudan-rudkhaneh', 'رودخانه', NULL, NULL, NULL, NULL, 1, '2025-04-25 15:32:25', '2025-04-25 15:32:25', NULL),
(35, 81, 'مركزی', 'Markazi', NULL, '02', 'markazi', 'iran-hormozgan-rudan-markazi', 'دهبارز', NULL, NULL, NULL, NULL, 1, '2025-04-25 15:32:25', '2025-04-25 15:32:25', NULL),
(36, 81, 'جغین', 'Jagin', NULL, '03', 'jagin', 'iran-hormozgan-rudan-jagin', 'بالا شهر', NULL, NULL, NULL, NULL, 1, '2025-04-25 15:32:25', '2025-04-25 15:32:25', NULL),
(37, 81, 'بیكاه', 'Bikah', NULL, '04', 'bikah', 'iran-hormozgan-rudan-bikah', 'بیکاء', NULL, NULL, NULL, NULL, 1, '2025-04-25 15:32:25', '2025-04-25 15:32:25', NULL),
(38, 5, 'سندرك', NULL, NULL, '02', 'sendarak', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:15', '2025-04-25 17:54:15', NULL),
(39, 5, 'مركزی', NULL, NULL, '03', 'markazi-minab', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:15', '2025-04-25 17:54:15', NULL),
(40, 5, 'توكهور', NULL, NULL, '04', 'tukuhur', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:15', '2025-04-25 17:54:15', NULL),
(41, 5, 'بند زرک', NULL, NULL, '05', 'band-zarak', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:15', '2025-04-25 17:54:15', NULL),
(42, 5, 'تیاب', NULL, NULL, '06', 'tiab', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:15', '2025-04-25 17:54:15', NULL),
(43, 5, 'کریان', NULL, NULL, '07', 'karyan', NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:15', '2025-04-25 17:54:15', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `state5_cities`
--

CREATE TABLE `state5_cities` (
  `id` int(11) NOT NULL COMMENT 'شناسه شهر',
  `district_id` int(11) DEFAULT NULL COMMENT 'شناسه بخش',
  `county_id` int(11) NOT NULL COMMENT 'شناسه شهرستان',
  `name` varchar(100) NOT NULL COMMENT 'نام شهر',
  `name_en` varchar(100) DEFAULT NULL COMMENT 'نام انگلیسی',
  `name_ar` varchar(100) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL COMMENT 'کد استاندارد',
  `slug` varchar(100) NOT NULL COMMENT 'نامک',
  `global_slug` varchar(255) DEFAULT NULL COMMENT 'نامک سراسری',
  `is_capital` tinyint(1) DEFAULT 0 COMMENT 'مرکز شهرستان/بخش',
  `boundaries` geometry DEFAULT NULL COMMENT 'مرزها (GeoJSON)',
  `area` decimal(10,2) DEFAULT NULL COMMENT 'مساحت (کیلومتر مربع)',
  `population` bigint(20) DEFAULT NULL COMMENT 'جمعیت',
  `elevation` int(11) DEFAULT NULL COMMENT 'ارتفاع از سطح دریا (متر)',
  `postal_code` varchar(10) DEFAULT NULL COMMENT 'کد پستی',
  `phone_code` varchar(5) DEFAULT NULL COMMENT 'پیش‌شماره تلفن',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول شهرهای ایران';

--
-- Dumping data for table `state5_cities`
--

INSERT INTO `state5_cities` (`id`, `district_id`, `county_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `is_capital`, `boundaries`, `area`, `population`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 1, 4, 'سوزا', 'Suza', NULL, '2487', 'suza', 'iran-hormozgan-qeshm-suza', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر سوزا در بخش شهاب قرار دارد.', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(2, 1, 4, 'هنگام', 'Hengam', NULL, '0004', 'hengam', 'iran-hormozgan-qeshm-hengam', 0, NULL, NULL, NULL, NULL, NULL, '076', 'جزیره هنگام در جنوب غربی قشم قرار دارد.', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(3, 2, 4, 'قشم', 'Qeshm', NULL, '1573', 'qeshm-city', 'iran-hormozgan-qeshm-city', 1, NULL, NULL, 40000, NULL, NULL, '076', 'مرکز شهرستان قشم', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(4, 2, 4, 'رمكان', 'Ramkan', NULL, '1033', 'ramkan', 'iran-hormozgan-qeshm-ramkan', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر رمکان در بخش مرکزی قشم', 1, '2025-04-24 16:19:08', '2025-05-17 03:21:22', NULL),
(5, 2, 4, 'لافت', 'Laft', NULL, '1034', 'laft', 'iran-hormozgan-qeshm-laft', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر لافت با بادگیرهای معروفش شناخته می‌شود.', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(6, 2, 4, 'درگهان', 'Dargahan', NULL, '2627', 'dargahan', 'iran-hormozgan-qeshm-dargahan', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر درگهان در بخش مرکزی قشم', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(7, 3, 4, 'طبل', 'Tabl', NULL, '2940', 'tabl', 'iran-hormozgan-qeshm-tabl', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر طبل در بخش حرا', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(8, 2, 4, 'لارک', 'Larak', NULL, '0003', 'larak', 'iran-hormozgan-qeshm-larak', 0, NULL, NULL, NULL, NULL, NULL, '076', 'جزیره لارک در شمال قشم', 1, '2025-04-24 16:19:08', '2025-04-24 16:19:08', NULL),
(9, 5, 1, 'ابوموسی', 'Abu Musa', NULL, '1563', 'abu-musa-city', 'iran-hormozgan-abu-musa-city', 1, NULL, NULL, 2000, NULL, NULL, '076', 'مرکز شهرستان ابوموسی', 1, '2025-04-24 17:23:49', '2025-04-24 17:23:49', NULL),
(10, 4, 1, 'تنب', 'Tanb', NULL, '0001', 'tanb-city', 'iran-hormozgan-abu-musa-tanb-city', 0, NULL, NULL, NULL, NULL, NULL, '076', 'جزیره تنب در بخش تنب', 1, '2025-04-24 17:23:49', '2025-04-24 17:23:49', NULL),
(11, 5, 1, 'سیری', 'Siri', NULL, '0003', 'siri-abu-musa', 'iran-hormozgan-abu-musa-siri', 0, NULL, NULL, NULL, NULL, NULL, '076', 'جزیره سیری در بخش مرکزی', 1, '2025-04-24 17:23:49', '2025-04-24 17:23:49', NULL),
(12, 7, 2, 'بندرعباس', 'Bandar Abbas', NULL, '1567', 'bandar-abbas-city', 'iran-hormozgan-bandar-abbas-city', 1, NULL, NULL, 526648, 9, NULL, '076', 'مرکز شهرستان و استان هرمزگان', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(13, 7, 2, 'بندرعباس 1', 'Bandar Abbas 1', NULL, '1697', 'bandar-abbas-1', 'iran-hormozgan-bandar-abbas-1', 0, NULL, NULL, NULL, NULL, NULL, '076', 'منطقه 1 بندرعباس', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(14, 7, 2, 'بندرعباس 2', 'Bandar Abbas 2', NULL, '1698', 'bandar-abbas-2', 'iran-hormozgan-bandar-abbas-2', 0, NULL, NULL, NULL, NULL, NULL, '076', 'منطقه 2 بندرعباس', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(15, 7, 2, 'بندرعباس 3', 'Bandar Abbas 3', NULL, '2091', 'bandar-abbas-3', 'iran-hormozgan-bandar-abbas-3', 0, NULL, NULL, NULL, NULL, NULL, '076', 'منطقه 3 بندرعباس', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(16, 6, 2, 'فین', 'Fin', NULL, '2307', 'fin-city', 'iran-hormozgan-bandar-abbas-fin-city', 0, NULL, NULL, NULL, NULL, '6244', '076', 'شهر فین در بخش فین', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(17, 7, 2, 'تازیان پایین', 'Tazian Payin', NULL, '2812', 'tazian-payin', 'iran-hormozgan-bandar-abbas-tazian-payin', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر تازیان پایین در بخش مرکزی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(18, 8, 2, 'تخت', 'Takht', NULL, '2088', 'takht-city', 'iran-hormozgan-bandar-abbas-takht-city', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر تخت در بخش تخت', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(19, 9, 2, 'قلعه قاضی', 'Qaleh Qazi', NULL, '2063', 'qaleh-qazi-city', 'iran-hormozgan-bandar-abbas-qaleh-qazi-city', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر قلعه قاضی در بخش قلعه قاضی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(20, 10, 2, 'هرمز', 'Hormuz', NULL, '1572', 'hormuz-city', 'iran-hormozgan-bandar-abbas-hormuz-city', 0, NULL, NULL, NULL, NULL, NULL, '076', 'جزیره هرمز در بخش هرمز', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(21, 6, 2, 'گهره', 'Gohreh', NULL, '0003', 'gohreh', 'iran-hormozgan-bandar-abbas-gohreh', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر گهره در بخش فین', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(22, 7, 2, 'ایسین', 'Isin', NULL, '0001', 'isin', 'iran-hormozgan-bandar-abbas-isin', 0, NULL, NULL, NULL, NULL, '6245', '076', 'شهر ایسین در بخش مرکزی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(23, 7, 2, 'تازیان', 'Tazian', NULL, '0002', 'tazian', 'iran-hormozgan-bandar-abbas-tazian', 0, NULL, NULL, NULL, NULL, '6634', '076', 'شهر تازیان در بخش مرکزی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(24, 7, 2, 'گچین', 'Gachin', NULL, '0005', 'gachin', 'iran-hormozgan-bandar-abbas-gachin', 0, NULL, NULL, NULL, NULL, '6240', '076', 'شهر گچین در بخش مرکزی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(25, 7, 2, 'سیاهو', 'Siahu', NULL, '0007', 'siahu', 'iran-hormozgan-bandar-abbas-siahu', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر سیاهو در بخش مرکزی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(26, 7, 2, 'سرخون', 'Sarkhun', NULL, '0008', 'sarkhun', 'iran-hormozgan-bandar-abbas-sarkhun', 0, NULL, NULL, NULL, NULL, '6248', '076', 'شهر سرخون در بخش مرکزی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(27, 8, 2, 'جلابی', 'Jalabi', NULL, '0003', 'jalabi', 'iran-hormozgan-bandar-abbas-jalabi', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر جلابی در بخش تخت', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(28, 9, 2, 'دهنو', 'Dehno', NULL, '0003', 'dehno', 'iran-hormozgan-bandar-abbas-dehno', 0, NULL, NULL, NULL, NULL, '6614', '076', 'شهر دهنو در بخش قلعه قاضی', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(29, 11, 2, 'حسن لنگی', 'Hasan Langi', NULL, '0001', 'hasan-langi', 'iran-hormozgan-bandar-abbas-hasan-langi', 0, NULL, NULL, NULL, NULL, '6613', '076', 'شهر حسن لنگی در بخش شمیل', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(30, 11, 2, 'شمیل', 'Shamil', NULL, '0002', 'shamil-city', 'iran-hormozgan-bandar-abbas-shamil-city', 0, NULL, NULL, NULL, NULL, '7262', '076', 'شهر شمیل در بخش شمیل', 1, '2025-04-24 17:31:22', '2025-04-24 17:31:22', NULL),
(31, 12, 9, 'جناح', 'Jenah', NULL, '2625', 'jenah-city', 'iran-hormozgan-bastak-jenah-city', 1, NULL, NULL, NULL, NULL, NULL, '076', 'شهر جناح مرکز بخش جناح', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(32, 12, 9, 'هنگوییه', 'Henguieh', NULL, '2959', 'henguieh', 'iran-hormozgan-bastak-henguieh', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر هنگوییه در بخش جناح', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(33, 13, 9, 'بستک', 'Bastak', NULL, '1568', 'bastak-city', 'iran-hormozgan-bastak-city', 1, NULL, NULL, NULL, NULL, NULL, '076', 'شهر بستک مرکز شهرستان و بخش مرکزی', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(34, 13, 9, 'کوهیچ', 'Kuhej', NULL, '2960', 'kuhej', 'iran-hormozgan-bastak-kuhej', 0, NULL, NULL, NULL, NULL, NULL, '076', 'شهر کوهیچ در بخش مرکزی', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(35, 14, 9, 'کوخرد', 'Kookherd', NULL, '6254', 'kookherd', 'iran-hormozgan-bastak-kookherd', 0, NULL, NULL, NULL, NULL, NULL, '076', 'دهستان کوخرد در بخش کوخرد هرنگ', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(36, 14, 9, 'هرنگ', 'Harang', NULL, '6256', 'harang', 'iran-hormozgan-bastak-harang', 0, NULL, NULL, NULL, NULL, NULL, '076', 'دهستان هرنگ در بخش کوخرد هرنگ', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(37, 13, 9, 'فتویه', 'Fatuyeh', NULL, '6261', 'fatuyeh', 'iran-hormozgan-bastak-fatuyeh', 0, NULL, NULL, NULL, NULL, NULL, '076', 'دهستان فتویه در بخش مرکزی', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(38, 12, 9, 'فرامرزان', 'Faramarzan', NULL, NULL, 'faramarzan', 'iran-hormozgan-bastak-faramarzan', 0, NULL, NULL, NULL, NULL, NULL, '076', 'دهستان فرامرزان در بخش جناح', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(39, 13, 9, 'ده تل', 'Deh-e-Tal', NULL, NULL, 'deh-e-tal', 'iran-hormozgan-bastak-deh-e-tal', 0, NULL, NULL, NULL, NULL, NULL, '076', 'دهستان ده تل در بخش مرکزی', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(40, 13, 9, 'گوده', 'Godeh', NULL, NULL, 'godeh', 'iran-hormozgan-bastak-godeh', 0, NULL, NULL, NULL, NULL, NULL, '076', 'دهستان گوده در بخش مرکزی', 1, '2025-04-24 21:32:33', '2025-04-24 21:32:33', NULL),
(41, 15, 11, 'پارسیان', 'Parsian', NULL, '1569', 'parsian', 'iran-hormozgan-parsian-parsian', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:55:05', '2025-04-24 22:55:05', NULL),
(42, 16, 11, 'كوشكنار', 'Kushkunar', NULL, '2004', 'kushkunar', 'iran-hormozgan-parsian-kushkunar', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:55:05', '2025-04-24 22:55:05', NULL),
(43, 15, 11, 'دشتی', 'Dashti', NULL, '2751', 'dashti', 'iran-hormozgan-parsian-dashti', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:55:05', '2025-04-24 22:55:05', NULL),
(44, 15, 11, 'بوچیر', 'Buchir', NULL, '6263', 'buchir', 'iran-hormozgan-parsian-buchir', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:55:05', '2025-04-24 22:55:05', NULL),
(45, 15, 11, 'بهده', 'Behdeh', NULL, '6637', 'behdeh', 'iran-hormozgan-parsian-behdeh', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:55:05', '2025-04-24 22:55:05', NULL),
(46, 18, 12, 'سیریك', 'Sirik', NULL, '2267', 'sirik', 'iran-hormozgan-sirik-sirik', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:03', '2025-04-24 23:08:03', NULL),
(47, 17, 12, 'کوهستک', 'Kuhistak', NULL, '2815', 'kuhistak', 'iran-hormozgan-sirik-kuhistak', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:03', '2025-04-24 23:08:03', NULL),
(48, 18, 12, 'گروک', 'Goruk', NULL, '2724', 'goruk', 'iran-hormozgan-sirik-goruk', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:03', '2025-04-24 23:08:03', NULL),
(49, 20, 10, 'خمیر', 'Khamir', NULL, '1564', 'khamir', 'iran-hormozgan-khamir-khamir', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(50, 19, 10, 'رویدر', 'Ruyder', NULL, '2005', 'ruyder', 'iran-hormozgan-khamir-ruyder', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(51, 20, 10, 'پل', 'Pol', NULL, '2939', 'pol', 'iran-hormozgan-khamir-pol', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(52, 20, 10, 'کشار بالا', 'Kashar Bala', NULL, '6238', 'kashar-bala', 'iran-hormozgan-khamir-kashar-bala', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(53, 21, 10, 'کهورستان', 'Kahoorstan', NULL, '6239', 'kahoorstan', 'iran-hormozgan-khamir-kahoorstan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(54, 19, 10, 'کروییه', 'Karviyeh', NULL, '6616', 'karviyeh', 'iran-hormozgan-khamir-karviyeh', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(55, 21, 10, 'نیمه کار', 'Nimeh Kar', NULL, '6615', 'nimeh-kar', 'iran-hormozgan-khamir-nimeh-kar', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:14:15', '2025-04-24 23:14:15', NULL),
(56, NULL, 3, 'بندرلنگه', 'Bandar Lengeh', NULL, NULL, 'bandar-lengeh', 'iran-hormozgan-bandar-lengeh', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(57, 22, 3, 'بندر چارك', 'Bandar Charak', NULL, '2266', 'bandar-charak', 'iran-hormozgan-bandar-lengeh-bandar-charak', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(58, 22, 3, 'مقام', 'Mogham', NULL, NULL, 'mogham', 'iran-hormozgan-bandar-lengeh-mogham', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(59, 23, 3, 'كیش', 'Kish', NULL, '2193', 'kish', 'iran-hormozgan-bandar-lengeh-kish', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(60, 23, 3, 'لاوان', 'Lavan', NULL, NULL, 'lavan', 'iran-hormozgan-bandar-lengeh-lavan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(61, 24, 3, 'كنگ', 'Kang', NULL, '1570', 'kang', 'iran-hormozgan-bandar-lengeh-kang', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(62, 24, 3, 'بندرلنگه', 'Bandar Lengeh', NULL, '1571', 'bandar-lengeh', 'iran-hormozgan-bandar-lengeh', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(63, 25, 3, 'لمزان', 'Lamzan', NULL, '2813', 'lamzan', 'iran-hormozgan-bandar-lengeh-lamzan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:31:48', '2025-04-25 08:31:48', NULL),
(64, NULL, 6, 'جاسک', 'Jask', NULL, NULL, 'jask', 'iran-hormozgan-jask', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(65, 26, 6, 'بندر جاسک', 'Bandar Jask', NULL, '1565', 'bandar-jask', 'iran-hormozgan-jask-bandar-jask', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(66, 26, 6, 'کنگان', 'Kangan', NULL, NULL, 'kangan', 'iran-hormozgan-jask-kangan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(67, 26, 6, 'گابریک', 'Gabrik', NULL, NULL, 'gabrik', 'iran-hormozgan-jask-gabrik', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(68, 27, 6, 'لیردف', 'Lirdaf', NULL, '2872', 'lirdaf', 'iran-hormozgan-jask-lirdaf', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(69, 27, 6, 'پی وشک', 'Piveshk', NULL, NULL, 'piveshk', 'iran-hormozgan-jask-piveshk', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(70, 27, 6, 'سورک', 'Surak', NULL, NULL, 'surak', 'iran-hormozgan-jask-surak', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:20:15', '2025-04-25 09:20:15', NULL),
(71, NULL, 13, 'بشاگرد', 'Bashagard', NULL, NULL, 'bashagard', 'iran-hormozgan-bashagard', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(72, 28, 13, 'سردشت', 'Sardasht', NULL, '2061', 'sardasht', 'iran-hormozgan-bashagard-sardasht', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(73, 28, 13, 'جكدان', 'Jakdan', NULL, NULL, 'jakdan', 'iran-hormozgan-bashagard-jakdan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(74, 29, 13, 'گوهران', 'Gowharan', NULL, '2062', 'gowharan', 'iran-hormozgan-bashagard-gowharan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(75, 29, 13, 'درآبسر', 'Darabsar', NULL, NULL, 'darabsar', 'iran-hormozgan-bashagard-darabsar', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(76, 30, 13, 'گافر', 'Gafr', NULL, NULL, 'gafr', 'iran-hormozgan-bashagard-gafr', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(77, 30, 13, 'پارمون', 'Parmon', NULL, NULL, 'parmon', 'iran-hormozgan-bashagard-parmon', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:10:53', '2025-04-25 10:10:53', NULL),
(78, 32, 8, 'حاجی آباد', 'Hajjiabad', NULL, '1566', 'hajjiabad', 'iran-hormozgan-hajjiabad-hajjiabad', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(79, 31, 8, 'فارغان', 'Faraghan', NULL, '2626', 'faraghan', 'iran-hormozgan-hajjiabad-faraghan', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(80, 33, 8, 'سرگز', 'Sargez', NULL, '2092', 'sargez', 'iran-hormozgan-hajjiabad-sargez', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-04-25 12:14:04', NULL),
(81, 34, 81, 'رودخانه', 'Rudkhaneh', NULL, '0001', 'rudkhaneh', 'iran-hormozgan-rudan-rudkhaneh-rudkhaneh', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(82, 34, 81, 'مسافرآباد', 'Mosafarabd', NULL, '0002', 'mosafarabd', 'iran-hormozgan-rudan-rudkhaneh-mosafarabd', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(83, 34, 81, 'رودخانه بر', 'Rudkhaneh Bar', NULL, '0003', 'rudkhaneh-bar', 'iran-hormozgan-rudan-rudkhaneh-rudkhaneh-bar', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(84, 35, 81, 'آب نما', 'Abnama', NULL, '0001', 'abnama', 'iran-hormozgan-rudan-markazi-abnama', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(85, 35, 81, 'فاریاب', 'Fariab', NULL, '0003', 'fariab', 'iran-hormozgan-rudan-markazi-fariab', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(86, 35, 81, 'راهدار', 'Rahdar', NULL, '0006', 'rahdar', 'iran-hormozgan-rudan-markazi-rahdar', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(87, 35, 81, 'برنطین', 'Berentin', NULL, '0007', 'berentin', 'iran-hormozgan-rudan-markazi-berentin', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(88, 36, 81, 'جغین شمالی', 'Jagin Shomali', NULL, '0001', 'jagin-shomali', 'iran-hormozgan-rudan-jagin-jagin-shomali', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(89, 36, 81, 'جغین جنوبی', 'Jagin Jonubi', NULL, '0002', 'jagin-jonubi', 'iran-hormozgan-rudan-jagin-jagin-jonubi', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(90, 37, 81, 'بیكاه', 'Bikah', NULL, '0001', 'bikah', 'iran-hormozgan-rudan-bikah-bikah', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(91, 37, 81, 'اسلام آباد', 'Islamabad', NULL, '0003', 'islamabad', 'iran-hormozgan-rudan-bikah-islamabad', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(92, NULL, 81, 'زیارتعلی', 'Ziarat Ali', NULL, '2663', 'ziarat-ali', 'iran-hormozgan-rudan-ziarat-ali', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(93, NULL, 81, 'دهبارز', 'Dehbarez', NULL, '1574', 'dehbarez', 'iran-hormozgan-rudan-dehbarez', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(94, NULL, 81, 'بالا شهر', 'Bala Shahr', NULL, '2911', 'bala-shahr', 'iran-hormozgan-rudan-bala-shahr', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(95, NULL, 81, 'بیکاء', 'Bikaa', NULL, '2006', 'bikaa', 'iran-hormozgan-rudan-bikaa', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 15:33:12', '2025-04-25 15:33:12', NULL),
(96, 38, 5, 'سندرك', NULL, NULL, '2064', 'sendarak', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(97, 39, 5, 'میناب', NULL, NULL, '1575', 'minab', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(98, 39, 5, 'تیرور', NULL, NULL, '2814', 'tirur', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(99, 40, 5, 'هشتبندی', NULL, NULL, '2003', 'hashtbandi', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(100, 41, 5, 'زهوكی', NULL, NULL, '1035', 'zuhaki', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(101, 41, 5, 'كرگان', NULL, NULL, '1036', 'kargan', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(102, 41, 5, 'بند زرک', NULL, NULL, '2910', 'band-zarak', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(103, 42, 5, 'تیاب', NULL, NULL, NULL, 'tiab', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL),
(104, 43, 5, 'کریان', NULL, NULL, NULL, 'karyan', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 17:54:34', '2025-04-25 17:54:34', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `state6_village`
--

CREATE TABLE `state6_village` (
  `id` int(11) NOT NULL COMMENT 'شناسه روستا',
  `district_id` int(11) DEFAULT NULL COMMENT 'شناسه بخش',
  `county_id` int(11) NOT NULL COMMENT 'شناسه شهرستان',
  `city_id` int(11) DEFAULT NULL COMMENT 'شناسه شهر نزدیک',
  `name` varchar(100) NOT NULL COMMENT 'نام روستا',
  `name_en` varchar(100) DEFAULT NULL COMMENT 'نام انگلیسی',
  `name_ar` varchar(100) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL COMMENT 'کد استاندارد',
  `slug` varchar(100) NOT NULL COMMENT 'نامک',
  `global_slug` varchar(255) DEFAULT NULL COMMENT 'نامک سراسری',
  `boundaries` geometry DEFAULT NULL COMMENT 'مرزها (GeoJSON)',
  `area` decimal(10,2) DEFAULT NULL COMMENT 'مساحت (کیلومتر مربع)',
  `population` bigint(20) DEFAULT NULL COMMENT 'جمعیت',
  `households` int(11) DEFAULT NULL COMMENT 'تعداد خانوار',
  `elevation` int(11) DEFAULT NULL COMMENT 'ارتفاع از سطح دریا (متر)',
  `postal_code` varchar(10) DEFAULT NULL COMMENT 'کد پستی',
  `phone_code` varchar(5) DEFAULT NULL COMMENT 'پیش‌شماره تلفن',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `is_active` tinyint(1) DEFAULT 1 COMMENT 'وضعیت فعال',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='جدول روستاهای ایران';

--
-- Dumping data for table `state6_village`
--

INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 1, 4, 1, 'بند چاپی', NULL, NULL, NULL, 'band-chapi', 'iran-hormozgan-qeshm-band-chapi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(2, 1, 4, 1, 'دیرستان', NULL, NULL, NULL, 'dirstan', 'iran-hormozgan-qeshm-dirstan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(3, 1, 4, 1, 'شیب دراز', NULL, NULL, NULL, 'shib-deraz', 'iran-hormozgan-qeshm-shib-deraz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(4, 1, 4, 1, 'بركه خلف', NULL, NULL, NULL, 'berke-khalf', 'iran-hormozgan-qeshm-berke-khalf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(5, 1, 4, 1, 'ریگو', NULL, NULL, NULL, 'rigu', 'iran-hormozgan-qeshm-rigu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(6, 1, 4, 1, 'زیرانگ', NULL, NULL, NULL, 'zirang', 'iran-hormozgan-qeshm-zirang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(7, 1, 4, 1, 'نخل گل', NULL, NULL, NULL, 'nakhl-gol', 'iran-hormozgan-qeshm-nakhl-gol', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(8, 1, 4, 1, 'نخلستانهای سوزا', NULL, NULL, NULL, 'nakhlestanhay-e-suza', 'iran-hormozgan-qeshm-nakhlestanhay-e-suza', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(9, 1, 4, 1, 'کمال آباد', NULL, NULL, NULL, 'kamal-abad', 'iran-hormozgan-qeshm-kamal-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(10, 1, 4, 1, 'مسن', NULL, NULL, NULL, 'masn', 'iran-hormozgan-qeshm-masn', NULL, NULL, NULL, NULL, NULL, '6621', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(11, 1, 4, 2, 'قیل', NULL, NULL, NULL, 'ghil', 'iran-hormozgan-qeshm-ghil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(12, 1, 4, 2, 'هنگام جدید', NULL, NULL, NULL, 'hengam-jadid', 'iran-hormozgan-qeshm-hengam-jadid', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(13, 1, 4, 2, 'هنگام قدیم', NULL, NULL, NULL, 'hengam-ghadim', 'iran-hormozgan-qeshm-hengam-ghadim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(14, 2, 4, 3, 'تمبان', NULL, NULL, NULL, 'temban', 'iran-hormozgan-qeshm-temban', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(15, 2, 4, 3, 'تلمبو', NULL, NULL, NULL, 'tlembo', 'iran-hormozgan-qeshm-tlembo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(16, 2, 4, 3, 'حمیری', NULL, NULL, NULL, 'hamiri', 'iran-hormozgan-qeshm-hamiri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(17, 2, 4, 3, 'دفاری', NULL, NULL, NULL, 'defari', 'iran-hormozgan-qeshm-defari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(18, 2, 4, 3, 'كابلی', NULL, NULL, NULL, 'kaboli', 'iran-hormozgan-qeshm-kaboli', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(19, 2, 4, 3, 'لافت كهنه', NULL, NULL, NULL, 'laft-kohne', 'iran-hormozgan-qeshm-laft-kohne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(20, 2, 4, 3, 'جمال آباد', NULL, NULL, NULL, 'jamal-abad', 'iran-hormozgan-qeshm-jamal-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(21, 2, 4, 3, 'گورزین', NULL, NULL, NULL, 'gorzin', 'iran-hormozgan-qeshm-gorzin', NULL, NULL, NULL, NULL, NULL, '6624', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(22, 2, 4, 3, 'رمچاه', NULL, NULL, NULL, 'ramcha', 'iran-hormozgan-qeshm-ramcha', NULL, NULL, NULL, NULL, NULL, '6273', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(23, 2, 4, 3, 'طولا', NULL, NULL, NULL, 'tula', 'iran-hormozgan-qeshm-tula', NULL, NULL, NULL, NULL, NULL, '3842', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(24, 2, 4, 3, 'كووه ای', NULL, NULL, NULL, 'kuveh-i', 'iran-hormozgan-qeshm-kuveh-i', NULL, NULL, NULL, NULL, NULL, '6274', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(25, 2, 4, 3, 'گیاهدان', NULL, NULL, NULL, 'giahdan', 'iran-hormozgan-qeshm-giahdan', NULL, NULL, NULL, NULL, NULL, '6275', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:17:58', NULL),
(26, 2, 4, 3, 'هلر', NULL, NULL, NULL, 'haler', 'iran-hormozgan-qeshm-haler', NULL, NULL, NULL, NULL, NULL, '3749', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(27, 2, 4, 4, 'باغ بالا', NULL, NULL, NULL, 'bagh-bala', 'iran-hormozgan-qeshm-bagh-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(28, 2, 4, 4, 'بند جهود', NULL, NULL, NULL, 'band-jahood', 'iran-hormozgan-qeshm-band-jahood', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(29, 2, 4, 4, 'بنگالی', NULL, NULL, NULL, 'bangali', 'iran-hormozgan-qeshm-bangali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(30, 2, 4, 4, 'تم سنتی', NULL, NULL, NULL, 'tem-sonati', 'iran-hormozgan-qeshm-tem-sonati', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(31, 2, 4, 4, 'جی جیان', NULL, NULL, NULL, 'ji-jian', 'iran-hormozgan-qeshm-ji-jian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(32, 2, 4, 4, 'خالدین', NULL, NULL, NULL, 'khaldin', 'iran-hormozgan-qeshm-khaldin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(33, 2, 4, 4, 'زینبی', NULL, NULL, NULL, 'zeynabi', 'iran-hormozgan-qeshm-zeynabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(34, 2, 4, 4, 'صیدم', NULL, NULL, NULL, 'seydam', 'iran-hormozgan-qeshm-seydam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(35, 2, 4, 4, 'كاروان', NULL, NULL, NULL, 'karvan', 'iran-hormozgan-qeshm-karvan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(36, 2, 4, 4, 'كوشه', NULL, NULL, NULL, 'kousheh', 'iran-hormozgan-qeshm-kousheh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(37, 2, 4, 4, 'گربه دان', NULL, NULL, NULL, 'gorbe-dan', 'iran-hormozgan-qeshm-gorbe-dan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(38, 2, 4, 4, 'گردوا', NULL, NULL, NULL, 'gerdova', 'iran-hormozgan-qeshm-gerdova', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(39, 2, 4, 4, 'منصورآباد', NULL, NULL, NULL, 'mansoor-abad', 'iran-hormozgan-qeshm-mansoor-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(40, 2, 4, 4, 'پی پشت', NULL, NULL, NULL, 'pi-pusht', 'iran-hormozgan-qeshm-pi-pusht', NULL, NULL, NULL, NULL, NULL, '6625', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(41, 2, 4, 4, 'توریان', NULL, NULL, NULL, 'tourian', 'iran-hormozgan-qeshm-tourian', NULL, NULL, NULL, NULL, NULL, '6271', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(42, 2, 4, 8, 'لارک شهری', NULL, NULL, NULL, 'larak-shahri', 'iran-hormozgan-qeshm-larak-shahri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(43, 2, 4, 8, 'لارک کوهی', NULL, NULL, NULL, 'larak-koohi', 'iran-hormozgan-qeshm-larak-koohi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(44, 2, 4, 8, 'لارک مرونه', NULL, NULL, NULL, 'larak-maroneh', 'iran-hormozgan-qeshm-larak-maroneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(45, 3, 4, NULL, 'تم گس', NULL, NULL, NULL, 'tem-gas', 'iran-hormozgan-qeshm-tem-gas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(46, 3, 4, NULL, 'چاهو غربی', NULL, NULL, NULL, 'chahoo-gharbi', 'iran-hormozgan-qeshm-chahoo-gharbi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(47, 3, 4, NULL, 'چاهو شرقی', NULL, NULL, NULL, 'chahoo-sharqi', 'iran-hormozgan-qeshm-chahoo-sharqi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(48, 3, 4, NULL, 'درکوه', NULL, NULL, NULL, 'dar-kooh', 'iran-hormozgan-qeshm-dar-kooh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(49, 3, 4, NULL, 'دوستکو', NULL, NULL, NULL, 'doostko', 'iran-hormozgan-qeshm-doostko', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(50, 3, 4, NULL, 'دولاب', NULL, NULL, NULL, 'doolab', 'iran-hormozgan-qeshm-doolab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(51, 3, 4, NULL, 'عایشه آباد', NULL, NULL, NULL, 'ayesheh-abad', 'iran-hormozgan-qeshm-ayesheh-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(52, 3, 4, NULL, 'کانی', NULL, NULL, NULL, 'kani', 'iran-hormozgan-qeshm-kani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(53, 3, 4, NULL, 'کنار سیاه', NULL, NULL, NULL, 'kenar-siah', 'iran-hormozgan-qeshm-kenar-siah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(54, 3, 4, NULL, 'گوری', NULL, NULL, NULL, 'gouri', 'iran-hormozgan-qeshm-gouri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(55, 3, 4, NULL, 'مرادی', NULL, NULL, NULL, 'moradi', 'iran-hormozgan-qeshm-moradi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(56, 3, 4, NULL, 'باسعیدو', NULL, NULL, NULL, 'basaeedo', 'iran-hormozgan-qeshm-basaeedo', NULL, NULL, NULL, NULL, NULL, '6623', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(57, 3, 4, NULL, 'سرریگ', NULL, NULL, NULL, 'sar-rig', 'iran-hormozgan-qeshm-sar-rig', NULL, NULL, NULL, NULL, NULL, '6622', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(58, 3, 4, NULL, 'دهخدا', NULL, NULL, NULL, 'dehkhoda', 'iran-hormozgan-qeshm-dehkhoda', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(59, 3, 4, NULL, 'خوزایی', NULL, NULL, NULL, 'khozai', 'iran-hormozgan-qeshm-khozai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(60, 3, 4, NULL, 'دوربنی', NULL, NULL, NULL, 'dorbani', 'iran-hormozgan-qeshm-dorbani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(61, 3, 4, NULL, 'گاچو', NULL, NULL, NULL, 'gacho', 'iran-hormozgan-qeshm-gacho', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(62, 3, 4, NULL, 'گمبران', NULL, NULL, NULL, 'gambran', 'iran-hormozgan-qeshm-gambran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(63, 3, 4, NULL, 'گوران', NULL, NULL, NULL, 'goran', 'iran-hormozgan-qeshm-goran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(64, 3, 4, NULL, 'ملکی', NULL, NULL, NULL, 'maleki', 'iran-hormozgan-qeshm-maleki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(65, 3, 4, NULL, 'نقاشه', NULL, NULL, NULL, 'naghasheh', 'iran-hormozgan-qeshm-naghasheh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(66, 3, 4, NULL, 'هفترنگو', NULL, NULL, NULL, 'haft-rangoo', 'iran-hormozgan-qeshm-haft-rangoo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(67, 3, 4, NULL, 'صلخ', NULL, NULL, NULL, 'salakh', 'iran-hormozgan-qeshm-salakh', NULL, NULL, NULL, NULL, NULL, '6268', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(68, 3, 4, NULL, 'سهیلی', NULL, NULL, NULL, 'soheyli', 'iran-hormozgan-qeshm-soheyli', NULL, NULL, NULL, NULL, NULL, '6620', NULL, NULL, 1, '2025-04-24 16:24:53', '2025-05-17 03:20:33', NULL),
(69, 4, 1, 10, 'تنب بزرگ', NULL, NULL, NULL, 'tanb-bozorg-abu-musa', 'iran-hormozgan-abu-musa-tanb-bozorg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 17:23:49', '2025-05-17 03:20:33', NULL),
(70, 4, 1, 10, 'تنب كوچك', NULL, NULL, NULL, 'tanb-koochak-abu-musa', 'iran-hormozgan-abu-musa-tanb-koochak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 17:23:49', '2025-05-17 03:20:33', NULL),
(71, 4, 1, 10, 'فارور بزرگ', NULL, NULL, NULL, 'farvar-bozorg-abu-musa', 'iran-hormozgan-abu-musa-farvar-bozorg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 17:23:49', '2025-05-17 03:20:33', NULL),
(72, 4, 1, 10, 'فارور كوچك', NULL, NULL, NULL, 'farvar-koochak-abu-musa', 'iran-hormozgan-abu-musa-farvar-koochak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 17:23:49', '2025-05-17 03:20:33', NULL),
(73, 5, 1, 11, 'سیری', NULL, NULL, NULL, 'siri-village-abu-musa', 'iran-hormozgan-abu-musa-siri-village', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 17:23:49', '2025-05-17 03:20:33', NULL),
(74, 6, 2, 16, 'اردان', NULL, NULL, NULL, 'ardan-fin', 'iran-hormozgan-bandar-abbas-ardan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(75, 6, 2, 16, 'باغستان', NULL, NULL, NULL, 'baghestan-fin', 'iran-hormozgan-bandar-abbas-baghestan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(76, 6, 2, 16, 'بركه شیخ', NULL, NULL, NULL, 'berke-sheikh-fin', 'iran-hormozgan-bandar-abbas-berke-sheikh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(77, 6, 2, 16, 'بگود', NULL, NULL, NULL, 'boghod-fin', 'iran-hormozgan-bandar-abbas-boghod-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(78, 6, 2, 16, 'پرزین', NULL, NULL, NULL, 'parzin-fin', 'iran-hormozgan-bandar-abbas-parzin-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(79, 6, 2, 16, 'تربكستان', NULL, NULL, NULL, 'torbakestan-fin', 'iran-hormozgan-bandar-abbas-torbakestan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(80, 6, 2, 16, 'تربوییه', NULL, NULL, NULL, 'torbuyeh-fin', 'iran-hormozgan-bandar-abbas-torbuyeh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(81, 6, 2, 16, 'تنغت', NULL, NULL, NULL, 'tanghat-fin', 'iran-hormozgan-bandar-abbas-tanghat-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(82, 6, 2, 16, 'تیزج', NULL, NULL, NULL, 'tizj-fin', 'iran-hormozgan-bandar-abbas-tizj-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(83, 6, 2, 16, 'تیكو', NULL, NULL, NULL, 'tiko-fin', 'iran-hormozgan-bandar-abbas-tiko-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(84, 6, 2, 16, 'غایب', NULL, NULL, NULL, 'ghayeb-fin', 'iran-hormozgan-bandar-abbas-ghayeb-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(85, 6, 2, 16, 'جونگان', NULL, NULL, NULL, 'jungan-fin', 'iran-hormozgan-bandar-abbas-jungan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(86, 6, 2, 16, 'چاكرتو', NULL, NULL, NULL, 'chakertu-fin', 'iran-hormozgan-bandar-abbas-chakertu-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(87, 6, 2, 16, 'چاهو', NULL, NULL, NULL, 'chahoo-fin', 'iran-hormozgan-bandar-abbas-chahoo-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(88, 6, 2, 16, 'چهل سواران', NULL, NULL, NULL, 'chehel-savaran-fin', 'iran-hormozgan-bandar-abbas-chehel-savaran-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(89, 6, 2, 16, 'خایین', NULL, NULL, NULL, 'khayin-fin', 'iran-hormozgan-bandar-abbas-khayin-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(90, 6, 2, 16, 'خورخورست', NULL, NULL, NULL, 'khorkhorst-fin', 'iran-hormozgan-bandar-abbas-khorkhorst-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(91, 6, 2, 16, 'دازان', NULL, NULL, NULL, 'dazan-fin', 'iran-hormozgan-bandar-abbas-dazan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(92, 6, 2, 16, 'درمغ', NULL, NULL, NULL, 'darmagh-fin', 'iran-hormozgan-bandar-abbas-darmagh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(93, 6, 2, 16, 'دشت مارم', NULL, NULL, NULL, 'dasht-marm-fin', 'iran-hormozgan-bandar-abbas-dasht-marm-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(94, 6, 2, 16, 'دم تنگ مصری', NULL, NULL, NULL, 'dam-tang-masri-fin', 'iran-hormozgan-bandar-abbas-dam-tang-masri-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(95, 6, 2, 16, 'دمیلو', NULL, NULL, NULL, 'damilu-fin', 'iran-hormozgan-bandar-abbas-damilu-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(96, 6, 2, 16, 'دوستانق', NULL, NULL, NULL, 'dostanagh-fin', 'iran-hormozgan-bandar-abbas-dostanagh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(97, 6, 2, 16, 'سرزه', NULL, NULL, NULL, 'sarzeh-fin', 'iran-hormozgan-bandar-abbas-sarzeh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(98, 6, 2, 16, 'سله كو', NULL, NULL, NULL, 'soleh-ko-fin', 'iran-hormozgan-bandar-abbas-soleh-ko-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(99, 6, 2, 16, 'سوتغان', NULL, NULL, NULL, 'sotaghan-fin', 'iran-hormozgan-bandar-abbas-sotaghan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(100, 6, 2, 16, 'شغو', NULL, NULL, NULL, 'shogho-fin', 'iran-hormozgan-bandar-abbas-shogho-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(101, 6, 2, 16, 'شیخ عالی', NULL, NULL, NULL, 'sheikh-ali-fin', 'iran-hormozgan-bandar-abbas-sheikh-ali-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(102, 6, 2, 16, 'علی آباد', NULL, NULL, NULL, 'ali-abad-fin', 'iran-hormozgan-bandar-abbas-ali-abad-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(103, 6, 2, 16, 'كوران', NULL, NULL, NULL, 'kuran-fin', 'iran-hormozgan-bandar-abbas-kuran-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(104, 6, 2, 16, 'كهتك', NULL, NULL, NULL, 'kohtak-fin', 'iran-hormozgan-bandar-abbas-kohtak-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(105, 6, 2, 16, 'كهن بالا', NULL, NULL, NULL, 'kohan-bala-fin', 'iran-hormozgan-bandar-abbas-kohan-bala-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(106, 6, 2, 16, 'گاونیز', NULL, NULL, NULL, 'gavaniz-fin', 'iran-hormozgan-bandar-abbas-gavaniz-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(107, 6, 2, 16, 'گرو سیاه', NULL, NULL, NULL, 'geroo-siah-fin', 'iran-hormozgan-bandar-abbas-geroo-siah-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(108, 6, 2, 16, 'گلدنو', NULL, NULL, NULL, 'goldeno-fin', 'iran-hormozgan-bandar-abbas-goldeno-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(109, 6, 2, 16, 'سربند', NULL, NULL, NULL, 'sarband-fin', 'iran-hormozgan-bandar-abbas-sarband-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(110, 6, 2, 16, 'لومائی', NULL, NULL, NULL, 'lomai-fin', 'iran-hormozgan-bandar-abbas-lomai-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(111, 6, 2, 16, 'لاور', NULL, NULL, NULL, 'lavar-fin', 'iran-hormozgan-bandar-abbas-lavar-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(112, 6, 2, 16, 'مزرا', NULL, NULL, NULL, 'mazra-fin', 'iran-hormozgan-bandar-abbas-mazra-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(113, 6, 2, 16, 'مزراء پائین', NULL, NULL, NULL, 'mazra-payin-fin', 'iran-hormozgan-bandar-abbas-mazra-payin-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(114, 6, 2, 16, 'منگو', NULL, NULL, NULL, 'mango-fin', 'iran-hormozgan-bandar-abbas-mango-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(115, 6, 2, 16, 'هورمودر بالا', NULL, NULL, NULL, 'hormodar-bala-fin', 'iran-hormozgan-bandar-abbas-hormodar-bala-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(116, 6, 2, 16, 'هورمودر پائین', NULL, NULL, NULL, 'hormodar-payin-fin', 'iran-hormozgan-bandar-abbas-hormodar-payin-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(117, 6, 2, 16, 'تنگ بازگران', NULL, NULL, NULL, 'tang-bazgaran-fin', 'iran-hormozgan-bandar-abbas-tang-bazgaran-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(118, 6, 2, 16, 'اوین سفلی', NULL, NULL, NULL, 'avin-sofla-fin', 'iran-hormozgan-bandar-abbas-avin-sofla-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(119, 6, 2, 16, 'اوین علیا', NULL, NULL, NULL, 'avin-olia-fin', 'iran-hormozgan-bandar-abbas-avin-olia-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(120, 6, 2, 16, 'پروزك', NULL, NULL, NULL, 'porozak-fin', 'iran-hormozgan-bandar-abbas-porozak-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(121, 6, 2, 16, 'گرد سیاه', NULL, NULL, NULL, 'gerd-siah-fin', 'iran-hormozgan-bandar-abbas-gerd-siah-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(122, 6, 2, 16, 'بست بیخ', NULL, NULL, NULL, 'bast-bikh-fin', 'iran-hormozgan-bandar-abbas-bast-bikh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(123, 6, 2, 16, 'كم گرمه', NULL, NULL, NULL, 'kam-garme-fin', 'iran-hormozgan-bandar-abbas-kam-garme-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(124, 6, 2, 16, 'مهدی آباد (ختنه سوری)', NULL, NULL, NULL, 'mahdi-abad-fin', 'iran-hormozgan-bandar-abbas-mahdi-abad-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(125, 6, 2, 16, 'پابند', NULL, NULL, NULL, 'paband-fin', 'iran-hormozgan-bandar-abbas-paband-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(126, 6, 2, 16, 'آبكهور', NULL, NULL, NULL, 'abkohor-fin', 'iran-hormozgan-bandar-abbas-abkohor-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(127, 6, 2, 16, 'گل اندام', NULL, NULL, NULL, 'gol-andam-fin', 'iran-hormozgan-bandar-abbas-gol-andam-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(128, 6, 2, 16, 'قلمان', NULL, NULL, NULL, 'ghalaman-fin', 'iran-hormozgan-bandar-abbas-ghalaman-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(129, 6, 2, 16, 'تشكن', NULL, NULL, NULL, 'tashkan-fin', 'iran-hormozgan-bandar-abbas-tashkan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(130, 6, 2, 16, 'بنگرسو', NULL, NULL, NULL, 'banger-so-fin', 'iran-hormozgan-bandar-abbas-banger-so-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(131, 6, 2, 16, 'شیاری', NULL, NULL, NULL, 'shiari-fin', 'iran-hormozgan-bandar-abbas-shiari-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(132, 6, 2, 16, 'سودرو', NULL, NULL, NULL, 'sodro-fin', 'iran-hormozgan-bandar-abbas-sodro-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(133, 6, 2, 16, 'كم رودان', NULL, NULL, NULL, 'kam-rudan-fin', 'iran-hormozgan-bandar-abbas-kam-rudan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(134, 6, 2, 16, 'خورجل بالا', NULL, NULL, NULL, 'khoorjal-bala-fin', 'iran-hormozgan-bandar-abbas-khoorjal-bala-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(135, 6, 2, 16, 'درمیشان', NULL, NULL, NULL, 'darmishan-fin', 'iran-hormozgan-bandar-abbas-darmishan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(136, 6, 2, 16, 'خورجل زیر', NULL, NULL, NULL, 'khoorjal-zir-fin', 'iran-hormozgan-bandar-abbas-khoorjal-zir-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(137, 6, 2, 16, 'بندر', NULL, NULL, NULL, 'bandar-fin', 'iran-hormozgan-bandar-abbas-bandar-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(138, 6, 2, 16, 'مازغ كوارو', NULL, NULL, NULL, 'mazagh-kavaro-fin', 'iran-hormozgan-bandar-abbas-mazagh-kavaro-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(139, 6, 2, 16, 'تنگ تربوئیه', NULL, NULL, NULL, 'tang-torbuyeh-fin', 'iran-hormozgan-bandar-abbas-tang-torbuyeh-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(140, 6, 2, 16, 'رضوان', NULL, NULL, NULL, 'rezvan-fin', 'iran-hormozgan-bandar-abbas-rezvan-fin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(141, 6, 2, 21, 'آب شیرین', NULL, NULL, NULL, 'ab-shirin-gohreh', 'iran-hormozgan-bandar-abbas-ab-shirin-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(142, 6, 2, 21, 'آبماه', NULL, NULL, NULL, 'abmah-gohreh', 'iran-hormozgan-bandar-abbas-abmah-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(143, 6, 2, 21, 'ارنگان', NULL, NULL, NULL, 'arangan-gohreh', 'iran-hormozgan-bandar-abbas-arangan-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(144, 6, 2, 21, 'بنو', NULL, NULL, NULL, 'bonu-gohreh', 'iran-hormozgan-bandar-abbas-bonu-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(145, 6, 2, 21, 'پشته برنگ', NULL, NULL, NULL, 'poshte-barang-gohreh', 'iran-hormozgan-bandar-abbas-poshte-barang-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(146, 6, 2, 21, 'چاه کل', NULL, NULL, NULL, 'chah-kol-gohreh', 'iran-hormozgan-bandar-abbas-chah-kol-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(147, 6, 2, 21, 'چلو گهره', NULL, NULL, NULL, 'cholo-gohreh', 'iran-hormozgan-bandar-abbas-cholo-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(148, 6, 2, 21, 'خوش هنگام', NULL, NULL, NULL, 'khosh-hangam-gohreh', 'iran-hormozgan-bandar-abbas-khosh-hangam-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(149, 6, 2, 21, 'درانار', NULL, NULL, NULL, 'daranar-gohreh', 'iran-hormozgan-bandar-abbas-daranar-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(150, 6, 2, 21, 'دوین', NULL, NULL, NULL, 'dovin-gohreh', 'iran-hormozgan-bandar-abbas-dovin-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(151, 6, 2, 21, 'زرتو بالا', NULL, NULL, NULL, 'zartu-bala-gohreh', 'iran-hormozgan-bandar-abbas-zartu-bala-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(152, 6, 2, 21, 'زیارت', NULL, NULL, NULL, 'ziarat-gohreh', 'iran-hormozgan-bandar-abbas-ziarat-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(153, 6, 2, 21, 'قطب آباد گهره', NULL, NULL, NULL, 'ghotb-abad-gohreh', 'iran-hormozgan-bandar-abbas-ghotb-abad-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(154, 6, 2, 21, 'گوچین', NULL, NULL, NULL, 'gochin-gohreh', 'iran-hormozgan-bandar-abbas-gochin-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(155, 6, 2, 21, 'گهره', NULL, NULL, NULL, 'gohreh-village', 'iran-hormozgan-bandar-abbas-gohreh-village', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(156, 6, 2, 21, 'گیشان غربی', NULL, NULL, NULL, 'gishan-gharbi-gohreh', 'iran-hormozgan-bandar-abbas-gishan-gharbi-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(157, 6, 2, 21, 'ناتردان', NULL, NULL, NULL, 'natardan-gohreh', 'iran-hormozgan-bandar-abbas-natardan-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(158, 6, 2, 21, 'نارنگان', NULL, NULL, NULL, 'narangan-gohreh', 'iran-hormozgan-bandar-abbas-narangan-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(159, 6, 2, 21, 'باغون', NULL, NULL, NULL, 'baghun-gohreh', 'iran-hormozgan-bandar-abbas-baghun-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(160, 6, 2, 21, 'پشت تنگ', NULL, NULL, NULL, 'posht-tang-gohreh', 'iran-hormozgan-bandar-abbas-posht-tang-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(161, 6, 2, 21, 'پیشدان', NULL, NULL, NULL, 'pishdan-gohreh', 'iran-hormozgan-bandar-abbas-pishdan-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(162, 6, 2, 21, 'تتكوه', NULL, NULL, NULL, 'tatkoh-gohreh', 'iran-hormozgan-bandar-abbas-tatkoh-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(163, 6, 2, 21, 'چاه مهكو', NULL, NULL, NULL, 'chah-mehko-gohreh', 'iran-hormozgan-bandar-abbas-chah-mehko-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(164, 6, 2, 21, 'كملشت', NULL, NULL, NULL, 'kamlasht-gohreh', 'iran-hormozgan-bandar-abbas-kamlasht-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(165, 6, 2, 21, 'گرو', NULL, NULL, NULL, 'geroo-gohreh', 'iran-hormozgan-bandar-abbas-geroo-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(166, 6, 2, 21, 'گنگیگان', NULL, NULL, NULL, 'gangigan-gohreh', 'iran-hormozgan-bandar-abbas-gangigan-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(167, 6, 2, 21, 'مورك', NULL, NULL, NULL, 'mork-gohreh', 'iran-hormozgan-bandar-abbas-mork-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(168, 6, 2, 21, 'گرگ', NULL, NULL, NULL, 'gorg-gohreh', 'iran-hormozgan-bandar-abbas-gorg-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(169, 6, 2, 21, 'زرتو پائین', NULL, NULL, NULL, 'zartu-payin-gohreh', 'iran-hormozgan-bandar-abbas-zartu-payin-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(170, 6, 2, 21, 'چاله', NULL, NULL, NULL, 'chaleh-gohreh', 'iran-hormozgan-bandar-abbas-chaleh-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(171, 6, 2, 21, 'بیخو', NULL, NULL, NULL, 'bikho-gohreh', 'iran-hormozgan-bandar-abbas-bikho-gohreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(172, 7, 2, 22, 'شهرك درجتان ابراهیمی', NULL, NULL, NULL, 'shahrak-darjatan-ebrahimi-isin', 'iran-hormozgan-bandar-abbas-darjatan-ebrahimi-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(173, 7, 2, 22, 'آب زمینو', NULL, NULL, NULL, 'ab-zaminu-isin', 'iran-hormozgan-bandar-abbas-ab-zaminu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(174, 7, 2, 22, 'آب قلمون', NULL, NULL, NULL, 'ab-ghalamun-isin', 'iran-hormozgan-bandar-abbas-ab-ghalamun-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(175, 7, 2, 22, 'بوندر', NULL, NULL, NULL, 'bondar-isin', 'iran-hormozgan-bandar-abbas-bondar-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(176, 7, 2, 22, 'خان مردو', NULL, NULL, NULL, 'khan-mardu-isin', 'iran-hormozgan-bandar-abbas-khan-mardu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(177, 7, 2, 22, 'داوودی', NULL, NULL, NULL, 'davoodi-isin', 'iran-hormozgan-bandar-abbas-davoodi-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(178, 7, 2, 22, 'دیمشهر خورگو', NULL, NULL, NULL, 'dimshahr-khorgu-isin', 'iran-hormozgan-bandar-abbas-dimshahr-khorgu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(179, 7, 2, 22, 'شهرك سرخاء', NULL, NULL, NULL, 'shahrak-sorkha-isin', 'iran-hormozgan-bandar-abbas-shahrak-sorkha-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(180, 7, 2, 22, 'سرگلم', NULL, NULL, NULL, 'sargolam-isin', 'iran-hormozgan-bandar-abbas-sargolam-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(181, 7, 2, 22, 'قلم', NULL, NULL, NULL, 'ghalam-isin', 'iran-hormozgan-bandar-abbas-ghalam-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(182, 7, 2, 22, 'كلوچان', NULL, NULL, NULL, 'koluchan-isin', 'iran-hormozgan-bandar-abbas-koluchan-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(183, 7, 2, 22, 'گاش', NULL, NULL, NULL, 'gash-isin', 'iran-hormozgan-bandar-abbas-gash-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(184, 7, 2, 22, 'گلستان', NULL, NULL, NULL, 'golestan-isin', 'iran-hormozgan-bandar-abbas-golestan-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(185, 7, 2, 22, 'ماشكار', NULL, NULL, NULL, 'mashkar-isin', 'iran-hormozgan-bandar-abbas-mashkar-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(186, 7, 2, 22, 'مزراكو', NULL, NULL, NULL, 'mazrako-isin', 'iran-hormozgan-bandar-abbas-mazrako-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(187, 7, 2, 22, 'پاتل ایسین', NULL, NULL, NULL, 'patel-isin', 'iran-hormozgan-bandar-abbas-patel-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(188, 7, 2, 22, 'تنگ باغ', NULL, NULL, NULL, 'tang-bagh-isin', 'iran-hormozgan-bandar-abbas-tang-bagh-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(189, 7, 2, 22, 'تهلو', NULL, NULL, NULL, 'tahlo-isin', 'iran-hormozgan-bandar-abbas-tahlo-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(190, 7, 2, 22, 'چاهو گنو بالا', NULL, NULL, NULL, 'chahoo-genu-bala-isin', 'iran-hormozgan-bandar-abbas-chahoo-genu-bala-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(191, 7, 2, 22, 'خورلول', NULL, NULL, NULL, 'khorlol-isin', 'iran-hormozgan-bandar-abbas-khorlol-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(192, 7, 2, 22, 'درژگی', NULL, NULL, NULL, 'darzhgi-isin', 'iran-hormozgan-bandar-abbas-darzhgi-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(193, 7, 2, 22, 'دربرهو', NULL, NULL, NULL, 'darbarho-isin', 'iran-hormozgan-bandar-abbas-darbarho-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(194, 7, 2, 22, 'درگیر', NULL, NULL, NULL, 'dargir-isin', 'iran-hormozgan-bandar-abbas-dargir-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(195, 7, 2, 22, 'دزك', NULL, NULL, NULL, 'dezak-isin', 'iran-hormozgan-bandar-abbas-dezak-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(196, 7, 2, 22, 'دشت امام', NULL, NULL, NULL, 'dasht-emam-isin', 'iran-hormozgan-bandar-abbas-dasht-emam-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(197, 7, 2, 22, 'سرریگ اول', NULL, NULL, NULL, 'sar-rig-aval-isin', 'iran-hormozgan-bandar-abbas-sar-rig-aval-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(198, 7, 2, 22, 'سرریگ دوم', NULL, NULL, NULL, 'sar-rig-dovom-isin', 'iran-hormozgan-bandar-abbas-sar-rig-dovom-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(199, 7, 2, 22, 'شركت هامون', NULL, NULL, NULL, 'shirkat-hamun-isin', 'iran-hormozgan-bandar-abbas-shirkat-hamun-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(200, 7, 2, 22, 'شهرو', NULL, NULL, NULL, 'shahro-isin', 'iran-hormozgan-bandar-abbas-shahro-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(201, 7, 2, 22, 'كوه سیاه', NULL, NULL, NULL, 'kuh-siah-isin', 'iran-hormozgan-bandar-abbas-kuh-siah-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(202, 7, 2, 22, 'كهنوج گنو', NULL, NULL, NULL, 'kahnuj-genu-isin', 'iran-hormozgan-bandar-abbas-kahnuj-genu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(203, 7, 2, 22, 'قلعه ایسین', NULL, NULL, NULL, 'ghaleh-isin', 'iran-hormozgan-bandar-abbas-ghaleh-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(204, 7, 2, 22, 'هورمودر', NULL, NULL, NULL, 'hormodar-isin', 'iran-hormozgan-bandar-abbas-hormodar-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(205, 7, 2, 22, 'ایستگاه مخابرات كوه گنو', NULL, NULL, NULL, 'istakhe-mokhaberat-kuh-genu-isin', 'iran-hormozgan-bandar-abbas-istakhe-mokhaberat-kuh-genu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(206, 7, 2, 22, 'پاسگاه نیروی انتظامی كوه گنو', NULL, NULL, NULL, 'pasgah-niru-entezami-kuh-genu-isin', 'iran-hormozgan-bandar-abbas-pasgah-niru-entezami-kuh-genu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(207, 7, 2, 22, 'فاریاب ایسین', NULL, NULL, NULL, 'faryab-isin', 'iran-hormozgan-bandar-abbas-faryab-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(208, 7, 2, 22, 'صنایع بوریا', NULL, NULL, NULL, 'sanaei-buria-isin', 'iran-hormozgan-bandar-abbas-sanaei-buria-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(209, 7, 2, 22, 'فرستنده رادیو و تلویزیون', NULL, NULL, NULL, 'ferestande-radio-tv-isin', 'iran-hormozgan-bandar-abbas-ferestande-radio-tv-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(210, 7, 2, 22, 'تصفیه خانه آب هرمزگان', NULL, NULL, NULL, 'tasfiye-khane-ab-hormozgan-isin', 'iran-hormozgan-bandar-abbas-tasfiye-khane-ab-hormozgan-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(211, 7, 2, 22, 'گورستان بهشت زهرا', NULL, NULL, NULL, 'gorstan-behesht-zahra-isin', 'iran-hormozgan-bandar-abbas-gorstan-behesht-zahra-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(212, 7, 2, 22, 'شهرك صنعتی بندرعباس', NULL, NULL, NULL, 'shahrak-sanaei-bandar-abbas-isin', 'iran-hormozgan-bandar-abbas-shahrak-sanaei-bandar-abbas-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(213, 7, 2, 22, 'كافه دوراهی سرخون', NULL, NULL, NULL, 'cafe-dorahi-sarkhun-isin', 'iran-hormozgan-bandar-abbas-cafe-dorahi-sarkhun-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(214, 7, 2, 22, 'شركت هرمز بتون', NULL, NULL, NULL, 'shirkat-hormoz-beton-isin', 'iran-hormozgan-bandar-abbas-shirkat-hormoz-beton-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(215, 7, 2, 22, 'شركت تولیدی گامرون توربین', NULL, NULL, NULL, 'shirkat-tolidi-gamron-turbin-isin', 'iran-hormozgan-bandar-abbas-shirkat-tolidi-gamron-turbin-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(216, 7, 2, 22, 'شركت كشت و صنعت خانچه', NULL, NULL, NULL, 'shirkat-kesht-sanaat-khancheh-isin', 'iran-hormozgan-bandar-abbas-shirkat-kesht-sanaat-khancheh-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(217, 7, 2, 22, 'گنو', NULL, NULL, NULL, 'genu-isin', 'iran-hormozgan-bandar-abbas-genu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(218, 7, 2, 22, 'قدمگاه درویش سلیمان', NULL, NULL, NULL, 'ghadamgah-darvish-solyman-isin', 'iran-hormozgan-bandar-abbas-ghadamgah-darvish-solyman-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(219, 7, 2, 22, 'آبگرم خورگو', NULL, NULL, NULL, 'abgarm-khorgu-isin', 'iran-hormozgan-bandar-abbas-abgarm-khorgu-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(220, 7, 2, 22, 'گدار گز', NULL, NULL, NULL, 'gadargaz-isin', 'iran-hormozgan-bandar-abbas-gadargaz-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(221, 7, 2, 22, 'ده شیخ/ شیخ آباد', NULL, NULL, NULL, 'deh-sheikh-isin', 'iran-hormozgan-bandar-abbas-deh-sheikh-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(222, 7, 2, 22, 'دم گروبند', NULL, NULL, NULL, 'dam-groband-isin', 'iran-hormozgan-bandar-abbas-dam-groband-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(223, 7, 2, 22, 'گدار نران', NULL, NULL, NULL, 'gadar-naran-isin', 'iran-hormozgan-bandar-abbas-gadar-naran-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(224, 7, 2, 22, 'مازغو', NULL, NULL, NULL, 'mazgho-isin', 'iran-hormozgan-bandar-abbas-mazgho-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(225, 7, 2, 22, 'آبادی', NULL, NULL, NULL, 'abadi-isin', 'iran-hormozgan-bandar-abbas-abadi-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(226, 7, 2, 22, 'پشته مغیری', NULL, NULL, NULL, 'poshte-moghiri-isin', 'iran-hormozgan-bandar-abbas-poshte-moghiri-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(227, 7, 2, 22, 'شوكلات', NULL, NULL, NULL, 'shokolat-isin', 'iran-hormozgan-bandar-abbas-shokolat-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(228, 7, 2, 22, 'دوتمب', NULL, NULL, NULL, 'dotemb-isin', 'iran-hormozgan-bandar-abbas-dotemb-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(229, 7, 2, 22, 'حسین آباد', NULL, NULL, NULL, 'hossein-abad-isin', 'iran-hormozgan-bandar-abbas-hossein-abad-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(230, 7, 2, 22, 'مجتمع مسكونی راه آهن', NULL, NULL, NULL, 'majmoe-maskoni-rah-ahan-isin', 'iran-hormozgan-bandar-abbas-majmoe-maskoni-rah-ahan-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(231, 7, 2, 22, 'اسلام آباد', NULL, NULL, NULL, 'islam-abad-isin', 'iran-hormozgan-bandar-abbas-islam-abad-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(232, 7, 2, 22, 'گورمونو', NULL, NULL, NULL, 'gormono-isin', 'iran-hormozgan-bandar-abbas-gormono-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(233, 7, 2, 22, 'خوابگاه و دانشگاه هرمزگان', NULL, NULL, NULL, 'khabgah-daneshgah-hormozgan-isin', 'iran-hormozgan-bandar-abbas-khabgah-daneshgah-hormozgan-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(234, 7, 2, 22, 'شهرک خلیج فارس', NULL, NULL, NULL, 'shahrak-khalij-fars-isin', 'iran-hormozgan-bandar-abbas-shahrak-khalij-fars-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(235, 7, 2, 22, 'بوندر پایین', NULL, NULL, NULL, 'bondar-payin-isin', 'iran-hormozgan-bandar-abbas-bondar-payin-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(236, 7, 2, 22, 'دریا پیشگان', NULL, NULL, NULL, 'darya-pishgan-isin', 'iran-hormozgan-bandar-abbas-darya-pishgan-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(237, 7, 2, 22, 'آبشورک', NULL, NULL, NULL, 'abshoorak-isin', 'iran-hormozgan-bandar-abbas-abshoorak-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(238, 7, 2, 22, 'پشته ایسین', NULL, NULL, NULL, 'poshte-isin', 'iran-hormozgan-bandar-abbas-poshte-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(239, 7, 2, 22, 'چه چکر', NULL, NULL, NULL, 'che-cheker-isin', 'iran-hormozgan-bandar-abbas-che-cheker-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(240, 7, 2, 22, 'شهرک شهید نامجو', NULL, NULL, NULL, 'shahrak-shahid-nameju-isin', 'iran-hormozgan-bandar-abbas-shahrak-shahid-nameju-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL);
INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(241, 7, 2, 22, 'محله نو', NULL, NULL, NULL, 'mahale-no-isin', 'iran-hormozgan-bandar-abbas-mahale-no-isin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(242, 7, 2, 23, 'بلندو', NULL, NULL, NULL, 'bolando-tazian', 'iran-hormozgan-bandar-abbas-bolando-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(243, 7, 2, 23, 'سودرو', NULL, NULL, NULL, 'sodro-tazian', 'iran-hormozgan-bandar-abbas-sodro-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(244, 7, 2, 23, 'گربند', NULL, NULL, NULL, 'gorband-tazian', 'iran-hormozgan-bandar-abbas-gorband-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(245, 7, 2, 23, 'بنوبند', NULL, NULL, NULL, 'bonuband-tazian', 'iran-hormozgan-bandar-abbas-bonuband-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(246, 7, 2, 23, 'بنوبند پاتل', NULL, NULL, NULL, 'bonuband-patel-tazian', 'iran-hormozgan-bandar-abbas-bonuband-patel-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(247, 7, 2, 23, 'بنوبند پا سنگ', NULL, NULL, NULL, 'bonuband-pa-sang-tazian', 'iran-hormozgan-bandar-abbas-bonuband-pa-sang-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(248, 7, 2, 23, 'پاسگاه جنگلبانی', NULL, NULL, NULL, 'pasgah-jangalbari-tazian', 'iran-hormozgan-bandar-abbas-pasgah-jangalbari-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(249, 7, 2, 23, 'تل سیاه', NULL, NULL, NULL, 'tel-siah-tazian', 'iran-hormozgan-bandar-abbas-tel-siah-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(250, 7, 2, 23, 'جمال احمد', NULL, NULL, NULL, 'jamal-ahmad-tazian', 'iran-hormozgan-bandar-abbas-jamal-ahmad-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(251, 7, 2, 23, 'چاه محمد', NULL, NULL, NULL, 'chah-mohammad-tazian', 'iran-hormozgan-bandar-abbas-chah-mohammad-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(252, 7, 2, 23, 'چاهو گنو پائین', NULL, NULL, NULL, 'chahoo-genu-payin-tazian', 'iran-hormozgan-bandar-abbas-chahoo-genu-payin-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(253, 7, 2, 23, 'چاهو', NULL, NULL, NULL, 'chahoo-tazian', 'iran-hormozgan-bandar-abbas-chahoo-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(254, 7, 2, 23, 'سایت رادار بندرعباس', NULL, NULL, NULL, 'site-radar-bandar-abbas-tazian', 'iran-hormozgan-bandar-abbas-site-radar-bandar-abbas-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(255, 7, 2, 23, 'كلاتو', NULL, NULL, NULL, 'kalato-tazian', 'iran-hormozgan-bandar-abbas-kalato-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(256, 7, 2, 23, 'كنارو', NULL, NULL, NULL, 'kenaro-tazian', 'iran-hormozgan-bandar-abbas-kenaro-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(257, 7, 2, 23, 'پایگاه هوا دریا', NULL, NULL, NULL, 'paygah-hava-darya-tazian', 'iran-hormozgan-bandar-abbas-paygah-hava-darya-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(258, 7, 2, 23, 'پاتل تازیان', NULL, NULL, NULL, 'patel-tazian-tazian', 'iran-hormozgan-bandar-abbas-patel-tazian-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(259, 7, 2, 23, 'زیارت سید سلیمان', NULL, NULL, NULL, 'ziarat-seyed-solyman-tazian', 'iran-hormozgan-bandar-abbas-ziarat-seyed-solyman-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(260, 7, 2, 23, 'قدمگاه امام رضا', NULL, NULL, NULL, 'ghadamgah-emam-reza-tazian', 'iran-hormozgan-bandar-abbas-ghadamgah-emam-reza-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(261, 7, 2, 23, 'قدمگاه حضرت امیر', NULL, NULL, NULL, 'ghadamgah-hazrat-amir-tazian', 'iran-hormozgan-bandar-abbas-ghadamgah-hazrat-amir-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(262, 7, 2, 23, 'پابندگنو', NULL, NULL, NULL, 'paband-genu-tazian', 'iran-hormozgan-bandar-abbas-paband-genu-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(263, 7, 2, 23, 'آقا میرجلیل', NULL, NULL, NULL, 'agha-mirjalil-tazian', 'iran-hormozgan-bandar-abbas-agha-mirjalil-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(264, 7, 2, 23, 'شركت سرمل', NULL, NULL, NULL, 'shirkat-sarmal-tazian', 'iran-hormozgan-bandar-abbas-shirkat-sarmal-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(265, 7, 2, 23, 'ترمینال نظامی بندرعباس', NULL, NULL, NULL, 'terminal-nezami-bandar-abbas-tazian', 'iran-hormozgan-bandar-abbas-terminal-nezami-bandar-abbas-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(266, 7, 2, 23, 'محمد شمسی', NULL, NULL, NULL, 'mohammad-shamsi-tazian', 'iran-hormozgan-bandar-abbas-mohammad-shamsi-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(267, 7, 2, 23, 'شهرو', NULL, NULL, NULL, 'shahro-tazian', 'iran-hormozgan-bandar-abbas-shahro-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(268, 7, 2, 23, 'تازیان بالا', NULL, NULL, NULL, 'tazian-bala-tazian', 'iran-hormozgan-bandar-abbas-tazian-bala-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(269, 7, 2, 23, 'قلات بالا', NULL, NULL, NULL, 'ghalat-bala-tazian', 'iran-hormozgan-bandar-abbas-ghalat-bala-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(270, 7, 2, 23, 'قلات پایین', NULL, NULL, NULL, 'ghalat-payin-tazian', 'iran-hormozgan-bandar-abbas-ghalat-payin-tazian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(271, 7, 2, 24, 'دمیلو', NULL, NULL, NULL, 'damilu-gachin', 'iran-hormozgan-bandar-abbas-damilu-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(272, 7, 2, 24, 'مجتمع كشتی سازی خلیج فارس', NULL, NULL, NULL, 'majmoe-keshti-sazi-khalij-fars-gachin', 'iran-hormozgan-bandar-abbas-majmoe-keshti-sazi-khalij-fars-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(273, 7, 2, 24, 'مغ احمد بالا', NULL, NULL, NULL, 'mog-ahmad-bala-gachin', 'iran-hormozgan-bandar-abbas-mog-ahmad-bala-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(274, 7, 2, 24, 'اسكله شهید رجائی', NULL, NULL, NULL, 'eskele-shahid-rajaei-gachin', 'iran-hormozgan-bandar-abbas-eskele-shahid-rajaei-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(275, 7, 2, 24, 'آمادگاه حضرت ابوالفضل', NULL, NULL, NULL, 'amadegah-hazrat-abolfazl-gachin', 'iran-hormozgan-bandar-abbas-amadegah-hazrat-abolfazl-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(276, 7, 2, 24, 'تیاب خون سرخ', NULL, NULL, NULL, 'tiab-khoon-sorkh-gachin', 'iran-hormozgan-bandar-abbas-tiab-khoon-sorkh-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(277, 7, 2, 24, 'شهرك توانیر', NULL, NULL, NULL, 'shahrak-tavanir-gachin', 'iran-hormozgan-bandar-abbas-shahrak-tavanir-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(278, 7, 2, 24, 'فرودگاه آزمایشی نیروی هوائی', NULL, NULL, NULL, 'forudgah-azmayeshi-niru-havai-gachin', 'iran-hormozgan-bandar-abbas-forudgah-azmayeshi-niru-havai-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(279, 7, 2, 24, 'مغ احمد پائین', NULL, NULL, NULL, 'mog-ahmad-payin-gachin', 'iran-hormozgan-bandar-abbas-mog-ahmad-payin-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(280, 7, 2, 24, 'كمپ مسكونی خلیج فارس', NULL, NULL, NULL, 'camp-maskoni-khalij-fars-gachin', 'iran-hormozgan-bandar-abbas-camp-maskoni-khalij-fars-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(281, 7, 2, 24, 'شركت گران سنگ  مهر', NULL, NULL, NULL, 'shirkat-gran-sang-mehr-gachin', 'iran-hormozgan-bandar-abbas-shirkat-gran-sang-mehr-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(282, 7, 2, 24, 'بارقین خونسرخ', NULL, NULL, NULL, 'barghin-khoon-sorkh-gachin', 'iran-hormozgan-bandar-abbas-barghin-khoon-sorkh-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(283, 7, 2, 24, 'مجتمع انبارهای ایران', NULL, NULL, NULL, 'majmoe-anbarhay-iran-gachin', 'iran-hormozgan-bandar-abbas-majmoe-anbarhay-iran-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(284, 7, 2, 24, 'شركت كشتیرانی ایران بحر', NULL, NULL, NULL, 'shirkat-keshti-rani-iran-bahr-gachin', 'iran-hormozgan-bandar-abbas-shirkat-keshti-rani-iran-bahr-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(285, 7, 2, 24, 'انبار شركت فولاد هرمزگان', NULL, NULL, NULL, 'anbar-shirkat-fulad-hormozgan-gachin', 'iran-hormozgan-bandar-abbas-anbar-shirkat-fulad-hormozgan-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(286, 7, 2, 24, 'مجتمع تولیدی شهید درویشی صنایع دفاع', NULL, NULL, NULL, 'majmoe-tolidi-shahid-darvishi-sanaei-defa-gachin', 'iran-hormozgan-bandar-abbas-majmoe-tolidi-shahid-darvishi-sanaei-defa-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(287, 7, 2, 24, 'مجتمع آلومینیم المهدی', NULL, NULL, NULL, 'majmoe-alominom-almahdi-gachin', 'iran-hormozgan-bandar-abbas-majmoe-alominom-almahdi-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(288, 7, 2, 24, 'سردخانه 20 هزار تنی كوثر', NULL, NULL, NULL, 'sardakhane-20-hezar-toni-kowsar-gachin', 'iran-hormozgan-bandar-abbas-sardakhane-20-hezar-toni-kowsar-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(289, 7, 2, 24, 'كمپ مسكونی شركت نفت بستانو', NULL, NULL, NULL, 'camp-maskoni-shirkat-naft-bostano-gachin', 'iran-hormozgan-bandar-abbas-camp-maskoni-shirkat-naft-bostano-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(290, 7, 2, 24, 'پالایشگاه نفت بندرعباس', NULL, NULL, NULL, 'palayeshgah-naft-bandar-abbas-gachin', 'iran-hormozgan-bandar-abbas-palayeshgah-naft-bandar-abbas-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(291, 7, 2, 24, 'بستانو', NULL, NULL, NULL, 'bostano-gachin', 'iran-hormozgan-bandar-abbas-bostano-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(292, 7, 2, 24, 'لاتیدان', NULL, NULL, NULL, 'latidan-gachin', 'iran-hormozgan-bandar-abbas-latidan-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(293, 7, 2, 24, 'گچین بالا', NULL, NULL, NULL, 'gachin-bala-gachin', 'iran-hormozgan-bandar-abbas-gachin-bala-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(294, 7, 2, 24, 'گچین پایین', NULL, NULL, NULL, 'gachin-payin-gachin', 'iran-hormozgan-bandar-abbas-gachin-payin-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(295, 7, 2, 24, 'دوگردان خونسرخ', NULL, NULL, NULL, 'dogardan-khoon-sorkh-gachin', 'iran-hormozgan-bandar-abbas-dogardan-khoon-sorkh-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(296, 7, 2, 24, 'شهرک شهید رجایی', NULL, NULL, NULL, 'shahrak-shahid-rajaei-gachin', 'iran-hormozgan-bandar-abbas-shahrak-shahid-rajaei-gachin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(297, 7, 2, 25, 'برچهر', NULL, NULL, NULL, 'barchahr-siahu', 'iran-hormozgan-bandar-abbas-barchahr-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(298, 7, 2, 25, 'خرسین', NULL, NULL, NULL, 'kharasin-siahu', 'iran-hormozgan-bandar-abbas-kharasin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(299, 7, 2, 25, 'دق فینو', NULL, NULL, NULL, 'dag-fino-siahu', 'iran-hormozgan-bandar-abbas-dag-fino-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(300, 7, 2, 25, 'هماگ بالا', NULL, NULL, NULL, 'hamag-bala-siahu', 'iran-hormozgan-bandar-abbas-hamag-bala-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(301, 7, 2, 25, 'هماگ پائین', NULL, NULL, NULL, 'hamag-payin-siahu', 'iran-hormozgan-bandar-abbas-hamag-payin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(302, 7, 2, 25, 'آب محمدی', NULL, NULL, NULL, 'ab-mohammadi-siahu', 'iran-hormozgan-bandar-abbas-ab-mohammadi-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(303, 7, 2, 25, 'آغاسین پائین', NULL, NULL, NULL, 'aghasin-payin-siahu', 'iran-hormozgan-bandar-abbas-aghasin-payin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(304, 7, 2, 25, 'آغاسین بالا', NULL, NULL, NULL, 'aghasin-bala-siahu', 'iran-hormozgan-bandar-abbas-aghasin-bala-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(305, 7, 2, 25, 'بیخ', NULL, NULL, NULL, 'bikh-siahu', 'iran-hormozgan-bandar-abbas-bikh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(306, 7, 2, 25, 'پتكنان بالا', NULL, NULL, NULL, 'patkanan-bala-siahu', 'iran-hormozgan-bandar-abbas-patkanan-bala-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(307, 7, 2, 25, 'پاگرد', NULL, NULL, NULL, 'pagard-siahu', 'iran-hormozgan-bandar-abbas-pagard-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(308, 7, 2, 25, 'تل سورو', NULL, NULL, NULL, 'tel-soro-siahu', 'iran-hormozgan-bandar-abbas-tel-soro-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(309, 7, 2, 25, 'تل گردو', NULL, NULL, NULL, 'tel-gerdo-siahu', 'iran-hormozgan-bandar-abbas-tel-gerdo-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(310, 7, 2, 25, 'توتنگ', NULL, NULL, NULL, 'totang-siahu', 'iran-hormozgan-bandar-abbas-totang-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(311, 7, 2, 25, 'جغدر بالا', NULL, NULL, NULL, 'jaghdar-bala-siahu', 'iran-hormozgan-bandar-abbas-jaghdar-bala-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(312, 7, 2, 25, 'درگز', NULL, NULL, NULL, 'dargaz-siahu', 'iran-hormozgan-bandar-abbas-dargaz-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(313, 7, 2, 25, 'دوكوه', NULL, NULL, NULL, 'dokuh-siahu', 'iran-hormozgan-bandar-abbas-dokuh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(314, 7, 2, 25, 'رباط', NULL, NULL, NULL, 'rabat-siahu', 'iran-hormozgan-bandar-abbas-rabat-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(315, 7, 2, 25, 'رود شور', NULL, NULL, NULL, 'rud-shur-siahu', 'iran-hormozgan-bandar-abbas-rud-shur-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(316, 7, 2, 25, 'زاكین', NULL, NULL, NULL, 'zakin-siahu', 'iran-hormozgan-bandar-abbas-zakin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(317, 7, 2, 25, 'زروكان', NULL, NULL, NULL, 'zarvakan-siahu', 'iran-hormozgan-bandar-abbas-zarvakan-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(318, 7, 2, 25, 'زنكوته', NULL, NULL, NULL, 'zenkoteh-siahu', 'iran-hormozgan-bandar-abbas-zenkoteh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(319, 7, 2, 25, 'سغ', NULL, NULL, NULL, 'sagh-siahu', 'iran-hormozgan-bandar-abbas-sagh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(320, 7, 2, 25, 'سلرد', NULL, NULL, NULL, 'selard-siahu', 'iran-hormozgan-bandar-abbas-selard-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(321, 7, 2, 25, 'سیاهو', NULL, NULL, NULL, 'siahu-village', 'iran-hormozgan-bandar-abbas-siahu-village', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(322, 7, 2, 25, 'سیخوران بالا', NULL, NULL, NULL, 'sikhuran-bala-siahu', 'iran-hormozgan-bandar-abbas-sikhuran-bala-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(323, 7, 2, 25, 'طیفكان', NULL, NULL, NULL, 'tifkan-siahu', 'iran-hormozgan-bandar-abbas-tifkan-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(324, 7, 2, 25, 'كروكان', NULL, NULL, NULL, 'karukan-siahu', 'iran-hormozgan-bandar-abbas-karukan-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(325, 7, 2, 25, 'كووه', NULL, NULL, NULL, 'kuveh-siahu', 'iran-hormozgan-bandar-abbas-kuveh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(326, 7, 2, 25, 'ماشاری', NULL, NULL, NULL, 'mashari-siahu', 'iran-hormozgan-bandar-abbas-mashari-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(327, 7, 2, 25, 'نامدر بالا', NULL, NULL, NULL, 'namdar-bala-siahu', 'iran-hormozgan-bandar-abbas-namdar-bala-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(328, 7, 2, 25, 'نرینگان', NULL, NULL, NULL, 'naringan-siahu', 'iran-hormozgan-bandar-abbas-naringan-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(329, 7, 2, 25, 'هزارتا', NULL, NULL, NULL, 'hezar-ta-siahu', 'iran-hormozgan-bandar-abbas-hezar-ta-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(330, 7, 2, 25, 'فورخورج', NULL, NULL, NULL, 'forkhorj-siahu', 'iran-hormozgan-bandar-abbas-forkhorj-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(331, 7, 2, 25, 'چاه شور', NULL, NULL, NULL, 'chah-shur-siahu', 'iran-hormozgan-bandar-abbas-chah-shur-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(332, 7, 2, 25, 'درفراغ', NULL, NULL, NULL, 'darforagh-siahu', 'iran-hormozgan-bandar-abbas-darforagh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(333, 7, 2, 25, 'پاگرو', NULL, NULL, NULL, 'pagro-siahu', 'iran-hormozgan-bandar-abbas-pagro-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(334, 7, 2, 25, 'همت آباد', NULL, NULL, NULL, 'hamat-abad-siahu', 'iran-hormozgan-bandar-abbas-hamat-abad-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(335, 7, 2, 25, 'قدمگاه حضرت علی', NULL, NULL, NULL, 'ghadamgah-hazrat-ali-siahu', 'iran-hormozgan-bandar-abbas-ghadamgah-hazrat-ali-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(336, 7, 2, 25, 'كم اشنو', NULL, NULL, NULL, 'kam-ashno-siahu', 'iran-hormozgan-bandar-abbas-kam-ashno-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(337, 7, 2, 25, 'زیارت پاكوه', NULL, NULL, NULL, 'ziarat-pakuh-siahu', 'iran-hormozgan-bandar-abbas-ziarat-pakuh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(338, 7, 2, 25, 'سركم', NULL, NULL, NULL, 'sarkam-siahu', 'iran-hormozgan-bandar-abbas-sarkam-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(339, 7, 2, 25, 'درگیران', NULL, NULL, NULL, 'dargiran-siahu', 'iran-hormozgan-bandar-abbas-dargiran-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(340, 7, 2, 25, 'گرو سیاهان', NULL, NULL, NULL, 'geroo-siahan-siahu', 'iran-hormozgan-bandar-abbas-geroo-siahan-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(341, 7, 2, 25, 'هواران', NULL, NULL, NULL, 'havaran-siahu', 'iran-hormozgan-bandar-abbas-havaran-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(342, 7, 2, 25, 'جغدر پائین', NULL, NULL, NULL, 'jaghdar-payin-siahu', 'iran-hormozgan-bandar-abbas-jaghdar-payin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(343, 7, 2, 25, 'نامدر پائین', NULL, NULL, NULL, 'namdar-payin-siahu', 'iran-hormozgan-bandar-abbas-namdar-payin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(344, 7, 2, 25, 'آبشور', NULL, NULL, NULL, 'abshur-siahu', 'iran-hormozgan-bandar-abbas-abshur-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(345, 7, 2, 25, 'دنوكی', NULL, NULL, NULL, 'donuki-siahu', 'iran-hormozgan-bandar-abbas-donuki-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(346, 7, 2, 25, 'دتو ناصری', NULL, NULL, NULL, 'dato-naseri-siahu', 'iran-hormozgan-bandar-abbas-dato-naseri-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(347, 7, 2, 25, 'سیخوران پائین', NULL, NULL, NULL, 'sikhuran-payin-siahu', 'iran-hormozgan-bandar-abbas-sikhuran-payin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(348, 7, 2, 25, 'پشت بندسغ', NULL, NULL, NULL, 'poshte-band-sagh-siahu', 'iran-hormozgan-bandar-abbas-poshte-band-sagh-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(349, 7, 2, 25, 'گری گوری', NULL, NULL, NULL, 'gri-gori-siahu', 'iran-hormozgan-bandar-abbas-gri-gori-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(350, 7, 2, 25, 'بنگلایان', NULL, NULL, NULL, 'banglayan-siahu', 'iran-hormozgan-bandar-abbas-banglayan-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(351, 7, 2, 25, 'سردرو', NULL, NULL, NULL, 'sardro-siahu', 'iran-hormozgan-bandar-abbas-sardro-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(352, 7, 2, 25, 'پشته چاهو', NULL, NULL, NULL, 'poshte-chahoo-siahu', 'iran-hormozgan-bandar-abbas-poshte-chahoo-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(353, 7, 2, 25, 'نیومر', NULL, NULL, NULL, 'niumar-siahu', 'iran-hormozgan-bandar-abbas-niumar-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(354, 7, 2, 25, 'گود بونگرد', NULL, NULL, NULL, 'good-bongard-siahu', 'iran-hormozgan-bandar-abbas-good-bongard-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(355, 7, 2, 25, 'جذرآباد', NULL, NULL, NULL, 'jazr-abad-siahu', 'iran-hormozgan-bandar-abbas-jazr-abad-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(356, 7, 2, 25, 'چهل گزی', NULL, NULL, NULL, 'chehel-gazi-siahu', 'iran-hormozgan-bandar-abbas-chehel-gazi-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(357, 7, 2, 25, 'دو کوه پایین', NULL, NULL, NULL, 'do-kuh-payin-siahu', 'iran-hormozgan-bandar-abbas-do-kuh-payin-siahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(358, 7, 2, 26, 'باغو', NULL, NULL, NULL, 'bagho-sarkhun', 'iran-hormozgan-bandar-abbas-bagho-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(359, 7, 2, 26, 'فتح الجلیل', NULL, NULL, NULL, 'fath-al-jalil-sarkhun', 'iran-hormozgan-bandar-abbas-fath-al-jalil-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(360, 7, 2, 26, 'قادهار', NULL, NULL, NULL, 'ghadhar-sarkhun', 'iran-hormozgan-bandar-abbas-ghadhar-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(361, 7, 2, 26, 'ننگ', NULL, NULL, NULL, 'nang-sarkhun', 'iran-hormozgan-bandar-abbas-nang-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(362, 7, 2, 26, 'پلیس راه میناب بندرعباس', NULL, NULL, NULL, 'police-rah-minab-bandar-abbas-sarkhun', 'iran-hormozgan-bandar-abbas-police-rah-minab-bandar-abbas-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(363, 7, 2, 26, 'تاسیسات شركت گاز', NULL, NULL, NULL, 'tasysat-shirkat-gaz-sarkhun', 'iran-hormozgan-bandar-abbas-tasysat-shirkat-gaz-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(364, 7, 2, 26, 'چاه حسن كهوری', NULL, NULL, NULL, 'chah-hasan-kohori-sarkhun', 'iran-hormozgan-bandar-abbas-chah-hasan-kohori-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(365, 7, 2, 26, 'قدمگاه بی بی شهربانو', NULL, NULL, NULL, 'ghadamgah-bi-bi-shahrbanu-sarkhun', 'iran-hormozgan-bandar-abbas-ghadamgah-bi-bi-shahrbanu-sarkhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(366, 7, 2, 26, 'سرخون', NULL, NULL, NULL, 'sarkhun-village', 'iran-hormozgan-bandar-abbas-sarkhun-village', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(367, 8, 2, 18, 'آب پیش', NULL, NULL, NULL, 'ab-pish-takht', 'iran-hormozgan-bandar-abbas-ab-pish-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(368, 8, 2, 18, 'بدك', NULL, NULL, NULL, 'badak-takht', 'iran-hormozgan-bandar-abbas-badak-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(369, 8, 2, 18, 'بهرغ', NULL, NULL, NULL, 'bohrogh-takht', 'iran-hormozgan-bandar-abbas-bohrogh-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(370, 8, 2, 18, 'پشمی', NULL, NULL, NULL, 'pashmi-takht', 'iran-hormozgan-bandar-abbas-pashmi-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(371, 8, 2, 18, 'جغان', NULL, NULL, NULL, 'jaghan-takht', 'iran-hormozgan-bandar-abbas-jaghan-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(372, 8, 2, 18, 'جوت', NULL, NULL, NULL, 'jot-takht', 'iran-hormozgan-bandar-abbas-jot-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(373, 8, 2, 18, 'چاهستان', NULL, NULL, NULL, 'chahstan-takht', 'iran-hormozgan-bandar-abbas-chahstan-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(374, 8, 2, 18, 'زیارت سید سلیمان', NULL, NULL, NULL, 'ziarat-seyed-solyman-takht', 'iran-hormozgan-bandar-abbas-ziarat-seyed-solyman-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(375, 8, 2, 18, 'سردره', NULL, NULL, NULL, 'sardareh-takht', 'iran-hormozgan-bandar-abbas-sardareh-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(376, 8, 2, 18, 'شاه عوضی', NULL, NULL, NULL, 'shah-avazi-takht', 'iran-hormozgan-bandar-abbas-shah-avazi-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(377, 8, 2, 18, 'گیشان', NULL, NULL, NULL, 'gishan-takht', 'iran-hormozgan-bandar-abbas-gishan-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(378, 8, 2, 18, 'مقسم', NULL, NULL, NULL, 'moghsam-takht', 'iran-hormozgan-bandar-abbas-moghsam-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(379, 8, 2, 18, 'سرخا پائین', NULL, NULL, NULL, 'sorkha-payin-takht', 'iran-hormozgan-bandar-abbas-sorkha-payin-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(380, 8, 2, 18, 'گچکنی', NULL, NULL, NULL, 'gachkani-takht', 'iran-hormozgan-bandar-abbas-gachkani-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(381, 8, 2, 18, 'خورخیاری', NULL, NULL, NULL, 'khorkhiari-takht', 'iran-hormozgan-bandar-abbas-khorkhiari-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(382, 8, 2, 18, 'مازغ مغیران', NULL, NULL, NULL, 'mazagh-moghiran-takht', 'iran-hormozgan-bandar-abbas-mazagh-moghiran-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(383, 8, 2, 18, 'بهرغ بالا/ سرگدار', NULL, NULL, NULL, 'bohrogh-bala-takht', 'iran-hormozgan-bandar-abbas-bohrogh-bala-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(384, 8, 2, 27, 'پاقلاتان پایین', NULL, NULL, NULL, 'paghlatan-payin-jalabi', 'iran-hormozgan-bandar-abbas-paghlatan-payin-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(385, 8, 2, 27, 'پاقلاتان بالا', NULL, NULL, NULL, 'paghlatan-bala-jalabi', 'iran-hormozgan-bandar-abbas-paghlatan-bala-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(386, 8, 2, 27, 'جلابی', NULL, NULL, NULL, 'jalabi-village', 'iran-hormozgan-bandar-abbas-jalabi-village', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(387, 8, 2, 27, 'چاه بس', NULL, NULL, NULL, 'chah-bas-jalabi', 'iran-hormozgan-bandar-abbas-chah-bas-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(388, 8, 2, 27, 'چاه عالی شرقی', NULL, NULL, NULL, 'chah-ali-sharqi-jalabi', 'iran-hormozgan-bandar-abbas-chah-ali-sharqi-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(389, 8, 2, 27, 'چاه عالی غربی', NULL, NULL, NULL, 'chah-ali-gharbi-jalabi', 'iran-hormozgan-bandar-abbas-chah-ali-gharbi-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(390, 8, 2, 27, 'حسین آباد', NULL, NULL, NULL, 'hossein-abad-jalabi', 'iran-hormozgan-bandar-abbas-hossein-abad-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(391, 8, 2, 27, 'دل بودنی', NULL, NULL, NULL, 'del-bodani-jalabi', 'iran-hormozgan-bandar-abbas-del-bodani-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(392, 8, 2, 27, 'سید آباد', NULL, NULL, NULL, 'seyed-abad-jalabi', 'iran-hormozgan-bandar-abbas-seyed-abad-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(393, 8, 2, 27, 'شاه بازان', NULL, NULL, NULL, 'shah-bazan-jalabi', 'iran-hormozgan-bandar-abbas-shah-bazan-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(394, 8, 2, 27, 'کل ذرت', NULL, NULL, NULL, 'kol-zorat-jalabi', 'iran-hormozgan-bandar-abbas-kol-zorat-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(395, 8, 2, 27, 'کهور کلاغی', NULL, NULL, NULL, 'kohor-kalaghi-jalabi', 'iran-hormozgan-bandar-abbas-kohor-kalaghi-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(396, 8, 2, 27, 'گاو مرده', NULL, NULL, NULL, 'gav-morde-jalabi', 'iran-hormozgan-bandar-abbas-gav-morde-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(397, 8, 2, 27, 'محمود كلاهی', NULL, NULL, NULL, 'mahmud-kolahi-jalabi', 'iran-hormozgan-bandar-abbas-mahmud-kolahi-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(398, 8, 2, 27, 'نران', NULL, NULL, NULL, 'naran-jalabi', 'iran-hormozgan-bandar-abbas-naran-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(399, 8, 2, 27, 'گنبد سرخ', NULL, NULL, NULL, 'gonbad-sorkh-jalabi', 'iran-hormozgan-bandar-abbas-gonbad-sorkh-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(400, 8, 2, 27, 'پاسگاه جلابی', NULL, NULL, NULL, 'pasgah-jalabi', 'iran-hormozgan-bandar-abbas-pasgah-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(401, 8, 2, 27, 'کناران', NULL, NULL, NULL, 'kenaran-jalabi', 'iran-hormozgan-bandar-abbas-kenaran-jalabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(402, 9, 2, 19, 'باریز', NULL, NULL, NULL, 'bariz-qaleh-qazi', 'iran-hormozgan-bandar-abbas-bariz-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(403, 9, 2, 19, 'توج', NULL, NULL, NULL, 'toj-qaleh-qazi', 'iran-hormozgan-bandar-abbas-toj-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(404, 9, 2, 19, 'چاه فعله شرقی', NULL, NULL, NULL, 'chah-faleh-sharqi-qaleh-qazi', 'iran-hormozgan-bandar-abbas-chah-faleh-sharqi-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(405, 9, 2, 19, 'چاه فعله غربی', NULL, NULL, NULL, 'chah-faleh-gharbi-qaleh-qazi', 'iran-hormozgan-bandar-abbas-chah-faleh-gharbi-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(406, 9, 2, 19, 'خرگی', NULL, NULL, NULL, 'kharagi-qaleh-qazi', 'iran-hormozgan-bandar-abbas-kharagi-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(407, 9, 2, 19, 'خور قاسمی', NULL, NULL, NULL, 'khor-ghasemi-qaleh-qazi', 'iran-hormozgan-bandar-abbas-khor-ghasemi-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(408, 9, 2, 19, 'ذرتی', NULL, NULL, NULL, 'zorati-qaleh-qazi', 'iran-hormozgan-bandar-abbas-zorati-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(409, 9, 2, 19, 'ریگو', NULL, NULL, NULL, 'rigu-qaleh-qazi', 'iran-hormozgan-bandar-abbas-rigu-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(410, 9, 2, 19, 'سرچیل', NULL, NULL, NULL, 'sarchil-qaleh-qazi', 'iran-hormozgan-bandar-abbas-sarchil-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(411, 9, 2, 19, 'طاهری', NULL, NULL, NULL, 'taheri-qaleh-qazi', 'iran-hormozgan-bandar-abbas-taheri-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(412, 9, 2, 19, 'كدوكار', NULL, NULL, NULL, 'kodokar-qaleh-qazi', 'iran-hormozgan-bandar-abbas-kodokar-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(413, 9, 2, 19, 'گزریز', NULL, NULL, NULL, 'gazriz-qaleh-qazi', 'iran-hormozgan-bandar-abbas-gazriz-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(414, 9, 2, 19, 'برتمب', NULL, NULL, NULL, 'bartamb-qaleh-qazi', 'iran-hormozgan-bandar-abbas-bartamb-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(415, 9, 2, 19, 'گودو', NULL, NULL, NULL, 'godo-qaleh-qazi', 'iran-hormozgan-bandar-abbas-godo-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(416, 9, 2, 19, 'مدنگ احمد', NULL, NULL, NULL, 'madang-ahmad-qaleh-qazi', 'iran-hormozgan-bandar-abbas-madang-ahmad-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(417, 9, 2, 19, 'نوبست', NULL, NULL, NULL, 'nobast-qaleh-qazi', 'iran-hormozgan-bandar-abbas-nobast-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(418, 9, 2, 19, 'پیرچیلی', NULL, NULL, NULL, 'pirchili-qaleh-qazi', 'iran-hormozgan-bandar-abbas-pirchili-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(419, 9, 2, 19, 'شهر كهنه', NULL, NULL, NULL, 'shahr-kohne-qaleh-qazi', 'iran-hormozgan-bandar-abbas-shahr-kohne-qaleh-qazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(420, 9, 2, 28, 'چوج', NULL, NULL, NULL, 'choj-dehno', 'iran-hormozgan-bandar-abbas-choj-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(421, 9, 2, 28, 'خور چاه', NULL, NULL, NULL, 'khor-chah-dehno', 'iran-hormozgan-bandar-abbas-khor-chah-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(422, 9, 2, 28, 'دهنو بالا', NULL, NULL, NULL, 'dehno-bala-dehno', 'iran-hormozgan-bandar-abbas-dehno-bala-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(423, 9, 2, 28, 'گل ملك', NULL, NULL, NULL, 'gol-molk-dehno', 'iran-hormozgan-bandar-abbas-gol-molk-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(424, 9, 2, 28, 'كولغان تومان غلام حسن', NULL, NULL, NULL, 'kolghan-toman-gholam-hasan-dehno', 'iran-hormozgan-bandar-abbas-kolghan-toman-gholam-hasan-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(425, 9, 2, 28, 'كولغان تومان عبدالله', NULL, NULL, NULL, 'kolghan-toman-abdollah-dehno', 'iran-hormozgan-bandar-abbas-kolghan-toman-abdollah-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(426, 9, 2, 28, 'پاسگاه انتظامی كولغان', NULL, NULL, NULL, 'pasgah-entezami-kolghan-dehno', 'iran-hormozgan-bandar-abbas-pasgah-entezami-kolghan-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(427, 9, 2, 28, 'سایت پرورش میگوی كولغان', NULL, NULL, NULL, 'site-parvaresh-meygou-kolghan-dehno', 'iran-hormozgan-bandar-abbas-site-parvaresh-meygou-kolghan-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(428, 9, 2, 28, 'دهنو پایین', NULL, NULL, NULL, 'dehno-payin-dehno', 'iran-hormozgan-bandar-abbas-dehno-payin-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(429, 11, 2, 29, 'چاه خرگ', NULL, NULL, NULL, 'chah-kharg-hasan-langi', 'iran-hormozgan-bandar-abbas-chah-kharg-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(430, 11, 2, 29, 'چیل گرگی', NULL, NULL, NULL, 'chil-gorgi-hasan-langi', 'iran-hormozgan-bandar-abbas-chil-gorgi-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(431, 11, 2, 29, 'حسن لنگی پایین', NULL, NULL, NULL, 'hasan-langi-payin', 'iran-hormozgan-bandar-abbas-hasan-langi-payin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(432, 11, 2, 29, 'سرزه آل مهتریان', NULL, NULL, NULL, 'sarzeh-al-mehtarian-hasan-langi', 'iran-hormozgan-bandar-abbas-sarzeh-al-mehtarian-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(433, 11, 2, 29, 'سرزه خاروک', NULL, NULL, NULL, 'sarzeh-kharook-hasan-langi', 'iran-hormozgan-bandar-abbas-sarzeh-kharook-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(434, 11, 2, 29, 'سمسلو', NULL, NULL, NULL, 'samsalu-hasan-langi', 'iran-hormozgan-bandar-abbas-samsalu-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(435, 11, 2, 29, 'سهرابی', NULL, NULL, NULL, 'sohrabi-hasan-langi', 'iran-hormozgan-bandar-abbas-sohrabi-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(436, 11, 2, 29, 'کرمون', NULL, NULL, NULL, 'karmon-hasan-langi', 'iran-hormozgan-bandar-abbas-karmon-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(437, 11, 2, 29, 'زمین سنگ', NULL, NULL, NULL, 'zamin-sang-hasan-langi', 'iran-hormozgan-bandar-abbas-zamin-sang-hasan-langi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(438, 11, 2, 29, 'حسن لنگی بالا/ گزکی حسن لنگی', NULL, NULL, NULL, 'hasan-langi-bala', 'iran-hormozgan-bandar-abbas-hasan-langi-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(439, 11, 2, 30, 'آبکهور', NULL, NULL, NULL, 'abkohor-shamil', 'iran-hormozgan-bandar-abbas-abkohor-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(440, 11, 2, 30, 'بالولی', NULL, NULL, NULL, 'balooli-shamil', 'iran-hormozgan-bandar-abbas-balooli-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(441, 11, 2, 30, 'گوجگ پشتکوه', NULL, NULL, NULL, 'gojg-poshtkuh-shamil', 'iran-hormozgan-bandar-abbas-gojg-poshtkuh-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(442, 11, 2, 30, 'پشتکوه', NULL, NULL, NULL, 'poshtkuh-shamil', 'iran-hormozgan-bandar-abbas-poshtkuh-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(443, 11, 2, 30, 'تنب باریکو', NULL, NULL, NULL, 'tanb-bariko-shamil', 'iran-hormozgan-bandar-abbas-tanb-bariko-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(444, 11, 2, 30, 'درتوجان', NULL, NULL, NULL, 'dartoojan-shamil', 'iran-hormozgan-bandar-abbas-dartoojan-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(445, 11, 2, 30, 'زنهی', NULL, NULL, NULL, 'zanahi-shamil', 'iran-hormozgan-bandar-abbas-zanahi-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(446, 11, 2, 30, 'زهوکی', NULL, NULL, NULL, 'zahooki-shamil', 'iran-hormozgan-bandar-abbas-zahooki-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(447, 11, 2, 30, 'سرخنگی', NULL, NULL, NULL, 'sarkhanghi-shamil', 'iran-hormozgan-bandar-abbas-sarkhanghi-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(448, 11, 2, 30, 'سرزه پشت بند', NULL, NULL, NULL, 'sarzeh-poshte-band-shamil', 'iran-hormozgan-bandar-abbas-sarzeh-poshte-band-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(449, 11, 2, 30, 'سرزه شمیل', NULL, NULL, NULL, 'sarzeh-shamil', 'iran-hormozgan-bandar-abbas-sarzeh-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(450, 11, 2, 30, 'سرسماد', NULL, NULL, NULL, 'sarsamad-shamil', 'iran-hormozgan-bandar-abbas-sarsamad-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(451, 11, 2, 30, 'سرکم', NULL, NULL, NULL, 'sarkam-shamil', 'iran-hormozgan-bandar-abbas-sarkam-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(452, 11, 2, 30, 'سرریگ', NULL, NULL, NULL, 'sar-rig-shamil', 'iran-hormozgan-bandar-abbas-sar-rig-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(453, 11, 2, 30, 'سلوبلم', NULL, NULL, NULL, 'soloblem-shamil', 'iran-hormozgan-bandar-abbas-soloblem-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(454, 11, 2, 30, 'سنخرو', NULL, NULL, NULL, 'sankhro-shamil', 'iran-hormozgan-bandar-abbas-sankhro-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(455, 11, 2, 30, 'قلم', NULL, NULL, NULL, 'ghalam-shamil', 'iran-hormozgan-bandar-abbas-ghalam-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(456, 11, 2, 30, 'کشکو', NULL, NULL, NULL, 'kashko-shamil', 'iran-hormozgan-bandar-abbas-kashko-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(457, 11, 2, 30, 'کنار سیاه', NULL, NULL, NULL, 'kenar-siah-shamil', 'iran-hormozgan-bandar-abbas-kenar-siah-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(458, 11, 2, 30, 'کوه دازان', NULL, NULL, NULL, 'kuh-dazan-shamil', 'iran-hormozgan-bandar-abbas-kuh-dazan-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(459, 11, 2, 30, 'کوه لهرو', NULL, NULL, NULL, 'kuh-lahro-shamil', 'iran-hormozgan-bandar-abbas-kuh-lahro-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(460, 11, 2, 30, 'گردنه پشتکوه', NULL, NULL, NULL, 'gardaneh-poshtkuh-shamil', 'iran-hormozgan-bandar-abbas-gardaneh-poshtkuh-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(461, 11, 2, 30, 'گرده', NULL, NULL, NULL, 'gerdeh-shamil', 'iran-hormozgan-bandar-abbas-gerdeh-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(462, 11, 2, 30, 'نیان', NULL, NULL, NULL, 'niyan-shamil', 'iran-hormozgan-bandar-abbas-niyan-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(463, 11, 2, 30, 'چاه سرگزان/ شاگزان', NULL, NULL, NULL, 'chah-sargazan-shamil', 'iran-hormozgan-bandar-abbas-chah-sargazan-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL);
INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(464, 11, 2, 30, 'مغیران', NULL, NULL, NULL, 'moghiran-shamil', 'iran-hormozgan-bandar-abbas-moghiran-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(465, 11, 2, 30, 'سنگ بهمن', NULL, NULL, NULL, 'sang-bahman-shamil', 'iran-hormozgan-bandar-abbas-sang-bahman-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(466, 11, 2, 30, 'بندر محمد کهوری', NULL, NULL, NULL, 'bandar-mohammad-kohori-shamil', 'iran-hormozgan-bandar-abbas-bandar-mohammad-kohori-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(467, 11, 2, 30, 'لهرو پایین', NULL, NULL, NULL, 'lahro-payin-shamil', 'iran-hormozgan-bandar-abbas-lahro-payin-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(468, 11, 2, 30, 'آبگلمان', NULL, NULL, NULL, 'abgalaman-shamil', 'iran-hormozgan-bandar-abbas-abgalaman-shamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(469, 11, 2, 30, 'شمیل', NULL, NULL, NULL, 'shamil-village', 'iran-hormozgan-bandar-abbas-shamil-village', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 21:13:15', '2025-05-17 03:20:33', NULL),
(470, 12, 9, 31, 'احمد آباد', NULL, NULL, NULL, 'ahmadabad-jenah', 'iran-hormozgan-bastak-ahmadabad-jenah', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(471, 12, 9, 31, 'اشكفت سیاه', NULL, NULL, NULL, 'eshkaft-siah', 'iran-hormozgan-bastak-eshkaft-siah', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(472, 12, 9, 31, 'كهتویه', NULL, NULL, NULL, 'kohtuyeh', 'iran-hormozgan-bastak-kohtuyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(473, 12, 9, 31, 'میستان', NULL, NULL, NULL, 'mistan', 'iran-hormozgan-bastak-mistan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(474, 12, 9, 31, 'پای تاوه', NULL, NULL, NULL, 'pay-taaveh', 'iran-hormozgan-bastak-pay-taaveh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(475, 12, 9, 31, 'چاله فرامرزان', NULL, NULL, NULL, 'chaleh-faramarzan', 'iran-hormozgan-bastak-chaleh-faramarzan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(476, 12, 9, 31, 'مزرعه حیدر پدیدار', NULL, NULL, NULL, 'mazraeh-heydar-padidar', 'iran-hormozgan-bastak-mazraeh-heydar-padidar', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(477, 12, 9, 31, 'نهند', NULL, NULL, NULL, 'nahand', 'iran-hormozgan-bastak-nahand', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(478, 12, 9, 31, 'گرن', NULL, NULL, NULL, 'gorn', 'iran-hormozgan-bastak-gorn', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(479, 12, 9, 31, 'لاور میستان', NULL, NULL, NULL, 'lavar-mistan', 'iran-hormozgan-bastak-lavar-mistan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(480, 12, 9, 31, 'گره كوه', NULL, NULL, NULL, 'gareh-kuh', 'iran-hormozgan-bastak-gareh-kuh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(481, 12, 9, 31, 'پادرو', NULL, NULL, NULL, 'padru', 'iran-hormozgan-bastak-padru', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(482, 12, 9, 38, 'خمر قلندران', NULL, NULL, NULL, 'khomar-qalandaran', 'iran-hormozgan-bastak-khomar-qalandaran', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(483, 12, 9, 38, 'داربست', NULL, NULL, NULL, 'darbast', 'iran-hormozgan-bastak-darbast', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(484, 12, 9, 38, 'دهنو خواجه', NULL, NULL, NULL, 'dehnoo-khajeh', 'iran-hormozgan-bastak-dehnoo-khajeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(485, 12, 9, 38, 'دهنو قلندران', NULL, NULL, NULL, 'dehnoo-qalandaran', 'iran-hormozgan-bastak-dehnoo-qalandaran', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(486, 12, 9, 38, 'عالی احمدان', NULL, NULL, NULL, 'ali-ahmadan', 'iran-hormozgan-bastak-ali-ahmadan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(487, 12, 9, 38, 'كنار سیاه', NULL, NULL, NULL, 'kenar-siah-faramarzan', 'iran-hormozgan-bastak-kenar-siah-faramarzan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(488, 12, 9, 38, 'گچوئیه', NULL, NULL, NULL, 'gachooyeh', 'iran-hormozgan-bastak-gachooyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(489, 12, 9, 38, 'گزه', NULL, NULL, NULL, 'gozeh', 'iran-hormozgan-bastak-gozeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(490, 12, 9, 38, 'كمشك', NULL, NULL, NULL, 'komshek', 'iran-hormozgan-bastak-komshek', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(491, 13, 9, 39, 'ازادی', NULL, NULL, NULL, 'azadi', 'iran-hormozgan-bastak-azadi', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(492, 13, 9, 39, 'انجیردان', NULL, NULL, NULL, 'anjirdan', 'iran-hormozgan-bastak-anjirdan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(493, 13, 9, 39, 'ایلچی بالا', NULL, NULL, NULL, 'iilchi-bala', 'iran-hormozgan-bastak-iilchi-bala', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(494, 13, 9, 39, 'ایلود', NULL, NULL, NULL, 'iilud', 'iran-hormozgan-bastak-iilud', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(495, 13, 9, 39, 'باغ نو', NULL, NULL, NULL, 'bagh-e-no', 'iran-hormozgan-bastak-bagh-e-no', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(496, 13, 9, 39, 'بامستان', NULL, NULL, NULL, 'bamestan', 'iran-hormozgan-bastak-bamestan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(497, 13, 9, 39, 'بركه لاری', NULL, NULL, NULL, 'berkah-lari', 'iran-hormozgan-bastak-berkah-lari', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(498, 13, 9, 39, 'تنگ تلخ', NULL, NULL, NULL, 'tang-talkh', 'iran-hormozgan-bastak-tang-talkh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(499, 13, 9, 39, 'چاه دزدان', NULL, NULL, NULL, 'chah-dozdan', 'iran-hormozgan-bastak-chah-dozdan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(500, 13, 9, 39, 'خشاوه', NULL, NULL, NULL, 'khoshaveh', 'iran-hormozgan-bastak-khoshaveh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(501, 13, 9, 39, 'خلیل', NULL, NULL, NULL, 'khalil', 'iran-hormozgan-bastak-khalil', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(502, 13, 9, 39, 'دوبستو', NULL, NULL, NULL, 'do-bosto', 'iran-hormozgan-bastak-do-bosto', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(503, 13, 9, 39, 'ده تل', NULL, NULL, NULL, 'deh-e-tal-village', 'iran-hormozgan-bastak-deh-e-tal-village', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(504, 13, 9, 39, 'رودبار', NULL, NULL, NULL, 'rudbar-bastak', 'iran-hormozgan-bastak-rudbar', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(505, 13, 9, 39, 'روی گچ', NULL, NULL, NULL, 'ruy-gach', 'iran-hormozgan-bastak-ruy-gach', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(506, 13, 9, 39, 'سرك', NULL, NULL, NULL, 'sarok', 'iran-hormozgan-bastak-sarok', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(507, 13, 9, 39, 'سید احمدی', NULL, NULL, NULL, 'seyed-ahmadi', 'iran-hormozgan-bastak-seyed-ahmadi', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(508, 13, 9, 39, 'كرزه', NULL, NULL, NULL, 'karzeh', 'iran-hormozgan-bastak-karzeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(509, 13, 9, 39, 'كنجی', NULL, NULL, NULL, 'konji', 'iran-hormozgan-bastak-konji', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(510, 13, 9, 39, 'لرد بستو', NULL, NULL, NULL, 'lard-bosto', 'iran-hormozgan-bastak-lard-bosto', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(511, 13, 9, 39, 'لاور سفلی', NULL, NULL, NULL, 'lavar-sofla', 'iran-hormozgan-bastak-lavar-sofla', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(512, 13, 9, 39, 'مورد', NULL, NULL, NULL, 'murd', 'iran-hormozgan-bastak-murd', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(513, 13, 9, 39, 'حمدونی', NULL, NULL, NULL, 'hamduni', 'iran-hormozgan-bastak-hamduni', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(514, 13, 9, 39, 'طهر', NULL, NULL, NULL, 'tohr', 'iran-hormozgan-bastak-tohr', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(515, 13, 9, 39, 'كفچال', NULL, NULL, NULL, 'kafchal', 'iran-hormozgan-bastak-kafchal', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(516, 13, 9, 39, 'مروارید انجیردان', NULL, NULL, NULL, 'morvarid-anjirdan', 'iran-hormozgan-bastak-morvarid-anjirdan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(517, 13, 9, 37, 'انوه', NULL, NULL, NULL, 'anveh', 'iran-hormozgan-bastak-anveh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(518, 13, 9, 37, 'براشت پائین', NULL, NULL, NULL, 'barasht-payin', 'iran-hormozgan-bastak-barasht-payin', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(519, 13, 9, 37, 'بستقلات', NULL, NULL, NULL, 'bastaghlat', 'iran-hormozgan-bastak-bastaghlat', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(520, 13, 9, 37, 'ملوردی', NULL, NULL, NULL, 'malverdi', 'iran-hormozgan-bastak-malverdi', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(521, 13, 9, 37, 'بیسه', NULL, NULL, NULL, 'biseh', 'iran-hormozgan-bastak-biseh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(522, 13, 9, 37, 'تنگ شهر', NULL, NULL, NULL, 'tang-shahr', 'iran-hormozgan-bastak-tang-shahr', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(523, 13, 9, 37, 'چاه قیل', NULL, NULL, NULL, 'chah-ghil', 'iran-hormozgan-bastak-chah-ghil', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(524, 13, 9, 37, 'شیخ حضور', NULL, NULL, NULL, 'sheikh-hozur', 'iran-hormozgan-bastak-sheikh-hozur', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(525, 13, 9, 37, 'فاریاب سنگویه', NULL, NULL, NULL, 'faryab-sanguyeh', 'iran-hormozgan-bastak-faryab-sanguyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(526, 13, 9, 37, 'گیلوئیه', NULL, NULL, NULL, 'giluyeh', 'iran-hormozgan-bastak-giluyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(527, 13, 9, 37, 'مردنو', NULL, NULL, NULL, 'mard-e-no', 'iran-hormozgan-bastak-mard-e-no', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(528, 13, 9, 37, 'نخل خین', NULL, NULL, NULL, 'nakhle-khin', 'iran-hormozgan-bastak-nakhle-khin', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(529, 13, 9, 37, 'گود كز', NULL, NULL, NULL, 'good-kaz', 'iran-hormozgan-bastak-good-kaz', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(530, 13, 9, 37, 'همدونی', NULL, NULL, NULL, 'hamduni-fatuyeh', 'iran-hormozgan-bastak-hamduni-fatuyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(531, 13, 9, 37, 'براشت بالا', NULL, NULL, NULL, 'barasht-bala', 'iran-hormozgan-bastak-barasht-bala', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(532, 13, 9, 37, 'مغدان', NULL, NULL, NULL, 'moghadan', 'iran-hormozgan-bastak-moghadan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(533, 13, 9, 37, 'بیخ', NULL, NULL, NULL, 'bikh', 'iran-hormozgan-bastak-bikh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(534, 13, 9, 37, 'حسین آباد', NULL, NULL, NULL, 'hosein-abad-fatuyeh', 'iran-hormozgan-bastak-hosein-abad-fatuyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(535, 13, 9, 37, 'تنگ بستک', NULL, NULL, NULL, 'tang-bastak', 'iran-hormozgan-bastak-tang-bastak', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(536, 13, 9, 37, 'فتویه', NULL, NULL, NULL, 'fatuyeh-village', 'iran-hormozgan-bastak-fatuyeh-village', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:38:11', '2025-05-17 03:20:33', NULL),
(537, 13, 9, 40, 'بدخ', NULL, NULL, NULL, 'badakh', 'iran-hormozgan-bastak-badakh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(538, 13, 9, 40, 'بیگلر آباد', NULL, NULL, NULL, 'biglar-abad', 'iran-hormozgan-bastak-biglar-abad', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(539, 13, 9, 40, 'تسان', NULL, NULL, NULL, 'tesan', 'iran-hormozgan-bastak-tesan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(540, 13, 9, 40, 'چاه سرمه', NULL, NULL, NULL, 'chah-sormeh', 'iran-hormozgan-bastak-chah-sormeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(541, 13, 9, 40, 'چاه بنارد', NULL, NULL, NULL, 'chah-benard', 'iran-hormozgan-bastak-chah-benard', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(542, 13, 9, 40, 'دهنگ', NULL, NULL, NULL, 'dehang', 'iran-hormozgan-bastak-dehang', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(543, 13, 9, 40, 'عالی قندی', NULL, NULL, NULL, 'ali-ghandi', 'iran-hormozgan-bastak-ali-ghandi', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(544, 13, 9, 40, 'گاله', NULL, NULL, NULL, 'galeh', 'iran-hormozgan-bastak-galeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(545, 13, 9, 40, 'گاوبری', NULL, NULL, NULL, 'gavbori', 'iran-hormozgan-bastak-gavbori', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(546, 13, 9, 40, 'گشون', NULL, NULL, NULL, 'goshun', 'iran-hormozgan-bastak-goshun', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(547, 13, 9, 40, 'گیل', NULL, NULL, NULL, 'gil', 'iran-hormozgan-bastak-gil', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(548, 13, 9, 40, 'ناخری', NULL, NULL, NULL, 'nakhri', 'iran-hormozgan-bastak-nakhri', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(549, 13, 9, 40, 'هرا', NULL, NULL, NULL, 'hara-bastak', 'iran-hormozgan-bastak-hara', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(550, 13, 9, 40, 'آبگرم تدروئیه', NULL, NULL, NULL, 'ab-garm-taderuyeh', 'iran-hormozgan-bastak-ab-garm-taderuyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(551, 13, 9, 40, 'چاه چهه', NULL, NULL, NULL, 'chah-cheh', 'iran-hormozgan-bastak-chah-cheh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(552, 13, 9, 40, 'كلات گودی', NULL, NULL, NULL, 'kalat-godi', 'iran-hormozgan-bastak-kalat-godi', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(553, 13, 9, 40, 'كل مسلی', NULL, NULL, NULL, 'kal-masli', 'iran-hormozgan-bastak-kal-masli', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(554, 13, 9, 40, 'شیلی', NULL, NULL, NULL, 'shili', 'iran-hormozgan-bastak-shili', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(555, 13, 9, 40, 'پت', NULL, NULL, NULL, 'pat', 'iran-hormozgan-bastak-pat', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(556, 13, 9, 40, 'بنگری', NULL, NULL, NULL, 'bangari', 'iran-hormozgan-bastak-bangari', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(557, 13, 9, 40, 'بدستان', NULL, NULL, NULL, 'bodestan', 'iran-hormozgan-bastak-bodestan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(558, 13, 9, 40, 'نیدان', NULL, NULL, NULL, 'nidan', 'iran-hormozgan-bastak-nidan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(559, 13, 9, 40, 'اشكت دراز', NULL, NULL, NULL, 'eshkat-deraz', 'iran-hormozgan-bastak-eshkat-deraz', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(560, 13, 9, 40, 'بن كوه', NULL, NULL, NULL, 'bon-kuh', 'iran-hormozgan-bastak-bon-kuh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(561, 13, 9, 40, 'تنگ قلم', NULL, NULL, NULL, 'tang-ghalam', 'iran-hormozgan-bastak-tang-ghalam', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(562, 13, 9, 40, 'تدروییه', NULL, NULL, NULL, 'taderuyeh', 'iran-hormozgan-bastak-taderuyeh', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(563, 13, 9, 40, 'زنگارد', NULL, NULL, NULL, 'zangard', 'iran-hormozgan-bastak-zangard', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(564, 13, 9, 40, 'گوده', NULL, NULL, NULL, 'godeh-village', 'iran-hormozgan-bastak-godeh-village', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:08', '2025-05-17 03:20:33', NULL),
(565, 14, 9, 35, 'اسو', NULL, NULL, NULL, 'asu', 'iran-hormozgan-bastak-asu', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(566, 14, 9, 35, 'بار', NULL, NULL, NULL, 'bar', 'iran-hormozgan-bastak-bar', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(567, 14, 9, 35, 'بربار', NULL, NULL, NULL, 'barbar', 'iran-hormozgan-bastak-barbar', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(568, 14, 9, 35, 'تخت گرو', NULL, NULL, NULL, 'takht-goru', 'iran-hormozgan-bastak-takht-goru', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(569, 14, 9, 35, 'تلخ اطهر', NULL, NULL, NULL, 'talkh-atar', 'iran-hormozgan-bastak-talkh-atar', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(570, 14, 9, 35, 'چاله', NULL, NULL, NULL, 'chaleh-kookherd', 'iran-hormozgan-bastak-chaleh-kookherd', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(571, 14, 9, 35, 'دی خور', NULL, NULL, NULL, 'di-khur', 'iran-hormozgan-bastak-di-khur', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(572, 14, 9, 35, 'كرون', NULL, NULL, NULL, 'karon', 'iran-hormozgan-bastak-karon', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(573, 14, 9, 35, 'كوران', NULL, NULL, NULL, 'kuran', 'iran-hormozgan-bastak-kuran', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(574, 14, 9, 35, 'كوردان', NULL, NULL, NULL, 'kordan', 'iran-hormozgan-bastak-kordan', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(575, 14, 9, 35, 'گریند', NULL, NULL, NULL, 'grind', 'iran-hormozgan-bastak-grind', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(576, 14, 9, 35, 'گوچی', NULL, NULL, NULL, 'gochi', 'iran-hormozgan-bastak-gochi', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(577, 14, 9, 35, 'لاور', NULL, NULL, NULL, 'lavar-kookherd', 'iran-hormozgan-bastak-lavar-kookherd', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(578, 14, 9, 35, 'لاور دین', NULL, NULL, NULL, 'lavar-din', 'iran-hormozgan-bastak-lavar-din', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(579, 14, 9, 35, 'یس دوچنگ', NULL, NULL, NULL, 'yas-dochang', 'iran-hormozgan-bastak-yas-dochang', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(580, 14, 9, 35, 'تشتو', NULL, NULL, NULL, 'tashtu', 'iran-hormozgan-bastak-tashtu', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(581, 14, 9, 35, 'شهرك صالح آباد', NULL, NULL, NULL, 'shahrak-saleh-abad', 'iran-hormozgan-bastak-shahrak-saleh-abad', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(582, 14, 9, 35, 'بارترك', NULL, NULL, NULL, 'bartark', 'iran-hormozgan-bastak-bartark', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(583, 14, 9, 35, 'كنار زرد', NULL, NULL, NULL, 'kenar-zard', 'iran-hormozgan-bastak-kenar-zard', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(584, 14, 9, 35, 'كافه لاوردین', NULL, NULL, NULL, 'kafe-lavardin', 'iran-hormozgan-bastak-kafe-lavardin', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(585, 14, 9, 35, 'كوخرد', NULL, NULL, NULL, 'kookherd-village', 'iran-hormozgan-bastak-kookherd-village', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(586, 14, 9, 36, 'خلوص', NULL, NULL, NULL, 'khalus', 'iran-hormozgan-bastak-khalus', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(587, 14, 9, 36, 'فاریاب', NULL, NULL, NULL, 'faryab-harang', 'iran-hormozgan-bastak-faryab-harang', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(588, 14, 9, 36, 'كاشونی', NULL, NULL, NULL, 'kashuni', 'iran-hormozgan-bastak-kashuni', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(589, 14, 9, 36, 'گتاو', NULL, NULL, NULL, 'gatav', 'iran-hormozgan-bastak-gatav', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(590, 14, 9, 36, 'لاور جمیل', NULL, NULL, NULL, 'lavar-jamil', 'iran-hormozgan-bastak-lavar-jamil', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(591, 14, 9, 36, 'هرنگ', NULL, NULL, NULL, 'harang-village', 'iran-hormozgan-bastak-harang-village', NULL, NULL, NULL, NULL, NULL, NULL, '076', NULL, 1, '2025-04-24 21:42:58', '2025-05-17 03:20:33', NULL),
(592, 15, 11, 44, 'حمیران', NULL, NULL, NULL, 'hamiran', 'iran-hormozgan-parsian-hamiran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:59:29', '2025-05-17 03:20:33', NULL),
(593, 15, 11, 44, 'هشنیز', NULL, NULL, NULL, 'hashniz', 'iran-hormozgan-parsian-hashniz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:59:29', '2025-05-17 03:20:33', NULL),
(594, 15, 11, 44, 'احمدی', NULL, NULL, NULL, 'ahmadi', 'iran-hormozgan-parsian-ahmadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:59:29', '2025-05-17 03:20:33', NULL),
(595, 15, 11, 44, 'حمیران جنوبی', NULL, NULL, NULL, 'hamiran-jonubi', 'iran-hormozgan-parsian-hamiran-jonubi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 22:59:29', '2025-05-17 03:20:33', NULL),
(596, 15, 11, 45, 'بمبری', NULL, NULL, NULL, 'bambari', 'iran-hormozgan-parsian-bambari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(597, 15, 11, 45, 'چكچك جنوبی', NULL, NULL, NULL, 'chakchak-jonubi', 'iran-hormozgan-parsian-chakchak-jonubi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(598, 15, 11, 45, 'چكچك شمالی', NULL, NULL, NULL, 'chakchak-shomali', 'iran-hormozgan-parsian-chakchak-shomali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(599, 15, 11, 45, 'چهواز', NULL, NULL, NULL, 'chavaz', 'iran-hormozgan-parsian-chavaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(600, 15, 11, 45, 'حاجی آباد', NULL, NULL, NULL, 'hajjiabad', 'iran-hormozgan-parsian-hajjiabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(601, 15, 11, 45, 'دم تیر جنوبی', NULL, NULL, NULL, 'dam-tir-jonubi', 'iran-hormozgan-parsian-dam-tir-jonubi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(602, 15, 11, 45, 'رستم آباد', NULL, NULL, NULL, 'rostamabad', 'iran-hormozgan-parsian-rostamabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(603, 15, 11, 45, 'فومستان', NULL, NULL, NULL, 'fumestan', 'iran-hormozgan-parsian-fumestan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(604, 15, 11, 45, 'قاسم آباد', NULL, NULL, NULL, 'qasemabad', 'iran-hormozgan-parsian-qasemabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(605, 15, 11, 45, 'كنار سبز', NULL, NULL, NULL, 'kenar-sabz', 'iran-hormozgan-parsian-kenar-sabz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(606, 15, 11, 45, 'گود كناردان', NULL, NULL, NULL, 'gud-kanardan', 'iran-hormozgan-parsian-gud-kanardan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(607, 15, 11, 45, 'میلكی', NULL, NULL, NULL, 'milki', 'iran-hormozgan-parsian-milki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(608, 15, 11, 45, 'یرد خردو', NULL, NULL, NULL, 'yerd-kherdu', 'iran-hormozgan-parsian-yerd-kherdu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(609, 15, 11, 45, 'یرد خلف', NULL, NULL, NULL, 'yerd-khalf', 'iran-hormozgan-parsian-yerd-khalf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(610, 15, 11, 45, 'باغستان', NULL, NULL, NULL, 'baghstan', 'iran-hormozgan-parsian-baghstan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(611, 15, 11, 45, 'دمتیر شمالی', NULL, NULL, NULL, 'dam-tir-shomali', 'iran-hormozgan-parsian-dam-tir-shomali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(612, 15, 11, 45, 'مزرعه پیشو', NULL, NULL, NULL, 'mazraeh-pishu', 'iran-hormozgan-parsian-mazraeh-pishu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(613, 15, 11, 45, 'چیكلو', NULL, NULL, NULL, 'chiklu', 'iran-hormozgan-parsian-chiklu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(614, 15, 11, 45, 'خوضو', NULL, NULL, NULL, 'khozoo', 'iran-hormozgan-parsian-khozoo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(615, 15, 11, 45, 'یرد بصراوی', NULL, NULL, NULL, 'yerd-basravi', 'iran-hormozgan-parsian-yerd-basravi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(616, 15, 11, 45, 'یرد قاسم عالی', NULL, NULL, '6631', 'yerd-qasem-ali', 'iran-hormozgan-parsian-yerd-qasem-ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:04:47', '2025-05-17 03:20:33', NULL),
(617, 16, 11, 42, 'بندر بستانو', NULL, NULL, NULL, 'bandar-bostanu', 'iran-hormozgan-parsian-bandar-bostanu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:17', '2025-05-17 03:20:33', NULL),
(618, 16, 11, 42, 'زیارت', NULL, NULL, NULL, 'ziarat', 'iran-hormozgan-parsian-ziarat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:17', '2025-05-17 03:20:33', NULL),
(619, 16, 11, 42, 'ستلو', NULL, NULL, NULL, 'satlu', 'iran-hormozgan-parsian-satlu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:17', '2025-05-17 03:20:33', NULL),
(620, 16, 11, 42, 'بندر شیو', NULL, NULL, NULL, 'bandar-shiv', 'iran-hormozgan-parsian-bandar-shiv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:17', '2025-05-17 03:20:33', NULL),
(621, 16, 11, 42, 'مغدان', NULL, NULL, NULL, 'moghadan', 'iran-hormozgan-parsian-moghadan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:17', '2025-05-17 03:20:33', NULL),
(622, 16, 11, 42, 'اكبری', NULL, NULL, NULL, 'akbari', 'iran-hormozgan-parsian-akbari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(623, 16, 11, 42, 'تنبو جنوبی', NULL, NULL, NULL, 'tonbu-jonubi', 'iran-hormozgan-parsian-tonbu-jonubi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(624, 16, 11, 42, 'تنبو شمالی', NULL, NULL, NULL, 'tonbu-shomali', 'iran-hormozgan-parsian-tonbu-shomali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(625, 16, 11, 42, 'غورزه', NULL, NULL, NULL, 'ghoorzeh', 'iran-hormozgan-parsian-ghoorzeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(626, 16, 11, 42, 'سورباش', NULL, NULL, NULL, 'surbash', 'iran-hormozgan-parsian-surbash', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(627, 16, 11, 42, 'فارسی', NULL, NULL, NULL, 'farsi', 'iran-hormozgan-parsian-farsi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(628, 16, 11, 42, 'بركه دكا', NULL, NULL, NULL, 'berkah-daka', 'iran-hormozgan-parsian-berkah-daka', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(629, 16, 11, 42, 'چاه شنبه', NULL, NULL, NULL, 'chah-shanbeh', 'iran-hormozgan-parsian-chah-shanbeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(630, 16, 11, 42, 'عمانی', NULL, NULL, NULL, 'omani', 'iran-hormozgan-parsian-omani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(631, 16, 11, 42, 'حسین آباد', NULL, NULL, NULL, 'hosseinabad', 'iran-hormozgan-parsian-hosseinabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:05:33', '2025-05-17 03:20:33', NULL),
(632, 17, 12, 47, 'پاتل', NULL, NULL, NULL, 'patel', 'iran-hormozgan-sirik-patel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(633, 17, 12, 47, 'سرگلم', NULL, NULL, NULL, 'sargalam', 'iran-hormozgan-sirik-sargalam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(634, 17, 12, 47, 'كلاوی', NULL, NULL, NULL, 'kalavi', 'iran-hormozgan-sirik-kalavi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(635, 17, 12, 47, 'كندال', NULL, NULL, NULL, 'kandal', 'iran-hormozgan-sirik-kandal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(636, 17, 12, 47, 'گردو', NULL, NULL, NULL, 'gerdu', 'iran-hormozgan-sirik-gerdu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(637, 17, 12, 47, 'لبنی', NULL, NULL, NULL, 'labni', 'iran-hormozgan-sirik-labni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(638, 17, 12, 47, 'واداشت', NULL, NULL, NULL, 'vadasht', 'iran-hormozgan-sirik-vadasht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(639, 17, 12, 47, 'مقسان', NULL, NULL, NULL, 'meghsan', 'iran-hormozgan-sirik-meghsan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:21', '2025-05-17 03:20:33', NULL),
(640, 17, 12, 47, 'پالور', NULL, NULL, NULL, 'palur', 'iran-hormozgan-sirik-palur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(641, 17, 12, 47, 'دودر', NULL, NULL, NULL, 'dudar', 'iran-hormozgan-sirik-dudar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(642, 17, 12, 47, 'روتان', NULL, NULL, NULL, 'rutan', 'iran-hormozgan-sirik-rutan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(643, 17, 12, 47, 'زمین ملا', NULL, NULL, NULL, 'zamin-molla', 'iran-hormozgan-sirik-zamin-molla', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(644, 17, 12, 47, 'شامردی', NULL, NULL, NULL, 'shamardi', 'iran-hormozgan-sirik-shamardi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(645, 17, 12, 47, 'كنارجو', NULL, NULL, NULL, 'kenaarju', 'iran-hormozgan-sirik-kenaarju', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(646, 17, 12, 47, 'گچینه پائین', NULL, NULL, NULL, 'gachineh-pain', 'iran-hormozgan-sirik-gachineh-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(647, 17, 12, 47, 'محملیان', NULL, NULL, NULL, 'mahmalian', 'iran-hormozgan-sirik-mahmalian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(648, 17, 12, 47, 'كرپان', NULL, NULL, NULL, 'kerpan', 'iran-hormozgan-sirik-kerpan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(649, 17, 12, 47, 'گچینه بالا', NULL, NULL, NULL, 'gachineh-bala', 'iran-hormozgan-sirik-gachineh-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:08:48', '2025-05-17 03:20:33', NULL),
(650, 18, 12, 46, 'ددی', NULL, NULL, NULL, 'dedi', 'iran-hormozgan-sirik-dedi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(651, 18, 12, 46, 'زرآباد', NULL, NULL, NULL, 'zarabad', 'iran-hormozgan-sirik-zarabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(652, 18, 12, 46, 'سلمه ای', NULL, NULL, NULL, 'salamei', 'iran-hormozgan-sirik-salamei', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(653, 18, 12, 46, 'سیكوئی', NULL, NULL, NULL, 'sikui', 'iran-hormozgan-sirik-sikui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(654, 18, 12, 46, 'خركوشی/ كرگوشكی', NULL, NULL, NULL, 'kharkushi-kargoshki', 'iran-hormozgan-sirik-kharkushi-kargoshki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(655, 18, 12, 46, 'منگلی بریزک', NULL, NULL, NULL, 'mangali-brizak', 'iran-hormozgan-sirik-mangali-brizak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(656, 18, 12, 46, 'هرنگان بریزک', NULL, NULL, NULL, 'harengan-brizak', 'iran-hormozgan-sirik-harengan-brizak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(657, 18, 12, 46, 'بازگرد', NULL, NULL, NULL, 'bazgard', 'iran-hormozgan-sirik-bazgard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(658, 18, 12, 46, 'پاراف پایین', NULL, NULL, NULL, 'paraf-pain', 'iran-hormozgan-sirik-paraf-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(659, 18, 12, 46, 'پگو', NULL, NULL, NULL, 'pegu', 'iran-hormozgan-sirik-pegu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(660, 18, 12, 46, 'جیفری', NULL, NULL, NULL, 'jifri', 'iran-hormozgan-sirik-jifri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(661, 18, 12, 46, 'دیودان', NULL, NULL, NULL, 'divdan', 'iran-hormozgan-sirik-divdan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(662, 18, 12, 46, 'سرزه', NULL, NULL, NULL, 'sarzeh', 'iran-hormozgan-sirik-sarzeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(663, 18, 12, 46, 'سورگی', NULL, NULL, NULL, 'surgi', 'iran-hormozgan-sirik-surgi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(664, 18, 12, 46, 'سول جامك', NULL, NULL, NULL, 'sul-jamk', 'iran-hormozgan-sirik-sul-jamk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(665, 18, 12, 46, 'عاشقان', NULL, NULL, NULL, 'asheghan', 'iran-hormozgan-sirik-asheghan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(666, 18, 12, 46, 'كرتان', NULL, NULL, NULL, 'kertan', 'iran-hormozgan-sirik-kertan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(667, 18, 12, 46, 'كلمویی', NULL, NULL, NULL, 'kalmui', 'iran-hormozgan-sirik-kalmui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(668, 18, 12, 46, 'كهورچلان', NULL, NULL, NULL, 'kahurchalan', 'iran-hormozgan-sirik-kahurchalan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(669, 18, 12, 46, 'گاراندو', NULL, NULL, NULL, 'garandu', 'iran-hormozgan-sirik-garandu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(670, 18, 12, 46, 'گدو بالا', NULL, NULL, NULL, 'gedu-bala', 'iran-hormozgan-sirik-gedu-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(671, 18, 12, 46, 'گدو پایین', NULL, NULL, NULL, 'gedu-pain', 'iran-hormozgan-sirik-gedu-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(672, 18, 12, 46, 'گرائیك', NULL, NULL, NULL, 'garaik', 'iran-hormozgan-sirik-garaik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(673, 18, 12, 46, 'گز', NULL, NULL, NULL, 'gaz', 'iran-hormozgan-sirik-gaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(674, 18, 12, 46, 'گزپیر', NULL, NULL, NULL, 'gazpir', 'iran-hormozgan-sirik-gazpir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(675, 18, 12, 46, 'گزان بزین', NULL, NULL, NULL, 'gazan-bazin', 'iran-hormozgan-sirik-gazan-bazin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(676, 18, 12, 46, 'گناری', NULL, NULL, NULL, 'gonari', 'iran-hormozgan-sirik-gonari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(677, 18, 12, 46, 'گوجگ', NULL, NULL, NULL, 'gujag', 'iran-hormozgan-sirik-gujag', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(678, 18, 12, 46, 'گوشكی', NULL, NULL, NULL, 'goshki', 'iran-hormozgan-sirik-goshki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(679, 18, 12, 46, 'گونمردی', NULL, NULL, NULL, 'gonmardi', 'iran-hormozgan-sirik-gonmardi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(680, 18, 12, 46, 'مهرگی', NULL, NULL, NULL, 'mehrgi', 'iran-hormozgan-sirik-mehrgi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(681, 18, 12, 46, 'مستو', NULL, NULL, NULL, 'masto', 'iran-hormozgan-sirik-masto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(682, 18, 12, 46, 'مغ كنار', NULL, NULL, NULL, 'mogh-kenar', 'iran-hormozgan-sirik-mogh-kenar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(683, 18, 12, 46, 'مهمانی', NULL, NULL, NULL, 'mehmani', 'iran-hormozgan-sirik-mehmani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(684, 18, 12, 46, 'بصره', NULL, NULL, NULL, 'basreh', 'iran-hormozgan-sirik-basreh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(685, 18, 12, 46, 'پاراف بالا / فاریاب', NULL, NULL, NULL, 'paraf-bala-fariab', 'iran-hormozgan-sirik-paraf-bala-fariab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(686, 18, 12, 46, 'میاندر', NULL, NULL, NULL, 'meyandar', 'iran-hormozgan-sirik-meyandar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(687, 18, 12, 46, 'پشت بند', NULL, NULL, NULL, 'posht-band', 'iran-hormozgan-sirik-posht-band', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(688, 18, 12, 46, 'نوشهر سورگی', NULL, NULL, NULL, 'nowshahr-surgi', 'iran-hormozgan-sirik-nowshahr-surgi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(689, 18, 12, 46, 'سردرنگ', NULL, NULL, NULL, 'sardorong', 'iran-hormozgan-sirik-sardorong', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(690, 18, 12, 46, 'نوشهر', NULL, NULL, NULL, 'nowshahr', 'iran-hormozgan-sirik-nowshahr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:10:53', '2025-05-17 03:20:33', NULL),
(691, 18, 12, 46, 'بنداران', NULL, NULL, NULL, 'bandaran', 'iran-hormozgan-sirik-bandaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(692, 18, 12, 46, 'بند كرمان', NULL, NULL, NULL, 'band-kerman', 'iran-hormozgan-sirik-band-kerman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(693, 18, 12, 46, 'تومان راهی', NULL, NULL, NULL, 'tuman-rahi', 'iran-hormozgan-sirik-tuman-rahi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(694, 18, 12, 46, 'دوجمیلان', NULL, NULL, NULL, 'dujamilan', 'iran-hormozgan-sirik-dujamilan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(695, 18, 12, 46, 'زیارت بزرگ', NULL, NULL, NULL, 'ziarat-bozorg', 'iran-hormozgan-sirik-ziarat-bozorg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(696, 18, 12, 46, 'زیارت حسن آباد', NULL, NULL, NULL, 'ziarat-hasan-abad', 'iran-hormozgan-sirik-ziarat-hasan-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(697, 18, 12, 46, 'سرارو', NULL, NULL, NULL, 'sararu', 'iran-hormozgan-sirik-sararu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(698, 18, 12, 46, 'سرخور طاهرویی', NULL, NULL, NULL, 'sarkhur-taheroei', 'iran-hormozgan-sirik-sarkhur-taheroei', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(699, 18, 12, 46, 'طاهرویی', NULL, NULL, NULL, 'taheroei', 'iran-hormozgan-sirik-taheroei', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(700, 18, 12, 46, 'كناردان', NULL, NULL, NULL, 'kanardan', 'iran-hormozgan-sirik-kanardan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(701, 18, 12, 46, 'گندمی', NULL, NULL, NULL, 'gandomi', 'iran-hormozgan-sirik-gandomi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(702, 18, 12, 46, 'میشی', NULL, NULL, NULL, 'mishi', 'iran-hormozgan-sirik-mishi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(703, 18, 12, 46, 'همزانگ', NULL, NULL, NULL, 'hamzang', 'iran-hormozgan-sirik-hamzang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(704, 18, 12, 46, 'كردر', NULL, NULL, NULL, 'kerdar', 'iran-hormozgan-sirik-kerdar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(705, 18, 12, 46, 'كلنگی', NULL, NULL, NULL, 'kolangi', 'iran-hormozgan-sirik-kolangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(706, 18, 12, 46, 'سیریك كهنه', NULL, NULL, NULL, 'sirik-kohneh', 'iran-hormozgan-sirik-sirik-kohneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(707, 18, 12, 46, 'شمع جو', NULL, NULL, NULL, 'shamju', 'iran-hormozgan-sirik-shamju', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(708, 18, 12, 46, 'نوشهر كلنگی', NULL, NULL, NULL, 'nowshahr-kolangi', 'iran-hormozgan-sirik-nowshahr-kolangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(709, 18, 12, 46, 'نوشهر', NULL, NULL, NULL, 'nowshahr', 'iran-hormozgan-sirik-nowshahr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:11:48', '2025-05-17 03:20:33', NULL),
(710, 19, 10, 50, 'آب مصلی', NULL, NULL, NULL, 'ab-mosalla', 'iran-hormozgan-khamir-ab-mosalla', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(711, 19, 10, 50, 'بل دونو', NULL, NULL, NULL, 'bol-dono', 'iran-hormozgan-khamir-bol-dono', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(712, 19, 10, 50, 'بنفشه دان', NULL, NULL, NULL, 'banafsheh-dan', 'iran-hormozgan-khamir-banafsheh-dan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(713, 19, 10, 50, 'پركان آل موسی', NULL, NULL, NULL, 'parkan-al-mousa', 'iran-hormozgan-khamir-parkan-al-mousa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(714, 19, 10, 50, 'پركان گیشو', NULL, NULL, NULL, 'parkan-gishu', 'iran-hormozgan-khamir-parkan-gishu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL);
INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(715, 19, 10, 50, 'پسگدار آبشور', NULL, NULL, NULL, 'pasgadar-abshur', 'iran-hormozgan-khamir-pasgadar-abshur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(716, 19, 10, 50, 'چاهو', NULL, NULL, NULL, 'chahu', 'iran-hormozgan-khamir-chahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(717, 19, 10, 50, 'خرزانی', NULL, NULL, NULL, 'kharzani', 'iran-hormozgan-khamir-kharzani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(718, 19, 10, 50, 'رودبار', NULL, NULL, NULL, 'rudbar', 'iran-hormozgan-khamir-rudbar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(719, 19, 10, 50, 'گری گیش', NULL, NULL, NULL, 'gari-gish', 'iran-hormozgan-khamir-gari-gish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(720, 19, 10, 50, 'گری گردک', NULL, NULL, NULL, 'gari-gardak', 'iran-hormozgan-khamir-gari-gardak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(721, 19, 10, 50, 'گوین', NULL, NULL, NULL, 'gouin', 'iran-hormozgan-khamir-gouin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(722, 19, 10, 50, 'گیشو', NULL, NULL, NULL, 'gishu', 'iran-hormozgan-khamir-gishu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(723, 19, 10, 50, 'مرزاع', NULL, NULL, NULL, 'marzaa', 'iran-hormozgan-khamir-marzaa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(724, 19, 10, 50, 'كنار سبز', NULL, NULL, NULL, 'kenar-sabz', 'iran-hormozgan-khamir-kenar-sabz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(725, 19, 10, 50, 'نیكان', NULL, NULL, NULL, 'nikan', 'iran-hormozgan-khamir-nikan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(726, 19, 10, 50, 'تنگ اشكن', NULL, NULL, NULL, 'tang-ashkan', 'iran-hormozgan-khamir-tang-ashkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(727, 19, 10, 50, 'پرنیمه', NULL, NULL, NULL, 'parnimeh', 'iran-hormozgan-khamir-parnimeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:15:08', '2025-05-17 03:20:33', NULL),
(728, 19, 10, 50, 'بستو', NULL, NULL, NULL, 'basto', 'iran-hormozgan-khamir-basto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(729, 19, 10, 50, 'بنگرك', NULL, NULL, NULL, 'bangark', 'iran-hormozgan-khamir-bangark', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(730, 19, 10, 50, 'بنو', NULL, NULL, NULL, 'banu', 'iran-hormozgan-khamir-banu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(731, 19, 10, 50, 'پیامبران', NULL, NULL, NULL, 'payambaran', 'iran-hormozgan-khamir-payambaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(732, 19, 10, 50, 'تنگ گچ', NULL, NULL, NULL, 'tang-gach', 'iran-hormozgan-khamir-tang-gach', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(733, 19, 10, 50, 'چرمه', NULL, NULL, NULL, 'charme', 'iran-hormozgan-khamir-charme', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(734, 19, 10, 50, 'خادنو', NULL, NULL, NULL, 'khadno', 'iran-hormozgan-khamir-khadno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(735, 19, 10, 50, 'درواخانی', NULL, NULL, NULL, 'darvakhani', 'iran-hormozgan-khamir-darvakhani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(736, 19, 10, 50, 'كرمران', NULL, NULL, NULL, 'karmaran', 'iran-hormozgan-khamir-karmaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(737, 19, 10, 50, 'كنوئی', NULL, NULL, NULL, 'kanui', 'iran-hormozgan-khamir-kanui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(738, 19, 10, 50, 'گیشی', NULL, NULL, NULL, 'gishi', 'iran-hormozgan-khamir-gishi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(739, 19, 10, 50, 'تهران', NULL, NULL, NULL, 'tehran', 'iran-hormozgan-khamir-tehran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(740, 19, 10, 50, 'نودان', NULL, NULL, NULL, 'nudan', 'iran-hormozgan-khamir-nudan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(741, 19, 10, 50, 'هتران', NULL, NULL, NULL, 'hetran', 'iran-hormozgan-khamir-hetran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(742, 19, 10, 50, 'مزرعه عبداله آباد', NULL, NULL, NULL, 'mazraeh-abdollah-abad', 'iran-hormozgan-khamir-mazraeh-abdollah-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(743, 19, 10, 50, 'چحه', NULL, NULL, NULL, 'chehe', 'iran-hormozgan-khamir-chehe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(744, 19, 10, 50, 'كارگاه گچ رویدر', NULL, NULL, NULL, 'kargah-gach-ruyder', 'iran-hormozgan-khamir-kargah-gach-ruyder', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(745, 19, 10, 50, 'مزرعه روی كوه', NULL, NULL, NULL, 'mazraeh-ruy-kuh', 'iran-hormozgan-khamir-mazraeh-ruy-kuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(746, 19, 10, 50, 'محمد آباد', NULL, NULL, NULL, 'mohammad-abad', 'iran-hormozgan-khamir-mohammad-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(747, 19, 10, 50, 'پس بست', NULL, NULL, NULL, 'pas-bast', 'iran-hormozgan-khamir-pas-bast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(748, 19, 10, 50, 'گی شی بالا', NULL, NULL, NULL, 'gi-shi-bala', 'iran-hormozgan-khamir-gi-shi-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:02', '2025-05-17 03:20:33', NULL),
(749, 20, 10, 49, 'آل درویش', NULL, NULL, NULL, 'al-darvish', 'iran-hormozgan-khamir-al-darvish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(750, 20, 10, 49, 'باقی آباد', NULL, NULL, NULL, 'bagh-abad', 'iran-hormozgan-khamir-bagh-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(751, 20, 10, 49, 'پارو', NULL, NULL, NULL, 'paru', 'iran-hormozgan-khamir-paru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(752, 20, 10, 49, 'پاسگاه انتظامی منبع آب', NULL, NULL, NULL, 'police-station-water-source', 'iran-hormozgan-khamir-police-station-water-source', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(753, 20, 10, 49, 'پل گل كنی', NULL, NULL, NULL, 'pol-gol-kani', 'iran-hormozgan-khamir-pol-gol-kani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(754, 20, 10, 49, 'تنگ خیر', NULL, NULL, NULL, 'tang-kheir', 'iran-hormozgan-khamir-tang-kheir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(755, 20, 10, 49, 'چاه رو', NULL, NULL, NULL, 'chah-ru', 'iran-hormozgan-khamir-chah-ru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(756, 20, 10, 49, 'چاه صحاری', NULL, NULL, NULL, 'chah-sahari', 'iran-hormozgan-khamir-chah-sahari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(757, 20, 10, 49, 'خونو', NULL, NULL, NULL, 'khono', 'iran-hormozgan-khamir-khono', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(758, 20, 10, 49, 'درگور', NULL, NULL, NULL, 'dargur', 'iran-hormozgan-khamir-dargur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(759, 20, 10, 49, 'كارگاه گچ صدف خمیر', NULL, NULL, NULL, 'kargah-gach-sedaf-khamir', 'iran-hormozgan-khamir-kargah-gach-sedaf-khamir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(760, 20, 10, 49, 'كسه', NULL, NULL, NULL, 'kase', 'iran-hormozgan-khamir-kase', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(761, 20, 10, 49, 'گری شیخ', NULL, NULL, NULL, 'gari-sheikh', 'iran-hormozgan-khamir-gari-sheikh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(762, 20, 10, 49, 'معدن گچ خمیر', NULL, NULL, NULL, 'madan-gach-khamir', 'iran-hormozgan-khamir-madan-gach-khamir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(763, 20, 10, 49, 'موردو', NULL, NULL, NULL, 'murdu', 'iran-hormozgan-khamir-murdu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:16:49', '2025-05-17 03:20:33', NULL),
(764, 20, 10, 52, 'انگوران', NULL, NULL, NULL, 'anguran', 'iran-hormozgan-khamir-anguran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(765, 20, 10, 52, 'چاه گود چمردان', NULL, NULL, NULL, 'chah-gud-chamardan', 'iran-hormozgan-khamir-chah-gud-chamardan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(766, 20, 10, 52, 'کشار چمردان', NULL, NULL, NULL, 'kashar-chamardan', 'iran-hormozgan-khamir-kashar-chamardan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(767, 20, 10, 52, 'کشار دوستانی', NULL, NULL, NULL, 'kashar-dostani', 'iran-hormozgan-khamir-kashar-dostani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(768, 20, 10, 52, 'کشار زیر', NULL, NULL, NULL, 'kashar-zir', 'iran-hormozgan-khamir-kashar-zir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(769, 20, 10, 52, 'کشار سرگپ', NULL, NULL, NULL, 'kashar-sargap', 'iran-hormozgan-khamir-kashar-sargap', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(770, 20, 10, 52, 'تهلو', NULL, NULL, NULL, 'tahlo', 'iran-hormozgan-khamir-tahlo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(771, 20, 10, 52, 'شهر جدید علوی', NULL, NULL, NULL, 'shahr-jadid-alavi', 'iran-hormozgan-khamir-shahr-jadid-alavi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(772, 20, 10, 52, 'چاه لیمو', NULL, NULL, NULL, 'chah-limu', 'iran-hormozgan-khamir-chah-limu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:17:20', '2025-05-17 03:20:33', NULL),
(773, 21, 10, 53, 'برکه سلطان', NULL, NULL, NULL, 'berkah-sultan', 'iran-hormozgan-khamir-berkah-sultan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(774, 21, 10, 53, 'تقی خانی', NULL, NULL, NULL, 'taghi-khani', 'iran-hormozgan-khamir-taghi-khani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(775, 21, 10, 53, 'تهلاب', NULL, NULL, NULL, 'tahlab', 'iran-hormozgan-khamir-tahlab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(776, 21, 10, 53, 'تهرو', NULL, NULL, NULL, 'tahru', 'iran-hormozgan-khamir-tahru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(777, 21, 10, 53, 'دم تنگ سنگر', NULL, NULL, NULL, 'dam-tang-sangar', 'iran-hormozgan-khamir-dam-tang-sangar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(778, 21, 10, 53, 'قلعه پارو', NULL, NULL, NULL, 'ghaleh-paru', 'iran-hormozgan-khamir-ghaleh-paru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(779, 21, 10, 53, 'مغدان', NULL, NULL, NULL, 'moghadan', 'iran-hormozgan-khamir-moghadan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(780, 21, 10, 53, 'احمدآباد', NULL, NULL, NULL, 'ahmadabad', 'iran-hormozgan-khamir-ahmadabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(781, 21, 10, 53, 'دوکل پهن ( برکه نو )', NULL, NULL, NULL, 'dokol-pahn-berkah-no', 'iran-hormozgan-khamir-dokol-pahn-berkah-no', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(782, 21, 10, 53, 'چاه گلنی', NULL, NULL, NULL, 'chah-golani', 'iran-hormozgan-khamir-chah-golani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(783, 21, 10, 53, 'تنگ دالان', NULL, NULL, NULL, 'tang-dalan', 'iran-hormozgan-khamir-tang-dalan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(784, 21, 10, 53, 'جیحون', NULL, NULL, NULL, 'jeyhun', 'iran-hormozgan-khamir-jeyhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(785, 21, 10, 53, 'دشت جیحون', NULL, NULL, NULL, 'dasht-jeyhun', 'iran-hormozgan-khamir-dasht-jeyhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(786, 21, 10, 53, 'سرتنگ', NULL, NULL, NULL, 'sartang', 'iran-hormozgan-khamir-sartang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(787, 21, 10, 53, 'کافه نوراله عبداله زاده', NULL, NULL, NULL, 'cafe-nurollah-abdollahzadeh', 'iran-hormozgan-khamir-cafe-nurollah-abdollahzadeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(788, 21, 10, 53, 'پنارو', NULL, NULL, NULL, 'panaru', 'iran-hormozgan-khamir-panaru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(789, 21, 10, 53, 'چاه ماخور', NULL, NULL, NULL, 'chah-makhor', 'iran-hormozgan-khamir-chah-makhor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(790, 21, 10, 53, 'گچ', NULL, NULL, NULL, 'gach', 'iran-hormozgan-khamir-gach', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(791, 21, 10, 53, 'زیارت مرتضی علی', NULL, NULL, NULL, 'ziarat-morteza-ali', 'iran-hormozgan-khamir-ziarat-morteza-ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(792, 21, 10, 53, 'تنگ لنگر', NULL, NULL, NULL, 'tang-langar', 'iran-hormozgan-khamir-tang-langar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(793, 21, 10, 53, 'تنگه', NULL, NULL, NULL, 'tangeh', 'iran-hormozgan-khamir-tangeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(794, 21, 10, 53, 'کارگاه تولید بالاست', NULL, NULL, NULL, 'kargah-tolide-balast', 'iran-hormozgan-khamir-kargah-tolide-balast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(795, 21, 10, 53, 'کارگاه آسفالت', NULL, NULL, NULL, 'kargah-asfalt', 'iran-hormozgan-khamir-kargah-asfalt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(796, 21, 10, 53, 'مزرعه چاه شوردر گروان', NULL, NULL, NULL, 'mazraeh-chah-shur-dar-gorvan', 'iran-hormozgan-khamir-mazraeh-chah-shur-dar-gorvan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(797, 21, 10, 53, 'شینگو', NULL, NULL, NULL, 'shingu', 'iran-hormozgan-khamir-shingu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(798, 21, 10, 53, 'شیب روان', NULL, NULL, NULL, 'shib-ravan', 'iran-hormozgan-khamir-shib-ravan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:19:56', '2025-05-17 03:20:33', NULL),
(799, 21, 10, 55, 'ارابی', NULL, NULL, NULL, 'arabi', 'iran-hormozgan-khamir-arabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(800, 21, 10, 55, 'اشتابی', NULL, NULL, NULL, 'eshtabi', 'iran-hormozgan-khamir-eshtabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(801, 21, 10, 55, 'پی پر', NULL, NULL, NULL, 'pipar', 'iran-hormozgan-khamir-pipar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(802, 21, 10, 55, 'چوری', NULL, NULL, NULL, 'churi', 'iran-hormozgan-khamir-churi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(803, 21, 10, 55, 'دریخا', NULL, NULL, NULL, 'darikha', 'iran-hormozgan-khamir-darikha', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(804, 21, 10, 55, 'مارو', NULL, NULL, NULL, 'maru', 'iran-hormozgan-khamir-maru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(805, 21, 10, 55, 'نره', NULL, NULL, NULL, 'nareh', 'iran-hormozgan-khamir-nareh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-24 23:20:13', '2025-05-17 03:20:33', NULL),
(806, 22, 3, 57, 'باواردان', NULL, NULL, NULL, 'bavardan', 'iran-hormozgan-bandar-lengeh-bavardan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(807, 22, 3, 57, 'بهمنی', NULL, NULL, NULL, 'bahmani', 'iran-hormozgan-bandar-lengeh-bahmani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(808, 22, 3, 57, 'غدیر صابری', NULL, NULL, NULL, 'ghadir-saberi', 'iran-hormozgan-bandar-lengeh-ghadir-saberi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(809, 22, 3, 57, 'جاونی', NULL, NULL, NULL, 'javuni', 'iran-hormozgan-bandar-lengeh-javuni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(810, 22, 3, 57, 'جبری', NULL, NULL, NULL, 'jabari', 'iran-hormozgan-bandar-lengeh-jabari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(811, 22, 3, 57, 'دهنو مراغ', NULL, NULL, NULL, 'dehno-moragh', 'iran-hormozgan-bandar-lengeh-dehno-moragh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(812, 22, 3, 57, 'دهنو میر', NULL, NULL, NULL, 'dehno-mir', 'iran-hormozgan-bandar-lengeh-dehno-mir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(813, 22, 3, 57, 'رستمی', NULL, NULL, NULL, 'rostami', 'iran-hormozgan-bandar-lengeh-rostami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(814, 22, 3, 57, 'سه كنار علیا', NULL, NULL, NULL, 'seh-kanar-e-olia', 'iran-hormozgan-bandar-lengeh-seh-kanar-e-olia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(815, 22, 3, 57, 'بندر طاعونه', NULL, NULL, NULL, 'bandar-tauneh', 'iran-hormozgan-bandar-lengeh-bandar-tauneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(816, 22, 3, 57, 'كوغان', NULL, NULL, NULL, 'koughan', 'iran-hormozgan-bandar-lengeh-koughan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(817, 22, 3, 57, 'غدیر كوهی', NULL, NULL, NULL, 'ghadir-koohi', 'iran-hormozgan-bandar-lengeh-ghadir-koohi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(818, 22, 3, 57, 'گلشن', NULL, NULL, NULL, 'golshan', 'iran-hormozgan-bandar-lengeh-golshan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(819, 22, 3, 57, 'لعالمی', NULL, NULL, NULL, 'laalami', 'iran-hormozgan-bandar-lengeh-laalami', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(820, 22, 3, 57, 'مراغ', NULL, NULL, NULL, 'moragh', 'iran-hormozgan-bandar-lengeh-moragh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(821, 22, 3, 57, 'نخل میر', NULL, NULL, NULL, 'nakhl-e-mir', 'iran-hormozgan-bandar-lengeh-nakhl-e-mir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(822, 22, 3, 57, 'وادی آباد/ وادی عبد', NULL, NULL, NULL, 'vadi-abad', 'iran-hormozgan-bandar-lengeh-vadi-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(823, 22, 3, 57, 'وادی احمد', NULL, NULL, NULL, 'vadi-ahmad', 'iran-hormozgan-bandar-lengeh-vadi-ahmad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(824, 22, 3, 57, 'ایستگاه مخابرات چارك', NULL, NULL, NULL, 'telecom-station-charak', 'iran-hormozgan-bandar-lengeh-telecom-station-charak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(825, 22, 3, 57, 'كلات', NULL, NULL, NULL, 'kalat', 'iran-hormozgan-bandar-lengeh-kalat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(826, 22, 3, 57, 'گرزه', NULL, NULL, NULL, 'garze', 'iran-hormozgan-bandar-lengeh-garze', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:11', '2025-05-17 03:20:33', NULL),
(827, 22, 3, 58, 'الفدان', NULL, NULL, NULL, 'alfadan', 'iran-hormozgan-bandar-lengeh-alfadan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(828, 22, 3, 58, 'باغویه', NULL, NULL, NULL, 'baghuye', 'iran-hormozgan-bandar-lengeh-baghuye', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(829, 22, 3, 58, 'بندر جزه', NULL, NULL, NULL, 'bandar-jezzeh', 'iran-hormozgan-bandar-lengeh-bandar-jezzeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(830, 22, 3, 58, 'بندر مقام', NULL, NULL, NULL, 'bandar-mogham', 'iran-hormozgan-bandar-lengeh-bandar-mogham', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(831, 22, 3, 58, 'بندر میچائیل', NULL, NULL, NULL, 'bandar-michael', 'iran-hormozgan-bandar-lengeh-bandar-michael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(832, 22, 3, 58, 'بندر نخیلو', NULL, NULL, NULL, 'bandar-nakhilu', 'iran-hormozgan-bandar-lengeh-bandar-nakhilu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(833, 22, 3, 58, 'بوجبرائیل', NULL, NULL, NULL, 'bojabrail', 'iran-hormozgan-bandar-lengeh-bojabrail', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(834, 22, 3, 58, 'خرابه', NULL, NULL, NULL, 'kharabeh', 'iran-hormozgan-bandar-lengeh-kharabeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(835, 22, 3, 58, 'رمیله', NULL, NULL, NULL, 'ramileh', 'iran-hormozgan-bandar-lengeh-ramileh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(836, 22, 3, 58, 'شكروییه', NULL, NULL, NULL, 'shakruiyeh', 'iran-hormozgan-bandar-lengeh-shakruiyeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(837, 22, 3, 58, 'نخل جمال', NULL, NULL, NULL, 'nakhl-e-jamal', 'iran-hormozgan-bandar-lengeh-nakhl-e-jamal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(838, 22, 3, 58, 'بوالعسكر', NULL, NULL, NULL, 'boalaskar', 'iran-hormozgan-bandar-lengeh-boalaskar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(839, 22, 3, 58, 'رستاق', NULL, NULL, NULL, 'rastagh', 'iran-hormozgan-bandar-lengeh-rastagh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(840, 22, 3, 58, 'گریشه', NULL, NULL, NULL, 'garisheh', 'iran-hormozgan-bandar-lengeh-garisheh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(841, 22, 3, 58, 'گزدان', NULL, NULL, NULL, 'gazdan', 'iran-hormozgan-bandar-lengeh-gazdan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(842, 22, 3, 58, 'لشتانی', NULL, NULL, NULL, 'lashtani', 'iran-hormozgan-bandar-lengeh-lashtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(843, 22, 3, 58, 'مرباغ', NULL, NULL, NULL, 'morbagh', 'iran-hormozgan-bandar-lengeh-morbagh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(844, 22, 3, 58, 'ارمكی', NULL, NULL, NULL, 'armaki', 'iran-hormozgan-bandar-lengeh-armaki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(845, 22, 3, 58, 'بندر چیروئیه', NULL, NULL, NULL, 'bandar-chiruiyeh', 'iran-hormozgan-bandar-lengeh-bandar-chiruiyeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(846, 22, 3, 58, 'بوجراش', NULL, NULL, NULL, 'bojarrash', 'iran-hormozgan-bandar-lengeh-bojarrash', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(847, 22, 3, 58, 'بوطیور', NULL, NULL, NULL, 'bootiyur', 'iran-hormozgan-bandar-lengeh-bootiyur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(848, 22, 3, 58, 'خلفانی', NULL, NULL, NULL, 'khalfani', 'iran-hormozgan-bandar-lengeh-khalfani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(849, 22, 3, 58, 'نخل غدیر', NULL, NULL, NULL, 'nakhl-e-ghadir', 'iran-hormozgan-bandar-lengeh-nakhl-e-ghadir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(850, 22, 3, 58, 'سایت پرورش میگوی مقام', NULL, NULL, NULL, 'mogham-shrimp-farm', 'iran-hormozgan-bandar-lengeh-mogham-shrimp-farm', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:24', '2025-05-17 03:20:33', NULL),
(851, 23, 3, 59, 'هندو رابی', NULL, NULL, NULL, 'hindu-rabi', 'iran-hormozgan-bandar-lengeh-hindu-rabi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:38', '2025-05-17 03:20:33', NULL),
(852, 23, 3, 60, 'ده ریز لاوان', NULL, NULL, NULL, 'deh-riz-lavan', 'iran-hormozgan-bandar-lengeh-deh-riz-lavan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(853, 23, 3, 60, 'دهكرت لاوان', NULL, NULL, NULL, 'dehkert-lavan', 'iran-hormozgan-bandar-lengeh-dehkert-lavan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(854, 23, 3, 60, 'كرت لاوان', NULL, NULL, NULL, 'kert-lavan', 'iran-hormozgan-bandar-lengeh-kert-lavan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(855, 23, 3, 60, 'لز', NULL, NULL, NULL, 'laz', 'iran-hormozgan-bandar-lengeh-laz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(856, 23, 3, 60, 'لازه', NULL, NULL, NULL, 'lazeh', 'iran-hormozgan-bandar-lengeh-lazeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(857, 23, 3, 60, 'تاسیسات نفتی', NULL, NULL, NULL, 'oil-installations', 'iran-hormozgan-bandar-lengeh-oil-installations', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(858, 23, 3, 60, 'جزیره شتوار', NULL, NULL, NULL, 'shetvar-island', 'iran-hormozgan-bandar-lengeh-shetvar-island', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(859, 23, 3, 60, 'كوسه', NULL, NULL, NULL, 'kuseh', 'iran-hormozgan-bandar-lengeh-kuseh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(860, 23, 3, 60, 'هله', NULL, NULL, NULL, 'halleh', 'iran-hormozgan-bandar-lengeh-halleh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:40:48', '2025-05-17 03:20:33', NULL),
(861, 24, 3, 62, 'بارچاه', NULL, NULL, NULL, 'barchah', 'iran-hormozgan-bandar-lengeh-barchah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(862, 24, 3, 62, 'باورد', NULL, NULL, NULL, 'bavard', 'iran-hormozgan-bandar-lengeh-bavard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(863, 24, 3, 62, 'بردغون', NULL, NULL, NULL, 'bardghun', 'iran-hormozgan-bandar-lengeh-bardghun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(864, 24, 3, 62, 'بركه سفلین', NULL, NULL, NULL, 'berkeh-sofla', 'iran-hormozgan-bandar-lengeh-berkeh-sofla', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(865, 24, 3, 62, 'بندر بندمعلم', NULL, NULL, NULL, 'bandar-bandamolam', 'iran-hormozgan-bandar-lengeh-bandar-bandamolam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(866, 24, 3, 62, 'پیروز', NULL, NULL, NULL, 'piruz', 'iran-hormozgan-bandar-lengeh-piruz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(867, 24, 3, 62, 'چاه عبدالرحمان', NULL, NULL, NULL, 'chah-abdolrahman', 'iran-hormozgan-bandar-lengeh-chah-abdolrahman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(868, 24, 3, 62, 'چاه كوهی', NULL, NULL, NULL, 'chah-koohi', 'iran-hormozgan-bandar-lengeh-chah-koohi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(869, 24, 3, 62, 'چاه كهنه', NULL, NULL, NULL, 'chah-kohneh', 'iran-hormozgan-bandar-lengeh-chah-kohneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(870, 24, 3, 62, 'چركیات', NULL, NULL, NULL, 'charkiyat', 'iran-hormozgan-bandar-lengeh-charkiyat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(871, 24, 3, 62, 'چمپه', NULL, NULL, NULL, 'champeh', 'iran-hormozgan-bandar-lengeh-champeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(872, 24, 3, 62, 'حشم حودو', NULL, NULL, NULL, 'heshme-hudu', 'iran-hormozgan-bandar-lengeh-heshme-hudu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(873, 24, 3, 62, 'حمیران', NULL, NULL, NULL, 'hamiran', 'iran-hormozgan-bandar-lengeh-hamiran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(874, 24, 3, 62, 'زیارت', NULL, NULL, NULL, 'ziarat', 'iran-hormozgan-bandar-lengeh-ziarat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(875, 24, 3, 62, 'شهرك امام خمینی', NULL, NULL, NULL, 'shahrak-emam-khomeini', 'iran-hormozgan-bandar-lengeh-shahrak-emam-khomeini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(876, 24, 3, 62, 'كوهی', NULL, NULL, NULL, 'koohi', 'iran-hormozgan-bandar-lengeh-koohi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(877, 24, 3, 62, 'گارستانه', NULL, NULL, NULL, 'garostaneh', 'iran-hormozgan-bandar-lengeh-garostaneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(878, 24, 3, 62, 'مهرگان بالا', NULL, NULL, NULL, 'mehregan-bala', 'iran-hormozgan-bandar-lengeh-mehregan-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(879, 24, 3, 62, 'بریسیمو', NULL, NULL, NULL, 'berisimo', 'iran-hormozgan-bandar-lengeh-berisimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(880, 24, 3, 62, 'پارو', NULL, NULL, NULL, 'paru', 'iran-hormozgan-bandar-lengeh-paru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(881, 24, 3, 62, 'مزرعه لاورگل', NULL, NULL, NULL, 'mazraeh-lavargol', 'iran-hormozgan-bandar-lengeh-mazraeh-lavargol', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(882, 24, 3, 62, 'برست', NULL, NULL, NULL, 'berast', 'iran-hormozgan-bandar-lengeh-berast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(883, 24, 3, 62, 'حشم چمپه', NULL, NULL, NULL, 'heshme-champeh', 'iran-hormozgan-bandar-lengeh-heshme-champeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(884, 24, 3, 62, 'گزیر', NULL, NULL, NULL, 'gazir', 'iran-hormozgan-bandar-lengeh-gazir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:02', '2025-05-17 03:20:33', NULL),
(885, 24, 3, NULL, 'بندر شناس', NULL, NULL, NULL, 'bandar-shenas', 'iran-hormozgan-bandar-lengeh-bandar-shenas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(886, 24, 3, NULL, 'بندر ملو', NULL, NULL, NULL, 'bandar-malu', 'iran-hormozgan-bandar-lengeh-bandar-malu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(887, 24, 3, NULL, 'خورملو', NULL, NULL, NULL, 'khormalu', 'iran-hormozgan-bandar-lengeh-khormalu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(888, 24, 3, NULL, 'فرودگاه بندرلنگه', NULL, NULL, NULL, 'bandar-lengeh-airport', 'iran-hormozgan-bandar-lengeh-bandar-lengeh-airport', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(889, 24, 3, NULL, 'ارمك', NULL, NULL, NULL, 'armak', 'iran-hormozgan-bandar-lengeh-armak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(890, 24, 3, NULL, 'چاه درویش', NULL, NULL, NULL, 'chah-darvish', 'iran-hormozgan-bandar-lengeh-chah-darvish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(891, 24, 3, NULL, 'حسینه', NULL, NULL, NULL, 'hosseinieh', 'iran-hormozgan-bandar-lengeh-hosseinieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(892, 24, 3, NULL, 'سورو', NULL, NULL, NULL, 'suru', 'iran-hormozgan-bandar-lengeh-suru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(893, 24, 3, NULL, 'كافرغان', NULL, NULL, NULL, 'kafarghan', 'iran-hormozgan-bandar-lengeh-kafarghan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(894, 24, 3, NULL, 'كندران', NULL, NULL, NULL, 'kandaran', 'iran-hormozgan-bandar-lengeh-kandaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(895, 24, 3, NULL, 'گلنگو', NULL, NULL, NULL, 'golangu', 'iran-hormozgan-bandar-lengeh-golangu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(896, 24, 3, NULL, 'لاوران', NULL, NULL, NULL, 'lavaran', 'iran-hormozgan-bandar-lengeh-lavaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(897, 24, 3, NULL, 'مغویه', NULL, NULL, NULL, 'moghuieh', 'iran-hormozgan-bandar-lengeh-moghuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(898, 24, 3, NULL, 'هیروند', NULL, NULL, NULL, 'hirund', 'iran-hormozgan-bandar-lengeh-hirund', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(899, 24, 3, NULL, 'شربتی', NULL, NULL, NULL, 'sharbati', 'iran-hormozgan-bandar-lengeh-sharbati', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(900, 24, 3, NULL, 'نخل یوسف', NULL, NULL, NULL, 'nakhl-e-yusef', 'iran-hormozgan-bandar-lengeh-nakhl-e-yusef', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(901, 24, 3, NULL, 'هتل ساحلی صدف', NULL, NULL, NULL, 'sadaf-beach-hotel', 'iran-hormozgan-bandar-lengeh-sadaf-beach-hotel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(902, 24, 3, NULL, 'سایت پرورش میگوی حسینه', NULL, NULL, NULL, 'hosseinieh-shrimp-farm', 'iran-hormozgan-bandar-lengeh-hosseinieh-shrimp-farm', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(903, 24, 3, NULL, 'بستانه', NULL, NULL, NULL, 'bastaneh', 'iran-hormozgan-bandar-lengeh-bastaneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(904, 24, 3, NULL, 'چاه مسلم', NULL, NULL, NULL, 'chah-moslem', 'iran-hormozgan-bandar-lengeh-chah-moslem', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(905, 24, 3, NULL, 'دیوان', NULL, NULL, NULL, 'divan', 'iran-hormozgan-bandar-lengeh-divan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:41:14', '2025-05-17 03:20:33', NULL),
(906, 25, 3, 63, 'اسلام آباد', NULL, NULL, NULL, 'islam-abad', 'iran-hormozgan-bandar-lengeh-islam-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(907, 25, 3, 63, 'كم رضوان', NULL, NULL, NULL, 'kam-rezvan', 'iran-hormozgan-bandar-lengeh-kam-rezvan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(908, 25, 3, 63, 'كوه بدو', NULL, NULL, NULL, 'kuh-badu', 'iran-hormozgan-bandar-lengeh-kuh-badu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(909, 25, 3, 63, 'نورآباد', NULL, NULL, NULL, 'nurabad', 'iran-hormozgan-bandar-lengeh-nurabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(910, 25, 3, 63, 'انجیره', NULL, NULL, NULL, 'anjireh', 'iran-hormozgan-bandar-lengeh-anjireh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(911, 25, 3, 63, 'بن كوه', NULL, NULL, NULL, 'bon-kuh', 'iran-hormozgan-bandar-lengeh-bon-kuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(912, 25, 3, 63, 'پدل', NULL, NULL, NULL, 'padal', 'iran-hormozgan-bandar-lengeh-padal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(913, 25, 3, 63, 'پس بست', NULL, NULL, NULL, 'pas-bast', 'iran-hormozgan-bandar-lengeh-pas-bast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(914, 25, 3, 63, 'چاه خودرو', NULL, NULL, NULL, 'chah-khodro', 'iran-hormozgan-bandar-lengeh-chah-khodro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(915, 25, 3, 63, 'خورچاه', NULL, NULL, NULL, 'khoorchah', 'iran-hormozgan-bandar-lengeh-khoorchah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(916, 25, 3, 63, 'دم هرا', NULL, NULL, NULL, 'dam-hara', 'iran-hormozgan-bandar-lengeh-dam-hara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(917, 25, 3, 63, 'كوردان', NULL, NULL, NULL, 'kordan', 'iran-hormozgan-bandar-lengeh-kordan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(918, 25, 3, 63, 'كونه', NULL, NULL, NULL, 'kuneh', 'iran-hormozgan-bandar-lengeh-kuneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(919, 25, 3, 63, 'گرسور', NULL, NULL, NULL, 'garsur', 'iran-hormozgan-bandar-lengeh-garsur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(920, 25, 3, 63, 'لاور كرچی', NULL, NULL, NULL, 'lavar-karchi', 'iran-hormozgan-bandar-lengeh-lavar-karchi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(921, 25, 3, 63, 'ناهنگ', NULL, NULL, NULL, 'nahang', 'iran-hormozgan-bandar-lengeh-nahang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(922, 25, 3, 63, 'هم هنگ', NULL, NULL, NULL, 'ham-hang', 'iran-hormozgan-bandar-lengeh-ham-hang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(923, 25, 3, 63, 'هرا', NULL, NULL, NULL, 'hara', 'iran-hormozgan-bandar-lengeh-hara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(924, 25, 3, 63, 'حارسین', NULL, NULL, NULL, 'haresin', 'iran-hormozgan-bandar-lengeh-haresin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(925, 25, 3, 63, 'دم طلا', NULL, NULL, NULL, 'dam-tala', 'iran-hormozgan-bandar-lengeh-dam-tala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(926, 25, 3, 63, 'پس بند', NULL, NULL, NULL, 'pas-band', 'iran-hormozgan-bandar-lengeh-pas-band', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(927, 25, 3, 63, 'چاه هندران', NULL, NULL, NULL, 'chah-hendaran', 'iran-hormozgan-bandar-lengeh-chah-hendaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(928, 25, 3, 63, 'هسته كوه', NULL, NULL, NULL, 'haste-kuh', 'iran-hormozgan-bandar-lengeh-haste-kuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(929, 25, 3, 63, 'بشتین', NULL, NULL, NULL, 'bashtin', 'iran-hormozgan-bandar-lengeh-bashtin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(930, 25, 3, 63, 'هیرو', NULL, NULL, NULL, 'hiru', 'iran-hormozgan-bandar-lengeh-hiru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(931, 25, 3, 63, 'نی منو', NULL, NULL, NULL, 'ni-manu', 'iran-hormozgan-bandar-lengeh-ni-manu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(932, 25, 3, 63, 'جوانی', NULL, NULL, NULL, 'javani', 'iran-hormozgan-bandar-lengeh-javani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:42:14', '2025-05-17 03:20:33', NULL),
(933, 25, 3, NULL, 'چاه احمد', NULL, NULL, NULL, 'chah-ahmad', 'iran-hormozgan-bandar-lengeh-chah-ahmad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(934, 25, 3, NULL, 'چاه دراز', NULL, NULL, NULL, 'chah-deraz', 'iran-hormozgan-bandar-lengeh-chah-deraz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(935, 25, 3, NULL, 'چنگ', NULL, NULL, NULL, 'chang', 'iran-hormozgan-bandar-lengeh-chang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(936, 25, 3, NULL, 'دواب', NULL, NULL, NULL, 'davab', 'iran-hormozgan-bandar-lengeh-davab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(937, 25, 3, NULL, 'سایه خوش', NULL, NULL, NULL, 'saye-khosh', 'iran-hormozgan-bandar-lengeh-saye-khosh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(938, 25, 3, NULL, 'سیاتك', NULL, NULL, NULL, 'siyatak', 'iran-hormozgan-bandar-lengeh-siyatak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(939, 25, 3, NULL, 'كنخ', NULL, NULL, NULL, 'konakh', 'iran-hormozgan-bandar-lengeh-konakh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(940, 25, 3, NULL, 'گنایی', NULL, NULL, NULL, 'ganai', 'iran-hormozgan-bandar-lengeh-ganai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(941, 25, 3, NULL, 'گاومیری', NULL, NULL, NULL, 'gavmiri', 'iran-hormozgan-bandar-lengeh-gavmiri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(942, 25, 3, NULL, 'كلاتو', NULL, NULL, NULL, 'kalatu', 'iran-hormozgan-bandar-lengeh-kalatu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(943, 25, 3, NULL, 'تنب سیك', NULL, NULL, NULL, 'tomb-sik', 'iran-hormozgan-bandar-lengeh-tomb-sik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(944, 25, 3, NULL, 'كنار تنكو/ قنات تنگو', NULL, NULL, NULL, 'kenar-tangu', 'iran-hormozgan-bandar-lengeh-kenar-tangu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(945, 25, 3, NULL, 'پیشه گون', NULL, NULL, NULL, 'pisheh-gun', 'iran-hormozgan-bandar-lengeh-pisheh-gun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(946, 25, 3, NULL, 'حنادان', NULL, NULL, NULL, 'hanadan', 'iran-hormozgan-bandar-lengeh-hanadan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(947, 25, 3, NULL, 'كوشك', NULL, NULL, NULL, 'kushk', 'iran-hormozgan-bandar-lengeh-kushk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(948, 25, 3, NULL, 'گواه كوه', NULL, NULL, NULL, 'gavah-kuh', 'iran-hormozgan-bandar-lengeh-gavah-kuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(949, 25, 3, NULL, 'سنگ سیاه', NULL, NULL, NULL, 'sang-siah', 'iran-hormozgan-bandar-lengeh-sang-siah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(950, 25, 3, NULL, 'كنار بلند', NULL, NULL, NULL, 'kenar-boland', 'iran-hormozgan-bandar-lengeh-kenar-boland', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(951, 25, 3, NULL, 'چاه دیگی', NULL, NULL, NULL, 'chah-digi', 'iran-hormozgan-bandar-lengeh-chah-digi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(952, 25, 3, NULL, 'كن گاهی', NULL, NULL, NULL, 'kan-gahi', 'iran-hormozgan-bandar-lengeh-kan-gahi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(953, 25, 3, NULL, 'خومكو', NULL, NULL, NULL, 'khumku', 'iran-hormozgan-bandar-lengeh-khumku', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(954, 25, 3, NULL, 'كنارگتو', NULL, NULL, NULL, 'kenar-gatu', 'iran-hormozgan-bandar-lengeh-kenar-gatu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(955, 25, 3, NULL, 'حسن آباد', NULL, NULL, NULL, 'hasan-abad', 'iran-hormozgan-bandar-lengeh-hasan-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(956, 25, 3, NULL, 'تنب جكی', NULL, NULL, NULL, 'tomb-jaki', 'iran-hormozgan-bandar-lengeh-tomb-jaki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(957, 25, 3, NULL, 'نرمستان', NULL, NULL, NULL, 'narmestan', 'iran-hormozgan-bandar-lengeh-narmestan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(958, 25, 3, NULL, 'تنب بنگرو', NULL, NULL, NULL, 'tomb-bangru', 'iran-hormozgan-bandar-lengeh-tomb-bangru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(959, 25, 3, NULL, 'سایت پرورش میگوی سایه خوش', NULL, NULL, NULL, 'saye-khosh-shrimp-farm', 'iran-hormozgan-bandar-lengeh-saye-khosh-shrimp-farm', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL);
INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(960, 25, 3, NULL, 'کرچی', NULL, NULL, NULL, 'karchi', 'iran-hormozgan-bandar-lengeh-karchi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(961, 25, 3, NULL, 'دژگان', NULL, NULL, NULL, 'dezhgan', 'iran-hormozgan-bandar-lengeh-dezhgan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 08:44:19', '2025-05-17 03:20:33', NULL),
(962, 26, 6, 65, 'باغان', NULL, NULL, NULL, 'baghan', 'iran-hormozgan-jask-baghan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(963, 26, 6, 65, 'بهمدی', NULL, NULL, NULL, 'bahmadi', 'iran-hormozgan-jask-bahmadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(964, 26, 6, 65, 'خوش گیزو', NULL, NULL, NULL, 'khosh-gizu', 'iran-hormozgan-jask-khosh-gizu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(965, 26, 6, 65, 'ریگ', NULL, NULL, NULL, 'rig', 'iran-hormozgan-jask-rig', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(966, 26, 6, 65, 'ریگو', NULL, NULL, NULL, 'rigu', 'iran-hormozgan-jask-rigu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(967, 26, 6, 65, 'سول', NULL, NULL, NULL, 'sul', 'iran-hormozgan-jask-sul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(968, 26, 6, 65, 'بحل', NULL, NULL, NULL, 'bahl', 'iran-hormozgan-jask-bahl', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(969, 26, 6, 65, 'جاسک کهنه', NULL, NULL, NULL, 'jask-e-kohneh', 'iran-hormozgan-jask-jask-e-kohneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(970, 26, 6, 65, 'زمین لشکری', NULL, NULL, NULL, 'zamin-e-lashkari', 'iran-hormozgan-jask-zamin-e-lashkari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(971, 26, 6, 65, 'کویک', NULL, NULL, NULL, 'kuyik', 'iran-hormozgan-jask-kuyik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(972, 26, 6, 65, 'کهوتی', NULL, NULL, NULL, 'kahuti', 'iran-hormozgan-jask-kahuti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(973, 26, 6, 65, 'گزدان', NULL, NULL, NULL, 'gazdan', 'iran-hormozgan-jask-gazdan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(974, 26, 6, 65, 'گیگن', NULL, NULL, NULL, 'gigan', 'iran-hormozgan-jask-gigan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(975, 26, 6, 65, 'لافیک', NULL, NULL, NULL, 'lafik', 'iran-hormozgan-jask-lafik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(976, 26, 6, 65, 'نگر پایین', NULL, NULL, NULL, 'nagar-e-pa\'in', 'iran-hormozgan-jask-nagar-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(977, 26, 6, 65, 'نگر بالا', NULL, NULL, NULL, 'nagar-e-bala', 'iran-hormozgan-jask-nagar-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(978, 26, 6, 65, 'تل', NULL, NULL, NULL, 'tal', 'iran-hormozgan-jask-tal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(979, 26, 6, 65, 'سران بارشکو', NULL, NULL, NULL, 'saran-e-bareshku', 'iran-hormozgan-jask-saran-e-bareshku', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(980, 26, 6, 65, 'خیرآباد', NULL, NULL, NULL, 'kheirabad', 'iran-hormozgan-jask-kheirabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(981, 26, 6, 65, 'کویک بالا', NULL, NULL, NULL, 'kuyik-e-bala', 'iran-hormozgan-jask-kuyik-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(982, 26, 6, 65, 'کلمبری', NULL, NULL, NULL, 'kalambari', 'iran-hormozgan-jask-kalambari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(983, 26, 6, 65, 'زوادو', NULL, NULL, NULL, 'zavadu', 'iran-hormozgan-jask-zavadu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(984, 26, 6, 65, 'بارشکان', NULL, NULL, NULL, 'bareshkan', 'iran-hormozgan-jask-bareshkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(985, 26, 6, 65, 'سران', NULL, NULL, NULL, 'saran', 'iran-hormozgan-jask-saran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:11', '2025-05-17 03:20:33', NULL),
(986, 26, 6, 66, 'بونچی کرباسی', NULL, NULL, NULL, 'bunchi-karbasi', 'iran-hormozgan-jask-bunchi-karbasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(987, 26, 6, 66, 'پا زرد', NULL, NULL, NULL, 'pa-zard', 'iran-hormozgan-jask-pa-zard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(988, 26, 6, 66, 'رابک', NULL, NULL, NULL, 'rabak', 'iran-hormozgan-jask-rabak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(989, 26, 6, 66, 'زهرکی', NULL, NULL, NULL, 'zahraki', 'iran-hormozgan-jask-zahraki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(990, 26, 6, 66, 'زیرکوه', NULL, NULL, NULL, 'zirkuh', 'iran-hormozgan-jask-zirkuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(991, 26, 6, 66, 'سرخ کوه', NULL, NULL, NULL, 'sorkh-kuh', 'iran-hormozgan-jask-sorkh-kuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(992, 26, 6, 66, 'سهران', NULL, NULL, NULL, 'sahran', 'iran-hormozgan-jask-sahran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(993, 26, 6, 66, 'شیرآهن شهر', NULL, NULL, NULL, 'shir-ahan-shahr', 'iran-hormozgan-jask-shir-ahan-shahr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(994, 26, 6, 66, 'شیرآهن', NULL, NULL, NULL, 'shir-ahan', 'iran-hormozgan-jask-shir-ahan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(995, 26, 6, 66, 'مغ قنبره کوه مبارک', NULL, NULL, NULL, 'magh-ghanbareh-kuh-e-mobarak', 'iran-hormozgan-jask-magh-ghanbareh-kuh-e-mobarak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(996, 26, 6, 66, 'گاوبندی', NULL, NULL, NULL, 'gavbandi', 'iran-hormozgan-jask-gavbandi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(997, 26, 6, 66, 'گروک پائین', NULL, NULL, NULL, 'guruk-e-pa\'in', 'iran-hormozgan-jask-guruk-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(998, 26, 6, 66, 'گروک بالا', NULL, NULL, NULL, 'guruk-e-bala', 'iran-hormozgan-jask-guruk-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(999, 26, 6, 66, 'گنگان', NULL, NULL, NULL, 'gangan', 'iran-hormozgan-jask-gangan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1000, 26, 6, 66, 'بونجی ساحلی لاتیدان', NULL, NULL, NULL, 'bunji-sahli-latidan', 'iran-hormozgan-jask-bunji-sahli-latidan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1001, 26, 6, 66, 'بونجی مسکی', NULL, NULL, NULL, 'bunji-maski', 'iran-hormozgan-jask-bunji-maski', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1002, 26, 6, 66, 'آغوشک دل', NULL, NULL, NULL, 'aghushak-del', 'iran-hormozgan-jask-aghushak-del', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1003, 26, 6, 66, 'آغوشک کش', NULL, NULL, NULL, 'aghushak-kesh', 'iran-hormozgan-jask-aghushak-kesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1004, 26, 6, 66, 'آغوشک خشک کاری', NULL, NULL, NULL, 'aghushak-khoshk-kari', 'iran-hormozgan-jask-aghushak-khoshk-kari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1005, 26, 6, 66, 'شمبیران', NULL, NULL, NULL, 'shambiran', 'iran-hormozgan-jask-shambiran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1006, 26, 6, 66, 'گتان سفلی', NULL, NULL, NULL, 'gatan-e-sofla', 'iran-hormozgan-jask-gatan-e-sofla', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1007, 26, 6, 66, 'گتان علیا', NULL, NULL, NULL, 'gatan-e-olia', 'iran-hormozgan-jask-gatan-e-olia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1008, 26, 6, 66, 'گزی', NULL, NULL, NULL, 'gazi', 'iran-hormozgan-jask-gazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1009, 26, 6, 66, 'گوان', NULL, NULL, NULL, 'gavan', 'iran-hormozgan-jask-gavan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1010, 26, 6, 66, 'مچی', NULL, NULL, NULL, 'machi', 'iran-hormozgan-jask-machi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1011, 26, 6, 66, 'مغ جنگان', NULL, NULL, NULL, 'magh-jangan', 'iran-hormozgan-jask-magh-jangan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1012, 26, 6, 66, 'مغ رحمت', NULL, NULL, NULL, 'magh-rahemat', 'iran-hormozgan-jask-magh-rahemat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1013, 26, 6, 66, 'تم باسیون کوه مبارک', NULL, NULL, NULL, 'tam-basion-kuh-e-mobarak', 'iran-hormozgan-jask-tam-basion-kuh-e-mobarak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1014, 26, 6, 66, 'سنگاری مچ/ سنگری مچ', NULL, NULL, NULL, 'sangari-mach', 'iran-hormozgan-jask-sangari-mach', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1015, 26, 6, 66, 'شهرک مطهر', NULL, NULL, NULL, 'shahrak-e-motahhar', 'iran-hormozgan-jask-shahrak-e-motahhar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:21:23', '2025-05-17 03:20:33', NULL),
(1016, 26, 6, 67, 'واعظ قبر', NULL, NULL, NULL, 'vaez-ghabr', 'iran-hormozgan-jask-vaez-ghabr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1017, 26, 6, 67, 'هوشدان', NULL, NULL, NULL, 'hushdan', 'iran-hormozgan-jask-hushdan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1018, 26, 6, 67, 'تار', NULL, NULL, NULL, 'tar', 'iran-hormozgan-jask-tar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1019, 26, 6, 67, 'تیتکن', NULL, NULL, NULL, 'titkan', 'iran-hormozgan-jask-titkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1020, 26, 6, 67, 'جگین', NULL, NULL, NULL, 'jagin', 'iran-hormozgan-jask-jagin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1021, 26, 6, 67, 'جگین بالا', NULL, NULL, NULL, 'jagin-e-bala', 'iran-hormozgan-jask-jagin-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1022, 26, 6, 67, 'حصار', NULL, NULL, NULL, 'hesar', 'iran-hormozgan-jask-hesar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1023, 26, 6, 67, 'دسکی', NULL, NULL, NULL, 'daski', 'iran-hormozgan-jask-daski', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1024, 26, 6, 67, 'دیزو', NULL, NULL, NULL, 'dizu', 'iran-hormozgan-jask-dizu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1025, 26, 6, 67, 'سرتیتکن', NULL, NULL, NULL, 'sar-titkan', 'iran-hormozgan-jask-sar-titkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1026, 26, 6, 67, 'سورگلم', NULL, NULL, NULL, 'surgalam', 'iran-hormozgan-jask-surgalam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1027, 26, 6, 67, 'شهرنی', NULL, NULL, NULL, 'shahrni', 'iran-hormozgan-jask-shahrni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1028, 26, 6, 67, 'طوطی کش', NULL, NULL, NULL, 'tuti-kesh', 'iran-hormozgan-jask-tuti-kesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1029, 26, 6, 67, 'کالری', NULL, NULL, NULL, 'kalari', 'iran-hormozgan-jask-kalari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1030, 26, 6, 67, 'کرگی', NULL, NULL, NULL, 'kargi', 'iran-hormozgan-jask-kargi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1031, 26, 6, 67, 'کلوان بالا', NULL, NULL, NULL, 'kalvan-e-bala', 'iran-hormozgan-jask-kalvan-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1032, 26, 6, 67, 'کلوان پائین', NULL, NULL, NULL, 'kalvan-e-pa\'in', 'iran-hormozgan-jask-kalvan-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1033, 26, 6, 67, 'کیایی', NULL, NULL, NULL, 'kiai', 'iran-hormozgan-jask-kiai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1034, 26, 6, 67, 'یکدار', NULL, NULL, NULL, 'yekdar', 'iran-hormozgan-jask-yekdar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1035, 26, 6, 67, 'بندبست', NULL, NULL, NULL, 'bandbast', 'iran-hormozgan-jask-bandbast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1036, 26, 6, 67, 'پرکوه', NULL, NULL, NULL, 'parkuh', 'iran-hormozgan-jask-parkuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1037, 26, 6, 67, 'زیروکی', NULL, NULL, NULL, 'ziruki', 'iran-hormozgan-jask-ziruki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1038, 26, 6, 67, 'کروچ', NULL, NULL, NULL, 'kuroch', 'iran-hormozgan-jask-kuroch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1039, 26, 6, 67, 'کنتاکی/ کنتگی', NULL, NULL, NULL, 'kentaki', 'iran-hormozgan-jask-kentaki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1040, 26, 6, 67, 'گرندو', NULL, NULL, NULL, 'gerando', 'iran-hormozgan-jask-gerando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1041, 26, 6, 67, 'گنجک', NULL, NULL, NULL, 'ganjak', 'iran-hormozgan-jask-ganjak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1042, 26, 6, 67, 'لیره ای', NULL, NULL, NULL, 'lirei', 'iran-hormozgan-jask-lirei', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1043, 26, 6, 67, 'مشنو', NULL, NULL, NULL, 'mishnu', 'iran-hormozgan-jask-mishnu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1044, 26, 6, 67, 'نوروزکار', NULL, NULL, NULL, 'noruzkar', 'iran-hormozgan-jask-noruzkar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1045, 26, 6, 67, 'هون', NULL, NULL, NULL, 'hun', 'iran-hormozgan-jask-hun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1046, 26, 6, 67, 'هی من', NULL, NULL, NULL, 'hi-man', 'iran-hormozgan-jask-hi-man', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1047, 26, 6, 67, 'هنگستان', NULL, NULL, NULL, 'hengstan', 'iran-hormozgan-jask-hengstan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1048, 26, 6, 67, 'توجائی', NULL, NULL, NULL, 'tuja\'i', 'iran-hormozgan-jask-tuja\'i', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1049, 26, 6, 67, 'اسپیتل', NULL, NULL, NULL, 'espitel', 'iran-hormozgan-jask-espitel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1050, 26, 6, 67, 'دیول', NULL, NULL, NULL, 'diyul', 'iran-hormozgan-jask-diyul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1051, 26, 6, 67, 'سیرمچ', NULL, NULL, NULL, 'sirmach', 'iran-hormozgan-jask-sirmach', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1052, 26, 6, 67, 'گبد', NULL, NULL, NULL, 'gobad', 'iran-hormozgan-jask-gobad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1053, 26, 6, 67, 'شهرک محمد آباد', NULL, NULL, NULL, 'shahrak-e-mohammad-abad', 'iran-hormozgan-jask-shahrak-e-mohammad-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1054, 26, 6, 67, 'حاجی آباد', NULL, NULL, NULL, 'haji-abad', 'iran-hormozgan-jask-haji-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1055, 26, 6, 67, 'زبر', NULL, NULL, NULL, 'zabr', 'iran-hormozgan-jask-zabr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1056, 26, 6, 67, 'حسین آباد', NULL, NULL, NULL, 'hossein-abad', 'iran-hormozgan-jask-hossein-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1057, 26, 6, 67, 'پیشانی کنده', NULL, NULL, NULL, 'pishani-kandeh', 'iran-hormozgan-jask-pishani-kandeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1058, 26, 6, 67, 'ککی', NULL, NULL, NULL, 'kaki', 'iran-hormozgan-jask-kaki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1059, 26, 6, 67, 'جهلا', NULL, NULL, NULL, 'jahla', 'iran-hormozgan-jask-jahla', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1060, 26, 6, 67, 'کرگوه', NULL, NULL, NULL, 'karguh', 'iran-hormozgan-jask-karguh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1061, 26, 6, 67, 'شهرک علی آباد', NULL, NULL, NULL, 'shahrak-e-ali-abad', 'iran-hormozgan-jask-shahrak-e-ali-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1062, 26, 6, 67, 'شهرک گابریک', NULL, NULL, NULL, 'shahrak-e-gabrik', 'iran-hormozgan-jask-shahrak-e-gabrik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1063, 26, 6, 67, 'چراغ آباد', NULL, NULL, NULL, 'cheragh-abad', 'iran-hormozgan-jask-cheragh-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1064, 26, 6, 67, 'سایت پرورش میگوی یکدار', NULL, NULL, NULL, 'yekdar-shrimp-farm', 'iran-hormozgan-jask-yekdar-shrimp-farm', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1065, 26, 6, 67, 'پرکوه پایین', NULL, NULL, NULL, 'parkuh-e-pa\'in', 'iran-hormozgan-jask-parkuh-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1066, 26, 6, 67, 'داروبست ( هوت آباد )', NULL, NULL, NULL, 'darubast', 'iran-hormozgan-jask-darubast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1067, 26, 6, 67, 'نزکی', NULL, NULL, NULL, 'nezki', 'iran-hormozgan-jask-nezki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1068, 26, 6, 67, 'تراتکان', NULL, NULL, NULL, 'taratakan', 'iran-hormozgan-jask-taratakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:23', '2025-05-17 03:20:33', NULL),
(1069, 27, 6, 69, 'براگ', NULL, NULL, NULL, 'brag', 'iran-hormozgan-jask-brag', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1070, 27, 6, 69, 'آبکوهی', NULL, NULL, NULL, 'abkuhi', 'iran-hormozgan-jask-abkuhi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1071, 27, 6, 69, 'بیاهی', NULL, NULL, NULL, 'beyahi', 'iran-hormozgan-jask-beyahi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1072, 27, 6, 69, 'پی وشک', NULL, NULL, NULL, 'piveshk', 'iran-hormozgan-jask-piveshk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1073, 27, 6, 69, 'توگنجک', NULL, NULL, NULL, 'tuganjak', 'iran-hormozgan-jask-tuganjak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1074, 27, 6, 69, 'جهلو', NULL, NULL, NULL, 'jahlu', 'iran-hormozgan-jask-jahlu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1075, 27, 6, 69, 'ریگ', NULL, NULL, NULL, 'rig', 'iran-hormozgan-jask-rig', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1076, 27, 6, 69, 'کرتی', NULL, NULL, NULL, 'karti', 'iran-hormozgan-jask-karti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1077, 27, 6, 69, 'کلیرک', NULL, NULL, NULL, 'kalirak', 'iran-hormozgan-jask-kalirak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1078, 27, 6, 69, 'کیدر پایین', NULL, NULL, NULL, 'kaydar-e-pa\'in', 'iran-hormozgan-jask-kaydar-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1079, 27, 6, 69, 'گتی', NULL, NULL, NULL, 'gati', 'iran-hormozgan-jask-gati', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1080, 27, 6, 69, 'مشکوهی', NULL, NULL, NULL, 'mashkuhi', 'iran-hormozgan-jask-mashkuhi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1081, 27, 6, 69, 'طلادر نخلستان', NULL, NULL, NULL, 'taladar-nakhlistan', 'iran-hormozgan-jask-taladar-nakhlistan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1082, 27, 6, 69, 'ونک', NULL, NULL, NULL, 'vank', 'iran-hormozgan-jask-vank', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1083, 27, 6, 69, 'پترکی', NULL, NULL, NULL, 'patraki', 'iran-hormozgan-jask-patraki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1084, 27, 6, 69, 'تراتکان', NULL, NULL, NULL, 'taratakan', 'iran-hormozgan-jask-taratakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1085, 27, 6, 69, 'جمعه ای', NULL, NULL, NULL, 'jom\'ei', 'iran-hormozgan-jask-jom\'ei', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1086, 27, 6, 69, 'جهل درک', NULL, NULL, NULL, 'jahl-darak', 'iran-hormozgan-jask-jahl-darak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1087, 27, 6, 69, 'زهری کار', NULL, NULL, NULL, 'zahri-kar', 'iran-hormozgan-jask-zahri-kar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1088, 27, 6, 69, 'سهرکی', NULL, NULL, NULL, 'sahraki', 'iran-hormozgan-jask-sahraki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1089, 27, 6, 69, 'کربلا', NULL, NULL, NULL, 'karbala', 'iran-hormozgan-jask-karbala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1090, 27, 6, 69, 'گرمی پایین', NULL, NULL, NULL, 'garmi-e-pa\'in', 'iran-hormozgan-jask-garmi-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1091, 27, 6, 69, 'کوتک', NULL, NULL, NULL, 'kutak', 'iran-hormozgan-jask-kutak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1092, 27, 6, 69, 'نگر شرق', NULL, NULL, NULL, 'nagar-e-sharq', 'iran-hormozgan-jask-nagar-e-sharq', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1093, 27, 6, 69, 'چی درکی', NULL, NULL, NULL, 'chi-daraki', 'iran-hormozgan-jask-chi-daraki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1094, 27, 6, 69, 'صلاهو', NULL, NULL, NULL, 'salahu', 'iran-hormozgan-jask-salahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1095, 27, 6, 69, 'پچک', NULL, NULL, NULL, 'pachak', 'iran-hormozgan-jask-pachak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1096, 27, 6, 69, 'گنجک', NULL, NULL, NULL, 'ganjak', 'iran-hormozgan-jask-ganjak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1097, 27, 6, 69, 'تنگ درهمان', NULL, NULL, NULL, 'tang-e-darhaman', 'iran-hormozgan-jask-tang-e-darhaman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1098, 27, 6, 69, 'لیرک', NULL, NULL, NULL, 'lirak', 'iran-hormozgan-jask-lirak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1099, 27, 6, 69, 'کاشی', NULL, NULL, NULL, 'kashi', 'iran-hormozgan-jask-kashi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1100, 27, 6, 69, 'کیدر بالا', NULL, NULL, NULL, 'kaydar-e-bala', 'iran-hormozgan-jask-kaydar-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1101, 27, 6, 69, 'کنارو', NULL, NULL, NULL, 'kanaru', 'iran-hormozgan-jask-kanaru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1102, 27, 6, 69, 'کرمی بالا', NULL, NULL, NULL, 'karami-e-bala', 'iran-hormozgan-jask-karami-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1103, 27, 6, 69, 'کشمیر', NULL, NULL, NULL, 'kashmir', 'iran-hormozgan-jask-kashmir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1104, 27, 6, 69, 'شیهولی', NULL, NULL, NULL, 'shayhuli', 'iran-hormozgan-jask-shayhuli', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1105, 27, 6, 69, 'کمبکی', NULL, NULL, NULL, 'kambaki', 'iran-hormozgan-jask-kambaki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1106, 27, 6, 69, 'رنز', NULL, NULL, NULL, 'ranz', 'iran-hormozgan-jask-ranz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1107, 27, 6, 69, 'آگی بند بست', NULL, NULL, NULL, 'agi-band-bast', 'iran-hormozgan-jask-agi-band-bast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1108, 27, 6, 69, 'تلک', NULL, NULL, NULL, 'talk', 'iran-hormozgan-jask-talk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 09:22:41', '2025-05-17 03:20:33', NULL),
(1109, 27, 6, 70, 'سدیچ', NULL, NULL, NULL, 'sadich', 'iran-hormozgan-jask-sadich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1110, 27, 6, 70, 'سورچاه پایین', NULL, NULL, NULL, 'surchah-e-pa\'in', 'iran-hormozgan-jask-surchah-e-pa\'in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1111, 27, 6, 70, 'شمشی', NULL, NULL, NULL, 'shamshi', 'iran-hormozgan-jask-shamshi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1112, 27, 6, 70, 'عبد', NULL, NULL, NULL, 'abd', 'iran-hormozgan-jask-abd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1113, 27, 6, 70, 'گپسر', NULL, NULL, NULL, 'gapsar', 'iran-hormozgan-jask-gapsar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1114, 27, 6, 70, 'گوهرت', NULL, NULL, NULL, 'gohart', 'iran-hormozgan-jask-gohart', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1115, 27, 6, 70, 'زیگدف', NULL, NULL, NULL, 'zigdaf', 'iran-hormozgan-jask-zigdaf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1116, 27, 6, 70, 'محمدآباد', NULL, NULL, NULL, 'mohammad-abad', 'iran-hormozgan-jask-mohammad-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1117, 27, 6, 70, 'میرن گوری', NULL, NULL, NULL, 'miran-guri', 'iran-hormozgan-jask-miran-guri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1118, 27, 6, 70, 'گندک سر', NULL, NULL, NULL, 'gandak-sar', 'iran-hormozgan-jask-gandak-sar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1119, 27, 6, 70, 'ملوکی', NULL, NULL, NULL, 'maluki', 'iran-hormozgan-jask-maluki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1120, 27, 6, 70, 'مچگی', NULL, NULL, NULL, 'machgi', 'iran-hormozgan-jask-machgi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1121, 27, 6, 70, 'گچی', NULL, NULL, NULL, 'gachi', 'iran-hormozgan-jask-gachi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1122, 27, 6, 70, 'دسکی', NULL, NULL, NULL, 'daski', 'iran-hormozgan-jask-daski', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1123, 27, 6, 70, 'شهری', NULL, NULL, NULL, 'shahri', 'iran-hormozgan-jask-shahri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1124, 27, 6, 70, 'آلائی', NULL, NULL, NULL, 'alai', 'iran-hormozgan-jask-alai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1125, 27, 6, 70, 'سهتو', NULL, NULL, NULL, 'sehtu', 'iran-hormozgan-jask-sehtu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1126, 27, 6, 70, 'پنسون', NULL, NULL, NULL, 'panson', 'iran-hormozgan-jask-panson', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1127, 27, 6, 70, 'بوته ای', NULL, NULL, NULL, 'buteh-i', 'iran-hormozgan-jask-buteh-i', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1128, 27, 6, 70, 'توجیدر', NULL, NULL, NULL, 'tujidar', 'iran-hormozgan-jask-tujidar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1129, 27, 6, 70, 'جانوری', NULL, NULL, NULL, 'janvari', 'iran-hormozgan-jask-janvari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1130, 27, 6, 70, 'جریت', NULL, NULL, NULL, 'jarit', 'iran-hormozgan-jask-jarit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1131, 27, 6, 70, 'زهی', NULL, NULL, NULL, 'zahi', 'iran-hormozgan-jask-zahi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1132, 27, 6, 70, 'شادین زهی', NULL, NULL, NULL, 'shadin-zahi', 'iran-hormozgan-jask-shadin-zahi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1133, 27, 6, 70, 'کمشنگر', NULL, NULL, NULL, 'kamshangar', 'iran-hormozgan-jask-kamshangar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1134, 27, 6, 70, 'گوربوجا', NULL, NULL, NULL, 'gorboja', 'iran-hormozgan-jask-gorboja', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1135, 27, 6, 70, 'چنالی بالا', NULL, NULL, NULL, 'chenali-e-bala', 'iran-hormozgan-jask-chenali-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1136, 27, 6, 70, 'خیرآباد', NULL, NULL, NULL, 'kheirabad', 'iran-hormozgan-jask-kheirabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1137, 27, 6, 70, 'سورچاه بالا', NULL, NULL, NULL, 'surchah-e-bala', 'iran-hormozgan-jask-surchah-e-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1138, 27, 6, 70, 'شم سیاهان', NULL, NULL, NULL, 'sham-siah-an', 'iran-hormozgan-jask-sham-siah-an', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1139, 27, 6, 70, 'گشمی', NULL, NULL, NULL, 'gashmi', 'iran-hormozgan-jask-gashmi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1140, 27, 6, 70, 'کلوکای', NULL, NULL, NULL, 'kalukai', 'iran-hormozgan-jask-kalukai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1141, 27, 6, 70, 'چنالی', NULL, NULL, NULL, 'chenali', 'iran-hormozgan-jask-chenali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1142, 27, 6, 70, 'بریدی', NULL, NULL, NULL, 'baridi', 'iran-hormozgan-jask-baridi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1143, 27, 6, 70, 'چریدف', NULL, NULL, NULL, 'charidaf', 'iran-hormozgan-jask-charidaf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1144, 27, 6, 70, 'گری برد', NULL, NULL, NULL, 'gari-bard', 'iran-hormozgan-jask-gari-bard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1145, 27, 6, 70, 'مگا', NULL, NULL, NULL, 'mega', 'iran-hormozgan-jask-mega', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1146, 27, 6, 70, 'تنگ دف', NULL, NULL, NULL, 'tang-daf', 'iran-hormozgan-jask-tang-daf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1147, 27, 6, 70, 'بونوک', NULL, NULL, NULL, 'bonuk', 'iran-hormozgan-jask-bonuk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1148, 27, 6, 70, 'عزت آباد', NULL, NULL, NULL, 'ezzat-abad', 'iran-hormozgan-jask-ezzat-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1149, 27, 6, 70, 'میسکنک', NULL, NULL, NULL, 'miskank', 'iran-hormozgan-jask-miskank', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1150, 27, 6, 70, 'باسیدی', NULL, NULL, NULL, 'basidi', 'iran-hormozgan-jask-basidi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1151, 27, 6, 70, 'بارگی زهی', NULL, NULL, NULL, 'bargi-zahi', 'iran-hormozgan-jask-bargi-zahi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1152, 27, 6, 70, 'چنالی', NULL, NULL, NULL, 'chenali', 'iran-hormozgan-jask-chenali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1153, 27, 6, 70, 'گورسر', NULL, NULL, NULL, 'gorsar', 'iran-hormozgan-jask-gorsar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:00:39', '2025-05-17 03:20:33', NULL),
(1154, 28, 13, 73, 'امیگی ( چوخون )', NULL, NULL, NULL, 'amigi-chokhun', 'iran-hormozgan-bashagard-amigi-chokhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1155, 28, 13, 73, 'آهون', NULL, NULL, NULL, 'ahun', 'iran-hormozgan-bashagard-ahun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1156, 28, 13, 73, 'برآهنگ', NULL, NULL, NULL, 'barahang', 'iran-hormozgan-bashagard-barahang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1157, 28, 13, 73, 'بستگان', NULL, NULL, NULL, 'bastegan', 'iran-hormozgan-bashagard-bastegan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1158, 28, 13, 73, 'بلبل آباد', NULL, NULL, NULL, 'bolbol-abad', 'iran-hormozgan-bashagard-bolbol-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1159, 28, 13, 73, 'سربندپرانگی', NULL, NULL, NULL, 'sarband-parangi', 'iran-hormozgan-bashagard-sarband-parangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1160, 28, 13, 73, 'پیس كن', NULL, NULL, NULL, 'pis-kan', 'iran-hormozgan-bashagard-pis-kan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1161, 28, 13, 73, 'تیراحمد', NULL, NULL, NULL, 'tir-ahmad', 'iran-hormozgan-bashagard-tir-ahmad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1162, 28, 13, 73, 'جكدان پیرو', NULL, NULL, NULL, 'jakdan-piru', 'iran-hormozgan-bashagard-jakdan-piru', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1163, 28, 13, 73, 'داربست', NULL, NULL, NULL, 'darbast', 'iran-hormozgan-bashagard-darbast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1164, 28, 13, 73, 'دازكان', NULL, NULL, NULL, 'dazkan', 'iran-hormozgan-bashagard-dazkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1165, 28, 13, 73, 'درالوی', NULL, NULL, NULL, 'daralavi', 'iran-hormozgan-bashagard-daralavi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1166, 28, 13, 73, 'درجك', NULL, NULL, NULL, 'darjak', 'iran-hormozgan-bashagard-darjak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1167, 28, 13, 73, 'درگ زمین', NULL, NULL, NULL, 'darg-zamin', 'iran-hormozgan-bashagard-darg-zamin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1168, 28, 13, 73, 'شه بابک', NULL, NULL, NULL, 'shah-babak', 'iran-hormozgan-bashagard-shah-babak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1169, 28, 13, 73, 'دستگرد', NULL, NULL, NULL, 'dastgerd', 'iran-hormozgan-bashagard-dastgerd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1170, 28, 13, 73, 'دهنه سهراب/ دهن سراب', NULL, NULL, NULL, 'dehneh-sohrab', 'iran-hormozgan-bashagard-dehneh-sohrab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1171, 28, 13, 73, 'دهیر', NULL, NULL, NULL, 'dehir', 'iran-hormozgan-bashagard-dehir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1172, 28, 13, 73, 'زه بدی', NULL, NULL, NULL, 'zeh-badi', 'iran-hormozgan-bashagard-zeh-badi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1173, 28, 13, 73, 'سرگروخ بلبلی', NULL, NULL, NULL, 'sargorukh-bolboli', 'iran-hormozgan-bashagard-sargorukh-bolboli', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1174, 28, 13, 73, 'شون', NULL, NULL, NULL, 'shun', 'iran-hormozgan-bashagard-shun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1175, 28, 13, 73, 'كمدارك', NULL, NULL, NULL, 'kamdark', 'iran-hormozgan-bashagard-kamdark', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1176, 28, 13, 73, 'كش بوندن', NULL, NULL, NULL, 'kash-bundan', 'iran-hormozgan-bashagard-kash-bundan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1177, 28, 13, 73, 'كش میگی', NULL, NULL, NULL, 'kash-migi', 'iran-hormozgan-bashagard-kash-migi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1178, 28, 13, 73, 'كنورعمری', NULL, NULL, NULL, 'kanvar-omari', 'iran-hormozgan-bashagard-kanvar-omari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1179, 28, 13, 73, 'كوه حیدر', NULL, NULL, NULL, 'kuh-heydar', 'iran-hormozgan-bashagard-kuh-heydar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1180, 28, 13, 73, 'گوریچی', NULL, NULL, NULL, 'gurichi', 'iran-hormozgan-bashagard-gurichi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1181, 28, 13, 73, 'مرانگ', NULL, NULL, NULL, 'marang', 'iran-hormozgan-bashagard-marang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1182, 28, 13, 73, 'وی', NULL, NULL, NULL, 'vi', 'iran-hormozgan-bashagard-vi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1183, 28, 13, 73, 'سیت', NULL, NULL, NULL, 'sit', 'iran-hormozgan-bashagard-sit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1184, 28, 13, 73, 'دره مورت', NULL, NULL, NULL, 'dareh-murt', 'iran-hormozgan-bashagard-dareh-murt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1185, 28, 13, 73, 'جكدان/ كلوجكدان', NULL, NULL, NULL, 'jakdan-kolujakdan', 'iran-hormozgan-bashagard-jakdan-kolujakdan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1186, 28, 13, 73, 'گوجک محمودی', NULL, NULL, NULL, 'gujak-mahmudi', 'iran-hormozgan-bashagard-gujak-mahmudi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1187, 28, 13, 73, 'گروغ', NULL, NULL, NULL, 'gurugh', 'iran-hormozgan-bashagard-gurugh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1188, 28, 13, 73, 'فراهك', NULL, NULL, NULL, 'farahak', 'iran-hormozgan-bashagard-farahak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1189, 28, 13, 73, 'زاچ داربست', NULL, NULL, NULL, 'zach-darbast', 'iran-hormozgan-bashagard-zach-darbast', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1190, 28, 13, 73, 'بن گرخ', NULL, NULL, NULL, 'bon-garkh', 'iran-hormozgan-bashagard-bon-garkh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1191, 28, 13, 73, 'دهندر شه بابك', NULL, NULL, NULL, 'dehandar-shah-babak', 'iran-hormozgan-bashagard-dehandar-shah-babak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1192, 28, 13, 73, 'زحك بالا', NULL, NULL, NULL, 'zehak-bala', 'iran-hormozgan-bashagard-zehak-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1193, 28, 13, 73, 'زحك پایین', NULL, NULL, NULL, 'zehak-pain', 'iran-hormozgan-bashagard-zehak-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1194, 28, 13, 73, 'پرانگی', NULL, NULL, NULL, 'parangi', 'iran-hormozgan-bashagard-parangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1195, 28, 13, 73, 'علی آباد', NULL, NULL, NULL, 'ali-abad', 'iran-hormozgan-bashagard-ali-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1196, 28, 13, 73, 'كمبو', NULL, NULL, NULL, 'kambu', 'iran-hormozgan-bashagard-kambu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1197, 28, 13, 73, 'زرآباد', NULL, NULL, NULL, 'zarabad', 'iran-hormozgan-bashagard-zarabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1198, 28, 13, 73, 'شهرک مطهر', NULL, NULL, NULL, 'shahrak-e-motahar', 'iran-hormozgan-bashagard-shahrak-e-motahar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1199, 28, 13, 73, 'ده پشت بیر', NULL, NULL, NULL, 'deh-posht-bir', 'iran-hormozgan-bashagard-deh-posht-bir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:35', '2025-05-17 03:20:33', NULL),
(1200, 28, 13, 72, 'بابك', NULL, NULL, NULL, 'babak', 'iran-hormozgan-bashagard-babak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1201, 28, 13, 72, 'بارشكان', NULL, NULL, NULL, 'bareshkan', 'iran-hormozgan-bashagard-bareshkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1202, 28, 13, 72, 'بیسكاو', NULL, NULL, NULL, 'biskav', 'iran-hormozgan-bashagard-biskav', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1203, 28, 13, 72, 'پشت گرشه بابك', NULL, NULL, NULL, 'posht-garsheh-babak', 'iran-hormozgan-bashagard-posht-garsheh-babak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1204, 28, 13, 72, 'درنه', NULL, NULL, NULL, 'darneh', 'iran-hormozgan-bashagard-darneh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1205, 28, 13, 72, 'زمین عباسو', NULL, NULL, NULL, 'zamin-abbasu', 'iran-hormozgan-bashagard-zamin-abbasu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1206, 28, 13, 72, 'سربیر', NULL, NULL, NULL, 'sarbir', 'iran-hormozgan-bashagard-sarbir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1207, 28, 13, 72, 'سگن', NULL, NULL, NULL, 'sagan', 'iran-hormozgan-bashagard-sagan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1208, 28, 13, 72, 'كماف', NULL, NULL, NULL, 'kamaf', 'iran-hormozgan-bashagard-kamaf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1209, 28, 13, 72, 'كولق', NULL, NULL, NULL, 'kulagh', 'iran-hormozgan-bashagard-kulagh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1210, 28, 13, 72, 'گجك اسپیر', NULL, NULL, NULL, 'gajak-asir', 'iran-hormozgan-bashagard-gajak-asir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1211, 28, 13, 72, 'گشهرو', NULL, NULL, NULL, 'gasharu', 'iran-hormozgan-bashagard-gasharu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1212, 28, 13, 72, 'ملكن', NULL, NULL, NULL, 'malakan', 'iran-hormozgan-bashagard-malakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1213, 28, 13, 72, 'درمعی', NULL, NULL, NULL, 'darmai', 'iran-hormozgan-bashagard-darmai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL);
INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1214, 28, 13, 72, 'كش تخت', NULL, NULL, NULL, 'kash-takht', 'iran-hormozgan-bashagard-kash-takht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1215, 28, 13, 72, 'رستم آباد دهوست', NULL, NULL, NULL, 'rostam-abad-dehust', 'iran-hormozgan-bashagard-rostam-abad-dehust', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1216, 28, 13, 72, 'محمودآباد', NULL, NULL, NULL, 'mahmud-abad', 'iran-hormozgan-bashagard-mahmud-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:11:47', '2025-05-17 03:20:33', NULL),
(1217, 29, 13, 74, 'اشكان', NULL, NULL, NULL, 'ashkan', 'iran-hormozgan-bashagard-ashkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1218, 29, 13, 74, 'انار شیرین', NULL, NULL, NULL, 'anar-shirin', 'iran-hormozgan-bashagard-anar-shirin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1219, 29, 13, 74, 'اوهكن', NULL, NULL, NULL, 'avehkan', 'iran-hormozgan-bashagard-avehkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1220, 29, 13, 74, 'پابنی', NULL, NULL, NULL, 'pabani', 'iran-hormozgan-bashagard-pabani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1221, 29, 13, 74, 'بشنو', NULL, NULL, NULL, 'bashnu', 'iran-hormozgan-bashagard-bashnu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1222, 29, 13, 74, 'بن اشك', NULL, NULL, NULL, 'bon-ashk', 'iran-hormozgan-bashagard-bon-ashk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1223, 29, 13, 74, 'بن نر', NULL, NULL, NULL, 'bon-nar', 'iran-hormozgan-bashagard-bon-nar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1224, 29, 13, 74, 'تیدر', NULL, NULL, NULL, 'tider', 'iran-hormozgan-bashagard-tider', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1225, 29, 13, 74, 'تریش', NULL, NULL, NULL, 'tarish', 'iran-hormozgan-bashagard-tarish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1226, 29, 13, 74, 'تیشن', NULL, NULL, NULL, 'tishan', 'iran-hormozgan-bashagard-tishan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1227, 29, 13, 74, 'خومن', NULL, NULL, NULL, 'khoman', 'iran-hormozgan-bashagard-khoman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1228, 29, 13, 74, 'درگازپلكی', NULL, NULL, NULL, 'dargaz-pelaki', 'iran-hormozgan-bashagard-dargaz-pelaki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1229, 29, 13, 74, 'دورمیش', NULL, NULL, NULL, 'durmesh', 'iran-hormozgan-bashagard-durmesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1230, 29, 13, 74, 'سرملا', NULL, NULL, NULL, 'sarmala', 'iran-hormozgan-bashagard-sarmala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1231, 29, 13, 74, 'سرهور', NULL, NULL, NULL, 'sarhur', 'iran-hormozgan-bashagard-sarhur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1232, 29, 13, 74, 'شهر شیب كلاه', NULL, NULL, NULL, 'shahr-shib-kolah', 'iran-hormozgan-bashagard-shahr-shib-kolah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1233, 29, 13, 74, 'كتوهنگ', NULL, NULL, NULL, 'katuhang', 'iran-hormozgan-bashagard-katuhang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1234, 29, 13, 74, 'كلاهو', NULL, NULL, NULL, 'kolahu', 'iran-hormozgan-bashagard-kolahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1235, 29, 13, 74, 'كهناب بالا', NULL, NULL, NULL, 'kohnab-bala', 'iran-hormozgan-bashagard-kohnab-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1236, 29, 13, 74, 'كهناب پائین', NULL, NULL, NULL, 'kohnab-pain', 'iran-hormozgan-bashagard-kohnab-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1237, 29, 13, 74, 'كیرشك', NULL, NULL, NULL, 'kirishk', 'iran-hormozgan-bashagard-kirishk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1238, 29, 13, 74, 'گارامان/ گارامون', NULL, NULL, NULL, 'garaman', 'iran-hormozgan-bashagard-garaman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1239, 29, 13, 74, 'گارانی', NULL, NULL, NULL, 'garani', 'iran-hormozgan-bashagard-garani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1240, 29, 13, 74, 'گوروی', NULL, NULL, NULL, 'gorvi', 'iran-hormozgan-bashagard-gorvi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1241, 29, 13, 74, 'گیمچ', NULL, NULL, NULL, 'gimach', 'iran-hormozgan-bashagard-gimach', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1242, 29, 13, 74, 'ناشكی', NULL, NULL, NULL, 'nashki', 'iran-hormozgan-bashagard-nashki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1243, 29, 13, 74, 'وائن', NULL, NULL, NULL, 'vaen', 'iran-hormozgan-bashagard-vaen', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1244, 29, 13, 74, 'ورونچ', NULL, NULL, NULL, 'varunch', 'iran-hormozgan-bashagard-varunch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1245, 29, 13, 74, 'بیورچ', NULL, NULL, NULL, 'bivarch', 'iran-hormozgan-bashagard-bivarch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1246, 29, 13, 74, 'درشهر', NULL, NULL, NULL, 'darshahr', 'iran-hormozgan-bashagard-darshahr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1247, 29, 13, 74, 'دستگرد درگاز', NULL, NULL, NULL, 'dastgerd-dargaz', 'iran-hormozgan-bashagard-dastgerd-dargaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1248, 29, 13, 74, 'كسیسه ای', NULL, NULL, NULL, 'kasisai', 'iran-hormozgan-bashagard-kasisai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1249, 29, 13, 74, 'پاهتك', NULL, NULL, NULL, 'pahtak', 'iran-hormozgan-bashagard-pahtak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1250, 29, 13, 74, 'رنین كوچك', NULL, NULL, NULL, 'ranin-kuchek', 'iran-hormozgan-bashagard-ranin-kuchek', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1251, 29, 13, 74, 'رنین بزرگ', NULL, NULL, NULL, 'ranin-bozorg', 'iran-hormozgan-bashagard-ranin-bozorg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1252, 29, 13, 74, 'درگوئن', NULL, NULL, NULL, 'darguen', 'iran-hormozgan-bashagard-darguen', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1253, 29, 13, 74, 'شهر شیب', NULL, NULL, NULL, 'shahr-shib', 'iran-hormozgan-bashagard-shahr-shib', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1254, 29, 13, 74, 'شه وروخ', NULL, NULL, NULL, 'shah-varukh', 'iran-hormozgan-bashagard-shah-varukh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1255, 29, 13, 74, 'كوه سفید', NULL, NULL, NULL, 'kuh-sefid', 'iran-hormozgan-bashagard-kuh-sefid', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1256, 29, 13, 74, 'گارگنجی', NULL, NULL, NULL, 'gargangi', 'iran-hormozgan-bashagard-gargangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1257, 29, 13, 74, 'اپا', NULL, NULL, NULL, 'apa', 'iran-hormozgan-bashagard-apa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1258, 29, 13, 74, 'امام آباد', NULL, NULL, NULL, 'emam-abad', 'iran-hormozgan-bashagard-emam-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1259, 29, 13, 74, 'بینك علیا', NULL, NULL, NULL, 'binek-olia', 'iran-hormozgan-bashagard-binek-olia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1260, 29, 13, 74, 'بند بارك', NULL, NULL, NULL, 'band-barak', 'iran-hormozgan-bashagard-band-barak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1261, 29, 13, 74, 'گلشهر', NULL, NULL, NULL, 'golshahr', 'iran-hormozgan-bashagard-golshahr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1262, 29, 13, 74, 'جنگل تیراحمد', NULL, NULL, NULL, 'jangal-tir-ahmad', 'iran-hormozgan-bashagard-jangal-tir-ahmad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1263, 29, 13, 74, 'تجك', NULL, NULL, NULL, 'tajak', 'iran-hormozgan-bashagard-tajak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1264, 29, 13, 74, 'عزت آباد/ دلكی', NULL, NULL, NULL, 'ezzat-abad-dalki', 'iran-hormozgan-bashagard-ezzat-abad-dalki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1265, 29, 13, 74, 'دشت صحرا', NULL, NULL, NULL, 'dasht-sahra', 'iran-hormozgan-bashagard-dasht-sahra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:30', '2025-05-17 03:20:33', NULL),
(1266, 29, 13, 75, 'ایرمیش', NULL, NULL, NULL, 'iramish', 'iran-hormozgan-bashagard-iramish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1267, 29, 13, 75, 'به تیش', NULL, NULL, NULL, 'beh-tish', 'iran-hormozgan-bashagard-beh-tish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1268, 29, 13, 75, 'بیكهنو', NULL, NULL, NULL, 'bikahnu', 'iran-hormozgan-bashagard-bikahnu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1269, 29, 13, 75, 'پوسمن', NULL, NULL, NULL, 'posman', 'iran-hormozgan-bashagard-posman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1270, 29, 13, 75, 'تج', NULL, NULL, NULL, 'taj', 'iran-hormozgan-bashagard-taj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1271, 29, 13, 75, 'جخو', NULL, NULL, NULL, 'jakhou', 'iran-hormozgan-bashagard-jakhou', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1272, 29, 13, 75, 'جخیش', NULL, NULL, NULL, 'jakhish', 'iran-hormozgan-bashagard-jakhish', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1273, 29, 13, 75, 'جگی سرحدی', NULL, NULL, NULL, 'jagi-sarhadi', 'iran-hormozgan-bashagard-jagi-sarhadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1274, 29, 13, 75, 'دربن صلاح', NULL, NULL, NULL, 'darban-salah', 'iran-hormozgan-bashagard-darban-salah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1275, 29, 13, 75, 'درگاه', NULL, NULL, NULL, 'dargah', 'iran-hormozgan-bashagard-dargah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1276, 29, 13, 75, 'درمار', NULL, NULL, NULL, 'darmar', 'iran-hormozgan-bashagard-darmar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1277, 29, 13, 75, 'دست موردن', NULL, NULL, NULL, 'dast-mordan', 'iran-hormozgan-bashagard-dast-mordan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1278, 29, 13, 75, 'دستگرد ناگرد', NULL, NULL, NULL, 'dastgerd-nagard', 'iran-hormozgan-bashagard-dastgerd-nagard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1279, 29, 13, 75, 'دسك', NULL, NULL, NULL, 'dask', 'iran-hormozgan-bashagard-dask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1280, 29, 13, 75, 'دو مرغ', NULL, NULL, NULL, 'do-morgh', 'iran-hormozgan-bashagard-do-morgh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1281, 29, 13, 75, 'زمین لشكری', NULL, NULL, NULL, 'zamin-lashkari', 'iran-hormozgan-bashagard-zamin-lashkari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1282, 29, 13, 75, 'شینش', NULL, NULL, NULL, 'shinsh', 'iran-hormozgan-bashagard-shinsh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1283, 29, 13, 75, 'كرمستان', NULL, NULL, NULL, 'karamestan', 'iran-hormozgan-bashagard-karamestan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1284, 29, 13, 75, 'كور', NULL, NULL, NULL, 'kur', 'iran-hormozgan-bashagard-kur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1285, 29, 13, 75, 'گهركوه', NULL, NULL, NULL, 'gahrkuh', 'iran-hormozgan-bashagard-gahrkuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1286, 29, 13, 75, 'بركهنك', NULL, NULL, NULL, 'barkahank', 'iran-hormozgan-bashagard-barkahank', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1287, 29, 13, 75, 'خمینی شهر', NULL, NULL, NULL, 'khomeyni-shahr', 'iran-hormozgan-bashagard-khomeyni-shahr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1288, 29, 13, 75, 'گزان لاگز', NULL, NULL, NULL, 'gazan-lagaz', 'iran-hormozgan-bashagard-gazan-lagaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1289, 29, 13, 75, 'بن حصار', NULL, NULL, NULL, 'bon-hisar', 'iran-hormozgan-bashagard-bon-hisar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1290, 29, 13, 75, 'اسلام آباد', NULL, NULL, NULL, 'islam-abad', 'iran-hormozgan-bashagard-islam-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1291, 29, 13, 75, 'حسین آباد شگمان', NULL, NULL, NULL, 'hossein-abad-shagman', 'iran-hormozgan-bashagard-hossein-abad-shagman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1292, 29, 13, 75, 'حاجی آباد سرحدی', NULL, NULL, NULL, 'haji-abad-sarhadi', 'iran-hormozgan-bashagard-haji-abad-sarhadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1293, 29, 13, 75, 'حجت آباد', NULL, NULL, NULL, 'hojat-abad', 'iran-hormozgan-bashagard-hojat-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1294, 29, 13, 75, 'گز ماهور', NULL, NULL, NULL, 'gaz-mahur', 'iran-hormozgan-bashagard-gaz-mahur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1295, 29, 13, 75, 'دولت آباد', NULL, NULL, NULL, 'dowlat-abad', 'iran-hormozgan-bashagard-dowlat-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1296, 29, 13, 75, 'سرتنگ سهران', NULL, NULL, NULL, 'sartang-sahran', 'iran-hormozgan-bashagard-sartang-sahran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:14:47', '2025-05-17 03:20:33', NULL),
(1297, 30, 13, 76, 'اخران', NULL, NULL, NULL, 'akhran', 'iran-hormozgan-bashagard-akhran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1298, 30, 13, 76, 'اشكفت مغ', NULL, NULL, NULL, 'eshkaft-magh', 'iran-hormozgan-bashagard-eshkaft-magh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1299, 30, 13, 76, 'بریم روشه', NULL, NULL, NULL, 'barim-ruhsheh', 'iran-hormozgan-bashagard-barim-ruhsheh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1300, 30, 13, 76, 'بنوشی', NULL, NULL, NULL, 'bonushi', 'iran-hormozgan-bashagard-bonushi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1301, 30, 13, 76, 'پاراپیون', NULL, NULL, NULL, 'parapion', 'iran-hormozgan-bashagard-parapion', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1302, 30, 13, 76, 'ده میرز', NULL, NULL, NULL, 'deh-mirz', 'iran-hormozgan-bashagard-deh-mirz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1303, 30, 13, 76, 'جنگل', NULL, NULL, NULL, 'jangal', 'iran-hormozgan-bashagard-jangal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1304, 30, 13, 76, 'درگل', NULL, NULL, NULL, 'dargol', 'iran-hormozgan-bashagard-dargol', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1305, 30, 13, 76, 'ذهاب', NULL, NULL, NULL, 'zahab', 'iran-hormozgan-bashagard-zahab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1306, 30, 13, 76, 'راپیج', NULL, NULL, NULL, 'rapij', 'iran-hormozgan-bashagard-rapij', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1307, 30, 13, 76, 'ریش دراز', NULL, NULL, NULL, 'rish-deraz', 'iran-hormozgan-bashagard-rish-deraz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1308, 30, 13, 76, 'زمین حنصین', NULL, NULL, NULL, 'zamin-hansin', 'iran-hormozgan-bashagard-zamin-hansin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1309, 30, 13, 76, 'زه حسین', NULL, NULL, NULL, 'zeh-hossein', 'iran-hormozgan-bashagard-zeh-hossein', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1310, 30, 13, 76, 'زه موسی', NULL, NULL, NULL, 'zeh-musa', 'iran-hormozgan-bashagard-zeh-musa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1311, 30, 13, 76, 'زهبارك', NULL, NULL, NULL, 'zehbarak', 'iran-hormozgan-bashagard-zehbarak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1312, 30, 13, 76, 'زه كوچكو', NULL, NULL, NULL, 'zeh-kucheku', 'iran-hormozgan-bashagard-zeh-kucheku', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1313, 30, 13, 76, 'سگركن', NULL, NULL, NULL, 'sagarkan', 'iran-hormozgan-bashagard-sagarkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1314, 30, 13, 76, 'سیت', NULL, NULL, NULL, 'sit', 'iran-hormozgan-bashagard-sit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1315, 30, 13, 76, 'سیت بندخرس', NULL, NULL, NULL, 'sit-band-khers', 'iran-hormozgan-bashagard-sit-band-khers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1316, 30, 13, 76, 'شهرك', NULL, NULL, NULL, 'shahrak', 'iran-hormozgan-bashagard-shahrak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1317, 30, 13, 76, 'کهورانی', NULL, NULL, NULL, 'kahurani', 'iran-hormozgan-bashagard-kahurani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1318, 30, 13, 76, 'گاوکش', NULL, NULL, NULL, 'gavkosh', 'iran-hormozgan-bashagard-gavkosh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1319, 30, 13, 76, 'گوگ', NULL, NULL, NULL, 'gug', 'iran-hormozgan-bashagard-gug', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1320, 30, 13, 76, 'ره گدر', NULL, NULL, NULL, 'rah-gader', 'iran-hormozgan-bashagard-rah-gader', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1321, 30, 13, 76, 'کَلَک', NULL, NULL, NULL, 'kalak', 'iran-hormozgan-bashagard-kalak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1322, 30, 13, 76, 'خوشاب (خشاب)', NULL, NULL, NULL, 'khoshab', 'iran-hormozgan-bashagard-khoshab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1323, 30, 13, 76, 'شم کرخی', NULL, NULL, NULL, 'sham-karkhi', 'iran-hormozgan-bashagard-sham-karkhi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1324, 30, 13, 76, 'میخن', NULL, NULL, NULL, 'mikhan', 'iran-hormozgan-bashagard-mikhan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1325, 30, 13, 76, 'درشهر گافر', NULL, NULL, NULL, 'darshahr-gafr', 'iran-hormozgan-bashagard-darshahr-gafr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1326, 30, 13, 76, 'بندر ترج', NULL, NULL, NULL, 'bandar-taraj', 'iran-hormozgan-bashagard-bandar-taraj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1327, 30, 13, 76, 'میان هنزیران', NULL, NULL, NULL, 'mian-hanziran', 'iran-hormozgan-bashagard-mian-hanziran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1328, 30, 13, 76, 'درنگگ', NULL, NULL, NULL, 'darengag', 'iran-hormozgan-bashagard-darengag', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1329, 30, 13, 76, 'دازکان', NULL, NULL, NULL, 'dazkan', 'iran-hormozgan-bashagard-dazkan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1330, 30, 13, 76, 'گلایی', NULL, NULL, NULL, 'golai', 'iran-hormozgan-bashagard-golai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:55:16', '2025-05-17 03:20:33', NULL),
(1331, 30, 13, 77, 'بوئیكان', NULL, NULL, NULL, 'buikan', 'iran-hormozgan-bashagard-buikan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1332, 30, 13, 77, 'بیشن', NULL, NULL, NULL, 'bishan', 'iran-hormozgan-bashagard-bishan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1333, 30, 13, 77, 'توجن', NULL, NULL, NULL, 'tujan', 'iran-hormozgan-bashagard-tujan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1334, 30, 13, 77, 'تومان احمد', NULL, NULL, NULL, 'tuman-ahmad', 'iran-hormozgan-bashagard-tuman-ahmad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1335, 30, 13, 77, 'درخیاران', NULL, NULL, NULL, 'darkhiaran', 'iran-hormozgan-bashagard-darkhiaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1336, 30, 13, 77, 'دركلاهو', NULL, NULL, NULL, 'darkolahu', 'iran-hormozgan-bashagard-darkolahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1337, 30, 13, 77, 'درنگ مدو', NULL, NULL, NULL, 'darang-madu', 'iran-hormozgan-bashagard-darang-madu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1338, 30, 13, 77, 'دوگنویر', NULL, NULL, NULL, 'doganvir', 'iran-hormozgan-bashagard-doganvir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1339, 30, 13, 77, 'دهندر شنبه', NULL, NULL, NULL, 'dehandar-shanbe', 'iran-hormozgan-bashagard-dehandar-shanbe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1340, 30, 13, 77, 'گرهون', NULL, NULL, NULL, 'garhun', 'iran-hormozgan-bashagard-garhun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1341, 30, 13, 77, 'زمین تومان', NULL, NULL, NULL, 'zamin-tuman', 'iran-hormozgan-bashagard-zamin-tuman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1342, 30, 13, 77, 'زمین در', NULL, NULL, NULL, 'zamin-dar', 'iran-hormozgan-bashagard-zamin-dar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1343, 30, 13, 77, 'سردر', NULL, NULL, NULL, 'sardar', 'iran-hormozgan-bashagard-sardar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1344, 30, 13, 77, 'سرزه', NULL, NULL, NULL, 'sarzeh', 'iran-hormozgan-bashagard-sarzeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1345, 30, 13, 77, 'سرزه چاركان', NULL, NULL, NULL, 'sarzeh-charakan', 'iran-hormozgan-bashagard-sarzeh-charakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1346, 30, 13, 77, 'كلاتك سر', NULL, NULL, NULL, 'kalatak-sar', 'iran-hormozgan-bashagard-kalatak-sar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1347, 30, 13, 77, 'كلاهو', NULL, NULL, NULL, 'kolahu', 'iran-hormozgan-bashagard-kolahu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1348, 30, 13, 77, 'كوروج كولن', NULL, NULL, NULL, 'kuroj-kulan', 'iran-hormozgan-bashagard-kuroj-kulan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1349, 30, 13, 77, 'نیک دشت', NULL, NULL, NULL, 'nik-dasht', 'iran-hormozgan-bashagard-nik-dasht', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1350, 30, 13, 77, 'كونكوچكی', NULL, NULL, NULL, 'konkucheki', 'iran-hormozgan-bashagard-konkucheki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1351, 30, 13, 77, 'گچوسک', NULL, NULL, NULL, 'gachusk', 'iran-hormozgan-bashagard-gachusk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1352, 30, 13, 77, 'مانیكان', NULL, NULL, NULL, 'manikan', 'iran-hormozgan-bashagard-manikan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1353, 30, 13, 77, 'ندروچ', NULL, NULL, NULL, 'nadruch', 'iran-hormozgan-bashagard-nadruch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1354, 30, 13, 77, 'نصری', NULL, NULL, NULL, 'nasri', 'iran-hormozgan-bashagard-nasri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1355, 30, 13, 77, 'نیان', NULL, NULL, NULL, 'niyan', 'iran-hormozgan-bashagard-niyan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1356, 30, 13, 77, 'بن ریز', NULL, NULL, NULL, 'bon-riz', 'iran-hormozgan-bashagard-bon-riz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1357, 30, 13, 77, 'بهركان', NULL, NULL, NULL, 'bahrakan', 'iran-hormozgan-bashagard-bahrakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1358, 30, 13, 77, 'دهندر میرعمر', NULL, NULL, NULL, 'dehandar-mir-omar', 'iran-hormozgan-bashagard-dehandar-mir-omar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1359, 30, 13, 77, 'زمین حسن', NULL, NULL, NULL, 'zamin-hasan', 'iran-hormozgan-bashagard-zamin-hasan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1360, 30, 13, 77, 'کهور', NULL, NULL, NULL, 'kahur', 'iran-hormozgan-bashagard-kahur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1361, 30, 13, 77, 'گس گرندو/ گس گرونو', NULL, NULL, NULL, 'gas-garandu', 'iran-hormozgan-bashagard-gas-garandu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1362, 30, 13, 77, 'گوین', NULL, NULL, NULL, 'gavin', 'iran-hormozgan-bashagard-gavin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1363, 30, 13, 77, 'نزگوار', NULL, NULL, NULL, 'nazgvar', 'iran-hormozgan-bashagard-nazgvar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1364, 30, 13, 77, 'ایرگون', NULL, NULL, NULL, 'irgun', 'iran-hormozgan-bashagard-irgun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1365, 30, 13, 77, 'دریوار', NULL, NULL, NULL, 'darivar', 'iran-hormozgan-bashagard-darivar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1366, 30, 13, 77, 'درپهنو', NULL, NULL, NULL, 'darpehno', 'iran-hormozgan-bashagard-darpehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1367, 30, 13, 77, 'تیسور', NULL, NULL, NULL, 'tisur', 'iran-hormozgan-bashagard-tisur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1368, 30, 13, 77, 'حیدرآباد', NULL, NULL, NULL, 'heydar-abad', 'iran-hormozgan-bashagard-heydar-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1369, 30, 13, 77, 'علی آباد سرحدی', NULL, NULL, NULL, 'ali-abad-sarhadi', 'iran-hormozgan-bashagard-ali-abad-sarhadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1370, 30, 13, 77, 'گازن بز', NULL, NULL, NULL, 'gazan-baz', 'iran-hormozgan-bashagard-gazan-baz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1371, 30, 13, 77, 'نورآباد', NULL, NULL, NULL, 'nurabad', 'iran-hormozgan-bashagard-nurabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1372, 30, 13, 77, 'گردیوالان', NULL, NULL, NULL, 'gardivalan', 'iran-hormozgan-bashagard-gardivalan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 10:57:52', '2025-05-17 03:20:33', NULL),
(1373, 31, 8, 79, 'آشکارا', NULL, NULL, '0003', 'ashkara', 'iran-hormozgan-hajjiabad-ashkara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1374, 31, 8, 79, 'بخوان', NULL, NULL, NULL, 'bokhvan', 'iran-hormozgan-hajjiabad-bokhvan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1375, 31, 8, 79, 'بسته', NULL, NULL, NULL, 'baste', 'iran-hormozgan-hajjiabad-baste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1376, 31, 8, 79, 'بندکوه', NULL, NULL, NULL, 'bandkuh', 'iran-hormozgan-hajjiabad-bandkuh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1377, 31, 8, 79, 'تی در', NULL, NULL, NULL, 'ti-dar', 'iran-hormozgan-hajjiabad-ti-dar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1378, 31, 8, 79, 'دهنه میمند', NULL, NULL, NULL, 'dahane-meymand', 'iran-hormozgan-hajjiabad-dahane-meymand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1379, 31, 8, 79, 'رحیم آباد', NULL, NULL, NULL, 'rahimabad', 'iran-hormozgan-hajjiabad-rahimabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1380, 31, 8, 79, 'شاهرود', NULL, NULL, NULL, 'shahrud', 'iran-hormozgan-hajjiabad-shahrud', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1381, 31, 8, 79, 'کشرودخانه', NULL, NULL, NULL, 'kesh-rudkhane', 'iran-hormozgan-hajjiabad-kesh-rudkhane', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1382, 31, 8, 79, 'مزرعه', NULL, NULL, NULL, 'mazraeh', 'iran-hormozgan-hajjiabad-mazraeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1383, 31, 8, 79, 'میمند', NULL, NULL, NULL, 'meymand', 'iran-hormozgan-hajjiabad-meymand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1384, 31, 8, 79, 'نارمند', NULL, NULL, NULL, 'narmand', 'iran-hormozgan-hajjiabad-narmand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1385, 31, 8, 79, 'نسا', NULL, NULL, NULL, 'nasa', 'iran-hormozgan-hajjiabad-nasa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1386, 31, 8, 79, 'نطام آباد', NULL, NULL, NULL, 'nezamabad', 'iran-hormozgan-hajjiabad-nezamabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1387, 31, 8, 79, 'کهنوج', NULL, NULL, NULL, 'kahnuj', 'iran-hormozgan-hajjiabad-kahnuj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1388, 31, 8, 79, 'باغان', NULL, NULL, NULL, 'baghan', 'iran-hormozgan-hajjiabad-baghan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1389, 31, 8, 79, 'بررود', NULL, NULL, NULL, 'berrud', 'iran-hormozgan-hajjiabad-berrud', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1390, 31, 8, 79, 'بناب', NULL, NULL, NULL, 'bonab', 'iran-hormozgan-hajjiabad-bonab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1391, 31, 8, 79, 'پرعابدنیه', NULL, NULL, NULL, 'porabedaniyeh', 'iran-hormozgan-hajjiabad-porabedaniyeh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1392, 31, 8, 79, 'تل مرا', NULL, NULL, NULL, 'tal-mara', 'iran-hormozgan-hajjiabad-tal-mara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1393, 31, 8, 79, 'راییز', NULL, NULL, NULL, 'rayiz', 'iran-hormozgan-hajjiabad-rayiz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1394, 31, 8, 79, 'زمین سیاه', NULL, NULL, NULL, 'zamin-siah', 'iran-hormozgan-hajjiabad-zamin-siah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1395, 31, 8, 79, 'سردر', NULL, NULL, NULL, 'sardar', 'iran-hormozgan-hajjiabad-sardar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1396, 31, 8, 79, 'سیرمند', NULL, NULL, NULL, 'sirmand', 'iran-hormozgan-hajjiabad-sirmand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1397, 31, 8, 79, 'سیاهک', NULL, NULL, NULL, 'siahak', 'iran-hormozgan-hajjiabad-siahak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1398, 31, 8, 79, 'سیروییه', NULL, NULL, NULL, 'siruieh', 'iran-hormozgan-hajjiabad-siruieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1399, 31, 8, 79, 'دشت آشکارا', NULL, NULL, NULL, 'dasht-ashkara', 'iran-hormozgan-hajjiabad-dasht-ashkara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1400, 31, 8, 79, 'بابا کوهی', NULL, NULL, NULL, 'baba-kuhi', 'iran-hormozgan-hajjiabad-baba-kuhi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1401, 31, 8, 79, 'سرگلان', NULL, NULL, NULL, 'sargalan', 'iran-hormozgan-hajjiabad-sargalan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1402, 31, 8, 79, 'جایین', NULL, NULL, NULL, 'jayin', 'iran-hormozgan-hajjiabad-jayin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1403, 31, 8, 79, 'شمیل بالا', NULL, NULL, NULL, 'shamil-bala', 'iran-hormozgan-hajjiabad-shamil-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1404, 32, 8, 78, 'درآگاه', NULL, NULL, '0001', 'dara-gah', 'iran-hormozgan-hajjiabad-dara-gah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1405, 32, 8, 78, 'طارم', NULL, NULL, '0002', 'tarem', 'iran-hormozgan-hajjiabad-tarem', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1406, 32, 8, 78, 'باکان', NULL, NULL, NULL, 'bakan', 'iran-hormozgan-hajjiabad-bakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1407, 32, 8, 78, 'باینوج', NULL, NULL, NULL, 'baynuj', 'iran-hormozgan-hajjiabad-baynuj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1408, 32, 8, 78, 'بویه', NULL, NULL, NULL, 'boveh', 'iran-hormozgan-hajjiabad-boveh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1409, 32, 8, 78, 'بیدوییه', NULL, NULL, NULL, 'biduieh', 'iran-hormozgan-hajjiabad-biduieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1410, 32, 8, 78, 'پشته زیارت', NULL, NULL, NULL, 'poshte-ziarat', 'iran-hormozgan-hajjiabad-poshte-ziarat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1411, 32, 8, 78, 'تل محمد خانی', NULL, NULL, NULL, 'tal-mohammad-khani', 'iran-hormozgan-hajjiabad-tal-mohammad-khani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1412, 32, 8, 78, 'تنگ صالحی', NULL, NULL, NULL, 'tangeh-salehi', 'iran-hormozgan-hajjiabad-tangeh-salehi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1413, 32, 8, 78, 'تنگ قوچان', NULL, NULL, NULL, 'tangeh-quchan', 'iran-hormozgan-hajjiabad-tangeh-quchan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1414, 32, 8, 78, 'تیراندازی', NULL, NULL, NULL, 'tirandazi', 'iran-hormozgan-hajjiabad-tirandazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1415, 32, 8, 78, 'چاه انجیر', NULL, NULL, NULL, 'chah-anjir', 'iran-hormozgan-hajjiabad-chah-anjir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1416, 32, 8, 78, 'چاه تل شماره سه', NULL, NULL, NULL, 'chah-tal-shomare-se', 'iran-hormozgan-hajjiabad-chah-tal-shomare-se', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1417, 32, 8, 78, 'چاه تر', NULL, NULL, NULL, 'chah-tar', 'iran-hormozgan-hajjiabad-chah-tar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1418, 32, 8, 78, 'چاه سوری', NULL, NULL, NULL, 'chah-suri', 'iran-hormozgan-hajjiabad-chah-suri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1419, 32, 8, 78, 'چاه کنار', NULL, NULL, NULL, 'chah-kanar', 'iran-hormozgan-hajjiabad-chah-kanar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1420, 32, 8, 78, 'حاجی آباد تنگ صالحی', NULL, NULL, NULL, 'hajjiabad-tangeh-salehi', 'iran-hormozgan-hajjiabad-hajjiabad-tangeh-salehi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1421, 32, 8, 78, 'حسن آباد', NULL, NULL, NULL, 'hasanabad', 'iran-hormozgan-hajjiabad-hasanabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1422, 32, 8, 78, 'حسین آباد', NULL, NULL, NULL, 'hosseinabad', 'iran-hormozgan-hajjiabad-hosseinabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1423, 32, 8, 78, 'حیدر حاجی', NULL, NULL, NULL, 'heydar-hajji', 'iran-hormozgan-hajjiabad-heydar-hajji', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1424, 32, 8, 78, 'خدادادی', NULL, NULL, NULL, 'khodadadi', 'iran-hormozgan-hajjiabad-khodadadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1425, 32, 8, 78, 'خوش آباد', NULL, NULL, NULL, 'khosh-abad', 'iran-hormozgan-hajjiabad-khosh-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1426, 32, 8, 78, 'خونه ورز', NULL, NULL, NULL, 'khuneh-varz', 'iran-hormozgan-hajjiabad-khuneh-varz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1427, 32, 8, 78, 'دراگاه', NULL, NULL, NULL, 'dara-gah', 'iran-hormozgan-hajjiabad-dara-gah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1428, 32, 8, 78, 'مزرعه دره شیر', NULL, NULL, NULL, 'mazraeh-dareh-shir', 'iran-hormozgan-hajjiabad-mazraeh-dareh-shir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1429, 32, 8, 78, 'دشتوییه', NULL, NULL, NULL, 'dashtuieh', 'iran-hormozgan-hajjiabad-dashtuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1430, 32, 8, 78, 'دق پده', NULL, NULL, NULL, 'degh-pade', 'iran-hormozgan-hajjiabad-degh-pade', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1431, 32, 8, 78, 'دشت آزادگان/ دق دزدان', NULL, NULL, NULL, 'dasht-azadegan', 'iran-hormozgan-hajjiabad-dasht-azadegan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1432, 32, 8, 78, 'دهستان بالا', NULL, NULL, NULL, 'dehestan-bala', 'iran-hormozgan-hajjiabad-dehestan-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1433, 32, 8, 78, 'دهستان پایین', NULL, NULL, NULL, 'dehestan-pain', 'iran-hormozgan-hajjiabad-dehestan-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1434, 32, 8, 78, 'دهنو', NULL, NULL, NULL, 'dehno', 'iran-hormozgan-hajjiabad-dehno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1435, 32, 8, 78, 'رزدر', NULL, NULL, NULL, 'razdar', 'iran-hormozgan-hajjiabad-razdar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1436, 32, 8, 78, 'ریش گیر', NULL, NULL, NULL, 'rishgir', 'iran-hormozgan-hajjiabad-rishgir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1437, 32, 8, 78, 'سرگز خضرصفا کلینو', NULL, NULL, NULL, 'sargez-khezr-safa-kalinu', 'iran-hormozgan-hajjiabad-sargez-khezr-safa-kalinu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1438, 32, 8, 78, 'سه شاخ', NULL, NULL, NULL, 'se-shakh', 'iran-hormozgan-hajjiabad-se-shakh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1439, 32, 8, 78, 'سیف آباد', NULL, NULL, NULL, 'seyf-abad', 'iran-hormozgan-hajjiabad-seyf-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1440, 32, 8, 78, 'صالح آباد', NULL, NULL, NULL, 'salehabad', 'iran-hormozgan-hajjiabad-salehabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1441, 32, 8, 78, 'علی آباد', NULL, NULL, NULL, 'aliabad', 'iran-hormozgan-hajjiabad-aliabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1442, 32, 8, 78, 'فخر آباد', NULL, NULL, NULL, 'fakhrabad', 'iran-hormozgan-hajjiabad-fakhrabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1443, 32, 8, 78, 'قلاتوییه', NULL, NULL, NULL, 'ghalatuieh', 'iran-hormozgan-hajjiabad-ghalatuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1444, 32, 8, 78, 'قلاتوییه تنگ صالحی', NULL, NULL, NULL, 'ghalatuieh-tangeh-salehi', 'iran-hormozgan-hajjiabad-ghalatuieh-tangeh-salehi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1445, 32, 8, 78, 'کشکوییه', NULL, NULL, NULL, 'koshkuieh', 'iran-hormozgan-hajjiabad-koshkuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1446, 32, 8, 78, 'گله اشتری', NULL, NULL, NULL, 'galeh-ashtari', 'iran-hormozgan-hajjiabad-galeh-ashtari', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1447, 32, 8, 78, 'کهه', NULL, NULL, NULL, 'koh', 'iran-hormozgan-hajjiabad-koh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1448, 32, 8, 78, 'گدار ملا محمدی', NULL, NULL, NULL, 'gadar-molla-mohammadi', 'iran-hormozgan-hajjiabad-gadar-molla-mohammadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1449, 32, 8, 78, 'گرمشک', NULL, NULL, NULL, 'garmeshk', 'iran-hormozgan-hajjiabad-garmeshk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1450, 32, 8, 78, 'گشنوئیه پائین', NULL, NULL, NULL, 'gashnuieh-pain', 'iran-hormozgan-hajjiabad-gashnuieh-pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1451, 32, 8, 78, 'گلزار', NULL, NULL, NULL, 'golzar', 'iran-hormozgan-hajjiabad-golzar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1452, 32, 8, 78, 'گلینو', NULL, NULL, NULL, 'golinu', 'iran-hormozgan-hajjiabad-golinu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1453, 32, 8, 78, 'مبارک حسینی', NULL, NULL, NULL, 'mobarak-hoseini', 'iran-hormozgan-hajjiabad-mobarak-hoseini', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1454, 32, 8, 78, 'محمداباد', NULL, NULL, NULL, 'mohammadabad', 'iran-hormozgan-hajjiabad-mohammadabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1455, 32, 8, 78, 'معصوم آباد', NULL, NULL, NULL, 'masumabad', 'iran-hormozgan-hajjiabad-masumabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1456, 32, 8, 78, 'مورتوییه', NULL, NULL, NULL, 'mortuieh', 'iran-hormozgan-hajjiabad-mortuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1457, 32, 8, 78, 'مهرآران', NULL, NULL, NULL, 'mehraran', 'iran-hormozgan-hajjiabad-mehraran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1458, 32, 8, 78, 'مهرخوشان', NULL, NULL, NULL, 'mehrkhoshan', 'iran-hormozgan-hajjiabad-mehrkhoshan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1459, 32, 8, 78, 'مهرگان', NULL, NULL, NULL, 'mehrgan', 'iran-hormozgan-hajjiabad-mehrgan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1460, 32, 8, 78, 'نسوئیه', NULL, NULL, NULL, 'nasuieh', 'iran-hormozgan-hajjiabad-nasuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL);
INSERT INTO `state6_village` (`id`, `district_id`, `county_id`, `city_id`, `name`, `name_en`, `name_ar`, `code`, `slug`, `global_slug`, `boundaries`, `area`, `population`, `households`, `elevation`, `postal_code`, `phone_code`, `description`, `is_active`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1461, 32, 8, 78, 'نی زار', NULL, NULL, NULL, 'neyzar', 'iran-hormozgan-hajjiabad-neyzar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1462, 32, 8, 78, 'تلمبه محمود خسروی', NULL, NULL, NULL, 'talebe-mahmoud-khosravi', 'iran-hormozgan-hajjiabad-talebe-mahmoud-khosravi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1463, 32, 8, 78, 'بهوا', NULL, NULL, NULL, 'bahva', 'iran-hormozgan-hajjiabad-bahva', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1464, 32, 8, 78, 'چاه مهکی', NULL, NULL, NULL, 'chah-mahki', 'iran-hormozgan-hajjiabad-chah-mahki', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1465, 32, 8, 78, 'چاه سرخ', NULL, NULL, NULL, 'chah-sorkh', 'iran-hormozgan-hajjiabad-chah-sorkh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1466, 32, 8, 78, 'گیس', NULL, NULL, NULL, 'gis', 'iran-hormozgan-hajjiabad-gis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1467, 32, 8, 78, 'عزت اباد', NULL, NULL, NULL, 'ezzatabad', 'iran-hormozgan-hajjiabad-ezzatabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1468, 32, 8, 78, 'باردرازی', NULL, NULL, NULL, 'bardarazi', 'iran-hormozgan-hajjiabad-bardarazi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1469, 32, 8, 78, 'گشنوئیه بالا', NULL, NULL, NULL, 'gashnuieh-bala', 'iran-hormozgan-hajjiabad-gashnuieh-bala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1470, 32, 8, 78, 'خیر آباد', NULL, NULL, NULL, 'khayrabad', 'iran-hormozgan-hajjiabad-khayrabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1471, 32, 8, 78, 'آباد', NULL, NULL, NULL, 'abad', 'iran-hormozgan-hajjiabad-abad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1472, 32, 8, 78, 'قنات باغات', NULL, NULL, NULL, 'qanat-baghat', 'iran-hormozgan-hajjiabad-qanat-baghat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1473, 32, 8, 78, 'چاه میرزاخانی', NULL, NULL, NULL, 'chah-mirza-khani', 'iran-hormozgan-hajjiabad-chah-mirza-khani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1474, 32, 8, 78, 'احشام خسرو خان', NULL, NULL, NULL, 'ahsham-khosrow-khan', 'iran-hormozgan-hajjiabad-ahsham-khosrow-khan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1475, 32, 8, 78, 'عباس آباد', NULL, NULL, NULL, 'abbasabad', 'iran-hormozgan-hajjiabad-abbasabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1476, 32, 8, 78, 'تلمبه بختیار صادقی', NULL, NULL, NULL, 'talebe-bakhtiyar-sadeghi', 'iran-hormozgan-hajjiabad-talebe-bakhtiyar-sadeghi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1477, 32, 8, 78, 'چاه انجیر گلوروباط', NULL, NULL, NULL, 'chah-anjir-golurobat', 'iran-hormozgan-hajjiabad-chah-anjir-golurobat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1478, 32, 8, 78, 'نی تلخ', NULL, NULL, NULL, 'ney-talkh', 'iran-hormozgan-hajjiabad-ney-talkh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1479, 32, 8, 78, 'سرگز', NULL, NULL, NULL, 'sargez', 'iran-hormozgan-hajjiabad-sargez', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1480, 32, 8, 78, 'سرتنگ دره شیر', NULL, NULL, NULL, 'sar-tang-dareh-shir', 'iran-hormozgan-hajjiabad-sar-tang-dareh-shir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1481, 32, 8, 78, 'تلمبه عباس پور', NULL, NULL, NULL, 'talebe-abbas-pur', 'iran-hormozgan-hajjiabad-talebe-abbas-pur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1482, 32, 8, 78, 'چاه زاغ', NULL, NULL, NULL, 'chah-zagh', 'iran-hormozgan-hajjiabad-chah-zagh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1483, 32, 8, 78, 'آب زالوئیه', NULL, NULL, NULL, 'ab-zaluieh', 'iran-hormozgan-hajjiabad-ab-zaluieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1484, 32, 8, 78, 'باغات', NULL, NULL, NULL, 'baghat', 'iran-hormozgan-hajjiabad-baghat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1485, 32, 8, 78, 'سرچاهان', NULL, NULL, NULL, 'sar-chahan', 'iran-hormozgan-hajjiabad-sar-chahan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1486, 32, 8, 78, 'طاشکوییه', NULL, NULL, NULL, 'tashkuieh', 'iran-hormozgan-hajjiabad-tashkuieh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1487, 33, 8, 80, 'احمدی', NULL, NULL, '0001', 'ahmadi', 'iran-hormozgan-hajjiabad-ahmadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1488, 33, 8, 80, 'کوه شاه', NULL, NULL, '0002', 'kuh-shah', 'iran-hormozgan-hajjiabad-kuh-shah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1489, 33, 8, 80, 'بغدادی', NULL, NULL, NULL, 'baghdadi', 'iran-hormozgan-hajjiabad-baghdadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1490, 33, 8, 80, 'بررود', NULL, NULL, NULL, 'berrud', 'iran-hormozgan-hajjiabad-berrud', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1491, 33, 8, 80, 'بلم سگی', NULL, NULL, NULL, 'balm-sagi', 'iran-hormozgan-hajjiabad-balm-sagi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1492, 33, 8, 80, 'بنگود احمدی', NULL, NULL, NULL, 'banguod-ahmadi', 'iran-hormozgan-hajjiabad-banguod-ahmadi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1493, 33, 8, 80, 'پازرد', NULL, NULL, NULL, 'pazard', 'iran-hormozgan-hajjiabad-pazard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-05-17 03:20:33', NULL),
(1494, 33, 8, 80, 'پاشغ جدید', NULL, NULL, NULL, 'pashgh-jadid', 'iran-hormozgan-hajjiabad-pashgh-jadid', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-04-25 12:14:04', '2025-