<?php

namespace Hekmatinasser\Jalali;

use DateTime;
use Hekmatinasser\Jalali\Traits\Date;

/**
 * A simple API extension for DateTime.
 *
 * <autodoc generated by `composer phpdoc`>
 *
 * @property int $year
 * @property int $month
 * @property int $day
 * @property int $hour
 * @property int $minute
 * @property int $second
 * @property int $micro
 * @property int $timestamp seconds since the Unix Epoch
 * @property int $dayOfYear 1 through 366
 * @property string $timezone the current timezone
 * @property-read int $dayOfWeek 1 (for Saturday) through 6 (for Friday)
 * @property-read int $weekOfYear ISO-8601 week number of year, weeks starting on Monday
 * @property-read int $daysInMonth number of days in the given month
 * @property-read int $quarter the quarter of this instance, 1 - 4
 *
 * @method bool isSunday() Checks if the instance day is sunday.
 * @method bool isMonday() Checks if the instance day is monday.
 * @method bool isTuesday() Checks if the instance day is tuesday.
 * @method bool isWednesday() Checks if the instance day is wednesday.
 * @method bool isThursday() Checks if the instance day is thursday.
 * @method bool isFriday() Checks if the instance day is friday.
 * @method bool isSaturday() Checks if the instance day is saturday.
 * @method bool isSameYear(Jalali|null $datetime = null)                        Checks if the given date is in the same year as the instance. If null passed, compare to now (with the same timezone).
 * @method bool isCurrentYear() Checks if the instance is in the same year as the current moment.
 * @method bool isNextYear() Checks if the instance is in the same year as the current moment next year.
 * @method bool isLastYear() Checks if the instance is in the same year as the current moment last year.
 * @method bool isNextWeek() Checks if the instance is in the same week as the current moment next week.
 * @method bool isLastWeek() Checks if the instance is in the same week as the current moment last week.
 * @method bool isSameDay(Jalali|null $datetime = null)                         Checks if the given date is in the same day as the instance. If null passed, compare to now (with the same timezone).
 * @method bool isToday()                                                                       Checks if the instance is in the same day as the current moment.
 * @method $this year(int $value) Set current instance year to the given value.
 * @method $this month(int $value) Set current instance month to the given value.
 * @method $this day(int $value) Set current instance day to the given value.
 * @method $this hour(int $value) Set current instance hour to the given value.
 * @method $this minute(int $value) Set current instance minute to the given value.
 * @method $this second(int $value) Set current instance second to the given value.
 * @method $this micro(int $value) Set current instance micro to the given value.
 * @method $this timestamp(int $value) Set current instance timestamp to the given value.
 * @method $this timezone(int $value) Set current instance timezone to the given value.
 * @method $this setDateTime(int $year, int $month, int $day, int $hour, int $minute, int $second = 0, int $micro = 0) Set the date and time all together.
 * @method $this setDateJalali(int $year, int $month, int $day) Sets the current date together.
 * @method $this setTimeString(string $time) Set the time by time string.
 *
 * @method $this startMinute Resets the second to 00
 * @method $this endMinute() Resets the second to 5
 * @method $this startHour() Resets the minute and second to 00:00
 * @method $this endHour() Resets the minute and second to 59:59
 * @method $this startDay() Resets the time to 00:00:00
 * @method $this endDay() Resets the time to 23:59:59
 * @method $this startWeek() Resets the date to the first day of week (defined in $weekStartsAt) and the time to 00:00:00
 * @method $this endWeek() Resets the date to the first day of week (defined in $weekStartsAt) and the time to 00:00:00
 * @method $this startMonth() Resets the date to the first day of the month and the time to 00:00:00
 * @method $this endMonth() Resets the date to end of the month and time to 23:59:59
 * @method $this startQuarter() Resets the date to the first day of the quarter and the time to 00:00:00
 * @method $this endQuarter() Resets the date to end of the quarter and time to 23:59:59
 * @method $this startYear() Resets the date to the first day of the year and the time to 00:00:00
 * @method $this endYear() Resets the date to end of the year and time to 23:59:59
 *
 * @method $this addYears(int $value = 1) Add years (the $value count passed in) to the instance (using date interval).
 * @method $this addYear() Add one year to the instance (using date interval).
 * @method $this subYears(int $value = 1) Sub years (the $value count passed in) to the instance (using date interval).
 * @method $this subYear() Sub one year to the instance (using date interval). Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method $this addMonths(int $value = 1) Add months (the $value count passed in) to the instance (using date interval).
 * @method $this addMonth() Add one month to the instance (using date interval).
 * @method $this subMonths(int $value = 1) Sub months (the $value count passed in) to the instance (using date interval).
 * @method $this subMonth() Sub one month to the instance (using date interval).
 * @method $this addDays(int $value = 1) Add days (the $value count passed in) to the instance (using date interval).
 * @method $this addDay() Add one day to the instance (using date interval).
 * @method $this subDays(int $value = 1) Sub days (the $value count passed in) to the instance (using date interval).
 * @method $this subDay() Sub one day to the instance (using date interval).
 * @method $this addHours(int $value = 1) Add hours (the $value count passed in) to the instance (using date interval).
 * @method $this addHour() Add one hour to the instance (using date interval).
 * @method $this subHours(int $value = 1) Sub hours (the $value count passed in) to the instance (using date interval).
 * @method $this subHour() Sub one hour to the instance (using date interval).
 * @method $this addMinutes(int $value = 1) Add minutes (the $value count passed in) to the instance (using date interval).
 * @method $this addMinute() Add one minute to the instance (using date interval).
 * @method $this subMinutes(int $value = 1) Sub minutes (the $value count passed in) to the instance (using date interval).
 * @method $this subMinute() Sub one minute to the instance (using date interval).
 * @method $this addSeconds(int $value = 1) Add seconds (the $value count passed in) to the instance (using date interval).
 * @method $this addSecond() Add one second to the instance (using date interval).
 * @method $this subSeconds(int $value = 1) Sub seconds (the $value count passed in) to the instance (using date interval).
 * @method $this subSecond() Sub one second to the instance (using date interval).
 * @method $this addWeeks(int $value = 1) Add weeks (the $value count passed in) to the instance (using date interval).
 * @method $this addWeek() Add one week to the instance (using date interval).
 * @method $this subWeeks(int $value = 1) Sub weeks (the $value count passed in) to the instance (using date interval).
 * @method $this subWeek() Sub one week to the instance (using date interval).
 *
 * </autodoc>
 */
class Jalali extends DateTime implements JalaliInterface
{
    use Date;
}
