

<?php $__env->startSection('title', 'داشبورد مدیریت'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .dashboard-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 15px;
        padding: 25px;
        color: white;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .dashboard-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, transparent 100%);
        pointer-events: none;
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.15);
    }

    .dashboard-card.primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .dashboard-card.success {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }

    .dashboard-card.info {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }

    .dashboard-card.warning {
        background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
    }

    .dashboard-card.danger {
        background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    }

    .dashboard-card.purple {
        background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
        color: #333;
    }

    .card-icon {
        font-size: 3rem;
        opacity: 0.8;
        margin-bottom: 15px;
    }

    .card-value {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 5px;
    }

    .card-label {
        font-size: 1rem;
        opacity: 0.9;
        margin-bottom: 10px;
    }

    .card-growth {
        font-size: 0.9rem;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .growth-positive {
        color: #4ade80;
    }

    .growth-negative {
        color: #f87171;
    }

    .modern-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 25px rgba(0,0,0,0.08);
        border: none;
        transition: all 0.3s ease;
    }

    .modern-card:hover {
        box-shadow: 0 10px 35px rgba(0,0,0,0.12);
        transform: translateY(-2px);
    }

    .modern-card .card-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-bottom: 1px solid #e2e8f0;
        border-radius: 15px 15px 0 0 !important;
        padding: 20px 25px;
        font-weight: 600;
        color: #1e293b;
    }

    .modern-card .card-body {
        padding: 25px;
    }

    .chart-container {
        position: relative;
        height: 350px;
        margin: 20px 0;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 25px;
        margin-bottom: 30px;
    }

    .metric-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.06);
        border-left: 4px solid #3b82f6;
    }

    .metric-value {
        font-size: 1.8rem;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 5px;
    }

    .metric-label {
        color: #64748b;
        font-size: 0.9rem;
        margin-bottom: 10px;
    }

    .metric-change {
        font-size: 0.8rem;
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .table-modern {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.06);
    }

    .table-modern thead th {
        background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
        color: white;
        font-weight: 600;
        border: none;
        padding: 15px;
    }

    .table-modern tbody td {
        padding: 12px 15px;
        border-bottom: 1px solid #f1f5f9;
        vertical-align: middle;
    }

    .table-modern tbody tr:hover {
        background-color: #f8fafc;
    }

    .badge-modern {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 500;
    }

    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
    }

    .page-header h1 {
        margin: 0;
        font-weight: 700;
        font-size: 2.2rem;
    }

    .page-header p {
        margin: 10px 0 0 0;
        opacity: 0.9;
        font-size: 1.1rem;
    }

    .quick-actions {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
    }

    .quick-action-btn {
        background: rgba(255,255,255,0.2);
        color: white;
        border: 1px solid rgba(255,255,255,0.3);
        padding: 10px 20px;
        border-radius: 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }

    .quick-action-btn:hover {
        background: rgba(255,255,255,0.3);
        color: white;
        transform: translateY(-2px);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="page-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h1>داشبورد مدیریت</h1>
            <p>مرکز کنترل و نظارت بر سیستم</p>
        </div>
        <div class="quick-actions">
            <a href="<?php echo e(route('admin.analytics.index')); ?>" class="quick-action-btn">
                <i class="fas fa-chart-line me-2"></i> تحلیل‌های پیشرفته
            </a>
            <a href="<?php echo e(route('admin.locations.create')); ?>" class="quick-action-btn">
                <i class="fas fa-plus me-2"></i> مکان جدید
            </a>
            <a href="<?php echo e(route('admin.categories.index')); ?>" class="quick-action-btn">
                <i class="fas fa-tags me-2"></i> دسته‌بندی‌ها
            </a>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="stats-grid">
    <div class="dashboard-card primary">
        <div class="card-icon">
            <i class="fas fa-map-marker-alt"></i>
        </div>
        <div class="card-value"><?php echo e(number_format($stats['locations'])); ?></div>
        <div class="card-label">کل مکان‌ها</div>
        <div class="card-growth">
            <?php if($stats['locations_growth'] > 0): ?>
                <i class="fas fa-arrow-up growth-positive"></i>
                <span class="growth-positive"><?php echo e($stats['locations_growth']); ?>%</span>
            <?php elseif($stats['locations_growth'] < 0): ?>
                <i class="fas fa-arrow-down growth-negative"></i>
                <span class="growth-negative"><?php echo e(abs($stats['locations_growth'])); ?>%</span>
            <?php else: ?>
                <i class="fas fa-minus text-muted"></i>
                <span class="text-muted">بدون تغییر</span>
            <?php endif; ?>
            <span class="ms-1">نسبت به ماه قبل</span>
        </div>
    </div>

    <div class="dashboard-card success">
        <div class="card-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="card-value"><?php echo e(number_format($stats['active_locations'])); ?></div>
        <div class="card-label">مکان‌های فعال</div>
        <div class="card-growth">
            <i class="fas fa-percentage"></i>
            <span><?php echo e($stats['locations'] > 0 ? round(($stats['active_locations'] / $stats['locations']) * 100, 1) : 0); ?>%</span>
            <span class="ms-1">از کل مکان‌ها</span>
        </div>
    </div>

    <div class="dashboard-card info">
        <div class="card-icon">
            <i class="fas fa-star"></i>
        </div>
        <div class="card-value"><?php echo e(number_format($stats['approved_ratings'])); ?></div>
        <div class="card-label">نظرات تایید شده</div>
        <div class="card-growth">
            <?php if($stats['ratings_growth'] > 0): ?>
                <i class="fas fa-arrow-up growth-positive"></i>
                <span class="growth-positive"><?php echo e($stats['ratings_growth']); ?>%</span>
            <?php elseif($stats['ratings_growth'] < 0): ?>
                <i class="fas fa-arrow-down growth-negative"></i>
                <span class="growth-negative"><?php echo e(abs($stats['ratings_growth'])); ?>%</span>
            <?php else: ?>
                <i class="fas fa-minus text-muted"></i>
                <span class="text-muted">بدون تغییر</span>
            <?php endif; ?>
            <span class="ms-1">نسبت به ماه قبل</span>
        </div>
    </div>

    <div class="dashboard-card warning">
        <div class="card-icon">
            <i class="fas fa-clock"></i>
        </div>
        <div class="card-value"><?php echo e(number_format($stats['pending_ratings'])); ?></div>
        <div class="card-label">نظرات در انتظار</div>
        <div class="card-growth">
            <i class="fas fa-exclamation-triangle"></i>
            <span>نیاز به بررسی</span>
        </div>
    </div>

    <div class="dashboard-card danger">
        <div class="card-icon">
            <i class="fas fa-ad"></i>
        </div>
        <div class="card-value"><?php echo e(number_format($stats['active_ads'])); ?></div>
        <div class="card-label">تبلیغات فعال</div>
        <div class="card-growth">
            <?php if($stats['advertisements_growth'] > 0): ?>
                <i class="fas fa-arrow-up growth-positive"></i>
                <span class="growth-positive"><?php echo e($stats['advertisements_growth']); ?>%</span>
            <?php elseif($stats['advertisements_growth'] < 0): ?>
                <i class="fas fa-arrow-down growth-negative"></i>
                <span class="growth-negative"><?php echo e(abs($stats['advertisements_growth'])); ?>%</span>
            <?php else: ?>
                <i class="fas fa-minus text-muted"></i>
                <span class="text-muted">بدون تغییر</span>
            <?php endif; ?>
            <span class="ms-1">نسبت به ماه قبل</span>
        </div>
    </div>

    <div class="dashboard-card purple">
        <div class="card-icon">
            <i class="fas fa-users"></i>
        </div>
        <div class="card-value"><?php echo e(number_format($stats['admins'])); ?></div>
        <div class="card-label">مدیران سیستم</div>
        <div class="card-growth">
            <i class="fas fa-shield-alt"></i>
            <span>دسترسی کامل</span>
        </div>
    </div>
</div>

<!-- Real-time Metrics -->
<div class="row mb-4">
    <div class="col-12">
        <div class="modern-card">
            <div class="card-header">
                <i class="fas fa-chart-line me-2"></i>
                آمار لحظه‌ای سیستم
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="metric-card">
                            <div class="metric-value"><?php echo e($realTimeMetrics['today_locations']); ?></div>
                            <div class="metric-label">مکان‌های امروز</div>
                            <div class="metric-change">
                                <?php if($realTimeMetrics['today_locations'] > $realTimeMetrics['yesterday_locations']): ?>
                                    <i class="fas fa-arrow-up text-success"></i>
                                    <span class="text-success"><?php echo e($realTimeMetrics['today_locations'] - $realTimeMetrics['yesterday_locations']); ?> بیشتر از دیروز</span>
                                <?php elseif($realTimeMetrics['today_locations'] < $realTimeMetrics['yesterday_locations']): ?>
                                    <i class="fas fa-arrow-down text-danger"></i>
                                    <span class="text-danger"><?php echo e($realTimeMetrics['yesterday_locations'] - $realTimeMetrics['today_locations']); ?> کمتر از دیروز</span>
                                <?php else: ?>
                                    <i class="fas fa-equals text-muted"></i>
                                    <span class="text-muted">مشابه دیروز</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="metric-card">
                            <div class="metric-value"><?php echo e($realTimeMetrics['today_ratings']); ?></div>
                            <div class="metric-label">نظرات امروز</div>
                            <div class="metric-change">
                                <?php if($realTimeMetrics['today_ratings'] > $realTimeMetrics['yesterday_ratings']): ?>
                                    <i class="fas fa-arrow-up text-success"></i>
                                    <span class="text-success"><?php echo e($realTimeMetrics['today_ratings'] - $realTimeMetrics['yesterday_ratings']); ?> بیشتر از دیروز</span>
                                <?php elseif($realTimeMetrics['today_ratings'] < $realTimeMetrics['yesterday_ratings']): ?>
                                    <i class="fas fa-arrow-down text-danger"></i>
                                    <span class="text-danger"><?php echo e($realTimeMetrics['yesterday_ratings'] - $realTimeMetrics['today_ratings']); ?> کمتر از دیروز</span>
                                <?php else: ?>
                                    <i class="fas fa-equals text-muted"></i>
                                    <span class="text-muted">مشابه دیروز</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="metric-card">
                            <div class="metric-value"><?php echo e(number_format($realTimeMetrics['avg_rating_today'], 1)); ?></div>
                            <div class="metric-label">میانگین امتیاز امروز</div>
                            <div class="metric-change">
                                <i class="fas fa-star text-warning"></i>
                                <span>از 5 امتیاز</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="metric-card">
                            <div class="metric-value"><?php echo e($realTimeMetrics['week_locations']); ?></div>
                            <div class="metric-label">مکان‌های این هفته</div>
                            <div class="metric-change">
                                <?php if($realTimeMetrics['week_locations'] > $realTimeMetrics['last_week_locations']): ?>
                                    <i class="fas fa-arrow-up text-success"></i>
                                    <span class="text-success"><?php echo e($realTimeMetrics['week_locations'] - $realTimeMetrics['last_week_locations']); ?> بیشتر از هفته قبل</span>
                                <?php elseif($realTimeMetrics['week_locations'] < $realTimeMetrics['last_week_locations']): ?>
                                    <i class="fas fa-arrow-down text-danger"></i>
                                    <span class="text-danger"><?php echo e($realTimeMetrics['last_week_locations'] - $realTimeMetrics['week_locations']); ?> کمتر از هفته قبل</span>
                                <?php else: ?>
                                    <i class="fas fa-equals text-muted"></i>
                                    <span class="text-muted">مشابه هفته قبل</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="modern-card">
            <div class="card-header">
                <i class="fas fa-map-marker-alt me-2"></i>
                آخرین مکان‌های اضافه شده
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th>عنوان</th>
                                <th>دسته‌بندی</th>
                                <th>امتیاز</th>
                                <th>وضعیت</th>
                                <th>تاریخ ایجاد</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-3">
                                                <?php if($location->categoryRelation && $location->categoryRelation->emoji): ?>
                                                    <span style="font-size: 1.5rem;"><?php echo e($location->categoryRelation->emoji); ?></span>
                                                <?php else: ?>
                                                    <i class="fas fa-map-marker-alt text-primary"></i>
                                                <?php endif; ?>
                                            </div>
                                            <div>
                                                <div class="fw-bold"><?php echo e($location->title); ?></div>
                                                <?php if($location->address): ?>
                                                    <small class="text-muted"><?php echo e(Str::limit($location->address, 50)); ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($location->category_id && is_object($location->categoryRelation)): ?>
                                            <span class="badge-modern bg-primary"><?php echo e($location->categoryRelation->getTranslatedName()); ?></span>
                                        <?php elseif($location->category_fa): ?>
                                            <span class="badge-modern bg-primary"><?php echo e($location->category_fa); ?></span>
                                        <?php else: ?>
                                            <span class="badge-modern bg-secondary">نامشخص</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($location->ratings_avg_rating): ?>
                                            <div class="d-flex align-items-center">
                                                <span class="fw-bold me-1"><?php echo e(number_format($location->ratings_avg_rating, 1)); ?></span>
                                                <i class="fas fa-star text-warning"></i>
                                                <small class="text-muted ms-1">(<?php echo e($location->ratings_count); ?>)</small>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted">بدون امتیاز</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($location->is_active): ?>
                                            <span class="badge-modern bg-success">فعال</span>
                                        <?php else: ?>
                                            <span class="badge-modern bg-danger">غیرفعال</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div><?php echo e(\Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('Y/m/d')); ?></div>
                                        <small class="text-muted"><?php echo e(\Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('H:i')); ?></small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.locations.show', $location->id)); ?>" class="btn btn-sm btn-outline-info" title="مشاهده">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.locations.edit', $location->id)); ?>" class="btn btn-sm btn-outline-primary" title="ویرایش">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <div class="text-muted">هیچ مکانی یافت نشد.</div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <!-- Category Distribution Chart -->
        <div class="modern-card mb-4">
            <div class="card-header">
                <i class="fas fa-chart-pie me-2"></i>
                توزیع مکان‌ها بر اساس دسته‌بندی
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="categoryChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Top Rated Locations -->
        <div class="modern-card mb-4">
            <div class="card-header">
                <i class="fas fa-trophy me-2"></i>
                بهترین مکان‌ها
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $topLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex align-items-center mb-3 p-3 rounded" style="background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);">
                        <div class="me-3">
                            <div class="badge bg-warning rounded-circle" style="width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;">
                                <?php echo e($index + 1); ?>

                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-bold mb-1"><?php echo e($location->title); ?></div>
                            <div class="small text-muted mb-1">
                                <?php if($location->category_id && is_object($location->categoryRelation)): ?>
                                    <?php echo e($location->categoryRelation->getTranslatedName()); ?>

                                <?php elseif($location->category_fa): ?>
                                    <?php echo e($location->category_fa); ?>

                                <?php else: ?>
                                    نامشخص
                                <?php endif; ?>
                            </div>
                            <div class="d-flex align-items-center">
                                <span class="fw-bold text-warning me-1"><?php echo e(number_format($location->average_rating, 1)); ?></span>
                                <i class="fas fa-star text-warning me-2"></i>
                                <small class="text-muted">(<?php echo e($location->ratings_count); ?> نظر)</small>
                            </div>
                        </div>
                        <div>
                            <a href="<?php echo e(route('admin.locations.show', $location->id)); ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-star fa-3x text-muted mb-3"></i>
                        <div class="text-muted">هیچ مکانی با امتیاز یافت نشد.</div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Growth Trend Chart -->
        <div class="modern-card">
            <div class="card-header">
                <i class="fas fa-chart-line me-2"></i>
                روند رشد (30 روز گذشته)
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="growthChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activities and Performance -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="modern-card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>
                    <i class="fas fa-ad me-2"></i>
                    تبلیغات اخیر
                </div>
                <a href="<?php echo e(route('admin.advertisements.index')); ?>" class="btn btn-sm btn-primary">
                    مشاهده همه
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th>عنوان</th>
                                <th>نوع</th>
                                <th>وضعیت</th>
                                <th>عملکرد</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentAds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="fw-bold"><?php echo e($ad->title); ?></div>
                                        <?php if($ad->position): ?>
                                            <small class="text-muted"><?php echo e($ad->position); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge-modern bg-info"><?php echo e($ad->ad_type); ?></span>
                                    </td>
                                    <td>
                                        <?php if($ad->is_active): ?>
                                            <span class="badge-modern bg-success">فعال</span>
                                        <?php else: ?>
                                            <span class="badge-modern bg-danger">غیرفعال</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div><i class="fas fa-eye text-info me-1"></i><?php echo e(number_format($ad->view_count)); ?> نمایش</div>
                                            <div><i class="fas fa-mouse-pointer text-success me-1"></i><?php echo e(number_format($ad->click_count)); ?> کلیک</div>
                                            <?php if($ad->view_count > 0): ?>
                                                <div class="text-muted">CTR: <?php echo e(number_format(($ad->click_count / $ad->view_count) * 100, 2)); ?>%</div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.advertisements.edit', $ad->id)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center py-4">
                                        <i class="fas fa-ad fa-3x text-muted mb-3"></i>
                                        <div class="text-muted">هیچ تبلیغی یافت نشد.</div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6 mb-4">
        <div class="modern-card">
            <div class="card-header">
                <i class="fas fa-chart-bar me-2"></i>
                آمار عملکرد سیستم
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6 mb-3">
                        <div class="text-center p-3 rounded" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                            <div class="h4 mb-1"><?php echo e(number_format($performanceMetrics['avgRating'], 1)); ?></div>
                            <div class="small">میانگین امتیاز</div>
                            <div class="mt-2">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= round($performanceMetrics['avgRating'])): ?>
                                        <i class="fas fa-star text-warning"></i>
                                    <?php else: ?>
                                        <i class="far fa-star text-warning"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="text-center p-3 rounded" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white;">
                            <div class="h4 mb-1"><?php echo e($performanceMetrics['locationsGrowthRate']); ?>%</div>
                            <div class="small">رشد ماهانه</div>
                            <div class="mt-2">
                                <?php if($performanceMetrics['locationsGrowthRate'] > 0): ?>
                                    <i class="fas fa-arrow-up"></i>
                                <?php elseif($performanceMetrics['locationsGrowthRate'] < 0): ?>
                                    <i class="fas fa-arrow-down"></i>
                                <?php else: ?>
                                    <i class="fas fa-minus"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($performanceMetrics['topCategory']): ?>
                <div class="mb-3">
                    <h6 class="fw-bold">دسته‌بندی محبوب:</h6>
                    <div class="d-flex align-items-center">
                        <span class="badge-modern bg-primary me-2"><?php echo e($performanceMetrics['topCategory']->category); ?></span>
                        <span class="text-muted"><?php echo e($performanceMetrics['topCategory']->count); ?> مکان</span>
                    </div>
                </div>
                <?php endif; ?>

                <?php if($performanceMetrics['topAmenities']->count() > 0): ?>
                <div>
                    <h6 class="fw-bold">امکانات محبوب:</h6>
                    <div class="d-flex flex-wrap gap-1">
                        <?php $__currentLoopData = $performanceMetrics['topAmenities']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge-modern bg-secondary"><?php echo e($amenity->title); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Set global font defaults for all charts
    Chart.defaults.font.family = "IRANSans";
    Chart.defaults.color = '#64748b';

    // Modern color palette
    const modernColors = [
        '#667eea', '#764ba2', '#f093fb', '#f5576c', '#4facfe', '#00f2fe',
        '#43e97b', '#38f9d7', '#fa709a', '#fee140', '#a8edea', '#fed6e3'
    ];

    // Category Distribution Chart
    const categoryCtx = document.getElementById('categoryChart').getContext('2d');
    const categoryChart = new Chart(categoryCtx, {
        type: 'doughnut',
        data: {
            labels: [
                <?php $__currentLoopData = $categoryCounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($category->category); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            datasets: [{
                data: [
                    <?php $__currentLoopData = $categoryCounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($category->count); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                backgroundColor: modernColors,
                borderWidth: 0,
                hoverBorderWidth: 3,
                hoverBorderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        font: {
                            family: 'IRANSans',
                            size: 12
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0,0,0,0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#667eea',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((context.parsed / total) * 100).toFixed(1);
                            return `${context.label}: ${context.parsed} (${percentage}%)`;
                        }
                    }
                }
            },
            cutout: '65%',
            animation: {
                animateRotate: true,
                duration: 2000
            }
        }
    });

    // Growth Trend Chart
    const growthCtx = document.getElementById('growthChart').getContext('2d');
    const growthChart = new Chart(growthCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($growthTrends['days'], 15, 512) ?>,
            datasets: [{
                label: 'مکان‌ها',
                data: <?php echo json_encode($growthTrends['locations'], 15, 512) ?>,
                borderColor: '#667eea',
                backgroundColor: 'rgba(102, 126, 234, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: '#667eea',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
                pointRadius: 4,
                pointHoverRadius: 6
            }, {
                label: 'نظرات',
                data: <?php echo json_encode($growthTrends['ratings'], 15, 512) ?>,
                borderColor: '#f093fb',
                backgroundColor: 'rgba(240, 147, 251, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: '#f093fb',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
                pointRadius: 4,
                pointHoverRadius: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                intersect: false,
                mode: 'index'
            },
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        usePointStyle: true,
                        padding: 20,
                        font: {
                            family: 'IRANSans',
                            size: 12
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0,0,0,0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#667eea',
                    borderWidth: 1,
                    cornerRadius: 8
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: {
                            family: 'IRANSans',
                            size: 11
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0,0,0,0.05)'
                    },
                    ticks: {
                        font: {
                            family: 'IRANSans',
                            size: 11
                        }
                    }
                }
            },
            animation: {
                duration: 2000,
                easing: 'easeInOutQuart'
            }
        }
    });

    // Auto refresh data every 5 minutes
    setInterval(function() {
        fetch(window.location.href, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.text())
        .then(html => {
            // Update real-time metrics
            const parser = new DOMParser();
            const doc = parser.parseFromString(html, 'text/html');

            // Update metric values
            document.querySelectorAll('.metric-value').forEach((element, index) => {
                const newElement = doc.querySelectorAll('.metric-value')[index];
                if (newElement) {
                    element.textContent = newElement.textContent;
                }
            });

            console.log('Dashboard data refreshed');
        })
        .catch(error => {
            console.error('Error refreshing dashboard:', error);
        });
    }, 300000); // 5 minutes

    // Add loading animation to cards
    document.addEventListener('DOMContentLoaded', function() {
        const cards = document.querySelectorAll('.dashboard-card, .modern-card');
        cards.forEach((card, index) => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';

            setTimeout(() => {
                card.style.transition = 'all 0.6s ease';
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, index * 100);
        });
    });

    // Developer info function
    function showDeveloperInfo() {
        const modal = document.createElement('div');
        modal.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 10000;
            backdrop-filter: blur(8px);
            animation: fadeIn 0.3s ease;
        `;

        modal.innerHTML = `
            <div style="
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 20px;
                padding: 2rem;
                text-align: center;
                color: white;
                max-width: 450px;
                width: 90%;
                box-shadow: 0 20px 40px rgba(0,0,0,0.3);
                transform: scale(0.9);
                animation: modalPop 0.3s ease forwards;
            ">
                <div style="font-size: 3rem; margin-bottom: 1rem;">⚡</div>
                <h3 style="margin-bottom: 0.5rem; font-weight: 700;">یوسف رجستری</h3>
                <p style="margin-bottom: 0.5rem; font-size: 1.1rem; color: #e0e7ff;">Yousof Rajestary</p>
                <p style="margin-bottom: 1.5rem; opacity: 0.9;">System Architect & Lead Developer</p>
                <div style="background: rgba(255,255,255,0.1); border-radius: 12px; padding: 1rem; margin-bottom: 1.5rem;">
                    <p style="margin: 0; font-size: 0.9rem; line-height: 1.6;">
                        این سیستم مدیریت مکان‌ها از مرحله تحلیل نیازمندی تا پیاده‌سازی کامل و راه‌اندازی توسط یوسف رجستری طراحی و توسعه یافته است.
                        شامل معماری سیستم، طراحی دیتابیس، توسعه API، پنل مدیریت، و بهینه‌سازی عملکرد.
                    </p>
                </div>
                <div style="display: flex; gap: 0.5rem; justify-content: center; margin-bottom: 1.5rem;">
                    <span style="background: rgba(255,255,255,0.2); padding: 0.25rem 0.75rem; border-radius: 20px; font-size: 0.8rem;">Laravel</span>
                    <span style="background: rgba(255,255,255,0.2); padding: 0.25rem 0.75rem; border-radius: 20px; font-size: 0.8rem;">Vue.js</span>
                    <span style="background: rgba(255,255,255,0.2); padding: 0.25rem 0.75rem; border-radius: 20px; font-size: 0.8rem;">MySQL</span>
                    <span style="background: rgba(255,255,255,0.2); padding: 0.25rem 0.75rem; border-radius: 20px; font-size: 0.8rem;">Bootstrap</span>
                </div>
                <button onclick="this.closest('div').parentElement.remove()" style="
                    background: rgba(255,255,255,0.2);
                    border: 1px solid rgba(255,255,255,0.3);
                    border-radius: 8px;
                    color: white;
                    padding: 0.5rem 1.5rem;
                    cursor: pointer;
                    transition: all 0.3s ease;
                " onmouseover="this.style.background='rgba(255,255,255,0.3)'" onmouseout="this.style.background='rgba(255,255,255,0.2)'">
                    بستن
                </button>
            </div>
        `;

        modal.onclick = (e) => {
            if (e.target === modal) modal.remove();
        };

        document.body.appendChild(modal);
    }
</script>

<style>
    /* Developer Credit Styles */
    .developer-credit {
        position: fixed;
        bottom: 20px;
        right: 20px;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(16px);
        -webkit-backdrop-filter: blur(16px);
        border: 1px solid rgba(0, 0, 0, 0.1);
        border-radius: 12px;
        padding: 0.75rem 1rem;
        color: #333;
        font-size: 0.85rem;
        font-weight: 500;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        cursor: pointer;
        z-index: 1000;
    }

    .developer-credit:hover {
        background: rgba(255, 255, 255, 1);
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    }

    .developer-credit .dev-icon {
        color: #667eea;
        margin-left: 0.5rem;
        font-size: 1rem;
    }

    .developer-credit .dev-name {
        font-weight: 600;
        color: #333;
    }

    .developer-credit .dev-role {
        font-size: 0.75rem;
        opacity: 0.7;
        margin-top: 0.25rem;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    @keyframes modalPop {
        from { transform: scale(0.9); opacity: 0; }
        to { transform: scale(1); opacity: 1; }
    }
</style>

<!-- Developer Credit -->
<div class="developer-credit" onclick="showDeveloperInfo()">
    <div class="d-flex align-items-center">
        <i class="fas fa-cogs dev-icon"></i>
        <div>
            <div class="dev-name">یوسف رجستری</div>
            <div class="dev-role">System Developer</div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>