<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تغییر رمز عبور - پنل مدیریت</title>
    <meta name="description" content="تغییر رمز عبور حساب کاربری ادمین با امنیت بالا">
    <meta name="robots" content="noindex, nofollow">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/fonts.css')); ?>">

    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --danger-gradient: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
            --glass-bg: rgba(255, 255, 255, 0.25);
            --glass-border: rgba(255, 255, 255, 0.18);
            --shadow-light: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            --shadow-heavy: 0 15px 35px rgba(0, 0, 0, 0.1);
            --border-radius: 16px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IRANSans', 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><defs><radialGradient id="a" cx="50%" cy="50%"><stop offset="0%" stop-color="%23ffffff" stop-opacity="0.1"/><stop offset="100%" stop-color="%23ffffff" stop-opacity="0"/></radialGradient></defs><circle cx="300" cy="200" r="120" fill="url(%23a)"/><circle cx="700" cy="400" r="100" fill="url(%23a)"/><circle cx="200" cy="600" r="80" fill="url(%23a)"/></svg>') no-repeat center center;
            background-size: cover;
            animation: float 25s ease-in-out infinite;
            pointer-events: none;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-30px) rotate(180deg); }
        }

        .main-container {
            display: grid;
            grid-template-columns: 1fr 500px;
            gap: 2rem;
            width: 100%;
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
            align-items: start;
            min-height: 100vh;
        }

        /* Security Dashboard */
        .security-dashboard {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2rem;
            box-shadow: var(--shadow-light);
            animation: slideInLeft 0.8s ease-out;
            height: fit-content;
        }

        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .dashboard-header {
            text-align: center;
            margin-bottom: 2rem;
            color: white;
        }

        .dashboard-header h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .dashboard-header p {
            opacity: 0.9;
            font-size: 1rem;
        }

        /* Security Score */
        .security-score {
            text-align: center;
            margin-bottom: 2rem;
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            position: relative;
        }

        .score-circle {
            width: 120px;
            height: 120px;
            margin: 0 auto 1rem;
            position: relative;
        }

        .score-circle svg {
            width: 100%;
            height: 100%;
            transform: rotate(-90deg);
        }

        .score-circle .score-bg {
            fill: none;
            stroke: rgba(255, 255, 255, 0.2);
            stroke-width: 8;
        }

        .score-circle .score-fill {
            fill: none;
            stroke: #4ade80;
            stroke-width: 8;
            stroke-linecap: round;
            transition: stroke-dasharray 1s ease-in-out;
        }

        .score-text {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 1.5rem;
            font-weight: 700;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .score-label {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            margin-top: 0.5rem;
        }

        /* Security Stats Grid */
        .security-stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .stat-item {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1rem;
            text-align: center;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .stat-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .stat-item:hover::before {
            left: 100%;
        }

        .stat-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }

        .stat-icon {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            color: white;
        }

        .stat-value {
            font-size: 1.2rem;
            font-weight: 700;
            color: white;
            margin-bottom: 0.25rem;
        }

        .stat-label {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.8);
        }

        /* Recommendations */
        .recommendations {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 1.5rem;
        }

        .recommendations h4 {
            color: white;
            font-size: 1.1rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .recommendation-item {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            padding: 0.75rem;
            margin-bottom: 0.5rem;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .recommendation-item:last-child {
            margin-bottom: 0;
        }

        .recommendation-item i {
            color: #fbbf24;
        }

        /* Password Form Container */
        .password-form-container {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2rem;
            box-shadow: var(--shadow-light);
            animation: slideInRight 0.8s ease-out;
            height: fit-content;
        }

        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
            color: white;
        }

        .form-header h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .form-header p {
            opacity: 0.9;
            font-size: 1rem;
        }

        /* Modern Form Styles */
        .modern-form {
            margin-bottom: 2rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: white;
            font-weight: 600;
            margin-bottom: 0.75rem;
            font-size: 0.95rem;
        }

        .required {
            color: #ef4444;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            padding: 1rem 3rem 1rem 1.25rem;
            font-size: 1rem;
            color: #333;
            transition: var(--transition);
            width: 100%;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.95);
            border-color: rgba(102, 126, 234, 0.5);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }

        .form-control::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .form-control.is-invalid {
            border-color: #ef4444;
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }

        .password-toggle {
            position: absolute;
            left: 1rem;
            background: none;
            border: none;
            color: #6b7280;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 6px;
            transition: var(--transition);
        }

        .password-toggle:hover {
            color: #374151;
            background: rgba(0, 0, 0, 0.05);
        }

        /* Password Strength Indicator */
        .password-strength {
            margin-top: 0.75rem;
        }

        .strength-bar {
            width: 100%;
            height: 6px;
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
            overflow: hidden;
            margin-bottom: 0.5rem;
        }

        .strength-fill {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
            border-radius: 3px;
        }

        .strength-text {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.85rem;
            text-align: center;
        }

        /* Password Requirements */
        .password-requirements {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0.5rem;
            margin-top: 0.75rem;
        }

        .requirement {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.8rem;
            transition: var(--transition);
        }

        .requirement.valid {
            color: #4ade80;
        }

        .requirement.valid i {
            color: #4ade80;
        }

        .requirement i {
            color: #ef4444;
            font-size: 0.7rem;
        }

        /* Password Match Indicator */
        .password-match {
            margin-top: 0.5rem;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .password-match.match {
            color: #4ade80;
        }

        .password-match.no-match {
            color: #ef4444;
        }

        /* Error Messages */
        .error-message {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: #ef4444;
            font-size: 0.85rem;
            margin-top: 0.5rem;
            background: rgba(239, 68, 68, 0.1);
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Alert Styles */
        .alert {
            border-radius: 12px;
            border: none;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.2);
            color: #e8f5e8;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }

        .alert-danger {
            background: rgba(244, 67, 54, 0.2);
            color: #ffebee;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }

        /* Form Actions */
        .form-actions {
            display: flex;
            gap: 1rem;
            margin-top: 2rem;
        }

        .btn {
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1rem;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary-gradient);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            flex: 1;
            justify-content: center;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
            color: white;
        }

        .btn-secondary {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .btn-secondary:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: translateY(-2px);
            color: white;
        }

        .btn-loading {
            display: none;
        }

        .btn.loading .btn-text {
            display: none;
        }

        .btn.loading .btn-loading {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        /* Security Tips */
        .security-tips {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 1.5rem;
        }

        .security-tips h4 {
            color: white;
            font-size: 1.1rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .tips-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        .tip-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            padding: 0.75rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            transition: var(--transition);
        }

        .tip-item:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateY(-1px);
        }

        .tip-item i {
            color: #4ade80;
            font-size: 1rem;
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .main-container {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }

            .security-dashboard {
                order: 2;
            }

            .password-form-container {
                order: 1;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }

            .security-dashboard,
            .password-form-container {
                padding: 1.5rem;
            }

            .security-stats {
                grid-template-columns: 1fr;
            }

            .password-requirements {
                grid-template-columns: 1fr;
            }

            .tips-grid {
                grid-template-columns: 1fr;
            }

            .form-actions {
                flex-direction: column;
            }
        }

        @media (max-width: 480px) {
            .main-container {
                padding: 0.5rem;
            }

            .security-dashboard,
            .password-form-container {
                padding: 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Security Dashboard -->
        <div class="security-dashboard">
            <div class="dashboard-header">
                <h2><i class="fas fa-shield-alt"></i> داشبورد امنیت</h2>
                <p>وضعیت امنیتی حساب کاربری شما</p>
            </div>

            <!-- Security Score -->
            <div class="security-score">
                <div class="score-circle">
                    <svg viewBox="0 0 120 120">
                        <circle class="score-bg" cx="60" cy="60" r="54"></circle>
                        <circle class="score-fill" cx="60" cy="60" r="54"
                                stroke-dasharray="<?php echo e(($securityStats['security_score'] ?? 75) * 3.39); ?> 339"
                                style="stroke: <?php echo e(($securityStats['security_score'] ?? 75) >= 80 ? '#4ade80' : (($securityStats['security_score'] ?? 75) >= 60 ? '#fbbf24' : '#ef4444')); ?>"></circle>
                    </svg>
                    <div class="score-text"><?php echo e($securityStats['security_score'] ?? 75); ?>%</div>
                </div>
                <div class="score-label">امتیاز امنیت</div>
            </div>

            <!-- Security Stats -->
            <div class="security-stats">
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <div class="stat-value">
                        <?php echo e($securityStats['password_age'] ?? 'نامشخص'); ?>

                    </div>
                    <div class="stat-label">روز از آخرین تغییر</div>
                </div>

                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-history"></i>
                    </div>
                    <div class="stat-value">
                        <?php echo e($securityStats['password_history_count'] ?? 0); ?>

                    </div>
                    <div class="stat-label">تاریخچه رمز عبور</div>
                </div>

                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-value">
                        <?php echo e($securityStats['password_expires_in'] ?? 90); ?>

                    </div>
                    <div class="stat-label">روز تا انقضا</div>
                </div>

                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="stat-value">
                        <?php echo e($securityStats['failed_attempts_today'] ?? 0); ?>

                    </div>
                    <div class="stat-label">تلاش ناموفق امروز</div>
                </div>

                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-sign-in-alt"></i>
                    </div>
                    <div class="stat-value">
                        <?php echo e($securityStats['total_logins'] ?? 0); ?>

                    </div>
                    <div class="stat-label">کل ورودها</div>
                </div>

                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-desktop"></i>
                    </div>
                    <div class="stat-value">
                        <?php echo e($securityStats['login_sessions'] ?? 1); ?>

                    </div>
                    <div class="stat-label">جلسات فعال</div>
                </div>
            </div>

            <!-- Last Activity -->
            <div class="stat-item" style="grid-column: 1 / -1;">
                <div class="stat-icon">
                    <i class="fas fa-user-clock"></i>
                </div>
                <div class="stat-value">
                    <?php echo e($securityStats['last_login'] ? $securityStats['last_login']->format('Y/m/d H:i') : 'هرگز'); ?>

                </div>
                <div class="stat-label">آخرین ورود</div>
            </div>

            <!-- Security Recommendations -->
            <?php if(!empty($securityStats['security_recommendations'])): ?>
            <div class="recommendations">
                <h4>
                    <i class="fas fa-lightbulb"></i>
                    توصیه‌های امنیتی
                </h4>
                <?php $__currentLoopData = $securityStats['security_recommendations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recommendation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="recommendation-item">
                    <i class="fas fa-info-circle"></i>
                    <?php echo e($recommendation); ?>

                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endif; ?>
        </div>

        <!-- Change Password Form -->
        <div class="password-form-container">
            <div class="form-header">
                <h2><i class="fas fa-key"></i> تغییر رمز عبور</h2>
                <p>برای امنیت بیشتر، رمز عبور قوی انتخاب کنید</p>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.password.change')); ?>" method="POST" id="password-form" class="modern-form">
                <?php echo csrf_field(); ?>

                <!-- Current Password -->
                <div class="form-group">
                    <label for="current_password" class="form-label">
                        <i class="fas fa-lock"></i>
                        رمز عبور فعلی
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               name="current_password"
                               id="current_password"
                               class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               required
                               autocomplete="current-password"
                               placeholder="رمز عبور فعلی خود را وارد کنید">
                        <button type="button" class="password-toggle" data-target="current_password">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- New Password -->
                <div class="form-group">
                    <label for="password" class="form-label">
                        <i class="fas fa-key"></i>
                        رمز عبور جدید
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               name="password"
                               id="password"
                               class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               required
                               autocomplete="new-password"
                               placeholder="رمز عبور جدید خود را وارد کنید"
                               minlength="8">
                        <button type="button" class="password-toggle" data-target="password">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <div class="password-strength">
                        <div class="strength-bar">
                            <div class="strength-fill" id="strength-fill"></div>
                        </div>
                        <div class="strength-text" id="strength-text">قدرت رمز عبور</div>
                    </div>
                    <div class="password-requirements">
                        <div class="requirement" id="req-length">
                            <i class="fas fa-times"></i>
                            حداقل 8 کاراکتر
                        </div>
                        <div class="requirement" id="req-uppercase">
                            <i class="fas fa-times"></i>
                            حروف بزرگ انگلیسی
                        </div>
                        <div class="requirement" id="req-lowercase">
                            <i class="fas fa-times"></i>
                            حروف کوچک انگلیسی
                        </div>
                        <div class="requirement" id="req-number">
                            <i class="fas fa-times"></i>
                            اعداد
                        </div>
                        <div class="requirement" id="req-special">
                            <i class="fas fa-times"></i>
                            کاراکترهای خاص
                        </div>
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Confirm Password -->
                <div class="form-group">
                    <label for="password_confirmation" class="form-label">
                        <i class="fas fa-check-double"></i>
                        تکرار رمز عبور جدید
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               name="password_confirmation"
                               id="password_confirmation"
                               class="form-control"
                               required
                               autocomplete="new-password"
                               placeholder="رمز عبور جدید را مجدداً وارد کنید">
                        <button type="button" class="password-toggle" data-target="password_confirmation">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <div class="password-match" id="password-match"></div>
                </div>

                <!-- Form Actions -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary" id="submit-btn">
                        <span class="btn-text">
                            <i class="fas fa-save"></i>
                            ثبت رمز عبور جدید
                        </span>
                        <div class="btn-loading">
                            <i class="fas fa-spinner fa-spin"></i>
                            در حال ثبت...
                        </div>
                    </button>

                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i>
                        بازگشت به داشبورد
                    </a>
                </div>
            </form>

            <!-- Security Tips -->
            <div class="security-tips">
                <h4>
                    <i class="fas fa-shield-alt"></i>
                    نکات امنیتی
                </h4>
                <div class="tips-grid">
                    <div class="tip-item">
                        <i class="fas fa-random"></i>
                        <span>از ترکیب حروف، اعداد و نمادها استفاده کنید</span>
                    </div>
                    <div class="tip-item">
                        <i class="fas fa-ban"></i>
                        <span>از اطلاعات شخصی در رمز عبور خودداری کنید</span>
                    </div>
                    <div class="tip-item">
                        <i class="fas fa-sync-alt"></i>
                        <span>رمز عبور را به صورت منظم تغییر دهید</span>
                    </div>
                    <div class="tip-item">
                        <i class="fas fa-user-secret"></i>
                        <span>رمز عبور را با کسی به اشتراک نگذارید</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        class ModernPasswordChanger {
            constructor() {
                this.init();
                this.setupEventListeners();
                this.animatePageLoad();
            }

            init() {
                this.form = document.getElementById('password-form');
                this.submitBtn = document.getElementById('submit-btn');
                this.passwordInput = document.getElementById('password');
                this.confirmInput = document.getElementById('password_confirmation');
                this.strengthFill = document.getElementById('strength-fill');
                this.strengthText = document.getElementById('strength-text');
                this.passwordMatch = document.getElementById('password-match');

                this.requirements = {
                    length: document.getElementById('req-length'),
                    uppercase: document.getElementById('req-uppercase'),
                    lowercase: document.getElementById('req-lowercase'),
                    number: document.getElementById('req-number'),
                    special: document.getElementById('req-special')
                };
            }

            setupEventListeners() {
                // Password toggle functionality
                document.querySelectorAll('.password-toggle').forEach(toggle => {
                    toggle.addEventListener('click', (e) => this.togglePassword(e));
                });

                // Password strength checking
                if (this.passwordInput) {
                    this.passwordInput.addEventListener('input', (e) => {
                        this.checkPasswordStrength(e.target.value);
                        this.checkPasswordMatch();
                    });
                }

                // Password confirmation checking
                if (this.confirmInput) {
                    this.confirmInput.addEventListener('input', () => {
                        this.checkPasswordMatch();
                    });
                }

                // Form submission
                if (this.form) {
                    this.form.addEventListener('submit', (e) => this.handleSubmit(e));
                }

                // Input focus animations
                document.querySelectorAll('.form-control').forEach(input => {
                    input.addEventListener('focus', (e) => this.handleInputFocus(e));
                    input.addEventListener('blur', (e) => this.handleInputBlur(e));
                });
            }

            togglePassword(e) {
                const button = e.currentTarget;
                const targetId = button.getAttribute('data-target');
                const input = document.getElementById(targetId);
                const icon = button.querySelector('i');

                if (input.type === 'password') {
                    input.type = 'text';
                    icon.className = 'fas fa-eye-slash';
                } else {
                    input.type = 'password';
                    icon.className = 'fas fa-eye';
                }

                // Add animation
                button.style.transform = 'scale(0.9)';
                setTimeout(() => {
                    button.style.transform = 'scale(1)';
                }, 150);
            }

            checkPasswordStrength(password) {
                let score = 0;
                const checks = {
                    length: password.length >= 8,
                    uppercase: /[A-Z]/.test(password),
                    lowercase: /[a-z]/.test(password),
                    number: /[0-9]/.test(password),
                    special: /[^A-Za-z0-9]/.test(password)
                };

                // Update requirement indicators
                Object.keys(checks).forEach(key => {
                    const element = this.requirements[key];
                    const icon = element.querySelector('i');

                    if (checks[key]) {
                        element.classList.add('valid');
                        icon.className = 'fas fa-check';
                        score += 20;
                    } else {
                        element.classList.remove('valid');
                        icon.className = 'fas fa-times';
                    }
                });

                // Update strength bar
                this.updateStrengthBar(score);
            }

            updateStrengthBar(score) {
                const percentage = Math.min(score, 100);
                this.strengthFill.style.width = percentage + '%';

                let color, text;
                if (score < 40) {
                    color = '#ef4444';
                    text = 'ضعیف';
                } else if (score < 80) {
                    color = '#fbbf24';
                    text = 'متوسط';
                } else {
                    color = '#4ade80';
                    text = 'قوی';
                }

                this.strengthFill.style.background = color;
                this.strengthText.textContent = `قدرت رمز عبور: ${text}`;
                this.strengthText.style.color = color;
            }

            checkPasswordMatch() {
                const password = this.passwordInput.value;
                const confirm = this.confirmInput.value;

                if (confirm === '') {
                    this.passwordMatch.textContent = '';
                    this.passwordMatch.className = 'password-match';
                    return;
                }

                if (password === confirm) {
                    this.passwordMatch.innerHTML = '<i class="fas fa-check"></i> رمز عبور مطابقت دارد';
                    this.passwordMatch.className = 'password-match match';
                } else {
                    this.passwordMatch.innerHTML = '<i class="fas fa-times"></i> رمز عبور مطابقت ندارد';
                    this.passwordMatch.className = 'password-match no-match';
                }
            }

            handleInputFocus(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1.02)';
                    wrapper.style.transition = 'transform 0.2s ease';
                }
            }

            handleInputBlur(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1)';
                }
            }

            handleSubmit(e) {
                // Add loading state
                this.submitBtn.classList.add('loading');
                this.submitBtn.disabled = true;

                // Validate passwords match
                if (this.passwordInput.value !== this.confirmInput.value) {
                    e.preventDefault();
                    this.showError('رمز عبور و تکرار آن مطابقت ندارد');
                    this.submitBtn.classList.remove('loading');
                    this.submitBtn.disabled = false;
                    return;
                }

                // Check password strength
                const score = this.calculatePasswordScore(this.passwordInput.value);
                if (score < 60) {
                    e.preventDefault();
                    this.showError('رمز عبور انتخابی به اندازه کافی قوی نیست');
                    this.submitBtn.classList.remove('loading');
                    this.submitBtn.disabled = false;
                    return;
                }

                // Add success animation
                this.addSubmitAnimation();
            }

            calculatePasswordScore(password) {
                let score = 0;
                if (password.length >= 8) score += 20;
                if (/[A-Z]/.test(password)) score += 20;
                if (/[a-z]/.test(password)) score += 20;
                if (/[0-9]/.test(password)) score += 20;
                if (/[^A-Za-z0-9]/.test(password)) score += 20;
                return score;
            }

            showError(message) {
                // Create error alert
                const alert = document.createElement('div');
                alert.className = 'alert alert-danger';
                alert.innerHTML = `<i class="fas fa-exclamation-circle"></i> ${message}`;

                // Insert before form
                this.form.parentNode.insertBefore(alert, this.form);

                // Remove after 5 seconds
                setTimeout(() => {
                    alert.remove();
                }, 5000);

                // Shake animation
                this.form.style.animation = 'shake 0.5s ease-in-out';
                setTimeout(() => {
                    this.form.style.animation = '';
                }, 500);
            }

            addSubmitAnimation() {
                // Add ripple effect
                const ripple = document.createElement('span');
                ripple.style.cssText = `
                    position: absolute;
                    border-radius: 50%;
                    background: rgba(255, 255, 255, 0.6);
                    transform: scale(0);
                    animation: ripple 0.6s linear;
                    pointer-events: none;
                    width: 100px;
                    height: 100px;
                    left: 50%;
                    top: 50%;
                    margin-left: -50px;
                    margin-top: -50px;
                `;

                this.submitBtn.appendChild(ripple);

                setTimeout(() => {
                    ripple.remove();
                }, 600);
            }

            animatePageLoad() {
                // Animate security score circle
                setTimeout(() => {
                    const scoreCircle = document.querySelector('.score-fill');
                    if (scoreCircle) {
                        scoreCircle.style.strokeDasharray = scoreCircle.getAttribute('stroke-dasharray');
                    }
                }, 500);

                // Animate stats cards
                const statItems = document.querySelectorAll('.stat-item');
                statItems.forEach((item, index) => {
                    item.style.opacity = '0';
                    item.style.transform = 'translateY(20px)';

                    setTimeout(() => {
                        item.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        item.style.opacity = '1';
                        item.style.transform = 'translateY(0)';
                    }, 200 + (index * 100));
                });

                // Animate form elements
                const formGroups = document.querySelectorAll('.form-group');
                formGroups.forEach((group, index) => {
                    group.style.opacity = '0';
                    group.style.transform = 'translateX(20px)';

                    setTimeout(() => {
                        group.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        group.style.opacity = '1';
                        group.style.transform = 'translateX(0)';
                    }, 400 + (index * 150));
                });
            }
        }

        // Initialize when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            new ModernPasswordChanger();
            console.log('🔐 Modern Password Changer initialized');
        });

        // Add CSS animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                25% { transform: translateX(-5px); }
                75% { transform: translateX(5px); }
            }

            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }

            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(30px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/auth/change-password.blade.php ENDPATH**/ ?>