<div class="tab-pane fade" id="geoAnalysis" role="tabpanel">
    <!-- Enhanced Header Section -->
    <div class="geo-header-section mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="geo-title-wrapper">
                    <h4 class="geo-main-title">
                        <i class="fas fa-globe-asia text-primary me-2"></i>
                        تحلیل جغرافیایی و پراکندگی
                    </h4>
                    <p class="geo-subtitle text-muted mb-0">
                        بررسی توزیع جغرافیایی کاربران و مکان‌ها در سراسر کشور
                    </p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="geo-controls d-flex justify-content-end">
                    <div class="btn-group geo-toggle-group me-2" role="group">
                        <button type="button" class="btn btn-outline-primary" data-geography-chart="provinces">
                            <i class="fas fa-map me-1"></i>
                            استان‌ها
                        </button>
                        <button type="button" class="btn btn-outline-primary" data-geography-chart="cities">
                            <i class="fas fa-city me-1"></i>
                            شهرها
                        </button>
                        <button type="button" class="btn btn-outline-primary" data-geography-chart="villages">
                            <i class="fas fa-home me-1"></i>
                            روستاها
                        </button>
                        <button type="button" class="btn btn-outline-primary active" data-geography-chart="heatmap">
                            <i class="fas fa-fire me-1"></i>
                            نقشه حرارتی
                        </button>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog me-1"></i>
                            تنظیمات
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="refreshGeoData()">
                                <i class="fas fa-sync-alt me-2"></i>بروزرسانی داده‌ها
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="exportGeoData('excel')">
                                <i class="fas fa-file-excel me-2"></i>خروجی Excel
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="exportGeoData('pdf')">
                                <i class="fas fa-file-pdf me-2"></i>گزارش PDF
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="#" onclick="showGeoFilters()">
                                <i class="fas fa-filter me-2"></i>فیلترهای پیشرفته
                            </a></li>
                            <li><a class="dropdown-item" href="#" onclick="showGeoComparison()">
                                <i class="fas fa-balance-scale me-2"></i>مقایسه مناطق
                            </a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Geographic Overview Cards -->
    <div class="geo-overview-section mb-4">
        <div class="row">
            <div class="col-md-3">
                <div class="geo-overview-card">
                    <div class="card-icon bg-primary">
                        <i class="fas fa-map-marked-alt"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value"><?php echo e(count($geographicData['provinces']['labels'] ?? [])); ?></div>
                        <div class="card-label">استان فعال</div>
                        <div class="card-trend positive">
                            <i class="fas fa-arrow-up me-1"></i>
                            <?php echo e(round((count($geographicData['provinces']['labels'] ?? []) / 31) * 100)); ?>% پوشش
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="geo-overview-card">
                    <div class="card-icon bg-success">
                        <i class="fas fa-city"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value"><?php echo e(count($geographicData['cities']['labels'] ?? [])); ?></div>
                        <div class="card-label">شهر فعال</div>
                        <div class="card-trend positive">
                            <i class="fas fa-check me-1"></i>
                            در حال رشد
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="geo-overview-card">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-crown"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value"><?php echo e($geographicData['provinces']['labels'][0] ?? 'تهران'); ?></div>
                        <div class="card-label">استان برتر</div>
                        <div class="card-detail"><?php echo e($geographicData['provinces']['percentages'][0] ?? 0); ?>% از کل</div>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="geo-overview-card">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-home"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value"><?php echo e(count($geographicData['villages']['labels'] ?? [])); ?></div>
                        <div class="card-label">روستا فعال</div>
                        <div class="card-trend positive">
                            <i class="fas fa-leaf me-1"></i>
                            روستایی
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="geo-overview-card">
                    <div class="card-icon bg-info">
                        <i class="fas fa-chart-area"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-value"><?php echo e(array_sum($geographicData['provinces']['data'] ?? [0])); ?></div>
                        <div class="card-label">کل مکان‌ها</div>
                        <div class="card-trend positive">
                            <i class="fas fa-plus me-1"></i>
                            در حال افزایش
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Chart Section -->
    <div class="geo-main-section">
        <!-- Provinces Distribution -->
        <div class="geography-chart d-none" id="provinces-chart-container" data-chart-type="provinces">
            <div class="row">
                <div class="col-lg-8 mb-4">
                    <div class="geo-chart-card">
                        <div class="chart-header">
                            <div class="chart-title">
                                <h5 class="mb-1">
                                    <i class="fas fa-map text-primary me-2"></i>
                                    توزیع مکان‌ها بر اساس استان‌ها
                                </h5>
                                <p class="text-muted mb-0">نمایش تعداد و درصد مکان‌های ثبت شده در هر استان</p>
                            </div>
                            <div class="chart-actions">
                                <div class="btn-group btn-group-sm">
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('provinces', 'bar')">
                                        <i class="fas fa-chart-bar"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('provinces', 'pie')">
                                        <i class="fas fa-chart-pie"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('provinces', 'donut')">
                                        <i class="fas fa-circle-notch"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="chart-body">
                            <div id="provinces-chart" class="chart-container"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="geo-ranking-card">
                        <div class="ranking-header">
                            <h6 class="mb-0">
                                <i class="fas fa-trophy text-warning me-2"></i>
                                رتبه‌بندی استان‌ها
                            </h6>
                        </div>
                        <div class="ranking-body">
                            <div id="provinces-top" class="ranking-list">
                                <!-- Provinces data will be inserted here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cities Distribution -->
        <div class="geography-chart d-none" id="cities-chart-container" data-chart-type="cities">
            <div class="row">
                <div class="col-lg-8 mb-4">
                    <div class="geo-chart-card">
                        <div class="chart-header">
                            <div class="chart-title">
                                <h5 class="mb-1">
                                    <i class="fas fa-city text-success me-2"></i>
                                    توزیع مکان‌ها بر اساس شهرها
                                </h5>
                                <p class="text-muted mb-0">نمایش تعداد و درصد مکان‌های ثبت شده در شهرهای مختلف</p>
                            </div>
                            <div class="chart-actions">
                                <div class="btn-group btn-group-sm">
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('cities', 'bar')">
                                        <i class="fas fa-chart-bar"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('cities', 'pie')">
                                        <i class="fas fa-chart-pie"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('cities', 'donut')">
                                        <i class="fas fa-circle-notch"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="chart-body">
                            <div id="cities-chart" class="chart-container"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="geo-ranking-card">
                        <div class="ranking-header">
                            <h6 class="mb-0">
                                <i class="fas fa-medal text-info me-2"></i>
                                رتبه‌بندی شهرها
                            </h6>
                        </div>
                        <div class="ranking-body">
                            <div id="cities-top" class="ranking-list">
                                <!-- Cities data will be inserted here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Villages Distribution -->
        <div class="geography-chart d-none" id="villages-chart-container" data-chart-type="villages">
            <div class="row">
                <div class="col-lg-8 mb-4">
                    <div class="geo-chart-card">
                        <div class="chart-header">
                            <div class="chart-title">
                                <h5 class="mb-1">
                                    <i class="fas fa-home text-warning me-2"></i>
                                    توزیع مکان‌ها بر اساس روستاها
                                </h5>
                                <p class="text-muted mb-0">نمایش تعداد و درصد مکان‌های ثبت شده در روستاهای مختلف</p>
                            </div>
                            <div class="chart-actions">
                                <div class="btn-group btn-group-sm">
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('villages', 'bar')">
                                        <i class="fas fa-chart-bar"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('villages', 'pie')">
                                        <i class="fas fa-chart-pie"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="toggleChartType('villages', 'donut')">
                                        <i class="fas fa-circle-notch"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="chart-body">
                            <div id="villages-chart" class="chart-container"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="geo-ranking-card">
                        <div class="ranking-header">
                            <h6 class="mb-0">
                                <i class="fas fa-leaf text-success me-2"></i>
                                رتبه‌بندی روستاها
                            </h6>
                        </div>
                        <div class="ranking-body">
                            <div id="villages-top" class="ranking-list">
                                <!-- Villages data will be inserted here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Heatmap View -->
        <div class="geography-chart" id="heatmap-container" data-chart-type="heatmap">
            <div class="geo-heatmap-card">
                <div class="heatmap-header">
                    <div class="heatmap-title">
                        <h5 class="mb-1">
                            <i class="fas fa-fire text-danger me-2"></i>
                            نقشه حرارتی توزیع مکان‌ها در ایران
                        </h5>
                        <p class="text-muted mb-0">نمایش تراکم و پراکندگی مکان‌ها بر روی نقشه کشور</p>
                    </div>
                    <div class="heatmap-controls">
                        <div class="btn-group btn-group-sm me-2">
                            <button class="btn btn-outline-primary active" onclick="setHeatmapMode('density')">
                                <i class="fas fa-fire me-1"></i>تراکم
                            </button>
                            <button class="btn btn-outline-primary" onclick="setHeatmapMode('activity')">
                                <i class="fas fa-chart-line me-1"></i>فعالیت
                            </button>
                            <button class="btn btn-outline-primary" onclick="setHeatmapMode('growth')">
                                <i class="fas fa-trending-up me-1"></i>رشد
                            </button>
                        </div>
                        <div class="btn-group btn-group-sm">
                            <button class="btn btn-outline-secondary" onclick="zoomToProvince()">
                                <i class="fas fa-search-plus me-1"></i>زوم استان
                            </button>
                            <button class="btn btn-outline-secondary" onclick="resetMapView()">
                                <i class="fas fa-home me-1"></i>نمای کلی
                            </button>
                            <button class="btn btn-outline-secondary" onclick="toggleMapLayers()">
                                <i class="fas fa-layer-group me-1"></i>لایه‌ها
                            </button>
                        </div>
                    </div>
                </div>
                <div class="heatmap-info-panel">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="info-alert">
                                <i class="fas fa-info-circle text-info me-2"></i>
                                این نقشه بر اساس داده‌های واقعی مکان‌های ثبت شده (مختصات جغرافیایی) و میزان تعامل کاربران ترسیم شده است.
                                رنگ‌های گرم‌تر نشان‌دهنده تراکم بیشتر مکان‌ها می‌باشد.
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="heatmap-legend">
                                <div class="legend-title">راهنمای رنگ‌ها:</div>
                                <div class="legend-items">
                                    <div class="legend-item">
                                        <span class="legend-color" style="background: #ff0000;"></span>
                                        <span class="legend-label">تراکم بالا</span>
                                    </div>
                                    <div class="legend-item">
                                        <span class="legend-color" style="background: #ffff00;"></span>
                                        <span class="legend-label">تراکم متوسط</span>
                                    </div>
                                    <div class="legend-item">
                                        <span class="legend-color" style="background: #0000ff;"></span>
                                        <span class="legend-label">تراکم کم</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="heatmap-body">
                    <div id="iran-heatmap" class="heatmap-container"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters and Analytics Section -->
    <div class="geo-analytics-section mt-4">
        <div class="row">
            <!-- Enhanced Filters Panel -->
            <div class="col-lg-4 mb-4">
                <div class="geo-filters-card">
                    <div class="filters-header">
                        <h6 class="mb-0">
                            <i class="fas fa-filter text-primary me-2"></i>
                            فیلترهای پیشرفته
                        </h6>
                    </div>
                    <div class="filters-body">
                        <div class="filter-group">
                            <label class="filter-label">بازه زمانی</label>
                            <select class="form-select" id="geo-date-range">
                                <option value="7">هفته گذشته</option>
                                <option value="30" selected>ماه گذشته</option>
                                <option value="90">سه ماه گذشته</option>
                                <option value="365">سال گذشته</option>
                                <option value="custom">بازه دلخواه</option>
                            </select>
                        </div>

                        <div class="filter-group">
                            <label class="filter-label">نوع تحلیل</label>
                            <select class="form-select" id="geo-analysis-type">
                                <option value="locations" selected>تعداد مکان‌ها</option>
                                <option value="users">تعداد کاربران</option>
                                <option value="activity">میزان فعالیت</option>
                                <option value="growth">نرخ رشد</option>
                            </select>
                        </div>

                        <div class="filter-group">
                            <label class="filter-label">دسته‌بندی</label>
                            <select class="form-select" id="geo-category-filter">
                                <option value="all" selected>همه دسته‌ها</option>
                                <?php if(isset($categoryAnalytics['distribution']['labels'])): ?>
                                    <?php $__currentLoopData = $categoryAnalytics['distribution']['labels']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category); ?>"><?php echo e($category); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="filter-group">
                            <label class="filter-label">حداقل تعداد</label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="geo-min-count" value="1" min="1">
                                <span class="input-group-text">مکان</span>
                            </div>
                        </div>

                        <div class="filter-actions">
                            <button class="btn btn-primary w-100 mb-2" id="apply-geo-filters">
                                <i class="fas fa-search me-1"></i>
                                اعمال فیلترها
                            </button>
                            <button class="btn btn-outline-secondary w-100" onclick="resetGeoFilters()">
                                <i class="fas fa-undo me-1"></i>
                                بازنشانی
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Insights and Analytics Panel -->
            <div class="col-lg-8 mb-4">
                <div class="geo-insights-card">
                    <div class="insights-header">
                        <h6 class="mb-0">
                            <i class="fas fa-lightbulb text-warning me-2"></i>
                            تحلیل‌ها و بینش‌های هوشمند
                        </h6>
                        <div class="insights-actions">
                            <button class="btn btn-sm btn-outline-primary" onclick="refreshInsights()">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" onclick="exportInsights()">
                                <i class="fas fa-download"></i>
                            </button>
                        </div>
                    </div>
                    <div class="insights-body">
                        <div id="geo-insights" class="insights-content">
                            <?php if(isset($geographicData['insights']) && !empty($geographicData['insights'])): ?>
                                <?php $__currentLoopData = $geographicData['insights']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="insight-item <?php echo e($insight['type']); ?>">
                                        <div class="insight-icon">
                                            <i class="fas fa-<?php echo e($insight['icon']); ?>"></i>
                                        </div>
                                        <div class="insight-content">
                                            <div class="insight-text"><?php echo e($insight['text']); ?></div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="insight-item info">
                                    <div class="insight-icon">
                                        <i class="fas fa-crown"></i>
                                    </div>
                                    <div class="insight-content">
                                        <div class="insight-title">استان برتر</div>
                                        <div class="insight-text">
                                            بیشترین فعالیت از استان <?php echo e($geographicData['provinces']['labels'][0] ?? 'تهران'); ?>

                                            با <?php echo e($geographicData['provinces']['percentages'][0] ?? '0'); ?>% از کل مکان‌ها
                                        </div>
                                    </div>
                                </div>

                                <?php if(isset($geographicData['growth'])): ?>
                                    <?php $__currentLoopData = $geographicData['growth']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provinceGrowth): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($provinceGrowth['growth'] > 0): ?>
                                            <div class="insight-item success">
                                                <div class="insight-icon">
                                                    <i class="fas fa-trending-up"></i>
                                                </div>
                                                <div class="insight-content">
                                                    <div class="insight-title">رشد مثبت</div>
                                                    <div class="insight-text">
                                                        رشد <?php echo e(abs($provinceGrowth['growth'])); ?>% در استان <?php echo e($provinceGrowth['province']); ?> نسبت به ماه قبل
                                                    </div>
                                                </div>
                                            </div>
                                            <?php break; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php $__currentLoopData = $geographicData['growth']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provinceGrowth): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($provinceGrowth['growth'] < 0): ?>
                                            <div class="insight-item warning">
                                                <div class="insight-icon">
                                                    <i class="fas fa-trending-down"></i>
                                                </div>
                                                <div class="insight-content">
                                                    <div class="insight-title">نیاز به توجه</div>
                                                    <div class="insight-text">
                                                        کاهش <?php echo e(abs($provinceGrowth['growth'])); ?>% در فعالیت استان <?php echo e($provinceGrowth['province']); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <?php break; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <!-- Additional Smart Insights -->
                                <div class="insight-item info">
                                    <div class="insight-icon">
                                        <i class="fas fa-chart-pie"></i>
                                    </div>
                                    <div class="insight-content">
                                        <div class="insight-title">توزیع جغرافیایی</div>
                                        <div class="insight-text">
                                            <?php echo e(count($geographicData['provinces']['labels'] ?? [])); ?> استان و
                                            <?php echo e(count($geographicData['cities']['labels'] ?? [])); ?> شهر در سیستم فعال هستند
                                        </div>
                                    </div>
                                </div>

                                <div class="insight-item success">
                                    <div class="insight-icon">
                                        <i class="fas fa-bullseye"></i>
                                    </div>
                                    <div class="insight-content">
                                        <div class="insight-title">فرصت بازاریابی</div>
                                        <div class="insight-text">
                                            استان‌های با پتانسیل رشد بالا برای تمرکز بیشتر شناسایی شده‌اند
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- روند رشد در دوره‌های زمانی مختلف -->
    <div class="row mt-4">
        <div class="col-md-12 mb-4">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">روند رشد زمانی</h6>
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-outline-primary active" data-time-period="daily">روزانه</button>
                        <button type="button" class="btn btn-sm btn-outline-primary" data-time-period="weekly">هفتگی</button>
                        <button type="button" class="btn btn-sm btn-outline-primary" data-time-period="monthly">ماهانه</button>
                        <button type="button" class="btn btn-sm btn-outline-primary" data-time-period="yearly">سالانه</button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <div id="time-growth-chart" style="height: 350px;"></div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-4">
                            <div class="card bg-primary text-white shadow">
                                <div class="card-body">
                                    <div class="text-xs font-weight-bold text-uppercase mb-1">تعداد کل</div>
                                    <div class="h5 mb-0 font-weight-bold" id="time-total-count">0</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-success text-white shadow">
                                <div class="card-body">
                                    <div class="text-xs font-weight-bold text-uppercase mb-1">میانگین رشد</div>
                                    <div class="h5 mb-0 font-weight-bold" id="time-avg-growth">0%</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-info text-white shadow">
                                <div class="card-body">
                                    <div class="text-xs font-weight-bold text-uppercase mb-1">بیشترین رشد</div>
                                    <div class="h5 mb-0 font-weight-bold" id="time-max-growth">0%</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle between different geography chart types
    document.querySelectorAll('[data-geography-chart]').forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('[data-geography-chart]').forEach(btn => {
                btn.classList.remove('active');
            });

            // Add active class to clicked button
            this.classList.add('active');

            // Hide all chart containers
            document.querySelectorAll('.geography-chart').forEach(container => {
                container.classList.add('d-none');
            });

            // Show the selected chart containers
            const chartType = this.getAttribute('data-geography-chart');
            document.querySelectorAll(`[data-chart-type="${chartType}"]`).forEach(container => {
                container.classList.remove('d-none');
            });

            // Initialize or refresh the visible charts with timeout for DOM to update
            setTimeout(() => {
                initGeographyCharts(chartType);
            }, 100);
        });
    });

    // برای نمایش درست نقشه حرارتی در بارگذاری اولیه صفحه
    setTimeout(() => {
        // ابتدا همه کانتینرها را مخفی کنیم
        document.querySelectorAll('.geography-chart').forEach(container => {
            container.classList.add('d-none');
        });

        // حالا تنها کانتینر مربوط به دکمه فعال را نمایش دهیم
        const activeButton = document.querySelector('[data-geography-chart].active');
        const activeChartType = activeButton ? activeButton.getAttribute('data-geography-chart') : 'heatmap';

        document.querySelectorAll(`[data-chart-type="${activeChartType}"]`).forEach(container => {
            container.classList.remove('d-none');
        });

        // و سپس چارت مربوطه را راه‌اندازی کنیم
        initGeographyCharts(activeChartType);
    }, 200);

    // Apply geography filters
    document.getElementById('apply-geo-filters').addEventListener('click', function() {
        const dateRange = document.getElementById('geo-date-range').value;
        const userType = document.getElementById('geo-user-type').value;

        // Get the currently active chart type
        const activeChartType = document.querySelector('[data-geography-chart].active').getAttribute('data-geography-chart');

        // Apply filters and refresh charts
        applyGeoFilters(dateRange, userType, activeChartType);
    });

    // راه‌اندازی نمودار رشد زمانی در بارگذاری صفحه
    renderTimeGrowthChart('daily');

    // اضافه کردن رویداد کلیک به دکمه‌های دوره زمانی
    document.querySelectorAll('[data-time-period]').forEach(button => {
        button.addEventListener('click', function() {
            // حذف کلاس active از همه دکمه‌ها
            document.querySelectorAll('[data-time-period]').forEach(btn => {
                btn.classList.remove('active');
            });

            // اضافه کردن کلاس active به دکمه کلیک شده
            this.classList.add('active');

            // نمایش نمودار مربوطه
            const period = this.getAttribute('data-time-period');
            renderTimeGrowthChart(period);
        });
    });
});

function initGeographyCharts(chartType) {
    if (chartType === 'provinces') {
        // Clear existing chart before rendering new one
        document.querySelector("#provinces-chart").innerHTML = '';
        renderProvincesChart();
        renderTopProvinces();
    } else if (chartType === 'cities') {
        // Clear existing chart before rendering new one
        document.querySelector("#cities-chart").innerHTML = '';
        renderCitiesChart();
        renderTopCities();
    } else if (chartType === 'villages') {
        // Clear existing chart before rendering new one
        document.querySelector("#villages-chart").innerHTML = '';
        renderVillagesChart();
        renderTopVillages();
    } else if (chartType === 'heatmap') {
        renderIranHeatmap();
    }
}

function applyGeoFilters(dateRange, userType, chartType) {
    // Add loading indicator
    const insightsContainer = document.getElementById('geo-insights');
    if (insightsContainer) {
        insightsContainer.innerHTML = `
            <div class="alert alert-info">
                <i class="fas fa-spinner fa-spin"></i>
                در حال بارگذاری اطلاعات...
            </div>
        `;
    }

    // نمایش وضعیت بارگذاری برای نمودار رشد زمانی
    document.getElementById('time-growth-chart').innerHTML = `
        <div class="d-flex justify-content-center align-items-center h-100">
            <div class="spinner-border text-primary" role="status">
                <span class="sr-only">در حال بارگذاری...</span>
            </div>
            <span class="mr-2">در حال بارگذاری اطلاعات...</span>
        </div>
    `;

    // Make an AJAX request to fetch filtered data
    fetch(`<?php echo e(route('admin.analytics.geo-filter')); ?>?date_range=${dateRange}&user_type=${userType}`, {
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'X-Requested-With': 'XMLHttpRequest',
        }
    })
    .then(response => response.json())
    .then(data => {
        console.log('Geo filter data received:', data);

        // Update the global geographicData variable with new data
        window.filteredGeoData = data;

        // Update the insights based on the new data
        updateGeoInsights(data.insights);

        // Refresh the appropriate chart
        if (chartType === 'provinces') {
            renderFilteredProvincesChart(data.provinces);
            renderFilteredTopProvinces(data.provinces);
        } else if (chartType === 'cities') {
            renderFilteredCitiesChart(data.cities);
            renderFilteredTopCities(data.cities);
        } else if (chartType === 'heatmap') {
            // If the heatmap is already initialized, update it
            if (window.iranHeatmap) {
                // Remove existing heat layer if it exists
                if (window.heatLayer) {
                    window.iranHeatmap.removeLayer(window.heatLayer);
                    window.heatLayer = null;
                }

                // Make sure map is properly sized (in case it was hidden)
                window.iranHeatmap.invalidateSize(true);

                // Process the new heat data
                const heatData = data.heatmap || [];
                if (heatData.length > 0) {
                    try {
                        const heat = createOptimizedHeatLayer(heatData, {
                            radius: 25,
                            blur: 15,
                            maxZoom: 10,
                            minOpacity: 0.3
                        });

                        if (heat) {
                            window.heatLayer = heat;
                            heat.addTo(window.iranHeatmap);
                        }

                        console.log('Heat layer updated with filtered data');
                    } catch (error) {
                        console.error('Error updating heat layer:', error);
                    }
                } else {
                    // Show no data message if no heat points
                    const noDataControl = L.control({position: 'bottomleft'});
                    noDataControl.onAdd = function() {
                        const div = L.DomUtil.create('div', 'info');
                        div.innerHTML = '<div class="alert alert-warning p-2">داده‌ای برای نمایش با فیلترهای انتخابی وجود ندارد</div>';
                        return div;
                    };
                    noDataControl.addTo(window.iranHeatmap);
                }
            } else {
                // If heatmap not initialized, store the data for later and try to initialize
                window.heatLayerData = data.heatmap;
                renderIranHeatmap();
            }
        }

        // به‌روزرسانی نمودار روند رشد زمانی با داده‌های جدید
        if (data.time_growth) {
            // دریافت دوره زمانی فعال
            const activeTimePeriod = document.querySelector('[data-time-period].active').getAttribute('data-time-period');
            renderFilteredTimeGrowthChart(activeTimePeriod, data.time_growth);
        }
    })
    .catch(error => {
        console.error('Error fetching filtered data:', error);
        // Show error message
        const insights = document.getElementById('geo-insights');
        if (insights) {
            insights.innerHTML = `
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    خطا در دریافت اطلاعات. لطفاً مجدداً تلاش کنید.
                </div>
            `;
        }

        // نمایش پیام خطا در نمودار رشد زمانی
        document.getElementById('time-growth-chart').innerHTML = `
            <div class="alert alert-danger text-center">
                <i class="fas fa-exclamation-circle"></i>
                خطا در دریافت اطلاعات. لطفاً مجدداً تلاش کنید.
            </div>
        `;
    });
}

function updateGeoInsights(insights) {
    // Update the insights panel with new data
    const insightsContainer = document.getElementById('geo-insights');
    if (!insightsContainer) {
        console.error('Insights container not found');
        return;
    }

    if (!insights || insights.length === 0) {
        // If no insights are provided, calculate some basic ones
        try {
            const provinceLabels = <?php echo json_encode($geographicData['provinces']['labels'] ?? [], 15, 512) ?>;
            const provinceCounts = <?php echo json_encode($geographicData['provinces']['data'] ?? [], 15, 512) ?>;

            if (provinceLabels.length === 0 || provinceCounts.length === 0) {
                insightsContainer.innerHTML = `
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        داده کافی برای تحلیل وجود ندارد.
                    </div>
                `;
                return;
            }

            const totalLocations = provinceCounts.reduce((acc, curr) => acc + curr, 0);

            // Get the top province
            const topProvinceIndex = provinceCounts.indexOf(Math.max(...provinceCounts));
            const topProvince = provinceLabels[topProvinceIndex];
            const topProvincePercentage = Math.round((provinceCounts[topProvinceIndex] / totalLocations * 100) * 10) / 10;

            // Current month vs previous month comparison for top province
            // Use the data directly from the geographicData object
            const currentMonthData = <?php echo json_encode($geographicData['provinces']['current_month_data'] ?? [], 15, 512) ?>;
            const previousMonthData = <?php echo json_encode($geographicData['provinces']['previous_month_data'] ?? [], 15, 512) ?>;

            let insightHTML = '';

            // Top province insight
            insightHTML += `
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    بیشترین مکان‌ها در استان ${topProvince} با ${topProvincePercentage}% از کل مکان‌ها می‌باشد.
                </div>
            `;

            // Growth insights
            if (Object.keys(currentMonthData).length > 0 && Object.keys(previousMonthData).length > 0) {
                let maxGrowthProvince = '';
                let maxGrowthValue = -Infinity;
                let maxDeclineProvince = '';
                let maxDeclineValue = Infinity;

                for (const province of provinceLabels) {
                    const current = currentMonthData[province] ?? 0;
                    const previous = previousMonthData[province] ?? 0;

                    if (previous > 0) {
                        const growthRate = (current - previous) / previous * 100;

                        if (growthRate > maxGrowthValue) {
                            maxGrowthValue = growthRate;
                            maxGrowthProvince = province;
                        }

                        if (growthRate < maxDeclineValue) {
                            maxDeclineValue = growthRate;
                            maxDeclineProvince = province;
                        }
                    }
                }

                if (maxGrowthProvince && maxGrowthValue > 0) {
                    insightHTML += `
                        <div class="alert alert-success">
                            <i class="fas fa-chart-line"></i>
                            رشد ${Math.round(maxGrowthValue * 10) / 10}% در تعداد مکان‌ها از استان ${maxGrowthProvince} نسبت به ماه قبل.
                        </div>
                    `;
                }

                if (maxDeclineProvince && maxDeclineValue < 0) {
                    insightHTML += `
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            کاهش ${Math.abs(Math.round(maxDeclineValue * 10) / 10)}% در تعداد مکان‌ها از استان ${maxDeclineProvince}.
                        </div>
                    `;
                }
            } else {
                insightHTML += `
                    <div class="alert alert-secondary">
                        <i class="fas fa-info-circle"></i>
                        داده کافی برای محاسبه روند رشد وجود ندارد.
                    </div>
                `;
            }

            insightsContainer.innerHTML = insightHTML;

        } catch (error) {
            console.error('Error generating insights:', error);
            insightsContainer.innerHTML = `
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-circle"></i>
                    خطا در تحلیل داده‌ها.
                </div>
            `;
        }
    } else {
        // If insights are provided by the server, use them
        let insightHTML = '';

        insights.forEach(insight => {
            insightHTML += `
                <div class="alert alert-${insight.type}">
                    <i class="fas fa-${insight.icon}"></i>
                    ${insight.text}
                </div>
            `;
        });

        insightsContainer.innerHTML = insightHTML;
    }
}

function renderProvincesChart() {
    // Use real data from the server via the geographicData variable
    const provincesData = <?php echo json_encode($geographicData['provinces']['data'] ?? [], 15, 512) ?>;
    const provinceLabels = <?php echo json_encode($geographicData['provinces']['labels'] ?? [], 15, 512) ?>;

    // Calculate percentages for the chart
    const totalLocations = provincesData.reduce((acc, curr) => acc + curr, 0);
    const provincePercentages = provincesData.map(count => {
        return Math.round((count / totalLocations * 100) * 10) / 10; // Round to 1 decimal place
    });

    const options = {
        series: [{
            name: 'درصد مکان‌ها',
            data: provincePercentages
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                distributed: true,
                barHeight: '70%',
                dataLabels: {
                    position: 'bottom'
                }
            }
        },
        colors: ['#33b2df', '#546E7A', '#d4526e', '#13d8aa', '#A5978B', '#2b908f', '#f9a3a4', '#90ee7e', '#f48024', '#69d2e7'],
        dataLabels: {
            enabled: true,
            textAnchor: 'start',
            style: {
                colors: ['#fff']
            },
            formatter: function(val, opt) {
                return val + '%';
            },
            offsetX: 0,
            dropShadow: {
                enabled: true
            }
        },
        stroke: {
            width: 1,
            colors: ['#fff']
        },
        xaxis: {
            categories: provinceLabels,
        },
        yaxis: {
            labels: {
                show: false
            }
        },
        tooltip: {
            theme: 'dark',
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: function() {
                        return 'درصد مکان‌ها';
                    }
                },
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    // Check if element exists before rendering
    const chartElement = document.querySelector("#provinces-chart");
    if (chartElement) {
        // Destroy any existing chart to prevent duplicates
        if (window.provincesChart) {
            window.provincesChart.destroy();
        }

        // Create new chart and store reference
        window.provincesChart = new ApexCharts(chartElement, options);
        window.provincesChart.render();
    } else {
        console.error('Chart element not found');
    }
}

function renderTopProvinces() {
    // Get real data for top provinces
    const provinceLabels = <?php echo json_encode($geographicData['provinces']['labels'] ?? [], 15, 512) ?>;
    const provinceCounts = <?php echo json_encode($geographicData['provinces']['data'] ?? [], 15, 512) ?>;

    // Use only top 5 provinces
    const topCount = Math.min(5, provinceLabels.length);
    const totalLocations = provinceCounts.reduce((acc, curr) => acc + curr, 0);

    const topProvinces = [];

    // Get current and previous month data for trends calculation
    const currentMonthData = <?php echo json_encode($geographicData['provinces']['current_month_data'] ?? [], 15, 512) ?>;
    const previousMonthData = <?php echo json_encode($geographicData['provinces']['previous_month_data'] ?? [], 15, 512) ?>;

    for (let i = 0; i < topCount; i++) {
        const province = provinceLabels[i];
        const count = provinceCounts[i];
        const percentage = Math.round((count / totalLocations * 100) * 10) / 10;

        // Calculate trend
        const current = currentMonthData[province] ?? 0;
        const previous = previousMonthData[province] ?? 0;
        let trend = '0%';
        let trendClass = 'text-secondary';

        if (previous > 0) {
            const trendValue = Math.round(((current - previous) / previous * 100) * 10) / 10;
            if (trendValue > 0) {
                trend = '+' + trendValue + '%';
                trendClass = 'text-success';
            } else if (trendValue < 0) {
                trend = trendValue + '%';
                trendClass = 'text-danger';
            }
        } else if (current > 0) {
            trend = '+100%';
            trendClass = 'text-success';
        }

        topProvinces.push({
            province: province,
            count: percentage,
            trend: trend,
            class: trendClass
        });
    }

    const provincesList = document.querySelector('#provinces-top .list-group');
    if (!provincesList) {
        console.error('Provinces list element not found');
        return;
    }

    let listHTML = '';

    if (topProvinces.length === 0) {
        listHTML = `<div class="alert alert-info">داده‌ای برای نمایش وجود ندارد.</div>`;
    } else {
        topProvinces.forEach((item, index) => {
            listHTML += `
                <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                    <div>
                        <span class="badge badge-primary badge-pill mr-2">${index + 1}</span>
                        ${item.province}
                    </div>
                    <div>
                        <span class="badge badge-light badge-pill">${item.count}%</span>
                        <span class="${item.class} mr-2"><i class="fas ${item.trend.includes('+') ? 'fa-arrow-up' : 'fa-arrow-down'}"></i> ${item.trend}</span>
                    </div>
                </a>
            `;
        });
    }

    provincesList.innerHTML = listHTML;
}

function renderCitiesChart() {
    // Use real data from the server via the geographicData variable
    const citiesData = <?php echo json_encode($geographicData['cities']['data'] ?? [], 15, 512) ?>;
    const cityLabels = <?php echo json_encode($geographicData['cities']['labels'] ?? [], 15, 512) ?>;

    // Calculate percentages for the chart
    const totalLocations = citiesData.reduce((acc, curr) => acc + curr, 0);
    const cityPercentages = citiesData.map(count => {
        return Math.round((count / totalLocations * 100) * 10) / 10; // Round to 1 decimal place
    });

    const options = {
        series: [{
            name: 'درصد مکان‌ها',
            data: cityPercentages
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                distributed: true,
                barHeight: '70%',
                dataLabels: {
                    position: 'bottom'
                }
            }
        },
        colors: ['#33b2df', '#546E7A', '#d4526e', '#13d8aa', '#A5978B', '#2b908f', '#f9a3a4', '#90ee7e', '#f48024', '#69d2e7'],
        dataLabels: {
            enabled: true,
            textAnchor: 'start',
            style: {
                colors: ['#fff']
            },
            formatter: function(val, opt) {
                return val + '%';
            },
            offsetX: 0,
            dropShadow: {
                enabled: true
            }
        },
        stroke: {
            width: 1,
            colors: ['#fff']
        },
        xaxis: {
            categories: cityLabels,
        },
        yaxis: {
            labels: {
                show: false
            }
        },
        tooltip: {
            theme: 'dark',
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: function() {
                        return 'درصد مکان‌ها';
                    }
                },
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    const chartElement = document.querySelector("#cities-chart");
    if (chartElement) {
        // Destroy any existing chart to prevent duplicates
        if (window.citiesChart) {
            window.citiesChart.destroy();
        }

        // Create new chart and store reference
        window.citiesChart = new ApexCharts(chartElement, options);
        window.citiesChart.render();
    } else {
        console.error('Chart element not found');
    }
}

function renderTopCities() {
    // Get real data for top cities
    const cityLabels = <?php echo json_encode($geographicData['cities']['labels'] ?? [], 15, 512) ?>;
    const cityCounts = <?php echo json_encode($geographicData['cities']['data'] ?? [], 15, 512) ?>;

    // Use only top 5 cities
    const topCount = Math.min(5, cityLabels.length);
    const totalLocations = cityCounts.reduce((acc, curr) => acc + curr, 0);

    const topCities = [];

    // For trends, we don't have current/previous month data for cities in this simplified version
    // So we'll just show percentages

    for (let i = 0; i < topCount; i++) {
        const city = cityLabels[i];
        const count = cityCounts[i];
        const percentage = Math.round((count / totalLocations * 100) * 10) / 10;

        topCities.push({
            city: city,
            count: percentage,
            trend: '', // No trend data available
            class: 'text-secondary'
        });
    }

    const citiesList = document.querySelector('#cities-top .list-group');
    if (!citiesList) {
        console.error('Cities list element not found');
        return;
    }

    let listHTML = '';

    if (topCities.length === 0) {
        listHTML = `<div class="alert alert-info">داده‌ای برای نمایش وجود ندارد.</div>`;
    } else {
        topCities.forEach((item, index) => {
            listHTML += `
                <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                    <div>
                        <span class="badge badge-primary badge-pill mr-2">${index + 1}</span>
                        ${item.city}
                    </div>
                    <div>
                        <span class="badge badge-light badge-pill">${item.count}%</span>
                    </div>
                </a>
            `;
        });
    }

    citiesList.innerHTML = listHTML;
}

function renderIranHeatmap() {
    try {
        console.log('Starting heatmap rendering from geography_analysis.blade.php...');

        // اگر تابع renderIranHeatmap در window وجود دارد، از آن استفاده می‌کنیم
        if (typeof window.renderIranHeatmap === 'function') {
            console.log('Calling main renderIranHeatmap function from window...');
            // با تاخیر فراخوانی کنیم تا مطمئن شویم DOM آماده است
            setTimeout(() => {
                window.renderIranHeatmap();
            }, 200);
        } else {
            // اگر تابع اصلی وجود ندارد، یک پیام خطا نمایش دهیم
            console.error('Main renderIranHeatmap function not found in window object');
            const mapContainer = document.getElementById('iran-heatmap');
            if (mapContainer) {
                mapContainer.innerHTML = `
                    <div class="alert alert-warning text-center p-5">
                        <h4>خطا در بارگذاری نقشه</h4>
                        <p>تابع اصلی نقشه حرارتی موجود نیست. لطفاً صفحه را مجدداً بارگذاری کنید.</p>
                    </div>
                `;
            }
        }
    } catch (error) {
        console.error('Fatal error in renderIranHeatmap from geography_analysis.blade.php:', error);
    }
}

function renderFilteredProvincesChart(provinceData) {
    // Calculate percentages for the chart
    const totalLocations = provinceData.data.reduce((acc, curr) => acc + curr, 0);
    const provincePercentages = provinceData.data.map(count => {
        return Math.round((count / totalLocations * 100) * 10) / 10; // Round to 1 decimal place
    });

    const options = {
        series: [{
            name: 'درصد مکان‌ها',
            data: provincePercentages
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                distributed: true,
                barHeight: '70%',
                dataLabels: {
                    position: 'bottom'
                }
            }
        },
        colors: ['#33b2df', '#546E7A', '#d4526e', '#13d8aa', '#A5978B', '#2b908f', '#f9a3a4', '#90ee7e', '#f48024', '#69d2e7'],
        dataLabels: {
            enabled: true,
            textAnchor: 'start',
            style: {
                colors: ['#fff']
            },
            formatter: function(val, opt) {
                return val + '%';
            },
            offsetX: 0,
            dropShadow: {
                enabled: true
            }
        },
        stroke: {
            width: 1,
            colors: ['#fff']
        },
        xaxis: {
            categories: provinceData.labels,
        },
        yaxis: {
            labels: {
                show: false
            }
        },
        tooltip: {
            theme: 'dark',
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: function() {
                        return 'درصد مکان‌ها';
                    }
                },
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    // Check if element exists
    const chartElement = document.querySelector("#provinces-chart");
    if (chartElement) {
        // Destroy any existing chart to prevent duplicates
        if (window.provincesChart) {
            window.provincesChart.destroy();
        }

        // Create new chart and store reference
        window.provincesChart = new ApexCharts(chartElement, options);
        window.provincesChart.render();
    } else {
        console.error('Chart element not found');
    }
}

function renderFilteredTopProvinces(provinceData) {
    // Use only top 5 provinces
    const topCount = Math.min(5, provinceData.labels.length);
    const totalLocations = provinceData.data.reduce((acc, curr) => acc + curr, 0);

    const topProvinces = [];

    for (let i = 0; i < topCount; i++) {
        const province = provinceData.labels[i];
        const count = provinceData.data[i];
        const percentage = Math.round((count / totalLocations * 100) * 10) / 10;

        topProvinces.push({
            province: province,
            count: percentage,
        });
    }

    const provincesList = document.querySelector('#provinces-top .list-group');
    let listHTML = '';

    if (topProvinces.length === 0) {
        listHTML = `<div class="alert alert-info">داده‌ای برای نمایش وجود ندارد.</div>`;
    } else {
        topProvinces.forEach((item, index) => {
            listHTML += `
                <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                    <div>
                        <span class="badge badge-primary badge-pill mr-2">${index + 1}</span>
                        ${item.province}
                    </div>
                    <div>
                        <span class="badge badge-light badge-pill">${item.count}%</span>
                    </div>
                </a>
            `;
        });
    }

    provincesList.innerHTML = listHTML;
}

function renderFilteredCitiesChart(cityData) {
    // Calculate percentages for the chart
    const totalLocations = cityData.data.reduce((acc, curr) => acc + curr, 0);
    const cityPercentages = cityData.data.map(count => {
        return Math.round((count / totalLocations * 100) * 10) / 10; // Round to 1 decimal place
    });

    const options = {
        series: [{
            name: 'درصد مکان‌ها',
            data: cityPercentages
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                distributed: true,
                barHeight: '70%',
                dataLabels: {
                    position: 'bottom'
                }
            }
        },
        colors: ['#33b2df', '#546E7A', '#d4526e', '#13d8aa', '#A5978B', '#2b908f', '#f9a3a4', '#90ee7e', '#f48024', '#69d2e7'],
        dataLabels: {
            enabled: true,
            textAnchor: 'start',
            style: {
                colors: ['#fff']
            },
            formatter: function(val, opt) {
                return val + '%';
            },
            offsetX: 0,
            dropShadow: {
                enabled: true
            }
        },
        stroke: {
            width: 1,
            colors: ['#fff']
        },
        xaxis: {
            categories: cityData.labels,
        },
        yaxis: {
            labels: {
                show: false
            }
        },
        tooltip: {
            theme: 'dark',
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: function() {
                        return 'درصد مکان‌ها';
                    }
                },
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    // Check if element exists
    const chartElement = document.querySelector("#cities-chart");
    if (chartElement) {
        // Destroy any existing chart to prevent duplicates
        if (window.citiesChart) {
            window.citiesChart.destroy();
        }

        // Create new chart and store reference
        window.citiesChart = new ApexCharts(chartElement, options);
        window.citiesChart.render();
    } else {
        console.error('Chart element not found');
    }
}

function renderFilteredTopCities(cityData) {
    // Use only top 5 cities
    const topCount = Math.min(5, cityData.labels.length);
    const totalLocations = cityData.data.reduce((acc, curr) => acc + curr, 0);

    const topCities = [];

    for (let i = 0; i < topCount; i++) {
        const city = cityData.labels[i];
        const count = cityData.data[i];
        const percentage = Math.round((count / totalLocations * 100) * 10) / 10;

        topCities.push({
            city: city,
            count: percentage,
            trend: 'N/A', // Trend not available for filtered data
            class: 'text-secondary'
        });
    }

    const citiesList = document.querySelector('#cities-top .list-group');
    let listHTML = '';

    if (topCities.length === 0) {
        listHTML = `<div class="alert alert-info">داده‌ای برای نمایش وجود ندارد.</div>`;
    } else {
        topCities.forEach((item, index) => {
            listHTML += `
                <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                    <div>
                        <span class="badge badge-primary badge-pill mr-2">${index + 1}</span>
                        ${item.city}
                    </div>
                    <div>
                        <span class="badge badge-light badge-pill">${item.count}%</span>
                    </div>
                </a>
            `;
        });
    }

    citiesList.innerHTML = listHTML;
}

// نمایش نمودار رشد زمانی براساس دوره زمانی
function renderTimeGrowthChart(period) {
    // دریافت داده‌ها براساس دوره زمانی
    const timeGrowthData = <?php echo json_encode($geographicData['time_growth'] ?? [], 15, 512) ?>;

    if (!timeGrowthData || !timeGrowthData[period]) {
        console.error(`No data available for time period: ${period}`);
        return;
    }

    const chartData = timeGrowthData[period];
    const chartElement = document.getElementById('time-growth-chart');

    if (!chartElement) {
        console.error('Time growth chart element not found');
        return;
    }

    // محاسبه مقادیر آماری
    const totalCount = chartData.data.reduce((sum, count) => sum + count, 0);
    const growthValues = chartData.growth.filter(g => !isNaN(g));
    const avgGrowth = growthValues.length > 0
        ? Math.round(growthValues.reduce((sum, g) => sum + g, 0) / growthValues.length * 10) / 10
        : 0;
    const maxGrowth = growthValues.length > 0
        ? Math.round(Math.max(...growthValues) * 10) / 10
        : 0;

    // نمایش مقادیر آماری
    document.getElementById('time-total-count').textContent = totalCount.toLocaleString();
    document.getElementById('time-avg-growth').textContent = avgGrowth + '%';
    document.getElementById('time-max-growth').textContent = maxGrowth + '%';

    // پاکسازی نمودار قبلی
    chartElement.innerHTML = '';

    // ایجاد نمودار جدید
    const options = {
        series: [{
            name: 'تعداد',
            type: 'column',
            data: chartData.data
        }, {
            name: 'درصد رشد',
            type: 'line',
            data: chartData.growth
        }],
        chart: {
            height: 350,
            type: 'line',
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: true,
                tools: {
                    download: true,
                    selection: true,
                    zoom: true,
                    zoomin: true,
                    zoomout: true,
                    pan: true,
                    reset: true
                }
            }
        },
        stroke: {
            width: [0, 3]
        },
        dataLabels: {
            enabled: true,
            enabledOnSeries: [1],
            formatter: function (val) {
                return val + '%';
            }
        },
        labels: chartData.labels,
        colors: ['#4e73df', '#1cc88a'],
        title: {
            text: getPeriodTitle(period),
            align: 'center',
            style: {
                fontSize: '16px',
                fontWeight: 'bold',
                fontFamily: 'IRANSans, tahoma, sans-serif'
            }
        },
        yaxis: [
            {
                title: {
                    text: 'تعداد',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            {
                opposite: true,
                title: {
                    text: 'درصد رشد',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            }
        ],
        tooltip: {
            y: {
                formatter: function(value, { series, seriesIndex, dataPointIndex, w }) {
                    if (seriesIndex === 0) {
                        return value.toLocaleString() + ' مورد';
                    } else {
                        return value + '%';
                    }
                }
            }
        }
    };

    // ایجاد و نمایش نمودار
    if (window.timeGrowthChart) {
        window.timeGrowthChart.destroy();
    }

    window.timeGrowthChart = new ApexCharts(chartElement, options);
    window.timeGrowthChart.render();
}

// تابع کمکی برای نمایش عنوان دوره زمانی
function getPeriodTitle(period) {
    switch(period) {
        case 'daily':
            return 'روند رشد روزانه (30 روز اخیر)';
        case 'weekly':
            return 'روند رشد هفتگی (12 هفته اخیر)';
        case 'monthly':
            return 'روند رشد ماهانه (12 ماه اخیر)';
        case 'yearly':
            return 'روند رشد سالانه (5 سال اخیر)';
        default:
            return 'روند رشد';
    }
}

// تابع نمایش نمودار رشد زمانی با داده‌های فیلتر شده
function renderFilteredTimeGrowthChart(period, timeGrowthData) {
    if (!timeGrowthData || !timeGrowthData[period]) {
        console.error(`No filtered data available for time period: ${period}`);
        return;
    }

    const chartData = timeGrowthData[period];
    const chartElement = document.getElementById('time-growth-chart');

    if (!chartElement) {
        console.error('Time growth chart element not found');
        return;
    }

    // محاسبه مقادیر آماری
    const totalCount = chartData.data.reduce((sum, count) => sum + count, 0);
    const growthValues = chartData.growth.filter(g => !isNaN(g));
    const avgGrowth = growthValues.length > 0
        ? Math.round(growthValues.reduce((sum, g) => sum + g, 0) / growthValues.length * 10) / 10
        : 0;
    const maxGrowth = growthValues.length > 0
        ? Math.round(Math.max(...growthValues) * 10) / 10
        : 0;

    // نمایش مقادیر آماری
    document.getElementById('time-total-count').textContent = totalCount.toLocaleString();
    document.getElementById('time-avg-growth').textContent = avgGrowth + '%';
    document.getElementById('time-max-growth').textContent = maxGrowth + '%';

    // پاکسازی نمودار قبلی
    chartElement.innerHTML = '';

    // ایجاد نمودار جدید
    const options = {
        series: [{
            name: 'تعداد',
            type: 'column',
            data: chartData.data
        }, {
            name: 'درصد رشد',
            type: 'line',
            data: chartData.growth
        }],
        chart: {
            height: 350,
            type: 'line',
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: true,
                tools: {
                    download: true,
                    selection: true,
                    zoom: true,
                    zoomin: true,
                    zoomout: true,
                    pan: true,
                    reset: true
                }
            }
        },
        stroke: {
            width: [0, 3]
        },
        dataLabels: {
            enabled: true,
            enabledOnSeries: [1],
            formatter: function (val) {
                return val + '%';
            }
        },
        labels: chartData.labels,
        colors: ['#4e73df', '#1cc88a'],
        title: {
            text: getPeriodTitle(period) + ' (فیلتر شده)',
            align: 'center',
            style: {
                fontSize: '16px',
                fontWeight: 'bold',
                fontFamily: 'IRANSans, tahoma, sans-serif'
            }
        },
        yaxis: [
            {
                title: {
                    text: 'تعداد',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            {
                opposite: true,
                title: {
                    text: 'درصد رشد',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            }
        ],
        tooltip: {
            y: {
                formatter: function(value, { series, seriesIndex, dataPointIndex, w }) {
                    if (seriesIndex === 0) {
                        return value.toLocaleString() + ' مورد';
                    } else {
                        return value + '%';
                    }
                }
            }
        }
    };

    // ایجاد و نمایش نمودار
    if (window.timeGrowthChart) {
        window.timeGrowthChart.destroy();
    }

    window.timeGrowthChart = new ApexCharts(chartElement, options);
    window.timeGrowthChart.render();
}

// تابع بهبود یافته برای نمایش رتبه‌بندی استان‌ها
function renderTopProvinces() {
    const topProvinces = <?php echo json_encode($geographicData['provinces']['top_list'] ?? [], 15, 512) ?>;
    const container = document.getElementById('provinces-top');

    if (!container) {
        console.error('Provinces top container not found');
        return;
    }

    if (topProvinces.length === 0) {
        container.innerHTML = '<div class="text-center text-muted p-3">داده‌ای یافت نشد</div>';
        return;
    }

    let html = '<div class="ranking-list-content">';
    topProvinces.forEach((item) => {
        const trendIcon = item.growth > 0 ? 'fa-arrow-up text-success' :
                         item.growth < 0 ? 'fa-arrow-down text-danger' :
                         'fa-minus text-muted';

        const trendText = item.growth > 0 ? `+${item.growth}%` :
                         item.growth < 0 ? `${item.growth}%` :
                         '0%';

        html += `
            <div class="ranking-item">
                <div class="ranking-number">${item.rank}</div>
                <div class="ranking-content">
                    <div class="ranking-name">${item.name}</div>
                    <div class="ranking-details">
                        <span class="ranking-count">${item.count} مکان</span>
                        <span class="ranking-percentage">${item.percentage}%</span>
                    </div>
                </div>
                <div class="ranking-trend">
                    <i class="fas ${trendIcon}"></i>
                    <span>${trendText}</span>
                </div>
            </div>
        `;
    });
    html += '</div>';
    container.innerHTML = html;
}

// تابع بهبود یافته برای نمایش رتبه‌بندی شهرها
function renderTopCities() {
    const topCities = <?php echo json_encode($geographicData['cities']['top_list'] ?? [], 15, 512) ?>;
    const container = document.getElementById('cities-top');

    if (!container) {
        console.error('Cities top container not found');
        return;
    }

    if (topCities.length === 0) {
        container.innerHTML = '<div class="text-center text-muted p-3">داده‌ای یافت نشد</div>';
        return;
    }

    let html = '<div class="ranking-list-content">';
    topCities.forEach((item) => {
        html += `
            <div class="ranking-item">
                <div class="ranking-number">${item.rank}</div>
                <div class="ranking-content">
                    <div class="ranking-name">${item.name}</div>
                    <div class="ranking-details">
                        <span class="ranking-count">${item.count} مکان</span>
                        <span class="ranking-percentage">${item.percentage}%</span>
                    </div>
                </div>
                <div class="ranking-trend">
                    <i class="fas fa-chart-line text-info"></i>
                    <span>شهری</span>
                </div>
            </div>
        `;
    });
    html += '</div>';
    container.innerHTML = html;
}

// تابع جدید برای نمایش رتبه‌بندی روستاها
function renderTopVillages() {
    const topVillages = <?php echo json_encode($geographicData['villages']['top_list'] ?? [], 15, 512) ?>;
    const container = document.getElementById('villages-top');

    if (!container) {
        console.error('Villages top container not found');
        return;
    }

    if (topVillages.length === 0) {
        container.innerHTML = '<div class="text-center text-muted p-3">داده‌ای یافت نشد</div>';
        return;
    }

    let html = '<div class="ranking-list-content">';
    topVillages.forEach((item) => {
        html += `
            <div class="ranking-item">
                <div class="ranking-number">${item.rank}</div>
                <div class="ranking-content">
                    <div class="ranking-name">${item.name}</div>
                    <div class="ranking-details">
                        <span class="ranking-count">${item.count} مکان</span>
                        <span class="ranking-percentage">${item.percentage}%</span>
                    </div>
                </div>
                <div class="ranking-trend">
                    <i class="fas fa-leaf text-success"></i>
                    <span>روستایی</span>
                </div>
            </div>
        `;
    });
    html += '</div>';
    container.innerHTML = html;
}

// تابع جدید برای نمایش نمودار روستاها
function renderVillagesChart() {
    const villageLabels = <?php echo json_encode($geographicData['villages']['labels'] ?? [], 15, 512) ?>;
    const villageCounts = <?php echo json_encode($geographicData['villages']['data'] ?? [], 15, 512) ?>;

    if (villageLabels.length === 0) {
        document.querySelector("#villages-chart").innerHTML = '<div class="text-center text-muted p-4">داده‌ای برای نمایش وجود ندارد</div>';
        return;
    }

    const totalLocations = villageCounts.reduce((acc, curr) => acc + curr, 0);
    const villagePercentages = villageCounts.map(count => {
        return Math.round((count / totalLocations * 100) * 10) / 10;
    });

    const options = {
        series: [{
            name: 'درصد مکان‌ها',
            data: villagePercentages
        }],
        chart: {
            type: 'bar',
            height: 350,
            fontFamily: 'IRANSans, tahoma, sans-serif',
            dir: 'rtl',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: true,
                distributed: true,
                barHeight: '70%',
                dataLabels: {
                    position: 'bottom'
                }
            }
        },
        colors: ['#28a745', '#20c997', '#17a2b8', '#ffc107', '#fd7e14', '#dc3545', '#6f42c1', '#e83e8c', '#6c757d', '#343a40'],
        dataLabels: {
            enabled: true,
            textAnchor: 'start',
            style: {
                colors: ['#fff']
            },
            formatter: function(val, opt) {
                return val + '%';
            },
            offsetX: 0,
            dropShadow: {
                enabled: true
            }
        },
        stroke: {
            width: 1,
            colors: ['#fff']
        },
        xaxis: {
            categories: villageLabels,
        },
        yaxis: {
            labels: {
                show: false
            }
        },
        tooltip: {
            theme: 'dark',
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: function() {
                        return 'درصد مکان‌ها';
                    }
                },
                formatter: function(val) {
                    return val + '%';
                }
            }
        }
    };

    const chartElement = document.querySelector("#villages-chart");
    if (chartElement) {
        if (window.villagesChart) {
            window.villagesChart.destroy();
        }
        window.villagesChart = new ApexCharts(chartElement, options);
        window.villagesChart.render();
    } else {
        console.error('Villages chart element not found');
    }
}
</script><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/analytics/partials/geography_analysis.blade.php ENDPATH**/ ?>