@extends('layouts.user')

@section('title', 'جزئیات نظر')

@section('styles')
<link rel="stylesheet" href="{{ asset('css/rating-comments.css') }}">
<style>
    /* Modern Rating Show Styles */
    .rating-show-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: calc(100vh - 140px);
        padding: 2rem 0;
        position: relative;
        overflow: hidden;
    }

    .rating-show-container::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.3;
    }

    .rating-detail-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 24px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        overflow: hidden;
        position: relative;
        z-index: 2;
        animation: slideInUp 0.6s ease-out;
    }

    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .card-header-modern {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2rem;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .card-header-modern::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: shimmer 3s ease-in-out infinite;
    }

    @keyframes shimmer {
        0%, 100% { transform: rotate(0deg); }
        50% { transform: rotate(180deg); }
    }

    .header-icon {
        width: 80px;
        height: 80px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
        font-size: 2rem;
        position: relative;
        z-index: 2;
    }

    .header-title {
        font-size: 1.75rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        position: relative;
        z-index: 2;
    }

    .header-subtitle {
        font-size: 1rem;
        opacity: 0.9;
        position: relative;
        z-index: 2;
    }

    .card-body-modern {
        padding: 2.5rem;
    }

    /* Rating Info Section */
    .rating-info {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-radius: 16px;
        padding: 1.5rem;
        margin-bottom: 2rem;
        border: 1px solid #e2e8f0;
    }

    .rating-meta {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }

    .meta-item {
        background: white;
        padding: 1rem;
        border-radius: 12px;
        border: 1px solid #e2e8f0;
        text-align: center;
        transition: all 0.3s ease;
    }

    .meta-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .meta-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin: 0 auto 0.5rem;
        font-size: 1.1rem;
    }

    .meta-value {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 0.25rem;
    }

    .meta-label {
        font-size: 0.875rem;
        color: #718096;
    }

    /* Rating Stars */
    .rating-stars {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 1rem;
    }

    .stars {
        display: flex;
        gap: 0.25rem;
    }

    .star {
        color: #fbbf24;
        font-size: 1.25rem;
    }

    .star.empty {
        color: #e5e7eb;
    }

    .rating-value {
        font-size: 1.125rem;
        font-weight: 600;
        color: #2d3748;
        margin-right: 0.5rem;
    }

    /* Status Badge */
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.5rem 1rem;
        border-radius: 20px;
        font-size: 0.875rem;
        font-weight: 500;
    }

    .status-badge.pending {
        background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
        color: white;
    }

    .status-badge.approved {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
    }

    .status-badge.rejected {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
    }

    /* Comments Section */
    .comments-section {
        margin-top: 2rem;
    }

    .comment-box {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        border: 1px solid #e2e8f0;
        margin-bottom: 1rem;
    }

    .comment-header {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 1rem;
        padding-bottom: 0.75rem;
        border-bottom: 1px solid #e2e8f0;
    }

    .comment-icon {
        width: 32px;
        height: 32px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 0.875rem;
    }

    .comment-title {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
    }

    .comment-content {
        color: #4a5568;
        line-height: 1.6;
        font-size: 0.95rem;
    }

    /* Action Buttons */
    .action-buttons {
        display: flex;
        gap: 1rem;
        justify-content: space-between;
        margin-top: 2rem;
        padding-top: 2rem;
        border-top: 1px solid #e2e8f0;
    }

    .btn-modern {
        padding: 1rem 2rem;
        border-radius: 12px;
        font-size: 1rem;
        font-weight: 600;
        border: none;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        display: flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
        position: relative;
        overflow: hidden;
    }

    .btn-modern::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .btn-modern:hover::before {
        left: 100%;
    }

    .btn-secondary-modern {
        background: linear-gradient(135deg, #718096 0%, #4a5568 100%);
        color: white;
    }

    .btn-secondary-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(113, 128, 150, 0.3);
        color: white;
    }

    .btn-primary-modern {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-primary-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        color: white;
    }

    .btn-warning-modern {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
    }

    .btn-warning-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(245, 158, 11, 0.3);
        color: white;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .rating-show-container {
            padding: 1rem 0;
        }

        .rating-detail-card {
            margin: 0 1rem;
            border-radius: 16px;
        }

        .card-header-modern,
        .card-body-modern {
            padding: 1.5rem;
        }

        .header-icon {
            width: 60px;
            height: 60px;
            font-size: 1.5rem;
        }

        .header-title {
            font-size: 1.5rem;
        }

        .rating-meta {
            grid-template-columns: 1fr;
        }

        .action-buttons {
            flex-direction: column;
        }

        .btn-modern {
            justify-content: center;
        }
    }
</style>
@endsection

@section('content')
<div class="rating-show-container">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-8">
                <div class="rating-detail-card">
                    <!-- Card Header -->
                    <div class="card-header-modern">
                        <div class="header-icon">
                            <i class="fas fa-star"></i>
                        </div>
                        <h1 class="header-title">جزئیات نظر</h1>
                        <p class="header-subtitle">مشاهده کامل اطلاعات نظر ثبت شده</p>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body-modern">
                        <!-- Rating Information -->
                        <div class="rating-info">
                            <div class="rating-meta">
                                <div class="meta-item">
                                    <div class="meta-icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div class="meta-value">{{ $rating->hotel_name }}</div>
                                    <div class="meta-label">نام مکان</div>
                                </div>
                                <div class="meta-item">
                                    <div class="meta-icon">
                                        <i class="fas fa-calendar-alt"></i>
                                    </div>
                                    <div class="meta-value">
                                        @dateByLocale($rating->created_at)
                                    </div>
                                    <div class="meta-label">تاریخ ثبت</div>
                                </div>
                                <div class="meta-item">
                                    <div class="meta-icon">
                                        <i class="fas fa-info-circle"></i>
                                    </div>
                                    <div class="meta-value">
                                        <span class="status-badge {{ $rating->status }}">
                                            <i class="fas fa-{{ $rating->status == 'pending' ? 'clock' : ($rating->status == 'approved' ? 'check' : 'times') }}"></i>
                                            {{ $rating->status == 'pending' ? 'در انتظار تایید' : ($rating->status == 'approved' ? 'تایید شده' : 'رد شده') }}
                                        </span>
                                    </div>
                                    <div class="meta-label">وضعیت</div>
                                </div>
                                <div class="meta-item">
                                    <div class="meta-icon">
                                        <i class="fas fa-tag"></i>
                                    </div>
                                    <div class="meta-value">{{ $rating->getLocalizedCategoryName() ?? 'عمومی' }}</div>
                                    <div class="meta-label">دسته‌بندی</div>
                                </div>
                            </div>

                            <!-- Overall Rating -->
                            <div class="rating-stars">
                                <span class="rating-value">{{ $rating->rating }}/5</span>
                                <div class="stars">
                                    @for($i = 1; $i <= 5; $i++)
                                        <i class="fas fa-star star {{ $i <= $rating->rating ? '' : 'empty' }}"></i>
                                    @endfor
                                </div>
                                <span style="margin-right: auto; color: #718096; font-size: 0.875rem;">امتیاز کلی</span>
                            </div>

                            <!-- Detailed Ratings -->
                            @if($rating->service_rating || $rating->cleanliness_rating || $rating->location_rating || $rating->price_rating)
                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin-top: 1rem;">
                                @if($rating->service_rating)
                                <div style="background: white; padding: 1rem; border-radius: 8px; border: 1px solid #e2e8f0;">
                                    <div style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem;">
                                        <i class="fas fa-concierge-bell" style="color: #667eea;"></i>
                                        <span style="font-weight: 600; color: #2d3748;">خدمات</span>
                                    </div>
                                    <div class="stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $rating->service_rating ? '' : 'empty' }}" style="font-size: 1rem;"></i>
                                        @endfor
                                    </div>
                                </div>
                                @endif

                                @if($rating->cleanliness_rating)
                                <div style="background: white; padding: 1rem; border-radius: 8px; border: 1px solid #e2e8f0;">
                                    <div style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem;">
                                        <i class="fas fa-broom" style="color: #667eea;"></i>
                                        <span style="font-weight: 600; color: #2d3748;">نظافت</span>
                                    </div>
                                    <div class="stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $rating->cleanliness_rating ? '' : 'empty' }}" style="font-size: 1rem;"></i>
                                        @endfor
                                    </div>
                                </div>
                                @endif

                                @if($rating->location_rating)
                                <div style="background: white; padding: 1rem; border-radius: 8px; border: 1px solid #e2e8f0;">
                                    <div style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem;">
                                        <i class="fas fa-map-marker-alt" style="color: #667eea;"></i>
                                        <span style="font-weight: 600; color: #2d3748;">موقعیت</span>
                                    </div>
                                    <div class="stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $rating->location_rating ? '' : 'empty' }}" style="font-size: 1rem;"></i>
                                        @endfor
                                    </div>
                                </div>
                                @endif

                                @if($rating->price_rating)
                                <div style="background: white; padding: 1rem; border-radius: 8px; border: 1px solid #e2e8f0;">
                                    <div style="display: flex; align-items: center; gap: 0.5rem; margin-bottom: 0.5rem;">
                                        <i class="fas fa-dollar-sign" style="color: #667eea;"></i>
                                        <span style="font-weight: 600; color: #2d3748;">قیمت</span>
                                    </div>
                                    <div class="stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $rating->price_rating ? '' : 'empty' }}" style="font-size: 1rem;"></i>
                                        @endfor
                                    </div>
                                </div>
                                @endif
                            </div>
                            @endif
                        </div>

                        <!-- Comments Section -->
                        <div class="comments-section">
                            @if($rating->positive_comment)
                            <div class="comment-box">
                                <div class="comment-header">
                                    <div class="comment-icon">
                                        <i class="fas fa-thumbs-up"></i>
                                    </div>
                                    <div class="comment-title">نکات مثبت</div>
                                </div>
                                <div class="comment-content positive-comments">{!! $rating->positive_comment_html !!}</div>
                            </div>
                            @endif

                            @if($rating->negative_comment)
                            <div class="comment-box">
                                <div class="comment-header">
                                    <div class="comment-icon">
                                        <i class="fas fa-thumbs-down"></i>
                                    </div>
                                    <div class="comment-title">نکات منفی</div>
                                </div>
                                <div class="comment-content negative-comments">{!! $rating->negative_comment_html !!}</div>
                            </div>
                            @endif

                            @if($rating->comment)
                            <div class="comment-box">
                                <div class="comment-header">
                                    <div class="comment-icon">
                                        <i class="fas fa-comment"></i>
                                    </div>
                                    <div class="comment-title">نظر کلی</div>
                                </div>
                                <div class="comment-content">{{ $rating->comment }}</div>
                            </div>
                            @endif

                            @if($rating->admin_reply)
                            <div class="comment-box" style="border-left: 4px solid #667eea;">
                                <div class="comment-header">
                                    <div class="comment-icon">
                                        <i class="fas fa-reply"></i>
                                    </div>
                                    <div class="comment-title">پاسخ مدیریت</div>
                                    <span style="margin-right: auto; font-size: 0.875rem; color: #718096;">
                                        @dateTimeByLocale($rating->admin_reply_date)
                                    </span>
                                </div>
                                <div class="comment-content">{{ $rating->admin_reply }}</div>
                            </div>
                            @endif
                        </div>

                        <!-- Action Buttons -->
                        <div class="action-buttons">
                            <a href="{{ route('user.ratings.index') }}" class="btn-modern btn-secondary-modern">
                                <i class="fas fa-arrow-right"></i>
                                بازگشت به لیست
                            </a>
                            
                            <div style="display: flex; gap: 1rem;">
                                @if($rating->status === 'pending')
                                <a href="{{ route('user.ratings.edit', $rating->id) }}" class="btn-modern btn-warning-modern">
                                    <i class="fas fa-edit"></i>
                                    ویرایش نظر
                                </a>
                                @endif
                                
                                <a href="{{ route('user.ratings.create') }}" class="btn-modern btn-primary-modern">
                                    <i class="fas fa-plus"></i>
                                    نظر جدید
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
