@extends('layouts.app')

@section('title', isset($location) ? $location->title . ' | ' . config('app.name') : config('app.name'))

@push('head')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="{{ asset('css/modern-base-template.css') }}">
<link rel="stylesheet" href="{{ asset('css/modern-rating-system.css') }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.css" />
<meta name="csrf-token" content="{{ csrf_token() }}">
<meta property="og:title" content="{{ $location->title ?? 'مکان' }}">
<meta property="og:description" content="{{ Str::limit($location->description ?? '', 160) }}">
@if($location->images)
    @php
        $locationImages = is_array($location->images) ? $location->images : (is_string($location->images) ? json_decode($location->images, true) : []);
        $firstImage = ($locationImages ?? [])[0] ?? null;
    @endphp
    @if($firstImage)
        <meta property="og:image" content="{{ asset('storage/' . (is_string($firstImage) ? $firstImage : ($firstImage['path'] ?? ''))) }}">
    @endif
@endif
@endpush

@section('content')
<!-- Modern Professional Breadcrumb Navigation -->
<div class="breadcrumb-container">
    <div class="container">
        <nav aria-label="مسیر صفحه" role="navigation">
            <ol class="breadcrumb modern-breadcrumb" itemscope itemtype="https://schema.org/BreadcrumbList">
                <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                    <a href="{{ url('/') }}" itemprop="item" title="بازگشت به صفحه اصلی">
                        <i class="fas fa-home" aria-hidden="true"></i>
                        <span itemprop="name">خانه</span>
                    </a>
                    <meta itemprop="position" content="1" />
                </li>
                @if(isset($categoryHierarchy) && count($categoryHierarchy) > 0)
                    @foreach($categoryHierarchy as $index => $category)
                        <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            @if(isset($category->category_key))
                                <a href="{{ url('/' . $category->category_key) }}" itemprop="item"
                                   title="مشاهده {{ $category->name_fa ?? $category->category_fa ?? $category->name ?? $category->category_key }}">
                                    <i class="fas fa-layer-group" aria-hidden="true"></i>
                                    <span itemprop="name">{{ $category->name_fa ?? $category->category_fa ?? $category->name ?? $category->category_key }}</span>
                                </a>
                            @else
                                <span itemprop="name">
                                    <i class="fas fa-layer-group" aria-hidden="true"></i>
                                    {{ $category->name_fa ?? $category->category_fa ?? $category->name ?? 'دسته‌بندی' }}
                                </span>
                            @endif
                            <meta itemprop="position" content="{{ $index + 2 }}" />
                        </li>
                    @endforeach
                @elseif($location->category_fa)
                    <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name">
                            <i class="fas fa-layer-group" aria-hidden="true"></i>
                            {{ $location->category_fa }}
                        </span>
                        <meta itemprop="position" content="2" />
                    </li>
                @endif
                <li class="breadcrumb-item active" aria-current="page" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                    <span itemprop="name">
                        <i class="fas fa-map-marker-alt" aria-hidden="true"></i>
                        {{ Str::limit($location->title, 50) }}
                    </span>
                    <meta itemprop="position" content="{{ (isset($categoryHierarchy) && count($categoryHierarchy) > 0) ? count($categoryHierarchy) + 2 : ($location->category_fa ? 3 : 2) }}" />
                </li>
            </ol>
        </nav>
    </div>
</div>

@if(isset($location))
    <!-- Hero Section -->
    <div class="location-hero">
        <div class="hero-background">
            @if($location->images)
                @php
                    $heroImages = is_array($location->images) ? $location->images : (is_string($location->images) ? json_decode($location->images, true) : []);
                    $firstImage = ($heroImages ?? [])[0] ?? null;
                @endphp
                @if($firstImage)
                    <img src="{{ asset('storage/' . (is_string($firstImage) ? $firstImage : ($firstImage['path'] ?? ''))) }}"
                         alt="{{ $location->title }}" class="hero-image">
                @endif
            @endif
            <div class="hero-overlay"></div>
        </div>
        <div class="container">
            <div class="hero-content">
                <div class="hero-top-info">
                    <div class="location-badges">
                        <div class="location-badge primary">
                            <i class="fas fa-map-marker-alt"></i>
                            {{ $location->category_fa ?? 'مکان' }}
                        </div>
                        @if($location->package_type && $location->package_type !== 'regular')
                            <div class="location-badge premium {{ $location->package_type }}">
                                <i class="fas fa-crown"></i>
                                {{ ucfirst($location->package_type) }}
                            </div>
                        @endif
                        @if($location->star_rating)
                            <div class="location-badge rating">
                                <i class="fas fa-star"></i>
                                {{ $location->star_rating }}/5
                            </div>
                        @endif
                    </div>
                    @if($location->emoji)
                        <div class="location-emoji">{{ $location->emoji }}</div>
                    @endif
                </div>

                <h1 class="location-title">{{ $location->title }}</h1>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container location-content">
        <div class="row g-4">
            <div class="col-lg-8">
                <!-- Quick Info Cards -->
                <div class="quick-info-grid">
                    @if($location->phone)
                        <div class="quick-info-card">
                            <div class="info-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="info-content">
                                <span class="info-label">تلفن تماس</span>
                                <a href="tel:{{ $location->phone }}" class="info-value">{{ $location->phone }}</a>
                            </div>
                        </div>
                    @endif

                    @if($location->open_hours || $location->closing_hours)
                        <div class="quick-info-card">
                            <div class="info-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="info-content">
                                <span class="info-label">ساعات کاری</span>
                                <div class="working-hours-display">
                                    <span class="info-value">{{ $location->open_hours ?? '۹ صبح' }} تا {{ $location->closing_hours ?? '۹ شب' }}</span>
                                    @php
                                        $locationStatus = \App\Helpers\TimezoneHelper::getLocationStatus($location);
                                        $isOpen = $locationStatus['isOpen'];
                                        $statusText = $locationStatus['statusText'];
                                        $statusClass = $locationStatus['statusClass'];
                                        $timezone = $locationStatus['timezone'];
                                        $now = $locationStatus['currentTime'];
                                    @endphp
                                    <span class="status-badge {{ $statusClass }}">
                                        <i class="fas fa-circle"></i>
                                        {{ $statusText }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($location->url)
                        <div class="quick-info-card">
                            <div class="info-icon">
                                <i class="fas fa-globe"></i>
                            </div>
                            <div class="info-content">
                                <span class="info-label">وب‌سایت</span>
                                <a href="{{ $location->url }}" target="_blank" class="info-value">
                                    مشاهده سایت
                                    <i class="fas fa-external-link-alt ms-1"></i>
                                </a>
                            </div>
                        </div>
                    @endif
                </div>

                <!-- Description Section -->
                @if($location->description || $location->Slogan)
                <div class="content-section">
                    <div class="section-header">
                        <h2 class="section-title">
                            <i class="fas fa-info-circle"></i>
                            درباره این مکان
                        </h2>
                    </div>
                    <div class="section-content">
                        @if($location->Slogan)
                            <div class="location-slogan-section">
                                <blockquote class="location-slogan-quote">
                                    <i class="fas fa-quote-right slogan-quote-icon"></i>
                                    <p class="slogan-text">{{ $location->Slogan }}</p>
                                    <i class="fas fa-quote-left slogan-quote-icon"></i>
                                </blockquote>
                            </div>
                        @endif
                        @if($location->description)
                            <p class="description-text">{{ $location->description }}</p>
                        @endif
                    </div>
                </div>
                @endif

                <!-- Image Gallery -->
                @if($location->images)
                    @php
                        $images = is_array($location->images) ? $location->images : (json_decode($location->images, true) ?? []);
                    @endphp
                    @if(count($images) > 0)
                    <div class="content-section">
                        <div class="section-header">
                            <h2 class="section-title">
                                <i class="fas fa-images"></i>
                                گالری تصاویر
                            </h2>
                            <span class="image-count">{{ count($images) }} تصویر</span>
                        </div>
                        <div class="modern-gallery">
                            @if(count($images) > 0)
                                <!-- Main Image -->
                                <div class="gallery-main">
                                    @php $mainImage = $images[0]; $mainImagePath = is_string($mainImage) ? $mainImage : (is_array($mainImage) && isset($mainImage['path']) ? $mainImage['path'] : ''); @endphp
                                    @if(!empty($mainImagePath))
                                    <div class="main-image-container" onclick="openLightbox(0)">
                                        <img src="{{ asset('storage/' . trim($mainImagePath)) }}"
                                             alt="{{ $location->title }}"
                                             class="main-image">
                                        <div class="main-image-overlay">
                                            <div class="overlay-content">
                                                <i class="fas fa-expand-alt"></i>
                                                <span>مشاهده در اندازه کامل</span>
                                            </div>
                                            <div class="image-counter">
                                                <i class="fas fa-images"></i>
                                                {{ count($images) }} تصویر
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>

                                <!-- Thumbnail Grid -->
                                @if(count($images) > 1)
                                <div class="gallery-thumbnails">
                                    @foreach($images as $index => $image)
                                        @if($index > 0 && $index < 5) {{-- Show max 4 thumbnails --}}
                                            @php $imagePath = is_string($image) ? $image : (is_array($image) && isset($image['path']) ? $image['path'] : ''); @endphp
                                            @if(!empty($imagePath))
                                            <div class="thumbnail-item {{ $index == 4 && count($images) > 5 ? 'more-images' : '' }}"
                                                 onclick="openLightbox({{ $index }})">
                                                <img src="{{ asset('storage/' . trim($imagePath)) }}"
                                                     alt="{{ $location->title }}"
                                                     class="thumbnail-image">
                                                @if($index == 4 && count($images) > 5)
                                                <div class="more-overlay">
                                                    <span>+{{ count($images) - 4 }}</span>
                                                </div>
                                                @endif
                                            </div>
                                            @endif
                                        @endif
                                    @endforeach
                                </div>
                                @endif
                            @else
                                <div class="no-images">
                                    <i class="fas fa-image"></i>
                                    <p>تصویری برای این مکان ثبت نشده است</p>
                                </div>
                            @endif
                        </div>
                    </div>
                    @endif
                @endif

                <!-- Amenities Section -->
                @if($location->amenities && count($location->amenities) > 0)
                <div class="content-section">
                    <div class="section-header">
                        <h2 class="section-title">
                            <i class="fas fa-star"></i>
                            امکانات و ویژگی‌ها
                        </h2>
                        <span class="amenities-count">{{ count($location->amenities) }} مورد</span>
                    </div>
                    <div class="amenities-grid">
                        @foreach($location->amenities as $amenity)
                            <div class="amenity-item">
                                <div class="amenity-icon">
                                    @if(isset($amenity['icon']) && $amenity['icon'])
                                        <i class="{{ $amenity['icon'] }}"></i>
                                    @else
                                        <i class="fas fa-check-circle"></i>
                                    @endif
                                </div>
                                <div class="amenity-content">
                                    <span class="amenity-name">{{ $amenity['name'] ?? $amenity }}</span>
                                    @if(isset($amenity['description']) && $amenity['description'])
                                        <span class="amenity-description">{{ $amenity['description'] }}</span>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Tags Section -->
                @if($location->tags)
                <div class="content-section">
                    <div class="section-header">
                        <h2 class="section-title">
                            <i class="fas fa-tags"></i>
                            برچسب‌ها
                        </h2>
                    </div>
                    <div class="tags-container">
                        @php
                            $tags = is_string($location->tags) ? explode(',', $location->tags) : $location->tags;
                        @endphp
                        @foreach($tags as $tag)
                            @if(trim($tag))
                                <span class="tag-item">
                                    <i class="fas fa-hashtag"></i>
                                    {{ trim($tag) }}
                                </span>
                            @endif
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Modern Rating & Comment System -->
                <div class="modern-rating-section">
                    <div class="rating-section-header">
                        <h2 class="rating-section-title">
                            <i class="fas fa-star"></i>
                            نظرات و امتیازدهی
                        </h2>

                        @if(isset($ratingStats) && $ratingStats)
                        <div class="rating-overview">
                            <div class="rating-summary-card">
                                <div class="rating-average-display">{{ number_format($ratingStats->average_rating, 1) }}</div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $ratingStats->average_rating ? 'active' : '' }}"></i>
                                        @endfor
                                    </div>
                                </div>
                                <div class="rating-count-display">{{ $ratingStats->total_ratings }} نظر</div>
                            </div>

                            @if($ratingStats->service_avg)
                            <div class="rating-summary-card">
                                <div class="rating-average-display">{{ number_format($ratingStats->service_avg, 1) }}</div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $ratingStats->service_avg ? 'active' : '' }}"></i>
                                        @endfor
                                    </div>
                                </div>
                                <div class="rating-count-display">کیفیت خدمات</div>
                            </div>
                            @endif

                            @if($ratingStats->location_avg)
                            <div class="rating-summary-card">
                                <div class="rating-average-display">{{ number_format($ratingStats->location_avg, 1) }}</div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $ratingStats->location_avg ? 'active' : '' }}"></i>
                                        @endfor
                                    </div>
                                </div>
                                <div class="rating-count-display">موقعیت مکانی</div>
                            </div>
                            @endif
                        </div>
                        @elseif(isset($ratings) && count($ratings) > 0)
                        <div class="rating-overview">
                            @php
                                $avgRating = $ratings->avg('rating');
                                $totalRatings = $ratings->count();
                            @endphp
                            <div class="rating-summary-card">
                                <div class="rating-average-display">{{ number_format($avgRating, 1) }}</div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $avgRating ? 'active' : '' }}"></i>
                                        @endfor
                                    </div>
                                </div>
                                <div class="rating-count-display">{{ $totalRatings }} نظر</div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Rating Form -->
                    <div class="modern-rating-form">
                        <h3 class="rating-form-title">
                            <i class="fas fa-edit"></i>
                            نظر خود را ثبت کنید
                        </h3>

                        <form id="modern-rating-form" action="{{ route('ratings.store') }}" method="POST">
                            @csrf
                            <input type="hidden" name="title_id" value="{{ $location->title_id }}">

                            <!-- User Information -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">نام شما *</label>
                                        <input type="text" name="name" class="rating-form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">ایمیل *</label>
                                        <input type="email" name="email" class="rating-form-control" required>
                                    </div>
                                </div>
                            </div>

                            <!-- Overall Rating -->
                            <div class="rating-form-group">
                                <label class="rating-form-label">امتیاز کلی *</label>
                                <div class="star-rating star-rating-large" data-rating="overall">
                                    @for($i = 1; $i <= 5; $i++)
                                        <i class="fas fa-star star" data-value="{{ $i }}"></i>
                                    @endfor
                                </div>
                                <input type="hidden" name="rating" required>
                            </div>

                            <!-- Detailed Ratings -->
                            <div class="multi-rating-grid">
                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-concierge-bell"></i>
                                        کیفیت خدمات
                                    </div>
                                    <div class="star-rating" data-rating="service">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star" data-value="{{ $i }}"></i>
                                        @endfor
                                    </div>
                                    <input type="hidden" name="service_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-gem"></i>
                                        کیفیت کلی
                                    </div>
                                    <div class="star-rating" data-rating="quality">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star" data-value="{{ $i }}"></i>
                                        @endfor
                                    </div>
                                    <input type="hidden" name="quality_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-map-marker-alt"></i>
                                        موقعیت مکانی
                                    </div>
                                    <div class="star-rating" data-rating="location">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star" data-value="{{ $i }}"></i>
                                        @endfor
                                    </div>
                                    <input type="hidden" name="location_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-dollar-sign"></i>
                                        ارزش در برابر قیمت
                                    </div>
                                    <div class="star-rating" data-rating="price">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star" data-value="{{ $i }}"></i>
                                        @endfor
                                    </div>
                                    <input type="hidden" name="price_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-broom"></i>
                                        نظافت
                                    </div>
                                    <div class="star-rating" data-rating="cleanliness">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star" data-value="{{ $i }}"></i>
                                        @endfor
                                    </div>
                                    <input type="hidden" name="cleanliness_rating">
                                </div>
                            </div>

                            <!-- Comment -->
                            <div class="rating-form-group">
                                <label class="rating-form-label">نظر شما</label>
                                <textarea name="comment" class="rating-form-control rating-form-textarea"
                                         placeholder="تجربه خود را با ما به اشتراک بگذارید..."></textarea>
                            </div>

                            <!-- Positive/Negative Points -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">نکات مثبت</label>
                                        <textarea name="positive_comment" class="rating-form-control" rows="3"
                                                 placeholder="چه چیزهایی را دوست داشتید؟"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">نکات منفی</label>
                                        <textarea name="negative_comment" class="rating-form-control" rows="3"
                                                 placeholder="چه چیزهایی قابل بهبود است؟"></textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Information -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">تاریخ بازدید</label>
                                        <input type="date" name="visit_date" class="rating-form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">هدف بازدید</label>
                                        <select name="visit_purpose" class="rating-form-control">
                                            <option value="">انتخاب کنید</option>
                                            <option value="business">کاری</option>
                                            <option value="leisure">تفریحی</option>
                                            <option value="family">خانوادگی</option>
                                            <option value="romantic">عاشقانه</option>
                                            <option value="solo">انفرادی</option>
                                            <option value="group">گروهی</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Recommendation -->
                            <div class="rating-form-group">
                                <label class="rating-form-label">آیا این مکان را به دیگران توصیه می‌کنید؟</label>
                                <div class="recommendation-options">
                                    <label class="recommendation-option">
                                        <input type="radio" name="recommendation" value="yes">
                                        <span>بله، قطعاً</span>
                                    </label>
                                    <label class="recommendation-option">
                                        <input type="radio" name="recommendation" value="maybe">
                                        <span>شاید</span>
                                    </label>
                                    <label class="recommendation-option">
                                        <input type="radio" name="recommendation" value="no">
                                        <span>خیر</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="rating-form-group">
                                <button type="submit" class="rating-submit-btn">
                                    <i class="fas fa-paper-plane"></i>
                                    ارسال نظر
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Comments Display -->
                    @if(isset($ratings) && count($ratings) > 0)
                    <div class="comments-container">
                        <h3 class="comments-title">
                            <i class="fas fa-comments"></i>
                            نظرات کاربران
                        </h3>

                        @foreach($ratings as $rating)
                        <div class="comment-item" data-comment-id="{{ $rating->id }}">
                            <div class="comment-header">
                                <div class="comment-user">
                                    <div class="comment-avatar">
                                        {{ substr($rating->name ?? 'ک', 0, 1) }}
                                    </div>
                                    <div class="comment-user-info">
                                        <h5>{{ $rating->name ?? 'کاربر ناشناس' }}</h5>
                                        <p class="comment-date" data-original-date="{{ $rating->created_at ?? $rating->timestamp }}">
                                            {{ \Carbon\Carbon::parse($rating->created_at ?? $rating->timestamp)->diffForHumans() }}
                                        </p>
                                    </div>
                                </div>
                                <div class="comment-rating-display">
                                    <div class="star-rating star-rating-small">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star star {{ $i <= $rating->rating ? 'active' : '' }}"></i>
                                        @endfor
                                    </div>
                                </div>
                            </div>

                            @if($rating->comment)
                            <div class="comment-content">
                                {{ $rating->comment }}
                            </div>
                            @endif

                            @if($rating->positive_comment || $rating->negative_comment)
                            <div class="comment-points">
                                @if($rating->positive_comment)
                                <div class="positive-points">
                                    <strong>
                                        <i class="fas fa-thumbs-up"></i> نکات مثبت:
                                    </strong>
                                    <p>{!! $rating->positive_comment_html ?? $rating->positive_comment !!}</p>
                                </div>
                                @endif

                                @if($rating->negative_comment)
                                <div class="negative-points">
                                    <strong>
                                        <i class="fas fa-thumbs-down"></i> نکات منفی:
                                    </strong>
                                    <p>{!! $rating->negative_comment_html ?? $rating->negative_comment !!}</p>
                                </div>
                                @endif
                            </div>
                            @endif

                            <!-- Additional Rating Information -->
                            @if($rating->trip_type || $rating->travel_method || $rating->stay_date || $rating->visit_date)
                            <div class="rating-details">
                                <div class="rating-details-grid">
                                    @if($rating->trip_type)
                                    <div class="rating-detail-item">
                                        <span class="detail-label">نوع سفر:</span>
                                        <span class="detail-value">
                                            @switch($rating->trip_type)
                                                @case('business') سفر کاری @break
                                                @case('family') سفر خانوادگی @break
                                                @case('couple') سفر زوج @break
                                                @case('solo') سفر تنها @break
                                                @case('friends') سفر با دوستان @break
                                                @default {{ $rating->trip_type }}
                                            @endswitch
                                        </span>
                                    </div>
                                    @endif

                                    @if($rating->travel_method)
                                    <div class="rating-detail-item">
                                        <span class="detail-label">روش سفر:</span>
                                        <span class="detail-value">
                                            @switch($rating->travel_method)
                                                @case('car') خودرو شخصی @break
                                                @case('bus') اتوبوس @break
                                                @case('train') قطار @break
                                                @case('airplane') هواپیما @break
                                                @case('other') سایر @break
                                                @default {{ $rating->travel_method }}
                                            @endswitch
                                        </span>
                                    </div>
                                    @endif

                                    @if($rating->stay_date)
                                    <div class="rating-detail-item">
                                        <span class="detail-label">تاریخ اقامت:</span>
                                        <span class="detail-value">
                                            @php
                                                // بررسی اینکه آیا تاریخ از قبل شمسی است
                                                $stayDate = $rating->stay_date;
                                                if (preg_match('/^(13|14)\d{2}/', $stayDate)) {
                                                    echo $stayDate; // اگر شمسی است، همان را نمایش بده
                                                } else {
                                                    if(app()->getLocale() == 'fa') {
                                                        echo \Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($stayDate))->format('Y/m/d');
                                                    } else {
                                                        echo \Carbon\Carbon::parse($stayDate)->format('Y/m/d');
                                                    }
                                                }
                                            @endphp
                                        </span>
                                    </div>
                                    @endif

                                    @if($rating->visit_date)
                                    <div class="rating-detail-item">
                                        <span class="detail-label">تاریخ بازدید:</span>
                                        <span class="detail-value">
                                            @php
                                                // بررسی اینکه آیا تاریخ از قبل شمسی است
                                                $visitDate = $rating->visit_date;
                                                if (preg_match('/^(13|14)\d{2}/', $visitDate)) {
                                                    echo $visitDate; // اگر شمسی است، همان را نمایش بده
                                                } else {
                                                    if(app()->getLocale() == 'fa') {
                                                        echo \Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($visitDate))->format('Y/m/d');
                                                    } else {
                                                        echo \Carbon\Carbon::parse($visitDate)->format('Y/m/d');
                                                    }
                                                }
                                            @endphp
                                        </span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif

                            <div class="comment-actions">
                                <button class="comment-action-btn comment-like-btn" data-rating-id="{{ $rating->id }}">
                                    <i class="fas fa-thumbs-up"></i>
                                    مفید (<span class="count">{{ $rating->helpful_count ?? 0 }}</span>)
                                </button>
                                <button class="comment-action-btn comment-dislike-btn" data-rating-id="{{ $rating->id }}">
                                    <i class="fas fa-thumbs-down"></i>
                                    غیرمفید (<span class="count">{{ $rating->not_helpful_count ?? 0 }}</span>)
                                </button>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="sidebar-content">
                    <!-- Location Map -->
                    @if($location->lat && $location->lng)
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-map"></i>
                            موقعیت روی نقشه
                        </h3>
                        <div class="location-map" id="locationMap">
                            <div class="map-placeholder">
                                <i class="fas fa-map-marked-alt"></i>
                                <p>در حال بارگذاری نقشه...</p>
                            </div>
                        </div>
                        <div class="map-actions">
                            <a href="https://maps.google.com/?q={{ $location->lat }},{{ $location->lng }}"
                               target="_blank" class="btn btn-map">
                                <i class="fas fa-external-link-alt"></i>
                                مشاهده در گوگل مپ
                            </a>
                        </div>
                    </div>
                    @endif

                    <!-- Contact Information -->
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-address-card"></i>
                            اطلاعات تماس
                        </h3>
                        <div class="contact-info">
                            @if($location->address)
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">آدرس</span>
                                    <span class="contact-value">{{ $location->address }}</span>
                                </div>
                            </div>
                            @endif

                            @if($location->phone)
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">تلفن</span>
                                    <a href="tel:{{ $location->phone }}" class="contact-value">{{ $location->phone }}</a>
                                </div>
                            </div>
                            @endif

                            @if($location->open_hours || $location->closing_hours)
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">ساعات کاری</span>
                                    <div class="working-hours-info">
                                        <span class="contact-value">{{ $location->open_hours ?? '۹ صبح' }} تا {{ $location->closing_hours ?? '۹ شب' }}</span>
                                        @php
                                            $sidebarLocationStatus = \App\Helpers\TimezoneHelper::getLocationStatus($location);
                                            $sidebarIsOpen = $sidebarLocationStatus['isOpen'];
                                            $sidebarStatusText = $sidebarLocationStatus['statusText'];
                                            $sidebarStatusClass = $sidebarLocationStatus['statusClass'];
                                        @endphp
                                        <span class="status-badge {{ $sidebarStatusClass }}">
                                            <i class="fas fa-circle"></i>
                                            {{ $sidebarStatusText }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            @endif

                            @if($location->url)
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-globe"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">وب‌سایت</span>
                                    <a href="{{ $location->url }}" target="_blank" class="contact-value">
                                        مشاهده سایت
                                        <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Share Section -->
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-share-alt"></i>
                            اشتراک‌گذاری
                        </h3>
                        <div class="share-buttons">
                            <button class="share-btn telegram" onclick="shareToTelegram()">
                                <i class="fab fa-telegram"></i>
                                تلگرام
                            </button>
                            <button class="share-btn whatsapp" onclick="shareToWhatsApp()">
                                <i class="fab fa-whatsapp"></i>
                                واتساپ
                            </button>
                            <button class="share-btn twitter" onclick="shareToTwitter()">
                                <i class="fab fa-twitter"></i>
                                توییتر
                            </button>
                            <button class="share-btn copy" onclick="copyLink()">
                                <i class="fas fa-copy"></i>
                                کپی لینک
                            </button>
                        </div>
                    </div>

                    <!-- Related Locations -->
                    @if(isset($relatedLocations) && count($relatedLocations) > 0)
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-map-marked"></i>
                            مکان‌های مشابه
                        </h3>
                        <div class="related-locations">
                            @foreach($relatedLocations as $related)
                            <div class="related-item">
                                <div class="related-image">
                                    @if($related->images)
                                        @php
                                            $relatedImages = is_array($related->images) ? $related->images : (json_decode($related->images, true) ?? []);
                                            $relatedImage = $relatedImages[0] ?? null;
                                        @endphp
                                        @if($relatedImage)
                                            <img src="{{ asset('storage/' . (is_string($relatedImage) ? $relatedImage : ($relatedImage['path'] ?? ''))) }}"
                                                 alt="{{ $related->title }}">
                                        @else
                                            <div class="no-image">
                                                <i class="fas fa-image"></i>
                                            </div>
                                        @endif
                                    @else
                                        <div class="no-image">
                                            <i class="fas fa-image"></i>
                                        </div>
                                    @endif
                                </div>
                                <div class="related-content">
                                    <h4 class="related-title">{{ $related->title }}</h4>
                                    <p class="related-category">{{ $related->category_fa }}</p>
                                    <a href="{{ route('locations.showWithCategories', ['categoryPath' => $related->category_path ?? 'location', 'titleId' => $related->title_id]) }}"
                                       class="related-link">مشاهده</a>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@else
    <!-- Error Message -->
    <div class="container">
        <div class="error-container">
            <div class="error-content">
                <div class="error-icon">
                    <i class="fas fa-map-marked-alt"></i>
                </div>
                <h2 class="error-title">مکان یافت نشد</h2>
                <p class="error-message">متأسفانه اطلاعات این مکان در دسترس نیست یا ممکن است حذف شده باشد.</p>
                <div class="error-actions">
                    <a href="{{ url('/') }}" class="btn btn-primary">
                        <i class="fas fa-home"></i>
                        بازگشت به صفحه اصلی
                    </a>
                    <a href="{{ url('/categories') }}" class="btn btn-outline-primary">
                        <i class="fas fa-list"></i>
                        مشاهده دسته‌بندی‌ها
                    </a>
                </div>
            </div>
        </div>
    </div>
@endif

<!-- Lightbox Modal -->
<div id="lightboxModal" class="lightbox-modal">
    <div class="lightbox-content">
        <span class="lightbox-close" onclick="closeLightbox()">&times;</span>
        <img id="lightboxImage" src="" alt="">
        <div class="lightbox-nav">
            <button class="lightbox-prev" onclick="prevImage()">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="lightbox-next" onclick="nextImage()">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
        <div class="lightbox-counter">
            <span id="lightboxCounter"></span>
        </div>
    </div>
</div>

<!-- Location Data for JavaScript -->
<script type="application/json" id="location-data">
{
    "title": @json($location->title ?? ''),
    "lat": {{ $location->lat ?? 0 }},
    "lng": {{ $location->lng ?? 0 }},
    "address": @json($location->address ?? ''),
    "phone": @json($location->phone ?? ''),
    "url": @json($location->url ?? ''),
    "images": @json($location->images ? (is_array($location->images) ? $location->images : (is_string($location->images) ? json_decode($location->images, true) : [])) : [])
}
</script>

<!-- JavaScript for Location Template -->
<script src="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.js"></script>
<script src="{{ asset('js/location-template.js') }}"></script>
<script src="{{ asset('js/modern-rating-system.js') }}"></script>
<script src="{{ asset('js/persian-date-picker.js') }}"></script>

<script>
// Set title ID for rating system
window.titleId = '{{ $location->title_id ?? '' }}';
</script>

@endsection
