@extends('layouts.app')

@section('title', __('نظرات کاربران درباره') . ' ' . $location->title)

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('خانه') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('locations.show', $location->id) }}">{{ $location->title }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('نظرات و امتیازات') }}</li>
                </ol>
            </nav>

            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="mb-0">{{ __('نظرات کاربران') }}</h1>
                <a href="{{ route('reviews.create', ['location_id' => $location->id]) }}" class="btn btn-primary">
                    <i class="fas fa-plus-circle me-1"></i> {{ __('ثبت نظر جدید') }}
                </a>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <h2 class="mb-0">{{ $location->title }}</h2>
                            @if(!empty($location->images))
                                @php
                                    $images = explode(',', $location->images);
                                    $firstImage = trim($images[0] ?? '');
                                @endphp
                                @if(!empty($firstImage))
                                    <img src="{{ $firstImage }}" alt="{{ $location->title }}" class="rounded my-3" style="width: 100%; max-height: 180px; object-fit: cover;">
                                @endif
                            @endif
                            @if(!empty($location->category_fa))
                                <p class="text-muted">
                                    <i class="fas fa-tag me-1"></i> {{ $location->category_fa }}
                                </p>
                            @endif
                            <a href="{{ route('locations.show', $location->id) }}" class="btn btn-outline-primary btn-sm mt-2">
                                {{ __('مشاهده مکان') }}
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card h-100">
                        <div class="card-body">
                            <x-ratings-widget :locationId="$location->id" size="large" />
                        </div>
                    </div>
                </div>
            </div>
            
            <x-review-list :locationId="$location->id" :showFilters="true" :showPagination="true" />
            
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show mt-4" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show mt-4" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            
            @if(session('info'))
                <div class="alert alert-info alert-dismissible fade show mt-4" role="alert">
                    {{ session('info') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection 