@extends('layouts.app')

@section('title', $location->title)

@section('content')
<div class="container py-4">
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('خانه') }}</a></li>
            @if (!empty($location->category) && !empty($location->category_fa))
                <li class="breadcrumb-item">
                    <a href="{{ route('categories.show', $location->category) }}">
                        {{ is_object($location->category) ? $location->category->getTranslatedName(app()->getLocale()) : $location->category_fa }}
                    </a>
                </li>
            @endif
            <li class="breadcrumb-item active" aria-current="page">{{ $location->title }}</li>
        </ol>
    </nav>

    <div class="location-header bg-light p-4 rounded mb-4">
        <div class="row">
            <div class="col-md-8">
                <h1 class="mb-2">{{ $location->title }}</h1>

                @if (!empty($location->category_fa))
                    <div class="mb-2 text-muted">
                        <i class="fas fa-tag me-1"></i> {{ $location->category_fa }}
                    </div>
                @endif

                @if (!empty($location->Slogan))
                    <div class="mb-3 fst-italic text-secondary">
                        {{ $location->Slogan }}
                    </div>
                @endif

                <div class="location-details">
                    @if (!empty($location->address))
                        <div class="mb-2">
                            <i class="fas fa-map-marker-alt me-2 text-primary"></i>
                            {{ $location->getStructuredAddress(app()->getLocale()) }}
                        </div>
                    @endif

                    @if (!empty($location->phone))
                        <div class="mb-2">
                            <i class="fas fa-phone me-2 text-primary"></i>
                            <a href="tel:{{ $location->phone }}" class="text-decoration-none">
                                {{ $location->phone }}
                            </a>
                        </div>
                    @endif

                    @if (!empty($location->url))
                        <div class="mb-2">
                            <i class="fas fa-globe me-2 text-primary"></i>
                            <a href="{{ $location->url }}" target="_blank" class="text-decoration-none">
                                {{ $location->url }}
                            </a>
                        </div>
                    @endif

                    @if (!empty($location->open_hours) || !empty($location->closing_hours))
                        <div>
                            <i class="far fa-clock me-2 text-primary"></i>
                            {{ __('ساعت کار') }}:
                            @if (!empty($location->open_hours) && !empty($location->closing_hours))
                                {{ $location->open_hours }} {{ __('الی') }} {{ $location->closing_hours }}
                            @elseif (!empty($location->open_hours))
                                {{ __('از') }} {{ $location->open_hours }}
                            @elseif (!empty($location->closing_hours))
                                {{ __('تا') }} {{ $location->closing_hours }}
                            @endif
                        </div>
                    @endif
                </div>
            </div>

            <div class="col-md-4">
                @if ($location->categoryRelation &&
                     $location->categoryRelation->activeTemplateRelation &&
                     is_object($location->categoryRelation->activeTemplateRelation) &&
                     method_exists($location->categoryRelation->activeTemplateRelation, 'isFeatureEnabled') &&
                     $location->categoryRelation->activeTemplateRelation->isFeatureEnabled('ratings'))
                    <x-ratings-widget :locationId="$location->id" size="large" />
                @endif
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            @if (!empty($location->images))
                @php
                    $images = $location->images_array;
                @endphp
                @if(count($images) > 0)
                <div class="location-images mb-4">
                    <div id="locationCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            @foreach ($images as $index => $image)
                                @if (!empty(trim($image)))
                                    <div class="carousel-item {{ $index === 0 ? 'active' : '' }}">
                                        <img src="{{ asset('storage/' . trim($image)) }}" class="d-block w-100 rounded" alt="{{ $location->title }}">
                                    </div>
                                @endif
                            @endforeach
                        </div>

                        @if (count(array_filter(array_map('trim', $images))) > 1)
                            <button class="carousel-control-prev" type="button" data-bs-target="#locationCarousel" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">{{ __('قبلی') }}</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#locationCarousel" data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">{{ __('بعدی') }}</span>
                            </button>
                        @endif
                    </div>
                </div>
                @endif
            @endif

            @if (!empty($location->description))
                <div class="mb-4">
                    <h3 class="border-start border-4 border-primary ps-2 mb-3">{{ __('درباره') }} {{ $location->title }}</h3>
                    <div class="card">
                        <div class="card-body">
                            {!! nl2br(e($location->description)) !!}
                        </div>
                    </div>
                </div>
            @endif

            @if (!empty($amenities) && count($amenities) > 0)
                <div class="mb-4">
                    <h3 class="border-start border-4 border-primary ps-2 mb-3">{{ __('امکانات') }}</h3>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                @foreach ($amenities as $amenity)
                                    <div class="col-md-6 col-lg-4 mb-2">
                                        <i class="fas {{ $amenity->icon }} me-2 text-primary"></i>
                                        {{ $amenity->title }}
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if (!empty($location->lat) && !empty($location->lng) && $location->categoryRelation &&
                 $location->categoryRelation->activeTemplateRelation &&
                 is_object($location->categoryRelation->activeTemplateRelation) &&
                 method_exists($location->categoryRelation->activeTemplateRelation, 'isFeatureEnabled') &&
                 $location->categoryRelation->activeTemplateRelation->isFeatureEnabled('map'))
                <div class="mb-4">
                    <h3 class="border-start border-4 border-primary ps-2 mb-3">{{ __('موقعیت') }} {{ $location->title }} {{ __('روی نقشه') }}</h3>
                    <div id="map" class="rounded" style="height: 400px;"></div>
                </div>
            @endif

            @if ($location->categoryRelation &&
                 $location->categoryRelation->activeTemplateRelation &&
                 is_object($location->categoryRelation->activeTemplateRelation) &&
                 method_exists($location->categoryRelation->activeTemplateRelation, 'isFeatureEnabled') &&
                 $location->categoryRelation->activeTemplateRelation->isFeatureEnabled('ratings'))
                <div class="mb-4 p-4 bg-light rounded">
                    <h3 class="border-start border-4 border-primary ps-2 mb-4">{{ __('نظرات کاربران') }}</h3>

                    @php
                        // نمایش 3 نظر آخر
                        $recentReviews = \App\Models\Rating::where('title_id', $location->title_id)
                            ->where('status', 'approved')
                            ->orderBy('timestamp', 'desc')
                            ->take(3)
                            ->get();

                        $hasMoreReviews = \App\Models\Rating::where('title_id', $location->title_id)
                            ->where('status', 'approved')
                            ->count() > 3;
                    @endphp

                    @if ($recentReviews->count() > 0)
                        <div class="mb-4">
                            @foreach ($recentReviews as $review)
                                <div class="card mb-3">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>{{ $review->name }}</strong>
                                            @if (!empty($review->trip_type))
                                                <span class="badge bg-secondary ms-2">{{ __($review->trip_type) }}</span>
                                            @endif
                                            <small class="text-muted ms-2">
                                                {{ $review->timestamp->format('Y/m/d') }}
                                            </small>
                                        </div>
                                        <div>
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($i <= $review->rating)
                                                    <i class="fas fa-star text-warning"></i>
                                                @else
                                                    <i class="far fa-star text-warning"></i>
                                                @endif
                                            @endfor
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        @if (!empty($review->positive_comment))
                                            <p class="text-success small mb-2">
                                                <i class="fas fa-plus-circle me-1"></i> {{ __('نکات مثبت') }}:
                                                {{ $review->positive_comment }}
                                            </p>
                                        @endif

                                        @if (!empty($review->negative_comment))
                                            <p class="text-danger small mb-0">
                                                <i class="fas fa-minus-circle me-1"></i> {{ __('نکات منفی') }}:
                                                {{ $review->negative_comment }}
                                            </p>
                                        @endif

                                        @if (!empty($review->comment))
                                            <p class="mt-3 mb-0">{{ $review->comment }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="text-center">
                            <a href="{{ route('reviews.index', ['location_id' => $location->title_id]) }}" class="btn btn-outline-primary me-2">
                                {{ __('مشاهده همه نظرات') }}
                                @if ($hasMoreReviews)
                                    <span class="badge bg-primary ms-1">{{ __('بیشتر') }}</span>
                                @endif
                            </a>
                            <a href="{{ route('reviews.create', ['location_id' => $location->title_id]) }}" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-1"></i> {{ __('ثبت نظر جدید') }}
                            </a>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <p>{{ __('تاکنون نظری برای این مکان ثبت نشده است.') }}</p>
                            <a href="{{ route('reviews.create', ['location_id' => $location->title_id]) }}" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-1"></i> {{ __('اولین نظر را شما ثبت کنید') }}
                            </a>
                        </div>
                    @endif
                </div>
            @endif
        </div>

        <div class="col-md-4">
            <div class="sticky-top" style="top: 20px; z-index: 100;">
                <!-- کارت اطلاعات تماس -->
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <i class="fas fa-info-circle me-1"></i> {{ __('اطلاعات تماس') }}
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0">
                            @if (!empty($location->phone))
                                <li class="mb-3">
                                    <i class="fas fa-phone me-2 text-primary"></i>
                                    <a href="tel:{{ $location->phone }}" class="text-decoration-none">
                                        {{ $location->phone }}
                                    </a>
                                </li>
                            @endif

                            @if (!empty($location->url))
                                <li class="mb-3">
                                    <i class="fas fa-globe me-2 text-primary"></i>
                                    <a href="{{ $location->url }}" target="_blank" class="text-decoration-none">
                                        {{ __('وب‌سایت') }}
                                    </a>
                                </li>
                            @endif

                            @if (!empty($location->address))
                                <li class="mb-3">
                                    <i class="fas fa-map-marker-alt me-2 text-primary"></i>
                                    {{ $location->getStructuredAddress(app()->getLocale()) }}
                                </li>
                            @endif

                            @if (!empty($location->open_hours) || !empty($location->closing_hours))
                                <li>
                                    <i class="far fa-clock me-2 text-primary"></i>
                                    {{ __('ساعت کار') }}:
                                    @if (!empty($location->open_hours) && !empty($location->closing_hours))
                                        {{ $location->open_hours }} {{ __('الی') }} {{ $location->closing_hours }}
                                    @elseif (!empty($location->open_hours))
                                        {{ __('از') }} {{ $location->open_hours }}
                                    @elseif (!empty($location->closing_hours))
                                        {{ __('تا') }} {{ $location->closing_hours }}
                                    @endif
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>

                <!-- مکان‌های مرتبط -->
                @php
                    $relatedLocations = [];

                    if (!empty($location->category)) {
                        $relatedLocations = \App\Models\Location::where('category', $location->category)
                            ->where('id', '!=', $location->id)
                            ->where('is_active', 1)
                            ->take(5)
                            ->get();
                    }
                @endphp

                @if (count($relatedLocations) > 0)
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <i class="fas fa-link me-1"></i> {{ __('مکان‌های مرتبط') }}
                        </div>
                        <div class="card-body p-0">
                            <ul class="list-group list-group-flush">
                                @foreach ($relatedLocations as $related)
                                    <li class="list-group-item">
                                        <a href="{{ route('locations.show', $related->id) }}" class="text-decoration-none d-flex align-items-center">
                                            @if (!empty($related->images))
                                                @php
                                                    $relatedImages = is_array($related->images) ? $related->images : (json_decode($related->images, true) ?? []);
                                                    $firstImage = !empty($relatedImages) ? $relatedImages[0] : null;
                                                @endphp

                                                @if (!empty($firstImage))
                                                    <img src="{{ asset('storage/' . $firstImage) }}" class="rounded me-2" style="width: 50px; height: 50px; object-fit: cover;" alt="{{ $related->title }}">
                                                @endif
                                            @endif

                                            <span>{{ $related->title }}</span>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@if (!empty($location->lat) && !empty($location->lng) && $location->categoryRelation &&
     $location->categoryRelation->activeTemplateRelation &&
     is_object($location->categoryRelation->activeTemplateRelation) &&
     method_exists($location->categoryRelation->activeTemplateRelation, 'isFeatureEnabled') &&
     $location->categoryRelation->activeTemplateRelation->isFeatureEnabled('map'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mapElement = document.getElementById('map');

            if (mapElement) {
                const map = new google.maps.Map(mapElement, {
                    center: {
                        lat: {{ $location->lat }},
                        lng: {{ $location->lng }}
                    },
                    zoom: 15
                });

                new google.maps.Marker({
                    position: {
                        lat: {{ $location->lat }},
                        lng: {{ $location->lng }}
                    },
                    map: map,
                    title: '{{ $location->title }}'
                });
            }
        });
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}" async defer></script>
@endif
@endpush