<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'fa' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'پنل مدیریت') - {{ config('app.name', 'اَلو ایران') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Persian Font -->
    @if(app()->getLocale() == 'fa')
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
        <style>
            body, .form-control, .btn, .card, .navbar, .dropdown-menu {
                font-family: 'Vazirmatn', sans-serif !important;
            }
        </style>
    @endif

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Admin Panel Styles -->
    <style>
        :root {
            --admin-primary: #4e73df;
            --admin-secondary: #858796;
            --admin-success: #1cc88a;
            --admin-info: #36b9cc;
            --admin-warning: #f6c23e;
            --admin-danger: #e74a3b;
            --admin-light: #f8f9fc;
            --admin-dark: #5a5c69;
        }

        body {
            background-color: var(--admin-light);
            font-size: 0.875rem;
        }

        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, var(--admin-primary) 10%, #224abe 100%);
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }

        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 1rem;
            border-radius: 0.35rem;
            margin: 0.25rem 1rem;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: #fff;
            background-color: rgba(255, 255, 255, 0.1);
        }

        .sidebar .nav-link i {
            margin-left: 0.5rem;
            width: 1rem;
            text-align: center;
        }

        .topbar {
            background-color: #fff;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }

        .card {
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            border: none;
        }

        .card-header {
            background-color: var(--admin-light);
            border-bottom: 1px solid #e3e6f0;
        }

        .btn-primary {
            background-color: var(--admin-primary);
            border-color: var(--admin-primary);
        }

        .btn-primary:hover {
            background-color: #2653d4;
            border-color: #2653d4;
        }

        .text-primary {
            color: var(--admin-primary) !important;
        }

        .bg-primary {
            background-color: var(--admin-primary) !important;
        }

        /* RTL Styles */
        [dir="rtl"] .sidebar .nav-link i {
            margin-left: 0;
            margin-right: 0.5rem;
        }

        [dir="rtl"] .sidebar {
            border-radius: 0 0.35rem 0.35rem 0;
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 0.5rem;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--admin-secondary);
            border-radius: 0.25rem;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--admin-dark);
        }

        /* Animation */
        .fade-in {
            animation: fadeIn 0.3s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                right: -250px;
                width: 250px;
                height: 100vh;
                z-index: 1050;
                transition: right 0.3s ease;
            }

            .sidebar.show {
                right: 0;
            }

            .content-wrapper {
                margin-right: 0 !important;
            }
        }
    </style>

    @stack('styles')
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <nav class="sidebar" id="sidebar">
            <div class="p-3">
                <!-- Logo -->
                <div class="text-center mb-4">
                    <h4 class="text-white mb-0">
                        <i class="fas fa-cogs me-2"></i>
                        پنل مدیریت
                    </h4>
                </div>

                <!-- Navigation -->
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.dashboard*') ? 'active' : '' }}" href="{{ url('/admin/dashboard') }}">
                            <i class="fas fa-tachometer-alt"></i>
                            داشبورد
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.header-settings.*') ? 'active' : '' }}" href="{{ url('/admin/header-settings') }}">
                            <i class="fas fa-cog"></i>
                            تنظیمات هدر و منو
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.user-menu.*') ? 'active' : '' }}" href="{{ url('/admin/user-menu') }}">
                            <i class="fas fa-users-cog"></i>
                            مدیریت منوی کاربری
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.locations.*') ? 'active' : '' }}" href="#">
                            <i class="fas fa-map-marker-alt"></i>
                            مدیریت مکان‌ها
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}" href="#">
                            <i class="fas fa-users"></i>
                            مدیریت کاربران
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.advertisements.*') ? 'active' : '' }}" href="#">
                            <i class="fas fa-ad"></i>
                            مدیریت تبلیغات
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('admin.reports.*') ? 'active' : '' }}" href="{{ route('admin.reports.locations') }}">
                            <i class="fas fa-chart-bar"></i>
                            گزارشات
                        </a>
                    </li>

                    <hr class="my-3" style="border-color: rgba(255,255,255,0.2);">
                    
                    <li class="nav-item">
                        <a class="nav-link" href="{{ url('/') }}" target="_blank">
                            <i class="fas fa-external-link-alt"></i>
                            مشاهده سایت
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="fas fa-sign-out-alt"></i>
                            خروج
                        </a>
                        <form id="logout-form" action="{{ url('/admin/logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="flex-grow-1 content-wrapper" style="margin-right: 250px;">
            <!-- Top Bar -->
            <nav class="navbar navbar-expand topbar mb-4 static-top">
                <div class="container-fluid">
                    <!-- Mobile Menu Toggle -->
                    <button class="btn btn-link d-md-none" type="button" onclick="toggleSidebar()">
                        <i class="fas fa-bars"></i>
                    </button>

                    <!-- Breadcrumb -->
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin/dashboard') }}">داشبورد</a>
                        </li>
                        @if(isset($breadcrumb))
                            @foreach($breadcrumb as $item)
                                @if($loop->last)
                                    <li class="breadcrumb-item active">{{ $item['title'] }}</li>
                                @else
                                    <li class="breadcrumb-item">
                                        <a href="{{ $item['url'] }}">{{ $item['title'] }}</a>
                                    </li>
                                @endif
                            @endforeach
                        @endif
                    </ol>

                    <!-- User Info -->
                    <div class="navbar-nav ms-auto">
                        <div class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-user-circle me-1"></i>
                                {{ auth()->user()->name ?? 'مدیر' }}
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="#"><i class="fas fa-user me-2"></i>پروفایل</a></li>
                                <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i>تنظیمات</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <a class="dropdown-item" href="#" onclick="event.preventDefault(); document.getElementById('logout-form-top').submit();">
                                        <i class="fas fa-sign-out-alt me-2"></i>خروج
                                    </a>
                                    <form id="logout-form-top" action="{{ url('/admin/logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Page Content -->
            <div class="container-fluid fade-in">
                <!-- Alerts -->
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        {{ session('warning') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <strong>خطاهای زیر رخ داده است:</strong>
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Main Content -->
                @yield('content')
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>

    <!-- Locale Date Manager -->
    <script src="{{ asset('js/locale-date-manager.js') }}"></script>

    <!-- Admin Panel Scripts -->
    <script>
        // Toggle sidebar for mobile
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('show');
        }

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const toggleBtn = event.target.closest('[onclick="toggleSidebar()"]');
            
            if (!sidebar.contains(event.target) && !toggleBtn && window.innerWidth <= 768) {
                sidebar.classList.remove('show');
            }
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);

        // Confirm delete actions
        function confirmDelete(message = 'آیا از حذف این مورد اطمینان دارید؟') {
            return confirm(message);
        }

        // Show loading state
        function showLoading(element) {
            const originalText = element.innerHTML;
            element.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال پردازش...';
            element.disabled = true;
            
            return function() {
                element.innerHTML = originalText;
                element.disabled = false;
            };
        }
    </script>

    @stack('scripts')
</body>
</html>
