@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <h1 class="mb-4">دسته‌بندی‌ها</h1>
        </div>
    </div>

    {{-- فیلتر جغرافیایی --}}
    <x-geographic-filter :countries="$countries" />

    <div class="row">
        @foreach($parentCategories as $parentCategory)
            <div class="col-md-4 mb-4">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            @if($parentCategory->emoji)
                                <span class="fs-4 me-2">{{ $parentCategory->emoji }}</span>
                            @elseif($parentCategory->font_icon)
                                <i class="fas fa-{{ $parentCategory->font_icon }} fs-4 me-2"></i>
                            @endif
                            <h5 class="card-title mb-0">
                                {{ $parentCategory->getTranslatedName(app()->getLocale()) }}
                                @if(isset($locationCounts[$parentCategory->id]))
                                    <span class="badge bg-primary ms-2">{{ $locationCounts[$parentCategory->id] }}</span>
                                @endif
                            </h5>
                        </div>

                        @if($parentCategory->getTranslatedDescription(app()->getLocale()))
                            <p class="card-text text-muted">{{ $parentCategory->getTranslatedDescription(app()->getLocale()) }}</p>
                        @endif

                        @php
                            $categoryChildren = $childCategories->where('parent_id', $parentCategory->id);
                        @endphp

                        @if($categoryChildren->count() > 0)
                            <div class="mt-3">
                                <h6 class="text-muted mb-2">زیردسته‌ها:</h6>
                                <div class="list-group">
                                    @foreach($categoryChildren as $child)
                                        <a href="{{ route('categories.show', $child->category_key) }}" class="list-group-item list-group-item-action">
                                            <div>
                                                {{ $child->getTranslatedName(app()->getLocale()) }}
                                                @if($child->getTranslatedDescription(app()->getLocale()))
                                                    <small class="d-block text-muted">{{ $child->getTranslatedDescription(app()->getLocale()) }}</small>
                                                @endif
                                            </div>
                                            @if(isset($locationCounts[$child->id]))
                                                <span class="badge bg-primary float-end">{{ $locationCounts[$child->id] }}</span>
                                            @endif
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection

@push('styles')
<style>
    .card {
        transition: transform 0.2s;
        border: none;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .card:hover {
        transform: translateY(-5px);
    }

    .card-title {
        color: #333;
    }

    .list-unstyled li a {
        color: #666;
        transition: color 0.2s;
    }

    .list-unstyled li a:hover {
        color: #007bff;
    }

    .badge {
        font-size: 0.8rem;
        padding: 0.25em 0.6em;
    }
</style>
@endpush

@push('scripts')
<script>
// تابع به‌روزرسانی نتایج بر اساس فیلترهای جغرافیایی
function updateResults() {
    // ساخت پارامترهای URL بر اساس فیلترهای فعال
    const params = new URLSearchParams();
    
    if (activeGeoFilters.country) params.append('country', activeGeoFilters.country);
    if (activeGeoFilters.province) params.append('province', activeGeoFilters.province);
    if (activeGeoFilters.county) params.append('county', activeGeoFilters.county);
    if (activeGeoFilters.district) params.append('district', activeGeoFilters.district);
    if (activeGeoFilters.city) params.append('city', activeGeoFilters.city);
    if (activeGeoFilters.village) params.append('village', activeGeoFilters.village);
    if (activeGeoFilters.zone) params.append('zone', activeGeoFilters.zone);
    
    // به‌روزرسانی URL بدون بارگذاری مجدد صفحه
    const newUrl = window.location.pathname + (params.toString() ? '?' + params.toString() : '');
    window.history.pushState({}, '', newUrl);
    
    // در اینجا می‌توانید درخواست AJAX برای فیلتر کردن دسته‌بندی‌ها ارسال کنید
    // یا صفحه را مجدداً بارگذاری کنید
    // window.location.reload();
}
</script>
@endpush