@extends('admin.layouts.app')

@section('title', 'تنظیمات سایت')

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
<style>
    .custom-file {
        position: relative;
        display: inline-block;
        width: 100%;
        height: calc(1.5em + .75rem + 2px);
        margin-bottom: 0;
    }

    .custom-file-input {
        position: relative;
        z-index: 2;
        width: 100%;
        height: calc(1.5em + .75rem + 2px);
        margin: 0;
        opacity: 0;
    }

    .custom-file-label {
        position: absolute;
        top: 0;
        right: 0;
        left: 0;
        z-index: 1;
        height: calc(1.5em + .75rem + 2px);
        padding: .375rem .75rem;
        font-weight: 400;
        line-height: 1.5;
        color: #495057;
        background-color: #fff;
        border: 1px solid #ced4da;
        border-radius: .25rem;
        cursor: pointer;
    }

    .custom-file-input:focus ~ .custom-file-label {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
    }

    .img-thumbnail {
        padding: .25rem;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: .25rem;
        max-width: 100%;
        height: auto;
    }

    .btn-danger {
        color: #fff;
        background-color: #dc3545;
        border-color: #dc3545;
    }

    .btn-danger:hover {
        color: #fff;
        background-color: #c82333;
        border-color: #bd2130;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات سایت</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="site_title">عنوان سایت</label>
                                    <input type="text" class="form-control @error('site_title') is-invalid @enderror" 
                                           id="site_title" name="site_title" 
                                           value="{{ $settings['site_title'] ?? old('site_title') }}" required>
                                    @error('site_title')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="theme_color">رنگ تم</label>
                                    <input type="color" class="form-control @error('theme_color') is-invalid @enderror" 
                                           id="theme_color" name="theme_color" 
                                           value="{{ $settings['theme_color'] ?? old('theme_color', '#000000') }}">
                                    @error('theme_color')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="site_icon">آیکون سایت</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('site_icon') is-invalid @enderror" 
                                               id="site_icon" name="site_icon" accept="image/*">
                                        <label class="custom-file-label" for="site_icon">انتخاب فایل</label>
                                    </div>
                                    @error('site_icon')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    @if(isset($settings['site_icon']))
                                        <div class="mt-2">
                                            <img src="{{ $settings['site_icon'] }}" alt="آیکون سایت" class="img-thumbnail" style="max-width: 100px;">
                                            <button type="button" class="btn btn-sm btn-danger mt-1" onclick="removeImage('site_icon')">حذف</button>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="favicon">فاویکون</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('favicon') is-invalid @enderror" 
                                               id="favicon" name="favicon" accept="image/*">
                                        <label class="custom-file-label" for="favicon">انتخاب فایل</label>
                                    </div>
                                    @error('favicon')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    @if(isset($settings['favicon']))
                                        <div class="mt-2">
                                            <img src="{{ $settings['favicon'] }}" alt="فاویکون" class="img-thumbnail" style="max-width: 100px;">
                                            <button type="button" class="btn btn-sm btn-danger mt-1" onclick="removeImage('favicon')">حذف</button>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="logo">لوگو</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('logo') is-invalid @enderror" 
                                               id="logo" name="logo" accept="image/*">
                                        <label class="custom-file-label" for="logo">انتخاب فایل</label>
                                    </div>
                                    @error('logo')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    @if(isset($settings['logo']))
                                        <div class="mt-2">
                                            <img src="{{ $settings['logo'] }}" alt="لوگو" class="img-thumbnail" style="max-width: 100px;">
                                            <button type="button" class="btn btn-sm btn-danger mt-1" onclick="removeImage('logo')">حذف</button>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="logo_text">متن لوگو</label>
                                    <input type="text" class="form-control @error('logo_text') is-invalid @enderror" 
                                           id="logo_text" name="logo_text" 
                                           value="{{ $settings['logo_text'] ?? old('logo_text') }}"
                                           placeholder="متن نمایشی کنار لوگو">
                                    @error('logo_text')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">این متن در کنار لوگوی سایت نمایش داده می‌شود</small>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="meta_title">عنوان متا</label>
                                    <input type="text" class="form-control @error('meta_title') is-invalid @enderror" 
                                           id="meta_title" name="meta_title" 
                                           value="{{ $settings['meta_title'] ?? old('meta_title') }}">
                                    @error('meta_title')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="meta_description">توضیحات متا</label>
                                    <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                                              id="meta_description" name="meta_description" rows="3">{{ $settings['meta_description'] ?? old('meta_description') }}</textarea>
                                    @error('meta_description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="meta_keywords">کلمات کلیدی متا</label>
                                    <input type="text" class="form-control @error('meta_keywords') is-invalid @enderror" 
                                           id="meta_keywords" name="meta_keywords" 
                                           value="{{ $settings['meta_keywords'] ?? old('meta_keywords') }}">
                                    @error('meta_keywords')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="footer_text">متن فوتر</label>
                                    <textarea class="form-control @error('footer_text') is-invalid @enderror" 
                                              id="footer_text" name="footer_text" rows="3">{{ $settings['footer_text'] ?? old('footer_text') }}</textarea>
                                    @error('footer_text')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="contact_email">ایمیل تماس</label>
                                    <input type="email" class="form-control @error('contact_email') is-invalid @enderror" 
                                           id="contact_email" name="contact_email" 
                                           value="{{ $settings['contact_email'] ?? old('contact_email') }}">
                                    @error('contact_email')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="contact_phone">تلفن تماس</label>
                                    <input type="text" class="form-control @error('contact_phone') is-invalid @enderror" 
                                           id="contact_phone" name="contact_phone" 
                                           value="{{ $settings['contact_phone'] ?? old('contact_phone') }}">
                                    @error('contact_phone')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="contact_address">آدرس تماس</label>
                                    <input type="text" class="form-control @error('contact_address') is-invalid @enderror" 
                                           id="contact_address" name="contact_address" 
                                           value="{{ $settings['contact_address'] ?? old('contact_address') }}">
                                    @error('contact_address')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="google_analytics_id">شناسه گوگل آنالیتیکس</label>
                                    <input type="text" class="form-control @error('google_analytics_id') is-invalid @enderror" 
                                           id="google_analytics_id" name="google_analytics_id" 
                                           value="{{ $settings['google_analytics_id'] ?? old('google_analytics_id') }}">
                                    @error('google_analytics_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="google_maps_api_key">کلید API گوگل مپس</label>
                                    <input type="text" class="form-control @error('google_maps_api_key') is-invalid @enderror" 
                                           id="google_maps_api_key" name="google_maps_api_key" 
                                           value="{{ $settings['google_maps_api_key'] ?? old('google_maps_api_key') }}">
                                    @error('google_maps_api_key')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="maintenance_message">پیام حالت تعمیر و نگهداری</label>
                                    <textarea class="form-control @error('maintenance_message') is-invalid @enderror" 
                                              id="maintenance_message" name="maintenance_message" rows="3">{{ $settings['maintenance_message'] ?? old('maintenance_message') }}</textarea>
                                    @error('maintenance_message')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="custom_css">CSS سفارشی</label>
                                    <textarea class="form-control @error('custom_css') is-invalid @enderror" 
                                              id="custom_css" name="custom_css" rows="5">{{ $settings['custom_css'] ?? old('custom_css') }}</textarea>
                                    @error('custom_css')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="custom_js">JavaScript سفارشی</label>
                                    <textarea class="form-control @error('custom_js') is-invalid @enderror" 
                                              id="custom_js" name="custom_js" rows="5">{{ $settings['custom_js'] ?? old('custom_js') }}</textarea>
                                    @error('custom_js')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">عملیات کش</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.clear-cache') }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-warning">پاک کردن کش</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">حالت تعمیر و نگهداری</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.toggle-maintenance') }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-danger">
                            {{ isset($settings['maintenance_mode']) && $settings['maintenance_mode'] ? 'غیرفعال کردن حالت تعمیر' : 'فعال کردن حالت تعمیر' }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<!-- Load jQuery first -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Then load other dependencies -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.all.min.js"></script>

<script>
    // تعریف تابع removeImage در سطح global
    function removeImage(fieldName) {
        if (confirm('آیا از حذف این تصویر اطمینان دارید؟')) {
            // پیدا کردن فرم والد
            const form = document.querySelector('form[action*="settings"]');
            if (!form) return;
            
            // ایجاد یک input مخفی برای ارسال درخواست حذف
            let input = form.querySelector(`input[name='remove_${fieldName}']`);
            if (!input) {
                input = document.createElement('input');
                input.type = 'hidden';
                input.name = `remove_${fieldName}`;
                input.value = '1';
                form.appendChild(input);
            }

            // حذف نمایش تصویر
            const imageContainer = document.querySelector(`#${fieldName}`).closest('.form-group').querySelector('.mt-2');
            if (imageContainer) {
                imageContainer.remove();
            }

            // پاک کردن مقدار فایل
            const fileInput = document.querySelector(`#${fieldName}`);
            if (fileInput) {
                fileInput.value = '';
                const label = fileInput.nextElementSibling;
                if (label && label.classList.contains('custom-file-label')) {
                    label.textContent = 'انتخاب فایل';
                }
            }

            // اضافه کردن کلاس loading به دکمه submit
            const submitButton = form.querySelector('button[type="submit"]');
            if (submitButton) {
                submitButton.disabled = true;
                submitButton.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> در حال ذخیره...';
            }
        }
    }

    // اضافه کردن تابع به window object
    window.removeImage = removeImage;

    // Initialize when document is ready
    $(document).ready(function() {
        // اضافه کردن کلاس‌های بوت‌استرپ به فرم‌ها
        $('input, textarea, select').addClass('form-control');

        // اضافه کردن کلاس‌های بوت‌استرپ به دکمه‌ها
        $('button[type="submit"]').addClass('btn btn-primary');

        // نمایش نام فایل انتخاب شده
        $('.custom-file-input').on('change', function(e) {
            let fileName = e.target.files[0]?.name || 'انتخاب فایل';
            $(this).next('.custom-file-label').text(fileName);
        });

        // پیش‌نمایش تصویر قبل از آپلود
        $('input[type="file"]').on('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // حذف پیش‌نمایش قبلی
                    const formGroup = $(this).closest('.form-group');
                    formGroup.find('.mt-2').remove();
                    
                    // ایجاد پیش‌نمایش جدید
                    const preview = $('<div>', {
                        class: 'mt-2'
                    }).html(`
                        <img src="${e.target.result}" alt="پیش‌نمایش" class="img-thumbnail" style="max-width: 100px;">
                        <button type="button" class="btn btn-sm btn-danger mt-1" onclick="removeImage('${this.id}')">حذف</button>
                    `);
                    formGroup.append(preview);
                }.bind(this);
                reader.readAsDataURL(file);
            }
        });
    });
</script>
@endpush 