@extends('admin.layouts.app')

@section('title', 'تنظیمات سیستم امتیازدهی')

@section('styles')
<style>
    .settings-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        border: none;
        margin-bottom: 25px;
    }
    .settings-card .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px 15px 0 0;
        border: none;
        padding: 20px;
    }
    .form-switch .form-check-input {
        width: 3rem;
        height: 1.5rem;
    }
    .form-switch .form-check-input:checked {
        background-color: #28a745;
        border-color: #28a745;
    }
    .setting-item {
        padding: 20px;
        border-bottom: 1px solid #e3e6f0;
        transition: background-color 0.3s ease;
    }
    .setting-item:hover {
        background-color: #f8f9fc;
    }
    .setting-item:last-child {
        border-bottom: none;
    }
    .setting-icon {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 20px;
    }
    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 30px;
        margin-bottom: 30px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h2 class="mb-2">
                    <i class="fas fa-cog me-3"></i>
                    تنظیمات سیستم امتیازدهی
                </h2>
                <p class="mb-0 opacity-75">مدیریت تنظیمات عمومی سیستم امتیازدهی و نظرات</p>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('admin.ratings.index') }}" class="btn btn-light">
                    <i class="fas fa-arrow-right"></i> بازگشت به لیست
                </a>
            </div>
        </div>
    </div>

    <form action="{{ route('admin.ratings.settings.update') }}" method="POST" id="settingsForm">
        @csrf
        
        <!-- تنظیمات تایید خودکار -->
        <div class="settings-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-check-circle me-2"></i>
                    تنظیمات تایید خودکار
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="setting-item">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="setting-icon bg-success text-white">
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="mb-1">تایید خودکار امتیازات</h6>
                            <p class="text-muted mb-0">امتیازات جدید به صورت خودکار تایید شوند</p>
                        </div>
                        <div class="col-auto">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="auto_approve_ratings" id="autoApproveRatings">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="setting-item">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="setting-icon bg-info text-white">
                                <i class="fas fa-comments"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="mb-1">تایید خودکار نظرات</h6>
                            <p class="text-muted mb-0">نظرات جدید به صورت خودکار تایید شوند</p>
                        </div>
                        <div class="col-auto">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="auto_approve_comments" id="autoApproveComments">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تنظیمات کاربران -->
        <div class="settings-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-users me-2"></i>
                    تنظیمات کاربران
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="setting-item">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="setting-icon bg-warning text-white">
                                <i class="fas fa-envelope"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="mb-1">الزام تایید ایمیل</h6>
                            <p class="text-muted mb-0">کاربران باید ایمیل خود را تایید کنند</p>
                        </div>
                        <div class="col-auto">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="require_email_verification" id="requireEmailVerification">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="setting-item">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="setting-icon bg-secondary text-white">
                                <i class="fas fa-user-secret"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="mb-1">امکان امتیازدهی ناشناس</h6>
                            <p class="text-muted mb-0">کاربران بتوانند بدون ثبت نام امتیاز دهند</p>
                        </div>
                        <div class="col-auto">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="allow_anonymous_ratings" id="allowAnonymousRatings">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تنظیمات نظرات -->
        <div class="settings-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-comment-alt me-2"></i>
                    تنظیمات نظرات
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="minCommentLength" class="form-label">حداقل طول نظر (کاراکتر)</label>
                            <input type="number" class="form-control" name="min_rating_comment_length" id="minCommentLength" value="10" min="0" max="1000">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="maxCommentLength" class="form-label">حداکثر طول نظر (کاراکتر)</label>
                            <input type="number" class="form-control" name="max_rating_comment_length" id="maxCommentLength" value="2000" min="100" max="5000">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تنظیمات ویژگی‌ها -->
        <div class="settings-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-tools me-2"></i>
                    تنظیمات ویژگی‌ها
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="setting-item">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="setting-icon bg-primary text-white">
                                <i class="fas fa-thumbs-up"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="mb-1">فعال‌سازی رای مفید/غیرمفید</h6>
                            <p class="text-muted mb-0">کاربران بتوانند به نظرات رای مفید یا غیرمفید دهند</p>
                        </div>
                        <div class="col-auto">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="enable_helpful_votes" id="enableHelpfulVotes" checked>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="setting-item">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="setting-icon bg-danger text-white">
                                <i class="fas fa-reply"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="mb-1">فعال‌سازی پاسخ مدیران</h6>
                            <p class="text-muted mb-0">مدیران بتوانند به نظرات پاسخ دهند</p>
                        </div>
                        <div class="col-auto">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="enable_admin_replies" id="enableAdminReplies" checked>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- دکمه‌های عملیات -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body text-center">
                        <button type="submit" class="btn btn-primary btn-lg me-3">
                            <i class="fas fa-save"></i> ذخیره تنظیمات
                        </button>
                        <a href="{{ route('admin.ratings.index') }}" class="btn btn-secondary btn-lg">
                            <i class="fas fa-times"></i> انصراف
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // ذخیره تنظیمات با AJAX
    $('#settingsForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        // تبدیل چک‌باکس‌ها به مقادیر boolean
        $('input[type="checkbox"]').each(function() {
            if (this.checked) {
                formData.set(this.name, '1');
            } else {
                formData.set(this.name, '0');
            }
        });
        
        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                Swal.fire({
                    title: 'موفق!',
                    text: 'تنظیمات با موفقیت ذخیره شد.',
                    icon: 'success',
                    confirmButtonText: 'باشه'
                });
            },
            error: function(xhr) {
                let errorMessage = 'خطایی در ذخیره تنظیمات رخ داد.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    title: 'خطا!',
                    text: errorMessage,
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
            }
        });
    });
    
    // انیمیشن برای تغییر وضعیت سوئیچ‌ها
    $('.form-check-input').change(function() {
        const settingItem = $(this).closest('.setting-item');
        settingItem.addClass('bg-light');
        setTimeout(() => {
            settingItem.removeClass('bg-light');
        }, 300);
    });
});
</script>
@endsection
