@extends('admin.layouts.app')

@section('title', 'مدیریت امتیازات و نظرات')

@section('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.css">
<style>
    .stats-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 15px;
        color: white;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .stats-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.15);
    }
    .stats-card.success {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    }
    .stats-card.warning {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }
    .stats-card.info {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }
    .stats-card.danger {
        background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    }
    .filter-card {
        background: #f8f9fc;
        border-radius: 15px;
        border: none;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .rating-stars {
        color: #ffc107;
    }
    .rating-table {
        background: white;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .table th {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        font-weight: 600;
        text-align: center;
    }
    .table td {
        vertical-align: middle;
        text-align: center;
        border-color: #e3e6f0;
    }
    .status-badge {
        padding: 8px 16px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 12px;
    }
    .btn-action {
        border-radius: 20px;
        padding: 6px 12px;
        margin: 2px;
        border: none;
        transition: all 0.3s ease;
    }
    .btn-action:hover {
        transform: scale(1.1);
    }
    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 30px;
        margin-bottom: 30px;
    }
    .chart-container {
        background: white;
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        margin-bottom: 20px;
        position: relative;
        height: 300px;
        overflow: hidden;
    }
    .chart-container canvas {
        max-height: 250px !important;
    }
    .bulk-actions {
        background: #f8f9fc;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 20px;
        display: none;
    }
    .bulk-actions.show {
        display: block;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h2 class="mb-2">
                    <i class="fas fa-star me-3"></i>
                    مدیریت امتیازات و نظرات
                </h2>
                <p class="mb-0 opacity-75">مدیریت جامع سیستم امتیازدهی و نظرات کاربران</p>
            </div>
            <div class="col-md-4 text-end">
                <div class="btn-group">
                    <a href="{{ route('admin.ratings.dashboard') }}" class="btn btn-light">
                        <i class="fas fa-chart-bar"></i> داشبورد
                    </a>
                    <a href="{{ route('admin.ratings.analytics') }}" class="btn btn-light">
                        <i class="fas fa-analytics"></i> آنالیز
                    </a>
                    <a href="{{ route('admin.ratings.settings') }}" class="btn btn-light">
                        <i class="fas fa-cog"></i> تنظیمات
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stats-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">کل امتیازات</div>
                            <div class="h5 mb-0 font-weight-bold">{{ number_format($stats['total_ratings']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-star fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stats-card warning">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">در انتظار تایید</div>
                            <div class="h5 mb-0 font-weight-bold">{{ number_format($stats['pending_ratings']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stats-card success">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">تایید شده</div>
                            <div class="h5 mb-0 font-weight-bold">{{ number_format($stats['approved_ratings']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stats-card info">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">میانگین امتیاز</div>
                            <div class="h5 mb-0 font-weight-bold">{{ number_format($stats['average_rating'], 1) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters -->
    <div class="card filter-card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.ratings.index') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-2">
                        <label class="form-label">وضعیت</label>
                        <select name="status" class="form-select">
                            <option value="all" {{ $status == 'all' ? 'selected' : '' }}>همه</option>
                            <option value="pending" {{ $status == 'pending' ? 'selected' : '' }}>در انتظار</option>
                            <option value="approved" {{ $status == 'approved' ? 'selected' : '' }}>تایید شده</option>
                            <option value="rejected" {{ $status == 'rejected' ? 'selected' : '' }}>رد شده</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">دسته‌بندی</label>
                        <select name="category" class="form-select">
                            <option value="">همه دسته‌ها</option>
                            @foreach($categories as $cat)
                                <option value="{{ $cat }}" {{ $category == $cat ? 'selected' : '' }}>{{ $cat }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">امتیاز</label>
                        <select name="rating_filter" class="form-select">
                            <option value="">همه امتیازات</option>
                            @for($i = 5; $i >= 1; $i--)
                                <option value="{{ $i }}" {{ $rating_filter == $i ? 'selected' : '' }}>{{ $i }} ستاره</option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">از تاریخ</label>
                        <input type="date" name="date_from" class="form-control" value="{{ $date_from }}">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">تا تاریخ</label>
                        <input type="date" name="date_to" class="form-control" value="{{ $date_to }}">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">تعداد نمایش</label>
                        <select name="per_page" class="form-select">
                            <option value="15" {{ $per_page == 15 ? 'selected' : '' }}>15</option>
                            <option value="25" {{ $per_page == 25 ? 'selected' : '' }}>25</option>
                            <option value="50" {{ $per_page == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ $per_page == 100 ? 'selected' : '' }}>100</option>
                        </select>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-8">
                        <input type="text" name="search" class="form-control" placeholder="جستجو در نام، ایمیل، مکان یا نظرات..." value="{{ $search }}">
                    </div>
                    <div class="col-md-4">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-search"></i> جستجو
                        </button>
                        <a href="{{ route('admin.ratings.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> پاک کردن
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Bulk Actions -->
    <div class="bulk-actions" id="bulkActions">
        <div class="row align-items-center">
            <div class="col-md-6">
                <span class="text-muted">
                    <span id="selectedCount">0</span> مورد انتخاب شده
                </span>
            </div>
            <div class="col-md-6 text-end">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-sm" onclick="bulkAction('approve')">
                        <i class="fas fa-check"></i> تایید همه
                    </button>
                    <button type="button" class="btn btn-danger btn-sm" onclick="bulkAction('reject')">
                        <i class="fas fa-times"></i> رد همه
                    </button>
                    <button type="button" class="btn btn-warning btn-sm" onclick="bulkAction('delete')">
                        <i class="fas fa-trash"></i> حذف همه
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Ratings Table -->
    <div class="rating-table">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th width="50">
                            <input type="checkbox" id="selectAll" class="form-check-input">
                        </th>
                        <th>مکان</th>
                        <th>کاربر</th>
                        <th>امتیاز کلی</th>
                        <th>امتیازات تفصیلی</th>
                        <th>وضعیت</th>
                        <th>تاریخ</th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($ratings ?? [] as $rating)
                        <tr>
                            <td>
                                <input type="checkbox" class="form-check-input rating-checkbox" value="{{ $rating->id }}">
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div>
                                        <div class="fw-bold">{{ $rating->hotel_name }}</div>
                                        <small class="text-muted">{{ $rating->getLocalizedCategoryName() }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div>
                                    <div class="fw-bold">{{ $rating->name }}</div>
                                    <small class="text-muted">{{ $rating->email }}</small>
                                    @if($rating->user_phone)
                                        <br><small class="text-muted">{{ $rating->user_phone }}</small>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div class="text-center">
                                    <div class="rating-stars mb-1">
                                        @for($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star {{ $i <= $rating->rating ? 'text-warning' : 'text-muted' }}"></i>
                                        @endfor
                                    </div>
                                    <span class="badge bg-primary">{{ $rating->rating }}/5</span>
                                </div>
                            </td>
                            <td>
                                <div class="small">
                                    @if($rating->service_rating)
                                        <div><i class="fas fa-concierge-bell text-info"></i> خدمات: {{ $rating->service_rating }}/5</div>
                                    @endif
                                    @if($rating->cleanliness_rating)
                                        <div><i class="fas fa-broom text-success"></i> نظافت: {{ $rating->cleanliness_rating }}/5</div>
                                    @endif
                                    @if($rating->location_rating)
                                        <div><i class="fas fa-map-marker-alt text-danger"></i> موقعیت: {{ $rating->location_rating }}/5</div>
                                    @endif
                                    @if($rating->price_rating)
                                        <div><i class="fas fa-dollar-sign text-warning"></i> قیمت: {{ $rating->price_rating }}/5</div>
                                    @endif
                                    @if($rating->quality_rating)
                                        <div><i class="fas fa-star text-primary"></i> کیفیت: {{ $rating->quality_rating }}/5</div>
                                    @endif
                                </div>
                            </td>
                            <td>
                                @if($rating->status === 'approved')
                                    <span class="status-badge bg-success text-white">
                                        <i class="fas fa-check"></i> تایید شده
                                    </span>
                                @elseif($rating->status === 'rejected')
                                    <span class="status-badge bg-danger text-white">
                                        <i class="fas fa-times"></i> رد شده
                                    </span>
                                @else
                                    <span class="status-badge bg-warning text-dark">
                                        <i class="fas fa-clock"></i> در انتظار
                                    </span>
                                @endif
                                @if($rating->is_featured)
                                    <br><span class="badge bg-info mt-1">ویژه</span>
                                @endif
                                @if($rating->is_verified)
                                    <br><span class="badge bg-success mt-1">تایید شده</span>
                                @endif
                            </td>
                            <td>
                                <div class="text-center">
                                    <div>{{ $rating->timestamp ? $rating->timestamp->format('Y/m/d') : 'نامشخص' }}</div>
                                    <small class="text-muted">{{ $rating->timestamp ? $rating->timestamp->format('H:i') : '' }}</small>
                                </div>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-action btn-info view-rating"
                                        data-bs-toggle="modal" data-bs-target="#viewRatingModal"
                                        data-id="{{ $rating->id }}"
                                        data-name="{{ htmlspecialchars($rating->name ?? '') }}"
                                        data-hotel="{{ htmlspecialchars($rating->hotel_name ?? '') }}"
                                        data-rating="{{ $rating->rating ?? 0 }}"
                                        data-comment="{{ htmlspecialchars($rating->comment ?? '') }}"
                                        data-positive="{{ $rating->positive_comment_html ?? '' }}"
                                        data-negative="{{ $rating->negative_comment_html ?? '' }}"
                                        data-service="{{ $rating->service_rating ?? 0 }}"
                                        data-cleanliness="{{ $rating->cleanliness_rating ?? 0 }}"
                                        data-location="{{ $rating->location_rating ?? 0 }}"
                                        data-price="{{ $rating->price_rating ?? 0 }}"
                                        data-quality="{{ $rating->quality_rating ?? 0 }}"
                                        data-trip-type="{{ htmlspecialchars($rating->trip_type ?? '') }}"
                                        data-travel-method="{{ htmlspecialchars($rating->travel_method ?? '') }}"
                                        data-stay-date="{{ $rating->stay_date ?? '' }}"
                                        data-visit-date="{{ $rating->visit_date ?? '' }}"
                                        data-recommendation="{{ $rating->recommendation ?? '' }}"
                                        title="مشاهده جزئیات">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    @if($rating->status === 'pending')
                                        <form action="{{ route('admin.ratings.approve', $rating->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-action btn-success" title="تایید">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.ratings.reject', $rating->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-action btn-danger" title="رد">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    @endif

                                    <form action="{{ route('admin.ratings.delete', $rating->id) }}" method="POST" class="d-inline rating-delete-form">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-action btn-warning" title="حذف">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <div class="text-muted">
                                    <i class="fas fa-star fa-3x mb-3 opacity-50"></i>
                                    <h5>هیچ امتیازی یافت نشد</h5>
                                    <p>با تغییر فیلترها امتیازات مورد نظر را جستجو کنید.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if(isset($ratings) && $ratings->hasPages())
            <div class="card-footer">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="text-muted">
                            نمایش {{ $ratings->firstItem() }} تا {{ $ratings->lastItem() }} از {{ number_format($ratings->total()) }} نتیجه
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex justify-content-end">
                            {{ $ratings->appends(request()->query())->links() }}
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Quick Stats Chart -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="chart-container">
                <h5 class="mb-3">
                    <i class="fas fa-chart-pie text-primary"></i>
                    توزیع امتیازات
                </h5>
                <canvas id="ratingDistributionChart" height="200"></canvas>
            </div>
        </div>
        <div class="col-md-6">
            <div class="chart-container">
                <h5 class="mb-3">
                    <i class="fas fa-chart-bar text-success"></i>
                    دسته‌بندی‌های برتر
                </h5>
                <canvas id="topCategoriesChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- مودال نمایش جزئیات امتیاز -->
<div class="modal fade" id="viewRatingModal" tabindex="-1" aria-labelledby="viewRatingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="viewRatingModalLabel">
                    <i class="fas fa-star me-2"></i>
                    جزئیات امتیاز و نظر
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- اطلاعات کلی -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-info-circle text-primary"></i> اطلاعات کلی</h6>
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>نظردهنده:</strong></div>
                                    <div class="col-sm-8" id="modalReviewerName"></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>مکان:</strong></div>
                                    <div class="col-sm-8" id="modalHotelName"></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>امتیاز کلی:</strong></div>
                                    <div class="col-sm-8">
                                        <div id="modalRatingStars"></div>
                                        <span id="modalRating" class="badge bg-primary"></span>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>نوع سفر:</strong></div>
                                    <div class="col-sm-8" id="modalTripType"></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>روش سفر:</strong></div>
                                    <div class="col-sm-8" id="modalTravelMethod"></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>تاریخ اقامت:</strong></div>
                                    <div class="col-sm-8" id="modalStayDate"></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>تاریخ بازدید:</strong></div>
                                    <div class="col-sm-8" id="modalVisitDate"></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-4"><strong>توصیه:</strong></div>
                                    <div class="col-sm-8" id="modalRecommendation"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- امتیازات تفصیلی -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-star text-warning"></i> امتیازات تفصیلی</h6>
                            </div>
                            <div class="card-body">
                                <div id="detailedRatings">
                                    <!-- امتیازات تفصیلی اینجا نمایش داده می‌شود -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- نظرات -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-comments text-info"></i> نظرات و دیدگاه‌ها</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-success"><i class="fas fa-thumbs-up"></i> نظر مثبت:</h6>
                                        <div class="border rounded p-3 bg-light" style="max-height: 200px; overflow-y: auto;">
                                            <p id="modalPositiveComment" class="mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 class="text-danger"><i class="fas fa-thumbs-down"></i> نظر منفی:</h6>
                                        <div class="border rounded p-3 bg-light" style="max-height: 200px; overflow-y: auto;">
                                            <p id="modalNegativeComment" class="mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col-12">
                                        <h6 class="text-primary"><i class="fas fa-comment"></i> نظر کلی:</h6>
                                        <div class="border rounded p-3 bg-light" style="max-height: 200px; overflow-y: auto;">
                                            <p id="modalGeneralComment" class="mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i> بستن
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// تنظیمات Chart.js برای جلوگیری از مشکلات
Chart.defaults.responsive = true;
Chart.defaults.maintainAspectRatio = false;

// محافظت از اجرای مجدد نمودارها

$(document).ready(function() {
    // جلوگیری از اجرای مجدد اسکریپت
    if (window.ratingsPageInitialized) {
        return;
    }
    window.ratingsPageInitialized = true;

    // تمیز کردن نمودارهای قبلی
    if (window.ratingDistributionChart && typeof window.ratingDistributionChart.destroy === 'function') {
        window.ratingDistributionChart.destroy();
        window.ratingDistributionChart = null;
    }
    if (window.topCategoriesChart && typeof window.topCategoriesChart.destroy === 'function') {
        window.topCategoriesChart.destroy();
        window.topCategoriesChart = null;
    }

    // نمایش مودال جزئیات امتیاز
    $('.view-rating').click(function() {
        const button = $(this);

        // Debug: نمایش اطلاعات در کنسول
        console.log('Modal data:', {
            name: button.data('name'),
            hotel: button.data('hotel'),
            rating: button.data('rating'),
            comment: button.data('comment'),
            positive: button.data('positive'),
            negative: button.data('negative')
        });

        // اطلاعات کلی
        $('#modalReviewerName').text(button.data('name') || 'نامشخص');
        $('#modalHotelName').text(button.data('hotel') || 'نامشخص');
        $('#modalTripType').text(button.data('trip-type') || 'مشخص نشده');
        $('#modalTravelMethod').text(button.data('travel-method') || 'مشخص نشده');
        $('#modalStayDate').text(button.data('stay-date') || 'مشخص نشده');
        $('#modalVisitDate').text(button.data('visit-date') || 'مشخص نشده');

        // توصیه
        const recommendation = button.data('recommendation');
        let recommendationText = 'مشخص نشده';
        if (recommendation === 'yes') recommendationText = '✅ توصیه می‌کنم';
        else if (recommendation === 'no') recommendationText = '❌ توصیه نمی‌کنم';
        else if (recommendation === 'maybe') recommendationText = '🤔 شاید';
        $('#modalRecommendation').html(recommendationText);

        // امتیاز کلی و ستاره‌ها
        const rating = button.data('rating');
        $('#modalRating').text(rating + '/5');

        let starsHtml = '';
        for (let i = 1; i <= 5; i++) {
            starsHtml += `<i class="fas fa-star ${i <= rating ? 'text-warning' : 'text-muted'}"></i>`;
        }
        $('#modalRatingStars').html(starsHtml);

        // امتیازات تفصیلی
        let detailedRatingsHtml = '';
        const detailedRatings = [
            { key: 'service', label: 'خدمات', icon: 'fas fa-concierge-bell', color: 'info' },
            { key: 'cleanliness', label: 'نظافت', icon: 'fas fa-broom', color: 'success' },
            { key: 'location', label: 'موقعیت', icon: 'fas fa-map-marker-alt', color: 'danger' },
            { key: 'price', label: 'قیمت', icon: 'fas fa-dollar-sign', color: 'warning' },
            { key: 'quality', label: 'کیفیت', icon: 'fas fa-star', color: 'primary' }
        ];

        detailedRatings.forEach(item => {
            const value = button.data(item.key);
            if (value) {
                let stars = '';
                for (let i = 1; i <= 5; i++) {
                    stars += `<i class="fas fa-star ${i <= value ? 'text-warning' : 'text-muted'} me-1"></i>`;
                }
                detailedRatingsHtml += `
                    <div class="row mb-3">
                        <div class="col-sm-4">
                            <i class="${item.icon} text-${item.color}"></i> ${item.label}:
                        </div>
                        <div class="col-sm-8">
                            ${stars}
                            <span class="badge bg-${item.color}">${value}/5</span>
                        </div>
                    </div>
                `;
            }
        });

        if (!detailedRatingsHtml) {
            detailedRatingsHtml = '<p class="text-muted">امتیاز تفصیلی ثبت نشده است.</p>';
        }
        $('#detailedRatings').html(detailedRatingsHtml);

        // نظرات
        const positiveComment = button.data('positive');
        const negativeComment = button.data('negative');
        const generalComment = button.data('comment');

        $('#modalPositiveComment').html(positiveComment || 'نظر مثبتی ثبت نشده است.');
        $('#modalNegativeComment').html(negativeComment || 'نظر منفی ثبت نشده است.');
        $('#modalGeneralComment').html(generalComment || 'نظر کلی ثبت نشده است.');
    });

    // انتخاب همه چک‌باکس‌ها
    $('#selectAll').change(function() {
        $('.rating-checkbox').prop('checked', this.checked);
        updateBulkActions();
    });

    // تغییر وضعیت چک‌باکس‌های انفرادی
    $('.rating-checkbox').change(function() {
        updateBulkActions();

        // بررسی آیا همه انتخاب شده‌اند یا نه
        const totalCheckboxes = $('.rating-checkbox').length;
        const checkedCheckboxes = $('.rating-checkbox:checked').length;
        $('#selectAll').prop('checked', totalCheckboxes === checkedCheckboxes);
    });

    // به‌روزرسانی نمایش عملیات گروهی
    function updateBulkActions() {
        const checkedCount = $('.rating-checkbox:checked').length;
        $('#selectedCount').text(checkedCount);

        if (checkedCount > 0) {
            $('#bulkActions').addClass('show');
        } else {
            $('#bulkActions').removeClass('show');
        }
    }

    // تأیید حذف
    $('.rating-delete-form').on('submit', function(e) {
        e.preventDefault();
        const form = this;

        Swal.fire({
            title: 'آیا مطمئن هستید؟',
            text: 'این امتیاز برای همیشه حذف خواهد شد!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'بله، حذف کن!',
            cancelButtonText: 'انصراف'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });

    // فیلتر خودکار
    $('.form-select, .form-control').change(function() {
        if ($(this).attr('name') !== 'search') {
            $('#filterForm').submit();
        }
    });

    // نمودار توزیع امتیازات
    const ratingDistributionCanvas = document.getElementById('ratingDistributionChart');
    console.log('Rating distribution canvas found:', !!ratingDistributionCanvas);
    if (ratingDistributionCanvas) {
        const ratingDistributionCtx = ratingDistributionCanvas.getContext('2d');

        // داده‌های توزیع امتیازات (از دیتابیس)
        const distributionData = [
            {{ $stats['rating_distribution'][5] ?? 0 }}, // 5 ستاره
            {{ $stats['rating_distribution'][4] ?? 0 }}, // 4 ستاره
            {{ $stats['rating_distribution'][3] ?? 0 }}, // 3 ستاره
            {{ $stats['rating_distribution'][2] ?? 0 }}, // 2 ستاره
            {{ $stats['rating_distribution'][1] ?? 0 }}  // 1 ستاره
        ];

        console.log('Creating rating distribution chart with data:', distributionData);
        window.ratingDistributionChart = new Chart(ratingDistributionCtx, {
        type: 'doughnut',
        data: {
            labels: ['5 ستاره', '4 ستاره', '3 ستاره', '2 ستاره', '1 ستاره'],
            datasets: [{
                data: distributionData,
                backgroundColor: [
                    '#28a745',
                    '#17a2b8',
                    '#ffc107',
                    '#fd7e14',
                    '#dc3545'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            animation: {
                duration: 800,
                animateRotate: true,
                animateScale: false
            },
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const total = distributionData.reduce((a, b) => a + b, 0);
                            const percentage = total > 0 ? ((context.parsed / total) * 100).toFixed(1) : 0;
                            return context.label + ': ' + context.parsed + ' (' + percentage + '%)';
                        }
                    }
                }
            }
        }
        });
    }

    // نمودار دسته‌بندی‌های برتر
    const topCategoriesCanvas = document.getElementById('topCategoriesChart');
    console.log('Top categories canvas found:', !!topCategoriesCanvas);
    if (topCategoriesCanvas) {
        const topCategoriesCtx = topCategoriesCanvas.getContext('2d');

        // داده‌های دسته‌بندی‌ها (از دیتابیس)
        const categoryLabels = [
            @if(isset($stats['top_categories']) && count($stats['top_categories']) > 0)
                @foreach($stats['top_categories'] as $category)
                    '{{ addslashes($category->category ?? 'نامشخص') }}',
                @endforeach
            @else
                'هیچ داده‌ای موجود نیست'
            @endif
        ];

        const categoryData = [
            @if(isset($stats['top_categories']) && count($stats['top_categories']) > 0)
                @foreach($stats['top_categories'] as $category)
                    {{ $category->count ?? 0 }},
                @endforeach
            @else
                0
            @endif
        ];

        console.log('Creating top categories chart with labels:', categoryLabels, 'data:', categoryData);
        window.topCategoriesChart = new Chart(topCategoriesCtx, {
        type: 'bar',
        data: {
            labels: categoryLabels,
            datasets: [{
                label: 'تعداد امتیازات',
                data: categoryData,
                backgroundColor: [
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderColor: [
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 99, 132, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            animation: {
                duration: 800,
                animateRotate: false,
                animateScale: true
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.parsed.y + ' امتیاز';
                        }
                    }
                }
            }
        }
        });
    }
});

// عملیات گروهی
function bulkAction(action) {
    const selectedIds = $('.rating-checkbox:checked').map(function() {
        return this.value;
    }).get();

    console.log('Selected IDs:', selectedIds);
    console.log('Action:', action);

    if (selectedIds.length === 0) {
        Swal.fire('خطا', 'لطفاً حداقل یک مورد را انتخاب کنید.', 'error');
        return;
    }

    let actionText = '';
    let confirmText = '';

    switch(action) {
        case 'approve':
            actionText = 'تایید';
            confirmText = 'آیا از تایید موارد انتخاب شده اطمینان دارید؟';
            break;
        case 'reject':
            actionText = 'رد';
            confirmText = 'آیا از رد موارد انتخاب شده اطمینان دارید؟';
            break;
        case 'delete':
            actionText = 'حذف';
            confirmText = 'آیا از حذف موارد انتخاب شده اطمینان دارید؟ این عمل قابل بازگشت نیست!';
            break;
    }

    Swal.fire({
        title: 'تأیید عملیات',
        text: confirmText,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'بله، ' + actionText + ' کن!',
        cancelButtonText: 'انصراف'
    }).then((result) => {
        if (result.isConfirmed) {
            console.log('Sending AJAX request...');
            $.ajax({
                url: '{{ route("admin.ratings.bulk-action") }}',
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                data: JSON.stringify({
                    action: action,
                    rating_ids: selectedIds
                }),
                beforeSend: function() {
                    console.log('Request data:', {
                        action: action,
                        rating_ids: selectedIds
                    });
                },
                success: function(response) {
                    console.log('Success response:', response);
                    if (response.success) {
                        Swal.fire('موفق!', response.message, 'success').then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.log('Error response:', xhr.responseText);
                    console.log('Status:', status);
                    console.log('Error:', error);

                    let errorMessage = 'خطایی در انجام عملیات رخ داد.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }

                    Swal.fire('خطا!', errorMessage, 'error');
                }
            });
        }
    });
}
</script>
@endsection