@extends('admin.layouts.app')

@section('title', 'ماژول‌های فعال')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">ماژول‌های فعال</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($modules as $key => $module)
                            <div class="col-md-4 mb-4">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ $module['name'] }}</h5>
                                        <p class="card-text">{{ $module['description'] }}</p>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="module_{{ $key }}" 
                                                {{ $module['is_active'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="module_{{ $key }}">
                                                {{ $module['is_active'] ? 'فعال' : 'غیرفعال' }}
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 