@extends('admin.layouts.app')

@section('title', 'سطل زباله پیام‌ها')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">سطل زباله پیام‌ها</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>فرستنده/گیرنده</th>
                                    <th>موضوع</th>
                                    <th>تاریخ حذف</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($messages as $message)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        @if($message->sender_id === auth()->id())
                                            به: {{ $message->recipient_name }}
                                        @else
                                            از: {{ $message->sender_name }}
                                        @endif
                                    </td>
                                    <td>{{ $message->subject }}</td>
                                    <td>{{ jdate($message->deleted_at)->format('Y/m/d H:i') }}</td>
                                    <td>
                                        <form action="{{ route('admin.messages.restore', $message) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success">
                                                <i class="fa fa-undo"></i>
                                                بازیابی
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.messages.force_delete', $message) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف دائمی این پیام اطمینان دارید؟')">
                                                <i class="fa fa-trash"></i>
                                                حذف دائمی
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">هیچ پیام حذف شده‌ای وجود ندارد.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    {{ $messages->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 