@extends('admin.layouts.app')

@section('title', __('admin.languages'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('admin.languages') }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.languages.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> {{ __('admin.add_language') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>{{ __('admin.flag') }}</th>
                                <th>{{ __('admin.name') }}</th>
                                <th>{{ __('admin.code') }}</th>
                                <th>{{ __('admin.status') }}</th>
                                <th>{{ __('admin.default') }}</th>
                                <th>{{ __('admin.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($languages as $language)
                            <tr>
                                <td class="text-center">
                                    @if($language->flag)
                                        <span class="flag-emoji" title="{{ $language->native_name }}">{!! $language->flag !!}</span>
                                    @endif
                                </td>
                                <td>
                                    {{ in_array(strtoupper($language->name), ['FA','EN','AR']) ? $language->native_name : $language->name }}
                                </td>
                                <td>{{ $language->code }}</td>
                                <td>
                                    @if($language->is_active)
                                        <span class="badge badge-success">{{ __('admin.active') }}</span>
                                    @else
                                        <span class="badge badge-danger">{{ __('admin.inactive') }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($language->is_default)
                                        <span class="badge badge-primary">{{ __('admin.default') }}</span>
                                    @else
                                        <form action="{{ route('admin.languages.set-default', $language) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-outline-primary">
                                                {{ __('admin.set_default') }}
                                            </button>
                                        </form>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.languages.edit', $language) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="{{ route('admin.languages.translations', $language) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-language"></i>
                                        </a>
                                        @if(!$language->is_default)
                                            <form action="{{ route('admin.languages.toggle-active', $language) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm {{ $language->is_active ? 'btn-danger' : 'btn-success' }}">
                                                    <i class="fas {{ $language->is_active ? 'fa-times' : 'fa-check' }}"></i>
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.languages.destroy', $language) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('{{ __('admin.are_you_sure') }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.flag-emoji {
    font-size: 1.5em;
    line-height: 1;
    display: inline-block;
    vertical-align: middle;
    font-family: 'Segoe UI Emoji', 'Apple Color Emoji', 'Noto Color Emoji', 'Arial', sans-serif !important;
}
</style>

<!--
    این جدول لیست زبان‌ها را با پرچم ایموجی و نام صحیح نمایش می‌دهد.
    اگر مقدار name کد کشور باشد (مثلاً FA)، نام بومی نمایش داده می‌شود.
-->
@endsection 