@extends('admin.layouts.app')

@section('title', __('admin.add_language'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('admin.add_language') }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.languages.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-left"></i> {{ __('admin.back') }}
                        </a>
                    </div>
                </div>
                <form action="{{ route('admin.languages.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">{{ __('admin.name') }}</label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="native_name">{{ __('admin.native_name') }}</label>
                            <input type="text" class="form-control @error('native_name') is-invalid @enderror" id="native_name" name="native_name" value="{{ old('native_name') }}" required>
                            @error('native_name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="code">{{ __('admin.code') }}</label>
                            <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code" value="{{ old('code') }}" required>
                            @error('code')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="flag">{{ __('admin.flag') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control @error('flag') is-invalid @enderror" id="flag" name="flag" value="{{ old('flag') }}" placeholder="🇸🇦">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('flag').value = '🇸🇦'">🇸🇦</button>
                                    <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('flag').value = '🇮🇷'">🇮🇷</button>
                                    <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('flag').value = '🇺🇸'">🇺🇸</button>
                                </div>
                            </div>
                            <small class="form-text text-muted">{{ __('admin.flag_help') }}</small>
                            @error('flag')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_default" name="is_default" value="1" {{ old('is_default') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_default">{{ __('admin.set_as_default') }}</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">{{ __('admin.active') }}</label>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">{{ __('admin.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection 