@extends('admin.layouts.app')

@section('title', 'ویرایش استان')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>ویرایش استان</h4>
                <a href="{{ route('admin.geography.provinces.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> بازگشت به لیست استان‌ها
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.geography.provinces.update', $item->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="country_id">کشور <span class="text-danger">*</span></label>
                            <select name="country_id" id="country_id" class="form-control country-flag-select @error('country_id') is-invalid @enderror" required>
                                <option value="">انتخاب کشور</option>
                                @foreach($countries as $id => $name)
                                    @php
                                        $flag = '';
                                        if (is_object($name) && isset($name->flag)) $flag = $name->flag;
                                        elseif (is_array($name) && isset($name['flag'])) $flag = $name['flag'];
                                    @endphp
                                    <option value="{{ $id }}" {{ old('country_id', $item->country_id) == $id ? 'selected' : '' }}>
                                        {{ $flag }} {{ is_object($name) ? $name->name : (is_array($name) ? $name['name'] : $name) }}
                                    </option>
                                @endforeach
                            </select>
                            @error('country_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">نام استان <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" 
                                value="{{ old('name', $item->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name_en">نام انگلیسی</label>
                            <input type="text" name="name_en" id="name_en" class="form-control @error('name_en') is-invalid @enderror" 
                                value="{{ old('name_en', $item->name_en) }}">
                            @error('name_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="slug">نامک (slug)</label>
                            <input type="text" name="slug" id="slug" class="form-control @error('slug') is-invalid @enderror" 
                                value="{{ old('slug', $item->slug) }}">
                            @error('slug')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="center_city_name">نام شهر مرکزی</label>
                            <input type="text" name="center_city_name" id="center_city_name" class="form-control @error('center_city_name') is-invalid @enderror" 
                                value="{{ old('center_city_name', $item->center_city_name) }}">
                            @error('center_city_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="code">کد استان</label>
                            <input type="text" name="code" id="code" class="form-control @error('code') is-invalid @enderror" 
                                value="{{ old('code', $item->code) }}">
                            @error('code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="boundaries">مرزهای جغرافیایی (GeoJSON)</label>
                            <div class="mb-2">
                                <button type="button" id="insert-template" class="btn btn-sm btn-outline-secondary">Insert GeoJSON Template</button>
                                <a href="https://geojson.io/" target="_blank" class="btn btn-sm btn-outline-info">Create GeoJSON Online</a>
                                <button type="button" id="fix-json" class="btn btn-sm btn-outline-danger">Fix Corrupted Data</button>
                            </div>
                            <div class="alert alert-info mb-2">
                                <i class="fas fa-info-circle"></i> مرزهای جغرافیایی باید در فرمت GeoJSON و با نوع <code>Polygon</code> وارد شوند. اگر داده‌های فعلی مشکل دارند از دکمه "Fix Corrupted Data" استفاده کنید.
                            </div>
                            <textarea name="boundaries" id="boundaries" rows="10" class="form-control @error('boundaries') is-invalid @enderror">{{ old('boundaries', $item->boundaries) }}</textarea>
                            <small class="form-text text-muted">دیتای GeoJSON برای نمایش مرزهای استان روی نقشه را وارد کنید</small>
                            @error('boundaries')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="is_active">وضعیت</label>
                            <div class="form-check">
                                <input type="checkbox" name="is_active" id="is_active" class="form-check-input @error('is_active') is-invalid @enderror" 
                                    value="1" {{ old('is_active', $item->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">فعال</label>
                            </div>
                            @error('is_active')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="text-center mt-5">
                    <button type="submit" class="btn btn-primary px-5">بروزرسانی استان</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تولید خودکار نامک از روی نام استان
        $('#name').on('keyup', function() {
            let nameValue = $(this).val();
            let slug = nameValue
                .toLowerCase()
                .replace(/ /g, '-')
                .replace(/[^\w-]+/g, '');
            
            $('#slug').val(slug);
        });
        
        // Insert GeoJSON template
        $('#insert-template').on('click', function() {
            // Simple Polygon format - this format matches existing data in the database
            const template = {
                "type": "Polygon",
                "coordinates": [
                    [
                        [51.3, 35.7], // Tehran area coordinates
                        [51.5, 35.7],
                        [51.5, 35.8],
                        [51.3, 35.8],
                        [51.3, 35.7]
                    ]
                ]
            };
            
            $('#boundaries').val(JSON.stringify(template, null, 2));
        });
        
        // Fix corrupted JSON data
        $('#fix-json').on('click', function() {
            var currentValue = $('#boundaries').val();
            
            // If empty or null, just insert the template
            if (!currentValue || currentValue === 'null') {
                $('#insert-template').click();
                return;
            }
            
            // Check if it looks corrupted
            var isBadData = false;
            
            // Look for JSON parse errors
            try {
                JSON.parse(currentValue);
            } catch(e) {
                isBadData = true;
            }
            
            // Non-printable characters suggest binary data
            for (var i = 0; i < currentValue.length; i++) {
                var code = currentValue.charCodeAt(i);
                if (code < 32 || code === 127) {
                    isBadData = true;
                    break;
                }
            }
            
            if (isBadData) {
                if (confirm('داده‌های موجود معتبر نیستند. آیا می‌خواهید از الگوی پیش‌فرض استفاده کنید؟')) {
                    $('#insert-template').click();
                }
                return;
            }
            
            try {
                // Try to pretty-print it
                const parsed = JSON.parse(currentValue);
                $('#boundaries').val(JSON.stringify(parsed, null, 2));
                alert('داده‌های GeoJSON با موفقیت تمیز شدند.');
            } catch (e) {
                alert('خطا: ' + e.message);
            }
        });
    });
</script>
@endsection 