@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مدیریت تنظیمات نمایش</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.display-settings.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> افزودن تنظیمات جدید
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>صفحه</th>
                                    <th>بخش</th>
                                    <th>تعداد آیتم دسکتاپ</th>
                                    <th>تعداد آیتم موبایل</th>
                                    <th>متن دکمه بیشتر</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($settings as $setting)
                                    <tr>
                                        <td>{{ $setting->page_key }}</td>
                                        <td>{{ $setting->section_key }}</td>
                                        <td>{{ $setting->desktop_items }}</td>
                                        <td>{{ $setting->mobile_items }}</td>
                                        <td>{{ $setting->load_more_text }}</td>
                                        <td>
                                            @if($setting->is_active)
                                                <span class="badge badge-success">فعال</span>
                                            @else
                                                <span class="badge badge-danger">غیرفعال</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.display-settings.edit', $setting) }}" 
                                               class="btn btn-sm btn-info">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.display-settings.destroy', $setting) }}" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('آیا از حذف این تنظیمات اطمینان دارید؟')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">هیچ تنظیماتی یافت نشد.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 