@extends('admin.layouts.app')

@section('title', 'تحلیل رفتار کاربران')

@section('content')
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">تحلیل رفتار کاربران</h1>
    <div>
        <a href="{{ route('admin.analytics.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm ml-2">
            <i class="fas fa-chart-bar fa-sm text-white-50 ml-1"></i> بازگشت به داشبورد تحلیلی
        </a>
        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-success shadow-sm" id="printReport">
            <i class="fas fa-download fa-sm text-white-50 ml-1"></i> دریافت گزارش
        </a>
    </div>
</div>

<!-- User Stats Cards -->
<div class="row">
    <!-- Total Users Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">کل کاربران</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $userStats['total_users'] }}</div>
                        <div class="mt-2 small">
                            <span class="text-{{ $userStats['user_growth'] >= 0 ? 'success' : 'danger' }}">
                                <i class="fas fa-{{ $userStats['user_growth'] >= 0 ? 'arrow-up' : 'arrow-down' }} fa-sm"></i>
                                {{ $userStats['user_growth'] }}% رشد ماهانه
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Users Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">کاربران فعال</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $userStats['active_users'] }}</div>
                        <div class="mt-2 small">
                            {{ round($userStats['active_percentage']) }}% از کل کاربران
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-user-check fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- New Users Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">کاربران جدید (30 روز گذشته)</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $userStats['new_users'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-user-plus fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Login Activity Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">ورود اخیر (7 روز گذشته)</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $userStats['recent_logins'] }}</div>
                        <div class="mt-2 small">
                            {{ round($userStats['login_percentage']) }}% از کاربران فعال
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-sign-in-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Admin Stats Card -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body py-3 d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="m-0 font-weight-bold text-primary">وضعیت مدیران سیستم</h6>
                    <span class="small">
                        از مجموع <span class="font-weight-bold">{{ $userStats['total_admins'] }}</span> مدیر، 
                        <span class="font-weight-bold text-success">{{ $userStats['active_admins'] }}</span> مدیر فعال هستند.
                    </span>
                </div>
                <div>
                    <a href="#" class="btn btn-sm btn-info">
                        <i class="fas fa-user-shield fa-sm ml-1"></i> مشاهده جزئیات
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- User Activity Trends -->
    <div class="col-xl-8 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">روند فعالیت کاربران (30 روز گذشته)</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">گزینه‌های نمودار:</div>
                        <a class="dropdown-item" href="#" id="toggle-registrations">نمایش/مخفی ثبت‌نام</a>
                        <a class="dropdown-item" href="#" id="toggle-logins">نمایش/مخفی ورود</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" id="export-chart-activity">دریافت نمودار</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="userActivityChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <h6 class="font-weight-bold">تحلیل فعالیت‌ها:</h6>
                    <p>
                        این نمودار روند ثبت‌نام کاربران جدید و ورود کاربران به سیستم را در 30 روز گذشته نشان می‌دهد.
                        با مقایسه این دو نمودار می‌توانید الگوی رفتاری کاربران و ارتباط آن با رویدادهای خاص را تحلیل کنید.
                    </p>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <div class="activity-dot bg-primary mr-2"></div>
                                <div class="small">
                                    <span class="font-weight-bold">میانگین روزانه ثبت‌نام:</span>
                                    <span id="avg-registrations">12</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <div class="activity-dot bg-success mr-2"></div>
                                <div class="small">
                                    <span class="font-weight-bold">میانگین روزانه ورود:</span>
                                    <span id="avg-logins">45</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Segmentation -->
    <div class="col-xl-4 col-lg-5">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">بخش‌بندی کاربران</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12 mb-4">
                        <div class="card bg-primary text-white shadow">
                            <div class="card-body">
                                بخش‌بندی بر اساس نقش
                                <div class="text-white-50 small">تعداد کاربران در هر نقش</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 mb-4">
                        <div class="chart-pie mb-4">
                            <canvas id="userRolesChart"></canvas>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-lg-12 mb-4">
                        <div class="card bg-success text-white shadow">
                            <div class="card-body">
                                بخش‌بندی بر اساس فعالیت
                                <div class="text-white-50 small">میزان فعالیت کاربران</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="chart-pie">
                            <canvas id="userActivitySegmentChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- User Engagement Metrics -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">شاخص‌های تعامل کاربران</h6>
            </div>
            <div class="card-body">
                <h4 class="small font-weight-bold">نرخ بازگشت کاربران <span class="float-right">{{ $userEngagementMetrics['return_rate'] }}%</span></h4>
                <div class="progress mb-4">
                    <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $userEngagementMetrics['return_rate'] }}%" aria-valuenow="{{ $userEngagementMetrics['return_rate'] }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <h4 class="small font-weight-bold">میزان مشارکت کاربران <span class="float-right">{{ $userEngagementMetrics['participation_rate'] }}%</span></h4>
                <div class="progress mb-4">
                    <div class="progress-bar bg-warning" role="progressbar" style="width: {{ $userEngagementMetrics['participation_rate'] }}%" aria-valuenow="{{ $userEngagementMetrics['participation_rate'] }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <h4 class="small font-weight-bold">نرخ ماندگاری کاربران <span class="float-right">{{ $userEngagementMetrics['retention_rate'] }}%</span></h4>
                <div class="progress mb-4">
                    <div class="progress-bar" role="progressbar" style="width: {{ $userEngagementMetrics['retention_rate'] }}%" aria-valuenow="{{ $userEngagementMetrics['retention_rate'] }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <h4 class="small font-weight-bold">میانگین زمان حضور در سایت <span class="float-right">{{ $userEngagementMetrics['avg_time_on_site'] }}%</span></h4>
                <div class="progress mb-4">
                    <div class="progress-bar bg-info" role="progressbar" style="width: {{ $userEngagementMetrics['avg_time_on_site'] }}%" aria-valuenow="{{ $userEngagementMetrics['avg_time_on_site'] }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <h4 class="small font-weight-bold">نرخ رضایت کاربران <span class="float-right">{{ $userEngagementMetrics['satisfaction_rate'] }}%</span></h4>
                <div class="progress">
                    <div class="progress-bar bg-success" role="progressbar" style="width: {{ $userEngagementMetrics['satisfaction_rate'] }}%" aria-valuenow="{{ $userEngagementMetrics['satisfaction_rate'] }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent User Activities Timeline -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">فعالیت‌های اخیر کاربران</h6>
                <a href="#" class="btn btn-sm btn-primary">
                    مشاهده همه فعالیت‌ها
                </a>
            </div>
            <div class="card-body">
                <div class="timeline-user-activity">
                    @forelse($recentUserActivities as $activity)
                    <div class="timeline-item">
                        <div class="timeline-badge bg-{{ $activity['color'] }}">
                            <i class="fas fa-{{ $activity['icon'] }}"></i>
                        </div>
                        <div class="timeline-content">
                            <h5 class="timeline-title">{{ $activity['title'] }}</h5>
                            <p class="timeline-text">کاربر <strong>{{ $activity['user_name'] }}</strong> 
                                @if($activity['type'] == 'rating')
                                امتیاز {{ $activity['rating'] }} را ثبت کرد.
                                @elseif($activity['type'] == 'comment')
                                یک نظر جدید ثبت کرد.
                                @elseif($activity['type'] == 'login')
                                وارد سیستم شد.
                                @elseif($activity['type'] == 'registration')
                                در سیستم ثبت‌نام کرد.
                                @elseif($activity['type'] == 'error')
                                با خطای احراز هویت مواجه شد.
                                @endif
                            </p>
                            <span class="small text-muted">{{ $activity['time_diff'] }}</span>
                        </div>
                    </div>
                    @empty
                    <div class="alert alert-info">
                        هیچ فعالیت کاربری ثبت نشده است.
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.0/dist/chart.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // User activity chart data
        var userActivity = @json($userActivityTrends ?? []);
        
        // User Activity Chart
        var activityCtx = document.getElementById('userActivityChart');
        var activityChart = new Chart(activityCtx, {
            type: 'line',
            data: {
                labels: userActivity?.dates ?? [],
                datasets: [{
                    label: 'ثبت‌نام‌های جدید',
                    data: userActivity?.registrations ?? [],
                    backgroundColor: 'rgba(78, 115, 223, 0.05)',
                    borderColor: 'rgba(78, 115, 223, 1)',
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                    pointBorderColor: 'rgba(78, 115, 223, 1)',
                    pointHoverRadius: 5,
                    pointHoverBackgroundColor: 'rgba(78, 115, 223, 1)',
                    pointHoverBorderColor: 'rgba(78, 115, 223, 1)',
                    pointHitRadius: 10,
                    pointBorderWidth: 2,
                    fill: true
                },
                {
                    label: 'ورود کاربران',
                    data: userActivity?.logins ?? [],
                    backgroundColor: 'rgba(28, 200, 138, 0.05)',
                    borderColor: 'rgba(28, 200, 138, 1)',
                    pointRadius: 3,
                    pointBackgroundColor: 'rgba(28, 200, 138, 1)',
                    pointBorderColor: 'rgba(28, 200, 138, 1)',
                    pointHoverRadius: 5,
                    pointHoverBackgroundColor: 'rgba(28, 200, 138, 1)',
                    pointHoverBorderColor: 'rgba(28, 200, 138, 1)',
                    pointHitRadius: 10,
                    pointBorderWidth: 2,
                    fill: false
                }]
            },
            options: {
                maintainAspectRatio: false,
                layout: {
                    padding: {
                        left: 10,
                        right: 25,
                        top: 25,
                        bottom: 0
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            maxTicksLimit: 10
                        }
                    },
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    },
                    tooltip: {
                        rtl: true,
                        titleAlign: 'right',
                        bodyAlign: 'right'
                    }
                }
            }
        });
        
        // User Roles Chart
        var rolesCtx = document.getElementById('userRolesChart');
        var userSegmentation = @json($userSegmentation ?? []);
        
        var rolesChart = new Chart(rolesCtx, {
            type: 'doughnut',
            data: {
                labels: userSegmentation.roles?.labels ?? [],
                datasets: [{
                    data: userSegmentation.roles?.data ?? [],
                    backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc'],
                    hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf'],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }]
            },
            options: {
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        rtl: true
                    }
                },
                cutout: '70%'
            }
        });
        
        // User Activity Segmentation Chart
        var activitySegmentCtx = document.getElementById('userActivitySegmentChart');
        
        var activitySegmentChart = new Chart(activitySegmentCtx, {
            type: 'doughnut',
            data: {
                labels: userSegmentation.activity?.labels ?? [],
                datasets: [{
                    data: userSegmentation.activity?.data ?? [],
                    backgroundColor: ['#1cc88a', '#4e73df', '#f6c23e', '#e74a3b'],
                    hoverBackgroundColor: ['#17a673', '#2e59d9', '#f4b619', '#e02d1b'],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }]
            },
            options: {
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        rtl: true
                    }
                },
                cutout: '70%'
            }
        });
        
        // Toggle buttons for activity chart
        document.getElementById('toggle-registrations').addEventListener('click', function() {
            activityChart.data.datasets[0].hidden = !activityChart.data.datasets[0].hidden;
            activityChart.update();
        });
        
        document.getElementById('toggle-logins').addEventListener('click', function() {
            activityChart.data.datasets[1].hidden = !activityChart.data.datasets[1].hidden;
            activityChart.update();
        });
        
        // Calculate average metrics
        function calculateAverages() {
            var registrations = userActivity.registrations || [];
            var logins = userActivity.logins || [];
            
            if (registrations.length > 0) {
                var avgReg = Math.round(registrations.reduce((a, b) => a + b, 0) / registrations.length);
                document.getElementById('avg-registrations').textContent = avgReg;
            }
            
            if (logins.length > 0) {
                var avgLogin = Math.round(logins.reduce((a, b) => a + b, 0) / logins.length);
                document.getElementById('avg-logins').textContent = avgLogin;
            }
        }
        
        // Run calculations
        calculateAverages();
        
        // Print report functionality
        document.getElementById('printReport').addEventListener('click', function() {
            window.print();
        });
        
        // Export chart
        document.getElementById('export-chart-activity').addEventListener('click', function() {
            var link = document.createElement('a');
            link.download = 'user-activity.png';
            link.href = activityChart.toBase64Image();
            link.click();
        });
    });
</script>
@endsection

@section('styles')
<style>
    .chart-area, .chart-pie {
        height: 20rem;
        position: relative;
    }
    .timeline-user-activity {
        position: relative;
        padding-left: 50px;
    }
    .timeline-item {
        position: relative;
        margin-bottom: 25px;
    }
    .timeline-badge {
        position: absolute;
        left: -50px;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        text-align: center;
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .timeline-content {
        background-color: #f8f9fc;
        padding: 10px 15px;
        border-radius: 5px;
    }
    .timeline-title {
        margin: 0;
        font-size: 14px;
        font-weight: bold;
    }
    .timeline-text {
        margin: 5px 0 0;
        font-size: 12px;
        color: #858796;
    }
    .activity-dot {
        width: 12px;
        height: 12px;
        border-radius: 50%;
    }
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            break-inside: avoid;
            border: 1px solid #ddd !important;
            box-shadow: none !important;
        }
        .chart-area, .chart-pie {
            height: 15rem !important;
        }
    }
</style>
@endsection 