@extends('admin.layouts.app')

@section('title', 'مدیریت تبلیغات')

@section('content')
<div class="container-fluid">
    <h1 class="page-title">مدیریت تبلیغات</h1>
    
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="m-0">لیست تبلیغات</h5>
            <a href="{{ route('admin.advertisements.create') }}" class="btn btn-primary">
                <i class="fas fa-plus ml-1"></i>
                افزودن تبلیغ جدید
            </a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="50">#</th>
                            <th>عنوان</th>
                            <th>نوع</th>
                            <th>موقعیت</th>
                            <th>تصویر</th>
                            <th>تاریخ شروع</th>
                            <th>تاریخ پایان</th>
                            <th>نمایش/کلیک</th>
                            <th>وضعیت</th>
                            <th width="180">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(count($advertisements) > 0)
                            @foreach($advertisements as $advertisement)
                                <tr>
                                    <td>{{ $advertisement->id }}</td>
                                    <td>{{ $advertisement->title }}</td>
                                    <td>{{ $advertisement->ad_type }}</td>
                                    <td>{{ $advertisement->position }}</td>
                                    <td>
                                        @if($advertisement->image_path)
                                            <img src="{{ asset('storage/' . $advertisement->image_path) }}" 
                                                alt="{{ $advertisement->title }}" 
                                                style="max-width: 50px; max-height: 50px;">
                                        @else
                                            <span class="text-muted">بدون تصویر</span>
                                        @endif
                                    </td>
                                    <td>{{ \Morilog\Jalali\Jalalian::fromDateTime($advertisement->start_date)->format('Y/m/d') }}</td>
                                    <td>
                                        @if($advertisement->end_date)
                                            {{ \Morilog\Jalali\Jalalian::fromDateTime($advertisement->end_date)->format('Y/m/d') }}
                                        @else
                                            <span class="text-muted">نامحدود</span>
                                        @endif
                                    </td>
                                    <td>
                                        {{ $advertisement->view_count }} / {{ $advertisement->click_count }}
                                    </td>
                                    <td>
                                        @if($advertisement->is_active)
                                            <span class="badge bg-success">فعال</span>
                                        @else
                                            <span class="badge bg-danger">غیرفعال</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <form action="{{ route('admin.advertisements.toggle-active', $advertisement->id) }}" method="POST">
                                                @csrf
                                                <button type="submit" class="btn btn-sm {{ $advertisement->is_active ? 'btn-warning' : 'btn-success' }}">
                                                    <i class="fas {{ $advertisement->is_active ? 'fa-ban' : 'fa-check' }}"></i>
                                                    {{ $advertisement->is_active ? 'غیرفعال کردن' : 'فعال کردن' }}
                                                </button>
                                            </form>
                                            
                                            <a href="{{ route('admin.advertisements.edit', $advertisement->id) }}" class="btn btn-sm btn-info mx-1">
                                                <i class="fas fa-edit"></i>
                                                ویرایش
                                            </a>
                                            
                                            <form action="{{ route('admin.advertisements.destroy', $advertisement->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این تبلیغ اطمینان دارید؟');">
                                                    <i class="fas fa-trash"></i>
                                                    حذف
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="10" class="text-center">هیچ تبلیغی یافت نشد.</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center mt-3">
                {{ $advertisements->links() }}
            </div>
        </div>
    </div>
</div>
@endsection 