<?php
/**
 * Alu Dubai Tourism Guide - Auto Installer (Shared Hosting Version)
 */

// تنظیمات خطا
error_reporting(E_ALL);
ini_set('display_errors', 1);

// بررسی وجود Composer autoload
if (!file_exists('vendor/autoload.php')) {
    die('خطا: فایل vendor/autoload.php یافت نشد. لطفاً ابتدا composer install را روی لوکال اجرا کنید و سپس vendor را آپلود کنید.');
}

// بررسی وجود فایل .env
if (!file_exists('.env')) {
    die('خطا: فایل .env یافت نشد. لطفاً فایل .env را ایجاد کنید.');
}

// بررسی دسترسی نوشتن در پوشه‌ها
$writable_dirs = ['storage', 'bootstrap/cache'];
foreach ($writable_dirs as $dir) {
    if (!is_writable($dir)) {
        echo "خطا: پوشه $dir قابل نوشتن نیست. لطفاً دسترسی‌ها را تنظیم کنید.<br>";
    }
}

// بررسی اتصال به دیتابیس
try {
    $env = file_get_contents('.env');
    preg_match('/DB_HOST=(.+)/', $env, $host);
    preg_match('/DB_DATABASE=(.+)/', $env, $database);
    preg_match('/DB_USERNAME=(.+)/', $env, $username);
    preg_match('/DB_PASSWORD=(.+)/', $env, $password);
    
    $host = trim($host[1] ?? 'localhost');
    $database = trim($database[1] ?? '');
    $username = trim($username[1] ?? '');
    $password = trim($password[1] ?? '');
    
    if (empty($database) || empty($username)) {
        die('خطا: اطلاعات دیتابیس در فایل .env کامل نیست.');
    }
    
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    echo "✓ اتصال به دیتابیس موفقیت‌آمیز بود<br>";
    
} catch (PDOException $e) {
    die('خطا در اتصال به دیتابیس: ' . $e->getMessage());
}

echo "<h2>مراحل نصب:</h2>";

// 1. پاک کردن کش‌ها با متدهای لاراول
echo "1. پاک کردن کش‌ها...<br>";

require __DIR__ . '/vendor/autoload.php';

$app = require __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

$commands = [
    'cache:clear',
    'config:clear',
    'route:clear',
    'view:clear'
];

foreach ($commands as $command) {
    try {
        $kernel->call($command);
        echo "✓ $command اجرا شد<br>";
    } catch (Exception $e) {
        echo "✗ خطا در اجرای $command: " . $e->getMessage() . "<br>";
    }
}

// 2. تنظیم دسترسی‌ها
echo "2. تنظیم دسترسی‌ها...<br>";
$chmod_dirs = [
    'storage' => '775',
    'bootstrap/cache' => '775',
    'public' => '755'
];

foreach ($chmod_dirs as $dir => $perm) {
    if (is_dir($dir)) {
        chmod($dir, octdec($perm));
        echo "✓ دسترسی $perm برای $dir تنظیم شد<br>";
    }
}

// 3. بررسی فایل‌های مهم
echo "3. بررسی فایل‌های مهم...<br>";
$important_files = [
    'public/index.php',
    'public/.htaccess',
    '.env',
    'composer.json'
];

foreach ($important_files as $file) {
    if (file_exists($file)) {
        echo "✓ $file موجود است<br>";
    } else {
        echo "✗ $file یافت نشد<br>";
    }
}

echo "<h2>نصب با موفقیت تکمیل شد!</h2>";
echo "<p>پروژه شما آماده استفاده است. لطفاً فایل install.php را حذف کنید.</p>";
echo "<p><a href='/' target='_blank'>مشاهده سایت</a></p>";
