# سیستم تنظیمات امنیتی

این سند نحوه استفاده و پیکربندی سیستم تنظیمات امنیتی را توضیح می‌دهد.

## فهرست مطالب

1. [معرفی](#معرفی)
2. [گروه‌های تنظیمات](#گروه‌های-تنظیمات)
3. [نحوه استفاده](#نحوه-استفاده)
4. [پیکربندی](#پیکربندی)
5. [میان‌افزار امنیتی](#میان‌افزار-امنیتی)

## معرفی

سیستم تنظیمات امنیتی یک راهکار جامع برای مدیریت تنظیمات امنیتی برنامه است. این سیستم امکان تنظیم و کنترل جنبه‌های مختلف امنیتی را از طریق پنل مدیریت فراهم می‌کند.

## گروه‌های تنظیمات

### تنظیمات فایل
- انواع فایل‌های مجاز (MIME Types)
- حداکثر حجم فایل
- پسوندهای خطرناک

### تنظیمات نشست
- حداکثر تعداد نشست همزمان
- زمان انقضای نشست
- فاصله زمانی بازسازی شناسه نشست

### تنظیمات XSS و CSRF
- الگوهای XSS
- سیاست امنیتی محتوا (CSP)
- زمان انقضای توکن CSRF

### تنظیمات محافظت در برابر حملات
- حداکثر تعداد تلاش‌های ناموفق
- زمان قفل شدن
- زمان پاکسازی تلاش‌ها

### تنظیمات لاگ
- سطح لاگ
- مدت زمان نگهداری لاگ‌ها
- رمزنگاری لاگ‌ها

## نحوه استفاده

### دسترسی به پنل تنظیمات

پنل تنظیمات امنیتی در مسیر زیر قابل دسترسی است:
```
/admin/security-settings
```

### مدیریت تنظیمات

1. **مشاهده تنظیمات**
   - تنظیمات بر اساس گروه دسته‌بندی شده‌اند
   - هر تنظیم شامل توضیحات و مقدار فعلی است

2. **ویرایش تنظیمات**
   - مقادیر را تغییر دهید
   - دکمه "ذخیره تنظیمات" را بزنید
   - تغییرات بلافاصله اعمال می‌شوند

3. **فعال/غیرفعال کردن**
   - از کلید تغییر وضعیت برای هر تنظیم استفاده کنید
   - تنظیمات غیرفعال نادیده گرفته می‌شوند

## پیکربندی

### افزودن تنظیم جدید

برای افزودن تنظیم جدید از طریق سیدر:

```php
SecuritySetting::setValue(
    'group',      // نام گروه
    'key',        // کلید تنظیم
    'value',      // مقدار پیش‌فرض
    'description' // توضیحات
);
```

### تنظیم گزینه‌ها

برای تنظیمات با مقادیر از پیش تعیین شده:

```php
SecuritySetting::create([
    'group' => 'group',
    'key' => 'key',
    'value' => 'default',
    'description' => 'description',
    'options' => json_encode([
        'value1' => 'عنوان ۱',
        'value2' => 'عنوان ۲'
    ])
]);
```

## میان‌افزار امنیتی

میان‌افزار `SecuritySettingsMiddleware` به صورت خودکار تنظیمات را اعمال می‌کند:

1. **محافظت XSS**
   - اعمال سیاست CSP
   - فیلتر محتوای مشکوک

2. **امنیت نشست**
   - کنترل تعداد نشست‌ها
   - بازسازی خودکار شناسه

3. **محافظت از فایل**
   - بررسی نوع فایل
   - کنترل حجم
   - فیلتر پسوندهای خطرناک

4. **محافظت در برابر حملات**
   - محدودیت تلاش‌های ناموفق
   - قفل خودکار
   - پاکسازی تلاش‌ها

### نکات مهم

1. تنظیمات در کش ذخیره می‌شوند
2. تغییرات بلافاصله اعمال می‌شوند
3. برای اعمال تغییرات نیاز به راه‌اندازی مجدد برنامه نیست
4. تنظیمات غیرفعال نادیده گرفته می‌شوند 