-- Alu Dubai Tourism Guide - Database Setup
-- این فایل برای تنظیم اولیه دیتابیس در هاست سی پنل طراحی شده است

-- تنظیم charset و collation
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ایجاد دیتابیس (در صورت عدم وجود)
CREATE DATABASE IF NOT EXISTS `aludubai_main` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE `aludubai_main`;

-- تنظیمات اولیه
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- تنظیمات کاربر
-- لطفاً نام کاربری و رمز عبور دیتابیس را در فایل .env وارد کنید
-- DB_USERNAME=aludubai_admin
-- DB_PASSWORD=رمز_عبور_قوی_شما

-- نکات مهم:
-- 1. این فایل فقط برای تنظیم اولیه است
-- 2. فایل اصلی دیتابیس alu.sql است که باید وارد شود
-- 3. پس از وارد کردن alu.sql، این فایل را می‌توانید حذف کنید

COMMIT;
SET FOREIGN_KEY_CHECKS = 1;
