<?php
/**
 * تنظیمات اصلی سیستم
 */

// تنظیمات پایگاه داده
// حذف define و استفاده از env
// define('DB_HOST', 'localhost');
// define('DB_NAME', 'admin_db');
// define('DB_USER', 'root');
// define('DB_PASS', '');

// تنظیمات مسیرها
// حذف define و استفاده از env
// define('BASE_URL', 'http://localhost/Admin');
// define('ADMIN_URL', BASE_URL . '/admin');
// define('ASSETS_URL', BASE_URL . '/assets');

// تنظیمات زبان
// define('DEFAULT_LANG', 'fa');
// define('RTL', true);

// تنظیمات امنیتی
// define('HASH_SALT', 'your-secret-salt-here');
// define('SESSION_LIFETIME', 7200); // 2 ساعت

// تنظیمات آپلود
// define('UPLOAD_DIR', __DIR__ . '/../uploads');
// define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB
// define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx']);

// تنظیمات ایمیل
// define('SMTP_HOST', 'smtp.gmail.com');
// define('SMTP_PORT', 587);
// define('SMTP_USER', 'your-email@gmail.com');
// define('SMTP_PASS', 'your-app-password');
// define('SMTP_FROM', 'your-email@gmail.com');
// define('SMTP_FROM_NAME', 'Admin Panel');

// تنظیمات API
define('API_KEY', 'your-api-key-here');
define('API_RATE_LIMIT', 100); // درخواست در ساعت

// تنظیمات کش
define('CACHE_ENABLED', true);
define('CACHE_DIR', __DIR__ . '/../cache');
define('CACHE_LIFETIME', 3600); // 1 ساعت

// تنظیمات لاگ
define('LOG_ENABLED', true);
define('LOG_DIR', __DIR__ . '/../logs');
define('LOG_LEVEL', 'error'); // debug, info, warning, error

// تنظیمات توسعه
define('DEBUG_MODE', true);
define('SHOW_ERRORS', true);

// تنظیمات زمان
date_default_timezone_set('Asia/Tehran');
setlocale(LC_ALL, 'fa_IR.UTF-8');

// تنظیمات فونت
define('DEFAULT_FONT', 'IRANSans');
// define('FONT_DIR', ASSETS_URL . '/fonts');

// تنظیمات نمودار
define('CHART_COLORS', [
    'primary' => '#1976d2',
    'success' => '#2e7d32',
    'info' => '#0288d1',
    'warning' => '#ed6c02',
    'danger' => '#d32f2f',
    'dark' => '#212121'
]);

// تنظیمات پیمایش
define('ITEMS_PER_PAGE', 20);
define('PAGINATION_LINKS', 5);

// تنظیمات جستجو
define('SEARCH_MIN_LENGTH', 3);
define('SEARCH_MAX_RESULTS', 50);

// تنظیمات اعلان‌ها
define('NOTIFICATION_LIFETIME', 7); // روز
define('NOTIFICATION_CHECK_INTERVAL', 300); // 5 دقیقه

// تنظیمات پشتیبان‌گیری
define('BACKUP_ENABLED', true);
define('BACKUP_DIR', __DIR__ . '/../backups');
define('BACKUP_INTERVAL', 86400); // 24 ساعت
define('BACKUP_KEEP_DAYS', 7);

// تنظیمات بهینه‌سازی
define('COMPRESS_HTML', true);
define('COMPRESS_CSS', true);
define('COMPRESS_JS', true);
define('MINIFY_CSS', true);
define('MINIFY_JS', true);

// تنظیمات امنیتی اضافی
define('CSRF_PROTECTION', true);
define('XSS_PROTECTION', true);
define('SQL_INJECTION_PROTECTION', true);
define('PASSWORD_MIN_LENGTH', 8);
define('PASSWORD_REQUIRE_SPECIAL', true);
define('PASSWORD_REQUIRE_NUMBER', true);
define('PASSWORD_REQUIRE_UPPERCASE', true);
define('LOGIN_MAX_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 دقیقه

// تنظیمات API های خارجی
define('GOOGLE_MAPS_API_KEY', 'your-google-maps-api-key');
define('RECAPTCHA_SITE_KEY', 'your-recaptcha-site-key');
define('RECAPTCHA_SECRET_KEY', 'your-recaptcha-secret-key');

// تنظیمات سیستم پرداخت
define('PAYMENT_GATEWAY', 'zarinpal'); // zarinpal, nextpay, etc.
define('PAYMENT_MERCHANT_ID', 'your-merchant-id');
// define('PAYMENT_CALLBACK_URL', BASE_URL . '/payment/callback');

// تنظیمات سیستم امتیازدهی
define('RATING_ENABLED', true);
define('RATING_MIN', 1);
define('RATING_MAX', 5);
define('RATING_REQUIRE_COMMENT', false);

// تنظیمات سیستم نظرات
define('COMMENT_ENABLED', true);
define('COMMENT_APPROVAL_REQUIRED', true);
define('COMMENT_MAX_LENGTH', 1000);
define('COMMENT_MIN_LENGTH', 10);

// تنظیمات سیستم خبرنامه
define('NEWSLETTER_ENABLED', true);
define('NEWSLETTER_DAILY_LIMIT', 1000);
define('NEWSLETTER_INTERVAL', 3600); // 1 ساعت

// تنظیمات سیستم گزارش‌گیری
define('REPORT_ENABLED', true);
define('REPORT_TYPES', ['daily', 'weekly', 'monthly', 'yearly']);
define('REPORT_RETENTION_DAYS', 365);

// تنظیمات سیستم آمار
define('STATS_ENABLED', true);
define('STATS_TRACK_VISITORS', true);
define('STATS_TRACK_PAGEVIEWS', true);
define('STATS_TRACK_EVENTS', true);
define('STATS_RETENTION_DAYS', 90);

// تنظیمات سیستم بهینه‌سازی تصاویر
define('IMAGE_OPTIMIZATION_ENABLED', true);
define('IMAGE_QUALITY', 85);
define('IMAGE_MAX_WIDTH', 1920);
define('IMAGE_MAX_HEIGHT', 1080);
define('IMAGE_THUMB_WIDTH', 300);
define('IMAGE_THUMB_HEIGHT', 300);

// تنظیمات سیستم کش مرورگر
define('BROWSER_CACHE_ENABLED', true);
define('BROWSER_CACHE_LIFETIME', 86400); // 24 ساعت

// تنظیمات سیستم فشرده‌سازی
define('GZIP_ENABLED', true);
define('GZIP_LEVEL', 6);

// تنظیمات سیستم امنیتی اضافی
define('SECURITY_HEADERS_ENABLED', true);
define('SECURITY_HEADERS', [
    'X-Frame-Options' => 'SAMEORIGIN',
    'X-XSS-Protection' => '1; mode=block',
    'X-Content-Type-Options' => 'nosniff',
    'Referrer-Policy' => 'strict-origin-when-cross-origin',
    'Content-Security-Policy' => "default-src 'self'",
    'Strict-Transport-Security' => 'max-age=31536000; includeSubDomains'
]); 