<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\Services\SiteSettingService;

class SiteSettingServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(SiteSettingService::class, function ($app) {
            return new SiteSettingService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Register @site_setting blade directive
        Blade::directive('site_setting', function ($expression) {
            return "<?php echo app(App\Services\SiteSettingService::class)->getSetting($expression); ?>";
        });
    }
} 