<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SecuritySetting extends Model
{
    protected $fillable = [
        'group',
        'key',
        'value',
        'description',
        'is_active',
        'options',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'options' => 'array',
    ];

    public static function getValue(string $group, string $key, $default = null)
    {
        $setting = static::where('group', $group)
            ->where('key', $key)
            ->where('is_active', true)
            ->first();

        return $setting ? $setting->value : $default;
    }

    public static function setValue(string $group, string $key, $value, ?string $description = null): void
    {
        static::updateOrCreate(
            ['group' => $group, 'key' => $key],
            [
                'value' => $value,
                'description' => $description,
                'is_active' => true,
            ]
        );
    }

    public static function getGroup(string $group): array
    {
        return static::where('group', $group)
            ->where('is_active', true)
            ->pluck('value', 'key')
            ->toArray();
    }
}
