<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LocationSeo extends Model
{
    use HasFactory;

    protected $table = 'location_seo';

    protected $fillable = [
        'location_id',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'og_title',
        'og_description',
        'og_image',
        'og_type',
        'canonical_url',
        'robots_meta',
        'schema_type',
    ];

    // Relationships
    public function location()
    {
        return $this->belongsTo(Location::class);
    }
}
