<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Session\TokenMismatchException;
use Symfony\Component\HttpFoundation\Response;

class FixCsrfToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Start session if not already started
        if (!$request->hasSession()) {
            $request->setLaravelSession(app('session.store'));
        }

        // Regenerate CSRF token if it doesn't exist
        if (!$request->session()->has('_token')) {
            $request->session()->regenerateToken();
        }

        // Add CSRF token to request if missing
        if ($request->isMethod('POST') && !$request->has('_token')) {
            $request->merge(['_token' => $request->session()->token()]);
        }

        return $next($request);
    }
}
