<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckUserAgent
{
    protected $suspiciousPatterns = [
        '/bot/i',
        '/crawler/i',
        '/spider/i',
        '/curl/i',
        '/wget/i',
        '/python/i',
        '/java/i',
        '/perl/i',
        '/ruby/i',
        '/shell/i',
        '/sql/i',
        '/inject/i',
        '/eval/i',
        '/exec/i',
        '/system/i',
        '/cmd/i',
        '/bash/i',
        '/sh/i',
        '/powershell/i',
        '/msie/i',
        '/trident/i',
        '/edge/i',
        '/chrome/i',
        '/firefox/i',
        '/safari/i',
        '/opera/i',
        '/mozilla/i',
    ];

    public function handle(Request $request, Closure $next): Response
    {
        $userAgent = $request->header('User-Agent');

        if (empty($userAgent)) {
            abort(403, 'دسترسی بدون User-Agent مجاز نیست.');
        }

        if ($this->isSuspiciousUserAgent($userAgent)) {
            abort(403, 'دسترسی با این User-Agent مجاز نیست.');
        }

        return $next($request);
    }

    protected function isSuspiciousUserAgent(?string $userAgent): bool
    {
        if (empty($userAgent)) {
            return true;
        }

        foreach ($this->suspiciousPatterns as $pattern) {
            if (preg_match($pattern, $userAgent)) {
                return true;
            }
        }

        return false;
    }
}
