<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Services\SiteSettingService;

class CheckMaintenanceMode
{
    protected $siteSettingService;

    public function __construct(SiteSettingService $siteSettingService)
    {
        $this->siteSettingService = $siteSettingService;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if ($this->siteSettingService->isMaintenanceMode(app()->getLocale())) {
            if ($request->is('admin/*') && auth()->check() && auth()->user()->isAdmin()) {
                return $next($request);
            }

            return response()->view('errors.maintenance', [
                'message' => $this->siteSettingService->getMaintenanceMessage(app()->getLocale())
            ], 503);
        }

        return $next($request);
    }
} 