<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CleanupExpiredPasswordResetTokens extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'auth:cleanup-password-reset-tokens';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up expired password reset tokens';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting cleanup of expired password reset tokens...');

        // Delete expired tokens
        $deletedCount = DB::table('password_reset_tokens')
            ->where('expires_at', '<', now())
            ->delete();

        // Delete tokens older than 24 hours (even if not expired)
        $oldTokensCount = DB::table('password_reset_tokens')
            ->where('created_at', '<', now()->subDay())
            ->delete();

        $totalDeleted = $deletedCount + $oldTokensCount;

        if ($totalDeleted > 0) {
            $this->info("Cleaned up {$totalDeleted} expired password reset tokens.");
        } else {
            $this->info('No expired tokens found to clean up.');
        }

        // Show statistics
        $remainingTokens = DB::table('password_reset_tokens')->count();
        $this->info("Remaining active tokens: {$remainingTokens}");

        return Command::SUCCESS;
    }
}
